<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.com
 *
 */
class freewheelingeasy_make_amenities
{
    public static function makeAmenity($attributes)          // called from the menu makeAmenity
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        global $numGroups, $numTrails;
        global $NumberCreated, $numRecursion;
        global $href, $ext;
        global $OutfittersTitle;
        global $includeChurches;
        $includeChurches = false;
        try {
            $msg = "";

            $msg .= freeWheeling_edit_setGlobals::setGlobals("makeAmenity");
            $ext = "php";
            $href = "<a target='amen' href='/freewheelingeasy-amenity/?amenity=";
            $NumberCreated = 0;
            $numRecursion = 0;
            $numTrails = 0;
            $numGroups = 0;
            $OutfittersTitle = "Outfitters, Shuttles, Trip Planners";

            if (freeWheeling_edit_setGlobals::notAllowedToEdit("you must be logged in to run this routine "))
                return "$errorBeg E#603 fix routine is not allowed $errorEnd";
            $msg .= rrwUtil::deltaTimer("start of makeAmenity") . $eol;
            $msg .= freewheeling_edit_create_views("makeAmenity");
            $msg .= freewheelingEasy_setIconRange::setIconRange();
            $iconId = freeWheelParam::icon($attributes);
            $route = rrwParam::String("grpId");
            $all = rrwParam::String("all");
            $trailId = freeWheelParam::trail($attributes);
            //        $msg .= rrwUtil::print_r( $_GET, true, "GET" );
            $msg .= "parameters iconId = $iconId, trailId = $trailId, route = $route, all = $all $eol";
            $msg .= self::CreateMissingPages();
            $msg .= self::createAllAmenityPages(true);          // new approach, just do them all < 4 seconds

            /*
            } elseif (!empty($iconId)) {
                $msg .= self::createOneAmenityPageForIconId($iconId); // icon
            } elseif (!empty($route)) {
                $msg .= self::createAmenityPagesAlongRoute($route); // icon
            } elseif (!empty($all)) {
                $msg .= self::createAllAmenityPages();
            } elseif (!empty($trailId)) {       // must be last since may be set in _cookie
                $msg .= self::createAmenityPagesAlongTrail($trailId);
            } elseif (!empty($all)) {
                $msg .= self::createAllAmenityPages();
            } else {
                // find something to run
                $sqlFind = "select distinct iconId
                                from $wpdbExtra->icons
                                    where dateDiff (now(), icDateNear) < 60
                                order by icDateNear; ";
                $msg .= self::createAmenityPagesForSql($sqlFind, true);     // display each of the icons
            } // end if
             */
            $msg .= freewheelFormat::taskCompleted("Amenities Completed");
        } catch (Exception $e3) {
            $msg .= $e3->getMessage() . "$eol E#709 bottom of freewheelingeasy_make_amenities look elsewhere for error $eol";
        }
        return $msg;
    } // end makeAmenity

    public static function CreateMissingPages()
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        try {
            $debugMissing = rrwParam::Boolean("debugMissing");
            $dire = freewheeling_Writeup::fullNameFromShortName("amenities", "");
            if ($debugMissing)
                $msg .= "amenities directory is $dire $eol";
            $direList = array();
            foreach (new directoryIterator($dire) as $fileInfo) {
                if ($fileInfo->isDot()) continue;
                $filename = $fileInfo->getFilename();
                if (false)
                    $msg .= "found $filename in the directory $eol";
                $direList[$filename] = "$filename";
            }
            if ($debugMissing)
                $msg .= "there are " . count($direList)  . " entries in the directory $dire $eol";
            if (false) {
                ksort($direList);
                foreach ($direList as $filename) {
                    $msg .= "$filename $eol";
                }
            } // end if true
            $sqlAmenities = "select distinct iconName, iconId from $wpdbExtra->icons
                                    where onMap like '%amen%'
                                        order by iconName";
            $recAmenities = $wpdbExtra->get_resultsA($sqlAmenities);
            $msg .= "there are " . count($recAmenities) . " amenities in the database $eol";
            $cnt = 0;
            $msg .= "<table> \n";
            foreach ($recAmenities as $rec) {
                $iconId = $rec["iconId"];
                $iconName = $rec["iconName"];
                $tempName = "$iconName-$iconId.html";
                $filenameFull = freewheeling_Writeup::fullNameFromShortName("amenities", $tempName);
                $filenameOut = basename($filenameFull); // output file name has been adjusted by fullNameFromShortName
                if (array_key_exists("$filenameOut", $direList)) {
                    if ($debugMissing)
                        $msg .= rrwFormat::CellRow("found '$filenameOut' in the directory $eol");
                } else {
                    if ($debugMissing)
                        $msg .= rrwFormat::CellRow("did not find '$filenameOut' in the directory $eol");
                    $msg .= self::createOneAmenityPageForIconId($iconId, true);
                    $cnt++;
                    if ($cnt >  500) {
                        throw new Exception($msg . "$errorBeg E#329 too many missing pages $errorEnd");
                    }
                }
            }
        } catch (Exception $e) {
            $msg .= $e->getMessage() . "$errorBeg E#671 bottom of freewheelingeasy_make_amenities look elsewhere for error $eol";
        }
        $msg .= "</table> \n";
        return $msg;
    }
    public static function createAllAmenityPages($displayEach = false)      // called from kmlreset
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";

        try {
            $all = rrwParam::boolean("all");
            $msg .= freeWheelingClean::updateViewTables("createAllAmenityPages uses trailIcons table ");
            // has the nearby been run i the last week, perhaps changing things, if so, update the pages
            // TODO  aloso if the milepoststart or limilposend ranges have changed
            $recentDate = date("Y-m-d", strtotime("-1 week"));
            $sqlFind = "select distinct iconId
                                from $wpdbExtra->icons where ";
            if (! $all)
                $sqlFind .=  " (icDateNear > '$recentDate' || icDateNear = '') and ";
            $sqlFind .= " onMap like '%amen%'
                        order by iconName; ";
            $cnt = $wpdbExtra->get_var($sqlFind);
            $msg .= "found $cnt amenities to be updated " . freeWheelingClean::$okayLabel . $eol;
            $Output = self::createAmenityPagesForSql($sqlFind, $displayEach);
            $msg .= freewheeling_WriteUp::saveFileWithCompare("amenities", "amenitiesUpdateResults.html", $Output);
        } catch (Exception $e) {
            $msg .= $e->getMessage() . "$errorBeg E#501 at bottom of createAllAmenityPages $errorEnd";
        }
        return $msg;
    }
    /*  -------------------------------------------------------------------------------------------------  is_businessToBeIgnored
     *  given a route, create the amenity pages for all the icons along the route
     * based on routes select lines, based on lines select trails, based on trails select icons to  create pages

    private static function createAmenityPagesAlongRoute($route)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_lines;
        $msg = "";
        try {
            $debugRouteAmenity = rrwParam::isDebugMode("debugRouteAmenity");
            $sqlLinesSelect = "select lineSql, grpName, grpId from $wpdbExtra->trail_routes where grpId = '$route'";
            if ($debugRouteAmenity) $msg .= "$sqlLinesSelect $eol";
            $recSelect = $wpdbExtra->get_resultsA($sqlLinesSelect);
            if ($wpdbExtra->num_rows != 1)
                throw new Exception("$msg $errorBeg E#722 $errorEnd did not findthe input group $errorEnd $sqlLinesSelect $eol");
            $linesSelection = $recSelect[0]["linesql"];
            $routeName = $recSelect[0]["grpName"];
            $msg .= "Creating amenity pages for $routeName $eol";
            $sqlTrails = "select distinct trId from $rrw_lines where $linesSelection";
            if ($debugRouteAmenity)  $msg .= "$sqlTrails $eol ";
            $recTrails = $wpdbExtra->get_resultsA($sqlTrails);
            foreach ($recTrails as $recTrail) {
                $trailId = $recTrail["trId"];
                $msg .= self::createAmenityPagesAlongTrail($trailId);
                // Note isTimeUp will be checked in the next loop
            } // end foreach trail
        } catch (Exception $e) {
            $msg .= $e->getMessage();
            throw new Exception($msg);
        } // end createAmenityPagesAlongRoute
        return $msg;
    } // end createAmenityPagesAlongRoute


    private static function createAmenityPagesAlongTrail($trailId)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $debugTrail = rrwParam::isDebugMode("debugTrail", true);
        $msg = "";
        try {
            if ($debugTrail) $msg .= "I#606 createAmenityPagesAlongTrail( $trailId ) $eol";

            $msg .= freewheelingEasy_setIconRange::setIconRange();
            $sqlAmen = "select
                            from $wpdbExtra->icons
                            where trailId = '$trailId'  and onMap like '%amen%'
                            order by milepost asc";
            $msg .= self::createAmenityPagesForSql($sqlAmen);
        } catch (Exception $e) {
            $msg .=  $e->getMessage() . "$errorBeg E#393 at bottom of createAmenityPagesAlongTrail $errorEnd";
        }
        return $msg;
    } // end createAmenityPagesAlongTrail
*/

    private static function createAmenityPagesForSql($sqlFind, $displayEach)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";

        $msg .= "sqlFind = $sqlFind $eol";
        $recFind = $wpdbExtra->get_resultsA($sqlFind);
        if (0 == $wpdbExtra->num_rows) {
            $errmsg = "E#696 no amenities found. sqlFind = &nbsp; $sqlFind $errorEnd";
            return "$msg $errorBeg $errmsg $errorEnd";;
        }
        $msg .= "found " . $wpdbExtra->num_rows . " amenities to update via sql$eol";
        $cnt = 0;
        $msg .= "<table> \n";

        $color = "white";
        foreach ($recFind as $rec) {
            $iconId = $rec["iconId"];
            $msg .= self::createOneAmenityPageForIconId($iconId, $displayEach, $color);
            $cnt++;
        }
        $msg .= "</table> \n";
        $msg .= rrwUtil::deltaTimer("updating the $cnt make amenity ranges took") . $eol;
        //	$NumberCreated icon amenity pages $eol";
        return $msg;
    }

    //-----------------------------------------------------------------------------------------------   createOneAmenityPageForIconId
    private static function createOneAmenityPageForIconId($iconId, $displayEach = false, &$color = "white")
    {
        // given iconID create the amenity page for that icon.
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        global $freewheeling_pages_icon_html_url;
        $msg = "";
        $debugDoIcons = rrwParam::Boolean("debugDoIcons");
        $debugVerbose = rrwParam::Boolean("debugVerbose");
        try {
            $forced = true;
            // return "$msg stopped before anything one icon $eol";

            $numBusinesses = 0;
            $sqlLat = "select distinct iconId, iconName, trName, trailId,
                                    milePostPrefix, milepost, mileDisplayStart, mileDisplayEnd,icDateNear
                from $wpdbExtra->trailIcons
                where iconId = '$iconId'
                order by sort, milepost ";
            if ($debugDoIcons) $msg .= "I#775 createOneAmenityIconName: $sqlLat $eol";
            $recLats = $wpdbExtra->get_resultsA($sqlLat);
            if ($wpdbExtra->num_rows != 1) {
                $errmsg = "$errorBeg E#274 no data found for $iconId $errorEnd $sqlLat $eol";
                $msg .= rrwFormat::backtrace($errmsg);
                throw new Exception($msg);
            }
            $iconName = $recLats[0]["iconName"];
            $milePostPrefix = $recLats[0]["milePostPrefix"];
            $milepost = $recLats[0]["milepost"];
            $mileDisplayBeg = $recLats[0]["mileDisplayStart"];
            $mileDisplayEnd = $recLats[0]["mileDisplayEnd"];
            $trailId = $recLats[0]["trailId"];
            $trailName = $recLats[0]["trName"];
            $icDateNear = $recLats[0]["icDateNear"];
            if ($debugVerbose) $msg .= str_repeat("-", 80) . "working on amenity page for $iconName $eol";

            $tempName = "$iconName-$iconId.html";
            $filenameFull = freewheeling_Writeup::fullNameFromShortName("amenities", $tempName);
            $filenameOut = basename($filenameFull); // output file name has been adjusted by fullNameFromShortName
            $aWeekago = date("Y-m-d", strtotime("-1 week"));
            $debugForce = rrwParam::isDebugMode("debugForce");
            if ($debugForce) $msg .= "I#784 force fom Param = $forced, createOneAmenityIconName: $aWeekago > $icDateNear $eol";
            if ($aWeekago > $icDateNear)
                $forced = true;
            if (!file_exists($filenameFull))
                $forced = true;
            else {
                $last_modified = date("Y-m-d", filemtime($filenameFull));
                if ($aWeekago > $last_modified)
                    $forced = true;
            }
            if ($debugForce) $msg .= "I#785 final force is $forced $eol";
            //    return "$msg stopped before anything one icon $eol";

            if ($forced) {
                $pageTitle = self::formatPageTitleIcon(
                    $iconId,
                    $iconName,
                    $trailId,
                    $trailName,
                    $milePostPrefix,
                    $mileDisplayBeg,
                    $mileDisplayEnd
                );
                if ($debugVerbose) {
                    $msg .= "I#777 createOneAmenityIconName: $pageTitle $eol";
                    $msg .= "self::createAmenityContentBetween_3(    // creates the file and changes iconStyle is necessary
                            $milePostPrefix,
                            $mileDisplayBeg,
                            $mileDisplayEnd,
                            $pageTitle,
                            $filenameOut,
                            $iconId,
                            $numBusinesses
                );";
                };
                //              return "$msg stopped before getting contents $eol";

                $msg .= self::createAmenityContentBetween_3(    // creates the file and changes iconStyle is necessary
                    $milePostPrefix,
                    $mileDisplayBeg,
                    $mileDisplayEnd,
                    $pageTitle,
                    $filenameOut,
                    $iconId,
                    $numBusinesses
                );
            }  // end if forced
            //      return "$msg stopped after making content anything one icon $eol";

            $sqlStyle = "select iconstyle from $wpdbExtra->icons where iconId = '$iconId'";
            $iconStyle = $wpdbExtra->get_var($sqlStyle);
            if ($displayEach) {
                $color = rrwUtil::colorSwap($color);
                $amenityImage = "[ <a href='/write-up/?file=amenities/$filenameOut&amp;notitle=1' target='amenity' >
                    <img src='$freewheeling_pages_icon_html_url/icon-amenities/$iconStyle' /> </a> ] "; // amenity image

                $amenityName = self::formatIconMapAmenityLink($iconId, $iconName);
                $redo = " [ <a href='/make-amenities?trailId=$trailId target='update'>Redo one </a> ]";

                $msg .= rrwFormat::CellRow(
                    $color,
                    $amenityImage,
                    $amenityName,
                    "$milePostPrefix $milepost",
                    "$numBusinesses businesses",
                    $redo,
                    $filenameOut
                );
            } // end if displayEach
        } catch (Exception $e) {
            $msg .= $e->getMessage() . " $errorBeg E#569 at bottom of createOneAmenityForOneIconid $errorEnd";
            throw new Exception($msg);
        }
        return $msg;
    } // end createOneAmenityIcon( $iconName )
    // --------------------------------------------------------------------------------------------------------------  createAmenityContentBetween_3
    private static function createAmenityContentBetween_3(
        $prefix,
        $milepostBeg,
        $milepostEnd,
        $pageTitle,
        $filenameOut,
        $iconId,
        &$numBusinesses,            // used to update the point with the calculated style
        $displayEach = false
    ) {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        global $labelLodge, $labelFood, $labelBike, $labelCamping, $labelOutfitter, $labelChurch;
        global $cntLodge, $cntFood, $cntBike, $cntCamping, $cntOutfitter, $cntChurch;;
        global $meters2Mile;
        $msg = "";
        try {
            $debugServices = rrwParam::Boolean("debugServices");
            $debugDumpRecords = rrwParam::Boolean("debugDumpRecords");
            $debugAmenityBetween = rrwParam::isDebugMode("debugAmenityBetween");
            $debugVerbose = rrwParam::isDebugMode("debugVerbose");
            if ($debugAmenityBetween) $msg .= "createAmenityContentBetween(
            $prefix, $milepostBeg, $milepostEnd,  $filenameOut, $iconId ) $eol";
            $sqlSelect = "";
            $cnt = 0;

            $outLodging = "";
            $outFood = "";
            $outBike = "";
            $outCamp = "";
            $outOutfitters = "";
            $outChurch = "";
            $cntLodge = 0;
            $cntFood = 0;
            $cntCamp = 0;
            $cntOutfitters = "";
            $cntChurch = "";
            $colorFood = rrwUtil::colorSwap();
            $cnt++;

            $sqlWhere = " where trailmilepost >= '$milepostBeg' and trailmilepost <= '$milepostEnd' and  '$prefix' = trailMilepostPrefix  ";
            $sqlSelect = " select distinct 'biz' recType, '$cnt' seq, BizName, bizUsed
                , round(trailmilepost,1) trailmilepost, metersToTrail, trailmilePostPrefix
				, F, FB, FS, FG, FR, KC, KG, L, BS, BR, OC, T, SA , trailLatitude, trailLongitude
				, bizId, BizVerifyDisplay , BizStreet, BizCity
				, BizPhone, BizDirections
				, BizLat, BizLng , BizWWW, bizVerified, BizNote
				, tripAdvisorId, tripAdvisorRating, yelpId, yelpRating, googleMapUrl, googleRating
				, facebookId, facebookRating, place_id
				from $wpdbExtra->businessServices
                left join $wpdbExtra->access on bizId= accBizId and not trailMilepost=99999
                $sqlWhere";
            $union = " union select 'MP', '$cnt' seq,iconName, OnMap, round(milepost,1),
                            -9000, milePostPrefix
    		    from $wpdbExtra->trailIcons
                $sqlWhere ";
            // $sqlSelect .= str_replace("trailmilepost", "milepost", $union);
            $sqlSelect .= " order by seq, round(trailmilepost,1), metersToTrail,
                        BizCity, bizName ";
            if ($debugDumpRecords) $msg .= "createoneTrailHead: foreach services: $eol $sqlSelect $eol ";
            //        return "$msg stopped before doing qury $eol";

            $recs = $wpdbExtra->get_resultsA($sqlSelect);
            if ($debugDumpRecords) $msg .= rrwUtil::print_r($recs, true, " records found ");
            $numBusinesses = $wpdbExtra->num_rows;
            if ($debugVerbose) $msg .= "I#743 there are $numBusinesses business around
            <a href='https://edit.shaw-weil.com/write-up/?file=$filenameOut' target='amenity'> $filenameOut </a> $eol ";
            if ($wpdbExtra->num_rows == 0) {
                //     $msg .= "$errorBeg E#613 no data found $errorEnd $sqlSelect $eol ";
                $pageTitle = str_replace("Services", "No Services", $pageTitle);
                // for loop creates nothing on page
            }
            // return "$msg stopped before looping through the businesses $eol";

            $haveSnacks = false;
            $haveGrocery = false;
            $haveRestaurant = false;
            $haveBar = false;


            $milepostsave = array();
            $milePostSavName = array();
            $milepostDirection = 1; // used to count down vs up  of mileposts
            foreach (array("L", "KC", "T", "F", "OC", "BR", "BS") as $key) {
                $milepostsave[$key] = 999 * $milepostDirection;
                $milePostSavName[$key] = " ";
            }

            $cnt = 0;
            $bizNamePast = "not yet found any";
            foreach ($recs as $rec) {
                $cnt++;
                if ($cnt > 20000)
                    throw new Exception(" $msg $errorBeg E#407 -Too many times for trail head
                   $errorEnd $sqlSelect $eol ");
                $bizName = $rec["BizName"];
                $debugNameSearch = "Kittanningcc";
                if (strpos($bizName, $debugNameSearch) !== false)
                    $debugServices = true;
                else
                    $debugServices = false;
                if ($debugServices) {
                    $msg .= "debug processing of businesses $bizName which contains $debugNameSearch $eol";
                    if ($debugDumpRecords) $msg .= print_r($rec, true) . $eol;
                }
                // ============================================================= reject for various reasons
                $recType = $rec["recType"];
                $bizUsed = $rec["bizUsed"];
                $trailmilepost = $rec["trailmilepost"];
                $trailMilepostPrefix = $rec["trailmilePostPrefix"];
                if (self::is_businessToBeIgnored($bizUsed, $recType))
                    continue;
                if ($bizNamePast == $bizName)
                    continue;
                $bizNamePast = $bizName;
                // ============================================================= Accepted
                $bizId = $rec["bizId"];
                $bizStreet = $rec["BizStreet"];
                if (empty($rec["BizVerifyDisplay"]))
                    $BizVerifyDisplay = "Unverified";
                else
                    $BizVerifyDisplay = $rec["BizVerifyDisplay"];
                $bizCity = $rec["BizCity"];
                $bizPhone = $rec["BizPhone"];
                $BizDirections = $rec["BizDirections"];
                $BizNote = $rec["BizNote"];

                $placeLat = $rec["BizLat"];
                $placeLng = $rec["BizLng"];
                $bizVerified = $rec["bizVerified"];
                $place_id = $rec["place_id"];
                $tripAdvisorId = $rec["tripAdvisorId"];
                $facebookId = $rec["facebookId"];
                $BizWWW = $rec["BizWWW"];
                $googleMapUrl = $rec["googleMapUrl"];
                $metersToTrail = $rec["metersToTrail"];
                $milesToTrail = round($metersToTrail / $meters2Mile, 1);
                $trailLatitude = $rec["trailLatitude"];
                $trailLongitude = $rec["trailLongitude"];
                $trailmilepost = $rec["trailmilepost"];
                $trailMilepostPrefix = $rec["trailmilePostPrefix"];
                if (empty($trailLatitude))
                    $distDisplay = "";
                else
                    $distDisplay = rrwFormat::meters2MilesDirectionLink(
                        $metersToTrail,
                        $trailLatitude,
                        $trailLongitude,
                        $placeLat,
                        $placeLng,
                        "$bizName, $bizCity",
                        $place_id
                    );
                // -------------------------------------------- build special displays
                $bizNameDisplay = "$bizName ($BizVerifyDisplay)";
                if ("biz" == $recType) {
                    $bizlink = freeWheelFormat::BizLink($bizId) . " ($BizVerifyDisplay)";
                    $reviews = self::reviewsFromRec($rec);
                } elseif ("MP" == $recType) {
                    $bizlink = "";
                    $reviews = "";
                } else
                    throw new Exception("$msg $errorBeg E#726 $recType not equal'biz' or 'MP' $errorEnd");


                // key words used by freewheelingeasy_write-up to remove a section of output for nonadmins
                $milepostDisplay = freewheelFormat::Milepost($trailMilepostPrefix, $trailmilepost);

                //  --------------------------------------------- milepost
                //	save the milepost information,so we can print it when listing crosses a milepost
                if ("MP" == $recType) {
                    if (0 == fmod($trailmilepost, 1)) {
                        foreach (array("L", "KC", "T", "F", "OC", "BR", "BS") as $key) {
                            $milepostsave[$key] = $trailmilepost * $milepostDirection;
                            $milePostSavName[$key] = " $trailMilepostPrefix $trailmilepost ";
                        }
                    }
                }
                // ---------------------------------------------- lodging

                if ($rec["L"] == 1) {
                    $cntLodge++;
                    if ($debugServices) $msg .= "cnt L $cntLodge - $bizName, ";
                    if ($milesToTrail <= 10) {
                        if ($debugServices) $msg .= "D#646 " . $milepostsave["L"] . " <= " . ($trailmilepost * $milepostDirection) . $eol;
                        if ($milepostsave["L"] <= ($trailmilepost * $milepostDirection)) {
                            $name = $milePostSavName["L"];
                            if ($debugServices) $msg .= "D#647 call formatCellRowMP(  id='$labelLodge$cntLodge' , $name ) ";
                            $outLodging .= self::formatCellRowMP(" id='$labelLodge$cntLodge' ", $name);
                            $milepostsave["L"] = $milepostDirection * 999;
                            $cntLodge++;
                        }
                        $cntLodge++;
                        $outLodging .= self::formatCellRowAmen(
                            "id='$labelLodge$cntLodge' ",
                            $bizlink,
                            $bizStreet,
                            $bizCity,
                            $bizPhone,
                            $BizDirections,
                            $reviews,
                            $milepostDisplay,
                            $distDisplay
                        );
                        $mpLodge = true;
                    }
                }
                // ---------------------------------------------- camping
                //
                if ($rec["KC"] == 1) {
                    if ($milesToTrail <= 5) {
                        if ($milepostsave["KC"] <= ($trailmilepost * $milepostDirection)) {
                            $name = $milePostSavName["KC"];
                            $outCamp .= self::formatCellRowMP(" id='$labelLodge$cntCamping' ", $name);
                            $milepostsave["KC"] = $milepostDirection * 999;
                            $cntCamping++;
                        }
                        $cntCamping++;
                        $outCamp .= self::formatCellRowAmen(
                            "id='$labelCamping$cntCamping' ",
                            $bizlink,
                            $bizStreet,
                            $bizCity,
                            $bizPhone,
                            $BizDirections,
                            $reviews,
                            $milepostDisplay,
                            $distDisplay
                        );
                    }
                }

                // ---------------------------------------------- outfitter
                if ($rec["T"]) {
                    if ($milesToTrail <= 20) {
                        if ($milepostsave["T"] <= ($trailmilepost * $milepostDirection)) {
                            $name = $milePostSavName["T"];
                            $outOutfitters .= self::formatCellRowMP(" id='$labelLodge$cntOutfitter' ", $name);
                            $milepostsave["T"] = $milepostDirection * 999;
                            $cntOutfitter++;
                        }
                        $cntOutfitter++;
                        $outOutfitters .= self::formatCellRowAmen(
                            "id='$labelOutfitter$cntOutfitter' ",
                            $bizlink,
                            $bizStreet,
                            $bizCity,
                            $bizPhone,
                            $BizDirections,
                            $reviews,
                            $milepostDisplay,
                            $distDisplay
                        );
                    }
                }
                // ---------------------------------------------- food
                if ($rec["F"] == 1) {
                    if ($milesToTrail <= 5) {
                        if ($milepostsave["F"] <= ($trailmilepost * $milepostDirection)) {
                            $name = $milePostSavName["F"];
                            $outFood .= self::formatCellRowMP(" id='$labelLodge$cntFood' ", $name);
                            $milepostsave["F"] = $milepostDirection * 999;
                            $cntFood++;
                        }
                        $cntFood++;
                        $colorFood = rrwUtil::colorSwap($colorFood);
                        $outFood .= self::formatCellRowAmen(
                            "id='$labelFood$cntFood' style='background-color:$colorFood;' ",
                            $bizlink,
                            $bizStreet,
                            $bizCity,
                            $bizPhone,
                            $BizDirections,
                            $reviews,
                            $milepostDisplay,
                            $distDisplay
                        );
                        if ($rec["FS"] == 1)
                            $haveSnacks = "Yes";
                        if ($rec["FG"] == 1) {
                            $haveGrocery = "Yes";
                        }
                        if ($rec["FR"] == 1) {
                            $haveRestaurant = true;
                            $needIconDisplayRestaurant = true;
                        }
                        if ($rec["FB"] == 1) {
                            $haveBar = true;
                        }
                        if ($debugServices) $msg .= "food entry - $bizNameDisplay$eol";
                    }
                }

                // ---------------------------------------------- other
                if ($rec["OC"] == 1) {
                    if ($milesToTrail <= 5) {
                        if ($milepostsave["OC"] <= ($trailmilepost * $milepostDirection)) {
                            $name = $milePostSavName["OC"];
                            $outChurch .= self::formatCellRowMP(" id='$labelLodge$cntChurch' ", $name);
                            $milepostsave["OC"] = $milepostDirection * 999;
                            $cntChurch++;
                        }
                        $cntChurch++;
                        $outChurch .= self::formatCellRowAmen(
                            "id='$labelChurch$cntChurch' ",
                            $bizlink,
                            $bizStreet,
                            $bizCity,
                            $bizPhone,
                            $BizDirections,
                            $reviews,
                            $milepostDisplay,
                            $distDisplay
                        );
                        if ($debugServices) $msg .= "church entry - $bizNameDisplay$eol";
                    }
                }
                // ---------------------------------------------- bike shop
                if ($rec["BR"] == 1) {
                    $rental = "yes";
                } else
                    $rental = "";
                if ($rec["BS"] == 1) {
                    if ($milesToTrail <= 10) {
                        if ($milepostsave["BS"] <= ($trailmilepost * $milepostDirection)) {
                            $name = $milePostSavName["BS"];
                            $outBike .= self::formatCellRowMP(" id='$labelLodge$cntBike' ", $name);
                            $milepostsave["BS"] = $milepostDirection * 999;
                            $cntBike++;
                        }
                        $cntBike++;
                        $outBike .= self::formatCellRowAmen(
                            "id='$labelBike$cntBike'",
                            $bizlink,
                            $bizStreet,
                            $bizCity,
                            $bizPhone,
                            $BizDirections,
                            $reviews,
                            $milepostDisplay,
                            $distDisplay
                        );
                    }
                } // end if ( $rec[ "BS" ] == 1 )

                if ($debugAmenityBetween) $msg .= "$eol processed $cnt records, Lengths: Pagetitle " . strlen($pageTitle) .
                    ", outLodging " . strlen($outLodging) . ",
                        outFood " . strlen($outFood) . $eol;
                if ($debugServices) {
                    $msg .= "display outlodge $eol $outLodging $eol-------- $eol";
                    $msg .= "display outcamping $eol $outCamp $eol-------- $eol";
                } //

            } // end foreach ($recs as $rec) {

            if ($debugVerbose) $msg .= "// -- all data at the icons gathered.$eol";

            $outIconInformation = ""; // the amenity file contents for this trail head
            $outIconInformation .= $pageTitle;
            $outTrailNarrow = "";


            $outIconInformation .= self::combineOuts($pageTitle, $outLodging, $outFood, $outBike, $outCamp, $outOutfitters, $outChurch);
            if ($displayEach || $debugVerbose)
                $msg .= freewheeling_WriteUp::saveFileWithCompare("amenities", $filenameOut,  $outIconInformation);
            else
                $msg .= freewheeling_WriteUp::saveFile("amenities", $filenameOut,  $outIconInformation);

            /*	reset the idon display for this icon */
            if (!empty($iconId)) {
                $sqlIcon = "select iconstyle from $wpdbExtra->icons where iconId = '$iconId'";
                $existingIconstyle = $wpdbExtra->get_var($sqlIcon);
                $iconstyleThisPoint = self::calculateIconStyle(
                    $existingIconstyle,
                    $outLodging,
                    $haveSnacks,
                    $haveGrocery,
                    $haveRestaurant,
                    $haveBar,
                    $outBike,
                    $outCamp,
                    $outOutfitters,
                    $outChurch,
                    $displayEach
                );
                if ($existingIconstyle != $iconstyleThisPoint) {
                    if ($debugVerbose) $msg .= "I#306 iconstyle changed from $existingIconstyle to $iconstyleThisPoint $eol";
                    $sqlIcon = "update $wpdbExtra->icons set iconstyle = '$iconstyleThisPoint' where iconId = '$iconId'";
                    $cnt = $wpdbExtra->query($sqlIcon);
                    if (false === $cnt)
                        $msg .= "$errorBeg E#349 got a false while updating $errorEnd $sqlIcon $eol";
                } // end if iconstyle changed
            } // end if iconId not empty
        } catch (Exception $e) {
            $msg .= $e->getMessage();
        }
        return $msg;
    } //  end createAmenityContentBetween_3

    private static function calculateIconStyle(
        $existingIcon,
        $outLodging,
        $haveSnacks,
        $haveGrocery,
        $haveRestaurant,
        $haveBar,
        $outBike,
        $outCamp,
        $outOutfitters,
        $outChurch,
        $displayEach
    ) {
        //	reset the point display for this given point data
        //  some how we need to est the point style, but not here
        $debugIconBuild = rrwParam::Boolean("debugIconBuild");
        $sizeLimit = 1; // strlen( $outLodging ) + 1;

        $iconDisplay = "";
        // the order of list should match order in
        // http: //127.0.0.1/amenitiesbuild/parkingIconsBuild.php
        if (substr($existingIcon, 0, 4) == "park")
            $iconDisplay = "park";
        if (strlen($outLodging) > $sizeLimit)
            $iconDisplay .= "Lodging";
        if (strlen($outCamp) > $sizeLimit)
            $iconDisplay .= "Camping";
        if ($haveRestaurant || $haveBar)
            $iconDisplay .= "Restaurant";
        if ($haveGrocery || $haveSnacks)
            $iconDisplay .= "Grocery";
        //   if (  $haveSnacks, )   // Snacks display as grocery
        //        $iconDisplay .= "Snack";
        if (strlen($outBike) > $sizeLimit)
            $iconDisplay .= "Bikeshop";
        /*    if ( strlen( $outChurch ) > $sizeLimit ) {
            $iconDisplay .= "Church";
            if ( $debugIconBuild )$msg .= $outChurch;
        }   */ // we no longer deal with churches
        if (empty($iconDisplay))
            $iconDisplay = "park";
        $iconDisplay .= ".png";

        return $iconDisplay;
    }

    private static function combineOuts(
        $docTitle,
        $outLodging,
        $outFood,
        $outBike,
        $outCamp,
        $outOutfitters,
        $outChurch
    ) {
        // merge the various sections of the amenities page into one page
        global $cntLodge, $cntFood, $cntBike, $cntCamping, $cntOutfitter, $cntChurch;;
        global $labelLodge, $labelFood, $labelBike, $labelCamping, $labelOutfitter, $labelChurch;
        global $includeChurches;
        global $OutfittersTitle;
        global $freewheelingeasy_stylesheet;
        $sizeLimit = 1;
        $outIconInformation = "";

        $outIconInformation .= "
    $freewheelingeasy_stylesheet
    <table>\n";
        if (!empty($latlon)) { // fill the array if not yet done
            list($lat, $lon, $pluscode) = explode(",", $latlon);
            $latLink = "<a class='external' href='https://www.google.com/maps/search/" .
                "?api=1&query=$lat,$lon&z=14z' > $lat, $lon</a>";
            $plusLink = "<a class='external' href='https://www.google.com/maps/place/" .
                urlencode($pluscode) . "' >$pluscode</a>";
            $iconDirectiionlink = "Get
			<a class='external' href='https://www.google.com/maps/search/?api=1&query=$lat,$lon&z=14z' >
			directions</a>";
            $outIconInformation .= "<tr > <td colspan=6 >
		<span class='SectionTitle' >Parking Location</span>
		 $latLink, Google Plus Code $plusLink $iconDirectiionlink</td></tr>\n" .
                rrwFormat::CellRow(" &nbsp;");
        }

        if (strlen($outLodging) > $sizeLimit) {
            $cntLodge++;
            $id2 = "$labelLodge$cntLodge";
            $cntLodge++;
            $outIconInformation .= self::freewheeling_mapping_gatherSection(
                $outLodging,
                "Indoor lodging",
                "$labelLodge$cntLodge",
                $id2
            );
        }
        if (strlen($outFood) > $sizeLimit) {
            $cntFood++;
            $id2 = "$labelFood$cntFood";
            $cntFood++;
            $outIconInformation .= self::freewheeling_mapping_gatherSection(
                $outFood,
                "Restaurants/Groceries",
                "$labelFood$cntFood",
                $id2
            );
            $cntFood++;
            $id2 = "$labelFood$cntFood";
            $cntFood++;
        }
        if (strlen($outBike) > $sizeLimit) {
            $cntBike++;
            $id2 = "$labelBike$cntBike";
            $cntBike++;
            $outIconInformation .= self::freewheeling_mapping_gatherSection($outBike, "
        Bike Shops ", "$labelBike$cntBike ", $id2);
        }
        if (strlen($outCamp) > $sizeLimit) {
            $cntCamping++;
            $id2 = "
        $labelCamping$cntCamping ";
            $cntCamping++;
            $outIconInformation .= self::freewheeling_mapping_gatherSection($outCamp, "
        Camping ", "$labelCamping$cntCamping ", $id2);
        }
        if (strlen($outOutfitters) > $sizeLimit) {
            $cntOutfitter++;
            $id2 = "
        $labelOutfitter$cntOutfitter ";
            $cntOutfitter++;
            $outIconInformation .= self::freewheeling_mapping_gatherSection(
                $outOutfitters,
                "
        $OutfittersTitle ",
                "$labelOutfitter$cntOutfitter ",
                $id2
            );
        }
        if (strlen($outChurch) > $sizeLimit && $includeChurches) {
            $cntChurch++;
            $id2 = "
        $labelChurch$cntChurch ";
            $cntChurch++;
            $outIconInformation .= self::freewheeling_mapping_gatherSection($outChurch, "
        Churchs ", "$labelChurch$cntChurch ", $id2);
        }
        $outIconInformation .= "</table>\n";
        $outIconInformation .= self::amenityPageNotes($docTitle);
        return "$outIconInformation <br />\n";
    }

    public static function formatIconMapAmenityLink($iconId, $iconName = "", $target = "edit") // used by amenities
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;

        $msg = "";
        $debugFormat =  false;
        if (empty($iconId) && !empty($iconName))
            $iconId = $wpdbExtra->get_var(
                $wpdbExtra->prepare1arg("select iconId from $wpdbExtra->icons
                                        where iconName = %s", $iconName)
            );
        if (empty($iconName) && !empty($iconId))
            $iconName = $wpdbExtra->get_var("select iconName from $wpdbExtra->icons
                                            where iconId = '$iconId' ");
        if (empty($iconId) || empty($iconName))
            return "icon #$iconId, $iconName not found";
        $amenityFile = freewheeling_WriteUp::fullNameFromShortName("amenities", $iconName);
        if ($debugFormat) $msg .= "I#746 amenityFile $amenityFile, '" . file_exists($amenityFile) . "' $eol";
        if (file_exists($amenityFile))
            $iconName = "<a href='https://freewheelingeasy.com/freewheelingeasy-amenity/?amenity=$iconName' >
                            $iconName</a>\n";
        $theLink = FreewheelFormat::CommonLink($iconId, $iconName, "icon", $target);
        //  $theLink = str_replace("map /a>", "map /a> ] [ ", $theLink,);
        $msg .= "\n$theLink\n";
        return $msg;
    }
    /*
    public static function formatEditLineLink($lineId, $lineName = "", $target = "edit")
    {
        global $freewheelingeasy_pencilIconImage, $freewheeling_pagesPreBuiltUrl;
        global $wpdbExtra, $rrw_lines;
        global $eol, $errorBeg, $errorEnd;

        if (empty($lineName))
            $lineName = $wpdbExtra->get_var("select lineName from $rrw_lines where lineId = '$lineId' ");
        if (empty($lineName))
            $lineName = "name not found";
        return FreewheelFormat::CommonLink($lineId, $lineName, "line", $target);
    }
        */
    public static function formatHistoryLink($value)
    {
        return $value;
    }

    //  build the Amenity Page Title
    private static function formatPageTitleIcon(
        $iconId,
        $iconName,
        $trailId,
        $trailName,
        $milePostPrefix,
        $mileDisplayStart,
        $mileDisplayEnd
    ) {

        $range = "$milePostPrefix $mileDisplayStart to $mileDisplayEnd";
        $makelink = "iconId=$iconId";

        $pageTitleline = "<p class='pageTitle'> Services near";
        if (!empty($iconId)) {
            //   $pageTitleline .= " " . FreewheelFormat::EditIconLink($iconId, $iconName);
        }
        $pageTitleline .= " ($range) on " . FreewheelFormat::TrailLink($trailId, $trailName) .
            //   " " . FreewheelFormat::TrailLink($trailId, $trailName) .
            " " . self::formatPageLineUpdate($makelink, $iconName) .
            " " . self::formatWipeOutLink($milePostPrefix, $mileDisplayStart, $mileDisplayEnd);
        return $pageTitleline;
    }

    private static function formatPageTitleTrail($trailId, $trailName)
    {

        $makelink = "trailId=$trailId";

        $pageTitleline = "<p class='pageTitle'> Services along " .
            " " . FreewheelFormat::TrailLink($trailId, $trailName) .
            " " . self::formatPageLineUpdate($makelink, $trailName);
        return $pageTitleline;
    }
    private static function formatPageTitlePrefix($prefix)
    {
        global $wpdbExtra;
        $sqlGroup =   "select grpid, grpName  from $wpdbExtra->trail_routes where milepostprefix = '$prefix' ";
        $regGroups = $wpdbExtra->get_resultsA($sqlGroup);
        if (1 == $wpdbExtra->num_rows) {
            $grpid = $regGroups[0]["grpid"];
            $titleName = $regGroups[0]["grpName "];
            //      return self::formatPageTitleGroup($grpid, $titleName);
            return "";
        }

        $sqlTrail = "select trid, trname from $wpdbExtra->trails where trMilepostPrefix = '$prefix' ";
        $rectrail = $wpdbExtra->get_resultsA($sqlTrail);
        if (1 == $wpdbExtra->num_rows) {
            $trailId = $rectrail[0]["trid"];
            $trailName = $rectrail[0]["trname"];
            $answer =  self::formatPageTitleTrail($trailId, $trailName);
        } else {
            $answer = "<p class='pageTitle'> Services along $prefix </p>";
        }
        return $answer;
    }

    private static function formatPageLineUpdate($makelink, $itemname)
    {
        return freeWheel::editViewStart . "
            [ <a href='https://edit.shaw-weil.com/make-amenities/?$makelink'
                target='make'>Update $itemname Display</a> ]
            [ <a href='https://edit.shaw-weil.com/update-google?radius=10&$makelink'> 10 mi $$$</a> ]
            [ <a target='route'
                href='https://edit.shaw-weil.com/businessaccess/?$makelink'>Route $$$</a> ]" .
            freeWheel::editViewEnd;
    }

    private static function formatPageTitlegGroup($grpId, $trailName)
    {
        $pageTitleline = "<p class='pageTitle'> Services on" .
            " " . freeWheelFormat::groupIdMapLink($grpId) .
            " " . freeWheelFormat::editGroupLink($grpId);
        return $pageTitleline;
    }

    private static function formatWipeOutLink($trailmilePostPrefix, $mileDisplayStart, $mileDisplayEnd)
    {
        $queryData = array(
            "debug" => "not",
            "task" => "resetprefix",
            "prefix" => $trailmilePostPrefix,
            "minmile" => $mileDisplayStart,
            "maxmile" => $mileDisplayEnd,
        );
        $queryString = http_build_query($queryData);
        return freeWheel::editViewStart .
            " [ <a href='/businessaccess/?$queryString' target='update' >
				            wipe out business distance for '$trailmilePostPrefix'
                            from $mileDisplayStart to $mileDisplayEnd</a> ] " .
            freeWheel::editViewEnd;
    }

    private static function formatBusinessNameSearch($bizname)
    {
        $biznameFix = str_replace("--rrwA--", "&", $bizname);
        $biznameFix = str_replace("--rrwQ--", "'", $biznameFix);
        return $biznameFix;
    }

    private static function formatFilterList()
    {
        global $labelLodge, $labelFood, $labelBike, $labelCamping, $labelOutfitter, $labelChurch;
        global $includeChurches;

        $msg = "";
        $blank = "'about:blank'";
        $msg .= "<strong>Display</strong> &nbsp; &nbsp;
<input type='checkbox' checked id='indoor' onclick='turnit(this, \"$labelLodge\")'>Indoor lodging &nbsp; &nbsp;
<input type='checkbox' checked id='camp' onclick='turnit(this,\"$labelCamping\")'>Campground &nbsp; &nbsp;
<input type='checkbox' checked id='resturant\Grocery' onclick='turnit(this, \"$labelFood\")'>Restuarant &nbsp; &nbsp;
<input type='checkbox' checked id='bike' onclick='turnit(this, \"$labelBike\")'>bike shop &nbsp; &nbsp; ";
        if ($includeChurches) {
            $msg .= "<input type='checkbox' checked id='church' onclick='turnit(this, \"$labelChurch\")'>Church &nbsp; &nbsp; ";
        }
        $msg .= "
<script>
     function turnit( item, label ) {
        var status = item.checked;
        var displayText = 'inherit';
        console.log( 'status ' + status );
        if ( status === false ) {
            displayText = 'none';
        }
        console.log( 'displayText ' + displayText );
        for ( ii = 3000; ii > 0; ii-- ) {
            var idname = label + ii;
            item = document.getElementById( idname );
            if ( item !== null ) {
                console.log( idname );
                console.log( item );
                console.log( item.style );
                console.log( item.style.display );
                item.style.display = displayText;
                console.log( item.style.display );
            }
        }
    }
    if ( false ) {
        var winedit = window.open( $blank, 'edit' );;
        var winurl = window.open( $blank, 'url' );
        var wingoog = window.open( $blank, 'gog' );
        var wintrip = window.open( $blank, 'trip' );;
        var winface = window.open( $blank, 'face' );
        window.focus();
    }

     function openAllWindows( biz, face, trip, url, goog ) {
        winedit.location.assign( biz );
        winface.location.assign( face );
        wintrip.location.assign( trip );
        winurl.location.assign( url );
        wingoog.location.assign( goog );
        winedit.focus();
    }

     function openWidowThis( url, target ) {
        console.log( target );
        if ( typeof winEdit == 'undefined' ) {
            console.log( 'bizwindow not defined' );
            winEdit = window.open( url, target );
        } else {
            winEdit.location.assign( url );
        }
    }

     function hide( id, bizId ) {
        var trDoc = document.getElementById( id ).style.display = 'none';
        var url = 'https://edit.shaw-weil.com/delete-bizId/?bizId=' + bizId;
        var thisWindow = window.parent;
        console.log( thisWindow );
        var myWindow = window.open( url, 'edit' );
        console.log( thisWindow );
        setTimeout(  function () {
            thisWindow.focus();
        }, 5000 );
    }
</script>

<style>
    .indoor {
        color: black;
    }
</style>
";
        return $msg;
    }

    private static function reviewsFromRec($rec, $debugReviews = false)
    {
        global $eol, $errorBeg, $errorEnd;
        $bizName = $rec["BizName"];
        if (strpos($bizName, "xyxy") !== false)
            $debugReviews = true;
        else
            $debugReviews = false;

        $bizWWW = $rec["BizWWW"];
        if (!empty($bizWWW))
            $bizWWW = "<a class='external' target='Displayrating' href='$bizWWW'>web</a>";

        $bizTrip = rrwFormat::ReviewEntry($rec["tripAdvisorId"], $rec["tripAdvisorRating"], "tripadvisor");
        $bizGoogle = rrwFormat::ReviewEntry($rec["googleMapUrl"], $rec["googleRating"], "google");
        $bizFacebook = rrwFormat::ReviewEntry($rec["facebookId"], $rec["facebookRating"], "facebook");
        $bizYelp = rrwFormat::ReviewEntry($rec["yelpId"], $rec["yelpRating"], "yelp");
        $reviews = "";
        foreach (array($bizWWW, $bizGoogle, $bizTrip, $bizFacebook, $bizYelp) as $item) {
            if (empty($item))
                continue;
            if (!empty($reviews))
                $reviews .= ", ";
            $reviews .= $item;
        }
        // $reviews = "$bizWWW $bizTrip $bizYelp $bizGoogle $bizFacebook";
        return $reviews;
    }


    private static function is_businessToBeIgnored($bizUsed, $recType)
    {
        if ($recType == "MP")
            return false;
        if ($bizUsed <= 0)
            return true;
        if ($bizUsed > 1900 && $bizUsed < 2015)
            return true; // i.e closed sometime between 1900 and 2014 return false; }
        return false;
    }


    private static function freewheeling_mapping_gatherSection($content, $sectionTitle, $id1, $id2)
    {
        $msg = "";
        //$msg .= "gatherSection: $sectionTitle " . strlen( $content ) . "$eol";
        if (strlen($content) > 0) {
            $msg .= "<tr id='
                        $id1' ><td class='SectionTitle' colspan=5 >$sectionTitle</td>\n";
            $msg .= "<td><strong>Web Sites/review rateings</strong></td><td><strong>Milepost</strong></td>
					<td><strong>Dist from MP</strong></td></tr>";
            $msg .= "$content<tr><td>&nbsp;</td></tr>\n";
            return $msg;
        }
        return $msg;
    }

    private static function formatCellRowMP($style, $display)
    {
        $placeName = freeWheel::editViewStart
            . "[ <a href='freewheelingeasy-amenity/?amenity=$display' >amenity</a> ]"
            . freeWheel::editViewEnd;

        $out = "<tr $style >\n";
        $out .= "<td >&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
				<td ><strong>$display</strong></td>
				</tr>\n";
        return $out;
    }

    private static function formatCellRowAmen(...$cells)
    {
        global $eol, $errorBeg, $errorEnd;
        global $bizName, $recType;
        /*  cell[0] is the tr identity
     */
        if (strpos($cells[1], "debug") === false)
            $debugRowAmen = false;
        else
            $debugRowAmen = true;

        if ($debugRowAmen) print rrwUtil::print_r($cells, true, "I#721 formatCellRowAmen: as input");
        $out = "";
        $style = array_shift($cells);
        $out .= "<tr $style >\n";
        if ($recType == "MP") {
            return "<tr> <td>&nbsp;</td>
			<td>$errorBeg E#642 processing a mp in formatCellRowAmen $errorEnd</td></tr> ";
        }

        if ($debugRowAmen) print rrwUtil::print_r($cells, true, "I#687 formatCellRowAmen: as looped");
        $cnt = -1;
        // linked name, street, city, phone, directions, reviews, mileposts
        foreach ($cells as $cell) {
            $cnt++;
            $temp = "";
            if ($cnt == 4) // && !empty( $cell ) ) // biz Phone
                $temp = "<td style='width:95px;'>$cell&nbsp;</td>";
            elseif ($cnt == 5) // && !empty( $cell ) ) // biz Directions
                $temp = "<td style='maxwidth: 300px;'>$cell&nbsp;</td>";
            if (empty($temp))
                $out .= "<td >$cell&nbsp;</td>\n";
            else
                $out .= "$temp\n";
            if ($debugRowAmen) print "in loop $cnt - $out $eol ";
        }
        $out .= "</tr>\n";
        return $out;
    }


    private static function amenityPageNotes($doctitle)
    {
        $msg = "
<style>
    .freewheeling-amenities-external {
        background-position: right center;
        background-repeat: no-repeat;
        background-image: linear-gradient(transparent, transparent), url('data:image/svg+xml,%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%3F%3E%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2210%22%20height%3D%2210%22%3E%3Cg%20transform%3D%22translate%28-826.429%20-698.791%29%22%3E%3Crect%20width%3D%225.982%22%20height%3D%225.982%22%20x%3D%22826.929%22%20y%3D%22702.309%22%20fill%3D%22%23fff%22%20stroke%3D%22%2306c%22%2F%3E%3Cg%3E%3Cpath%20d%3D%22M831.194%20698.791h5.234v5.391l-1.571%201.545-1.31-1.31-2.725%202.725-2.689-2.689%202.808-2.808-1.311-1.311z%22%20fill%3D%22%2306f%22%2F%3E%3Cpath%20d%3D%22M835.424%20699.795l.022%204.885-1.817-1.817-2.881%202.881-1.228-1.228%202.881-2.881-1.851-1.851z%22%20fill%3D%22%23fff%22%2F%3E%3C%2Fg%3E%3C%2Fg%3E%3C%2Fsvg%3E');
        padding-right: 13px;
    }
</style>
<div id='freewheeling-amenities-note'>
    <strong>Note 1:</strong> The phrase in parenthises after the place name has the following meaning. The date is the month/year that the phrase was in affect/entered.
    <ul>
        <li> <em> (Google or Unverified)</em> -
            means that the data was extracted from Google maps or some business directory,
            and no secondary source has been accessed to verify
            that the data is accurate. For example: some of the lodging may be apartments.</li>
        <li><em>(Website)</em> - means some non-google website was visited and the place seems to exists.
            Typically this is the owner's own site, or a recent facebook, twitter, or trip advisor update/review.</li>
        <li><em>(Local)</em> - means that a reliable source has informed us the place still exists.</li>
        <li><em>(Visit)</em> - means that someone has been on the premises and actually seen the place.</li>
    </ul>
    <strong>Note 2:</strong> the number following the <em>web link </em> is the review rating
    <br />
    <strong>Note 3:</strong> Because they are so ephemeral and unregulated, lodging like <a class='external' href='https://www.airbnb.com'>Air B & Bs</a> and <a class='external' href='https://www.warmshowers.org/'>Warm Showers</a> are not listed on these pages. <br /><br />"
            . rrwFormat::sellTheBook() . " &nbsp; &nbsp; &nbsp;
    &copy <a href='https://brokenlinks.royweil.com/' class='freewheeling-amenities-external'>Roy Weil Consultng</a>.
</div>
<script type='text/javascript'>
    document.title = '$doctitle';
</script>
    ";
        return $msg;
    }
} // end class freewheelingeasy_make_amenities