<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.com
 */
/*
    outfitters, bike shops, camping are straight forward
        there is a distance from trail limit - different for each type
    food, lodging is grouped by town
        the town table is used to identify towns to display
        half way between towns is the dividing point
*/
class freeWheelingBuildBook
{
    public static function getLengthSurfaceLine($trailId)
    {




        global $wpdbExtra;
        global $meters2Mile;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        try {
            $debugSurface = true;
            $milesRoundTo = 2;
            $sqlTrail = "select (round(sum(lengthMeters)/ $meters2Mile,1) ) miles from $wpdbExtra->lines
						 where " . freeWheelParam::get_WhereTrailId() . " and not lineId =2624 ";
            $totalMiles = $wpdbExtra->get_var($sqlTrail);
            $msg .= "$totalMiles miles Planned $eol;";
            $lengthSurface = $totalMiles . " miles of trail";


            $sqlMileTypes = "select mapStyle, codeDescription, lengthMeters from $wpdbExtra->lines
                            join $wpdbExtra->codes on mapStyle = code
                            where " . freeWheelParam::get_WhereTrailId() . " and not lineId =2624
                            order by sequence ";
            if ($debugSurface) $msg .= "$sqlMileTypes $eol";
            $recMileTypes = $wpdbExtra->get_resultsA($sqlMileTypes);
            $msg .= "<table border=1 >\n";
            $codeDescriptionPast = $recMileTypes[0]["codeDescription"];
            $metersSum = 0;
            $color = rrwFormat::colorSwap();
            foreach ($recMileTypes as $recMileType) {
                if ($codeDescriptionPast != $recMileType["codeDescription"]) {
                    $miles = round($metersSum / $meters2Mile, $milesRoundTo);
                    $msg .= rrwFormat::CellRow($color, $codeDescriptionPast, $miles);
                    $color = rrwFormat::colorSwap($color);
                    $metersSum = 0;
                    $codeDescriptionPast = $recMileType["codeDescription"];
                }
                $metersSum += $recMileType["lengthMeters"];
            }
            $miles = round($metersSum / $meters2Mile, $milesRoundTo);
            $msg .= rrwFormat::CellRow($codeDescriptionPast, $miles);
            //
            $msg .= "</table>$eol";
            $msg .= "lengthSurface - $lengthSurface $eol";
        } catch (Exception $ex) {
            $msg .= $ex->getMessage() . "$errorBeg E#1792 bottom of getLengthSurfaceLine $errorEnd";
            throw new Exception($msg);
        } // end of try catch
        return $msg;
    } // end of getLengthSurfaceLine
} // end of class freeWheelingBuildBook

function freewheeling_mapping_makeHtml($attr)
{
    global $eol, $errorBeg, $errorEnd;
    $msg = "";
    try {
        $msg .= freeWheeling_edit_setGlobals::setGlobals("freewheeling_mapping_make html");
        error_reporting(E_ALL);
        ini_set("display_errors", 1);
        if (freeWheeling_edit_setGlobals::notAllowedToEdit("you must be logged in to run this routine "))
            return "$errorBeg E#1783 fix routine is not allowed $errorEnd";
        $task = rrwParam::String("task");

        // look for group name, trail name, icon name, iconId in the input string

        switch ($task) {
            case "book":
                $msg .= MakeLinkingUp();
                break;
            case "epta";
                $msg .= makeList("K", "Camping", "epta-free");
                break;
            case "gap":
                $msg .= makeBook("GAP MP");
                break;
            case "etp":
                $msg .= makeBook("epta-ken");
                $msg .= makeBook("epta-free");
                break;
            case "toc":
                $msg .= freewheeling_makeTOC::makeTocFiles();
                break;
            case "outfit":
            case "T":
                $msg .= makeList("T", "Outfitters");
                break;
            case "bike":
            case "B":
                $msg .= makeList("B", "BikeShops", "gap");
                $msg .= makeList("B", "BikeShops", "versailles");
                $msg .= makeList("B", "BikeShops", "three rivers southside");
                break;
            case "camp":
            case "camp1":
            case "K":
                $msg .= makeList("K", "Camping");
                break;
            case "food":
            case "gapfood":
            case "F":
                $msg .= makeList("F", "Restaurant and Grocery Stores information");
                break;
            case "L":
            case "lodging":
                $msg .= makeList("L", "Indoor Lodging");
                break;
            default:
                $msg .= "$errorBeg E#1780 trying to make unknown task of '$task' $errorEnd";
                break;
        } // end of switch  on task
    } catch (Exception $ex) {
        $msg .= $ex->getMessage() . "$errorBeg bottom of freewheeling_mapping_makeHtml
               look else where for the error   $errorEnd";
    }
    return $msg;
}
function MakeLinkingUp()
{
    $msg = "";
    $msg .= freewheeling_makeTOC::makeTocFiles();
    $msg .= makeList("T", "outfitters");
    $msg .= makeList("B", "BikeShops", "gap");
    $msg .= makeList("B", "BikeShops", "versailles");
    $msg .= makeList("B", "BikeShops", "three rivers southside");
    $msg .= makeList("K", "Camping");
    $msg .= makeList("L", "Lodging");
    $msg .= makeList("F", "Restaurant and Grocery Stores");
    return $msg;
}
function makeBook($route)
{
    global $eol, $errorBeg, $errorEnd;
    $msg = "";
    $msg .= makeList("T", "outfitters");
    $msg .= makeList("B", "BikeShops", $route);
    $msg .= makeList("K", "Camping", $route);
    $msg .= makeList("L", "Lodging", $route);
    $msg .= makeList("F", "Restaurant and Grocery Stores", $route);
    return $msg;
}

function makeList($SelectedService, $title, $route = "gap")
{
    global $eol, $errorBeg, $errorEnd;
    global $wpdbExtra;
    global $outHTML, $outHTMLfar, $outArray, $outXML, $outHTMLWeb;
    global $meters2Mile;
    $msg = "";
    try {
        $debugMakeList = rrwParam::isDebugMode("debugMakeList", true);
        $debugMakeListDetail = rrwParam::isDebugMode("debugMakeListDetail", true);
        $debugProgress = rrwParam::isDebugMode("debugProgress", true);
        freeWheeling_edit_setGlobals::notAllowedToEdit("update linking up data");
        if ($debugMakeList) $msg .= " makeList( $SelectedService,  $title, $route) $eol";
        if (($iiAnd = strpos($title, " and ")) !== false)
            $baseFileName = strtolower(substr($title, 0, $iiAnd));
        else
            $baseFileName = strtolower($title);
        $outXML = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>';
        $outCnt = 0;
        $colorHTML = rrwUtil::colorSwap();
        $colorFar = rrwUtil::colorSwap();
        $colorNot = rrwUtil::colorSwap();
        $colorWeb = rrwUtil::colorSwap();
        $outHTML = "";
        $outHTMLfar = "";
        $outHTMLWeb = "";
        $outHTMLRest = "";
        $outHTMLRestOneCity = "";
        $outHTMLnot = "";
        $outXML = "";
        if ($debugProgress) $msg .= "I#1790 build a table of bizUsed values to display $eol";
        $sqlUsed = "select code, codeDescription from $wpdbExtra->codes where codetype = 'bizUsed'";
        $recsUsed = $wpdbExtra->get_resultsA($sqlUsed);
        foreach ($recsUsed as $recused) {
            $code = $recused["code"];
            $usedDesc[$code] = $recused["codeDescription"];
        }

        if ($debugMakeList) $msg .= "I#1791 switch on route selection $route $eol";
        //  route selection is driven by milePostPrefix.
        //        Gather up a bunch of MilePostPrefixes and build whereSelectPrefix
        switch ($route) { // select business by the $route
            case "epta-free":
            case "epta-ken":
            case "all2red":
                $restbreakCityPast = "";
                $restbreakmilepostPrefixPast = "";
                $restbreakmilepostPast = 0;

                if ($debugProgress) $msg .= "I#1773 into epta-Free $eol";
                $sqlLines = "select lineSql from $wpdbExtra->trail_routes where grpId = '$route' ";
                $lineSql = $wpdbExtra->get_var($sqlLines);
                // get a list of lines, turn that into trailids.
                $sqlTrailIds = "select distinct trailId from $wpdbExtra->lines where $lineSql ";
                $trailIds = $wpdbExtra->get_resultsA($sqlTrailIds);
                $trailList = "";
                foreach ($trailIds as $trailId) {
                    $trailList .= ", '" . $trailId["trailId"] . "'";
                }
                $trailList = substr($trailList, 2);
                if ($debugProgress) $msg .= "I#1774 list of trail aslong the route = $trailList $eol";
                // got a list fo trailIds, now get the milepostprefixes
                $sqlPrefixes = "select distinct trMilepostPrefix from $wpdbExtra->trails where trId in ($trailList)";
                $msg .= "I#1797 trailList = $trailList $eol sqlPrefixes = $sqlPrefixes $eol";
                $prefixes = $wpdbExtra->get_resultsA($sqlPrefixes);
                $whereSelectPrefix = "";
                foreach ($prefixes as $prefix) {
                    $whereSelectPrefix .= ", '" . $prefix["trMilepostPrefix"] . "'";
                }
                $whereSelectPrefix = substr($whereSelectPrefix, 2);
                $whereSelectPrefix = " trailMilepostPrefix in ($whereSelectPrefix) ";
                if ($debugProgress) $msg .= "I#1798 list of prefixes along the route = $whereSelectPrefix $eol";
                break;
            case "gap":
                $whereSelectPrefix = "  ( trailMilepostPrefix like 'C&O%' or
                          trailMilepostPrefix like '%GAP%' ) ";
                $restbreakCityPast = "Washington";
                $restbreakmilepostPrefixPast = "C&amp;O";
                $restbreakmilepostPast = 0;
                break;
            case "versailles":
            case "three rivers southside":
                $whereSelectPrefix = " trailMilepostPrefix like '%$route%' ";
                break;
            default:
                throw new Exception("$msg $errorBeg E#1795 route of '$route' $errorEnd");
        }
        if ($debugProgress) $msg .= "I#1775 got the selection where clause  $whereSelectPrefix $eol";
        // build the select statement to get the data step 1 is to get all necessary fields
        $sqlWhere2 = str_replace("trail", "town", $whereSelectPrefix);
        $itemsSelected = "select 'Biz' recType, bizUsed, bizId, BizName,
                trailMilepostPrefix, trailmilepost, metersToTrail,
                bizStreet, bizCity,
                BizState, bizPhone, BizWWW, bizEmail, bizDirections, bizVerified,
                tripAdvisorId, tripAdvisorRating, googleMapUrl, googleRating,
                facebookId, facebookRating, yelpId , yelpRating,
                BR BikeRent, KC, KD, KG, KP,
                FG, FS, FB, FR ";
        $fromWhere = " from $wpdbExtra->businessServices
                    left join $wpdbExtra->access on bizId = accBizId
                 where $SelectedService = 1 and $whereSelectPrefix ";
        $sqlListing = " $itemsSelected $fromWhere
            union
            select 'comment', '1', townid, comment,
                    townmilepostPrefix, breakmilepost, townmilepost,
                    commenttype, '',
                    '', '', '', '', '', '',
                    '', '', '', '',
                    '', '', '', '',
                    0 , 0 , 0, 0, 0,
                    '0','0','0','0'
                from $wpdbExtra->towns
                where $sqlWhere2";
        //         comment', '1' /*bizUsed* , townid, townname,
        //         townmilepostPrefix, townmilepost, 0, /* metersToTrail */
        //         /*BikeRent, KC, KD, KG, KP */
        //         /* FG, FS, FB, FR */
        if ("T" == $SelectedService) // outfitters alphbetically
            $sqlListing .= "order by bizname, trailMilepostPrefix asc ";
        else
            $sqlListing .= "order by trailMilepostPrefix asc , round(trailmilepost,1) asc, recType,metersToTrail, bizcity desc";
        if ($debugMakeList) $msg .= "I#1793 $sqlListing -- $sqlListing $eol";
        $sqlOldestScan = " select min(googleScanned) $fromWhere and $whereSelectPrefix ";
        $oldestScan = $wpdbExtra->get_var($sqlOldestScan);
        $UpdateOldLink = "<a href='https://edit.shaw-weil.com/update-google/?task=" .
            "scandate&scandate=$oldestScan' > Update</a>";
        $msg .= "oldest scan date = $oldestScan $UpdateOldLink $eol";
        $recbizs = $wpdbExtra->get_resultsA($sqlListing);
        $numrows = $wpdbExtra->num_rows;
        foreach ($recbizs as $recbiz) {
            if ($recbiz["recType"] == "comment" && !empty($recbiz["bizStreet"]))
                $numrows += 2; //   we add two blank lines around the comment
        } // end of checking fo rcoments
        if ($debugMakeList) $msg .= "I#1794 found $numrows things to list $eol";
        $iiFrom = strpos($itemsSelected, "from");
        $outHTML .= OutputHeaders($SelectedService, $oldestScan);
        $outHTMLfar .= OutputHeaders($SelectedService, $oldestScan);
        $outHTMLnot .= OutputHeaders($SelectedService, $oldestScan);
        $outHTMLWeb .= OutputHeadersWeb($SelectedService, $oldestScan);
        $outHTMLRest .= OutputHeadersWeb($SelectedService, $oldestScan);
        $outXML .= OutputHeaderXML($SelectedService, $numrows, $route, $oldestScan);
        $color = rrwUtil::colorSwap();
        $resturantCity = "no";
        $snacksCity = "no";
        $groceryCity = "no";
        $pastCity = "not yet";
        $restbreakCityPast = "Washington";
        $restbreakCity = "not yet";
        $restBreakTownMilePostPast = -999;
        $restBreakTownMilePost = -999;
        $restbreakmilepost = -999;
        $restbreakmilepostPrefix = "not yet";
        $restbreakComment = "not yet";
        if ($debugProgress) $msg .= "I#1796 There are " . $wpdbExtra->num_rows . " entries for $baseFileName with type of $SelectedService $eol";
        foreach ($recbizs as $recbiz) {
            $outCnt++;
            if ($outCnt > 5000)     // run away check to avoid time out
                throw new Exception("$msg $errorBeg E#1781 to many entries for $baseFileName  $errorEnd");
            $bizId = $recbiz["bizId"];
            $bizName = $recbiz["BizName"];
            $bizStreet = $recbiz["bizStreet"];
            $bizCity = $recbiz["bizCity"];
            $BizState = $recbiz["BizState"];
            $bizPhone = $recbiz["bizPhone"];
            $bizWWW = $recbiz["BizWWW"];
            $bizEmail = $recbiz["bizEmail"];
            $bizDirections = $recbiz["bizDirections"];
            $trailmilepost = round($recbiz["trailmilepost"], 1);
            $trailMilepostPrefix = $recbiz["trailMilepostPrefix"];
            $metersToTrail = $recbiz["metersToTrail"];
            $milesToTrail = round($metersToTrail / $meters2Mile, 1);
            $bizVerified = $recbiz["bizVerified"];
            $BikeRent = $recbiz["BikeRent"];
            $bizUsed = $recbiz["bizUsed"];
            $recType = $recbiz["recType"];
            $snacksBiz = "no";
            $resturantBiz = "no";
            $groceryBiz = "no";
            if ($recbiz["FS"] == 1) { // set values for this facility
                $snacksBiz = "yes";
                $snacksCity = "yes";
            }
            if ($recbiz["FG"] == 1) {
                $groceryBiz = "yes";
                $groceryCity = "yes";
            }
            if ($recbiz["FR"] == 1 || $recbiz["FB"] == 1) {
                $resturantBiz = "yes";
                $resturantCity = "yes";
            }
            if ($bizId == "ChIJK4vGt0i2t4kRERWO_pibRJI")
                print "at load $bizName, $resturantBiz, $groceryBiz, $snacksBiz $eol";
            if (array_key_exists($bizUsed, $usedDesc))
                $displayUsed = $usedDesc[$bizUsed];
            else
                $displayUsed = "unknown";
            $bizIdDisplay = rrwFormat::PencilIcon("edit-biz?bizId=$bizId", $bizVerified);
            //  ------------------------------------------------------------------------------ comments
            if ($debugMakeListDetail) $msg .= "$recType - $trailmilepost - $bizName $eol";
            if ($recType == "comment") {
                if ($debugMakeListDetail) $msg .= "comment type $bizStreet $eol";
                $trailMP = freewheelFormat::Milepost($trailMilepostPrefix, $metersToTrail);
                switch ($bizStreet) { // commenr type
                    case "B": //  bike shop - output the line now
                        break; // forget the comments in the bike table
                        // only washiginton, versles and south side
                        if ($SelectedService != "B")
                            break; // no comments in bikes
                        $outHTML .= "<tr><td>&nbsp;</td></tr>\n";
                        $outHTML .= "<tr><td colspan='12'>$bizName</td></tr>\n";
                        $outHTML .= "<tr><td>&nbsp;</td></tr>\n";
                        $outXML .= writeOneRowXML(array("1", "2", " ", " ", " ", "6"));
                        $outXML .= writeOneRowXML(array("<strong>***</strong>*B", $bizName, " ", "4", " ", "6"));
                        break; // exit swirch and get next record
                    case "H": // lodging
                        if ($SelectedService != "L")
                            break; // not doing lodging, so ignore this entry
                        $iiPipe = strpos($bizName, "|");
                        if ($iiPipe !== false) {
                            $town = substr($bizName, 0, $iiPipe - 1);
                            $comment = substr($bizName, $iiPipe + 1);
                        } else {
                            $town = $bizName;
                            $comment = "";
                            if (empty($town))
                                break;
                        }
                        //          $msg .=  "$bizName using $iiPipe breaks up to $town ||| $comment  $eol";
                        $outHTML .= rrwFormat::CellRow("<h2>$town</h2>", "<h2>$trailMP</h2>", " ", " ");
                        $outHTMLWeb .= rrwFormat::CellRow("<h2>$town</h2>", "<h2>$trailMP</h2>", " ", " ");
                        $outXML .= writeOneRowXML(array($town, "****H", " ", $trailMP));
                        if (!empty($comment)) {
                            $outHTML .= "<tr>" . rrwFormat::Cell(
                                "<h3>$comment</h3>",
                                "colspan=10'"
                            ) . "</tr>\n";
                            $outXML .= writeOneRowXML(array("****J", $comment, " ", " "));
                        }
                        break; // exit swirch and get next record
                    case "F":
                    case "K":
                    case "L":
                        throw new Exception("$msg $errorBeg E#1799 got a comment with
                                selection of $bizStreet, $bizName which has no meaning $errorEnd ");
                    case "R": //  restaurants
                        // This causes the accumulated food status to print on the next change
                        $restbreakmilepostPrefix = $trailMilepostPrefix; // used in the food display
                        $restbreakmilepost = $trailmilepost; // really the breal milepost;
                        $restBreakTownMilePost = $metersToTrail;
                        $restbreakCity = $bizName;
                        $restbreakComment = $bizName;
                        break; // exit switch and get next record
                    default:
                        throw new Exception("$msg $errorBeg E#1784 invalid bizStreet ($bizStreet) in $wpdbExtra->towns $errorEnd");
                } // end switch
                continue;
            } // endrectype = comment
            // set up output coumn data based on fields
            $trailMP = freewheelFormat::Milepost($trailMilepostPrefix, $trailmilepost);
            if (4 == $bizUsed) {
                $trailMP = "pick-up";
            }
            $NameDisplay = rrwFormat::PencilIcon("edit-biz?bizId=$bizId", $bizVerified) .
                freeWheel::editViewStart .
                "<a href='https:/edit-service/?svcid=$bizId' target='service' >
                service</a>" . freeWheel::editViewEnd .
                freeWheelFormat::BizLink($bizId);
            if ($BikeRent)
                $BikeRent = "yes";
            else
                $BikeRent = "";
            $milesTotrail = rrwFormat::DisplayMetersInMiles($metersToTrail);
            if (!empty($bizWWW)) {
                $bizWWW = "<a class='external' href='$bizWWW'> $bizWWW</a>";
                $bizNameLinked = "<a class='external' href='$bizWWW'> $bizName</a>";
            } else {
                $bizNameLinked = $bizName;
            }
            if (!empty($bizEmail))
                $bizEmail = "<a href='mailto:$bizEmail'> $bizEmail</a>";
            $bizIdDisplay = rrwFormat::PencilIcon("edit-biz?bizId=$bizId", $bizVerified);
            $bizPhone = str_replace("(", "", $bizPhone);
            $bizPhone = str_replace(")", "", $bizPhone);
            if ($debugMakeListDetail) $msg .= "selection $SelectedService";
            switch ($SelectedService) {
                case "B": // bikeshops
                    // outhtml      shops forthelinking up book
                    // outhtmmlFar  shops more than 3miles from the trail
                    // outhtmlnot   shops with bisused "notused"
                    // outhtmlWeb   shops on the page of the  web
                    if (shoulWeDisplayOnWeb($bizUsed, $milesToTrail)) {
                        $colorWeb = rrwUtil::colorSwap($colorWeb);
                        $outHTMLWeb .= rrwFormat::CellRow(
                            $colorWeb,
                            "$trailMP<br />$milesTotrail",
                            "$bizName<br />&nbsp; &nbsp;$bizStreet",
                            "$bizCity<br />&nbsp; &nbsp;$bizPhone",
                            $BikeRent,
                            rrwFormat::reviewsFromRec($recbiz)
                        );
                    }
                    if (is_toofar($bizUsed, $milesToTrail, $trailMilepostPrefix, $trailmilepost)) {
                        $colorFar = rrwUtil::colorSwap($colorFar);
                        $outHTMLfar .= rrwFormat::CellRow(
                            $colorFar,
                            $trailMP,
                            $milesTotrail,
                            $NameDisplay,
                            $bizStreet,
                            $bizCity,
                            $bizPhone,
                            $BikeRent
                        );
                    } elseif ($bizUsed > 0) {
                        // display it
                        if (4 == $bizUsed) {
                            $trailMP = "pick-up";
                        }
                        $colorHTML = rrwUtil::colorSwap($colorHTML);
                        $outHTML .= rrwFormat::CellRow(
                            $colorHTML,
                            $trailMP,
                            $milesTotrail,
                            $NameDisplay,
                            $bizStreet,
                            $bizCity,
                            $bizPhone,
                            $BikeRent
                        );
                        $outXML .= writeOneRowXML(array(
                            $trailMP,
                            $bizName,
                            $bizStreet,
                            $bizCity,
                            $bizPhone,
                            $BikeRent
                        ));
                    } else {
                        $colorNot = rrwUtil::colorSwap($colorNot);
                        $outHTMLnot .= rrwFormat::CellRow(
                            $colorNot,
                            $trailMP,
                            $milesTotrail,
                            "$NameDisplay - $displayUsed",
                            $bizStreet,
                            $bizCity,
                            $bizPhone,
                            $BikeRent
                        );
                    }
                    break;
                case "F":
                    $debugFood = false;
                    //  $restbreakmilepostPrefix is set and changed in the comment section
                    if ($restbreakCityPast != $restbreakCity) {
                        if ($debugFood && $outCnt < 100)
                            $msg .= " if ( $restbreakCityPast != $restbreakCity ) $eol";
                        $displayMilepost = freewheelFormat::Milepost(
                            $restbreakmilepostPrefixPast,
                            $restbreakmilepostPast
                        ) .
                            " to " .
                            freewheelFormat::Milepost($restbreakmilepostPrefix, $restbreakmilepost);
                        $DisplayCityMilePost = freewheelFormat::Milepost(
                            $restBreakTownMilePostPast,
                            $restbreakmilepostPrefixPast
                        );
                        $outXML .= writeOneRowXML(array(
                            $displayMilepost,
                            $restbreakCityPast,
                            $resturantCity,
                            $snacksCity,
                            $groceryCity
                        ));
                        // output the yesnoyess on line on the web page and on the screen
                        $linkToCityDetail = "
                            <a href='/food-detail/#$restbreakCityPast' >$restbreakCityPast</a>";
                        $outHTMLWeb .= rrwFormat::CellRow(
                            $color,
                            $displayMilepost,
                            $linkToCityDetail,
                            $resturantCity,
                            $snacksCity,
                            $groceryCity
                        );
                        $outHTML .= rrwFormat::CellRow(
                            $displayMilepost,
                            $restbreakCityPast,
                            $resturantCity,
                            $snacksCity,
                            $groceryCity
                        );
                        // output the city an accumulated detail lines on the "detail page"
                        $cityLinkComesHere = "<a name='$restbreakCityPast' >$restbreakCityPast</a>";
                        $outHTMLRest .= rrwFormat::headerRow(
                            $displayMilepost,
                            "$cityLinkComesHere $DisplayCityMilePost"
                        );
                        $outHTMLRest .= "</a>\n$outHTMLRestOneCity";
                        // reset everything for te next city
                        $outHTMLRestOneCity = "";
                        $resturantCity = "no";
                        $snacksCity = "no";
                        $groceryCity = "no";
                        $restbreakmilepostPrefixPast = $restbreakmilepostPrefix; // used in the food display
                        $restbreakmilepostPast = $restbreakmilepost; //
                        $restbreakCommentPast = $restbreakComment;
                        $restbreakCityPast = $restbreakCity;
                        $restBreakTownMilePostPast = $restBreakTownMilePost;
                    } //  end output city
                    if ($bizUsed < 1) {
                        $colorNot = rrwUtil::colorSwap($colorNot);
                        $outHTMLnot .= rrwFormat::CellRow(
                            $colorNot,
                            $trailMP,
                            "$milesTotrail - $bizUsed",
                            "$NameDisplay -$displayUsed",
                            $bizStreet,
                            $bizCity,
                            $bizPhone,
                            $BikeRent
                        );
                    } elseif (is_toofar($bizUsed, $milesToTrail, $trailMilepostPrefix, $trailmilepost)) {
                        $colorFar = rrwUtil::colorSwap($colorFar);
                        $outHTMLfar .= rrwFormat::CellRow(
                            $colorFar,
                            $trailMP,
                            "$milesTotrail - $bizUsed",
                            $NameDisplay,
                            $bizStreet,
                            $bizCity,
                            $bizPhone
                        );
                    } else {
                        /*                   $outHTMLWeb .= rrwFormat::CellRow( $colorWeb, "$trailMP<br />$milesTotrail",
                                            "$bizName<br />&nbsp; &nbsp;$bizStreet", "$bizCity<br />&nbsp; &nbsp;$bizPhone",
                                                $BikeRent, rrwFormat::reviewsFromRec( $recbiz ) );
                        */
                        $outHTMLRestOneCity .= rrwFormat::CellRow(
                            $colorWeb,
                            "$trailMP<br />$milesTotrail",
                            "$bizName<br />&nbsp; &nbsp;$bizStreet",
                            "$bizCity<br />&nbsp; &nbsp;$bizPhone",
                            $resturantBiz,
                            $groceryBiz,
                            $snacksBiz,
                            rrwFormat::reviewsFromRec($recbiz)
                        );
                    }
                    if ($bizId == "ChIJK4vGt0i2t4kRERWO_pibRJI")
                        print "at prnt $bizName, $resturantBiz, $groceryBiz, $snacksBiz $eol";
                    break; // end food
                case "K":
                    if ($recbiz["KD"] == 1)
                        $type = "Drive-in";
                    elseif ($recbiz["KC"] == 1)
                        $type = "Comm";
                    elseif ($recbiz["KG"] == 1)
                        $type = "Group";
                    elseif ($recbiz["KP"] == 1)
                        $type = "Primitive";
                    else
                        $type = "Unkown";
                    $fixLink = freeWheel::editViewStart .
                        "<a href='https://edit.shaw-weil.com/fix/?bizId=$bizId&milepost='
                            target='fix' > fix milepost</a>" .
                        freeWheel::editViewEnd;
                    if ($debugProgress) $msg .= "$bizUsed, $milesTotrail, $NameDisplay, $type $eol";
                    if (shoulWeDisplayOnWeb($bizUsed, $milesToTrail)) {
                        if ($debugProgress) $msg .= "display it";
                        $colorWeb = rrwUtil::colorSwap($colorWeb);
                        $outHTMLWeb .= rrwFormat::CellRow($colorWeb, $trailMP . $fixLink, $milesTotrail, $NameDisplay, $type, $bizPhone);
                    } else {
                        if ($debugProgress) $msg .= "not displayed";
                    }
                    if (is_toofar($bizUsed, $milesToTrail, $trailMilepostPrefix, $trailmilepost)) {
                        $colorFar = rrwUtil::colorSwap($colorFar);
                        $outHTMLfar .= rrwFormat::CellRow($colorFar, $trailMP . $fixLink, $milesTotrail, $NameDisplay, $type, $bizPhone);
                    } elseif ($bizUsed > 0) {
                        $colorHTML = rrwUtil::colorSwap($colorHTML);
                        $outHTML .= rrwFormat::CellRow($colorHTML, $trailMP . $fixLink, $milesTotrail, $NameDisplay, $type, $bizPhone);
                        $outXML .= writeOneRowXML(array(
                            $trailMP,
                            $milesTotrail,
                            $bizName,
                            $type,
                            $bizPhone
                        ));
                    } else {
                        $colorNot = rrwUtil::colorSwap($colorNot);
                        $outHTMLnot .= rrwFormat::CellRow($colorNot, $trailMP . $fixLink, $milesTotrail, "$NameDisplay - $displayUsed", $type, $bizPhone);
                    }
                    break;
                case "L":
                    // outhtml      shops for the linking up book
                    // outhtmmlFar  shops more than 3miles from the trail
                    // outhtmlnot   shops with bisused "notused"
                    // outhtmlWeb   shops on the page of the  web
                    if (shoulWeDisplayOnWeb($bizUsed, $milesToTrail)) {
                        $colorWeb = rrwUtil::colorSwap($colorWeb);
                        $outHTMLWeb .= rrwFormat::CellRow(
                            $colorWeb,
                            "$trailMP<br />$milesTotrail",
                            "$NameDisplay<br /> $bizStreet",
                            "$bizCity<br />$bizPhone",
                            rrwFormat::reviewsFromRec($recbiz)
                        );
                    }
                    if (is_toofar($bizUsed, $milesToTrail, $trailMilepostPrefix, $trailmilepost)) {
                        $colorFar = rrwUtil::colorSwap($colorFar);
                        $outHTMLfar .= rrwFormat::CellRow(
                            $colorFar,
                            $trailMP,
                            $milesTotrail,
                            $NameDisplay,
                            $bizStreet,
                            $bizCity,
                            $bizPhone
                        );
                    } elseif ($bizUsed > 0) {
                        $colorHTML = rrwUtil::colorSwap($colorHTML);
                        $outHTML .= rrwFormat::CellRow(
                            $colorHTML,
                            $trailMP,
                            $milesTotrail,
                            $NameDisplay,
                            $bizStreet,
                            $bizCity,
                            $bizPhone
                        );
                        $outXML .= writeOneRowXML(array(
                            $trailMP,
                            $bizName,
                            $bizStreet,
                            $bizPhone
                        ));
                    } else {
                        $colorNot = rrwUtil::colorSwap($colorNot);
                        $outHTMLnot .= rrwFormat::CellRow(
                            $colorNot,
                            $trailMP,
                            $milesTotrail,
                            "$NameDisplay - $displayUsed",
                            $bizStreet,
                            $bizCity,
                            $bizPhone,
                            $BikeRent
                        );
                    }
                    break;
                case "T": // outfitters
                    $color = rrwUtil::colorSwap($color);
                    $outHTMLWeb .= "\n
<p style='outfitter'> $bizIdDisplay $bizName,
    $bizCity, $BizState
    $bizPhone $bizWWW $bizEmail";
                    if (!empty($bizDirections))
                        $outHTMLWeb .= "<br/>
    $bizDirections\n";
                    $outHTMLWeb .= "</p>
<p style='outfitter'> </p>
\n";
                    break;
                default:
                    throw new Exception("$msg $errorBeg E #1782 unexpect SelectedService
    of $SelectedService $errorEnd ");
            }
            $pastMilePost = $trailmilepost;
        } // end foreach record
        $outHTML .= outputTrailer($SelectedService);
        $outHTMLfar .= outputTrailer($SelectedService);
        $outHTMLnot .= outputTrailer($SelectedService);
        $outHTMLWeb .= outputTrailer($SelectedService);
        $outHTMLRest .= outputTrailer($SelectedService);
        $outXML .= OutputTrailerXML($SelectedService, $route);
        // save the XML file
        $outFilename = "data/$baseFileName-$route.xml";
        $msg .= "$eol <h2>$title in the book linking up</h2>";
        $msg .= freewheeling_writeup::saveFileWithCompare("data", "$baseFileName-$route.xml", $outXML);
        // save and show web summaary
        $msg .= freewheeling_writeup::saveFileWithCompare("data", "$baseFileName-$route.html", $outHTMLWeb);
        // save and show restaurant detail
        if ("F" == $SelectedService) {
            $msg .= "$eol <h2>$title displayed on the web detail</h2>";
            $msg .= freewheeling_writeup::saveFileWithCompare("/data", "$baseFileName-detail-$route.html", $outHTMLRest);
        }
        // show some the rejecta
        $msg .= "$eol <h2>$title too far</h2>" . $outHTMLfar;
        $msg .= "$eol <h2>$title not Used</h2>" . $outHTMLnot;
    } catch (Exception $ex) {
        $msg .= $ex->getMessage() . "E#1771 at bottom of makeList $eol";
    }
    return $msg;
} // end  function makeList
function shoulWeDisplayOnWeb($bizUsed, $milesToTrail)
{
    if (
        3 == $bizUsed || // 3 -> must use
        4 == $bizUsed || // 4 -> pickup
        (0 < $bizUsed && $milesToTrail <= 10)
    )
        return true;
    else
        return false;
}
function is_toofar($bizUsed, $milesToTrail, $trailMilepostPrefix, $trailmilepost)
{
    switch ($bizUsed) {
        case 1: // open
        case 2: // temp closed
            if (
                $milesToTrail > 3 ||
                // more than 3 miles is too far
                ("C&O" == $trailMilepostPrefix && $trailmilepost < 0.8 && $milesToTrail > 0.39) ||
                ("C&O" == $trailMilepostPrefix && $trailmilepost < 1.0 && $milesToTrail > 1.3) ||
                // reduce the numer of entries near C&) MP 0
                ("C&O" == $trailMilepostPrefix && 60.7 == $trailmilepost && $milesToTrail > 0.5)
                // reduce the numer of entries in Harpers Ferry
            )
                return true;
        case 3: // force used
        case 4: // pickup
            return false;
        default:
            return false; // anything else closed, not relevant, duplicate, etc
    } // end switch
} //end function
/*
function outpuoneLineMaybr( $bizUsed, $milesToTrail, ... $dataLine ) {
    if ( $bizUsed > 0 && $milesToTrail <= 10 ) {
        $colorWeb = rrwUtil::colorSwap( $colorWeb );
        $outHTMLWeb .= rrwFormat::CellRow( $dataLine );
    }
    if ( $milesToTrail > 3 ) {
        $colorFar = rrwUtil::colorSwap( $colorFar );
        $outHTMLfar .= frrwFormat::CellRow( $dataLine );
    } elseif ( $bizUsed > 0 ) {
        $colorHTML = rrwUtil::colorSwap( $colorHTML );
        $outHTML .= rrwFormat::CellRow( $dataLine );
        $outXML .= writeOneRowXML( $dataLine );
    } else {
        $colorNot = rrwUtil::colorSwap( $colorNot );
        $outHTMLnot .= rrwFormat::CellRow( $dataLine );
    }
}
*/
function writeOneRowXML($cells)
{
    $outXML = "";
    $eol = "<br />\n";
    for ($ii = 0; $ii < count($cells); $ii++) {
        $text = $cells[$ii];
        if (0 == $ii)
            $text = str_replace("Three Rivers Southside", "3 Riv S", $text);
        $text = htmlspecialchars($text, ENT_QUOTES);
        $outXML .= '    <cell aid:table="cell" aid:crows="1" aid:ccols="1" >' . $text . '</cell>
    ';
    }
    return $outXML;
}/*
function writeToServer($baseFileName, $outXML, $outHTMLWeb, $route)
{
    $msg = "";
    //       $msg .= "[ ";
    return $msg;
}
*/
function OutputHeaderXML($SelectedService, $numrows, $route)
{
    global $eol, $errorBeg, $errorEnd;
    $outXML = " ";
    switch ($SelectedService) {
        case "T": // outfitters
            // no xml file created
            break;
        case "B": // bikeshops
            $campWidth = array(40, 140, 120, 50, 60, 10);
            $outXML .= "
            <bikeshops-" . str_replace(" ", "-", $route) . ">";
            $outXML .= '
    <table xmlns:aid="http://ns.adobe.com/AdobeInDesign/4.0/" aid:table="table" aid:trows="' . $numrows . '" aid:tcols="6">
        <cell aid:table="cell" aid:crows="1" aid:ccols="1" aid:ccolwidth="' . $campWidth[0] . '">Trail MP</cell>
        <cell aid:table="cell" aid:crows="1" aid:ccols="1" aid:ccolwidth="' . $campWidth[1] . '">Name</cell>
        <cell aid:table="cell" aid:crows="1" aid:ccols="1" aid:ccolwidth="' . $campWidth[2] . '">Address</cell>
        <cell aid:table="cell" aid:crows="1" aid:ccols="1" aid:ccolwidth="' . $campWidth[3] . '">City</cell>
        <cell aid:table="cell" aid:crows="1" aid:ccols="1" aid:ccolwidth="' . $campWidth[4] . '">Phone</cell>
        <cell aid:table="cell" aid:crows="1" aid:ccols="1" aid:ccolwidth="' . $campWidth[5] . '">Rent</cell>
        ';
            break;
        case "K":
            $campWidth = array(58.5, 176, 53.3, 67.2, 24);
            $outXML .= "
    <campsites-" . str_replace(" ", "-", $route) . ">";
            $outXML .= '
        <table xmlns:aid="http://ns.adobe.com/AdobeInDesign/4.0/" aid:table="table" aid:trows="' . $numrows . '" aid:tcols="5">
            <cell aid:table="cell" aid:crows="1" aid:ccols="1" aid:ccolwidth="' . $campWidth[0] . '">Trail MP</cell>
            <cell aid:table="cell" aid:crows="1" aid:ccols="1" aid:ccolwidth="' . $campWidth[1] . '">Distance</cell>
            <cell aid:table="cell" aid:crows="1" aid:ccols="1" aid:ccolwidth="' . $campWidth[2] . '">Name</cell>
            <cell aid:table="cell" aid:crows="1" aid:ccols="1" aid:ccolwidth="' . $campWidth[3] . '">Type</cell>
            <cell aid:table="cell" aid:crows="1" aid:ccols="1" aid:ccolwidth="' . $campWidth[4] . '">Phone</cell>
            ' . "\n";
            break;
        case "F":
            $campWidth = array(58.5, 176, 40, 40, 40);
            $outXML .= "
    <food-" . str_replace(" ", "-", $route) . ">";
            $outXML .= '
            <table xmlns:aid="http://ns.adobe.com/AdobeInDesign/4.0/" aid:table="table" aid:trows="' . $numrows . '" aid:tcols="5">
                <cell aid:table="cell" aid:crows="1" aid:ccols="1" aid:ccolwidth="' . $campWidth[0] . '">trail MP</cell>
                <cell aid:table="cell" aid:crows="1" aid:ccols="1" aid:ccolwidth="' . $campWidth[1] . '">Town</cell>
                <cell aid:table="cell" aid:crows="1" aid:ccols="1" aid:ccolwidth="' . $campWidth[2] . '">Resturant</cell>
                <cell aid:table="cell" aid:crows="1" aid:ccols="1" aid:ccolwidth="' . $campWidth[3] . '">Grocery</cell>
                <cell aid:table="cell" aid:crows="1" aid:ccols="1" aid:ccolwidth="' . $campWidth[4] . '">Snacks</cell>
                ' . "\n";
            break;
        case "L":
            $campWidth = array(58.5, 176, 40, 40);
            $outXML .= "
    <lodging-" . str_replace(" ", "-", $route) . ">";
            $outXML .= '
            <table xmlns:aid="http://ns.adobe.com/AdobeInDesign/4.0/" aid:table="table" aid:trows="' . $numrows . '" aid:tcols="4">
                <cell aid:table="cell" aid:crows="1" aid:ccols="1" aid:ccolwidth="' . $campWidth[0] . '">trail MP</cell>
                <cell aid:table="cell" aid:crows="1" aid:ccols="1" aid:ccolwidth="' . $campWidth[1] . '">Hotel/Motel/B &amp; B</cell>
                <cell aid:table="cell" aid:crows="1" aid:ccols="1" aid:ccolwidth="' . $campWidth[2] . '">Address</cell>
                <cell aid:table="cell" aid:crows="1" aid:ccols="1" aid:ccolwidth="' . $campWidth[3] . '">Phone</cell>

                ';
            break;
        default:
            throw new Exception("$errorBeg E#1772 unexpect SelectedService of $SelectedService $errorEnd");
    }
    return $outXML;
}
function OutputTrailerXML($SelectedService, $route)
{
    global $eol, $errorBeg, $errorEnd;
    $outXML = " ";
    $route = str_replace(" ", "-", $route);
    switch ($SelectedService) {
        case "B": // bikeshops
            $xmltag = "bikeshops";
            break;
        case "F":
            $xmltag = "food";
            break;
        case "K":
            $xmltag = "campsites";
            break;
        case "L":
            $xmltag = "lodging";
            break;
        case "T": // outfitters
            return "";
        default:
            throw new Exception("$errorBeg E#1776 unexpect SelectedService of
            OutputTrailerXML( $SelectedService, $route ) $errorEnd");
    }
    $outXML .= "
    </table>
    </$xmltag-$route>";
    return $outXML;
}
function OutputHeaders($SelectedService)
{
    global $eol, $errorBeg, $errorEnd;
    $ourHead = "<table>\n ";
    switch ($SelectedService) {
        case "T": // outfitters
            // no header. Head Information on page
            break;
        case "B": // bikeshops
            $ourHead .= rrwFormat::HeaderRow(
                "trail MP",
                "miles to",
                "Busines Name",
                "Address",
                "City",
                "Phone",
                "Rent"
            );
            break;
        case "K":
            $ourHead .= rrwFormat::HeaderRow("trail MP", "Distance", "Name", "Type", "Phone");
            break;
        case "F":
            $ourHead .= rrwFormat::HeaderRow("trail MP", "distance", "Name", "address", "town", "phone");
            break;
        case "L":
            $ourHead .= rrwFormat::HeaderRow("trail MP", "Business Name", "Address", "Phone");
            break;
        default:
            throw new Exception("$errorBeg E#1777 unexpect SelectedService of $SelectedService $errorEnd");
    }
    return $ourHead;
}
function OutputHeadersWeb($SelectedService)
{
    global $eol, $errorBeg, $errorEnd;
    $ourHead = "<table>\n ";
    switch ($SelectedService) {
        case "T": // outfitters
            $ourHead .= " "; // no header. Head Information on page
            break;
        case "B": // bikeshops
            $ourHead .= rrwFormat::HeaderRow(
                "trail MP<br />miles to",
                "Busines Name<br />Address",
                "City<br />Phone",
                "Rent",
                "Web Links"
            );
            break;
        case "K":
            $ourHead .= rrwFormat::HeaderRow("trail MP", "Distance", "Name", "Type", "Phone");
            break;
        case "F":
            $ourHead .= rrwFormat::HeaderRow("trail MP", "town", "City", "Resturant", "Grocery", "Snacks", "Websites");
            break;
        case "L":
            $ourHead .= rrwFormat::HeaderRow("trail MP", "Business Name", "Address/Phone", "Websites");
            break;
        default:
            throw new Exception("$errorBeg E#1778 unexpect SelectedService of $SelectedService $errorEnd");
    }
    return $ourHead;
}
function outputTrailer($SelectedService)
{
    global $eol, $errorBeg, $errorEnd;
    $ourHead = "";
    switch ($SelectedService) {
        case "T": // outfitters
            $ourHead .= ""; // no header. Head Information on page
            break;
        case "B": // bikeshops
        case "K": // camping
        case "F": // food
        case "L": // Lodging
            $ourHead .= "\n
    </table>
    \n ";
            break;
            break;
        default:
            throw new Exception("$errorBeg E #1779 unexpect SelectedService
                                of outputTrailer($SelectedService $errorEnd ) ");
    }
    return $ourHead;
}
function orderby($SelectedService)
{
    global $eol, $errorBeg, $errorEnd;
    // TODO:  in genral this might be the sequence number. nrrf to think about that
    $sequence = " order by ";
    switch ($SelectedService) {
        case "T": // outfitters
            $sequence .= " bizName, bizCity ";
            break;
        case "B": // bikeshops
        case "K":
        case "F":
        case "L":
            //          $sequence .= " trailMilepostPrefix asc, trailmilepost asc, bizname ";
            $sequence .= " sort ";
            break;
        default:
            throw new Exception("$errorBeg E #1770 unexpect SelectedService  of $SelectedService $errorEnd ");
    }
    return $sequence;
}
