<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.com
 *
 *      makeStairStepChart  builds the stair stepper chart of mileages between trailHeads
 *      MakeChart4          create a file with a list of trail heads and mileposts
 *      outputMileByTypeFiles2      Create four files with information about the type of lines and there mileages
 */
class FreewheelingBuildMileageChart
{
    public static function buildManyCharts()
    {
        global $wpdbExtra;
        global $eol;
        $msg = "";
        try {
            $all = rrwParam::Boolean("all");
            rrwUtil::deltaTimer();
            $msg .= freeWheeling_edit_setGlobals::setGlobals("buildManyCharts");
            $date60daysAgo = new datetime();
            $date60daysAgo->sub(new DateInterval('P60D'));
            $dateLimit = $date60daysAgo->format('Y-m-d');
            if ($all)
                $dateLimit = "2099-01-01";
            $msg .= "<h1>Make charts</h1>";
            $sqlTrails = "select distinct trId from $wpdbExtra->trails where trDateCharted < '$dateLimit'
                            union
                      select grpid from $wpdbExtra->trail_routes where grp_routed < '$dateLimit'
                      order by trId";
            $recTrails = $wpdbExtra->get_resultsA($sqlTrails);
            $msg .= "I#245 There are " . count($recTrails) . " trails to be charted $eol";
            foreach ($recTrails as $recTrail) {
                $trailId = $recTrail["trId"];
                $msg .= self::outputMileByTypeFiles2($trailId, "");         // no title
            }
            $sqlTrails = "select grpId from $wpdbExtra->trail_routes
                            where is_continuous =1 and grp_routed < '$dateLimit'
                            order by grpName";
            $recTrails = $wpdbExtra->get_resultsA($sqlTrails);
            $msg .= "I#246 There are " . count($recTrails) . " groups to be charted $eol";
            foreach ($recTrails as $recTrail) {
                $trailId = $recTrail["grpId"];
                $msg .= self::makeStairStepChart($trailId, false);          // no display of chart
            }
            // build a group of charts the make selections
            $msg .= freewheeling_makeTOC::createLineDetailSelectionTable();      // list all the trails with links to charts
            $msg .= self::BuildTheIconSelectionPage("epta-free");                        // list all the continuous trails
        } catch (Exception $ex) {
            $msg .= "Error in buildManyCharts: " . $ex->getMessage();
        }
        $msg .= rrwUtil::deltaTimer("buildManyCharts");
        $msg .= "the build chart task is Completed $eol";
        $msg .= freewheelFormat::taskCompleted("Charts");
        return $msg;
    }
    /**
     * Generates a chart selection based on the provided attributes.
     *
     * This method handles the logic for responding to the users click ofhemaking a chart selection, updating icon selections,
     * and displaying continuous trails or icon selections based on the provided attributes.
     *
     * @param array $attributes An associative array of attributes used for making the chart selection.
     *
     * @return string A message indicating the result of the chart selection process.
     *
     * @throws Exception If an error occurs during the chart selection process.
     */
    public static function makeChartSelection($attributes)
    {
        global $eol;
        $msg = "";
        try {
            $msg .= freeWheeling_edit_setGlobals::setGlobals("make chart selection");
            $trailId = freeWheelParam::trail($attributes);
            $updateParam = rrwParam::String("update", $attributes);
            // $msg .= "update is '$updateParam', post is  '" .  $_POST["update"] . "'$eol";
            if (! empty($updateParam)) {
                // user clicked the save button on the form
                $msg .= self::UpdateIconSelection($attributes);
                return $msg;
            }
        } catch (Exception $ex) {
            $msg .= $ex->getMessage();
        }
        return $msg;
    }
    private static function  UpdateIconSelection($attributes)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $debugSetting = rrwParam::isDebugMode("debugSettings", false);
        // $msg .= rrwutil::print_r($_POST, true, "post array");
        $updateParam = rrwParam::String("update", $attributes);
        if (empty($updateParam)) {
            $msg .= "$errorBeg E#543 no update parameter found, You should not be here $errorEnd $eol";
            return $msg;
        }
        $msg .= "<a href='https://pgherie.com/pittsburgh-erie-milage-chart' > See the updated chart</a>$eol";
        foreach (array("amen", "step") as $field) {
            for ($ii = 1; $ii < 200; $ii++) {
                $checkKey = "iconId$ii";
                if ($debugSetting) $msg .= "ii = $ii $checkKey $eol";
                if (key_exists($checkKey, $_POST)) {
                    $iconId = $_POST[$checkKey];
                    $oldValueKey = $field . "Old$ii";
                    $oldValue = $_POST[$oldValueKey];
                    $newValueKey = $field . "NewValue$ii";
                    if (key_exists($newValueKey, $_POST))
                        $newValue = 1;      // if there is a value,  then it is checked
                    else
                        $newValue = 0;
                    if ($debugSetting) $msg .= "iconId = $iconId, keynew = $newValueKey, new value= $newValue - key = $oldValueKey, oldValue = $oldValue $eol";
                    if ($newValue != $oldValue) {
                        if ($field == "head")
                            $tableField = "isTrailHead";
                        elseif ($field == "amen")
                            $tableField = "isAmenityList";
                        elseif ($field == "step")
                            $tableField = "isMileageStep";
                        else
                            throw new Exception("E#755 unknown field $field");
                        $sqlUpdate = "update $wpdbExtra->icons set $tableField = $newValue where iconId = $iconId;";
                        $msg .= $_POST["iconName$ii"] . " =================== &nbsp; $sqlUpdate $eol";
                        $msg .= $wpdbExtra->query($sqlUpdate); // update the database
                    }
                } // end if (key_exists($key, $_POST))
            } // end for ($ii = 1; $ii < 500; $ii++)
        } // end foreach (array("head", "amen", "step") as $field)
        $trailId = $_POST["trailId"];
        $msg .= "rebuild " . $trailId . "-stepChart.html $eol";
        $msgTemp = self::makeStairStepChart($trailId, false);       // data changed, so rebuild the milage step chart
        $msgTemp .= self::BuildTheIconSelectionPage($trailId);      // rebuild the icon selection page with the users changes
        // $msg .= $msgTemp;
        return $msg;
    } // end function UpdateIconSelection
    private static function BuildTheIconSelectionPage($trailId)
    {
        global $wpdbExtra;
        global $eol;
        $msg = "";
        ini_set("display_errors", 1);
        error_reporting(-1);
        $debugChartSel = rrwParam::isDebugMode("debugChartSel", false);
        if ($debugChartSel) $msg .= "called DisplayIconSelection($trailId)";
        $msg .= "<h3>Indicate which towns you want to appear on the chart</h3>";
        $sqlWhere = freewheeling_kml_common::sqlWhereForGroupOrTrailIcons($trailId);
        $sqlWhere = str_replace(" trailId", " icon.trailId", $sqlWhere);
        $sqlTowns = "select distinct iconName, iconId, milePostPrefix, milepost, sort,
                            isTrailHead, isAmenityList, isMileageStep, latitude, longitude
                from $wpdbExtra->icons  icon
                    join $wpdbExtra->lines line on icon.trailId = line.trailId
                    where $sqlWhere  and sort != 0
                        and onMap not like '%offline%' and onMap != '" . freeWheel::estimated_milepost . "'
                    order by sort, milepost ";
        if ($debugChartSel) $msg .= "$sqlTowns $eol";
        $recTowns = $wpdbExtra->get_resultsA($sqlTowns);
        $msg .= "\n<form method='POST' action='https://edit.shaw-weil.com/adjust-the-milage-chart/?trailId=$trailId&nohead' >
        <table>\n";
        $msg .= "
                <input type='hidden' name='trailId' id='trailId' value='$trailId' >";
        $msg .= rrwFormat::HeaderRow("Town", "show Amenity List", "show Mileage Step", " ", " ");
        $cnt = 0;
        $color = 'white';
        $cnt = 0;
        foreach ($recTowns as $recTown) {
            $cnt++;
            $color = rrwFormat::colorSwap($color);
            $iconName = $recTown["iconName"];
            $milepost = $recTown["milepost"];
            $isTrailHead = $recTown["isTrailHead"];
            $isAmenityList = $recTown["isAmenityList"];
            $isMileageStep = $recTown["isMileageStep"];
            $sort = $recTown["sort"];
            if (1 == $isTrailHead)
                $box1Checked = " checked='checked' ";
            else
                $box1Checked = "";
            if (1 == $isAmenityList)
                $box2Checked = " checked='checked' ";
            else
                $box2Checked = "";
            if (1 == $isMileageStep)
                $box3Checked = " checked='checked' ";
            else
                $box3Checked = "";
            $hidden = "
                <input type='hidden' name='iconName$cnt' value='" . $recTown["iconName"] . "' />
                <input type='hidden' name='iconId$cnt' value='" . $recTown["iconId"] . "' />
                <input type='hidden' name='headOld$cnt' value='$isTrailHead' />
                <input type='hidden' name='amenOld$cnt' value='$isAmenityList" . "' />
                <input type='hidden' name='stepOld$cnt' value='$isMileageStep" . "' />";
            $box1 = "<input type='checkbox' name='headNewValue$cnt' $box1Checked  >";
            $box2 = "<input type='checkbox' name='amenNewValue$cnt' $box2Checked  >";
            $box3 = "<input type='checkbox' name='stepNewValue$cnt' $box3Checked  >";
            $msg .= rrwFormat::CellRow($color, "$iconName MP $milepost $hidden", $box2,  $box3, $sort, " &nbsp;", " &nbsp;", " &nbsp;", " &nbsp;");
        } // end foreach ($recTowns as $recTown)
        $sqlTownsMissing = "select distinct iconName, milepost, sort
                from $wpdbExtra->icons  icon
                    join $wpdbExtra->lines line on icon.trailId = line.trailId
                    where $sqlWhere  and onMap not like '%offline%' and onMap != '" . freeWheel::estimated_milepost . "'
                    and sort = 0 order by sort, milepost ";
        if ($debugChartSel) $msg .= "<tr><td cols=10>$sqlTownsMissing</td></tr>\n";
        $recTownsMissing = $wpdbExtra->get_resultsA($sqlTownsMissing);
        foreach ($recTownsMissing as $recTownMissing) {
            $iconName = $recTownMissing["iconName"];
            $milepost = $recTownMissing["milepost"];
            $msg .= rrwFormat::CellRow("$iconName MP $milepost", " &nbsp;", "&nbsp; ", " ", " &nbsp;");
        }
        $msg .= "</table><input type='submit' name='update' id='update'  value='update' ></form";
        $msg .= freewheeling_Writeup::saveFile("mileage-chart", "$trailId" . "-selection.html", $msg);
        return $msg;
    }
    private static function DisplayContinuosTrails()
    {
        global $wpdbExtra;
        $msg = "";
        $msg .= "<p>Choose which trail you want to make a chart for</p>";
        $sqlContinuous = "select grpId, grpName from $wpdbExtra->trail_routes where is_continuous = 1 order by grpName";
        $recsContinuous = $wpdbExtra->get_resultsA($sqlContinuous);
        $msg .= "<ul>\n";
        foreach ($recsContinuous as $recContinuous) {
            $grpId = $recContinuous["grpId"];
            $grpName = $recContinuous["grpName"];
            $msg .= "<li><a href='/make-a-chart/?trailId=$grpId'>$grpName</a></li>";
        }
        $msg .= "</ul>";
        return $msg;
    }
    /**
     *
     *
     * Outputs mileage by type files based on the provided SQL WHERE clause.
     *
     * @param string $sqlWhereLines The SQL WHERE clause to filter the lines.
     * @param string $title title is only used if it is a group with multiple trails
     * @return string The generated message or error.
     */
    public static function outputMileByTypeFiles2($trailOrGroupId, $title = "")
    {
        // working on
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        global $meters2Mile;
        $msg = "";
        //   return  "$msg $eol temp check hanging ------------outputMileByTypeFiles2-------------$eol";
        $sqlWhereLines = freewheeling_kml_common::sqlWhereForGroupOrTrailLines($trailOrGroupId);
        if (false !== strpos($trailOrGroupId, "debugEnabler"))   // for testing
            $debugMileage = true;
        else
            $debugMileage = false;
        $page = "";         // the output page which only has a total line
        $pageDetail = "";   // the output page which has the detail lines
        $Totals4Trail = array();
        $totals4Route = array();
        $totals4epta = array();
        // build the header line
        $sqlHeads = "SELECT distinct classification FROM $wpdbExtra->codesSurface ORDER BY Sort ASC;";
        $recHeads = $wpdbExtra->get_resultsA($sqlHeads);
        if (!empty($title))
            $msg .= "<h2>$title</h2>";  // title is only output if it is a group with multiple trails
        $headerLine = "<table>\n<tr>";
        $headerLine .= rrwFormat::CellHeader("Line Name ");
        $headerLine .= rrwFormat::CellHeader("surface");
        $headerLine .= rrwFormat::CellHeader("routes");
        $headerLine .= rrwFormat::CellHeader("total miles");
        foreach (array_keys($recHeads) as $recHead) {
            $mapStyleTem = $recHeads[$recHead]["classification"];
            $headerLine .= rrwFormat::CellHeader($mapStyleTem);
            $Totals4Trail[$mapStyleTem] = 0;
            $totals4Route[$mapStyleTem] = 0;
            $totals4epta[$mapStyleTem] = 0;
        }
        $headerLine .= rrwFormat::CellHeader(" ");  // for the edit link
        $headerLine .= "</tr>";
        $sqlLines = "select SQL_NO_CACHE trName, trailId, routes, lengthMeters/$meters2Mile as miles, landingPage, lineName, lineId,
                 googleType, mapStyle, codeDescription, routes
				from $wpdbExtra->lines line
                left join $wpdbExtra->trails on trailId = trId
                left join $wpdbExtra->codes on mapStyle = code and codeType = 'surface'
                where $sqlWhereLines
				order by sequence";
        if ($debugMileage) $msg .= rrwFormat::CellRow("i#771 there are " . $wpdbExtra->num_rows . " from the $sqlLines $eol");
        //      return  "$msg $eol temp check hanging -------- in  ----- outputMileByTypeFiles2;-------5-----$eol";
        $recLines = $wpdbExtra->get_resultsA($sqlLines);
        if ($wpdbExtra->num_rows == 0) {
            $msg .= "$sqlLines $eol";
            $ii = strpos($sqlLines, "where  trail");
            if ($ii !== false) {
                $trailIdBad = substr($sqlLines, $ii + 12);
                $jj = strpos($trailIdBad, "order by");
                if ($jj !== false) {
                    $trailIdBad = substr($trailIdBad, 0, $jj);
                }
            } else {
                $trailIdBad = "";
            }
            return "$msg $errorBeg E#772 trail/route $trailIdBad has no lines $errorEnd ";
        }
        $trNamePast = "";    // the trail name from the last line used to trigger totals
        $landingPagePast = $recLines[0]["landingPage"];
        $page .= $headerLine;       // headerLine has table built in
        $cntLines = 0;
        $is_eptaLine = false;
        foreach ($recLines as $recTrail) {
            $cntLines++;
            $trName = $recTrail["trName"];
            $trailId = $recTrail["trailId"];
            $miles = $recTrail["miles"];
            $mapStyle = $recTrail["mapStyle"];
            $googleType = $recTrail["googleType"];
            $landingPage = $recTrail["landingPage"];
            $lineName = $recTrail["lineName"];
            $lineId = $recTrail["lineId"];
            $codeDescription = $recTrail["codeDescription"];
            $routes = $recTrail["routes"];
            if ($debugMileage) $msg .= "line #$cntLines - $lineName - $mapStyle $eol ";
            if (strpos($routes, "epta") !== false) {
                $is_eptaLine = true;
            } else {
                $is_eptaLine = false;
            }
            //      return  "$msg $eol temp check hanging -------- in  ----- outputMileByTypeFiles2;-------6-----$eol";
            if ($trNamePast != $trName) {
                // change in trail name
                if (! empty($trNamePast)) {
                    // outputting multiple trails in this run
                    $thisLine = self::OutputTrailTotals($landingPagePast, $trNamePast, $Totals4Trail);
                    $page .= $thisLine;
                    $pageDetail .= $thisLine;
                }
                // reset the total for the this trail
                foreach (array_keys($Totals4Trail) as $key) {
                    $Totals4Trail[$key] = 0;  // reset the total
                }
                $pageDetail .= "<tr><td colspan='7' ><strong>$trName</strong></td></tr>";
                $pageDetail .= $headerLine;
                $trNamePast = $trName;
                $landingPagePast = $landingPage;
            } // end if ( $trNamePast != $trName  )
            $editLink = "edit-line/?lineId=$lineId";
            $RedOrNot = date("Y-m-d");
            $editLineLink = rrwFormat::PencilIcon($editLink, $RedOrNot) .
                FreewheelFormat::lineIdMapLink($lineId, "map $lineName ") . $lineName;
            $milesLine = array();
            foreach (array_keys($Totals4Trail) as $key) {
                if ($key == $googleType) {
                    $milesLine[$key] = $miles;
                    $Totals4Trail[$key] += $miles;
                    $totals4Route[$key] += $miles;
                    if ($is_eptaLine) {
                        $totals4epta[$key] += $miles;
                    }
                } else {
                    $milesLine[$key] = 0;   //
                }
            } // end foreach ( $heads as $head )
            //      return  "$msg $eol temp check hanging -------- in  ----- outputMileByTypeFiles2;-------7-----$eol";
            $pageDetail .= self::OutputLineOfNumbers($editLineLink, $codeDescription, $milesLine, $routes); //
        } // end foreach ( $recTrails as $recTrail )
        //      return  "$msg $eol temp check hanging -------- in  ----- outputMileByTypeFiles2;------- 8 -----$eol";
        // Do not forget the last total
        $totalLine = self::OutputTrailTotals($landingPagePast, $trNamePast, $Totals4Trail);
        $totalEPTA = self::OutputTrailTotals($landingPagePast, $trNamePast . "on EPTA", $totals4epta);
        $page .= $totalLine;
        $pageDetail .= $totalLine;
        if (!empty($title)) {
            $totalLineRoute = self::OutputTrailTotals($landingPagePast, $trNamePast, $Totals4Trail);
            $page .= $totalLineRoute;
            $pageDetail .= $totalLineRoute;
        }
        $page .= "</table>";
        $pageDetail .= "</table>";
        if ($debugMileage) {
            $msg .= str_repeat("-", 80) . $eol;
            $msg .= $page;
            $msg .= str_repeat("-", 80) . $eol;
            $msg .= $pageDetail;
            $msg .= str_repeat("-", 80) . $eol;
        }
        $page .= self::disclaimer();
        $pageDetail .= self::disclaimer();
        $msg .= freewheeling_WriteUp::saveFileWithCompare("miles-by-type", "$trailOrGroupId-route.html", $page);
        $msg .= freewheeling_WriteUp::saveFileWithCompare("miles-by-type", "$trailOrGroupId-routeDetail.html", $pageDetail);
        $msg .= freewheeling_WriteUp::saveFileWithCompare("miles-by-type", "$trailOrGroupId-routeTotal.html", $totalLine . $eol);
        // TODO more code to detect grip id changes
        return $msg;
    } // end FreewheelingBuildMileageChart::outputMileByTypeFiles2( $trailOrGroupId )
    public static function disclaimer()
    {
        return "<p>
    <strong>Trail Lines</strong> are typically entered by tracing satellite imagery to extract latitude/longitude coordinates. The accuracy of these coordinates changes depending on the source of the photo and the precision of placement. I have seem satellite edges mismatched on the order 55 feet. Line work is sometimes extracted from the Open Street Map Project and from Strava heat maps.<br>
    <Strong>>Milepost</strong> Known milepost (are placed on the map when they are visible in the satellite image or can be located via to visible features in the image. Other miles posts are extrapolated using calculations along the rail line. <i>Note</i> Railroads have also been known to realign trackage and not move existing mileage markers, only making an annotation on their paper maps.<br>
    <Strong>Distances Above</strong> are based on the google map distance between two points along the line work.
    </p>";
    }
    private static function OutputTrailTotals($landingPagePast, $trNamePast, $trailTotals)
    {
        $trailNameDisplay = "<a class='external' href='$landingPagePast' >$trNamePast</a>";
        $thisLine = rrwFormat::CellRow("", "", "", "", "", "");
        $thisLine .= self::OutputLineOfNumbers($trailNameDisplay, "<strong>total for Trail</strong>", $trailTotals);
        $thisLine .= rrwFormat::CellRow(" ", " ", " ", " ", " ", " ");
        // now put the total for the trail
        return $thisLine;
    }
    private static function OutputLineOfNumbers($itemDisplay, $mapStyle, $miles, $routes = "")
    {
        global $eol;
        static $color;
        $total = 0;
        foreach ($miles as $key => $mile) {
            $total = $total + $mile;
        }
        $color = rrwFormat::colorSwap($color);
        $thisRow = "<tr style='background-color:$color' >\n" .
            rrwFormat::Cells($itemDisplay) . rrwFormat::Cell($mapStyle) . rrwFormat::Cell($routes);
        if (strpos($mapStyle, "strong") !== false)
            $thisRow .= rrwFormat::Cell("<strong>$total</strong>");
        else
            $thisRow .= rrwFormat::Cell($total);
        foreach ($miles as $key => $mile) {
            if (0 == $mile)
                $thisRow .= rrwFormat::Cell("");
            elseif (strpos($mapStyle, "strong") !== false)
                $thisRow .= rrwFormat::Cell("<strong>$mile</strong>");
            else
                $thisRow .= rrwFormat::Cell($mile);
        }
        $thisRow .= rrwFormat::Cell("&nbsp;") . "</tr>";
        return $thisRow;
    }
    public static function makeStairStepChart($trailIdOrGroupId, $displayChart = false)
    {
        /* $Citys[] 	is the Citys remove the dash (-) to get the city name
     * $mpEnd[]		is the mileage along the trail at that particular icon
     * $lineStatus[]	is ether "closed" or anything else. Closed means make the line pink
     */
        global $eol, $errorBeg, $errorEnd, $okay;
        global $wpdbExtra;
        $msg = "";
        $debugArraySteps = rrwParam::isDebugMode("debugArraySteps", true);  // source data
        $displayProgress = rrwParam::isDebugMode("displayProgress", true);
        try {
            $msg = "";
            if ($debugArraySteps) $msg .= "makeStairStepChart: $trailIdOrGroupId $eol";
            if ($displayProgress) $msg .= "calling BuildTableOfPointsALongLines($trailIdOrGroupId $eol";
            try {
                $lines = new freewheelingLineTable($trailIdOrGroupId, " in makeChart ", $msg);
            } catch (Exception $ex) {
                $msg .= $ex->getMessage();
                return $msg;
            }
            if ($debugArraySteps) $msg .= "There are " . $lines->get_latCount() . "points along the line $eol";
            // $msg .= $lines->dumpMilageTableByPoints(0, 100, "after table build");
            if ($displayProgress) $msg .= "about to gather the icons $eol";
            $sqlWhereIcons = freewheeling_kml_common::sqlWhereForGroupOrTrailIcons($trailIdOrGroupId);
            $sqlWhereIcons = str_replace(" trailId", " icon.trailId", $sqlWhereIcons);
            $sqlIcons = "select distinct iconName, iconId, milePostPrefix, milepost, isTrailHead, latitude, longitude
                from $wpdbExtra->icons  icon
                    join $wpdbExtra->lines line on icon.trailId = line.trailId
                    where $sqlWhereIcons  and isMileageStep > 0
                        and onMap not like '%offline%' and onMap != '" . freeWheel::estimated_milepost . "'
                        and sort != '0-0000' and sort != 0
                    order by sort, milepost ";
            if ($debugArraySteps) $msg .= "$sqlIcons $eol";
            $recIcons = $wpdbExtra->get_resultsA($sqlIcons);
            $numCols = count($recIcons);
            if (0 == $numCols)
                return "ErrorBeg E#661 no points were found to make a  chart with $errorEnd $sqlIcons $eol";
            if ($debugArraySteps) $msg .= " there are $numCols Trail Heads along the line $eol";
            $ii = 0;
            foreach ($recIcons as $recIcon) {
                $iconName1 = $recIcon["iconName"];
                $milepost1 = $recIcon["milepost"];
                $latitude1 = $recIcon["latitude"];
                $longitude1 = $recIcon["longitude"];
                $milePostPrefix1 = $recIcon["milePostPrefix"];
                try {
                    $milesAlong1 = $lines->findMilesALongAt($latitude1, $longitude1, "$iconName1, $milePostPrefix1 $milepost1");
                } catch (Exception $ex) {
                    $msg .= $ex->getMessage() . " $errorBeg E#672 problems at bottom makeStairStepChart with the bigArray  $errorEnd";
                    return $msg;
                }
                $jj = 0;
                foreach ($recIcons as $recIcon2) {
                    $iconName2 = $recIcon2["iconName"];
                    $milepost2 = $recIcon2["milepost"];
                    $milePostPrefix2 = $recIcon2["milePostPrefix"];
                    $latitude2 = $recIcon2["latitude"];
                    $longitude2 = $recIcon2["longitude"];
                    //     $msg .= "get mileage $iconName1 $milepost1 $milePostPrefix1  and $iconName2 $milepost2 $milePostPrefix2  stool in $ii $jj$eol";
                    $milesAlong2 = $lines->findMilesALongAt($latitude2, $longitude2, "$iconName2, $milePostPrefix2 $milepost2");
                    $workingArray[$ii][$jj] = abs($milesAlong2 - $milesAlong1);
                    $jj++;
                    if ($jj > $ii)
                        break;
                } // end foreach($recIcons as $recIcon2)
                $ii++;
            }   // end foreach ($recIcons as $recIcon)
            if ($debugArraySteps) $msg .= self::DisplayBigArray($workingArray, $numCols,  "filled array with distance between columns");
            // workingArray now contains the data to display
            $chart = "";
            $chart .= self::styleBlock();
            $chart .= "<table class='make_pretty_mileage_chart' style='border-collapse: unset;' >";
            $chart .= self::formatLocation($recIcons, 0, $numCols + 2);
            for ($jj = 1; $jj < $numCols; $jj++) {
                $chart .= self::formatTrItem();;
                for ($ii = 0; $ii < $jj; $ii++) {
                    $distance = round($workingArray[$jj][$ii], 0);
                    $chart .= self::formatCellMile($distance, "open", $ii, $jj);
                }
                $chart .= self::formatLocation($recIcons, $jj, $numCols - $ii + 4);
            }
            $chart  .= "</table>";
            $chart .= self::disclaimer();
            $msg .= freewheeling_Writeup::saveFile("mileage_chart", "$trailIdOrGroupId" . "-stepChart.html", $chart);
            if ($displayChart) {
                $msg .= $chart;
            }
            $msg .= $eol;
        } catch (Exception $ex) {
            $msg .= $ex->getMessage() . " $errorBeg E#620 problems at bottom makeStairStepChart with the bigArray  $errorEnd";
            throw new Exception($msg);
        }
        return $msg;
    } // end function makeStairStepChart
    /*
    private static function CreateTheChart($recIcons, &$chart)
    {
        global $eol;
        $msg = "";
        $debugArraySteps = rrwParam::isDebugMode("debugArraySteps", false);
        $numCols = count($recIcons);
        $iconid = $recIcons[0]["iconId"];
        $milepostArray = array();
        // the columns contain the milepost of the top most item
        $numCols = count($recIcons);
        for ($ii = 0; $ii < $numCols; $ii++) {
            for ($jj = 0; $jj < $numCols; $jj++) {
                $milepostArray[$ii][$jj] = $recIcons[$jj]["milepost"];
            }
        }
        if ($debugArraySteps) $msg .= self::DisplayBigArray($milepostArray, $numCols,  "filled array with mileposts");
        // now fill the array with the difference between the columns or miles between adjacent columns
        for ($jj = $numCols - 1; $jj > 0; $jj--) {
            for ($ii = $numCols - 1; $ii >= 0; $ii--) {
                $miles =  $milepostArray[$ii][$jj] - $milepostArray[$ii][$jj - 1];
                //         $msg .= "ii=$ii, jj=$jj, " . $milepostArray[$ii][$jj] . " - " . $milepostArray[$ii][$jj - 1] . " = $miles $eol";
                $milepostArray[$ii][$jj] = $miles;
            }
        }
        if ($debugArraySteps) $msg .= self::DisplayBigArray($milepostArray, $numCols,  "filled array with distance between adjacent columns");
        // now add the columns right to left to get miles from right number to the end column
        for ($ii = 1; $ii < $numCols; $ii++) {
            for ($jj = $ii; $jj > 0; $jj--) {
                $miles = $milepostArray[$ii][$jj];
                $milepostArray[$ii][$jj - 1] = $milepostArray[$ii][$jj - 1] + $miles;
            }
        }
        if ($debugArraySteps) $msg .= self::DisplayBigArray($milepostArray, $numCols,  "filled array with distance between column and right most column");
        $iconid = $recIcons[0]["iconId"];
        // milepostArray now contains the data to display
        $chart = "";
        $chart .= self::styleBlock();
        $chart .= "<table class='make_pretty_mileage_chart' style='border-collapse: unset;' >";
        $chart .= self::formatLocation($recIcons, 0, $numCols + 2);
        $iconid = $recIcons[0]["iconId"];
        for ($jj = 1; $jj < $numCols; $jj++) {
            $chart .= self::formatTrItem();;
            for ($ii = 1; $ii <= $jj; $ii++) {
                $distance = round($milepostArray[$jj][$ii], 0);
                $chart .= self::formatCellMile($distance, "open", $ii, $jj);
            }
            $iconid = $recIcons[$jj]["iconId"];
            $iconId = $recIcons[$jj]["iconId"];
            $chart .= self::formatLocation($recIcons, $jj, $numCols - $ii + 4);
        }
        $chart  .= "</table>";
        return "$msg\n";
    }
*/
    private static function formatCellMile($mile, $status, $ii, $jj)
    {
        if ($status == "closed")
            $class = "make_pretty_mileage_chartedClosed";
        else
            $class = "make_pretty_mileage_charted";
        return "\n<td class='row$jj" . "_$ii' class=\"$class\"  onclick='changeColors($ii,$jj);'>$mile</td>";
    }
    private static function styleBlock($alert1 = false, $alert2 = true)
    {
        $scriptBlock = "
    <script>
        function changeColors(irow, icol) {
       alert ('row = ' + irow + ' column = ' + icol);
            for (var i = icol; i > irow; i--) {
                var loc = 'row' + i + '_' + irow;
             alert ('loc = ' + loc);
                cell = document.getElementsByClassName(loc);
                alert('cell.length 1 = ' + cell.length);
                cell[0].style.backgroundColor = 'pink';
            }
        alert ('now to the right row = ' + irow + ' column = ' + icol);
             for (var i = irow; i < icol; i++) {
                var loc = 'row' + icol + '_' + i;
                 alert ('loc = ' + loc);
                cell = document.getElementsByClassName(loc);
                alert('cell.length 2 = ' + cell.length);
                cell[0].style.backgroundColor = 'pink';
            }
        }
        </script>
        ";
        $styleBlock = "
<style>
table {
		border-collapse: unset;
}
.make_pretty_mileage_chart {
	border-spacing: 0px;
	border-collapse: unset;
}
.make_pretty_mileage_charted {
  	border-width: thin;
	border-style: solid;
	border-spacing: 0px;
	border-color: black;
	text-align: right;
	width: 14px;  /* 14 */
  	background-color: white;
	padding:2px;
	cell
}
.make_pretty_mileage_chartedClosed {
  	border-width: thin;
	border-style: solid;
	border-spacing: 0px;
	border-color:black;
	text-align:right;
	color: white;
	width:14px;
  	background-color:pink;
}
.make_pretty_mileage_chartTh {
	border: none;
	border-color:green;
  height: 20px;
  text-align:left;
 background-color: inherit;
#  -ms-transform: rotate(3155deg); /* IE 9 */
#  -webkit-transform: rotate(315deg); /* Safari 3-8 */
#  transform: rotate(315deg);
	-webkit-column-span: 5;
	-moz-column-span: all;
	-o-column-span: all;
}
</style>
";
        $iiEnd = 0;
        for ($ii = 1; $ii < 12; $ii++) { // remove the first 4 alerts
            $iiAlert = strpos($scriptBlock, "alert", $iiEnd);
            if ($iiAlert === false)
                break;
            $iiEnd = strpos($scriptBlock, "\n", $iiAlert + 1);
            $scriptBlock = substr($scriptBlock, 0, $iiAlert) . substr($scriptBlock, $iiEnd);
        }
        return $scriptBlock . $styleBlock;
    } //end function styleBlock
    private static function formatTrItem()
    {
        return "\n<tr border:thin >";
    }
    private static function formatLocation($recIcons, $jj, $columnSpan)
    {
        $msg = "";
        $chartSection = "";
        $iconName = $recIcons[$jj]["iconName"];
        $iconId   = $recIcons[$jj]["iconId"];
        $isTrailHead = $recIcons[$jj]["isTrailHead"];
        $milepost = round($recIcons[$jj]["milepost"], 1);
        $iiDash = strpos($iconName, "-");
        if ($iiDash === false)
            $city = $iconName;
        else
            $city = substr($iconName, 0, $iiDash - 1);
        $city = str_replace(" ", "&nbsp;", $city);
        if ($isTrailHead == 2)
            $city .= " (no parking)";
        //	$msg .= '\n<th class=""><div class="city" >' . $city . "</div></th>";
        $city .= " - $milepost";
        $msg .= "\n<th class=\"make_pretty_mileage_chartTh\" ";
        if ($columnSpan > 2) {
            $columnSpan--;
            $msg .= " colspan=\"$columnSpan\" ";
        }
        $aminityPage = "$iconName-$iconId";
        $msg .= "><a href='/freewheelingeasy-amenity/?amenity=$aminityPage'> &nbsp;
				$city </a></th>";
        $msg .= "\n</tr>\n";
        return $msg;
    } // end function formatCellCity
    private static function DisplayBigArray($bigArray, $numCols, $title = "")
    {   // debug tool to see how the steps i the creation of the chart
        $msg = "";
        $msg .= rrwFormat::backtrace("DisplayBigArray");
        $msg .= "<h2>$title</h2>";
        $msg .= "<table>";
        for ($ii = 0; $ii < $numCols; $ii++) {
            $msg .= "<tr><td>$ii</td>";
            for ($jj = 0; $jj < $numCols; $jj++) {
                if (!key_exists($ii, $bigArray))
                    $msg .= "<td>no data</td>";
                elseif (! key_exists($jj, $bigArray[$ii]))
                    $msg .= "<td>no data</td>";
                else
                    $msg .= "<td>" . $bigArray[$ii][$jj] . "</td>";
            } // end for ($jj = 0; $jj < $numCols; $jj++)
            $msg .= "</tr>";
        } // end for ($ii = 0; $ii < $numCols; $ii++)
        $msg .= "</table>";
        return $msg;
    }
    // ------------------------------------------------------------------------------------------------------------ end of makeStairStepChart routines
    /**
     * Generates a chart based on the provided SQL WHERE clause.
     *
     * @param string $sqlWhere The SQL WHERE clause to filter the data.
     * @param string $title The title of the chart.
     * @param string &$msg A reference to a variable that will store any error messages.
     * @return void
     */
    public static function makeTrailHeadChart($sqlWhere, $title, &$outputMsg)
    {
        // a make a table of trailheads, with mileposts, and accumulated miles
        // assumes that trails end and start at a trailhead, which may or may not be true
        // assumes that the trailheads are in order of the trail
        global $eol, $errorBeg, $errorEnd;;
        global $wpdbExtra;
        return "not implmented";
        $sqlIcons = "select distinct iconName, milepost " .
            "from $wpdbExtra->icons join $wpdbExtra->trails on trailId = trId " .
            " where isTrailHead > 0 and $sqlWhere " .
            "order by trSequence, milepost ";
        $recIcons = $wpdbExtra->get_resultsA($sqlIcons);
        if ($wpdbExtra === false || $wpdbExtra->num_rows == 0) {
            $outputMsg .= "$errorBeg E#681 makeChart has no trail heads found or something $sqlIcons $errorEnd";
            return "Chart creation failed"; // the chart display
        }
        $chart = "<h1>$title</h1>";
        $chart .= "<table >" . rrwFormat::HeaderRow("trailHead", "milepost", "miles", "miles to previous trailHead");
        $miles = 0;
        $pastMile = 0;
        foreach ($recIcons as $recIcon) {
            $milepost = $recIcon["milepost"];
            $diffMiles = $milepost - $pastMile;
            $miles += $diffMiles;
            $chart .= rrwFormat::CellRow($recIcon["iconName"], $milepost, $miles, $diffMiles);
            $pastMile = $milepost;
        }
        $chart .= "</table";
        return $chart;
    } // end function makeTrailHeadChart
    private static function makeChartAccessPointMilepostMiles($sqlWhereIcons)
    {
        // looks to make a chart of the trail heads with distance between them
        // is the where clause to produce a list of trail heads
        // a make a table of trailHeads, with mileposts, and accumulated miles
        // assumes that trails end and start at a trailHead, which may or may not be true
        // assumes that the trailLeads mileposts are in order of the trail
        // << need code to maybe deal with the trailHeads not in order >>
        // need code to deal with closed segments.
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $debugLoadTables = true;
        $sqlTrailHeads = "select distinct  trailId, iconName, iconId, milepost, isTrailHead from $wpdbExtra->icons
                      join $wpdbExtra->trails on trailId = trId
                      where $sqlWhereIcons
                        order by trSequence, milepost";
        if ($debugLoadTables) $msg .= "$sqlTrailHeads $eol ";
        $recTrailHeads = $wpdbExtra->get_resultsA($sqlTrailHeads);
        if ($wpdbExtra->num_rows == 0) {
            return "$msg $errorBeg E#682 makeChart has no trail heads found or maybe lines $sqlTrailHeads $errorEnd";
            //   $msg.= rrwFormat::backtrace("$msg");
            //   throw new Exception("$msg $errorBeg E#731 not not find a match to '$grpid' with sqlwhere '$sqlWhere' $eol
            //              " . rrwFormat::backtrace() . "$eol $sqlTrailHeads $errorEnd $msgTemp ");
        }
        $cnt = 0;
        $IconList = array();
        $milesAlongTrail = array();;
        $pastMilepost = 0;
        $sumMiles = 0;
        foreach ($recTrailHeads as $recTrailHead) {
            $mile = $recTrailHead["milepost"];
            $milepost[$cnt] = $mile;
            if (empty($mile))
                $mile = 0;
            $iconName = $recTrailHead["iconName"];
            $displayText = $iconName . " " . rrwFormat::milePostText($mile);
            $IconList[$cnt] = freewheelFormat::iconIdMapLink($recTrailHead["iconId"], $displayText);
            $diffMiles = $mile - $pastMilepost;
            $sumMiles += $diffMiles;
            $milesAlongTrail[$cnt] = $sumMiles;
            $pastMilepost = $mile;
            $cnt++;
        }
        if ($debugLoadTables) {
            $msg .= "<table>" . rrwFormat::HeaderRow("trailHead", "milepost", "miles");
            for ($ii = 0; $ii < count($IconList); $ii++) {
                $msg .= rrwFormat::CellRow($IconList[$ii], $milepost[$ii], $milesAlongTrail[$ii]);
            }
            $msg .= "</table>";
        }
        $msg .= "$errorBeg self::make_pretty_mileage_chart();  wants five paramters$errorEnd ";
        return $msg;
    }
}  // end class     FreewheelingBuildMileageChart
