<?php
/*		Freewheeling Easy Mapping Application
 *
 *		A collection of routines for display of trail maps and amenities
 *
 *		copyright Roy R Weil 2019 - https://royweil.com
 *
 */
class lineBuffer
{
    public static function makeOffsetLines($trailIdInput)
    {
        // create a line that is offset from the original line by 10 meters
        // this is used to create a line that is parallel to the original line
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        global $idLineMax, $defaultSource, $lineCnt;
        global $itemname, $itemCoords, $itemStyle, $itemId;
        global $trailId;
        $offset = "offset";  // dummy trail name for the offset line
        $msg = "";
        $sql = "select pointList from $wpdbExtra->lines where trailId = '$trailIdInput'";
        $recPoints = $wpdbExtra->get_resultsA($sql);
        $msg .= "found " . count($recPoints) . " lines for $trailIdInput $eol";
        if (empty($recPoints)) {
            $msg .= "no lines found for $trailIdInput $eol";
            return $msg;
        }
        foreach ($recPoints as $recPoint) {
            $pointList = $recPoint["pointList"];
            if (empty($pointList)) {
                $msg .= "no line buffer found for $trailIdInput $eol";
                return $msg;
            }
            $sqlEmpty = "delete from $wpdbExtra->lines where trailId = '$offset'";
            $cnt = $wpdbExtra->query($sqlEmpty);
            $cntCoords = explode(" ", $pointList);
            $msg .= "found " . count($cntCoords) . " points in line buffer $eol";
            $itemCoords = $pointList;
            $sql = " select max(lineId) as maxId from $wpdbExtra->lines"; # get the next line number
            $idLineMax = $wpdbExtra->get_var($sql);
            $itemId = 123456;
            $itemStyle = "#asphalt";
            $itemname = "offset line for $trailId";
            $defaultSource = "offset line for $trailId";
            $trailId = $offset;
            $msg .= freewheeling_kml_read::writeLineToDatabase(true);
            // trail offset now has one line in the lines table
            $msg .= self::makeLineBuffer($offset, 5); // make a 2.5 meter buffer line around the  line
            $sqlDeleteBase = "delete from $wpdbExtra->lines where trailId = '$offset' ";
            $cnt = $wpdbExtra->query($sqlDeleteBase);
            $msg .= "deleted $cnt base offset line $eol";
            $sqlNewRegion = "select lineBuffer from $wpdbExtra->regions where trailId = '$offset'";
            $pointListNew = $wpdbExtra->get_var($sqlNewRegion);
            $msg .= "before $eol $pointListNew $eol";
            $FirstCoord = strpos($pointListNew, ",0");
            $pointListNew = substr($pointListNew, $FirstCoord + 3); // remove the first point so it no loner is a closed polygon
            $itemCoords = $pointListNew;
            $msg .= "after $eol $itemCoords $eol";
            $itemId = 123457;
            $iconname = "new offset line form $trailIdInput";
            $msg .= freewheeling_kml_read::writeLineToDatabase(true);
            $msg .= freewheelingeasy_kml_merge::mergeTrail($offset, array());
        } // end foreach recPoints
        return $msg;
    }
    public static function makeLineBuffer($trailId, $metersOffset = 1112.3481)
    {
        // create a buffer around the line of the trail
        // the buffer is a polygon that is 0.01 degrees from the line
        // the buffer is stored in the regions.lineBuffer table
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        try {
            $debugLineBuffer = rrwParam::isDebugMode("debugLineBuffer");
            $latitudeOffset = self::convertMetersToLatitudeDifference($metersOffset);
            $msg = "";
            if ($debugLineBuffer) $msg .= "I#2354 makeLineBuffer( $trailId, $metersOffset) or $latitudeOffset degrees $eol";
            $sqlTrail = "select trId from $wpdbExtra->trails ";
            if (! empty($trailId))
                $sqlTrail .= " WHERE trId = '$trailId' ";
            $sqlTrail .= " order by trId";
            $recTrails = $wpdbExtra->get_resultsA($sqlTrail);
            foreach ($recTrails as $recTrail) {
                $trailId = $recTrail["trId"];
                if ($debugLineBuffer) $msg .= "I#2355 Processing $trailId $eol";
                $sql = "select * from $wpdbExtra->lines where trailId = '$trailId' order by sequence";
                $recs = $wpdbExtra->get_resultsA($sql);
                if ($debugLineBuffer) $msg .= "I#2356 found " . count($recs) . " lines for $trailId $eol";
                if (empty($recs)) {
                    if ($debugLineBuffer) $msg .= "I#2357 no lines found for $trailId found $eol";
                    continue;
                }
                $latLonString = "";
                $latmax = -180;
                $latmin = 180;
                $lngmax = -180;
                $lngmin = 180;
                foreach ($recs as $rec) {
                    $pointList = $rec["pointList"];
                    if (empty($pointList)) {
                        $lineNameTemp = $rec["lineName"];
                        if ($debugLineBuffer) $msg .= "T#2358 empty pointList for $trailId -  $lineNameTemp  $eol";
                        continue;
                    }
                    $coords = explode(" ", $pointList);
                    foreach ($coords as $coord) {
                        if (empty($coord))
                            continue;
                        $latLon = explode(",", $coord);
                        $lat = $latLon[1];
                        $lng = $latLon[0];
                        $latmax = max($latmax, $lat);   // we messed up a long ime ago and the point list is stored lng, lat, elevation
                        $latmin = min($latmin, $lat);
                        $lngmax = max($lngmax, $lng);
                        $lngmin = min($lngmin, $lng);
                        $latLonString .= " point($lat,$lng),";
                    } // end foreach coords
                } // end foreach recs
                //ets update the max min in regions
                if ($debugLineBuffer) $msg .= "I#2359 latmax = $latmax, latmin = $latmin, lngmax = $lngmax, lngmin = $lngmin $eol";
                $latLonString = substr($latLonString, 0, strlen($latLonString) - 1);
                $sqlUpdate = "update $wpdbExtra->regions set north = $latmax, south = $latmin, east = $lngmax, west = $lngmin where trailId = '$trailId'";
                if ($debugLineBuffer) $msg .= "I#2360 update " . $wpdbExtra->query($sqlUpdate) . " record  $eol";
                // if ($debugLineBuffer) $msg .= "latLonString = $latLonString $eol";
                $sqlBuff = "select   ST_AsText(   st_buffer( LINESTRING($latLonString), $latitudeOffset) )as buffer";
                if ($debugLineBuffer) $msg .= "I#2361 sqlls = $sqlBuff $eol";
                $buffer = $wpdbExtra->get_var($sqlBuff);
                $coords = str_replace("POLYGON((", "", $buffer);
                $coords = str_replace("))", "", $coords);
                $coords = str_replace(" ", ",", $coords);
                if ($debugLineBuffer) $msg .= "$eol" . substr($coords, 0, 200) . $eol;
                $coordArray = explode(",", $coords);
                $lineBuffer = "";
                $cnt = 0;
                for ($ii = 0; $ii < count($coordArray); $ii += 2) {
                    $lat = $coordArray[$ii];
                    $lng = $coordArray[$ii + 1];
                    if ($debugLineBuffer) $msg .= "I#2362 lat = $lat, lng = $lng $eol";
                    $lineBuffer .= "$lng,$lat,0 ";
                    $cnt++;
                    if ($cnt > 20)
                        continue;
                }   // end for
                if ($debugLineBuffer) {
                    $msg .= "$eol  <pre>" . substr($lineBuffer, 0, 200) . " </pre>$eol";
                    $msg .= "I#2363 length of line buffer = " . strlen($lineBuffer) . " $eol";
                }
                $sqlUpdate = "update $wpdbExtra->regions set lineBuffer = '$lineBuffer' where trailid = '$trailId'";
                if ($debugLineBuffer) $msg .= "I#2364 update " . $wpdbExtra->query($sqlUpdate) . " records  $eol";
            } // end foreach recTrails
            if ($debugLineBuffer) $msg .= "coords = $coords $eol";
        } // end try
        catch (Exception $ex) {
            $msg .= "$errorBeg  E#2365 thrown out of lineBuffer: " . $ex->getMessage() .  $errorEnd;
        } // end catch
        return $msg;
    } // end function lineBuffer
    /**
     * Converts a linear distance in meters to a difference in latitude (decimal degrees).
     *
     * Uses the approximation that 1 degree of latitude is ≈ 111,320 meters.
     * This is sufficiently accurate for most latitudes, but does not account for
     * ellipsoidal Earth variation or altitude. For high-precision geodesic work,
     * use a geodesic library instead.
     *
     * Note: This conversion applies to latitude only. Longitude degree length varies
     * with latitude and would require a cosine(latitude) factor.
     *
     * @param float|int $meters The distance in meters; the sign is preserved (negative values yield negative differences).
     * @return float The approximate difference in latitude in decimal degrees.
     *
     * @example 1000 meters ≈ 0.008983 degrees of latitude.
     */
    public static function convertMetersToLatitudeDifference($meters)
    {
        // convert meters to a difference in latitude
        // 1 degree of latitude is about 111.32 km (≈ 111,320 meters)
        // 1 meter is approximately 1 / 111,320 degrees of latitude (≈ 0.000008983°)
        // this approximation is reasonably accurate for most latitudes
        $latitudeDifference = $meters / 111320;
        return $latitudeDifference;
    }
} // end class