<?php
/*		Freewheeling Easy Mapping Application
 *
 *		A collection of routines for display of trail maps and amenities
 *
 *		copyright Roy R Weil 2019 - https://royweil.com
 *
 *
/*
 * freewheelingeasy_build_segment_report::freewheelingBuildSegmentReport
 *
 */
class freewheelingeasy_build_segment_report
{
    static public
    function freewheelingBuildSegmentReport($attr)
    {
        return "segement reports no longer active";
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_trail_routes;
        $msg = "";
        $msg .= freeWheeling_edit_setGlobals::setGlobals("freewheelingBuildSegmentReport");
        $route = rrwParam::String("route", $attr);
        $sqlRoutes = "select linesql from $rrw_trail_routes where grpid = '$route' ";
        $linesql = $wpdbExtra->get_var($sqlRoutes);
        $msg .= freewheelingeasy_calculateMP::update_Trail_mile_table($route, $linesql);
        $msg .= freewheelingeasy_build_segment_report::freewheelingBuildOneSegmentReport($route);
        return $msg;
    }
    static public
    function freewheelingBuildAllSegmentReports()
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_trail_routes;
        // called from kmlClean
        try {
            error_reporting(E_ALL | E_STRICT);
            $msg = "";
            $color = "white";
            $msg .= freeWheeling_edit_setGlobals::setGlobals("freewheelingBuildAllSegmentReports");
            $sqlRoutes = "select grpid, grpName, grpDescription, linesql from $rrw_trail_routes
							where is_continuous = 1  ";
            $recRoutes = $wpdbExtra->get_resultsA($sqlRoutes);
            $color = rrwutil::colorSwap();
            foreach ($recRoutes as $recRoute) {
                $routeid = $recRoute["grpid"];
                $color = rrwUtil::colorSwap($color);
                $msg .= "<span style='background-color:$color' >" .
                    freewheelingeasy_build_segment_report::freewheelingBuildOneSegmentReport($routeid) .
                    "</span>";
            }
        } catch (Exception $e) {
            $msg .= $e->getMessage() . $eol;
        }
        return $msg;
    }
    static public
    // called from calculatMP::doAllThingsForAgroup
    function freewheelingBuildOneSegmentReport($grpid)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_trail_routes;
        $msg = "";
        $sqlRoutes = "
            select grpid, grpName, grpDescription, linesql from $rrw_trail_routes
            where is_continuous = 1 and grpid = '$grpid' ";
        $recroutes = $wpdbExtra->get_resultsA($sqlRoutes);
        if ($wpdbExtra->num_rows == 0) {
            return "
            $msg $errorBeg E #680 no segments found for group $grpid $eol $sqlRoutes $errorEnd";
        }
        $recroute = $recroutes[0];
        $msg .= freewheelingeasy_build_segment_report::createSegReportsJson($recroute);
        return $msg;
    }
    static public
    function createSegReportsJson($recroute)
    {
        return "segment reports no longer active";
        global $eol, $errorBeg, $errorEnd;
        global $milepost;
        global $wpdbExtra, $rrw_trail_mile, $rrw_segments;
        $msg = "";
        $debugReport = rrwParam::Boolean("debugreport");
        $debugFoundTwo = rrwParam::Boolean("foundtwo");
        $debugtrail_mile = rrwParam::Boolean("trail_mile");
        $debugOutput = rrwParam::Boolean("debugoutput");
        $outputArray = array();
        $routeName = $recroute["grpName"];
        $routeid = $recroute["grpid"];
        $linesql = $recroute["linesql"];
        $msg .= " [ <a href='https:/status-one/?route=$routeid' >$routeName</a> ] ";
        $namearray["trname"] = $routeName;
        array_push($outputArray, $namearray);
        $sqlIcons = "select mile_iconName, milesAlongTrail from $rrw_trail_mile where mile_route = '$routeid' order by milesAlongTrail ";
        if ($debugReport) $msg .= "$sqlIcons $eol";
        $recIcons = $wpdbExtra->get_resultsA($sqlIcons);
        if ($wpdbExtra->num_rows < 2)
            return "$msg $errorBeg E#734 not enough rows in the trail_mile table $errorEnd $sqlIcons $eol";
        foreach ($recIcons as $recIcon) {
            $iconName = $recIcon["mile_iconName"];
            $icondistance[$iconName] = $recIcon["milesAlongTrail"];
        }
        if ($debugtrail_mile) $msg .= rrwUtil::print_r($icondistance, true, "table of icon distances");
        $iconNext = $recIcons[0]["mile_iconName"];
        $lastIndesx = count($recIcons) - 1;
        $iconLast = $recIcons[$lastIndesx]["mile_iconName"]; // they last one
        if ($debugReport) $msg .= "report begins at $iconNext and ends at $iconLast $eol";
        $segcount = 0;
        $sqlmatch = "";
        $segmentid = 0;
        while (1) {
            $segcount++;
            if ($debugReport) $msg .= "segcount = $segcount $iconNext $eol";
            if ($segcount > 140) {
                $msg .= "$errorBeg E#281 Worked on more than 140 segements,
							that seems like to many. $errorEnd
							currntly looking for $iconNext at segment #$segmentid ";
                return $msg;
            }
            if ($iconNext == $iconLast)
                break; // requesteed to stop
            $sqlsement = "select * from $rrw_segments where starticon = '$iconNext'";
            if ($debugReport) $msg .= "  $sqlsement $eol";
            $recsegs = $wpdbExtra->get_resultsA($sqlsement);
            if ($wpdbExtra->num_rows == 0) {
                break; // hopefully we are at the end
            }
            $recseg = $recsegs[0];
            $segmentid = $recseg["segmentid"];
            if (array_key_exists($iconNext, $icondistance)) {
                $recseg["startmiles"] = $icondistance[$iconNext];
            } else {
                $msg .= "$errorBeg E#544 $iconNext does not exist in the trail_mile table.
				<a href='/edit-segment?segmentid=$segmentid&route=$routeid' >Please fix</a>$errorEnd";
                $recseg["startmiles"] = 0;
            }
            if ($wpdbExtra->num_rows == 1) {
                //		$recseg[0]["milepost"] = freewheelingeasy_build_segment_report::displayMP( $mile_iconName, $milesAlongtrail );
                $iconNext = $recseg["endicon"];
                if (array_key_exists($iconNext, $icondistance)) {
                    $recseg["endmiles"] = $icondistance[$iconNext];
                } else {
                    $msg .= "$errorBeg E#739 $iconNext does not exist in the trail_mile table.
					<a href='/edit-segment?segmentid=$segmentid&route=$routeid' >Please fix</a>$errorEnd";
                    $recseg["endmiles"] = 0;
                }
                if ($debugOutput) $msg .= rrwUtil::print_r($recseg, true, "output for one row result");
                $arrayCnt = array_push($outputArray, $recseg);
            } elseif ($wpdbExtra->num_rows > 1) {
                if ($debugFoundTwo) {
                    $msg .= "E#736 got two many matches for iconNext - $iconNext $eol $sqlsement $eol";
                    $msg .= rrwUtil::print_r($recsegs, true, "recsegs");
                }
                $endiconlist = "";
                $numTrys = count($recsegs);
                $NoMatch = true;
                for ($ii = 0; $ii < $numTrys; $ii++) {
                    $endicon = $recsegs[$ii]["endicon"];
                    $endiconlist .= "$endicon, ";
                    $sqlmatch = "select mile_iconName from $rrw_trail_mile where mile_route = '$routeid' and mile_iconName = '$endicon'";
                    $foundEndicon = $wpdbExtra->get_var($sqlmatch);
                    if ($debugFoundTwo) $msg .= "$sqlmatch -- found -- $foundEndicon $eol";
                    if (!is_null($foundEndicon)) {
                        if ($debugFoundTwo) $msg .= "Found match on $ii - $foundEndicon $eol";
                        $NoMatch = false;
                        $recsegs[$ii]["startmiles"] = $icondistance[$iconNext];
                        $iconNext = $foundEndicon;
                        $recsegs[$ii]["endmiles"] = $icondistance[$iconNext];
                        if ($debugOutput) $msg .= rrwUtil::print_r($recsegs[$ii], true, "output for multiple row result");
                        $arrayCnt = array_push($outputArray, $recsegs[$ii]);
                    }
                }
                if ($NoMatch) {
                    $msg .= "$errorBeg E#742 found the following endpoints, '$endiconlist' non of which are in trail_mile $errorEnd";
                    $msg .= freewheelingeasy_build_segment_report::dumpTrail_mile($routeid);
                    break;
                }
            } else {
                return "$msg $errorBeg E#547 never should get here $errorEnd";
            }
            if ($debugReport) $msg .= "just before end while with iconNext = $iconNext $eol";
        } // end while(1)
        if ($segcount < 2) {
            $msg .= "[ $routeName ($routeid) ] <span style='color:red'> E#282 No segment report</span> $eol";
            return $msg;
        }
        if ($iconNext != $iconLast) { // Check that we reachead the endd of the list
            $msg .= "[ $routeName ] $errorBeg E#668 did not end on iconName of '$iconLast'
									<a href='/edit-segment?segmentid=$segmentid&route=$routeid' >Please fix</a>$errorEnd
									$sqlsement $eol $sqlmatch $eol";
        }
        $file = "/segments-json/$routeid.json";
        $outptjson = json_encode($outputArray);
        //     )
        $msg .= freewheeling_WriteUp::saveFile("status-json", "$routeid.json", $outptjson);
        return "$msg";
    }
    static private
    function dumpTrail_mile($routeid)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_trail_mile, $rrw_segments, $rrw_icons;
        $msg = "";
        $sqltrail = "Select mile_iconName, milesalongTrail from $rrw_trail_mile where mile_route = '$routeid'
									order by milesalongTrail";
        $msg .= "$sqltrail $eol ";
        $recTrails = $wpdbExtra->get_resultsA($sqltrail);
        $msg .= "<table>";
        foreach ($recTrails as $recTrail) {
            $msg .= rrwFormat::CellRow($recTrail["mile_iconName"], $recTrail["milesalongTrail"]);
        }
        $msg .= "</table>";
        return $msg;
    }
    static public
    function dumpSegmentData($attr)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_trail_mile, $rrw_segments, $rrw_icons, $rrw_trail_routes;
        $msg = "";
        try {
            $msg .= freeWheeling_edit_setGlobals::setGlobals("dumpSegmentData");
            $route = rrwParam::String("route", $attr);
            if (empty($route)) {
                $sqlRoutes = "select grpid, grpName, grpDescription, linesql
                        from $rrw_trail_routes where is_continuous = 1
                        order by grpName ";
                $recRoutes = $wpdbExtra->get_resultsA($sqlRoutes);
                foreach ($recRoutes as $recRoute) {
                    $routeid = $recRoute["grpid"];
                    $grpName = $recRoute["grpName"];
                    $msg .= "<a href='/segment-dump/?route=$routeid' target='edit'> $grpName </a>$eol";
                }
                return $msg;
            } // end empty route
            $sql = "SELECT starticon, endicon, milesAlongTrail,segmentid
					FROM `$rrw_segments`
					join $rrw_trail_mile on endicon = mile_iconName
					where mile_route = '$route'
					order by milesalongtrail, starticon,endicon";
            $recs = $wpdbExtra->get_resultsA($sql);
            $color = rrwUtil::colorSwap();
            $msg .= "<h2>Report for the route $route created " . date("d M Y h:i A") . "</h2>";
            $msg .= "<table>\n";
            $endicon = $recs[0]["starticon"];
            foreach ($recs as $rec) {
                $color = rrwUtil::colorSwap($color);
                $starticon = $rec["starticon"];
                if (strcmp($starticon, $endicon) != 0)
                    $color = "#F2D7D5";
                $endicon = $rec["endicon"];
                $milesAlongTrail = $rec["milesAlongTrail"];
                $segmentid = $rec["segmentid"];
                $segmentlink = "<a href='https://edit.shaw-weil.com/edit-segment/?segmentid=$segmentid&route=$route&action=edit'> $segmentid</a>";
                $msg .= rrwFormat::CellRow(
                    'style="background-color:' . $color . '"',
                    $starticon,
                    $endicon,
                    $milesAlongTrail,
                    $segmentlink
                );
            }
            $msg .= "<?table>";
        } catch (Exception $e) {
            $msg .= $e->getMessage() . $eol;
        }
        return $msg;
    }   // end dumpSegmentData
    static private
    function displayMP($icon, $distAlong)
    {
        global $milepost;
        if (array_key_exists($icon, $milepost)) {
            return "(MP" . $milepost[$icon] . ")";
        }
        return "(" . $distAlong . " miles from zero)";
    }
} // end class
