<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.com
 *
 */
class freewheelingeasy_surface
{

    static public function buildSurface($attributes)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        global $meters2Mile;
        $msg = "";
        try {
            error_reporting(E_ALL | E_STRICT);
            $debugSurface = true;
            $msg .= freeWheeling_edit_setGlobals::setGlobals("buildSurface");
            if ($debugSurface) $msg .= "edit-surface.php calling param surface $eol";
            $task = rrwParam::String("task", $attributes);
            switch ($task) {
                default:
                    $whereList = freeWheelParam::get_whereLines();
                    $cntTrails = 0;
                    $msg .= "<table>>" . rrwFormat::CellHeaderRow("Trail", "Length Meters", "Length Miles", "accum Miles", "SQL") . "\n";
                    $color = rrwFormat::colorSwap();
                    foreach ($whereList as $trailId => $sqlWhere) {
                        $cntTrails++;
                        $sqlLengthTypes = "select sum(lengthMeters) as subTotal, mapStyle from $wpdbExtra->lines where $sqlWhere group by mapStyle";
                        $lengthTypes = $wpdbExtra->get_resultsA($sqlLengthTypes);
                        $surface = "";
                        $sumMiles = 0;
                        foreach ($lengthTypes as $lengthType) {
                            $subTotal = round($lengthType["subTotal"] / $meters2Mile, 1);
                            $mapStyle = $lengthType["mapStyle"];
                            $surface .= " $subTotal mi.  $mapStyle ,";
                            $sumMiles += $subTotal;
                        }

                        $sqlLength = "select sum(lengthMeters) as total from $wpdbExtra->lines where $sqlWhere";
                        $lengthMeters = $wpdbExtra->get_var($sqlLength);
                        $lengthMiles = round($lengthMeters / $meters2Mile, 1);
                        if ($lengthMiles != $sumMiles) {
                            $sumMiles .= " **";
                        }
                        $color = rrwFormat::colorSwap($color);
                        $msg .= rrwFormat::CellRow($color, $trailId, $lengthMeters, $lengthMiles, $sumMiles, $surface);
                        if ($cntTrails > 20)
                            break;
                    }
                    $msg .= "</table>\n";
                    // $msg .= rrwUtil::print_r($whereList, true, "whereList");
            }
        } catch (Exception $e) {
            $msg .= $errorBeg . $e->getMessage() . $errorEnd;
        }
        return $msg;
    } // end editSurface
} // end class freewheelingeasy_surface
