<?php
//		Freewheeling Easy Mapping Application
//		A collection of routines for display of trail maps and amenities
//  	copyright Roy R Weil 2019 - https://royweil.com
/**
 * Class freewheel_trailHeads
 *
 * A collection of routines for display of trail maps and amenities.
 *
 * 	static private function ListOfAvailableGPSfiles($parkingFile)
 *  public static function iconList($attr)
 *  private static function displayOlcExplanations()
 *  static public function gatherPushTrailHead($attributes)
 */
/**
 * gatherPushTrailHead
 *
 * Outputs a table of trailhead locations including trail name, location name, latitude, longitude, and Open Location Code.
 *
 * @param array $attributes Attributes for gathering trailhead information.
 * @return string HTML table of trailhead locations or an error message.
 */ {
	// Function implementation
}
class freewheel_trailHeads
{
	static public 	function gatherPushTrailHead($attributes)
	{
		/* ----------------------------------------------------
         *   outputs a a table of TrailName, location Name, latitude, longitude, Open Location code
         * file stored on trailHead.html
         */
		global $wpdbExtra;
		global $eol, $errorBeg, $errorEnd;
		global $freewheeling_pagesPreBuiltUrl;
		$msg = "";
		$savedAttributes = $attributes;
		$pass[1] =  "select trId from $wpdbExtra->trails order by mergeSequence,trName";
		$pass[2] = "select grpId trId  from $wpdbExtra->trail_routes order by grpMergeSequence";
		foreach ($pass as $sql) {
			$recsPass = $wpdbExtra->get_resultsA($sql);
			$cnt = 0;
			foreach ($recsPass as $recPass) {
				$cnt++;
				if ($cnt > 5000) {	// prevent run away
					break;
				}
				$trailId = $recPass["trId"];
				$sudoAttributes = $savedAttributes;
				$sudoAttributes["trailId"] = $trailId;
				$msg .= self::gatherPushOneTrailHead($sudoAttributes);
			}
		}
		return $msg;
	} // end function gatherPushTrailHead
	/**
	 * Gathers and outputs a table of trailhead locations.
	 *
	 * This function generates an HTML table displaying trailhead locations, including trail name,
	 * location name, latitude, longitude, and Open Location Code. The data is retrieved from the
	 * database and formatted for display.
	 */
	static public 	function gatherPushOneTrailHead($attributes)
	{
		/* ----------------------------------------------------
         *   outputs a a table of TrailName, location Name, latitude, longitude, Open Location code
         * file stored on trailHead.html
         */
		global $wpdbExtra;
		global $eol, $errorBeg, $errorEnd;
		global $freewheeling_pagesPreBuiltUrl;
			$msg = "";
		$output = "";
		$debugTrailHeads = rrwParam::isDebugMode("trailHeads", true);
		if ($debugTrailHeads) $msg .= "GatherPushTrailHead() $eol";
		$trailIdOrGroupId = freeWheelParam::trail($attributes);
		if (empty($trailIdOrGroupId)) {
			$msg .= "$errorBeg E#570 No trail specified $errorEnd";
			return $msg;
		}
		$placeName = freewheeling_kml_common::get_TrailOrGroupName($trailIdOrGroupId);
		$output .= "<h2>Trailhead location for $placeName</h2>\n";
		$sqlWhere = freewheeling_kml_common::sqlWhereForGroupOrTrailIcons($trailIdOrGroupId);
		$sqlIcons = "select distinct trName, iconId, iconName, milePostPrefix, milepost, isAmenityList, isMileageStep, iconStyle,
							latitude, longitude
                from $wpdbExtra->icons  icon
                join $wpdbExtra->lines line on icon.trailId = line.trailId
				join $wpdbExtra->trails tr on icon.trailId = tr.trId
                    where ($sqlWhere)  and isTrailHead > 0
                    order by icon.trailId,sort, milepost ";
		$msg .= "$sqlIcons $eol";
		$recIcons = $wpdbExtra->get_resultsA($sqlIcons);
		$output .= "<table>";
		$output .= rrwFormat::HeaderRow(
			"Milepost",
			"Amenity Name",
			"location coordinates",
			"show in Icon List",
			"show on mileage chart",
			"steps"
		);
		$color = rrwUtil::colorSwap();
		$trNamePast = "not Yet";
		$cnt = 0;
		foreach ($recIcons as $recIcon) {
			$trName = $recIcon["trName"];
			$iconName = $recIcon["iconName"];
			$iconId = $recIcon["iconId"];
			$milepost = $recIcon["milepost"];
			$isAmenityList = $recIcon["isAmenityList"];
			$isMileageStep = $recIcon["isMileageStep"];
			$iconStyle = $recIcon["iconStyle"];
			$latitude = round($recIcon["latitude"], freeWheel::latRoundTo);
			$longitude = round($recIcon["longitude"], freeWheel::latRoundTo);
			$milePostPrefix = $recIcon["milePostPrefix"];
			$milepost = $recIcon["milepost"];
			$iconDisplay = FreewheelFormat::EditIconLink($iconId, $iconName);
			if (!empty($milepost)) {
				$iconDisplay .= " ($milePostPrefix " . round($milepost, 1) . ")";
			}
			if ($trNamePast == $trName) {
				$output .= rrwFormat::CellHeaderRow($trName, "", "", "", "");
				$trNamePast == $trName;
			}
			$MilepostDisplay = rrwFormat::milePostText($milepost, $milePostPrefix);
			$amenityIs = "
					<form onclick='updateIcon($iconId, check$cnt)' >
					<input type = 'checkbox' id='check$cnt' name='check$cnt'";
			if (1 == $isAmenityList)
				$amenityIs .= " checked='checked' ";
			$amenityIs .= "value='$isAmenityList' >
					</form>";
			$amenityImage = "<img  src=https://freewheelingeasy.com/prebuilt//icon-amenities/$iconStyle' height='16px' >";
			$StepIs = "
					<form onclick='updateIcon($iconId, check$cnt)' >
					<input type = 'checkbox' id='check$cnt' name='check$cnt'";
			if (1 == $isAmenityList)
				$StepIs .= " checked='checked' ";
			$StepIs .= "value='$isAmenityList' >
					</form>";
			$latLngDisplay = "<a href='https://www.google.com/maps/search/$latitude,$longitude' target='map' height='16px' > $latitude, $longitude </a>";
			$color = rrwUtil::colorSwap($color);
			$output .= rrwFormat::CellRow(
				$color,
				$MilepostDisplay,
				$iconDisplay,
				$latLngDisplay,
				$amenityImage,
				$amenityIs,
				$StepIs
			);
		}  // end foreach recIcons
		$output .= "\n</table>";
		$output .= self::displayOlcExplanations();
		$output .= FreewheelingBuildMileageChart::disclaimer();
		$msg .= freewheeling_Writeup::saveFileWithCompare("trailheads-html", "$trailIdOrGroupId-access.html", $output);
		$msg .= $output;
		return $msg;
		/*
		//---------------------------------------------------
		$output .= freewheel_trailHeads::displayOlcExplanations();
		// lineSql is based on routes, so will only get lines associated with route
		$sqlTrailHead = "select  trName, iconId, iconName, latitude, longitude, plusCode, milePostPrefix, milepost
			from $wpdbExtra->icons ic
					left join $wpdbExtra->lines on iconLineId = lineId
            		left join $wpdbExtra->trails on trId = ic.trailId
				where isTrailHead = 1 and ($lineSql)
            order by trSequence, sort ";
		if ($debugTrailHeads) $msg .= "$eol $eol $sqlTrailHead $eol $eol";
		$recTrailHeads = $wpdbExtra->get_resultsA($sqlTrailHead);
		$output .= "<table>";
		$output .= rrwFormat::HeaderRow(
			"Trail Name",
			"location Name",
			"Latitude,Longitude",
			"Open Location Code
                     <a = href='#olcHelp' >
                     <img src='$freewheeling_pagesPreBuiltUrl/images/help-question-mark-24.png'
                     height='16px' width='16px' /></a>"
		);
		$color = rrwUtil::colorSwap();
		$trNamePast = "not Yet";
		$cntGps = 0;
		foreach ($recTrailHeads as $recTrailHead) {
			$cntGps++;
			$trName = $recTrailHead["trName"];
			$iconId = $recTrailHead["iconId"];
			$iconName = $recTrailHead["iconName"];
			$latitude = round($recTrailHead["latitude"], freeWheel::latRoundTo);
			$longitude = round($recTrailHead["longitude"], freeWheel::latRoundTo);
			$milepost = $recTrailHead["milepost"];
			$milePostPrefix = $recTrailHead["milePostPrefix"];
			$iconDisplay = FreewheelFormat::EditIconLink($iconId, $iconName);
			if (!empty($milepost)) {
				$iconDisplay .= " ($milePostPrefix " . round($milepost, 1) . ")";
			}
			$latLngDisplay = "<a href='https://www.google.com/maps/search/" .
				"?api=1&query=$latitude,$longitude&z=14z' >
                        $latitude,$longitude </a>";
			if ($trName != $trNamePast) {
				$output .= rrwFormat::CellHeaderRow($trName, "", "", "", "");
				$trNamePast = $trName;
			}
			$color = rrwUtil::colorSwap($color);
			$output .= rrwFormat::CellRow(
				"style='background-color:$color'",
				$trNameDisplay,
				$iconDisplay,
				"$latLngDisplay",
				$plusCodeDisplay
			);
		}
		$output .= "\n</table>";
		$output .= freewheel_trailHeads::displayOlcExplanations();
		$output .= FreewheelingBuildMileageChart::disclaimer();
		if ($cntGps > 20)
			$output .= "<h2>Trailhead location for $grpName</h2>\n";
		$msg .= "output $cntGps trailheads to  ";
		$msg .= freewheeling_Writeup::saveFileWithCompare("trailheads-html", "$grpId.html", $output);
		return $msg;
		*/
	} // end function gatherPushTrailHead
	/*
	static private
	function ListOfAvailableGPSfiles($parkingFile)
	{
		global $eol, $errorBeg, $errorEnd;
		global $freewheeling_prebuilt_dire;
		$dh = opendir("$freewheeling_prebuilt_dire/gps");
		if ($dh === false) {
			return "$errorBeg E#565 Directory '$freewheeling_prebuilt_dire/gps' was not found.$errorEnd";
		}
		$extList = array();
		while ($filename = readdir($dh)) {
			if ($filename == "." || $filename == "..")
				continue;
			if (strncmp($parkingFile, $filename, strlen($parkingFile)) == 0)
				$extList[] = substr($filename, strlen($parkingFile)); // just get the extent
		}
		asort($extList);
		return $extList;
	}
		*/
	public static function iconList($attr)
	{
		global $eol, $errorBeg, $errorEnd;
		global $wpdbExtra;
		$msg = "";
		$trailId = freeWheelParam::trail($attr);
		if (empty($trailId)) {
			$msg .= "$errorBeg E#540 No trail specified $errorEnd";
			return $msg;
		}
		$sql = "select iconId, iconName, milepost, latitude, longitude, plusCode, isTrailHead
					from $wpdbExtra->icons where " . freeWheelParam::get_WhereTrailId() . " order by milepost";
		$recs = $wpdbExtra->get_resultsA($sql);
		$msg .= "<table>";
		$accessTable = "";
		$msg .= rrwFormat::HeaderRow("Icon Name", "trail head Information");
		$color = rrwUtil::colorSwap();
		foreach ($recs as $rec) {
			$iconId = $rec["iconId"];
			$iconName = $rec["iconName"];
			$milepost = $rec["milepost"];
			$latitude = round($rec["latitude"], 4);		// will get you with 45 feet
			$longitude = round($rec["longitude"], 4);
			$isTrailHead = $rec["isTrailHead"];
			$iconDisplay = FreewheelFormat::EditIconLink($iconId, $iconName);
			$plusCode = $rec["plusCode"];
			//$milepostDisplay = number_format(round($milepost, 1), 1);	// tenth of mile or 500/2 feet
			$milepostDisplay = rrwFormat::milePostText($milepost, "");
			$latLngDisplay = "<a href='https://www.google.com/maps/search/" .
				"?api=1&query=$latitude,$longitude&z=14z' >
						$latitude,$longitude </a>";
			$color = rrwUtil::colorSwap($color);
			$msg .= rrwFormat::CellRow(
				"style='background-color:$color'",
				$iconDisplay,
				" $milepostDisplay ($latitude,$longitude) $milepostDisplay"
			);
			if ($isTrailHead) {
				if (strpos($iconName, "Trailhead") === false)
					$iconNameDisplay = "$iconName Trailhead";
				else
					$iconNameDisplay = $iconName;
				$accessTable .=  "$iconNameDisplay:  $milepostDisplay ($latitude,$longitude), plus code $plusCode <br>";
			}
		} // end foreach
		$msg .= "</table> $eol $accessTable $eol";
		$msg .= freeWheelingBuildBook::getLengthSurfaceLine($trailId);
		return $msg;
	} // end function
	private static
	function displayOlcExplanations()
	{
		global $eol, $errorBeg, $errorEnd;
		return '
	<a name=olc> </a>
<p><a class="external" href="https://en.wikipedia.org/wiki/Open_Location_Code">OLC (Open Location Codes)</a>&nbsp;(aka Plus Codes) are a way of encoding location into a form that is easier to use than providing coordinates in the usual form of <a class="external" title="Latitude" href="https://en.wikipedia.org/wiki/Latitude">latitude</a> and <a class="external" title="Longitude" href="https://en.wikipedia.org/wiki/Longitude">longitude</a>. They are designed to be used like street addresses, and may be especially useful in places where there is no formal system to identify buildings, such a street names, number, and post codes.<sup id="cite_ref-4" class="reference"><a href="https://en.wikipedia.org/wiki/Open_Location_Code#cite_note-4">[4]</a><br />
</sup>Since August 2015, <a title="Google Maps" href="https://en.wikipedia.org/wiki/Google_Maps">Google Maps</a> supports plus codes in the address box.<br />
The <a class="external text" href="https://openlocationcode.com/" rel="nofollow">Open Location Code website</a> provides an overview. The document <a class="external text" href="https://github.com/google/open-location-code/blob/master/docs/comparison.adoc" rel="nofollow">An Evaluation of Location Encoding Systems</a> provides a rationale.</p>
';
	}
} // end class
