<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.com
 */
/*	step through the businesses and find the nearest icon.
 *	update/insert that information into the businessAccess table.
 */
class freewheelingeasy_build_businessAccess
{
    public static function freewheelingeasyBuildBusinessAccess($attributes)
    {
        global $eol, $errorBeg, $errorEnd;
        global $date60daysAgo;
        global $wpdbExtra;
        /*  Update the BusinessAccess table. i.e. assign icons to the various business
     *
     *	if Route or bizId is set
     *		if route information is not set then
     *			Determine the best route to a business location
     * 			use the business latitude, longitude to find closest icon/flag
     *			ask google for a route from there to the business
     * 			update trail latitude, trail longitude, trail milepost, meters from trail
     *	parameters
     *		bizId=		only doo one business
     *		iconId=		do business that are closest to that Icon
     *		trailId=	do business that are closet to the trail collection of icons
     *		route=		determine a route as well
     */
        $msg = "";
        try {
            $msg .= freeWheeling_edit_setGlobals::setGlobals("freewheelingeasy_build_businessAccess");
            if (freeWheeling_edit_setGlobals::notAllowedToEdit("you must be logged in to run this routine "))
                return "$errorBeg E#576 fix routine is not allowed $errorEnd";
            $now = new DateTime();
            $msg .= " Update the BusinessAccess table. i.e. assign mileposts, routes to the various business $eol";
            $action = rrwParam::String("action");
            if (!empty($action)) {
                $msg .= "'action' has been changed to 'task'";
                throw new Exception($msg);
            }
            $task = rrwParam::String("task");
            if ($task == "resetprefix") {
                $msg .= self::freewheelingeasy_reset_milepost($attributes);
                return $msg;
            }
            $bizId = freeWheelParam::business($attributes, false);
            $prefix = rrwParam::String("prefix", $attributes);
            $trailId = freeWheelParam::trail($attributes);
            $check = rrwParam::String("check", $attributes);
            $iconId = freeWheelParam::icon($attributes);
            $msg .= "task = $task, bizId = $bizId, prefix = $prefix, trailId = $trailId, check = $check, iconId = $iconId $eol";
            // set up prefix so we create the correct milepost txt files for access
            $msg .= self::moveDates2Trails();       // update to most current data
            $msg .= "task = $task, bizId = $bizId, prefix = $prefix, trailId = $trailId, check = $check, iconId = $iconId $eol";
            if (!empty($bizId)) {
                $cntSkip = 0;   // count of businesses skipped
                $msg .= "found the parameter bizId $bizId $eol";
                $msg .= self::route_one_bizId($bizId, $cntSkip);
                // need to verify he inserted business launch point.
                $sqlPrefix = "select trailMilepostPrefix from $wpdbExtra->access where accBizId = '$bizId' ";
                $prefix = $wpdbExtra->get_var($sqlPrefix);
            } elseif (!empty($prefix)) {
                $msg .= self::freewheelingeasy_route_one_prefix($attributes, $prefix);
            } elseif (!empty($iconId)) {
                $msg .= "found parameter iconId $iconId $eol";
                $msg .= self::routeOneIconId($iconId);
                /*     } elseif (!empty($trailId)) {
                $msg .= self::freewheelingeasy_route_one_trailId($trailId, $attributes);
                $sqlPrefix = "select trMilepostPrefix from $wpdbExtra->trails where trId = '$trId' ";
                $prefix = $wpdbExtra->get_var($sqlPrefix);
                */
            } else {
                // find something to run
                $sqlDiff = "SELECT trDateNear, trId, trName
                                from $wpdbExtra->trails
                                where '" . freewheelFormat::get_staleDate()  . "' > trDateRouted  and not (trDateRouted is null || trDateRouted = '')
                                order by mergeSequence, trDateNear ";
                $msg .= "looking for a trail to process $sqlDiff $eol";
                $recDiff = $wpdbExtra->get_resultsA($sqlDiff);
                $msg .= "found " . count($recDiff) . " trails to process $eol";
                if (0 == $wpdbExtra->num_rows) {
                    $msg .= "$errorBeg E#773 Did not find any trails to process $errorEnd $sqlDiff $eol";
                    $msg .= freewheelFormat::taskCompleted("Build Accesses");
                    return $msg;
                }
                foreach ($recDiff as $rec) {
                    $trailId = $rec["trId"]; // do one trail
                    $msg .= "I#778 process one trail  $trailId";
                    // next may or may not update the trDateNear
                    $msg .= self::freewheelingeasy_route_one_trailId($trailId, $attributes);
                    $msg .= "I#423 Processed Done one trail $trailId $eol"; // only do one trail
                } // end foreach ($recDiff as $rec)
            }
        } catch (Exception $ex) {
            $msg .=  $ex->getMessage() . "Bottom of freewheelingeasy_build_businessAccess E#350
            look further for the error $eol";
        }
        $msg .= self::moveDates2Trails();       // update to most current data
        return $msg;
    } // end of freewheelingeasy_build_businessAccess
    public static function moveDates2Trails()
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        try {
            $debugIcon = rrwParam::isDebugMode("debugIcon");
            $debugAccess = rrwParam::isDebugMode("debugAccess");
            $debugTrail = rrwParam::isDebugMode("debugTrail");
            $date55daysAgo = date("Y-m-d", strtotime("-55 days"));
            if ($debugAccess) $msg .= "date55daysAgo is $date55daysAgo $eol";
            $sqlDiff = "SELECT min(icDateNear) minDate, max(icDateNear) maxDate, trailId, trDateNear
                                FROM $wpdbExtra->icons
                                join $wpdbExtra->trails  on trId = trailId
                                group by trailId ";
            if ($debugIcon) {
                $msg .= " // ---------------------------------------------------------------------------------  date_near icon to trail";
                $msg .= " $sqlDiff $eol";
            }
            // Note: trails with no icons will not be here
            $recDiff = $wpdbExtra->get_resultsA($sqlDiff);
            if ($debugIcon) $msg .= "found " . count($recDiff) . " trails to process for updating Date Near $eol";
            foreach ($recDiff as $rec) {
                $trailId = $rec["trailId"];
                $newDate = $rec["minDate"];             // new minimum date for any icon that is on the trail
                $errors = $rec["maxDate"];              // stuff that is not a number
                $trDateNear = $rec["trDateNear"];       // existing trail date
                if ("2" != substr($errors, 0, 1))
                    $newDate = $errors;
                if ($newDate != $trDateNear) {          // update the trail date// is the date different
                    $msg .= freewheelFormat::setStatus($newDate, "trailNear", $trailId);
                    if ($debugIcon) {
                        //               $msg .= "$sqlUpdateNear $eol";
                        $msg .= "I#533 icon date near new $newDate != $trDateNear not equal for $trailId trail  $eol";
                    }
                    continue;
                }
            } // end foreach ($recDiff as $rec)
            $sqlTrail = "select trId, trDateNear, mergeSequence, mergeStatus from $wpdbExtra->trails ";  // handle no icon or error case
            $recTrails = $wpdbExtra->get_resultsA($sqlTrail);
            if ($debugTrail) $msg .= "found " . count($recTrails) . " trails to process for updating Date Near $eol";
            foreach ($recTrails as $recTrail) {
                $trailId = $recTrail["trId"];
                $trDateNear = $recTrail["trDateNear"];
                $mergeSequence = $recTrail["mergeSequence"];
                $mergeStatus = $recTrail["mergeStatus"];
                if (strpos($mergeStatus, "error") !== false) {
                    $msg .= freewheelFormat::setStatus("error merge= $mergeStatus ", "trailNear", $trailId);
                    continue;
                }
                if ($mergeSequence > 99000) {
                    $msg .= freewheelFormat::setStatus("not Yet merge= $mergeSequence ", "trailNear", $trailId);
                    continue;
                }
            } // end foreach ($recTrails as $recTrail)
            // TODO deal with trails that have no icons.??? maybe in the distance routine when "accepted"
            if ($debugAccess) {
                $msg .= "    // ------------------------------------------------------------------ date access Routed to business $eol";
                $msg .= "update business from access $eol";
            }
            $sqlBiz = "update $wpdbExtra->business set bizDateRouted = accDateRouted
                                join $wpdbExtra->access on bizId = accBizId ";              // set biz rouetes to access routed
            $today = date("Y-m-d");
            $staleDate = freewheelFormat::get_staleDate();
            $sqlAlreadyRouted =  "update $wpdbExtra->access set accDateRouted = concat('$today', 'changed<|',  accDateRouted, ' to $today')
                                where '$staleDate' >accDateRouted and coalesce(trailMilepostPrefix, '') != '' and coalesce(trailMilepost,'') != '';";
            $cnt = $wpdbExtra->query($sqlAlreadyRouted);
            $msg .= " I#242 $sqlAlreadyRouted -- update $cnt entires $eol";
            $msg .= "$sqlBiz $eol";
            // $cnt = $wpdbExtra->query($sqlBiz);
            if ($debugAccess) $msg .= "    // -------------------------------------------------------------------------------- date access Routed to icon $eol";
            $msg .= freewheelingEasy_setIconRange::setIconRange(); // update the icon display ranges
            $now = date("Y-m-d") . " no amen";           // those icons that have no amen range, and  therefor will have no associated Access
            $sqlNonAdmen = "update $wpdbExtra->icons set icDateRouted = '$now'
                            where not onMap like '%amen%' ";
            if ($debugAccess) $msg .= "I#243 $sqlNonAdmen $eol";
            $cnt = $wpdbExtra->query($sqlNonAdmen);
            // step though the icons, use milepostPrefix and milepost range to update the icons date routed
            $sqlIcons = "select iconId,iconName, mileDisplayStart, mileDisplayEnd, milepostPrefix, icDateRouted
                            from $wpdbExtra->icons where onMap like '%amen%' and mileDisplayStart != mileDisplayEnd ";
            $recIcons = $wpdbExtra->get_resultsA($sqlIcons);
            if ($debugAccess) $msg .= "I#257 found $wpdbExtra->num_rows amen icons to update with $sqlIcons $eol";
            foreach ($recIcons as $recIcon) {
                $iconId = $recIcon["iconId"];
                $iconName = $recIcon["iconName"];
                $mileDisplayStart = $recIcon["mileDisplayStart"];
                $mileDisplayEnd = $recIcon["mileDisplayEnd"];
                $milepostPrefix = $recIcon["milepostPrefix"];
                $icDateRouted = $recIcon["icDateRouted"];
                if ($mileDisplayStart == $mileDisplayEnd) {
                    if ($debugAccess) $msg .= "I#774 icon $iconName has no milepost range $mileDisplayStart == $mileDisplayEnd $eol";
                    continue;
                }
                // now set each icons routed date from the access records based on the milepost prefix, and milepost
                $sqlDates = " select Max(accDateRouted) errors, min(accDateRouted) newDate
                                from $wpdbExtra->access
                                where trailMilepostPrefix  = '$milepostPrefix' and
                                        TrailMilepost >= '$mileDisplayStart' and TrailMilepost <= '$mileDisplayEnd' ";
                $recDates = $wpdbExtra->get_resultsA($sqlDates);
                if ($debugAccess) {
                    $msg .= "$iconName  -- $sqlDates $eol";
                    $msg .= "found " . count($recDates) . " dates to process for updating $iconName Date Route $eol";
                }
                if (0 == count($recDates)) {
                    $msg .= "I#788 no dates found for $iconName $eol"; // nothing in the town, set so it gets a try again five days from now
                    $sqlUpdateDate = "update $wpdbExtra->icons set icDateRouted = '$date55daysAgo' where iconId = '$iconId' ";
                    if ($debugAccess) $msg .= $sqlUpdateDate . $eol;
                    $wpdbExtra->query($sqlUpdateDate);
                    continue; // next icon
                }
                foreach ($recDates as $recDate) {       // looping thru access records
                    $newDate = $recDate["newDate"];
                    $errors = $recDate["errors"];
                    if (empty($errors) || is_null($errors)) {
                        continue;
                    }
                    if ($debugAccess) $msg .= "I#781 icon $iconName new date $newDate, existing $icDateRouted $eol $sqlDates $eol";
                    if ("2" != substr($errors, 0, 1))
                        $newDate = $errors;
                    if (empty($newDate) || is_null($newDate)) {
                        if ($debugAccess) $msg .= "I#782 null date found for $iconName $eol"; // nothing in the town, set so it gets a try again five days from now
                        $newDate = $date55daysAgo;  // nothing in the town, set so it gets a try again five days from now
                        $icDateRouted = "2000-01-01"; // not there force to recreate
                    }
                    if ($newDate != $icDateRouted) {
                        if ($debugAccess) $msg .= "I#776 date being updated to $newDate $eol";
                        $sqlUpdateDate = "update $wpdbExtra->icons set icDateRouted = '$newDate' where iconId = '$iconId' ";
                        if ($debugAccess) $msg .= $sqlUpdateDate . $eol;
                        $wpdbExtra->query($sqlUpdateDate);
                    }
                } // end foreach ($recDates as $recDate)
            } // end foreach ($recIcons as $recIcon)
            // now catch the icons that have no business within the range
            if ($debugTrail) $msg .= "// --------------------------------------------------------------------------------- date_route icon to trail";
            $sqlDiff = "SELECT max(icDateRouted) error, min(icDateRouted) newDate, trId, trDateRouted
                                FROM $wpdbExtra->icons
                                join $wpdbExtra->trails  on trId = trailId
                                group by trId ";
            $recDiff = $wpdbExtra->get_resultsA($sqlDiff);
            if ($debugTrail) $msg .= "found " . count($recDiff) . " trails to process with $sqlDiff $eol";
            foreach ($recDiff as $rec) {
                $trailId = $rec["trId"];
                $newDate = $rec["newDate"];
                $error = $rec["error"];
                $trDateRouted = $rec["trDateRouted"];
                if ($debugTrail) $msg .= "I#323 trail $trailId new $newDate, existing $trDateRouted $eol";
                if ($newDate != $trDateRouted) {
                    $sqlUpDateRouted = "update $wpdbExtra->trails set trDateRouted = '$newDate' where trId = '$trailId' ";
                    $wpdbExtra->query($sqlUpDateRouted);
                    if ($debugTrail) $msg .= "I#324  $trailId with $newDate $eol";
                    continue;
                }
            } // end foreach ($recDiff as $rec)
            // now deal  with previous step not done
            $sqlMerge = "select mergeStatus, trId from $wpdbExtra->mergeStatus
                            where mergeStatus like '%error%' or mergeStatus like '%not%' or mergeStatus like '%inProgress%'
                            order by trId ";
            $msg .= "sqlMerge $sqlMerge $eol";
            $recMerges = $wpdbExtra->get_resultsA($sqlMerge);
            foreach ($recMerges as $recMerge) {
                $mergeStatus = $recMerge["mergeStatus"];
                $trailId = $recMerge["trId"];
                $msg .= freewheelFormat::setStatus("$mergeStatus ", "trailNear", $trailId);
                $msg .= freewheelFormat::setStatus("$mergeStatus ", "trailRouted", $trailId);
            } // end foreach ($recMerges as $recMerge)
            $sqlNear = "select trDateNear, trId from $wpdbExtra->mergeStatus
                            where trDateNear like '%error%' or trDateNear like '%not%'  or trDateNear like '%inProgress%'
                            order by trId ";
            $recNears = $wpdbExtra->get_resultsA($sqlNear);
            foreach ($recNears as $recNear) {
                $trDateNear = $recNear["trDateNear"];
                $trailId = $recNear["trId"];
                $msg .= freewheelFormat::setStatus("$trDateNear ", "trailRouted", $trailId);
            } // end foreach ($recNears as $recNear)
        } catch (Exception $ex) {
            $msgErr = "$errorBeg E#328 at bottom of moveDates2Trails " . $ex->getMessage() . $errorEnd;
            throw new Exception($msg . $ex->getMessage() . $msgErr);
        }
        return $msg;
    }
    private static function freewheelingeasy_route_one_prefix($attr, $prefix)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        global $date60daysAgo;
        $debugOneRoute = false;
        $msg = "";
        try {
            $msg .= "<h2>Looking for a icons with prefix $prefix</h2>$eol";
            $sqlPrefix = "select iconId from $wpdbExtra->icons
            where milepostPrefix = '$prefix'
             order by milepost ";
            $recPrefixes = $wpdbExtra->get_resultsA($sqlPrefix);
            if ($wpdbExtra->num_rows == 0)
                $msg .= "$msg $errorBeg E#294 Did not find any icons with prefix $prefix
                        $errorEnd $sqlPrefix $eol";
            $prefixCnt = 0;
            foreach ($recPrefixes as $recPrefix) {
                $prefixCnt++;
                if ($prefixCnt > 50)
                    break;
                $msg .= self::routeOneIconId($attr, $recPrefix["iconId"]);
                return $msg;    // route just one icon
            }
        } catch (Exception $ex) {
            $msgErr = "$errorBeg E#870 at bottom of freewheelingeasy_route_one_prefix " . $ex->getMessage() . $errorEnd;
            throw new Exception($msg . $ex->getMessage() . $msgErr);
            return $msg;
        }
    }
    private static function freewheelingeasy_route_one_trailId($trailId, $attribute)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        global $date60daysAgo;
        $msg = "";
        try {
            $debugOneTrail = rrwParam::isDebugMode("debugOneTrail");
            $force = rrwParam::Boolean("force");
            $sqlWhere = " trailId = '$trailId' ";
            $msg .= "<h2>I#670 Looking for a business along $trailId </h2>$eol";
            $sqlTrail = "select distinct iconId, iconName, icDateRouted
                from $wpdbExtra->icons where $sqlWhere
                and '" . freewheelFormat::get_staleDate() . "' > icDateRouted and not ( icDateRouted is null || icDateRouted = '' ) ";
            if ($debugOneTrail) $msg .= " $sqlTrail $eol";
            $recIcons = $wpdbExtra->get_resultsA($sqlTrail);
            $numIconsToProcess = $wpdbExtra->num_rows;
            $msg .= "I#801 found $numIconsToProcess icons to process $eol";
            if ($wpdbExtra->num_rows == 0) {
                $msg .= "$errorBeg E#596 Did not find any icons to process using VVVVVV $errorEnd $sqlTrail $eol";
                $msg .= self::moveDates2Trails();
                $msg .= freewheelFormat::taskCompleted("access create ");
                return $msg;
            }
            $iconListDone = "";
            $iconCnt = 0;
            foreach ($recIcons as $recIcon) {
                $iconId = $recIcon["iconId"];
                $iconName = $recIcon["iconName"];
                $trDateRouted = $recIcon["icDateRouted"];
                if (empty($trDateRouted)) $trDateRouted = "2000-01-01"; // not there force to recreate
                $iiTwo = strpos($trDateRouted, "2");
                $dateRoutedClean = substr($trDateRouted, $iiTwo, 10);
                $dateRoutedClean = new DateTime($dateRoutedClean);
                $days = $dateRoutedClean->diff(new DateTime())->days;
                if ($force || $days  > 60) {
                    $msg .= self::routeOneIconId($iconId, $attribute);
                } else {
                    $iconListDone .= "$iconName $days days ago,";
                }
                if (rrwUtil::isTimeUp(12)) {
                    $msg .=  rrwUtil::TimeUpMessage(
                        "E#560",
                        "icon loop along trail $trailId",
                        "https://edit.shaw-weil.com/businessaccess/?id=$trailId"
                    );
                    break;
                } // end if ( rrwUtil::isTimeUp
                else {
                    $iconListDone .= "$iconName, ";
                } //
                $msg .= "I#348 Processed $iconCnt of $numIconsToProcess icons , $iconListDone on trail $trailId $eol";
            } // end foreach ( recIcons as recIcon )
        } catch (Exception $ex) {
            throw new Exception($msg . $ex->getMessage() . "$errorBeg E#327 at bottom of freewheelingeasy_route_one_trailId $errorEnd");
        }
        return $msg;
    } // end function freewheelingeasy_route_one_Sql($trailId)
    private static function freewheelingeasy_route_one_lineId($lineId)
    {
        global $eol, $errorBeg, $errorEnd;
        return "freewheelingeasy_route_one_lineId( $lineId) not implemented yet $eol";
    } // end function freewheelingeasy_route_one_lineId
    private static function routeOneIconId($iconId, $attribute = array())
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        global $meters2Mile, $freewheel_degrees2Meters;
        $milesLimit = 10;
        $msg = "";
        $debugOneIcon = rrwParam::isDebugMode("debugOneIcon");
        $cntDist = 0;
        try {
            $msg .= self::moveDates2Trails();    // update to most current data// get current values
            $force = rrwParam::Boolean("force");
            $sqlIcon = "select trailId, iconName, latitude, longitude, icDateNear
                               from $wpdbExtra->icons where iconId = '$iconId'";
            if ($debugOneIcon) $msg .= "$sqlIcon $eol";
            $recIcons = $wpdbExtra->get_resultsA($sqlIcon);
            if ($wpdbExtra->num_rows != 1)
                throw new Exception("$msg E#449 found $wpdbExtra->num_rows icons, expected one $errorEnd
                                $sqlIcon $eol");
            $recIcon = $recIcons[0];
            $iconName = $recIcon["iconName"];
            $latitude = $recIcon["latitude"];
            $longitude = $recIcon["longitude"];
            $trailIdIcon = $recIcon["trailId"];
            $icDateNear = $recIcon["icDateNear"];
            $msg .= "$eol<h1>route $iconName</h1> $eol $eol";
            if ($debugOneIcon) $msg .= "iconName = $iconName, latitude = $latitude, longitude = $longitude, $icDateNear $eol";
            $beginTime = new DateTime();
            $displayTime = $beginTime->format('Y-m-d H:i:s');
            $msg .= "I#795 processing - $iconName
            <a href='/google-map/?iconName=$iconName' >$iconName</a> last Updated $icDateNear $displayTime $eol";
            // get the closest business
            // looking for businesses with in 10 miles of the icon
            // that have no access information for this icons trailid
            $degrees4TenMiles = FreewheelFormat::get_degrees4TenMiles($milesLimit);
            $staleDate = FreewheelFormat::get_staleDate();
            $sqlBusinesses = "select distinct bizId, bizName, bizLat, bizLng, trailMilepostPrefix,
                        trailMilepost, trail2bizRoute, metersToTrail, bizDateRouted,
			    ST_Distance(Point(bizLat, bizLng), Point($latitude,$longitude) ) distanceDegrees
                        from $wpdbExtra->business
                        left  join $wpdbExtra->access on bizId = accBizId
			        where bizUsed > 0 and bizLat is not null
                        and ST_Distance(Point(bizLat, bizLng), Point($latitude,$longitude) ) < $degrees4TenMiles
                        and (bizDateRouted = '' or bizDateRouted < '$staleDate')
			order by ST_Distance(Point(bizLat, bizLng), Point($latitude,$longitude) ) asc ";
            if ($debugOneIcon);
            $msg .= "$sqlBusinesses $eol";
            $recs2Process = $wpdbExtra->get_resultsA($sqlBusinesses);
            $numberOfBusinessFoundLastTine = $wpdbExtra->num_rows;
            $msg .= "I#531found  $numberOfBusinessFoundLastTine businesses to look at around $iconName
                with in $milesLimit miles $eol";
            if ($numberOfBusinessFoundLastTine == 0) {
                $msg .= "no more businesses found to look at around $iconName $eol";
                $msg .= self::moveDates2Trails();    // update to most current data// get current values
                return $msg;
            }
            $cntDist = 0;
            $msg .= "loopThroughTheBusinesses(recs2Process, $trailIdIcon, $latitude, $longitude, $iconId, $iconName, $milesLimit, attribute);$eol";
            $msg .= self::loopThroughTheBusinesses($recs2Process, $trailIdIcon, $latitude, $longitude, $iconId, $iconName, $milesLimit, $attribute, $cntDist);
            // we maybe finished the icon, maybe just ran out of time - do not update did_routing
            if (rrwUtil::isTimeUp(freewheelingEasy_fix_Class::checkLoopingTimeOut)) {    // did the for loop run out of time? i.e. fif not process all the businesses
                $errMsg = rrwUtil::TimeUpMessage(
                    "E#277",
                    "with in route_one_bizId",
                    "https://edit.shaw-weil.com/businessaccess/?iconId=$iconId"
                );
                throw new Exception($errMsg);
            }
            $msg .=
                $msg .= self::moveDates2Trails();    // update to most current data// get current values
            $msg .= "update icon $iconName as done $eol [ " .
                freeWheelFormat::EditIconLink($iconId, $iconName) . "] $eol";
            $msg .= "processed $cntDist business with in $milesLimit miles of
                [ " . freeWheelFormat::iconIdMapLink($iconId, $iconName) . "]
				[ " . freeWheelFormat::EditIconLink($iconId, $iconName) . $eol;
        } catch (Exception $ex) {
            $msg .= "$eol processed $cntDist business before termination";
            $msg .= freewheeling_Google_Costs::googleCosts();
            $msg .= "$errorBeg E#582 catch in freewheelingeasy_route_one_iconId $errorEnd" . $ex->getMessage() . $eol;
            $sqlError = "update $wpdbExtra->icons set icDateNear = '3000-01-03 route error' where iconId = '$iconId' ";
            $wpdbExtra->query($sqlError);
            throw new Exception($msg);
        }
        return $msg;
    } // end function freewheelingeasy_route_one_iconId
    private static function loopThroughTheBusinesses($recs2Process, $trailIdIcon, $latitude, $longitude, $iconId, $iconName, $milesLimit, $attribute, &$cntDist)
    {
        global $eol, $errorBeg, $errorEnd;
        global $meters2Mile;
        $msg = "";
        try {
            $debugManyBiz = rrwParam::isDebugMode("debugManyBiz");
            if ($debugManyBiz) $msg .= "loopThroughTheBusinesses with " . count($recs2Process) . " business to process $eol";
            $cntDist = 0;
            $cntSkip = 0;
            $bizProcessed = "";
            $staleDate = freewheelFormat::get_staleDate();
            foreach ($recs2Process as $recBiz) {
                $cntDist++;
                $bizId = $recBiz["bizId"];
                $bizName = $recBiz["bizName"];
                $bizProcessed .= "$bizName, ";
                $distanceDegrees = $recBiz["distanceDegrees"];
                $trailMilepost = $recBiz["trailMilepost"];
                $trailMilepostPrefix = $recBiz["trailMilepostPrefix"];
                $trail2bizRoute = $recBiz["trail2bizRoute"];
                $bizDateRouted = $recBiz["bizDateRouted"];
                $bizLat = $recBiz["bizLat"];
                $bizLng = $recBiz["bizLng"];
                $miles2trail = $recBiz["metersToTrail"] / $meters2Mile;
                if (!empty($trailMilepostPrefix) && !empty($trail2bizRoute)) {  // any route is a good route
                    if ('$staleDate' < $bizDateRouted) {
                        $msg .= "$errorBeg E#614 Business '$bizName' was already routed on $bizDateRouted $errorEnd $eol";
                        $today = date("Y-m-d");
                        $msg .= self::set_bizRouted("$today changed $bizDateRouted to $today", $bizId);
                        $msg .= insertIntoHistory($bizId, "changed trail2bizRoute $bizDateRouted to  $today", "");
                        continue;
                    } else {
                        $bizNameLink = freeWheelFormat::BizLink($bizId);
                        $msg .= "I#717 Business '$bizNameLink' has already
                                been processed on $bizDateRouted giving
                                $trailMilepostPrefix $trailMilepost - $miles2trail " .
                            freeWheelFormat::bizIDMapLink($bizId) . "$eol";
                        $cntSkip++;
                        continue;
                    } // end if ('$staleDate' < $bizDateRouted)
                } // end if ( !empty( trailMilepostPrefix ) ) {
                $miles = freewheeling_calculations::distanceMeters($latitude, $longitude, $bizLat, $bizLng) / $meters2Mile;
                if ($miles > $milesLimit) {
                    $msg .= "Straight line distance $bizName to $iconName is $miles done $eol ";
                    $msg .= self::set_bizRouted("too far", $bizId);
                    $cntSkip++;
                    continue; // we are done looking at this record, try the next
                }
                $cntSkip = 0;
                if ($debugManyBiz) $msg .= "I#627 route_one_bizId($bizId, $cntSkip) $eol";
                $msg .= self::route_one_bizId($bizId, $cntSkip);
                if (rrwUtil::isTimeUp(freewheelingEasy_fix_Class::$checkLoopingTimeOut)) {
                    $msg .= "Time up after routing one bizId "; // msg will appear before the update of the icon
                    break;
                } // end if ( rrwUtil::isTimeUp(12) )
            } // end foreach ( $recs2Process as $recBiz )
            $msg .= "loopThroughTheBusinesses processed $cntDist business, skipped $cntSkip   $eol";
            return $msg;
        } catch (Exception $ex) {
            $msg .= "loopThroughTheBusinesses processed $cntDist business, skipped $cntSkip   $eol";
            $msgErr = "$errorBeg E#307 at the bottom of loopThroughTheBusinesses $errorEnd" . $ex->getMessage() . $eol;
            throw new Exception($msg . $msgErr);
        }
        return $msg;
    } // end function loopThroughTheBusinesses
    public static function set_bizRouted($status, $bizId)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $statusDisplay = $status . " " . date("Y-m-d");
        $sqlUpdate = "update $wpdbExtra->business set bizDateRouted = '$statusDisplay' where bizId = '$bizId' ";
        $wpdbExtra->query($sqlUpdate);
        //$msg .= "updated $sqlUpdate $eol";
        return $msg;
    }
    public static function set_accessRouted($status, $accId)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $statusDisplay = $status . " " . date("Y-m-d");
        $sqlUpdate = "update $wpdbExtra->access set accDateRouted = '$statusDisplay' where accId = '$accId' ";
        $wpdbExtra->query($sqlUpdate);
        //$msg .= "updated $sqlUpdate $eol";
        return $msg;
    }
    public static function route_one_bizId($bizId, &$cntSkip)
    {
        /*
     *	parameters
     *		direction is either "NorthSouth", "SouthNorth, WestEast, or "eastWest"
     *				indicating which direction the mileposts go.
     */
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        global $meters2Mile;
        /* 	use the business latitude, longitude to find the ten closest icon/flag
     *	ask google for a route from there to the business
     *  use the google distance, minus any of the first few legs along a trail
     * 	create/update access data - trail latitude, trail longitude, trailMilepost, meters from trail
     *
     */
        $bizLink = freeWheelFormat::BizLink($bizId);
        try {
            $msg = "I#509 starting route_one_bizId($bizId) $bizLink " . str_repeat("-", 40) . $eol;
            $debugBizId = rrwParam::isDebugMode("debugBizId");
            $debugTraverse = rrwParam::isDebugMode("debugTraverse");
            $debugLoop = rrwParam::isDebugMode("debugLoop");
            $debugLoop2 = rrwParam::isDebugMode("debugLoop2");
            $forced = rrwParam::Boolean("force");
            $forced = rrwParam::Boolean("replace") || $forced;  //  either force or replace
            $sqlBusiness = "select bizDateRouted, bizName, bizLat, bizLng  from $wpdbExtra->business where bizId = '$bizId' ";
            if ($debugBizId) $msg .= "$sqlBusiness $eol";
            $recsBusiness = $wpdbExtra->get_resultsA($sqlBusiness);
            if ($debugBizId) $msg .= rrwUtil::print_r($recsBusiness, true, "recsBusiness");
            if (0 == $wpdbExtra->num_rows) {
                $msg .= "$errorBeg E#577 Asked to route a non-existing business entry($bizId)  $errorEnd $sqlBusiness $eol";
                throw new Exception($msg);
            } // end if ( 0 ==wpdbExtra-num_rows )
            if (!$forced) {
                try {
                    $dateRouted = $recsBusiness[0]["bizDateRouted"];
                    if ($debugBizId) $msg .= "bizDateRouted = '$dateRouted' $eol";
                    if (empty($dateRouted) || is_null($dateRouted)) {
                        $days = 100;    // force a recalculate
                    } else {
                        $iiTwo = strpos($dateRouted, "2");
                        $DateRoutedTime = substr($dateRouted, $iiTwo, 10);
                        $DateRoutedTime = new DateTime($DateRoutedTime);
                        $days = $DateRoutedTime->diff(new DateTime())->days;
                    }
                } catch (Exception $ex) {
                    $msg .= "$errorBeg E#373 routing business entry($bizId) - bad last routed date source -'$dateRouted'
                                cleaned $DateRoutedTime $errorEnd";
                    $days = 100;    // force a recalculate
                }
                if ($days < 60) {
                    $msg .= "I#631 business $bizLink was routed $days days ago, skip $eol";
                    $cntSkip++;
                    return $msg;
                } // end if ( $days < 60 )
            } // end if ( ! $forced )
            // okay, we are going to route this business
            $maxUsedLoop = 0;
            // not yet done for this trail:icon
            $sqlDelAccess = "delete from $wpdbExtra->access where accBizId = '$bizId' ";
            $wpdbExtra->query($sqlDelAccess);   // delete the old access information
            if ($wpdbExtra->num_rows != 1) {
                $msg .= "$errorBeg E#346 found $wpdbExtra->num_rows business, expected one $errorEnd $sqlBusiness $eol";
                return $msg;
            }
            $bizName = $recsBusiness[0]["bizName"];
            $bizLat = $recsBusiness[0]["bizLat"];
            $bizLng = $recsBusiness[0]["bizLng"];
            $bizLink = freeWheelFormat::bizIdMapLink($bizId, $bizName) . freeWheelFormat::BizLink($bizId);
            $msg .= "I#525 processing trailId biz Id $bizId, $bizLink $eol";
            $recIcons = self::closePointsOnTrails($bizLink, $bizLat, $bizLng, $msg);
            $msg .= "there are " . count($recIcons) . " icons with in some distance of the business, order by straight line distance $eol";
            if (count($recIcons) == 0) {
                $msg .= "$errorBeg E#516 no close by found to $bizLink $errorEnd";
                $msg .= self::freewheeling_setbizUsed($bizId, "maybe to far");
                return $msg;
            }
            if ($debugTraverse) $msg .= "found " . count($recIcons) . " icons close to $bizName $eol";
            $loop = 0;
            $distAnswerMin = array();
            $currentMinMeters = $meters2Mile * 50; //start with a big number
            foreach ($recIcons as $recsIcon) {
                $loop++;
                if ($currentMinMeters < 1) {
                    $msg .= "I#664 loop #$loop currentMinMeters $currentMinMeters is close enough, so done $eol";
                    break;
                }
                if ($loop > 20) {
                    $msg .= "loop $loop is too many, stopping $eol";
                    break;
                }
                if ($loop > $maxUsedLoop) {
                    $maxUsedLoop = $loop;
                }
                // assert milepost is not null, via sql
                // assert milePostPrefix is not null/blank via "check for icon miles"
                // $recIcon is a list of nearby icons in order of distance
                $milePostPrefix = $recsIcon["milePostPrefix"];
                $iconName = $recsIcon["iconName"];
                $iconMilepost = $recsIcon["milepost"];
                $iconLat = $recsIcon["latitude"];
                $iconLng = $recsIcon["longitude"];
                $distanceMetersStraight = $recsIcon["distanceMeters"];
                $msg .= "loop #$loop - $milePostPrefix - $iconMilepost
                            current <strong>$currentMinMeters</strong>, strong>distance = <strong>$distanceMetersStraight</strong>";
                if ($currentMinMeters < $distanceMetersStraight) {
                    $link = freewheelFormat::latitudeMapLink($iconLat, $iconLng, "$iconLat, $iconLng");
                    if ($debugLoop2 || $debugLoop);
                    $msg .= " &nbsp;  &nbsp; &nbsp;- straight line bigger than current, so done $iconName, $link, no route request $eol";
                    break;
                }
                // do the calculation.
                $trailId = $recsIcon["trailId"];
                $distAnswer = getGoogleRoute($iconLat, $iconLng, $bizLat, $bizLng, $bizId, "bicycling", $msg, "route_one_bizId");
                if ($debugTraverse) {
                    $msg .= "I#792 route_one_bizId::getGoogleRoute($iconLat, $iconLng, $bizLat, $bizLng, $bizId, bicycling, msg) $eol";
                    $msg .= rrwUtil::print_r($distAnswer, true, "I#793 from getGoogleRoute distAnswer loop #$loop ");
                }
                if ($debugBizId) $msg .= $distAnswer["steps"];
                if ($debugTraverse) {
                    $distAnswerNoLegs = $distAnswer;
                    $distAnswerNoLegs["legs"] = "not shown";
                    //     $msg .= rrwUtil::print_r($distAnswerNoLegs, true, "distAnswerNoLegs loop #$loop");
                }
                $distanceMeters = $distAnswer["distanceMeters"] + $distAnswer["trailmeters"]; // total distance the icon to the business
                if ($currentMinMeters == $distanceMeters) {
                    $msg .= " I#249 loop #$loop distanceMeters = $distanceMeters same route, so ignore it $eol ";
                    continue;
                }
                if ($currentMinMeters < $distanceMeters) {
                    $msg .= " I#694 loop #$loop distanceMeters = $distanceMeters previous was shorter $eol";
                    continue;
                }
                if ($debugLoop) {
                    $link = freewheelFormat::latitudeMapLink($iconLat, $iconLng, "$iconLat, $iconLng");
                    $msg .= "loop #$loop - prefix $milePostPrefix, mileposts $iconMilepost,
                                current $currentMinMeters &gt; route line $distanceMeters - not yet smaller, try again $eol";
                }
                if ($loop > $maxUsedLoop) {
                    $maxUsedLoop = $loop;
                }
                $msg .= " I#794 loop #$loop distanceMeters = $distanceMeters this is shorter, so save $eol";
                $currentMinMeters =  $distanceMeters;  // save the new result found so far
                $distAnswerMin = $distAnswer;
                $distAnswerMin["iconMilepost"] = $iconMilepost;
                $distAnswerMin["milePostPrefix"] = $milePostPrefix;
                $distAnswerMin["trailId"] = $trailId;
                $distAnswerMin["routeLatLon"] = $distAnswer["routeLatLon"];
                $distAnswerMin["routePolyline"] = $distAnswer["routePolyline"];
            } // end foreach ( $recIcons as $recsIcon )
            // assert that the distAnswerMin has the information that we need to update the access table
            if (0 == count($distAnswerMin)) {
                $msg .= "#E1014 no minium distance found for $bizName $eol";
                throw new Exception($msg);
            }
            $trailmeters = $distAnswerMin["trailmeters"];
            $bizMilepost = $distAnswerMin["iconMilepost"];
            $trailLatitude = $distAnswerMin["startLat"];
            $trailLongitude = $distAnswerMin["startLng"];
            $route = $distAnswerMin["routePolyline"];
            if (0 == $trailmeters) { // if the trailMeeters is not zero, then need to adjust the milepost.
                $bizMilepost = $distAnswerMin["iconMilepost"];
            } else {
                $lines = new freewheelingLineTable($trailId, " edit-accesses-build-business ", $msg);
                $result = $lines->GivenLatLonFindNearestLatLonLinePoint($trailLatitude, $trailLongitude, "point on trail", $msg);
                if ($result->matchPoint < 0) {
                    $msg .= "$errorBeg E#1015 no match point found for $bizName, lat,lon - $trailLatitude, $trailLongitude $errorEnd $eol";
                    throw new Exception($msg);
                }
                $bizMilepost = $result->milepost;
                $routeLink = freeWheelFormat::bizIdMapLink($trailId, $trailId);
                $msg .= "E#805 trailLatitude, trailLongitude = $trailLatitude, $trailLongitude  at $trailmeters meters from mile $bizMilepost $eol$eol";
            }
            $distMinMeters[$milePostPrefix] = $distanceMeters;
            $route = $distAnswerMin["routeLatLon"];
            if ($debugTraverse) {
                $msg .= "I#797 found a route for $bizName to $bizMilepost of points $route $eol";
                $msg .= rrwUtil::print_r($distAnswerMin, true, "distAnswerMin");
            }
            if (empty($route)) {
                $msg .= "$errorBeg I#341 no points in the route found for $bizName $errorEnd $eol";
                // so lets make something
                $route = "$trailLongitude,$trailLatitude,0 $bizLng,$bizLat,0";
            }
            $where = array("accBizId" => $bizId, "trailid" => $trailId);
            if ($debugBizId)  $msg .= rrwUtil::print_r($where, true, "E#700 where ");;
            $metersToTrail = $distAnswerMin["distanceMeters"];
            $trailMilepostPrefix = $distAnswerMin["milePostPrefix"];
            $dayRouted = date("Y-m-d");
            $update = array(
                "accBizId" => $bizId,
                "accBizName" => $bizName,
                'trailId' => $trailId,
                "metersToTrail" => $metersToTrail,
                "trailLatitude" => $trailLatitude,
                "trailLongitude" => $trailLongitude,
                "trailMilepost" => $bizMilepost,
                "trailMilepostPrefix" => $trailMilepostPrefix,
                "trail2bizRoute" => $route,
                "accDateRouted" => $dayRouted,
            );
            $cnt = $wpdbExtra->replace($wpdbExtra->access, $update, $where);
            if ($cnt === false || 1 != $cnt) {
                $msg .= "$errorBeg E#347 replacing access returned '$cnt' either not one or false $errorEnd ";
                $msg .= rrwUtil::print_r($update, true, "update");
                $msg .= rrwUtil::print_r($where, true, "where");
                throw new Exception($msg);
            }
            $cnt = insertintoHistory($bizId,  "access:trailId: $trailId,  $metersToTrail meters from $trailMilepostPrefix $bizMilepost,");
            $sqlPoint = "update $wpdbExtra->access set accTrailPoint = point($trailLatitude, $trailLongitude) where accBizId = '$bizId' ";
            $cnt2 = $wpdbExtra->query($sqlPoint);
            $msg .= self::set_accessRouted("routed", $bizId);
            $distanceMiles = $metersToTrail / $meters2Mile;
            $mp = freeWheelFormat::milePost($milePostPrefix, $bizMilepost);
            $msg .= "I#798 <strong>updated $cnt rows</strong> for $bizLink - $metersToTrail meters ($distanceMiles miles) from $trailMilepostPrefix $eol";
            if ($debugTraverse) $msg .= "------------------------- end of loop $loop $eol";
            $msg .= "I#799 <strong> maxUsedLoop was $maxUsedLoop</strong>$eol";
        } catch (Exception $ex) {
            throw new Exception("$msg $errorBeg E#244 " . $ex->getMessage() . " $errorEnd at bottom of freewheelingeasy_route_one_bizId  $errorEnd");
        }  // end catch (Exception $ex)
        return $msg;
    } // end function freewheelingeasy_route_one_bizId
    private static function freewheelingeasy_reset_milepost($attr)
    {
        // only do the removal of the submit button has been pushed.
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $debugReset = rrwParam::Boolean("debugreset");
        try {
            if ($debugReset) {
                $msg .= rrwUtil::print_r($_POST, true, "post");
                $msg .= rrwUtil::print_r($_GET, true, "get");
            }
            $prefix = rrwParam::String("prefix", $attr);
            $minMile = rrwParam::Number("minmile", $attr, -900);
            $maxMile = rrwParam::Number("maxmile", $attr, 900);
            if (empty($prefix)) {
                $trailId = freeWheelParam::trail($attr);
                $sqlprifix = "select distinct trMilepostPrefix from $wpdbExtra->trails where trid = '$trailId' ";
                $prefix = $wpdbExtra->get_var($sqlprifix);
                if (empty($prefix))
                    throw new Exception("$msg $errorBeg E#719 no prefix was entered $errorEnd");
            } else {
                $sqltrailId = "select distinct trid from $wpdbExtra->trails where trMilepostPrefix = '$prefix' ";
                $trailId = $wpdbExtra->get_var($sqltrailId);
                if (1 != $wpdbExtra->num_rows) {
                    $msg .= "I#7809 found zero or more than one trail for prefix $prefix $errorEnd";
                    $trailId = "";
                } // end if ( 1 != $wpdbExtra->num_rows ) {
            } // end if ( empty( $prefix ) ) {
            $sqlFromEtc = $wpdbExtra->prepare3arg(" from $wpdbExtra->access where trailMilepostPrefix = %s
				        and trailMilepost <  %s and trailMilepost >  %s", $prefix, $maxMile, $minMile);
            $sqlRange = "select min(trailMilepost) minMile, max(trailMilepost) maxMile $sqlFromEtc";
            if ($debugReset) $msg .= "$sqlRange $eol";
            $recRanges = $wpdbExtra->get_resultsA($sqlRange);
            if (1 != $wpdbExtra->num_rows)
                return "$msg $errorBeg E#738 did not find a any business trail mileposts for: $errorEnd $sqlRange $eol";
            if (empty($maxMile))
                $maxMile = $recRanges[0]["maxMile"];
            if (empty($minMile))
                $minMile = $recRanges[0]["minMile"];
            if ($maxMile < $minMile)
                return "$msg $errorBeg E#619 $maxMile is less than $minMile which is invalid $errorEnd ";
            $sqlCount = "select count(*) cnt $sqlFromEtc";
            if ($debugReset) $msg .= "$sqlCount $eol";
            $howMany = $wpdbExtra->query($sqlCount);
            if (empty(rrwParam::String("submit"))) {
                $msg .= "<form method='get' task='/businessaccess/'> reset $howMany business accesses with prefix <strong>'$prefix<strong> from '
            <input type='text' value = '$minMile' name='minmile' /> to
            <input type='text' value = '$maxMile' name='maxmile' />
            <input type='hidden' value='$prefix' name='prefix' />
            <input type='hidden' value='resetprefix' name='task' />
        <input type='submit' value='reset businesses mileposts' name = 'submit'/>
        </form>\n";
                $sqlBusiness = "select accBizId, accBizName, trailMilepostPrefix, trailMilepost, metersToTrail/1609.3  miles
                    $sqlFromEtc order by trailMilepost";
                if ($debugReset) $msg .= "$sqlBusiness $eol";
                $recBizs = $wpdbExtra->get_resultsA($sqlBusiness);
                $msg .= "<table>\n";
                rrwFormat::CellHeaderRow("bizName", "Milepost", "milesToTrail", "&nbsp; ", "&nbsp; ");
                foreach ($recBizs as $recBiz) {
                    $bizId = $recBiz["accBizId"];
                    $bizName = $recBiz["accBizName"];
                    $trailMilepostPrefix = $recBiz["trailMilepostPrefix"];
                    $trailMilepost = $recBiz["trailMilepost"];
                    $metersToTrail = $recBiz["miles"];
                    $bizLink = freeWheelFormat::BizLink($bizId);
                    $msg .= rrwFormat::CellRow("$bizLink $bizName", "$trailMilepostPrefix $trailMilepost", $metersToTrail);
                }
                $msg .= "</table>\n";
                if (!empty($trailId))
                    $msg .= freewheelingeasy_calculateMP::DisplayTrailMileposts($trailId);
                return $msg;
            }
            // to cause this to be recalculated,
            //      #1 we need to reset the bizDateRouted field in business
            //      #2 we need to remove the access records
            //      #3 prorocate the eed for a reroute to trails - done by moveDates2Trails
            //  doing that will cause the outing cleanup to reroute that business
            //$sqlWhere = ' trailMilepostPrefix = %s
            //	and trailMilepost >= %s and trailMilepost <= %s ", $prefix, $minMile, $maxMile);';
            $sqlUpdateBizRoute = $wpdbExtra->prepare3arg(
                "
                    update $wpdbExtra->business set bizDateRouted = '2002-02-02'
                     where trailMilepostPrefix = %s and trailMilepost >= %s and trailMilepost <= %s ",
                $prefix,
                $minMile,
                $maxMile
            );
            $msg .= "$sqlUpdateBizRoute $eol";
            $cnt = $wpdbExtra->query($sqlUpdateBizRoute);
            $sqlDeleteSccess = $wpdbExtra->prepare3arg("delete from $wpdbExtra->access " .
                " where trailMilepostPrefix = %s
				and trailMilepost >= %s and trailMilepost <= %s ", $prefix, $minMile, $maxMile);
            $msg .= "$sqlDeleteSccess $eol";
            $cnt = $wpdbExtra->query($sqlDeleteSccess);
            $msg .= self::moveDates2Trails();
        } catch (Exception $ex) {
            $msg .= "$errorBeg E#802 at bottom of freewheelingeasy_reset_milepost " . $ex->getMessage() . $errorEnd;
        }
        return $msg;
    }
    private static function freewheeling_setbizUsed($bizId, $newbizUsed)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $sql = "select code from $wpdbExtra->codes where codetype ='bizUsed'
                and googletype = '$newbizUsed' ";
        $code = $wpdbExtra->get_var($sql);
        $msg .= updateDataField($bizId, "bizUsed", $code);
        $updatedata = array(
            "metersToTrail" => 0,
            "trailLatitude" => 0,
            "trailLongitude" => 0,
            "accTrailPoint" => null,
            "trailMilepost" => null,
            "trailMilepostPrefix" => '',
            "trail2bizRoute" => ""
        );
        $keyacc = array("accBizId" => $bizId);
        $cntUdpate = $wpdbExtra->update($wpdbExtra->access, $updatedata, $keyacc);
        $updatedata = array("BizVerifyDisplay" => "near $newbizUsed");
        $keybiz = array("bizId" => $bizId);
        $cntUdpate .= $wpdbExtra->update($wpdbExtra->business, $updatedata, $keybiz);
        $msg .= updateDataField($bizId, "BizVerifyDisplay", "near $newbizUsed");
        $msg .= "$errorBeg I#354 Update business status to $newbizUsed $errorEnd";
        return $msg;
    }
    private static function checkForindividualException($bizId, $item, $default, $debugLegs)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $sqlexcept = "select fixValue from $wpdbExtra->exceptions
            where fixbizId = '$bizId' and fixType = '$item' ";
        if ($debugLegs) $msg .= "$sqlexcept $eol";
        $metersQuery = $wpdbExtra->get_var($sqlexcept);
        if (1 == $wpdbExtra->num_rows) {
            $default = $metersQuery;
            $msg .= "$errorBeg E#651 forced $item  to $metersQuery $errorEnd";
        } elseif (0 == $wpdbExtra->num_rows || is_null($metersQuery)) {
            // that is okay, no exception
        } else {
            throw new Exception("$msg $errorBeg #557 got $wpdbExtra->num_rows rows execting 1 while looking for exceptinon $errorEnd
        $sqlexcept $eol ");
        }
        return array($msg, $default);
    }
    private static function closePointsOnTrails($bizlink, $bizLat, $bizLng, &$msg)
    {
        global $wpdbExtra, $eol;
        $debugClosePoint = false;
        $debugClosePointsInformation = false;
        $recs = self::getNearbyPoints($bizLat, $bizLng, $msg, $debugClosePointsInformation, $debugClosePoint);
        $recs = self::calculateDistances($recs, $bizLat, $bizLng, $msg, $debugClosePoint);
        $SortedArray = freewheeling_kml_common::array_mSort($recs, array('distanceMeters' => SORT_ASC, "milepost" => SORT_ASC));
        $outputSortedArray = array();
        $distmin = -1;
        foreach ($SortedArray as $item) {
            $distanceMeters = $item["distanceMeters"];
            if ($distanceMeters == $distmin) {
                continue;
            }
            $distmin = $distanceMeters;
            $outputSortedArray[] = $item;
        }
        if ($debugClosePointsInformation || $debugClosePoint) $msg .= "i#587 Sorted array found" . rrwDisplayTable::array_to_table($outputSortedArray);
        return $outputSortedArray;
    }
    private static function getNearbyPoints($bizLat, $bizLng, &$msg, $debugClosePointsInformation, $debugClosePoint)
    {
        global $wpdbExtra, $eol;
        for ($rangeAdjustment = .0025; $rangeAdjustment < .2; $rangeAdjustment += .0025) {
            $bizLatMax = $bizLat + $rangeAdjustment;
            $bizLatMin = $bizLat - $rangeAdjustment;
            $bizLngMax = $bizLng + $rangeAdjustment;
            $bizLngMin = $bizLng - $rangeAdjustment;
            $sqlIcons = "select distinct trailId, iconName, latitude, longitude,
                            milepost, milePostPrefix, 'point' distance
                                from $wpdbExtra->icons
                                where latitude < $bizLatMax and latitude > $bizLatMin and
                                    longitude < $bizLngMax and longitude > $bizLngMin
                                    and milepost is not null
                                    and 0 = position('offline' in onMap)
                        union
                        select distinct  TrailId,'biz created point' IconName,trailLatitude, trailLongitude, trailMilepost, trailMilepostPrefix, 'access'
                                    from $wpdbExtra->access
                        where trailLatitude < $bizLatMax and trailLatitude > $bizLatMin and
                            trailLongitude < $bizLngMax and trailLongitude > $bizLngMin
                            and trailMilepost is not null";
            $recs = $wpdbExtra->get_resultsA($sqlIcons);
            $numPoints = $wpdbExtra->num_rows;
            if ($debugClosePointsInformation || $debugClosePoint) $msg .= "I#866 closePointsOnTrails:adjust $rangeAdjustment found $numPoints  points $eol";
            if ($numPoints > 10)
                break;
        }
        return $recs;
    }
    private static function calculateDistances($recs, $bizLat, $bizLng, &$msg, $debugClosePoint)
    {
        global $wpdbExtra, $eol;
        for ($ii = 0; $ii < count($recs); $ii++) {
            $iconLat = $recs[$ii]["latitude"];
            $iconLng = $recs[$ii]["longitude"];
            $recs[$ii]["distanceMeters"] =  freewheeling_calculations::distanceMeters($bizLat, $bizLng, $iconLat, $iconLng);
        }
        if ($debugClosePoint) {
            $msg .= "I#867 found " . $wpdbExtra->num_rows . " icons $eol";
            $msg .= rrwDisplayTable::array_to_table($recs);
        }
        return $recs;
    }
    public static function editAccess($attr)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;;
        $msg = "";
        $msg = freeWheeling_edit_setGlobals::setGlobals("freewheelingeasy_edit_businessAccess");
        $action = rrwParam::String("action");
        $accBizId = rrwParam::String("accBizId");
        if (empty($accBizId)) {
            $msg .= rrwUtil::print_r($_GET, true, "get");
            $msg .= rrwUtil::print_r($_POST, true, "post");
            return "$msg $errorBeg E#498 no id given  $errorEnd";
        }
        $msg .= "<h2>Edit Access information for Business $accBizId </h2>$eol";
        $displayTab = new rrwDisplayTable();
        $msg .= $displayTab->tablename($wpdbExtra->access);
        $msg .= $displayTab->keyname("accBizId");
        $msg .= $displayTab->keyvalue($accBizId);
        $msg .= $displayTab->columnread("BUssiness Name", "accBizName", 50, 1);
        $msg .= $displayTab->columnread("Bussiness id", "accBizId", 50, 1);
        $sqlTrailName = "SELECT trId as value, trName as display FROM $wpdbExtra->trails ";
        $msg .= $displayTab->DropDownOther("Trail Name", "trailId", 30, $sqlTrailName);
        $msg .= $displayTab->DropDownSelf("trail Milepost Prefix", "trailMilepostPrefix");
        $msg .= $displayTab->columns("trail Milepost", "trailMilepost", 50);
        $msg .= $displayTab->columns("Meters to trail", "metersToTrail", 50);
        $msg .= $displayTab->columnread("Latitude", "trailLatitude", 50, 1);
        $msg .= $displayTab->columnread("Longitude", "trailLongitude", 50, 1);
        $msg .= $displayTab->columns("Updated on", "accDateRouted", 50);
        //   $msg .= $displayTab->debugEditData(true);
        return $msg . $displayTab->DoAction($action);
    } // end function editAccess($id)
}// end class freewheelingeasy_build_businessAccess