<?php
/*		Freewheeling Easy Mapping Application
 *
 *		A collection of routines for display of trail maps and amenities
 *
 *		copyright Roy R Weil 2019 - https://royweil.com
 *
 */
class freewheeling_amen_search
{
    static public
    function amensearch($attrs)
    {
        global $eol, $errorBeg, $errorEnd;
        try {
            $msg = "";
            $msg .= freeWheeling_edit_setGlobals::setGlobals("amenity search");
            $msg .= freewheeling_edit_create_views("at start of clean ");
            $lookFor = rrwParam::Any("search");
            $trailsSearch = rrwParam::String("trailsSearch");
            if (empty($lookFor) && empty($trailsSearch)) {
                $msg .= freewheeling_amen_search::printSelectionForm();
            } elseif (!empty($lookFor)) {
                $msg .= freewheeling_amen_search::freewheeling_mapping_findName($lookFor);
                $msg .= freewheeling_amen_search::printSelectionForm();
            } elseif (!empty($trailsSearch)) {
                $msg .= freewheeling_amen_search::findtrail($trailsSearch);
                $msg .= freewheeling_amen_search::printSelectionForm();
                $msg .= freewheeling_change_bizId::buildForm($trailsSearch);
            } else {
                return "$msg $errorBeg E#703 can not get here $errorEnd";
            }
        } catch (Exception $ex) {
            $msg .= "$errorBeg E#440 " . $ex->getMessage() . $errorEnd;
        }
        return $msg;
    }
    static private
    function findtrail($trailsSearch)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $tableList = freewheeling_change_bizId::tablesWithBizIds();
        //		$msg .= rrwUtil::print_r( $tableList, true, "table list" );
        $msg .= "<table>";
        $color = rrwUtil::colorSwap();
        foreach ($tableList as $item => $table) {
            $sqlWhatever = "select * from $table where $item = '$trailsSearch'";
            $recWhatevers = $wpdbExtra->get_resultsA($sqlWhatever);
            if ($wpdbExtra->num_rows == 0) {
                $msg .= "<tr><td>no rows</td><td style='span:10' > $sqlWhatever</td></tr>";
                continue;
            }
            $msg .= "<tr><td colspan='10' >$sqlWhatever</td></tr>";
            foreach ($recWhatevers as $recWhatever) {
                $msg .= "<tr>\n";
                foreach ($recWhatever as $item) {
                    $msg .= rrwFormat::Cell($item);
                }
                $msg .= "</tr>\n";
            }
        }
        $msg .= "</table>";
        return $msg;
    }
    static public
    function printSelectionForm()
    {
        $form = "
	<form method='post' action='https://edit.shaw-weil.com/amensearch/' >
		Search Amenity by Partial Name:
		<input type='text' size='70' name='search' id='search' autofocus='autofocus'/>
		<input type='submit' value='Search for amenity' />
		</form>
	<form method='post' action='https://edit.shaw-weil.com/amensearch/' >
		Search trailinfo by Name:
		<input type='text' size='70' name='trailsSearch' id='trailsSearch' onBlur='submit();'  />
		<input type='submit' value='Search for trail' />
		</form>";
        return $form;
    }
    static public
    function freewheeling_mapping_findName($lookFor)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $debugSearch = rrwParam::Boolean("debug");
        $msg .= "<table>\n";
        $sql = "SELECT bizId, BizName, BizStreet, BizCity, BizZIP,
                        BizWWW, BizEmail, BizLat, BizLng, bizUsed, BizPhone,
                        BizVerifyDisplay, trail2bizroute, metersToTrail,
                        tripAdvisorId, tripAdvisorRating,
                        yelpId, yelpRating, googleMapUrl, googleRating ,
                        facebookId, facebookRating, L, T, B, F, K, 'biz' as itemtype
			     FROM `$wpdbExtra->businessServices`
                 left join $wpdbExtra->access on bizId = accBizId
                 where bizname like '%%%s%%' or bizId like '%%%s%%'
            UNION select iconId, iconName, '', '', '',
                        '', '', latitude, longitude, OnMap, '',
                        '', '', '',
                        '', '',
                        '', '', '',  '',
                        '', '', 0,0, 0,0,0, 'icon' from $wpdbExtra->icons
                where iconName like '%%%s%%'
            order by bizname";
        $sqlPrepared = $wpdbExtra->prepare3arg($sql, $lookFor, $lookFor, $lookFor);
        if ($debugSearch) $msg .= "$sql $eol";
        $bizrecs = $wpdbExtra->get_resultsA($sqlPrepared);
        if (0 == $wpdbExtra->num_rows) {
            if (freewheeling_kml_common::is_googleID($lookFor)) {
                $msg .= "Not found <a href='https://edit.shaw-weil.com/update-google/?bizId=$lookFor'
                                task='update Google' >
                            fetch google information - $lookFor</a> $eol ";
            }
        }
        $cnt = 0;
        foreach ($bizrecs as $bizrec) {
            $cnt++;
            if ($debugSearch && $cnt == 1) $msg .= rrwUtil::print_r($bizrec, true, "business record");
            $bizname = $bizrec["BizName"];
            $bizStreet = $bizrec["BizStreet"];
            $bizCity = $bizrec["BizCity"];
            $bizZip = $bizrec["BizZIP"];
            $bizLat = $bizrec["BizLat"];
            $bizLng = $bizrec["BizLng"];
            $bizPhone = $bizrec["BizPhone"];
            $bizUsed = $bizrec["bizUsed"];
            $bizWWW = $bizrec["BizWWW"];
            $bizId = $bizrec["bizId"];
            $bizEmail = $bizrec["BizEmail"];
            $bizgGoogleUrl = $bizrec["googleMapUrl"];
            $googleRating = $bizrec["googleRating"];
            $BizVerifyDisplay = $bizrec["BizVerifyDisplay"];
            $trail2bizroute = $bizrec["trail2bizroute"];
            $metersToTrail = $bizrec["metersToTrail"];
            $itemtype = $bizrec["itemtype"];
            $lodge = $bizrec["L"];
            $outfit = $bizrec["T"];
            $bike = $bizrec["B"];
            $food = $bizrec["F"];
            $camp = $bizrec["K"];
            //		gather the reason that the latest entry is not used
            $sqlUsed = "select * from $wpdbExtra->history where hisComment like '%bizUsed:%' " .
                " and hisId = '$bizId' order by hisDate desc ";
            $UsedRecs = $wpdbExtra->get_results($sqlUsed, ARRAY_A);
            if (count($UsedRecs) > 0) {
                //				var_dump($UsedRecs); // , "looking for bizUsed comment");
                $notUsedReason = " &nbsp; &nbsp; " . $UsedRecs[0]["hisComment"];
                $notUsedReason = str_replace("bizUsed:", " ", $notUsedReason);
                $notUsedReason .= " " . substr($UsedRecs[0]["hisDate"], 5, 2) . "/" .
                    substr($UsedRecs[0]["hisDate"], 0, 4);
            } else {
                $notUsedReason = "";
            }
            // check for blank e-mail and active facebook account
            if (empty($bizEmail)) {
                $sqlUsed = "select * from $wpdbExtra->history
							where hisComment like '%facebook%' " .
                    " and hisId = '$bizId' and hisDate > '2018-01 " .
                    "' order by hisDate desc limit 30001";
                $facebookrecs = $wpdbExtra->get_results($sqlUsed, ARRAY_A);
                if (count($facebookrecs) > 0) {
                    $bizEmail = " &nbsp; &nbsp; via facebook";
                }
            }
            $bizNameAndUsed = $bizname;
            $bizNameAndUsed .= " $BizVerifyDisplay";
            if ($itemtype == 'biz') {
                if ($bizUsed == 0) {
                    $bizNameAndUsed .= " &nbsp; Not displayed on web:";
                } else {
                    if ($lodge == 1)
                        $bizNameAndUsed .= " &nbsp; | Lodging";
                    if ($camp == 1)
                        $bizNameAndUsed .= " &nbsp; | Camping";
                    if ($outfit == 1)
                        $bizNameAndUsed .= " &nbsp; | Outfitter";
                    if ($bike == 1)
                        $bizNameAndUsed .= " &nbsp; | Bicycle";
                    if ($food == 1)
                        $bizNameAndUsed .= " &nbsp; | Food";
                }
            } elseif ($itemtype == 'icon') {
                $bizNameAndUsed .= "  &nbsp; icon of type $bizUsed:";
            } else {
                throw new Exception("$msg $errorBeg E#465
                                        imposible type of $itemtype $errorEnd ");
            }
            $reviewsAndMail = rrwFormat::reviewsFromRec($bizrec) .
                " <a href='mailto://$bizEmail' >$bizEmail</a>";
            if ($itemtype == "icon") {
                $editLink = FreewheelFormat::EditIconLink($bizId, $bizname);
                $viewLink = FreewheelFormat::EditIconLink($bizId, "View");
            } else {
                $editLink = freeWheelFormat::BizLink($bizId);
                $viewLink = freeWheelFormat::BizLink($bizId, "View");
                $viewLink .= " &nbsp; (" . freeWheelFormat::bizUsed2webStatus($bizUsed) . ")";
            }
            //       if ( !freeWheeling_edit_setGlobals::AllowedToEdit( "amenity search" ) ) {
            //         $editLink = "";
            //    }
            $mapLink = freeWheelFormat::bizIdMapLink($bizId);
            $milesTotrail = rrwFormat::DisplayMetersInMiles($metersToTrail);
            $msg .= rrwFormat::CellRow($mapLink, $bizNameAndUsed);
            $msg .= rrwFormat::CellRow(
                "$editLink $eol $mapLink - $milesTotrail",
                "$bizStreet $eol$bizCity,  $bizZip $bizPhone "
            );
            $msg .= rrwFormat::CellRow(" ", rrwFormat::reviewsFromRec($bizrec));
            $msg .= rrwFormat::CellRow(" ", " ");
        }
        $msg .= "</table>\n";
        return $msg;
    }
    public static function pushDevToProduction($attr)
    {
        global $eol, $errorBeg, $errorEnd;
        global $maxNumFiles, $previousRunDate, $countFiles;
        global $freewheeling_prebuilt_dire;
        try {
            $msg = "";
            $msg .= freeWheeling_edit_setGlobals::setGlobals("push_dev to production");
            if (!freeWheeling_edit_setGlobals::AllowedToEdit("push development to production")) {
                $msg .= "$errorBeg E#308 not allowed to push dev to production $errorEnd ";
                return $msg;
            }
            $directory = rrwParam::String("push", $attr);
            if (!empty($directory))
                $directory = "/$directory";
            $countFiles = 0;
            $optionName = "FreeWheelingEasyMapPreviousRunDate";
            $maxNumFiles = 1000;
            freeWheeling_edit_setGlobals::notAllowedToEdit(
                "push development to production"
            );
            $host = $_SERVER['HTTP_HOST'];
            if (strpos($host, "edit.shaw") !== false) {
                // in the right website
            } else {
                $msg .= "$errorBeg E#309 You need be in
                <a href='https://edit.shaw-weil.com' > for this to work. $errorEnd ";
                return $msg;
            }
            $defaultDate = strtotime("2001-03-19"); // unix time
            $previousRunDate = get_option($optionName, $defaultDate);
            $msg .= "<table>\n";
            $msg .= rrwFormat::HeaderRow("old date", "new date", "Directory", "file");
            $msg .= "top level directory for search is '$directory',
                        and  $freewheeling_prebuilt_dire $eol";
            $msg .= freewheeling_amen_search::processOneDir($directory);
            $msg .= "</table>\n";
            if (!update_option($optionName, time(), false)) {
                $msg .= "$errorBeg E#488 now option time did not get set $errorEnd";
            }
        } catch (Exception $ex) {
            $msg .= $msg . $errorBeg . $ex->getMessage() . $errorEnd;
        }
        $msg .= "copied $countFiles from dev to production $eol";
        return $msg;
    }
    private static
    function processOneDir($direName)
    {
        global $eol, $errorBeg, $errorEnd;
        global $freewheeling_prebuilt_dire;
        global $maxNumFiles, $previousRunDate, $countFiles;
        $msg = "";
        $color = rrwUtil::colorSwap();
        $debugDire = rrwParam::Boolean("debugDire");
        $debugFile = rrwParam::Boolean("debugFile");
        if ($direName == "/temp")
            return $msg . rrwFormat::CellRow("Igonoreing the temp directory");
        $maxNumFiles--;
        if ($maxNumFiles < 0)
            return $msg . rrwFormat::CellRow("E#791 processOneDir($direName) called to many time $eol");
        $sourceDir = "$freewheeling_prebuilt_dire$direName";
        $outputDir = str_replace("-dev", "ingeasy", $sourceDir);
        if ($debugDire) $msg .= "processing dire --- $direName -- $sourceDir to $outputDir $eol";
        if (!is_dir($outputDir)) {
            $msg .= rrwFormat::CellRow("", "", "$errorBeg E#609 processOneDir($direName)
                                        output directory does not exist $errorEnd");
            mkdir($outputDir);
        }
        $handle = opendir($sourceDir);
        if (!is_resource($handle)) {
            $msg .= rrwFormat::CellRow("$errorBeg E#477 open dire failed on
                        $sourceDir $errorEnd");
            return $msg;
        }
        $pastdire = "not yet";
        $cntdir = 0;
        while (false !== ($fileToSearch = readdir($handle))) {
            if ($fileToSearch == "." || $fileToSearch == "..")
                continue;
            $fileNameThis = "$sourceDir/$fileToSearch";
            if ($debugFile) $msg .= "============== $fileNameThis $eol ";
            if (is_dir($fileNameThis)) {
                $msg .= self::processOneDir(
                    "$direName/$fileToSearch"
                );
                continue;
            }
            // code to check date, and copy
            $sourceModDate = filemtime($fileNameThis);
            if (file_exists("$outputDir/$fileToSearch"))
                $outputModDate = filemtime("$outputDir/$fileToSearch");
            else
                $outputModDate = strtotime("1999-01-01");
            if ($debugFile) {
                $msg .= rrwFormat::CellRow(
                    date("  F d Y H:i:s", $sourceModDate),
                    date("  F d Y H:i:s", $sourceModDate),
                    $fileNameThis,
                    "$outputDir/$fileToSearch"
                );
            }
            // maybe test $previousRunDate
            if ($sourceModDate > $outputModDate) {
                $copy = "copy ($fileNameThis, $outputDir/$fileToSearch)";
                if ($pastdire == $outputDir)
                    $direDisplay = "";
                else {
                    $direDisplay = $outputDir;
                    $pastdire = $outputDir;
                }
                $color = rrwUtil::colorSwap($color);
                $msg .= rrwFormat::CellRow(
                    date("  F d Y H:i:s.", $outputModDate),
                    date("  F d Y H:i:s.", $sourceModDate),
                    $direDisplay,
                    $fileToSearch
                );
                if (copy($fileNameThis, "$outputDir/$fileToSearch") === false) {
                    $msg .= rrwFormat::CellRow(
                        "$errorBeg E#299 copy failed $errorEnd",
                        $copy
                    );
                    break;
                }
                $countFiles++;
            }
        } // end while
        return $msg;
    } // end processOneDir( $direName )
} // end class
