<?php

/*Freewheeling Easy Mapping Application
 *
 *		A collection of routines for display of trail maps and amenities
 *
 *		copyright Roy R Weil 2019 - https://royweil.com
 *
 */



class freewheelingeasy_editbiz
{
    static public
    function editbiz($attr)
    {
        global $eol, $errorBeg, $errorEnd;
        global $limit, $startAt;
        $msg = "";
        try {
            ini_set('display_errors', true);
            $msg .= rrwUtil::elapsedTime(); //start timer
            $msg .= freeWheeling_edit_setGlobals::setGlobals("edit biz");
            if (freeWheeling_edit_setGlobals::notAllowedToEdit("you must be logged in to run this routine "))
                return "$errorBeg E#313 fix routine is not allowed $errorEnd";
            $msg .= freewheeling_edit_create_views("after edit biz");
            $limit = rrwParam::Number("limit");
            if ($limit == 0)
                $limit = 20;
            $startAt = rrwParam::Number("startat", $attr);
            //          $msg .= self::addCityName2CommonPlaces();
            // various searches
            $action = rrwParam::String("action", $attr);
            $bizId = freeWheelParam::business($attr);
            //$msg .= "E#451 action '$action', bizId '$bizId' $eol";
            if (!empty($action)) {
                $bizId = rrwParam::String("update_value", $attr);
                $msg .= self::displayEditBiz($bizId);
                return $msg;
            }
            $task = rrwParam::String("task", $attr);
            switch ($task) {
                case "":
                    // $msg .= "got a bizId '$bizId' and there is no action $eol";
                    $msg .= self::displayEditBiz($bizId);
                    break;
                case "biz":
                    $msg .= self::displayEditBiz($bizId);
                    break;
                case "findfeedback":
                    $msg .= self::findFeedbacks($attr);
                    break;
                case "used":
                    $msg .= self::bizUsedVSnotclosed($attr);
                    break;
                case "swapbizUsed":
                    $msg .= self::swapbizUsed($attr);
                    break;
                case "premise":
                    $msg .= self::searchByTypes($attr, "premise");
                    break;
                case "health":
                    $msg .= self::searchByTypesUsed($attr, "health");
                    break;
                case "missingemail":
                    $msg .= self::listMissingEmail();
                    break;
                case "name":
                    $msg .= self::searchForMatchedName($attr);
                    break;
                case "sendemail":
                    $msg .= self::sendEmail();
                    break;
                case "close":
                    $msg .= self::searchForcloseBy($attr);
                    break;
                // case "break":
                //     $msg .= self::addRestaurantBreak($attr);
                //     break;
                case "dupokay":
                    $msg .= self::setDupNameOkay($attr);
                    break;
                case "delete":
                    $msg .= freewheeling_change_bizId::deleteBusiness($attr);
                    break;
                default:
                    $msg .= "$errorBeg E#539 did not find task '$task' in the list of tasks $errorEnd
						" . rrwUtil::print_r($_POST, true, "POST - attribute values") . "
						" . rrwUtil::print_r($attr, true, "ATTR - attribute values");
                    throw new Exception($msg);
            }
            return $msg;
            /*
                                 } elseif ( $task == "street" ) {
                                  $msg .= self::ApendOneSreet( $bizName );

                            } elseif ( $task == "wallmart" ) {
                                $msg .= self::searchforwallmart( $bizName );

                            } elseif ( $task == "processwallmart" ) {
                                $msg .= self::processwallmart();

                 */ // these update the database

        } catch (Exception $ex) {
            $msg .= "$errorBeg E#610 $msg " . $ex->getMessage() . $errorEnd;
            $msg .= rrwFormat::backtrace(4);
        }
        $msg .= rrwUtil::DisplayTimeDiff("editbiz", true);
        return $msg;
    } // end of editbiz


    static public
    function updateBizStyles()
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $debugUpdateStyles = false;
        $sqlBiz = "select bizId, bizName, google_types from $wpdbExtra->businessServices
        where bizstyle = '' and bizUsed > 0 and " . freewheeling_kml_common::selectOnlyGoogleId("bizId");
        $recBizs = $wpdbExtra->get_resultsA($sqlBiz);
        $updateCnt = 0;
        if ($debugUpdateStyles) $msg .= "<table>\n";
        foreach ($recBizs as $recBiz) {
            $updateCnt++;
            if ($updateCnt >= 10000)
                break;
            $bizId = $recBiz["bizId"];
            $bizName = $recBiz["bizName"];
            $google_types = $recBiz["google_types"];
            $bizIdDisplay = rrwFormat::PencilIcon("edit-biz?nohead=true&bizId=$bizId") . $bizName;
            $bizStyle = self::getBizStyle($google_types);
            if (empty($bizStyle)) {
                $msg .= "$bizIdDisplay with $google_types has no style $eol";
            } else {
                $updatedata = array("bizStyle" => $bizStyle);
                $where = array("bizId" => $bizId);
                $cnt = $wpdbExtra->update($wpdbExtra->business, $updatedata, $where);
                if ($debugUpdateStyles) $msg .= rrwFormat::CellRow(
                    $bizIdDisplay,
                    $bizStyle,
                    $google_types
                );
            }
        }
        if ($debugUpdateStyles) $msg .= "</table>\n";
        $msg .= "Update $updateCnt business with new bizStyle $eol";
        return $msg;
    }
    static private
    function getBizStyle($google_types)
    {
        global $wpdbExtra, $rrw_codes;
        global $eol, $errorBeg, $errorEnd;
        global $typeStyles;
        $debuggetBizStyle = false;
        if (!is_array($typeStyles)) {
            $sqlStyle = "select googletype, freeWheelingIcon from $rrw_codes
                where freeWheelingIcon is not null";
            $recStyles = $wpdbExtra->get_resultsA($sqlStyle);
            foreach ($recStyles as $recStyle) {
                $google = $recStyle["googletype"];
                $freeWheelingIcon = $recStyle["freeWheelingIcon"];
                if (empty($freeWheelingIcon) || empty($google))
                    continue;
                $typeStyles[$google] = $freeWheelingIcon;
            }
            if ($debuggetBizStyle) print rrwUtil::print_r($typeStyles, true, "type list");
        }
        $bizType = "";
        foreach ($typeStyles as $google => $freeWheel) {
            if (empty($google))
                continue;
            if (strpos($google_types, $google) !== false) {
                if (strpos($bizType, $freeWheel) === false) {
                    $bizType .= $freeWheel;
                }
            }
        }
        if (empty($bizType))
            $bizType = "none.jpg";
        else
            $bizType .= ".jpg";
        return $bizType;
    } // endd getBizStyle

    static private
    function swapbizUsed($bizId)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $sqlSwap = "update $wpdbExtra->business set bizUsed = not bizUsed where bizId = '$bizId'";
        $msg .= "$sqlSwap $eol";
        $msg .= $wpdbExtra->query($sqlSwap);
        return $msg;
    } // end swapbizUsed

    static private
    function bizUsedVSnotclosed($attr)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $msg .= freewheeling_edit_create_views("bizUsedVSnotclosed");
        $businessSelectable = "(F = 1 or L = 1 or B = 1 or K = 1 or T = 1)";
        // AD => Guided tours, OL => Laundary
        $busnessClosed = " (
        BizVerifyDisplay like 'Closed%' or
        BizVerifyDisplay like 'near%' or
        BizVerifyDisplay like 'reject%' or
        BizVerifyDisplay like 'not relevant%' or
        BizVerifyDisplay like 'too far%' or
        BizVerifyDisplay like 'air BnB%' or
        BizVerifyDisplay like 'duplicate%' or
        BizVerifyDisplay like 'same as%' ) ";
        $sql4 = " from $wpdbExtra->businessServices
					where $businessSelectable and bizUsed < 1
   					and not $busnessClosed ";
        $msg .= self::displaySelectedBussiness(
            $sql4,
            "bussiness to be listed but set not to list "
        );
        $sql5 = " from $wpdbExtra->businessServices
					where  $businessSelectable and bizUsed > 0
    					and $busnessClosed ";
        $msg .= self::displaySelectedBussiness(
            $sql5,
            "bussiness to be listed, marked listed, but closed "
        );
        $msg .= freewheeling_edit_create_views("bizUsed VS notclosed cleanup");
        $sql70 = " from $wpdbExtra->businessServices
					where  not $businessSelectable  and bizUsed > 0
                    and ol = 0 and p = 0 ";
        $msg .= self::displaySelectedBussiness(
            $sql70,
            "bussiness not to be listed, mark listed "
        );
        $sql80 = " from $wpdbExtra->businessServices
                    join $wpdbExtra->history on bizId= hisid
					where  $businessSelectable  and bizUsed > 0 and
                    (hiscomment like '%for sale%' or
                     hiscomment like '%check before publication%' )";
        $msg .= self::displaySelectedBussiness(
            $sql80,
            "bussiness to check before publication "
        );
        // update the routes biz to trail
        $msg .= freewheeling_edit_create_views("bizUsedVSnotclosed cleanup");
        return $msg;
    } // end bizUsedVSnotclosed
    static public
    function displaySelectedBussiness($sqlSelect, $title)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        global $limit;
        $msg = "";
        $msg .= "<h1>$title</h1>$eol ";
        $sql1 = " select count(*) cnt, codeDescription from $wpdbExtra->business
                        join $wpdbExtra->codes on bizUsed = code and codetype = 'bizUsed'
                        group by bizUsed order by codesort ";
        $recuseds = $wpdbExtra->get_resultsA($sql1);
        $total = 0;
        $counts = "";
        foreach ($recuseds as $recused) {
            $num = $recused["cnt"];
            $desc = $recused["codeDescription"];
            $counts .= "$num $desc, ";
            $total += $num;
        }
        $sql4 = "select count(*) $sqlSelect ";
        $msg .= "$sql4 $eol";
        $quesionable = $wpdbExtra->get_var($sql4);
        $msg .= "There are $total businesses, $counts $quesionable are quesionable $eol";
        //  -------------------------------------------------------- find unused
        $sql2 = "select distinct bizId, bizname, bizVerified, BizVerifyDisplay
                        $sqlSelect ";
        $recbizs = $wpdbExtra->get_resultsA($sql2);
        $msg .= "<table>\n" . rrwFormat::HeaderRow("bizId", "Name", "Verified");
        $bizCnt = 0;
        $bizreadCnt = 0;
        $color = rrwUtil::colorSwap();
        foreach ($recbizs as $recbiz) {
            $msgHold = "";
            $bizreadCnt++;
            if ($bizreadCnt > $limit)
                break;
            $closedDate = "";
            $color = rrwUtil::colorSwap($color);
            $bizId = $recbiz["bizId"];
            $bizname = $recbiz["bizname"];
            $bizVerified = $recbiz["bizVerified"];
            $BizVerifyDisplay = $recbiz["BizVerifyDisplay"];
            $bizIdDisplay = rrwFormat::PencilIcon(
                "edit-biz?nohead=true&bizId=$bizId",
                $bizVerified
            ) . $bizId;
            if (freewheeling_kml_common::is_googleID($bizId))
                $bizNamedisplay = "$bizname<a
                        href='https://developers.google.com/places/place-id'
				        target='search' > Search</a> ";
            else
                $bizNamedisplay = $bizname;
            $msgHold .= rrwformat::CellRow($color, $bizIdDisplay, $bizNamedisplay, $BizVerifyDisplay);
            // --------------------------------------------------------- find comments
            $sql3 = "select hisid, hisComment,hisdate from $wpdbExtra->history
						where hisid = '$bizId' order by hisdate desc, hiscomment";
            $recHiss = $wpdbExtra->get_resultsA($sql3);
            $hiscnt = 0;
            foreach ($recHiss as $recHis) {
                $hiscnt++;
                $hisdate = $recHis["hisdate"];
                $hisComment = $recHis["hisComment"];
                $hisdate = $recHis["hisdate"];
                if (stripos($hisComment, "type") !== false)
                    $hisComment = rrwFormat::PencilIcon(
                        "edit-service?nohead=true&svcid=$bizId&action=edit'
                    target='services' ",
                        $hisdate
                    ) . $hisComment;
                $msgHold .= rrwformat::CellRow($color, "&nbsp;", $hisdate, $hisComment);
                if (stripos($hisComment, "closed") !== false)
                    $closedDate = $hisdate;
            }
            $msg .= $msgHold;
            if (empty($closedDate))
                continue;
            $dd = new DateTime($closedDate);
            $dd = $dd->format("Y-m-d");
            $sql7 = "update $wpdbExtra->business set  BizVerifyDisplay = 'Closed $dd',
                        bizUsed = 0 where bizId = '$bizId'";
            $cnt = $wpdbExtra->query($sql7);
            $msg .= "<tr><td colspan='8'>$cnt - $sql7 </td></tr>\n";
            $bizCnt++;
        } // end  business
        $msg .= "<table>\n";
        $msg .= "Read $bizreadCnt and  processed $bizCnt $eol";
        return $msg;
    } // end displaySelectedBussiness

    private function processwallmart()
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_business;
        $msg = "";
        $bizIds = array_keys($_POST);
        foreach ($bizIds as $bizId) {
            $msg .= insertIntoHistory($bizId, "bizUsed: duplicate");
            $data = array(
                "bizVerified" => "getdate()",
                "bizUsed" => 0,
                "BizVerifyDisplay" => "duplicate",
            );
            $cnt = $wpdbExtra->update($rrw_business, $data, array("bizId" => $bizId));
            $edit = "<a href='https://edit.shaw-weil.com/edit-biz/?nohead=true&bizId=$bizId' target='edit'>$bizId</a> ";
            $msg .= " [ $edit ] ";
        }
        return $msg;
    }   //end processwallmart

    static private
    function findFeedbacks($attr)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_history;
        $msg = "";
        $msg .= "<h1 class='entry-title'>Entries by Unknown users </h1><p>";
        $sqlFeedback = "select distinct hisid, hisComment from $rrw_history
					where hisUpdater = 'unknown' and not hisComment like 'processed -'
					order by hisid, hisComment";
        $recfeeds = $wpdbExtra->get_resultsA($sqlFeedback);
        foreach ($recfeeds as $recfeed) {
            $bizId = $recfeed["hisid"];
            $hisComment = $recfeed["hisComment"];
            $bizlink = "<a href='/edit-biz/?bizId=$bizId' target='edit' >$bizId -- $hisComment</a> ";
            $msg .= " $bizlink $eol ";
        }
        $msg .= "</p>\n";
        return $msg;
    }   // end findFeedbacks


    static private
    function searchForcloseBy($attr)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $sqlLats = "SELECT * FROM $wpdbExtra->businessServices
							where googleMapUrl = '' and not BizLat = ''
							order by bizname ";
        $msg .= "$sqlLats $eol";
        $reclats = $wpdbExtra->get_resultsA($sqlLats);
        $msg .= "<div id=bizcnt>there are " . $wpdbExtra->num_rows .
            " business as starting point for search nearby </div>
		, based on having a lat,lng and no googlemap URL $eol ";
        $color = rrwUtil::colorSwap();
        $cnt = 0;
        $msg .= "<table>";
        $cntMissGoog = 0;
        foreach ($reclats as $reclat) {
            $cntMissGoog++;
            if ($cntMissGoog > 150)
                break;
            $color = rrwUtil::colorSwap($color);
            $BizName = $reclat["BizName"];
            $latitude = $reclat["BizLat"];
            $longitude = $reclat["BizLng"];
            $bizId = $reclat["bizId"];
            //		$msg .= "found $BizName with latitude $latitude,$longitude and no googleurl $eol ";
            $sqlNear = "select * from $wpdbExtra->businessServices
						where ST_Distance(Point($latitude, $longitude), bizpoint) < .005
						order by ST_Distance(Point($latitude, $longitude), bizpoint) asc ";
            //		$msg .= "$sqlNear $eol";
            $recbizs = $wpdbExtra->get_results($sqlNear, ARRAY_A);
            if ($wpdbExtra->num_rows < 2)
                continue;
            //			$msg .= rrwFormat::CellRow"", $wpdbExtra->num_rows);
            $cntBiz = 0;
            foreach ($recbizs as $recbiz) {
                if ($bizId == $recbiz["bizId"])
                    continue; // same as the first row, really lookng for different id
                $types = $recbiz["google_types"];
                $nearLat = $recbiz["BizLat"];
                $nearlng = $recbiz["BizLng"];
                $dist = freewheeling_calculations::distanceMeters($latitude, $longitude, $nearLat, $nearlng);
                if ($dist > 300)
                    break;
                if ($cntBiz == 0)
                    $msg .= self::displayOneRow($reclat, $cnt, $color);
                $cntBiz++;
                $msg .= self::displayOneRow($recbiz, $cnt, $color);
            } // end foreach ( $recsbizs as $recsbiz )
        } //end foreach ( $reclats as $reclat ) {
        $msg .= "</table>";
        return $msg;
    } // end searchForcloseBy
    static private function oneDup($itemName)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $sqlBizSelect = "select $itemName from $wpdbExtra->businessServices
							where not google_types like '%transit_station%'
							and not BizVerifyDisplay like '%duplicate%'
							and not P = 1
							group by $itemName having count(*) > 1
							and not $itemName = '' ";
        $msg .= self::DupSql($itemName, $sqlBizSelect);
        return $msg;
    } // edn oneDup
    static private
    function searchByTypes($attr, $google_type)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $itemName = "BizName";
        $sqlBizSelect = "select $itemName from $wpdbExtra->businessServices
							where google_types like '%$google_type%'";
        $msg .= self::DupSql($itemName, $sqlBizSelect);
        return $msg;
    } // end searchByTypes
    static private
    function searchByTypesUsed($attr, $google_type)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $itemName = "BizName";
        $sqlBizSelect = "select $itemName from $wpdbExtra->businessServices
							where google_types like '%$google_type%' and bizUsed > 0";
        $msg .= self::DupSql($itemName, $sqlBizSelect);
        return $msg;
    } // end searchByTypesUsed
    static private function searchForMatchedName($attr)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_business;
        $msg = "";
        $itemName = "BizName";
        $sqlDups = "SELECT $itemName  FROM $rrw_business where dupnameokay = 0
                and not bizUsed = -10 group by $itemName  having count(*) > 1";
        $msg .= self::DupSql(
            $itemName,
            $sqlDups,
            "bizname, bizcity, bizstreet"
        );
        return $msg;
    } // end searchForMatchedName
    static private
    function DupSql($itemName, $sqlBizSelect, $orderby = "")
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        global $limit, $viewOnly, $startAt;
        $msg = "";
        if (empty($orderby))
            $orderby = $itemName;
        $sqlcount = "select count(*) from ( $sqlBizSelect ) xx";
        $total = $wpdbExtra->get_var($sqlcount);
        $msg .= " There are $total duplicate $itemName $eol";
        $sqlbiz = "select * from $wpdbExtra->businessServices where $itemName in
                    ($sqlBizSelect) order by $orderby ";
        $msg .= "$sqlbiz $eol";
        $recBizs = $wpdbExtra->get_results($sqlbiz, ARRAY_A);
        $cnt = 0;
        $itemPast = "Not yet";
        $bizNamePast = "not yet";
        $color = rrwUtil::colorSwap();
        $cntgogleurl = 0;
        $msg .= "<table>";
        $msg .= rrwFormat::HeaderRow(
            "&nbsp;",
            "&nbsp;",
            "bizId/ PlaceID",
            "Name",
            "",
            "Address",
            "city",
            "Phone",
            "place website",
            "google map web"
        );
        $totalread = 0;
        foreach ($recBizs as $recBiz) {
            $totalread++;
            if ($totalread < $startAt)
                continue;
            $cnt++;
            $item = $recBiz[$itemName];
            if ($item != $itemPast) {
                $itemPast = $item;
                $color = rrwUtil::colorSwap($color);
                if ($cnt > $limit)
                    break;
            }
            $msg .= self::displayOneRow($recBiz, $cnt, $color);
        }
        $msg .= "</table>";
        $totalread = $totalread - 4;
        $msg .= "<a href='?task=name&amp;startat=$totalread' > Next </a> $eol";
        return $msg;
    } // end DupSql
    static private
    function addCityName2CommonPlaces()
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $knownDups = array(
            "7-Eleven",
            "AT&T Store",
            "Advance Auto Parts",
            "ALDI ",
            "American Legion",
            "Arby''s",
            "ATM",
            "ATM (Country Fair)",
            "ATM Express",
            "ATM Network, Inc",
            "Barnes & Noble",
            "Best Buy",
            "Big Lots",
            "Bob Evans",
            "Bed Bath & Beyond",
            "BP",
            "Bruegger''s Bagels",
            "Budget Inn",
            "Burger King",
            "Butler-Freeport Community Trail",
            "Cardtronics",
            "Cardtronics ATM",
            "Chipotle Mexican Grill",
            "Circle K",
            "Citizens Bank",
            "CoGo''s",
            "Comfort Inn & Suites",
            "Country Fair",
            "coinstar",
            "CVS",
            "CVS Pharmacy",
            "Dairy Mart Foods",
            "Dairy Queen",
            "Dairy Queen Grill & Chill",
            "DICK''S Sporting Goods",
            "Dollar General",
            "Dollar Tree",
            "Domino''s Pizza",
            "Dunkin''",
            "Eat''n Park",
            "Einstein Bros. Bagels",
            "Elks Lodge",
            "Enterprise Rent-A-Car",
            "Exxon",
            "Family Dollar",
            "Family Video",
            "First Baptist Church",
            "First National Bank",
            "First National Bank ATM",
            "First Presbyterian Church",
            "First United Methodist Church",
            "First United National Bank",
            "Flying J Travel Center",
            "Four Star Pizza",
            "Fox''s Pizza Den",
            "GetGo",
            "Getgo Gas Station",
            "Giant Eagle Pharmacy",
            "Giant Eagle",
            "Giant Eagle Supermarket",
            "GNC",
            "IHOP",
            "Jackson Hewitt Tax Service",
            "Jehovah''s Witnesses",
            "Jimmy John''s",
            "JOANN Fabrics and Crafts",
            "H&R Block",
            "KFC",
            "Kingdom Hall of Jehovah''s Witnesses",
            "Kings Family Restaurants",
            "Knights of Columbus",
            "Kwik Fill",
            "Little Caesars Pizza",
            "Long John Silver''s",
            "Lowe''s Home Improvement",
            "Mad Mex",
            "Marathon Gas",
            "Market District Supermarket",
            "Marshalls",
            "McDonald''s",
            "Monro Auto Service And Tire Centers",
            "New Life Baptist Church",
            "Northwest Bank",
            "One Stop Mini Mart",
            "Panera Bread",
            "Papa John''s Pizza",
            "Parkhurst Dining Services",
            "Pep Boys Auto Parts & Service",
            "Perkins Restaurant & Bakery",
            "Petco",
            "Pizza Hut",
            "Pizza Hut Express",
            "PNC Bank",
            "PNC Bank ATM",
            "Primanti Bros.",
            "Quality Inn & Suites",
            "redbox",
            "Rent-A-Center",
            "Rite Aid",
            "Sheetz",
            "Shell",
            "SHOP ''n SAVE",
            "Save-A-Lot",
            "Salvation Army",
            "Second Baptist Church",
            "Sprint Store",
            "Starbucks",
            "Subway",
            "Subway Restaurants",
            "Sunoco Gas Station",
            "T-Mobile",
            "Taco Bell",
            "Target",
            "TGI Fridays",
            "The Church of Jesus Christ of Latter-day Saints",
            "The Home Depot",
            "The UPS Store",
            "Tim Hortons",
            "Tractor Supply Co.",
            "United States Postal Service",
            "US Post Office",
            "U-Haul Neighborhood Dealer",
            "Verizon Authorized Retailer - Wireless Zone",
            "Veterans of Foreign Wars",
            "Vocelli Pizza",
            "Walgreens",
            "Walmart Auto Care Centers",
            "Walmart Bakery",
            "Walmart Connection Center",
            "Walmart Deli",
            "Walmart Garden Center",
            "Walmart Money Center",
            "Walmart Pharmacy",
            "Walmart Photo Center",
            "Walmart Supercenter",
            "Walmart Supercenter",
            "Walmart Vision & Glasses",
            "Walmart",
            "Wendy''s"
        );
        $cntUpdate = 0;
        foreach ($knownDups as $name) {
            $msg .= self::setDupNameOkay($name);
            $cntUpdate++;
        }
        return $msg;
    } // end addCityName2CommonPlaces
    static private function setDupNameOkay($bizName)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $debugDupName = false;
        if ($debugDupName) $msg .= "setDupNameOkay($bizName) $eol";
        $bizName = urldecode($bizName);
        if ($debugDupName) $msg .= "setDupNameOkay($bizName) $eol";
        $update = array("dupNameOkay" => 1);
        $key = array("bizName" => $bizName);
        $numUpdated1 = $wpdbExtra->update($wpdbExtra->business, $update, $key);
        $numUpdated2 = $wpdbExtra->update($wpdbExtra->businessServices, $update, $key);
        if ($numUpdated1 != $numUpdated2)
            $msg .= "$errorBeg E#359 update $numUpdated1 businesses and $numUpdated2
                        business services. Should be equal $errorEnd";
        $msg .= insertIntoHistory(
            $bizName,
            "user change - BizName - $bizName -> Duplicate name okay"
        );
        $msg .= "Updated $numUpdated1 $bizName entries to duplicate okay";
        return $msg;
    } // end setDupNameOkay

    static private
    function displayOneRow($recBiz, $cntgogleurl, $color)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_codes;
        global $codes;  // array of codes filled in by first time through
        $msg = "";
        $bizId = $recBiz["bizId"];
        $bizName = $recBiz["BizName"];
        $bizUsed = $recBiz["bizUsed"];
        $bizStreet = $recBiz["BizStreet"];
        $bizCity = $recBiz["BizCity"];
        $bizState = $recBiz["BizState"];
        $BizPhone = $recBiz["BizPhone"];
        $BizEmail = $recBiz["BizEmail"];
        $BizWWW = $recBiz["BizWWW"];
        $bizNote = $recBiz["BizNote"];
        $place_id = $recBiz["place_id"];
        $googleMapUrl = $recBiz["googleMapUrl"];
        $tripAdvisorId = $recBiz["tripAdvisorId"];
        $facebookId = $recBiz["facebookId"];
        $BizLat = $recBiz["BizLat"];
        $BizLng = $recBiz["BizLng"];
        $google_types = $recBiz["google_types"];
        if (!empty("$BizLat$BizLng"))
            $latgot = "<a href='https://edit.shaw-weil.com/update-google/" .
                "?radius=.02&latitude=$BizLat&longitude=$BizLng'>lat</a>";
        else
            $latgot = "---";
        if (empty($BizPhone))
            $BizPhone = $google_types;
        $yelpId = $recBiz["yelpId"];
        if (false) {
            $google_types = "";
            $temp = "";
            if (!is_array($codes)) {
                $codes = array();
                $sql = "select distinct code from $rrw_codes
						where codetype = 'establishment' and codesort < 900";
                $recCodes = $wpdbExtra->get_results($sql, ARRAY_A);
                $sum = 0;
                foreach ($recCodes as $recCode) {
                    $codes[$recCode["code"]] = $recCode["googleType"];
                }
            }
            foreach ($codes as $item => $desc) {
                $temp .= "$item - " . $recBiz[$item] . " &nbsp; ";
                if ($recBiz[$item] == 1)
                    $google_types .= ", $desc";
            }
            $temp .= $eol;
        }
        $bizNameClean = urlencode($bizName);
        $bizIdClean = urlencode($bizId);
        $edit = "<a href='https://edit.shaw-weil.com/edit-biz/?bizId=$bizIdClean' target='edit'>ed</a> ";
        $del = "<a href='https://edit.shaw-weil.com/edit-biz/?" .
            "bizId=$bizIdClean&action=update&submit=Delete+this+record&update_name=bizId&update_value=$bizId'
				 target='delete'>del</a>
				 <a href='https://edit.shaw-weil.com/duplicates/?bizname=$bizNameClean&task=dupokay'
				 					target='delete'>dupOK</a>";
        $googleMapUrlhref = "<a href='$googleMapUrl' target='goog$cntgogleurl' >$googleMapUrl</a> ";
        $wwwLink = "<a href='$BizWWW' target='www' >$BizWWW</a>";
        $bizUsedDisplay = "<a href='/edit-biz?bizId=$bizId&task=swapbizUsed'> $bizUsed </a>";
        if ($bizId == $place_id)
            $place_id = "";
        $msg .= rrwFormat::CellRow(
            'style="background-color:' . $color . '"',
            $edit,
            $del,
            "$bizId<br />$place_id",
            $bizName,
            $bizUsedDisplay,
            $bizStreet,
            $bizCity,
            $BizPhone,
            $BizEmail,
            $wwwLink,
            $bizNote,
            $googleMapUrlhref,
            $tripAdvisorId,
            $facebookId,
            $yelpId,
            $latgot
        );
        return $msg;
    }   //end displayOneRow
    static private
    function searchForMatchedAddress($attr)
    {
        global $wpdbExtra, $rrw_history, $rrw_business, $rrw_codes, $rrw_services;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $sqlDup = 'select BizName, bizId, replace(replace(replace(BizStreet, "Street", ""),"Stree", ""), "St", "") address
				FROM `$rrw_business` order by bizStreet';
        $msg .= "$sqlDup $eol";
        $recdups = $wpdbExtra->get_resultsA($sqlDup);
        $bizList = array();
        $addpast = "not yet";
        $cnt = 0;
        foreach ($recdups as $recdup) {
            $cnt++;
            $add = $recdup["address"];
            $bizId = $recdup["bizId"];
            $BizName = $recdup["BizName"];
            if (empty($add))
                continue;
            if (strpos($BizName, "Church Woman") !== false) {
                $msg .= "$cnt, $add, $BizName, $addpast $eol";
            }
            if ($add == $addpast) {
                $bizList["$add|<a href='/edit-biz/?bizId=$bizId'>$bizId</a>"] = $add;
            }
            $addpast = $add;
        }
        $msg .= "looked at $cnt entries $eol";
        $msg .= rrwUtil::print_r($bizList, true, "diplicate stuff");
        return $msg;
    } // end searchForMatchedAddress

    static private function displayEditBiz($bizId)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra,  $rrw_business, $rrw_codes;
        global $viewOnly;
        $msg = "";
        $debuginput = false;
        $msg .= freeWheeling_edit_setGlobals::setGlobals("editbiz");
        error_reporting(E_ALL);
        if ($debuginput) {
            $msg .= "bizid is '$bizId' $eol";
            $msg .= rrwUtil::print_r($_POST, true, "Post variables");
            $msg .= rrwUtil::print_r($_GET, true, "Get variables");
        }
        $action = rrwParam::String("action");
        $submit = rrwParam::String("submit");
        if ($debuginput) $msg .= "start editbiz #1  action, submit, bizId $action, $submit, $bizId $eol";
        if (empty($bizId)) {
            $msg .= "E#442 bizId === '$bizId' is missing or non existant, therefore nothing can be displayed $eol";
            return $msg;
        }
        if ($debuginput) $msg .= "start editbiz #2 action, submit, bizId $action, $submit, $bizId $eol";
        if ($action == "update" && substr(rrwParam::String("submit"), 0, "6") == "Delete") {
            // ========================================= delete
            // there is more to deleteing business then just the business record
            $msg .= freewheeling_change_bizId::deleteBusiness($bizId);
            $msg .= "bussiness has been deleted";
            return $msg;
        } // end delete

        // -------------------------------------  set up the display_tables
        $msg .= freewheelingeasy_calculateMP::Update_BizVerifyDisplay($bizId);
        $viewOnly = rrwParam::Boolean("viewonly");
        if (!$viewOnly)
            freeWheeling_edit_setGlobals::notAllowedToEdit("edit bussiness");
        $sqlAll = "select bizstate, bizstreet, bizcity, BizLat, bizlng, bizUsed from $rrw_business
                        where bizId = '$bizId' ";
        $recAll = $wpdbExtra->get_resultsA($sqlAll);
        if (false === $recAll || 0 == $wpdbExtra->num_rows) {
            $msg .= "$errorBeg E#270 bizId $bizId not found in $rrw_business $errorEnd $sqlAll $eol";
            return $msg;
        }
        $bizUsed = $recAll[0]["bizUsed"];
        $bizState = $recAll[0]["bizstate"];
        $bizStreet = $recAll[0]["bizstreet"];
        $bizCity = $recAll[0]["bizcity"];
        $BizLat = $recAll[0]["BizLat"];
        $bizlng = $recAll[0]["bizlng"];
        if ($BizLat > 0) {
            $latlink = "<a href='https://www.google.com/maps/place/$BizLat,$bizlng' target=lat >$BizLat,$bizlng</a>";
        } else {
            $latlink = "no lat,lng";
        }
        // note the coumn routine recognizes the name street and makes fourth aram a link
        $addresslink = "https://www.google.com/maps/place/$bizStreet, $bizCity' target=address >";
        $bizLink = freeWheelFormat::bizIdMapLink($bizId);
        $msg .= self::firstLineOfRequests($bizId);
        $displayTable = new rrwDisplayTable();
        $msg .= $displayTable->tablename("$rrw_business");
        $msg .= $displayTable->sortDefault("bizId");
        $msg .= $displayTable->KeyName("bizId");
        $msg .= $displayTable->KeyValue($bizId);
        $msg .= $displayTable->setOutputBizHistoryRecord(true);
        $msg .= $displayTable->columnread("Status Display Current", "BizVerifyDisplay", 69, 1);
        $sqlBizUsed = "SELECT code, codeDescription FROM $wpdbExtra->codesBizUsed order by codeDescription";
        // print " DropDownOther(Business Status, bizUsed, 20, $sqlBizUsed, $bizUsed);";
        $msg .= $displayTable->DropDownOther("Business Status", "bizUsed", 20, $sqlBizUsed, $bizUsed);

        $sqlAmenityCodes = "select code as code1, code from  $rrw_codes
							where codetype = 'amenitystatus' order by codesort ";

        $msg .= $displayTable->radioBUttons("Status Display", "status", 10, $sqlAmenityCodes);
        $msg .= $displayTable->columns("Business Name", "BizName", 60, $bizLink);
        $msg .= $displayTable->columns("Street", "BizStreet", 60, $addresslink);
        $msg .= $displayTable->columns("City, $bizState", "BizCity", 69,  $bizState);
        if (empty($bizState) || $bizState == "PS")
            $msg .= $displayTable->columns("State", "BizState", 4,);
        $msg .= $displayTable->columns("Zip", "BizZIP", 12, $latlink);
        $msg .= $displayTable->columns("Phone", "BizPhone", 50);
        $msg .= $displayTable->columns("e-mail", "BizEmail", 50);
        $msg .= $displayTable->columnUrlOrId("website", "BizWWW", "");
        $msg .= $displayTable->columnUrlOrId("Google map", "googleMapUrl", "");
        $msg .= $displayTable->columns("Google rating", "googleRating", 10);
        $msg .= $displayTable->columnUrlOrId("Yelp URL/ID", "yelpId", "https://www.yelp.com/");
        $msg .= $displayTable->columns("yelp Rating", "yelpRating", 10);
        $msg .= $displayTable->columnUrlOrId("Trip Advisor URL/ID", "tripAdvisorId", "https://www.tripadvisor.com/");
        $msg .= $displayTable->columns("trip advidor Rating", "tripAdvisorRating", 10);
        $msg .= $displayTable->columnUrlOrId("Facebook URL/ID", "facebookId", "https://www.facebook.com/");
        $msg .= $displayTable->columns("FaceBook Rating", "facebookRating", 10);
        $msg .= $displayTable->columnread("Business Original Note", "BizNote", 100, 9); // blank, no update if empty
        $msg .= $displayTable->columns("Business Directions", "BizDirections", 50);
        if (freeWheeling_edit_setGlobals::AllowedToEdit("displayEditBiz")) {
            $msg .= $displayTable->columnread("Todays Comment", "CommentsEntered", 69, 21);
        }
        print "BizLat = $BizLat, bizlng = $bizlng $eol";
        if (empty($BizLat) || 0 == $BizLat) {
            $msg .= $displayTable->columns("Latitude", "BizLat", 10, 1);
            $msg .= $displayTable->columns("Longitude", "BizLng", 10, 1);
        }
        $msg .= $displayTable->columnread("id", "bizId", 30, 1);
        $msg .= $displayTable->columnread("lastest google scan", "googleScanned", 25, 1);
        $msg .= $displayTable->columnread("latest verify", "bizVerified", 25, 1);
        $msg .= $displayTable->columnread("routed date", "bizDateRouted", 25, 1);
        $msg .= $displayTable->addWebCheckButton(true);
        if ($debuginput) $msg .= "setup done $eol";
        //  ------------------------------------ setup done, get to processing
        if ($action == "update") {
            //     $msg .= " need to after processing of the update";
            $msg .= self::processWebCHeck($bizId);
        }
        $msg .= $displayTable->DoAction();
        $msg .= $displayTable->DisplayAllHistory($bizId);
        return $msg;
    } // end of displayEditBiz

    private static function processWebCHeck($bizId)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_business;
        $msg = "";
        $submit = rrwParam::String("submit"); // get the submit button
        if (strpos($submit, "web check") !== false) {                       // web check button pushed
            $msg .= insertIntoHistory($bizId, "bizUsed: web site check");
            $sqlveryfied = "update $rrw_business set bizVerified = now() where bizId = '$bizId'";
            $cnt = $wpdbExtra->Query($sqlveryfied);
        }
        $webstatus = rrwParam::String("status");
        if (false) print "Status = $webstatus$eol";
        if (!empty($webstatus)) {
            $msg .= insertIntoHistory($bizId, "bizUsed: $webstatus");
            $data = array(
                "bizVerified" => "getdate()",
            );
            switch ($webstatus) {
                case "visited":
                case "web site check":
                case "local informant":
                case "unverified":
                    break;
                case "too far":
                    $bizUsed = -3;
                    break;
                case "rejected":
                    $bizUsed = -7;
                    break;
                case "closed":
                    $bizUsed = 0;
                    break;
                case "duplicate":
                    $bizUsed = -10;
                    break;
                case "maybe to far":
                    $bizUsed = -11;
                    break;
                default:
                    $msg .= "$errorBeg #353 did not find bizUsed code for $errorEnd";
                    $bizUsed = -6; // later
                    break;
            }
            $data["bizUsed"] = $bizUsed;
            $data["bizverifyDisplay"] = trim($webstatus);

            $cnt = $wpdbExtra->update($rrw_business, $data, array("bizId" => $bizId));
            if ($cnt > 0)
                $msg .= freewheelingeasy_calculateMP::Update_BizVerifyDisplay($bizId);
        }
        $debugComments = false;
        $CommentsEntered = rrwParam::String("CommentsEntered");
        if ($debugComments) print "comment - $bizId, $CommentsEntered $eol";
        if (!empty($CommentsEntered)) {
            $comments = explode("|", $CommentsEntered);
            foreach ($comments as $comment) {
                if ($debugComments) print "insert into $bizId, history comment - $comment $eol";
                $msg .= insertIntoHistory($bizId, $comment);
            } // end for loop
        }
        $msg .= freewheeling_edit_create_views("after edit biz");
    }   // end of processWebCHeck

    private static function firstLineOfRequests($bizId)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_business, $rrw_codes, $rrw_services;
        $msg = "";

        if (!empty($bizId)) {
            // figure out who
            $sqlWhere = " where bizId = '$bizId' ";
            $sql = "select BizName, bizId, BizCity, BizWWW, tripAdvisorId,facebookId, yelpId, googleMapUrl, place_id, googleScanned,
							bizVerified, BizLat, BizLng, ST_X(accTrailPoint) trailLatitude, ST_Y(accTrailPoint) trailLongitude,
							trailmilepost, trailmilepostPrefix, metersToTrail,
                            trail2bizroute
						from $rrw_business
                left join $wpdbExtra->access on bizId = accBizId
                $sqlWhere ";
            $dataRows = $wpdbExtra->get_results($sql, ARRAY_A);
            if ($dataRows === false || count($dataRows) < 1) {
                $msg .= "Returned no rows from the sql - $sql$eol";
                return $msg;
            }
            $dataRow = $dataRows[0];
            $BizName = $dataRow['BizName'];
            $BizCity = $dataRow['BizCity'];
            $place_id = $dataRow['place_id'];
            $bizId = $dataRow["bizId"];
            $bizWWW = $dataRow["BizWWW"];
            $tripAdvisorId = $dataRow["tripAdvisorId"];
            $googleMapUrl = $dataRow["googleMapUrl"];
            $BizLat = $dataRow["BizLat"];
            $BizLng = $dataRow["BizLng"];
            $yelpId = $dataRow["yelpId"];
            $facebookId = $dataRow["facebookId"];
            $bizVerified = $dataRow["bizVerified"];
            $metersToTrail = $dataRow["metersToTrail"];
            $trailLatitude = $dataRow["trailLatitude"];
            $trailLongitude = $dataRow["trailLongitude"];
            $trailmilepost = $dataRow["trailmilepost"];
            $trail2bizroute = $dataRow["trail2bizroute"];
            $googleScanned = $dataRow["googleScanned"];
            $trailMilepostPrefix = $dataRow["trailmilepostPrefix"];
            if (empty($BizLat)) {
                $latslink = "<a href='https://edit.shaw-weil.com/edit-biz/?bizId=$bizId&lat=' >missing biziness lats</a>";
            } else {
                $latslink01 = "<a target='update' href='https://edit.shaw-weil.com/update-google?radius=.01&latitude=$BizLat" .
                    "&longitude=$BizLng' target='update' >";
                $latslink10 = str_replace("=.01", "=10", $latslink01);
                $latslink = " $latslink01 close</a>, $latslink10 10 mi </a> ";
            }
            if (empty($trailLatitude)) {
                $maplink = "missing trail launch";
            } else {
                print "trailmilepost = $trailmilepost, prefix = $trailMilepostPrefix $eol";
                $maplink = freewheelFormat::Milepost($trailMilepostPrefix, $trailmilepost);

                $maplink .= " - " .
                    rrwFormat::meters2MilesDirectionLink(
                        $metersToTrail,
                        $trailLatitude,
                        $trailLongitude,
                        $BizLat,
                        $BizLng,
                        "$BizName, $BizCity",
                        $place_id
                    );
            }
            $bizAccessLink = "<a target='route' href='/businessaccess/?bizId=$bizId&redo=true&radius=";
            $bizAccLink1 = "$bizAccessLink' >Route $$</a>";
            $bizAccLink2 = "$bizAccessLink &replace=true' >Replace Route $$$</a>";
            $servicesLink = "<a href='/edit-service/?svcid=$bizId&action=edit'
                                target='services'> services</a> ";
            $sqlCntAccess = "select count(*) as cnt from $wpdbExtra->access where accBizId = '$bizId' ";
            $accessCnt = $wpdbExtra->get_var($sqlCntAccess);
            if (0 == $accessCnt)
                $accessLink = "no accesses";
            else
                $accessLink = "<a href='/edit-access/?accBizId=$bizId&action=edit'
                                target='access'> Accesses ($accessCnt)</a> ";

            $msg .= "<h1>$BizName -  <span style  =' font-size:smaller;'>
							[ $maplink ] ";

            if (current_user_can("edit_posts")) {
                $msg .= "\n[ $servicesLink ] [ $accessLink ] [ $latslink $$$] [ $bizAccLink1 ]  [ $bizAccLink2 ] ";

                $msg .= " [ <a href='https://edit.shaw-weil.com/changebizId/" .
                    "?old=$bizId|$BizName' target='change'>Change bizId</a> ]";

                if (freewheeling_kml_common::is_googleID($bizId)) {
                    if (empty($googleScanned))
                        $numDays = "never";
                    else {
                        $scanned = new DateTime($googleScanned);
                        $now = new Datetime();
                        $scandiff = $scanned->diff($now);
                        $numDays = $scandiff->days;
                    }
                    $msg .= " [ <a href='https://edit.shaw-weil.com/update-google/?task=placeid&bizId=$bizId'
								target='change'>google age $numDays</a> ]";
                } else {
                    $msg .= "[ not Googleable ] ";
                }

                $msg .= freeWheelFormat::bizIdMapLink($bizId);
            } else { // if ( current_user_can( "edit_posts" ) )
                print "
<script>
var titleThing = document.getElementsByClassName('entry-title');
console.log(titleThing);var i;
for (i = 0; i < titleThing.length; i++) {
  titleThing[i].innerHTML  = 'Enter feedback for business: ';
}
</script>
";
            }
            $daysSinceLast = self::daysSinceNow($bizVerified);
            $daysSinceLimit = get_user_option("rrw_daysSinceLimit");
            if ($daysSinceLimit === false)
                $daysSinceLimit = 30;
            if ($daysSinceLast > $daysSinceLimit)
                $verfiedMsg = "<a href='/google_update/?bizid=$bizId' target='update'> ** busness verified $daysSinceLast days ago</a>";
            else
                $verfiedMsg = "";
            $msg .= " $verfiedMsg $eol";
            $msg .= "</span></h1>";

            $msg .= "<script type=\"text/javascript\" >\n";
            $nowin = rrwParam::String("nowin");
            if (empty($nowin) && freeWheeling_edit_setGlobals::AllowedToEdit("firstLineOfRequests")) {
                $searchParam = "$BizName $BizCity";
                $msg .= self::windowopen($googleMapUrl, 'google', $searchParam);
                $msg .= self::windowopen($bizWWW, 'BizWWW', $searchParam);
                $msg .= self::windowopen(
                    $tripAdvisorId,
                    'tripAdvisor',
                    "tripadvisor $searchParam"
                );
                $msg .= self::windowopen(
                    $facebookId,
                    'facebook',
                    "facebook $searchParam"
                );
                $msg .= self::windowopen(
                    $yelpId,
                    'yelp',
                    "$searchParam"
                );
            }
            $msg .= "var doc = document.getElementsByTagName(\"title\")[0];
			doc.innerHTML = \"ed $BizName\" ;
			console.log (\"done\");
function logTabsForWindows(windowInfoArray) {
  for (windowInfo of windowInfoArray) {
    console.log(`Window: \${windowInfo.id}`);
    console.log(windowInfo.tabs.map((tab) => {return tab.url}));
  }
}
function onError(error) {
  console.log(`Error: \${error}`);
}
		</script>
";
        } // end if ( !empty( $bizId ) )

        //      $msg .= "<h1>$BizName -  <span style  =' font-size:smaller;'>
        //				<a href='/edit-service/?svcid=$bizId&action=edit'
        //               target='services' > services</a>$latslink</span> $verfiedMsg</h1>";

        return $msg;
    }   // end function editbiz

    public static function sendEmail()
    {
        global $wpdbExtra;
        $msg = "";
        $sql = "SELECT bizId, bizname, biznote, bizEmail, BizState FROM $wpdbExtra->businessServices
				where  BizEmail like '%@%' ";
        $sql .= " and not BizVerifyDisplay like '%closed%' and not BizVerifyDisplay like '%renamed%' ";
        $sql .= " and B = '1' ";
        $sql .= "order by bizname ";
        //			$msg .= "$sql $eol";
        $revsvcs = $wpdbExtra->get_resultsA($sql);
        $maxLimit = $wpdbExtra->num_rows;
        $msg .= "<h1>$maxLimit business with e-mail</h1>\n";
        $msg .= "<table>";
        $color = rrwUtil::colorSwap();
        $cnt = 0;
        foreach ($revsvcs as $revsvc) {
            $cnt++;
            $color = rrwUtil::colorSwap($color);
            $bizEmail = $revsvc["BizEmail"];
            $bizNote = $revsvc["BizNote"];
            $bizId = $revsvc["bizId"];
            $bizName = $revsvc["bizname"];
            $edit = "<a href='https://edit.shaw-weil.com/edit-biz/?bizId=$bizId'>$bizId ";
            $msg .= rrwFormat::CellRow(
                'style="background-color:' . $color . '"',
                $edit,
                $bizName,
                $bizNote,
                $bizEmail
            );
        }
        $msg .= "</table>";
        return $msg;
    }
    public static function listMissingEmail()
    {
        global $wpdbExtra;
        $msg = "";
        $limit = rrwParam::Integer("limit", 40);
        $sql = "SELECT bizId, BizName, BizWWW, BizNote, bizState, BS, BR
        FROM $wpdbExtra->businessServices
        where BizEmail = ''  and not BizVerifyDisplay like '%closed%'
        and not BizVerifyDisplay like '%renamed%' and B = '1' ";
        $sql .= "order by bizname ";
        $revsvcs = $wpdbExtra->get_resultsA($sql);
        $maxLimit = $wpdbExtra->num_rows;
        $msg .= "<h1>$maxLimit business with no e-mail</h1>\n";
        $msg .= "<table>";
        $color = rrwUtil::colorSwap();
        $cnt = 0;
        foreach ($revsvcs as $revsvc) {
            $cnt++;
            if ($cnt > $limit)
                break;
            $bs = "";
            $br = "";
            $bf = "";
            $color = rrwUtil::colorSwap($color);
            $bizId = $revsvc["bizId"];
            $bizName = $revsvc["BizName"];
            $bizWWW = $revsvc["BizWWW"];
            $bizNote = $revsvc["BizNote"];
            if ($revsvc["BS"] == 1)
                $bs = "shop";
            if ($revsvc["BR"] == 1)
                $br = "rental";
            $edit = "<a href='https://edit.shaw-weil.com/edit-biz/?bizId=$bizId' target='edit' >$bizId ";
            $msg .= rrwFormat::CellRow(
                $color,
                $edit,
                $bizName,
                $bizWWW,
                $bizNote,
                $bs,
                $br,
                $bf
            );
        }
        $msg .= "</table>";
        $msg .= freewheeling_amen_search::printSelectionForm();
        return $msg;
    }

    private static function addRestaurantBreak()
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_towns;
        $msg = "";
        throw new Exception("E#632 addRestaurantBreak: no idea what this does");
        $mile = rrwParam::Number("mi");
        $town = rrwParam::String("town");
        $prefix = rrwParam::String("prefix");
        if (!empty($mile)) {
            if (empty($town) || empty($prefix))
                throw new Exception("$msg E#662 missong townname or prefix");
            $updateData = array(
                "townmilepostprefix" => $prefix,
                "townmilepost" => $mile,
                "commenttype" => "R",
                "comment" => $town
            );
            $cnt = $wpdbExtra->insert($rrw_towns, $updateData);
            $msg .= "insert $cnt records $eol";
        }
        $sql = "select * from $rrw_towns order by townmilepostprefix, townmilepost";
        $recTowns = $wpdbExtra->get_resultsA($sql);
        $milepast = -9999;
        foreach ($recTowns as $recTown) {
            $townmilepost = $recTown["townmilepost"];

            if ($milepast == $townmilepost)
                throw new Exception("$msg E#727 duplicate milepost $milepast");
            $break = $recTown["breakmilepost"];
            if (is_null($break)) {
                $townid = $recTown["townid"];
                $comment = $recTown["comment"];
                $mile = ($recTown["townmilepost"] + $milepast) / 2;
                $cnt = $wpdbExtra->update(
                    $rrw_towns,
                    array("breakmilepost" => $mile),
                    array("townid" => $townid)
                );
                $msg .= "Updated $comment to $mile - $cnt $eol";
            }
            $milepast = $townmilepost;
        }
        return $msg;
    }
    public static
    function windowopen($url, $target, $searchParam = "")
    {
        global $returnnXX;
        $msg = "";
        if (empty($url)) {
            $searchParam = str_replace("'", "", $searchParam);
            $msg .= "window.open('https://google.com/?q=$searchParam', '$target');\n";
            $returnnXX = true;
        } else {
            if (substr($url, 0, 4) == "http") {
                $UrlFinal = $url;
            } else {
                $UrlFinal = "https://$target.com/$url";
            }
            $msg .= "window.open('$UrlFinal', '$target');\n";
        }
        return $msg;
    }
    public static
    function daysSinceNow($bizVerified)
    {
        global $eol, $errorBeg, $errorEnd;
        $debugSincelast = false;
        if ($debugSincelast) print "daysSinceNow:bizVerified $bizVerified - ";
        $bizVerified = str_replace("-", "/", $bizVerified);
        if ($bizVerified == '' || is_null($bizVerified))
            $verifiedDate = new DateTime('2001-06-06');
        else
            $verifiedDate = new datetime(substr($bizVerified, 0, 10));
        $today = new DateTime("now");
        $verifiedDiff = $today->diff($verifiedDate);
        $days = $verifiedDiff->days;
        if ($debugSincelast) print " $bizVerified - days $days $eol ";
        return $days;
    }
} // class freewheelingeasy_editbiz {
