<?php
//		Freewheeling Easy Mapping Application
//		A collection of routines for display of trail maps and amenities
//  	copyright Roy R Weil 2019 - https://royweil.com
class freewheelingeasy_calculateMP
{
    /*
     *	creates the table that lists miles by type of surface for each route -prebuilt-pages/miles-by-type
     *	creates the cross table milage chart for the continuous trail
     *			- pages-prebulit.milage_chart, pages_prebuilt icon-distance
     *	creates the trail_miles table for miles along the trail by Icon
     *
     *	has one parameter "route" which will cause it to do nly one route
     *		(used for testing and cleanup as it only takes a short time to do all)
     */
    public static
    function calculateMilepost($attr)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        ini_set("display_errors", true);
        error_reporting(E_ALL);
        $msg = "";
        $debugCalculate = rrwParam::Boolean("debugCalculate", $attr, false);
        $msgBottom = "";
        try {
            if ($debugCalculate) {
                $msg .= "calling calculateMilepost $eol";
                $msg .= rrwUtil::print_r($_GET, true, "GET");
                $msg .= rrwUtil::print_r($attr, true, "POST");
            }
            $msg .= freeWheeling_edit_setGlobals::setGlobals("freewheelingeasy_calculateMP::calculateMilepost");
            $msg .= freewheeling_edit_create_views("at calculateMP");
            try {
                $grpId = rrwParam::String("grpId", $attr); // do only one route
                $iconId = rrwParam::String("iconId", $attr);
                $trailId = freeWheelParam::trail($attr, false);
                $miles = rrwParam::String("miles", $attr);
                $task = rrwParam::String("task", $attr);
                $milesbytype = rrwParam::String("milesbytype", $attr);
                $msg .= " grpId = $grpId,  iconId,  = $iconId, miles = $miles, task = $task,  milesbytype = $milesbytype  $eol";
                $msg .= rrwUtil::DisplayTimeDiff("setup");
                switch ($task) {
                    case "part1":
                        $msg .= self::part1($attr);
                        return $msg;
                    case "part2":
                        $msg .= self::part2($attr);
                        return $msg;
                    case "part3":
                        $msg .= self::part3($attr);
                        return $msg;
                    case "kml":
                        $msg .= self::buildKMLRequestPage($attr);
                        return $msg;
                    default:
                        if ($debugCalculate) $msg .= "No specific task selected do all $eol";
                }
                $msgBottom .= " - - - - - - - $eol $eol";
                if (!empty($grpId)) {
                    if ($debugCalculate) $msg .= "doing the group $grpId $eol";
                    $msg .= self::processgrpId($grpId);
                    $msg .= rrwUtil::DisplayTimeDiff("process Group");
                    /*    } elseif (!empty($trailId)) {
                    if ($debugCalculate) $msg .= "doing the trail $trailId $eol";
                    $msg .= self::processTrailid($trailId);
                    $msg .= "do DisplayTrailMileposts $eol";
                    $msg .= rrwUtil::DisplayTimeDiff("process Trail ");
                    list($msgTemp, $chart) = self::DisplayTrailMileposts($trailId);
                    $msg .= $msgTemp;
                    $msg .= $chart;
                    $msg .= rrwUtil::DisplayTimeDiff("DisplayTrailMileposts ");
                    */
                } elseif (!empty($miles)) {
                    if ($debugCalculate) $msg .= "doing the mile  $miles $eol";
                    list($msgTemp, $milestable) = self::DisplayTrailMileposts($miles);
                    $msg .= $msgTemp . $milestable;
                } elseif (!empty($milesbytype)) {
                    if ($debugCalculate) $msg .= "doing the mile by type $milesbytype $eol";
                    $sqlGroup = "select grpId, grpName, LineSql from $wpdbExtra->trail_routes where grpId Like 'erie%pit' ";
                    $recGroup = $wpdbExtra->get_resultsA($sqlGroup);
                    foreach ($recGroup as $rec) {
                        $title = $rec["grpName"];
                        $lineSql = $rec["LineSql"];
                        $msg .= FreewheelingBuildMileageChart::outputMileByTypeFiles2($lineSql, $title);
                    }
                } else {
                    if ($debugCalculate) $msg .= "doing part 1 $eol";
                    $msg .= self::part1($attr);
                    if ($debugCalculate) $msg .= "doing part 2 $eol";
                    $msg .= self::part2($attr);
                    if ($debugCalculate) $msg .= "doing part 3 $eol";
                    $msg .= self::part3($attr);
                }
            } catch (Exception $ex) {
                $msg .= $errorBeg . $ex->getMessage() . $errorEnd;
            }
            $msg .= $msgBottom;
            $msg .= $eol . rrwUtil::DisplayTimeDiff("calculateMP calculations ", true);
        } // end try
        catch (Exception $ex) {
            $msg .= $ex->getMessage() . "$errorBeg  E#326 main upload $errorEnd";
        }
        return $msg;
    } // end 	function calculateMilepost( $attr )
    public static function part1($attr)
    {
        global $eol, $errorBeg, $errorEnd;
        $debugTimes = false;
        $msg = "";
        $msg .= freewheeling_edit_create_views("at calculateMP");
        if ($debugTimes) $msg .= rrwUtil::DisplayTimeDiff("created views ") . $eol;
        $msg .= self::buildKMLRequestPage($attr);
        if ($debugTimes) $msg .= rrwUtil::DisplayTimeDiff("created views ") . $eol;
        $msg .= self::milepost_update_selection();
        if ($debugTimes) $msg .= rrwUtil::DisplayTimeDiff("updated milepost selection ") . $eol;
        $msg .= freewheelingEasy_setIconRange::setIconRange($attr);
        if ($debugTimes) $msg .= rrwUtil::DisplayTimeDiff("updated milepost selection ") . $eol;
        $msg .= freewheelingEasy_kml_trailList::kml_trailList($attr);
        if ($debugTimes) $msg .= rrwUtil::DisplayTimeDiff("built lists ") . $eol;
        return $msg;
    }
    public static function part2($attr)
    {
        $msg = "";
        $msg .= self::processgrpId("%", "");
        $msg .= rrwUtil::DisplayTimeDiff("process grpId ");
        return $msg;
    }
    public static function part3($attr)
    {
        $msg = "";
        $msg .= self::processTrailid("%");
        $msg .= rrwUtil::DisplayTimeDiff("process Trailid ");
        return $msg;
    }
    /**
     * Builds the KML Request Page.
     *
     * This function generates an HTML page that lists trails with their corresponding KML sources.
     * It retrieves trail data from the database, checks for the existence of KML files, and creates
     * a table with links to these KML files.
     *
     * @param array $attr Attributes for building the KML request page.
     * @return string The generated HTML content for the KML request page.
     */
    private static function buildKMLRequestPage($attr)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $msg .= freewheeling_edit_create_views("at buildKMLRequestPage");
        $sqlKMLRequest = "select trId,trName, trSource from $wpdbExtra->trails where trSource != '' ";
        $recKMLRequest = $wpdbExtra->get_resultsA($sqlKMLRequest);
        $out = "<h1> KML Request Page </h1> $eol";
        $out .= "<table>";
        $out .= rrwFormat::HeaderRow("Trail Name", "KML Source");
        $color = rrwFormat::colorSwap();
        foreach ($recKMLRequest as $rec) {
            $trailId = $rec["trId"];
            $trName = $rec["trName"];
            $trSource = $rec["trSource"];
            $fileShort  = "wp-content/uploads/kml/$trSource.kml";
            $fileLong = "/home/pillowan/www-shaw-weil-edit/$fileShort";
            if (!file_exists($fileLong))
                continue;
            $color = rrwFormat::colorSwap($color);
            $sourceLink = "<a href='https://edit.shaw-weil.com/$fileShort' >$trSource.kml</a>";
            $out .= rrwFormat::CellRow($color, $trName, $sourceLink);
        }
        $out .= "</table>";
        $msg .= freewheeling_WriteUp::saveFileWithCompare("data", "kml_request.html", $out, 'file');
        return $msg;
    }
    private static
    function processgrpId($grpId)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $msg .= "<h1>process the continuous groups $grpId </h1> $eol";
        $sqlContinuous = " select SQL_NO_CACHE grpId, linesql, grpName from $wpdbExtra->trail_routes where is_continuous = 1 ";
        if (strcmp($grpId, "%") != 0)
            $sqlContinuous .= " and grpId like '$grpId' ";
        $sqlContinuous .= " order by grpId";
        $msg .= "$sqlContinuous $eol";
        $recGrps = $wpdbExtra->get_resultsA($sqlContinuous);
        foreach ($recGrps as $recGrp) {
            $grpId = $recGrp["grpId"];
            $linesql = $recGrp["linesql"];
            $grpName = $recGrp["grpName"];
            $msg .= self::do_all_things_for_a_group($grpId);
        }
        return $msg;
    }
    public static
    function processTrailid($trailId)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        try {
            if ($trailId == "all")
                $trailId = "%";
            $sqlTrail = "select SQL_NO_CACHE trid, trname from $wpdbExtra->trails  where trid like '$trailId' order by trid";
            $recTrails = $wpdbExtra->get_resultsA($sqlTrail);
            $cnt = 0;
            foreach ($recTrails as $recTrail) {
                $cnt++;
                if ($cnt > 50)
                    break;
                $trailId = $recTrail["trid"];
                $trname = $recTrail["trname"];
                $msg .= self::do_all_things_for_a_trail($trailId, false);
            }
            $msg .= "<hr>$eol";
            $msg .= rrwUtil::DisplayTimeDiff("individual trail information created ");
            $msg .= freewheelingEasy_kml_trailList::kml_trailList();
        } catch (Exception $ex) {
            $msg .= $errorBeg . $ex->getMessage() . $errorEnd;
        }
        return $msg;
    }
    private static
    function do_all_things_for_a_group($grpId)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $msg .= "$eol process $grpId, ";
        $sqlGrp = "select SQL_NO_CACHE linesql, grpName from $wpdbExtra->trail_routes where grpId = '$grpId' ";
        $recGrps = $wpdbExtra->get_resultsA($sqlGrp);
        if ($wpdbExtra->num_rows != 1)
            return "$msg $errorBeg E#446 did not get only one group from $eol $sqlGrp $errorEnd";
        $linesql = $recGrps[0]["linesql"];
        $grpName = $recGrps[0]["grpName"];
        $msg .= "<strong>$grpName</strong>, using $linesql $eol";
        if (empty($linesql)) {
            $msg .= "$errorBeg E#683 did not find a selection for grp '$grpId' $eol $sqlGrp $eol";
            return "$msg $errorEnd";
        }
        if (false) $msg .= self::DisplayTrailMileposts($grpId);
        $msg .= self::setgroupregions($grpId, $linesql);
        $msg .= self::update_Trail_mile_table($grpId, $linesql);
        $msg .= FreewheelingBuildMileageChart::outputMileByTypeFiles2($grpId);
        $chartGroup = FreewheelingBuildMileageChart::makeTrailHeadChart($linesql, $grpId, $msg);
        $msg .= freewheelingeasy_build_segment_report::freewheelingBuildOneSegmentReport($grpId);
        $msg .= self::gather_push_totalmile_byRoute($grpName, $linesql, $grpId);
        //         // << toDo gatherPushTrailHead wabts attributes as first parameter
        $sudoAttribute = array();
        $sudoAttribute["trailId"] = $grpId;
        $msg .= freewheel_trailHeads::gatherPushTrailHead($sudoAttribute);
        return $msg;
    }
    static private
    function fixMilePostIcons($trialid)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        try {
            $sqlIcons = "select SQL_NO_CACHE iconName, iconId from $wpdbExtra->icons
						where not substr(iconStyle,1,5) = concat( 'mp', substr(iconName,1,3) )
						and iconName like '%mile%'";
            $recsIcons = $wpdbExtra->get_resultsA($sqlIcons);
            foreach ($recsIcons as $recsIcon) {
                $iconName = $recsIcon["iconName"];
                $iconId = $recsIcon["iconId"];
                $iiSpace = strpos($iconName, " ");
                $name = substr($iconName, 0, $iiSpace);
                $iiSpace2 = strrpos($iconName, " ");
                $milepost = substr($iconName, $iiSpace2 + 1);
                if (0 == fmod($milepost, 1)) {
                    $iconStyle = "mpPic+" . (int)$milepost . " .png";
                } else {
                    $iconStyle = "flag.png";
                }
                $data = array(
                    "iconStyle" => $iconStyle,
                    "milepost" => $milepost
                );
                $msg .= "updating mapStyle of icon $iconName #$iconId to $iconStyle, row cnt = ";
                $msg .= $wpdbExtra->update($wpdbExtra->icons, $data, array("iconId" => $iconId));
                $msg .= $eol;
                return $msg;
            } // end foreach
        } catch (Exception $ex) {
            throw new Exception("$msg E#528" . $ex->getMessage() . $eol);
        }
        return $msg;
    }
    public static
    function do_all_things_for_a_trail($trailId, $createZZ_ = true)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        try {
            $msg .= "do_all_things_for_a_trail($trailId, $createZZ_ = true)";
            $trailInfo = freeWheeling_edit_setGlobals::getTrailInfo($trailId);
            throw new Exception("do_all_things_for_a_trail($trailId, $createZZ_ = true) $eol");
            $trname = $trailInfo["trName"];
            if (false) $msg .= self::DisplayTrailMileposts($trailId);
            $msg .= self::update_Trail_mile_table($trailId, "$wpdbExtra->lines.trailId = '$trailId'");
            $msg .= FreewheelingBuildMileageChart::outputMileByTypeFiles2($trailId);
            $chartTrail = FreewheelingBuildMileageChart::makeTrailHeadChart($sqlTrailWhere, $trailId, $msg);
            $msg .= self::gather_push_totalmile_byRoute($trname, $sqlTrailWhere, $trailId);
            //			$msg .= self::fixMilePostIcons( $trailId );
            $msg .= $eol;
            if ($createZZ_) {
                $msg .= createLineText::createZZDataFiles();
                $msg .= freewheelingEasy_kml_trailList::kml_trailList();
            }
        } catch (Exception $ex) {
            throw new Exception("$msg E#679 " . $ex->getMessage() . "thrown out of do_all_things_for_a_trail $eol");
        }
        return $msg;
    }
    static private
    function setgroupregions($grpId, $linesql)
    {
        global $wpdbExtra;
        $msg = "";
        $sqlGrp = " select SQL_NO_CACHE max(latmax) north, min(latmin) south,
                        min(lngmin) west, max(lngmin) east
						from $wpdbExtra->lines where $linesql ";
        $recGrps = $wpdbExtra->get_resultsA($sqlGrp);
        foreach ($recGrps as $recGrp) {
            $recGrp["trailId"] = $grpId;
            $recGrp["boundry"] = "";
            $recGrp["bndmapstyle"] = "#visableRegion";
            $recGrp["labelNorth"] = $recGrp["north"] / 2 + $recGrp["south"] / 2;
            $recGrp["labelEast"] = $recGrp["east"] / 2 + $recGrp["west"] / 2;
            $msg .= $wpdbExtra->replace($wpdbExtra->regions, $recGrp, array("trailId" => $grpId));
        }
        return $msg;
    }
    public static
    function DisplayTrailMileposts($routeRequested)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        global $meters2Mile;
        $outputTable = "";
        $msg = "";
        $debugDisplay = true;
        $sqlTrail = "select  * from $wpdbExtra->trails where trid = '$routeRequested'";
        if ($debugDisplay) $msg .= "$sqlTrail $eol";
        $rectrails = $wpdbExtra->get_resultsA($sqlTrail);
        if ($wpdbExtra->num_rows == 1) {
            if ($debugDisplay) $msg .= "found a trail ";
            $rectrail = $rectrails[0];
            $trailName = $rectrail["trname"];
            $msg .= "Mileage information for trail <a href='https:/edit-trail/?trailId=$routeRequested' >$trailName</a>
						Force mailpost to match <a href='https:/calculate?trailId=$routeRequested' >
						miles to Pittsburgh</a> $eol";
        } else {
            // assume that route requested is a grpId
            if ($debugDisplay) $msg .= "found a group ";
            $msg .= "Milepost information for route $routeRequested $eol";
            $totalmiles = 0;
            $totaloffroad = 0;
            $totalUnfinished = 0;
            $totalOnRoad = 0;
            $totalClosed = 0;
        }
        $sql = "select SQL_NO_CACHE distinct mile_iconName, milepost, milesAlongTrail
				FROM $wpdbExtra->trailMile
				join $wpdbExtra->icons on mile_iconName = iconName
				where mile_route= '$routeRequested' order by milesAlongTrail";
        $recmileposts = $wpdbExtra->get_resultsA($sql);
        if ($wpdbExtra->num_rows == 0)
            return "$msg $errorBeg E#487 sNo mileposts found for $routeRequested $eol $sql $errorEnd";
        $outputTable .= "<table width='500px'>";
        $outputTable .= rrwFormat::HeaderRow(
            "icon name",
            "miles along",
            "milepost",
            "Suggested",
            "Delta milepost",
            "Delta Along",
            "desccripancy",
            "Trailhead"
        );
        $pastmileAlong = 0;
        $pastmilepost = 0;
        $color = rrwUtil::colorSwap();
        foreach ($recmileposts as $recmilepost) {
            $color = rrwUtil::colorSwap($color);
            $iconName = $recmilepost["mile_iconName"];
            $milesAlongTrail = $recmilepost["milesAlongTrail"];
            $milepost = $recmilepost["milepost"];
            $diffMilepost = $milepost - $pastmilepost;
            $diffAlong = $milesAlongTrail - $pastmileAlong;
            $suggeted = $pastmilepost + $diffAlong;
            $desccripancy = abs($diffAlong) - abs($diffMilepost);
            $pastmileAlong = $milesAlongTrail;
            $pastmilepost = $milepost;
            $iconNamePlussed = str_replace(" ", "+", $iconName);
            $EditIconLink = "<a href='/edit-icon/?iconName=$iconNamePlussed' >$iconName</a>";
            $outputTable .= rrwFormat::CellRow(
                "style='background-color:$color'",
                $EditIconLink,
                $milesAlongTrail,
                $milepost,
                $suggeted,
                $diffMilepost,
                $diffAlong,
                $desccripancy
            );
        }
        $outputTable .= "</table>";
        return array($msg, $outputTable);
    } // end     function DisplayTrailMileposts( $routeRequested ) {
    private static
    function gather_push_totalmile_byRoute($Description, $sqlWhere, $grpId)
    {
        global $eol, $errorBeg, $errorEnd, $wpdbExtra, $distSum;
        global $meters2Mile;
        global $eol, $wpdbExtra;
        // ridable is defined as code sort < 600
        $debugMilage = false;
        $msg = "";
        $pageRoute = "";
        $sql = "select SQL_NO_CACHE sum(lengthMeters) as mteres
				FROM $wpdbExtra->lines where $sqlWhere";
        $sumLines = $wpdbExtra->get_var($sql);
        $sql = "select SQL_NO_CACHE sum(lengthMeters)/ $meters2Mile as miles, mapstyle, codesort,
					count(*) as cnt FROM `$wpdbExtra->lines` " .
            " left join $wpdbExtra->codes on mapstyle = code  ";
        $sql .= " where $sqlWhere ";
        $sql .= " GROUP by mapstyle, codesort order by codesort, mapstyle ";
        if ($debugMilage);
        $cnt = 0;
        $pageRoute .= "<h3>$Description </h3> ";
        $pageRoute .= "<table style='width:275px' >";
        $pageRoute .= rrwFormat::HeaderRow("Section Type", "Mileage");
        $total = 0;
        $ridable = 0;
        $recs = $wpdbExtra->get_results($sql, ARRAY_A);
        foreach ($recs as $rec) {
            $miles = $rec["miles"];
            $total += $miles;
            if ($rec["codesort"] < 550)
                $ridable += $miles;
            $numlines = 0;
            $surfaceDesc = self::getSurfaceDescriptions($rec["mapstyle"]);
            $howMany = $rec["cnt"];
            $numlines += $howMany;
            $miles = sprintf('% 5.1f', $miles);
            $miles = str_replace(" ", "&nbsp;", $miles);
            $cnt++;
            $pageRoute .= rrwFormat::CellRow(
                $surfaceDesc,
                "<span style='font-family:monospace; '>$miles</span>"
            );
        }
        $totalprt = sprintf('% 5.1f', $total);
        $totalprt = str_replace(" ", "&nbsp;", $totalprt);
        $pageRoute .= rrwFormat::CellRow(
            "<strong>Total Miles</strong>",
            "<span style='font-family:monospace; font-weight:bold '>$totalprt</span>"
        );
        $sourceLink = freeWheel::editViewStart .
            "<a href='/freewheelingeasy-write-up?file=miles-by-type/$grpId-routeDetail.html' >Source<a/>" .
            freeWheel::editViewEnd;
        if ($total > 0)
            $pageRoute .= rrwFormat::CellRow(
                "<strong>Ridable Miles</strong> road, open",
                round($ridable / $total * 100, 0) . "% $sourceLink "
            ); // ridable is code sort < 600
        $pageRoute .= "</table>";
        $milesAlong = $sumLines / $meters2Mile;
        $totaldbl = (float)$total;
        $diff = abs($milesAlong - $totaldbl);
        if ($diff > .5) {
            $msg .= "$errorBeg Milage along trail is $milesAlong, Sum of Serface is $total.
				The difference between then is $diff which is too large. $errorEnd";
        }
        $msg .= freewheeling_Writeup::saveFile("miles-by-type", "$grpId.html", $pageRoute);
        return $msg;
    }
    public static
    function update_Trail_mile_table($routeRequested, $sqlWhere)
    {
        global $eol, $errorBeg, $errorEnd;
        //
        // asumes that each icon is associated with the end of some line which has routes
        return "";
    } // end update_Trail_mile_table
    public static function checkIconsAtTrailends($trailId)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $debugendcheck = rrwParam::Boolean("debugendcheck");
        $sqlLinwes = "select lineId, lineName, lengthMeters, latStart, lngStart, latEnd, lngEnd
                    from $wpdbExtra->lines where trailId = '$trailId'
                    order by sequence";
        $recLines = $wpdbExtra->get_resultsA($sqlLinwes);
        if ($wpdbExtra->num_rows == 0) {
            $msg .= "$errorBeg E#750 no lines found for trail $trailId $errorEnd $sqlLinwes ";
            return $msg;
        }
        $rec = $recLines[0];
        $coors = $rec["pointList"];
        $iispace = strpos($coors, " ");
        $coor = substr($coors, 0, $iispace);
        $msg .= self::checkIconAtOneTrailEnd($rec["latStart"], $rec["lngStart"], $coor, $rec["lineId"]);
        $rec = $recLines[$wpdbExtra->num_rows - 1];
        $coors = $rec["pointList"];
        $iispace = strrpos($coors, " ", -3);
        $coor = substr($coors, $iispace);
        $msg .= self::checkIconAtOneTrailEnd($rec["latEnd"], $rec["lngEnd"], $coor, $rec["lineId"]);
        return $msg;
    } // end checkIconsAtTrailends
    private static function checkIconAtOneTrailEnd($lineLatitude, $lineLongitude, $coor, $lineId)
    {
        // assumes that lineLattude, line logitude is at the one end or the other of the trail.
        // veries that all nearby icons have same lat,lon as trail end
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $debugMilageTable = rrwParam::Boolean("debugMilageTable");
        list($coorlat, $coorlng, $z) = explode(",", $coor);
        if ($coorlat != $lineLatitude || $coorlng != $lineLongitude) {
            $msg .= "E#655 start/end of line not ($coorlat != $lineLatitude || $coorlng !=$lineLongitude) $eol";
            return $msg;
        }
        $closePoints = .00001;  // about 4.5 feet
        $sqlIcons = " select distinct iconId, iconName, latitude, longitude from $wpdbExtra->icons
                    where abs(latitude - $lineLatitude)< $closePoints and abs(longitude - $lineLongitude ) < $closePoints
                      order by iconName ";
        if ($debugMilageTable) $msg .= "$sqlIcons $eol";
        $recIcons = $wpdbExtra->get_resultsA($sqlIcons);
        // check that all icon points agree end line points
        $sqlIcons = "";
        $tempmsg = "";
        foreach ($recIcons as $recicon) {
            $lat = $recicon["latitude"];
            $lng = $recicon["longitude"];
            if (abs($lat - $lineLatitude) == 0 || abs($lng - $lineLongitude)  == 0)
                continue; // that is okay, exactly on end og line         $sqlIcons .= " or iconId = " . $recicon["iconId"];
            $tempmsg .= "[ " . FreewheelFormat::EditIconLink($recicon["iconId"], $recicon["iconName"]) . " - $lat, $lng ]";
        } // end for each icon
        if ($sqlIcons != "") {
            $sqlIcons = substr($sqlIcons, 3);   // remove the first or
            $sqlProb = "select iconId, latitude, longitude from $wpdbExtra->icons where 1=1 and ($sqlIcons);
                            select lineId, latStart, LngStart, LatEnd, lngEnd from $wpdbExtra->lines where lineId = lineId ";
            $msg .= " $errorEnd $sqlProb $tempmsg $eol";
        }
        if ($wpdbExtra->num_rows == 0) {
            $msg .= "$errorBeg &nbsp; &nbsp; &nbsp; &nbsp;
                            E#690 no icon found at beginning trail $errorEnd $sqlIcons ";
            $iconName = "No icon at begin of trail";
        } else
            $iconName = $recIcons[0]["iconName"];
        return $msg;
    }
    public static function Update_BizVerifyDisplay($bizId)
    {
        /*
         * Update BizVerifyDisplay based on the data in hisCommetn
         *   extract bizverifydisplay either from history or biznote
         * do this for all items that have information available
         * for the select items:
         *     build the new bizveriyDisplay
         *     compare to existing, and update if different
         */
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = ""; //
        if (substr($bizId, 0, 6) == "seg - ")
            return "";   // it is a segment not a business
        $debugVerify = false;
        $msg .= freeWheeling_edit_setGlobals::setGlobals("Update_BizVerifyDisplay");
        $sqlLastScan = "select bizVerified, googleScanned, bizVerifyDisplay, bizVerified, bizUsed
						from $wpdbExtra->business where bizId = '$bizId'";
        $bizRecs = $wpdbExtra->get_resultsA($sqlLastScan);
        if (1 != $wpdbExtra->num_rows) {
            return "$errorBeg E#732 Update_BizVerifyDisplay:expected 1 business but
				found " . $wpdbExtra->num_rows . $errorEnd;
        }
        $sqlverify = "select bizVerifyDisplay, bizVerified, hisdate,
				hiscomment, bizId, bizNote, BizName, bizUsed, googleScanned
                from $wpdbExtra->business
                left join $wpdbExtra->history on bizId = hisId
                where bizId = '$bizId' "; // enclude thisone as well
        $sqlverify .= " order by bizId, hisdate asc, hisComment asc ";
        if ($debugVerify) $msg .= "debugVerify: $sqlverify $eol ";
        $recsDates = $wpdbExtra->get_results($sqlverify, ARRAY_A);
        if (0 == $wpdbExtra->num_rows)
            return "$msg $errorBeg E#663 Did not find a business or history for $errorEnd
				$sqlverify $eol";
        if ($debugVerify) $msg .= "debugVerify:found " . $wpdbExtra->num_rows .
            "  history records $eol $sqlverify $eol";
        $pastbizId = $recsDates[0]["bizId"];
        $pastbizVerifyDisplay = $recsDates[0]["bizVerifyDisplay"];
        $pastbizVerified = $recsDates[0]["bizVerified"];
        $pastbizVerified = $recsDates[0]["bizVerified"];
        $pastbizUsed = $recsDates[0]["bizUsed"];
        $BizName = $recsDates[0]["BizName"];
        $lastGoogleScan = $recsDates[0]["googleScanned"];
        if (!empty($lastGoogleScan)) {
            $bizVerifyDisplay = "Google " . substr($lastGoogleScan, 0, 7); // it is a date field
            $bizVerified = $lastGoogleScan;
            if ($debugVerify) $msg .= "using google scan date of $lastGoogleScan $eol";
        } else {
            $bizVerifyDisplay = "Unverified";
            $bizVerified = "2001-07-07";
            if ($debugVerify) $msg .= "using google scan date of $lastGoogleScan $eol";
        }
        $cntRead = 0;
        $cntUpdate = 0;
        $cntNodata = 0;
        $cntNoDataButScanDate = 0;
        $unverifiedText = "Unverified";
        $printTableHeader = true;
        foreach ($recsDates as $recDate) {
            $cntRead++;
            if ($cntRead > 10000) {
                throw new Exception("$msg </table>$errorBeg E #590 Looping error in update_bizaccsvc $errorEnd");
            }
            $thishisDate = $recDate["hisdate"];
            $hisDatTest = substr($thishisDate, 0, 10); // full date
            $hisDatDisplay = substr($thishisDate, 0, 7); // display is jut year-month
            $hiscomment = $recDate["hiscomment"];
            if ($debugVerify) $msg .= "debugVerify: #$cntRead $hiscomment ||| old date = $thishisDate, hisDatDisplay = '$hisDatDisplay' $eol";
            if (empty($hiscomment))
                continue;
            $addDate = false;
            $switchThing = substr($hiscomment, 0, 8);
            if ($debugVerify) $msg .= "debugVerify: if ( $hisDatDisplay-01 >= $bizVerified )             		'$switchThing' $eol ";
            if ("$hisDatTest" >= $bizVerified) {
                if (false !== strpos($hiscomment, "web site check")) {
                    $bizVerifyDisplay = "Web Check " . $hisDatDisplay; // it is a date field
                    $bizVerified = $hisDatTest;
                }
                switch (substr($hiscomment, 0, 8)) {
                    //    123456789
                    case "web chec":
                    case "looks li":
                        $bizVerifyDisplay = "Web Check " . $hisDatDisplay; // it is a date field
                        $bizVerified = $hisDatTest;
                        break;
                    case "ATA amen":
                    case "ATAamen ":
                    case "Drive by":
                    case "E-Mail #":
                    case "owner em":
                    case "Personal":
                    case "phone ca":
                        $bizVerifyDisplay = "Local Informant " . $hisDatDisplay; // it is a date field
                        $bizVerified = $hisDatTest;
                        break;
                    case "visited ":
                        $bizVerifyDisplay = "Visited " . $hisDatDisplay; // it is a date field
                        $bizVerified = $hisDatTest;
                        break;
                    case "Google m":
                        if ($debugVerify) $msg .= " found Google m $eol";
                        $bizVerifyDisplay = "Unverivied"; // it is a date field
                        $bizVerified = $hisDatTest;
                        break;
                    case "Google i": // google insert
                        if ($debugVerify) $msg .= "debugVerify:find found Google i $eol $eol";
                        if ("Google insert - permanently_closed" == $hiscomment) {
                            $bizVerifyDisplay = "Closed " . $hisDatDisplay; // it is a date field
                            $bizVerified = $hisDatTest;
                            if (0 != $pastbizUsed) {
                                if ($debugVerify) $msg .= "update the bizUsed to zero ... ";
                                $updatedata = array("bizUsed" => 0);
                                $where = array("bizId" => $bizId);
                                $cntupdate = $wpdbExtra->update($wpdbExtra->business, $updatedata, $where);
                                if ($debugVerify) $msg .= " updated $cntupdate rows $eol";
                                $pastbizUsed = 0; // before the insert to avoid recusion lo
                                $msg .= insertIntoHistory(
                                    $bizId,
                                    "bizUsed: $pastbizUsed => 0",
                                    "Update_BizVerifyDisplay"
                                );
                            }
                            break;
                        }
                        $bizVerifyDisplay = "Google " . $hisDatDisplay; // it is a date field
                        $bizVerified = $hisDatTest;
                        break;
                    default:
                        break;
                } // end switch
            } // newr date on the hixcomment
        } // end the history search records  - foreach ( $recsDate as $recDate )
        // $bizVerifyDisplay and $bizVerified now set. lets check for update
        if ($debugVerify) $msg .= "if ( ( $bizVerifyDisplay != $pastbizVerifyDisplay ) || ( $bizVerified != $pastbizVerified ) ) $eol";
        if (($bizVerifyDisplay != $pastbizVerifyDisplay) || ($bizVerified != $pastbizVerified)) {
            $update = array(
                "bizVerified" => $bizVerified,
                "bizVerifyDisplay" => $bizVerifyDisplay,
            );
            $cntUpdate = $wpdbExtra->update($wpdbExtra->business, $update, array("bizId" => $bizId));
            $msg .= "changed $pastbizVerifyDisplay => $bizVerifyDisplay, $pastbizVerified => $bizVerified for " . freeWheelFormat::BizLink($bizId) . $eol;
        } // end if needs update
        return $msg;
    } // end function Update_BizVerifyDisplay( $bizId
    public static function getSurfaceDescriptions($code)
    {
        global $surfaces;
        global $wpdbExtra;
        if (!is_array($surfaces)) {
            $sql = "select code, codeDescription from $wpdbExtra->codes where codetype = 'surface' ";
            $recCodes = $wpdbExtra->get_results($sql, ARRAY_A);
            $surfaces = array();
            foreach ($recCodes as $recCode) {
                $surfaces[$recCode["code"]] = $recCode["codeDescription"];
            }
        }
        if (array_key_exists($code, $surfaces))
            return $surfaces[$code];
        else
            return "Unknow surface of $code ";
    }
    private static
    function milepost_update_selection()
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $msg .= "$errorBeg I#320 into milepost_update_selection $errorEnd";
        $taskgrp = array();
        $sglGroup = "select SQL_NO_CACHE grpId from $wpdbExtra->trail_routes order by grpId ";
        $recGroups = $wpdbExtra->get_resultsA($sglGroup);
        foreach ($recGroups as $recGroup) {
            $grpId = $recGroup["grpId"];
            $mileages = " &nbsp;";
            $route = " <a href='?grpId=$grpId' > Route ";
            array_push($taskgrp, rrwFormat::Cells($mileages, $route, " ", $grpId, " | "));
        }
        $taskTrail = array();
        $sqlTrail = "select SQL_NO_CACHE distinct trid, trname, milePostPrefix from $wpdbExtra->trailIcons order by trid ";
        $recTrails = $wpdbExtra->get_resultsA($sqlTrail);
        foreach ($recTrails as $recTrail) {
            $trailId = $recTrail["trid"];
            $trname = $recTrail["trname"];
            $mileages = "<a href='?trailId=$trailId' > mileposts ";
            $MPprefix = $recTrail["milePostPrefix"];
            $prefixLink = "<a href='https:/edit-trail/?trailId=$trailId' > ";
            if (empty($MPprefix))
                $prefixLink .= "not set</a>";
            else
                $prefixLink .= "$MPprefix</a>";
            $trname = str_replace(" ", "+", $trname);
            $mapLink = FreeWheelFormat::EditTrailLink($trailId);
            $amenityLink = "<a href='https:/freewheelingeasy-amenity/?amenity=$trname'>amen</a>";
            array_push($taskTrail, rrwFormat::Cells($mapLink, $amenityLink, $prefixLink, $trailId, "|"));
        }
        $task = array_merge($taskgrp, $taskTrail);
        $numTask = count($task);
        // $msg .= "there are $numTask to be displayed $eol";
        $inc = 4;
        $numrows = $numTask / $inc;
        $numrows = intval($numrows);
        $msg .= "<table>";
        $cntLines = 0;
        for ($ii = 0; $ii < $numrows; $ii++) {
            $cntLines++;
            if ($cntLines > 300)
                break;
            $msg .= "<tr>\n";
            for ($jj = 0; $jj < $numTask; $jj = $jj + $numrows) {
                if (($ii + $jj) < $numTask)
                    $msg .= $task[$ii + $jj];
            }
            $msg .= "</tr>\n";
        }
        $msg .= "</table>";
        $msg .= "$errorBeg I#321 out of milepost_update_selection $errorEnd";
        return $msg;
    } // end bsp; &nbsp; doAllRouteAndTrails
} // end class
