<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.com
 *
 */
class freewheeling_change_bizId
{
    static public function change_bizId($attr)
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $msg .= freeWheeling_edit_setGlobals::setGlobals("freewheelingeasy_change_bizId");
        if (freeWheeling_edit_setGlobals::notAllowedToEdit("you must be loged in to run this routine "))
            return "$errorBeg E#513 fix routine is not allowed $errorEnd";
        $old = rrwParam::String("old", $attr);
        $new = rrwParam::String("new", $attr);
        $name = rrwParam::String("name", $attr);
        $spaces = rrwParam::String("fixspace");
        $doKML = rrwParam::Boolean("doKML", $attr, false);
        $task = rrwParam::String("task");
        //		$msg .= rrwUtil::print_r( $_GET, true, "get" );
        //		$msg .= rrwUtil::print_r( $attr, true, "attr" );
        if (!empty($spaces)) {
            $msg .= self::replaceSpaces();
            return $msg; // special case to process many items
        }
        if ("delete" == $task) {
            $bizId = rrwParam::String("bizId");
            $msg .= self::deleteBusiness($bizId);
            return $msg;
        }
        $iiPipe = strpos($old, "|");
        if (false !== $iiPipe) {
            if (empty($name))
                $name = substr($old, $iiPipe + 1);
            $old = substr($old, 0, $iiPipe);
        }
        if (empty($old) || empty($new)) {
            $msg .= " I#279 You must supply old and new <strong>$name</strong>, $old, $new $eol";
            $msg .= self::buildForm($old, $new, $name);
        } else {
            $msg .= self::ChangeBizId($old, $new, $name, $doKML);
            $msg .= self::deleteBusiness("delete me");
        }
        return $msg;
    } // end change_bizId

    static public function tablesWithBizIds()
    {
        global $wpdbExtra;
        // this is the list of tables that have a filed that contains a bizid in them
        $tableList = array(
            "trid" => $wpdbExtra->trails,
            "hisid" => $wpdbExtra->history,
            "bizId" => $wpdbExtra->business,
            "svcId" => $wpdbExtra->services,
            "accBizId" => $wpdbExtra->access,
            "htmTrailId" => $wpdbExtra->html,
            "trailId-1" => $wpdbExtra->icons,   // use (-1)... to get unique keys
            "trailId-2" => $wpdbExtra->regions,
            "trailId-3" => $wpdbExtra->lines,
            "trailId-4" => $wpdbExtra->access,
        );
        //print rrwUtil::print_r($tableList, true, "tablesWithBizIds:tableList");
        return $tableList;
    }
    static public function tablesWithPointNames()
    {
        global $wpdbExtra;
        // this is the list of tables that have a filed that contains a point in them
        $tableList = array(
            "starticon" => $wpdbExtra->segments,
            "endicon" => $wpdbExtra->segments,
            "iconName" => $wpdbExtra->icons,
            "mile_iconName" => $wpdbExtra->trailMile,
            "lineName" => $wpdbExtra->lines,
            "bizName" => $wpdbExtra->business,
            "trName" => $wpdbExtra->trails,
            "accBizName" => $wpdbExtra->access,
        );
        //		print rrwUtil::print_r($tableList, true, "tablesWithPointNames:tableList");
        return $tableList;
    }

    /**
     * Updates the business ID across multiple tables and handles related updates.
     *
     * This method updates all references to a business ID ($old) with a new business ID ($new)
     * in all relevant tables. It also logs the change in the history, updates place IDs,
     * and optionally renames associated KML files. The method generates an HTML table
     * summarizing the SQL operations performed and their results.
     *
     * @param string $old    The current (old) business ID to be replaced.
     * @param string $new    The new business ID to update to.
     * @param string $name   The name associated with the business (for logging or display).
     * @param bool   $doKML  Whether to perform KML file renaming as part of the update.
     *
     *
     *
     * @return string HTML-formatted summary of the update operations performed, including
     *                SQL statements and the number of affected rows. If an exception occurs,
     *                the error message is appended to the output.
     */
    public static function ChangeBizId($old, $new, $name, $doKML)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_history, $rrw_business, $rrw_services;
        try {
            $msg = "";
            $msg .= "update Biz Id($old, $new, $name, '$doKML') $eol ";
            $tableList = self::tablesWithBizIds();
            // $msg .= rrwUtil::print_r($tableList, true, "table list");
            $msg .= "<table>";
            $color = rrwUtil::colorSwap();
            //        $msg .= rrwUtil::print_r( $tableList, true, "tableList" );
            $msg .= insertIntoHistory($old, "bizId change - $old -> $new");
            $msg .= insertIntoHistory($new, "bizId change - $old -> $new");
            foreach ($tableList as $field => $table) {
                if (strpos($field, "-") > 0) {
                    $ii = strpos($field, "-");
                    $field = substr($field, 0, $ii);
                }
                $sqlBiz = "update $table set $field = '$new' where $field = '$old'";
                $cnt = $wpdbExtra->query($sqlBiz);
                $color = rrwUtil::colorSwap($color);
                if ("$rrw_business" == $table)
                    $color = "#fadadd"; // pale pink
                if (0 == $cnt)
                    $cnt = " <span style='color:hotpink' > no update </span> ";
                else
                    $cnt = "$cnt rows of data";
                $msg .= rrwformat::CellRow($color, $sqlBiz, $cnt);
            }
            $sqlPlace = "update $rrw_business set place_id = bizId
                            where " . freewheeling_kml_common::selectOnlyGoogleId('bizId');
            $cnt = $wpdbExtra->query($sqlPlace);
            $color = rrwUtil::colorSwap($color);
            $msg .= rrwformat::CellRow($color, $sqlPlace, "$cnt rows of data");
            $sqlPlace = "update $rrw_business set place_id = null
                            where not " . freewheeling_kml_common::selectOnlyGoogleId('bizId');
            $cnt = $wpdbExtra->query($sqlPlace);
            $color = rrwUtil::colorSwap($color);
            $msg .= rrwformat::CellRow($color, $sqlPlace, "$cnt rows of data");
            $msg .= "</table>";
            if (freewheeling_kml_common::is_googleID($new)) { // new google place id
                $msg .= " [ <a href='https://edit.shaw-weil.com/update-google/?bizId=$new' >
					Update google</a> ]
					  [ <a href='https://edit.shaw-weil.com/edit-biz/?bizId=$new' >edit $new</a>$eol ";
                if (true) {
                    $attr = array(
                        "bizId" => "$new",
                        "allowed" => true
                    );
                    return $msg;
                } else {
                    $url = "https://edit.shaw-weil.com/update-google/" .
                        "?bizId=$new&allowed=please&nohead=true";
                    $msg .= rrwUtil::fetchURLcontents($url, "", 30);
                }
            }
            if ($doKML) {
                $msg .= self::renameKML($old, $new);
            }
            $msg .= self::renameKML($old, $new);
        } // end try
        catch (Exception $ex) {
            $msg .= $ex->getMessage() . "$errorBeg  E#305 at bottom of ChangeBizId $errorEnd";
        }
        return $msg;
    } // end function ChangeBizId
    static private function renameKML($old, $new)
    {
        global $eol, $errorBeg, $errorEnd;
        global  $freewheelingeasy_kml_directory;
        $msg = "";
        $oldFile = $old . "%d*.kml";
        $newfile = $new . "%d*.kml";
        $cnt = 0;
        foreach (new DirectoryIterator($freewheelingeasy_kml_directory) as $fileInfo) {
            if ($fileInfo->isDot())
                continue;
            $filename = $fileInfo->getFilename();
            if (strpos($filename, $old) !== false) {
                $newFileName = str_replace($old, $new, $filename);
                $msg .= "rename '$freewheelingeasy_kml_directory/$filename to $freewheelingeasy_kml_directory/$newFileName $eol";
                rename("$freewheelingeasy_kml_directory/$filename", "$freewheelingeasy_kml_directory/$newFileName");
                $cnt++;
            }
        }
        $msg .= "Updated $cnt KML files $eol";
        return $msg;
    }
    static public function buildForm($old = "", $new = "", $name = "")
    {
        global $eol, $dbkml, $errorBeg, $errorEnd;
        $msg = "";

        $msg .= "<strong>$name<strong>$eol";
        $msg .= "<form method=post action='https://edit.shaw-weil.com/changebizId/'>
			<input type=text id='old' name='old' size='80' value='$old' />
			<input type=text id='new' name='new' size='80' value='$new' />
            <input type=checkbox id='doKml' name='doKml' value='0' /> update kml files
			<input type='submit' value='Change the business Id' />
            <p> <strong>$name<strong></p>";
        return $msg;
    }
    static public function deleteBizId($attr) // delete a business
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $msg .= freeWheeling_edit_setGlobals::setGlobals("freewheelingeasy_change_bizId");
        if (freeWheeling_edit_setGlobals::notAllowedToEdit("you must be loged in to run this routine "))
            return "$errorBeg E#600 fix routine is not allowed $errorEnd";
        $bizId = rrwParam::string("bizid", $attr);
        if (empty($bizid))
            $bizId = rrwParam::string("bizId", $attr);
        if (empty($bizId)) {
            $msg .= " I#363 You must supply a business Id to delete $eol";
            return $msg;
        }
        $msg .= self::deleteBusiness($bizId);
        return $msg;
    } // end deleteBizId
    static public
    function deleteBusiness($id2Delete)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";

        $tableList = self::tablesWithBizIds();
        $msg .= "<table>";
        $color = rrwUtil::colorSwap();
        foreach ($tableList as $field => $table) {
            if (strpos($field, "-") > 0) {
                $ii = strpos($field, "-");
                $field = substr($field, 0, $ii);
            }
            $sqlBiz = "delete from $table where $field = '$id2Delete'";
            $cnt = $wpdbExtra->query($sqlBiz);
            $color = rrwUtil::colorSwap($color);
            $msg .= rrwFormat::CellRow($color, $sqlBiz, "$cnt rows of data ");
        }
        $msg .= "</table>";
        return $msg;
    } // end delete business

    private static function replaceSpaces()
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_business;
        $msg = "";
        try {
            $sql = "select bizId, bizname from $rrw_business where bizId like '% %'";
            $recspaces = $wpdbExtra->get_resultsA($sql);
            $max = $wpdbExtra->num_rows;
            $msg .= "there are $max businesses with spaces in the bizId";
            $cnt = 0;
            foreach ($recspaces as $space) {
                $cnt++;
                if ($cnt > 100)
                    return $msg;
                $bizId = $space["bizId"];
                $bizname = $space["bizname"];
                $newbizId = str_replace(" ", "-", $bizId);
                $oldLink =  $bizId;
                $newLink =  $newbizId;
                $msg .= "<table>" . rrwFormat::HeaderRow("old", "new", "bix name");
                $msg .= rrwFormat::CellRow($oldLink, $newLink, $bizname);
                $msg .= "</table>";
                $msg .= self::ChangeBizId($bizId, $newbizId, $bizname, false);
            }
        } // end try
        catch (Exception $ex) {
            $msg .= $ex->getMessage() . "$errorBeg  E#496 main upload $errorEnd";
        }
        return $msg;
    } // end function replaceSpaces
} // end class
