<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.com
 */

class freewheelingEasyCounts
{
    static public function counts($attribute = array())
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";

        ini_set("display_errors", true);
        error_reporting(E_ALL | E_STRICT);
        try {
            $msg .= freeWheeling_edit_setGlobals::setGlobals("Fix");
            $msg .= freewheeling_edit_create_views(" from fix first line");
            $msg .= rrwUtil::deltaTimer();  // start the time interval
            //    if (freeWheeling_edit_setGlobals::notAllowedToEdit("E#822 you must be logged in to run the fix routine"))
            //        return "$errorBeg E#253 fix routine is not allowed $errorEnd";
            $task = rrwParam::String("task", $attribute);
            $msg .= freewheelingEasy_fix_Class::setTitle("counts-$task");
            switch (strToLower($task)) { // task that do not require a trailId
                case strToLower("biz"):
                    $msg .= self::biz($attribute);
                    break;
                case strToLower("trail"):
                    $msg .= self::route($attribute);
                    break;
                case strToLower("route"):
                    $msg .= self::route($attribute);
                    break;
                case strToLower("biz"):
                    $msg .= self::biz($attribute);
                    break;
                case strToLower("biz"):
                    $msg .= self::biz($attribute);
                    break;
                default:
                    $msg .= "$errorBeg E#256 task = $task is not recognized. try biz,trail,route $errorEnd";
                    break;
            }
        } catch (Exception $e) {
            $msg .= "$errorBeg E# exception: " . $e->getMessage() . " at bottom of counts $errorEnd";
        }
        return $msg;
    } // end counts
    private static function biz($attributes)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        // ------------------------------------------------------------------------------------------------  bizUsed
        $sqlBiz = "select codeDescription, code, count(*) as cnt
                from $wpdbExtra->business
                left join $wpdbExtra->bizUsed on bizUsed = code
                group by bizUsed
                order by code";
        $recsBiz = $wpdbExtra->get_resultsA($sqlBiz);
        $msg .= "<table border=1>";
        $msg .= rrwFormat::CellHeaderSize(3, 10, 10, 10);
        $totalCnt = 0;
        foreach ($recsBiz as $recBiz) {
            $cnt = $recBiz["cnt"];
            $code = $recBiz["code"];
            $totalCnt += $cnt;
            $msg .= rrwFormat::CellRow($recBiz["codeDescription"], $cnt);
            if (0 == $code)
                $msg .= rrwFormat::HeaderRow("above not displayed");
        }
        $msg .= rrwFormat::HeaderRow("Total", $totalCnt);
        $msg .= "</table>";
        // ------------------------------------------------------------------------------------------------  google age
        $sqlBiz = "select bizVerified, count(*) as cnt
                from $wpdbExtra->business
                group by bizVerified
                order by bizVerified ASC";
        $recsBiz = $wpdbExtra->get_resultsA($sqlBiz);
        $msg .= "<table border=1>";
        $msg .= rrwFormat::CellHeaderSize(3, 10, 10, 10);
        $totalCnt = 0;
        foreach ($recsBiz as $recBiz) {
            $cnt = $recBiz["cnt"];
            $bizVerified = $recBiz["bizVerified"];
            $totalCnt += $cnt;
            $msg .= rrwFormat::CellRow($bizVerified, $cnt);
            if (0 == $bizVerified)
                $msg .= rrwFormat::HeaderRow("above not displayed");
        }
        $msg .= rrwFormat::HeaderRow("Total", $totalCnt);
        $msg .= "</table>";

        // ------------------------------------------------------------------------------------------------  google types
        $sqlBiz = "select google_types , count(*) as cnt
                from $wpdbExtra->services
                group by google_types
                order by cnt desc ";
        $msg .= "<p>Services  $sqlBiz</p>";
        $recsBiz = $wpdbExtra->get_resultsA($sqlBiz);
        $msg .= "<table border=1>";
        $msg .= rrwFormat::CellHeaderSize(30, 10, 10, 10);
        $totalCnt = 0;
        $oneCnt = 0;
        foreach ($recsBiz as $recBiz) {
            $cnt = $recBiz["cnt"];
            $google_types  = $recBiz["google_types"];
            $totalCnt += $cnt;
            if (1 == $cnt) {
                $oneCnt++;
                continue;
            }
            $msg .= rrwFormat::CellRow($google_types, $cnt);
        }
        $msg .= rrwFormat::HeaderRow("Total with just one cnt", $oneCnt);
        $totalCnt += $oneCnt;
        $msg .= rrwFormat::HeaderRow("Total", $totalCnt);
        $msg .= "</table>";
        return $msg;
    } //


} // end class freewheelingEasy_counts
