<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.com
 */
class FreewheelingEditDistance
{
    public static function distanceManual($attributes)
    {
        $msg = "";
        //   $msg .= rrwUtil::print_r($_POST, true, "post");
        $msg .= freeWheeling_edit_setGlobals::setGlobals("distanceManual");
        $trailId = freeWheelParam::trail($attributes);
        $msg .= self::distanceCalculator($trailId, $attributes);
        return $msg;
    }
    public static function distanceCalculator($trailId, $attributes)
    {
        //  Build a collection of joint points on the line with distance
        // and assign a mileage at each point based on "known" mileposts
        // for each mile not a milepost, create an estimated point, and assign a mileage
        // For each non-milepost icon on the line find the nearest joint point, and assign the milepost
        // for each non-milepost icon not on the line, find the nearest (joint point or icon), and assign the milepost
        //
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        //collection of points with mileages
        $msg = "";
        ini_set("display_errors", 1);
        try {
            $msg .= freeWheeling_edit_setGlobals::setGlobals("FreewheelingEditDistance");
            //           $msg .= rrwUtil::print_r( $_GET, true, "get" );
            $debugDisplaySteps = rrwParam::Boolean("debugDisplaySteps", $attributes, false);
            $debugDistance = rrwParam::Boolean("debugDistance", $attributes, false);
            $debugMileIncrements = rrwParam::Boolean("debugMileIncrements", $attributes, false);
            $debugMilesBeg = rrwParam::Number("debugMilesBeg", $attributes, false);
            $debugMilesEnd = rrwParam::Number("debugMilesEnd", $attributes, false);
            if ($debugDisplaySteps) {
                $msg .= rrwUtil::print_r($attributes, true, "I#2750 into distance with parameters ");
                $msg .= "found trailId = $trailId in the call $eol";
                // was the last set of numbers accepted?
            }
            if (self::CheckForSubmits($attributes, $msg))
                return $msg;        // a submit button was clicked and processed, so we are done with this call, return the message
            // if we get here, then we are doing the distance calculation, so we need to check that the trailId is not empty

            $sqlWhereTrail = $wpdbExtra->sqlWhereIcons($trailId);
            $msg .= self::setMilepostPrefix($trailId);      // set the prefix for the trail
            $msg .= " <a id=distanceTop></a>
                    <a id='top'></a>$eol
                    <h1>$trailId</h1>
                    <a href='https://edit.shaw-weil.com/adding-data/' target='instruction'>Distance Calculator instruction</a> <a href='#bottom'>to kml file</a>$eol";
            // builds lat, lat, distAlongMeters array
            $sqlCleanup1 = "delete from $wpdbExtra->icons where (onMap = '" . freeWheel::estimated_milepost . "' or iconName like '%estimated%' )
                                and $sqlWhereTrail";
            $result = $wpdbExtra->query($sqlCleanup1);
            if ($debugDistance)
                $msg .= "I#2753 Deleted $result " . freeWheel::estimated_milepost . " icons $eol $sqlCleanup1 $eol";
            $sqlCheckMilepost = "select * from $wpdbExtra->icons
                                    where onMap not like '%milepost%' and iconName like '%milepost%'
                                    and $sqlWhereTrail";
            $recCheckMileposts = $wpdbExtra->get_resultsA($sqlCheckMilepost);
            foreach ($recCheckMileposts as $recCheck) {
                $iconLink = freeWheelFormat::EditIconLink($recCheck["iconId"]);
                $latLink = freeWheelFormat::latitudeMapLink($recCheck["latitude"], $recCheck["longitude"]);
                $msg .= "E#2754 Milepost icon $iconLink  not marked as milepost$eol";
            } // end foreach recCheck
            $sqlCleanup2 = "update $wpdbExtra->icons set milepost = null
                            where not onMap like '%milepost%' and $sqlWhereTrail";
            $result = $wpdbExtra->query($sqlCleanup2);
            if ($debugDistance) {
                $msg .= "I#2755 set $result milepost to null not being real milepost points$eol";
                $msg .= freewheeling_kml_common::DisplayIcons($trailId, "before building the table");
            }
            ///check that all milepost icons have a mileage
            if ("cando" == $trailId) {
                $msg .= "I#2756 ignore test for all milepost icons have a mileage for cando $eol";
            } else {
                $sqlBadMileage = "select * from $wpdbExtra->icons where iconName like '%milepost%' and milepost is null and $sqlWhereTrail";
                $recBadMileage = $wpdbExtra->get_resultsA($sqlBadMileage);
                if (0 != $wpdbExtra->num_rows) {
                    foreach ($recBadMileage as $recBad) {
                        $recBad["milepost"];
                        $iconLink = freeWheelFormat::EditIconLink($recBad["iconId"]);
                        $latLink = freeWheelFormat::latitudeMapLink($recBad["latitude"], $recBad["longitude"]);
                        $msg .= "<table>";
                        $msg .= rrwFormat::HeaderRow("problem", "trail", "icon", "mileage", "latitude, longitude");
                        $msg .= rrwFormat::CellRow(
                            "E#2757 Bad Mileage",
                            $trailId,
                            $iconLink,
                            is_null($recBad["milepost"]) ? "null" : $recBad["milepost"],
                            $recBad["latitude"] . $recBad["longitude"] . $latLink
                        ) . "</table> $errorEnd $eol";
                    }
                    return $msg;
                }
            }
            // looks like all the checks are done, and  we are ready to proceed
            $debugDistance = true;
            if ($debugDistance)
                $msg .= "calling BuildTableOfPointsALongLines($trailId, $trailId, false)$eol";
            $latTable = new freewheelingLineTable($trailId, $trailId, $msg);
            // $msg .= $latTable->dumpMilageTableByPoints(0, 100, "after table build");
            if ($debugDistance) {
                $msg .= freewheeling_kml_common::DisplayIcons($trailId, "I#2758 after building the table, about to work with icons");
                $msg .= "I#2762 calling assert MilePoints On Line()$eol";
            }
            if ($debugDistance)
                $msg .= "calling BuildTableOfPointsALongLines($trailId, $trailId, false)$eol";
            $msg .= $latTable->verifyOrFixMilePointsOnLine();   // move any milepost icons that are not on the line to the line
            $msg .= $latTable->checkMilePointsOnLine();    // throws an exception if any milepost icons are not on the line
            if ($debugMilesBeg)
                $msg .= $latTable->dumpMilageTableBetweenMiles($debugMilesBeg, $debugMilesEnd, "I#2759 after BuildTableOfMilesALongLines");
            // fix all the default milepost prefix
            $sqlPrefixTrail = "select distinct trMilepostPrefix from $wpdbExtra->trails where trId = '$trailId'";
            $defaultPrefix = $wpdbExtra->get_var($sqlPrefixTrail);
            if ($debugDistance)
                $msg .= "default Milepost Prefix is $defaultPrefix $eol";
            $sqlPrefix = "update $wpdbExtra->icons set milepostPrefix = '$defaultPrefix' where trailId = '$trailId' ";
            $result = $wpdbExtra->query($sqlPrefix);
            // maybe zero updates if the prefixes are already set
            if (strpos($msg, "E#") !== false)
                throw new Exception(" $msg $errorBeg I#2760 There has been a previous error during set up  $errorEnd ");
            if (false) {
                $msgNote = "$errorBeg I#2761 terminated for distance debug $errorEnd ";
                $msg .= $msgNote . $latTable->dumpMilageTableByPoints() . $msgNote;
                return $msg;
            }
            $msg .= $latTable->BuildTableOfMilePostsAlongLines();            // build table of known ,mileposts
            // we now have a completely filled in milepost array.
            // now assignMilageToNulls
            if ($debugMilesBeg) {
                $msg .= freewheeling_kml_common::DisplayIcons($trailId, "before assignMilageToNulls");
                $msg .= $latTable->dumpMilageTableBetweenMiles($debugMilesBeg, $debugMilesEnd, "before assignMilageToNulls");
            }
            $msg .= rrwUtil::TimerTerminate("$msg I#2763 after assignMilageToNulls");
            // work is done, now display the results
            // code to build the new kml file >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
            $msg .= self::setMilepostPrefix($trailId);      // set the prefix for the trail
            // return  "$msg $eol temp check hanging  --------before -----createKMLFromDatabase-------3-----$eol";
            $msg .= Freewheelingeasy_kml_create::createKMLFromDatabase($trailId);
            //       return  "$msg $eol temp check hanging --------after -----createKMLFromDatabase-------3-----$eol";
            // and display stuff
            $msg .= freewheelingeasy_kml_merge::updateTheJunctionsMileages();  //----------------------------------------------------------------   update the junctions milages
            $msg .= self::DisplayAllTables($latTable, sqlWhereTrail: $sqlWhereTrail);
            $msg .= self::DisplayAcceptMilageButton($trailId);
            $msg .= "<a id='displayAfterDistance'></a>" . Freewheelingeasy_kml_create::jumpToLinks();
            $msg .= freewheeling_kml_common::displayIconsLines($trailId, "");
            //    return  "$msg $eol temp check hanging -----after -------displayIconsLines--------3-----$eol";
            $server = "https://edit.shaw-weil.com";
            $thisVersion = freewheeling_kml_common::findLatestTrailFileThisVersion($trailId, $msg);
            $filename = $trailId . $thisVersion;
            $msg .= Freewheelingeasy_kml_create::updateTrSource($filename);
            $msg .= freewheeling_edit_create_views("distance", true); // icons... has changed
        } catch (Exception $ex) {
            $msg .= $ex->getMessage();
            $msg .= rrwFormat::backtrace("I#2765  at bottom of distance see else where for error");
        } // end catch
        $msg .= "<a id='bottom'></a>
                <a href='#top'>go to start of distance calculation</a> $eol";
        rrwUtil::deltaTimer("I#2766 processed distances using ");
        //   return  "$msg $eol temp check hanging -----before  -------exit  distance calculator--------3-----$eol";
        return $msg;
    } // end distance
    public static function DisplayAcceptMilageButton($trailId)
    {
        $msg = "";
        $msg .= "<form method='post' action='https://edit.shaw-weil.com/distance-calculator/'>
                          <input type='hidden' name= 'trailId' value='$trailId' />
                       <button name= 'SubmitDistance' value='SubmitDistance' >Accept  Mileage Numbers</button>
                       <button name= 'SubmitNear' value='SubmitNear' >start Near by process</button>
                   </form>";
        return $msg;
    }
    /**
     * Checks for form submit actions in the provided attributes and updates trail-related statuses accordingly.
     *
     * Handles:
     * - "SubmitDistance": marks merge as done for the given trail, updates icon ranges, appends informational
     *   messages (including links for anomaly checks and amenity break adjustments), and updates junction mileages.
     * - "SubmitNear": marks merge as done and "trailNear" as ready for the given trail, and sets "iconNear" dates
     *   for icons where the near date is empty or marked as "not yet".
     *
     * @param array<string,mixed> $attributes Source of request parameters (expects keys like "SubmitDistance", "SubmitNear", "trailId").
     * @param string              $msg        Message accumulator; modified by reference with status output.
     *
     * @return bool True if a recognized submit action was processed; false otherwise.
     */
    public static function CheckForSubmits($attributes, &$msg)
    { // did the click on accept distances button happen?
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;

        $SubmitDistance = rrwParam::String("SubmitDistance", $attributes);
        if (! empty($SubmitDistance)) {
            $trailId = rrwParam::String("trailId", $attributes);
            // call by the push of the "Accept these Mileage Numbers" button
            $msg .= freewheelingeasy_kml_merge::set_mergeStatus('done', $trailId);
            $msg .= "I#2751 Accepted distance for  today$eol";
            $msg .= freewheelingEasy_setIconRange::setIconRange();
            $msg .= "$eol Run <a href='https://edit.shaw-weil.com/kmlclean/' target='check' >
                                check for anomalies  </a> $eol ";
            $msg .= "$eol Since the mileages moved, Run
                        <a href='https://edit.shaw-weil.com/fix/?task=adjustamenitybreaks' >
                        adjust amenity Mileage Breaks </a>$eol";
            $msg .= freewheelingeasy_kml_merge::updateTheJunctionsMileages(); // make the next trail as ready
            return true;
        } // end if SubmitDistance
        $SubmitNear = rrwParam::String("SubmitNear", $attributes);
        if (! empty($SubmitNear)) {
            $trailId = rrwParam::String("trailId", $attributes);
            // call by the push of the "Accept these Mileage Numbers" button
            $msg .= freewheelingeasy_kml_merge::set_mergeStatus('done', $trailId);
            $msg .= freewheelFormat::setStatus('ready', "trailNear", $trailId);
            $recIcons = $wpdbExtra->get_resultsA("select iconId, icDateNear from $wpdbExtra->icons where trailId = '$trailId'");
            foreach ($recIcons as $recIcon) {
                $icDateNear = $recIcon["icDateNear"];
                $iconId = $recIcon["iconId"];
                if (empty($icDateNear) || strPos($icDateNear, "not yet") !== false)
                    $msg .= freewheelFormat::setStatus('2002-03-03', "iconNear", $iconId);
            }
            $msg .= "I#2752 Accepted start near $eol";
            return true;
        } // end if SubmitNear"
        if (empty($trailId)) {
            $msg .= "<form >";
            $msg .= "<input type='text' id='increment' value='1' />";
            $msg .= freewheelingEasy_kml_trailList::trailSelectionBox(
                false,
                "Type/select trail/route name to verify distance",
                "Display Distance Deltas"
            );
            $msg .= "</form>";
            return true;
        } // end if empty trailId
        return false;
    }// end CheckForSubmits
    /**
     * Sets the milepost prefix for the given trail.
     *
     * @param string $trailId The ID of the trail.
     * @return string Message indicating the default milepost prefix.
     */
    public static function setMilepostPrefix($trailId)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $debugSetPrefix = rrwParam::isDebugMode("setMilepostPrefix", false);
        // fix all the default milepost prefix
        $sqlPrefixTrail = "select distinct trMilepostPrefix from $wpdbExtra->trails where trId = '$trailId'";
        if ($debugSetPrefix)
            $msg .= "I#2767 $sqlPrefixTrail $eol";
        $defaultPrefix = $wpdbExtra->get_var($sqlPrefixTrail);
        if ($debugSetPrefix)
            $msg .= "I#2768 default Milepost Prefix is $defaultPrefix $eol";
        $sqlPrefix = "update $wpdbExtra->icons set milepostPrefix = '$defaultPrefix' where trailId = '$trailId' ";
        if ($debugSetPrefix)
            $msg .= "i#2769 $sqlPrefix $eol";
        $wpdbExtra->query($sqlPrefix);
        if ($debugSetPrefix)
            $msg .= "I#2770 set milepostPrefix to $defaultPrefix for $wpdbExtra->num_rows records $eol";
        return $msg;
    } // end setMilepostPrefix
    /*
	 * Updates all the milepost icons to be a PNG file.
	 *
	 * This function searches for all the milepost icons that are multiples of 1
	 * and updates the icon style accordingly. It handles both real and
	 * freeWheel::estimated_milepost.
	 *
	 * @return string Message indicating the number of records updated and the SQL queries executed.
	public  function milepostPng()
	{
		// update all the milepost icons to be a png file
		// search for all the milepost icons that are multiples of 1
		//   and update the icon  style file
		global $eol, $errorBeg, $errorEnd;
		global $wpdbExtra;
		$msg = "";
		$debugMilePng = rrwParam::isDebugMode("milepostPng", false);
		// real milepost
		$sql1 = "update `$wpdbExtra->icons`
		set iconStyle = concat( 'mpPic', milepost, '.png'  )
		where onMap like 'milepost%' and mod(milepost,1) = 0
		and not milepost = 0 and not milepost like '%Estimated%' ";
		$cnt = $wpdbExtra->query($sql1);
		if ($debugMilePng) $msg .= "updated $cnt records with $sql1 $eol";
		// freeWheel::estimated_milepost
		$sql2 = "update `$wpdbExtra->icons`
		set iconStyle = concat( 'mpEst', milepost, '.png'  )
		where onMap like 'milepost%' and mod(milepost,1) = 0
		and not milepost = 0 and not milepost like '%Estimated%' ";
		$cnt = $wpdbExtra->query($sql2);
		if ($debugMilePng) $msg .= "updated $cnt records with $sql2";
		// clean up
		$sql3 = "update $wpdbExtra->icons set iconStyle = replace (iconStyle, '.000', '' )  ";
		$cnt = $wpdbExtra->query($sql3);
		if ($debugMilePng) $msg .= "replaced .000  for $cnt records with $sql3$eol";
		return $msg;
	} // end milepostPng
	 */

    private static function DisplayAllTables($latTable, $sqlWhereTrail)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        try {
            $whereList = array(
                " onMap = 'milepost' ",
                " (onMap = 'milepost' or onMap = '" . freeWheel::estimated_milepost . "' or onMap = 'launch' )",
                " (1 = 1)  ",
            );
            //          $whereList = array( " onMap = 'milepost' " );      // only one table for now, but could be more if we want to show all the icons
            //		-------------------------------------------- check the prefixes
            $sqlPrefix = "select distinct milepostPrefix from $wpdbExtra->icons
				where $sqlWhereTrail ";
            $recPrefixes = $wpdbExtra->get_resultsA($sqlPrefix);
            if ($wpdbExtra->num_rows != 1 || $recPrefixes === false) {
                $msg .= "$errorBeg E#2772 Did not find consistent milepost prefix in trails. $errorEnd $sqlPrefix $eol";
            }

            foreach ($whereList as $sqlIcons) {
                //       $sqlIcons = str_replace( "business", $sqlBusinessItems, $sqlIcons );
                $msg .= self::DisplayOneTable($latTable, $sqlWhereTrail, $sqlIcons);
            } // end for($iiWhere; )
        } catch (Exception $ex) {
            $msg .= "$msg $errorBeg " . $ex->getMessage() . "E#2775  bottom of display all tables $errorEnd";
        }
        return $msg;
    } // end DisplayAllTables
    private static function DisplayOneTable($latTable, $sqlWhereTrail, $where)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        global $meters2Mile;
        //       global $lat, $lng, $line_id; //collection of points
        $msg = "";
        $debugTable = false;
        if ($debugTable)
            $msg .= "select * $sqlWhereTrail and $where $eol";

        $sqlIcons = "select 'icon', iconId, iconName, milepost,  latitude, longitude
                            from $wpdbExtra->icons where $sqlWhereTrail and $where ";
        $sqlIcons .= " order by milepost ";
        if ($debugTable)
            $msg .= "$sqlIcons $eol ";
        $recSqlIcons = $wpdbExtra->get_resultsA($sqlIcons);
        // now put the end points into the output array
        $resultOneEnd = $latTable->fillResults(0);
        $resultOtherEnd = $latTable->fillResults($latTable->get_latCount() - 1);
        $recIcons = array();
        for ($ii = 0; $ii < $wpdbExtra->num_rows; $ii++) {
            $recIcons[$ii + 1] = $recSqlIcons[$ii];                 // make space at zero for the start of line, and at the end for the end of line
        }
        $lastPoint = $wpdbExtra->num_rows + 1;
        if ($resultOneEnd->milePostsAlong < $resultOtherEnd->milePostsAlong) {
            $zero = 0;
            $tail = $lastPoint;
        } else {
            $zero = $lastPoint;
            $tail = 0;
        }
        $recIcons[$zero] = array(
            "iconId" => -1,
            "iconName" => "One end of line",
            "milepost" => $resultOneEnd->milePostsAlong,
            "latitude" => $resultOneEnd->lat,
            "longitude" => $resultOneEnd->lon,
            "distAlongMeters" => $resultOneEnd->distAlongMeters
        );

        $recIcons[$tail] = array(
            "iconId" => -2,
            "iconName" => "Other end of line",
            "milepost" => $resultOtherEnd->milePostsAlong,
            "latitude" => $resultOtherEnd->lat,
            "longitude" => $resultOtherEnd->lon,
            "distAlongMeters" => $resultOtherEnd->distAlongMeters
        );

        for ($ii = 1; $ii <= $wpdbExtra->num_rows; $ii++) {
            if (is_null($recIcons[$ii]["milepost"]))
                $msg .= "E#2776 Milepost is null for icon " . freeWheelFormat::EditIconLink($recIcons[$ii]["iconId"]) . " $eol";
            $results = $latTable->GivenLatLonFindExactMatch($recIcons[$ii]["latitude"], $recIcons[$ii]["longitude"]);
            $recIcons[$ii]["distAlongMeters"] = $results->distAlongMeters;
        }
        $color = rrwUtil::colorSwap();
        $msg .= "<table>\n";
        $firstHead = "From/Line name ($where";
        if (strlen($where) > 25)      // split title into to lines
            $IIor = strrpos($where, "or", 0);
        else
            $IIor = -1;
        $firstHead = substr($where, 0, $IIor) . "</br" . substr($where, $IIor);
        $IIor = strrpos($firstHead, "or", $IIor + 5);
        $firstHead = substr($firstHead, 0, $IIor) . "</br" . substr($firstHead, $IIor);
        $msg .= rrwFormat::HeaderRow(
            $firstHead,
            "latitude",
            "longitude",
            "Milepost",
            "Milepost delta miles",
            "LineWork delta meters",
            "Milepost delta meters",
            "meter Error &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ",
        );
        for ($ii = 0; $ii <= $wpdbExtra->num_rows; $ii++) {
            $msg .= self::displayTheIconLine($recIcons[$ii], $color, $eol);
            $msg .= self::displayTheDifferenceLine($recIcons[$ii], $recIcons[$ii + 1], $color, $eol);
        }
        $msg .= self::displayTheIconLine($recIcons[$lastPoint], $color, $eol);
        $msg .= "</table>$eol";
        return $msg;
    }
    private static function displayTheIconLine($recIcon, $color, $eol)
    {
        $msg = "";
        $milepost = $recIcon["milepost"];
        $milePostDisplay = freeWheelFormat::milePost("", $milepost);
        $milePostDisplay .= "** " . $recIcon["distAlongMeters"];

        $iconName = $recIcon["iconName"];
        $iconId = $recIcon["iconId"];
        $latitude = $recIcon["latitude"];
        $longitude = $recIcon["longitude"];
        $EditIconLink = freeWheelFormat::iconIdMapLink($iconId);
        $EditIconLink .= freeWheelFormat::EditIconLink($iconId, $iconName);
        $msg .= rrwFormat::CellRowColor(
            $EditIconLink,
            $latitude,
            $longitude,
            "$milePostDisplay",
            "",
            "",
            "",
            "",
            ""
        );
        return $msg;
    }
    private static function displayTheDifferenceLine($recIconsBack, $recIconsNext, $color, $eol)
    {
        $msg = "";
        if (!array_key_exists("distAlongMeters", $recIconsBack) || !array_key_exists("distAlongMeters", $recIconsNext)) {
            $msg .= "E#2777 missing milepost in difference line $eol";
            $msg .= rrwUtil::print_r($recIconsBack, true, "back icon ");
            $msg .= rrwUtil::print_r($recIconsNext, true, "next");
            return $msg;
        }

        $milePostDeltaMiles = round($recIconsNext["milepost"] - $recIconsBack["milepost"], freeWheel::mileRoundTo);
        $milePostDeltaMeters = round($milePostDeltaMiles * freeWheel::metersPerMile, freeWheel::meterRoundTo);
        $LineWorkDeltaMeters = round(abs($recIconsNext["distAlongMeters"] - $recIconsBack["distAlongMeters"]), freeWheel::meterRoundTo);
        $meterError = $LineWorkDeltaMeters - $milePostDeltaMeters;
        if ($milePostDeltaMiles == 0)
            $meterErrorPerMile = 0;
        else
            $meterErrorPerMile = $meterError / $milePostDeltaMiles;
        $meterErrorDisplay = sprintf("total %01.2f m, ~ %01.2f ", $meterError, $meterErrorPerMile);
        if ($meterError < -1)
            $meterErrorDisplay .= "move closer to previous";
        elseif ($meterError > 1)
            $meterErrorDisplay .= "move further from previous";
        else
            $meterErrorDisplay .= "good";
        $msg .= rrwFormat::CellRow(
            $color,
            "",
            "",
            "",
            "",
            $milePostDeltaMiles,
            sprintf("%01.2f", $LineWorkDeltaMeters),
            sprintf("%01.2f", $milePostDeltaMeters),
            "$meterErrorDisplay"
        );
        return $msg;
    }

    public static function insertMilePostIntoDatabase($latitude, $longitude, $milepost, $name, $trailId)
    {
        // if milepost has value iconName gets that value , else append 3 to existing name
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $recIcon = array();
        $debugInsertIcon = false;
        if ($debugInsertIcon)
            $msg .= "insert icon ($latitude, $longitude, $milepost,$trailId  ) $eol";
        $sqlPrefix = "select trMilepostPrefix from $wpdbExtra->trails where trId = '$trailId' ";
        $milepostPrefix = $wpdbExtra->get_var($sqlPrefix); // get the prefix, just grab the first one.
        if ($debugInsertIcon)
            $msg .= "using milepost prefix $milepostPrefix) $eol";
        $recIcon["iconId"] = "";
        $recIcon["trailId"] = $trailId;
        $recIcon["latitude"] = round($latitude, freeWheel::latRoundTo);
        $recIcon["longitude"] = round($longitude, freeWheel::latRoundTo);
        $recIcon["plusCode"] = null; // will get reset sometime
        $recIcon["minutesFromPgh"] = null; // will get reset sometime
        $recIcon["isTrailHead"] = 0;
        $recIcon["icDateNear"] = "2001-08-08";
        $recIcon["source"] = "Milepost calculation";
        $recIcon["milepostPrefix"] = "$milepostPrefix";
        $recIcon["milepost"] = $milepost;
        $recIcon["iconName"] = $name;
        // recIcon["sort"] will get reset when we reprocess the lines
        if (false === strpos($name, "Est")) {
            $recIcon["onMap"] = "milepost";
            $recIcon["iconStyle"] = "mpPic$milepost.png";
        } else {
            $recIcon["onMap"] = freeWheel::estimated_milepost;
            $recIcon["iconStyle"] = "mpEst$milepost.png";
        }
        // recIcon["sort"] will get reset when we reprocess the lines
        if ($debugInsertIcon) {
            $msg .= rrwUtil::print_r($recIcon, true, "The new icon ");
            $msg .= rrwUtil::print_r($recIcon, true, "E#2789 the inserted icon nfo");
        }
        $sqlExists = "select iconId from $wpdbExtra->icons
                where iconName = '$name'  and trailId = '$trailId' "; // is there a previous record
        $iconIdOld = $wpdbExtra->get_var($sqlExists);
        if (! empty($iconIdOld)) {
            $msg .= "E#2790 Deleting previous record $trailId/" .
                $recIcon["iconName"] . " with iconId of $iconIdOld $eol";
            $sqlDelete = "delete from $wpdbExtra->icons where iconId = $iconIdOld ";
            $checkDelete = $wpdbExtra->query($sqlDelete);
            if (empty($checkDelete))
                throw new Exception("$msg E#2791 delete of previous failed -- $sqlDelete $eol");
        }
        $cnt = $wpdbExtra->insert($wpdbExtra->icons, $recIcon);
        if (1 != $cnt) {
            throw new Exception("$msg $errorBeg E#2792 insert of duplicate point did not work $errorEnd " .
                $eol);
        }
        $sqlId = "select iconId from $wpdbExtra->icons
                where iconName = '" . $recIcon["iconName"] . "'";
        $iconIdNew = $wpdbExtra->get_var($sqlId);
        if ($debugInsertIcon)
            $msg .= "placed new icon with  iconId  of $iconIdNew $eol $sqlId $eol";
        return $msg;
    } // end insertIcon
    private static function assignMilageToOffLine($trailId)
    {
        // special case - not on line - use nearest point
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $debugNull = rrwParam::isDebugMode("debugNull");
        // deal with the points that are not on a line
        try {
            $sqlNull = "select iconId, iconName, iconStyle, latitude, longitude,
                        milepost, onMap, milepostPrefix
			            from $wpdbExtra->icons
                        where (milepost is null or milepost = '')
                        and onMap like '%offline%'
                        and trailId = '$trailId'";
            $recsNulls = $wpdbExtra->get_resultsA($sqlNull);
            if ((0 == $wpdbExtra->num_rows) || is_null($recsNulls))
                return "$msg I#2793 No offLine points with a null mileage $eol ";
            if ($debugNull)
                $msg .= "I#2794 there are " . count($recsNulls) . " off line points with a null mileage $eol";
            foreach ($recsNulls as $recNull) {
                $iconId = $recNull["iconId"];
                $iconName = $recNull["iconName"];
                $latitude = $recNull["latitude"];
                $longitude = $recNull["longitude"];
                if ($debugNull)
                    $msg .= "1716 self::assignMilageToOffLine($latitude, $longitude, $iconId, $iconName)";
                $degrees4TenMiles = freewheelFormat::get_degrees4TenMiles();
                $sqlKnownMilage = "select iconName, milepost, sort  from $wpdbExtra->icons
                                    where st_distance(POINT( $latitude, $longitude),  point(latitude,longitude) ) < $degrees4TenMiles
                                    and milepost is not null and milepost != ''
                                    order by st_distance(POINT( $latitude, $longitude),  point(latitude,longitude)) asc limit 10";
                if ($debugNull)
                    $msg .= "I#2795 look for point with milages using &nbsp; $sqlKnownMilage $eol";
                $recKnownMilage = $wpdbExtra->get_resultsA($sqlKnownMilage);
                if ($wpdbExtra->num_rows < 1) {
                    $msg .= "$errorBeg E#2796 no nearby points with mileages found for $iconName $errorEnd sqlKnownMilage $eol";
                    return $msg;
                }
                $nearByName = $recKnownMilage[0]["iconName"];
                $milepost = $recKnownMilage[0]["milepost"];
                $sort = $recKnownMilage[0]["sort"];
                if ($debugNull)
                    $msg .= "I#2797 using $milepost, sequence $sort from $nearByName for $iconName $eol";
                $sqlMile = "update $wpdbExtra->icons set milepost = $milepost, sort = $sort where iconId = $iconId ";
                $wpdbExtra->query($sqlMile);
            } // end foreach ($recNulls as $recNull) for off line points
        } catch (Exception $ex) {
            $msg .= "$errorBeg  E#2798 thrown out of assignMilageToNulls: " . $ex->getMessage() . $errorEnd;
            throw new Exception("$msg");
        } // end try catch
        return $msg;
    }
} // end class freewheelingEditDistance
