<?php
//		Freewheeling Easy Mapping Application
//		A collection of routines for display of trail maps and amenities
//  	copyright Roy R Weil 2019 - https://royweil.com
class freewheeling_Google_Costs
{
    /**
     * Generates the Google Cost Page.
     *
     * This static public function generates the Google Cost Page by calling the googleCosts method.
     * If an exception occurs during the execution of googleCosts, the exception message is appended to the output.
     * Extra routine to capture and just display the exception, since called tend to throw exceptions
     * @param array $attributes Attributes passed to the function.
     * @return string The generated message or exception message.
     */
    static public function googleCostPage(array $attributes)
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        try {
            $dateformat = rrwParam::string("month", $attributes, "");
            //  $msg .= rrwUtil::print_r($attributes, true, "I#1978 googleCostPage attributes");
            $msg .= self::googleCosts($dateformat);
        } catch (exception $e) {
            $msg .= $e->getMessage() . "$errorBeg E#1979 at bottom googleCostPage $errorEnd";
        }
        return $msg;
    } // end function googleCostPage
    static public function googleCosts($dateformat = "")
    {
        // print cost table for current month
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $debugCosts = rrwParam::isDebugMode("costs");
        try {
            $msg .= freeWheeling_edit_setGlobals::setGlobals("google Costs");
            if (empty($dateformat))
                $dateformat = date("Y-m");
            if ($debugCosts) $msg .= "I#1975 found date $dateformat $eol";
            if (!empty($title))
                $msg .= "<h2>$title</h2>$eol";
            else
                $msg .= "<h2>Google Costs for $dateformat</h2>$eol";
            $sqlCost = "select codeDescription, billCount,
                    billCount, round( GREATEST(billCount - FreeLimit, 0 ) * costPer,2)  as dollar,
                    billApiKey, googleType, rowKey, costPer
                    from $wpdbExtra->google_billing_rates
                    left join $wpdbExtra->googleBilling on googleType = billType
                    where billYearMonth = '$dateformat'
                    order by billApiKey, codeSort ";
            if ($debugCosts) $msg .= "$sqlCost $eol";
            $msg .= self::printCostTable($sqlCost, $dateformat);
            $msg .= self::msgFooter();
        } catch (exception $e) {
            $msg .=  $e->getMessage() . "$errorBeg E#1999 at bottom google Costs $errorEnd";
            throw new exception($msg);
        }
        return $msg;
    } // end function googleCosts
    private static function printCostTable($sqlCost, $dateformat)
    {
        // print cost table for current sql i.e. for items billed tis month
        global $wpdbExtra, $rrw_codes;
        global $eol, $errorBeg, $errorEnd;
        global $cntMissGoog;
        $msg = "";
        $debugCost = rrwParam::isDebugMode("debugCosts");
        $showBigListing = false;
        try {
            $recCosts = $wpdbExtra->get_resultsA($sqlCost);
            // $msg .= rrwUtil::print_r($recCosts, true, "I#1973 printCostTable: recCosts from sql ");
            if ($wpdbExtra->num_rows < 1 || false === $wpdbExtra->num_rows) {
                $msg .= "$errorBeg E#1977 no costs yet for $dateformat $errorEnd";
                return $msg;
            }
            if ($debugCost) {
                $msg .= "<table>\n";
            }
            $pastKey = $recCosts[0]["billApiKey"];
            $pastApiName = freewheelAPI_2025::getGoogleBillingName($pastKey);
            $accumulateTotals = array();
            $cnt = 0;
            $numCols = 30;
            $sumCost = 0;
            $tableArray = array();
            for ($ii = 0; $ii < $numCols * 2; $ii++) {
                $lineArray[$ii] = 0;
            }
            foreach ($recCosts as $recCost) {
                if ($debugCost) $msg .= rrwUtil::print_r($recCost, true, "I#1972 printCostTable: processing recCost ");
                $apiKey = $recCost["billApiKey"];
                $apiname = freewheelAPI_2025::getGoogleBillingName($apiKey);
                if ($pastKey != $apiKey) { // new key , display and save totals
                    $accumulateTotals[$pastKey] = $sumCost;
                    //$msg .= rrwFormat::CellRow("", "", "", "");
                    $lineArray[30] = $sumCost;
                    $lineArray[1] = $sumCost;
                    $lineArray[0] = $pastApiName;
                    $tableArray[$cnt] = $lineArray;
                    $cnt++;
                    $headerNeeded = true;
                    $pastKey = $apiKey;
                    $pastApiName = $apiname;
                    $sumCost = 0;
                    $lineArray = array();
                    for ($ii = 0; $ii < ($numCols * 2); $ii++) {
                        $lineArray[$ii] = 0;
                    }
                    $lineArray[0] = $apiname;
                    $lineArray[1] = $sumCost;
                } // end of different pastKey
                $cntMissGoog++;
                $codeDescription = $recCost["codeDescription"];
                $countItem = $recCost["billCount"];
                $dollar = round($recCost["dollar"], 2);
                $key1 = $recCost["rowKey"] - 1;
                $lineArray[$key1 * 2] = $countItem;
                $lineArray[($key1 * 2) + 1] = $dollar;
                if ($showBigListing) $msg .= rrwFormat::CellRow($codeDescription, $countItem, $dollar);
                $sumCost += $dollar;
            } // end foreach
            $accumulateTotals[$pastKey] = $sumCost;
            $lineArray[30] = $sumCost;
            $lineArray[1] = $sumCost;
            $lineArray[0] = $pastApiName;
            $tableArray[$cnt] = $lineArray;
            $msg .= "</table>";
            $sumCost = 0;
            // print the table in sorted order
            if ($debugCost) $msg .= rrwUtil::print_r($tableArray, true, "I#1985 printCostTable: processing tableArray ");
            $msg .= "<table>  \n";
            // display the headings
            $msg .=  "<tr > <td>&nbsp;Billing Code</td>
                                <td style='border-style: solid; column-span:2;'  > Line Total</td>\n";
            $sqlDesc = "select codeDescription,rowKey from $wpdbExtra->google_billing_rates order by rowKey";
            $recs = $wpdbExtra->get_resultsA($sqlDesc);
            if ($debugCost) $msg .= rrwUtil::print_r($recs, true, "I#1991 printCostTable: processing recs for headings ");
            foreach ($recs as $rec) {
                $msg .= "<td   style='border-left: solid; column-span:2; align:center; > ' >" .
                    $rec["codeDescription"] . "</td><td align:right;> &nbsp;</td>\n";
            }
            $msg .= "</tr>";
            //     asort($tableArray[1], SORT_NUMERIC);
            array_multisort($tableArray, SORT_ASC);
            foreach ($tableArray as $lineArray) {
                $msg .= "<tr>";
                for ($ii = 0; $ii < $numCols * 2; $ii++) {
                    if (0 == $lineArray[$ii] && 0 != $ii)
                        $msg .= "<td>&nbsp;</td>";
                    else
                        $msg .= "<td>" . $lineArray[$ii] . "</td>";
                }
                $msg .= "</tr>";
            }
            $msg .= rrwFormat::CellRow("", "<strong>Total</strong", "<b>total</b>", $sumCost);
            $msg .= "</table>";
        } catch (exception $e) {
            $msgErr = $e->getMessage() . "$errorBeg E#1976 at bottom printCostTable $errorEnd";
            throw new exception($msg . $msgErr);
        }
        return $msg;
    } // end function printCostTable
    private static function msgFooter()
    {
        global $eol;
        return "actual <a href='https://console.cloud.google.com/billing'
       target='bill'>google bills are different</a>,
   <a href='https://console.cloud.google.com/apis/dashboard?invt=Ab6yVA&authuser=1&project=amentities'
       target='bill'>show google bills </a> $eol $eol";
    } // end function msgFooter
} // end class freewheeling_google_Costs