<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.com
 */
/*	Reads google data and builds the amenities database
 * copyright Roy R Weil
 *
 *  if bizId=nnnnnn . google update that business - maybeUpdateDatabaseWithPlaceId( $bizId );
 *  task ?Near id=  trailId,groupId, iconName- search 10 around that place
 *             for trail or group search around milepost mod 5
 %
 *
 * https://developers.google.com/places/web-service/intro
 * https://developers.google.com/places/web-service/search
 * https://developers.google.com/places/web-service/supported_types#table
 * https://developers.google.com/maps/documentation/javascript/directions
<script type='text/javascript' src='https://maps.googleapis.com/maps/api/js?$googleMapsapiKey&libraries=places'>
</script>
*/

class freeWheelingGoogleUpdate
{
    /*  ?bizAge=<days)  Google update all businesses older than <days> days
     *  ?id=<bizId>     Google update that business
     *     Google update a business, means get information from google, wipe out route if lat change
     *
     * ?verify=1  Update the business information for businesses bizUsed ='later'
    *  ?id=<trailId> or ?id=<groupId> find business within 10 mile every 5 miles along
     *  ?id=<iconId> or ?id=<iconName> find business within 10 mile for that icon
     * *searchByLatLng( $latitude, $longitude ) does the hard work. All other functions should call it
     *     callers if processing multiple LatLng should call timeUp between calls.
     *
     */
    public  static $latLonChanged = false;          // set true if lat/lon changed by a reasonable amount to indicate a run of routeing
    private static $bizDetail = array();            // detail business record as extracted from google
    private static $bizRecord = array();            // Database record form the database
    private static $updateBusiness = array();       // items to be updated in business record.
    private static $knownServiceTypes = array();    // list of service types known in the database
    private static $blankOutServiceCodes = array(); // string to blank out all service codes

    static public     function googleUpdateManual($attributes)
    {
        global $eol, $errorBeg, $errorEnd;
        global $foundBusinessesList, $foundAddressList;
        // Message accumulator for function output and error reporting
        $msg = "";

        try {   // provide exit with messages
            $foundBusinessesList = array(); // list of items processed
            $foundAddressList = array();
            $debugUpdateManual = rrwParam::isDebugMode("debugUpdateManual");
            ini_set("display_errors", true);
            $msg .= freeWheeling_edit_setGlobals::setGlobals("freeWheelingGoogleUpdate");
            $msg .= freewheeling_edit_create_views();
            $bizId = rrwParam::String("bizId", $attributes, "");
            if (!empty($bizId)) {
                $msg .= self::maybeUpdateDatabaseWithPlaceId($bizId, "");
                return $msg;
            }
            $automated = rrwParam::Boolean("automated", $attributes);
            if ($automated)
                $task = "automated";
            else
                $task = rrwParam::String("task", $attributes, "");
            switch ($task) {
                case "bizAge":
                    $bizAge = rrwParam::Number("bizAge", $attributes, 90);
                    $msg .= self::ProcessBizAge($bizAge);
                    break;
                case "automated":
                    if ($debugUpdateManual) $msg .= "trying automated merge $eol";
                    if (! array_key_exists("allowed", $_GET))
                        $_GET["allowed"] = 1;
                    $msg .= self::googleUpdateAutomated($attributes);
                    break;
                default:
                    $msg .= "$errorBeg E#336 Unknown task of $task $errorEnd";
                    return $msg;    //
            }
        } catch (Exception $ex) {
            $msg .= $ex->getMessage() . "$errorBeg  E#669 at bottom of upload google $errorEnd";
        }
        $msg .= freewheeling_Google_Costs::googleCosts();
        return $msg;
    } // end function googleUpdateManual

    public static function set_NearStatus($status, $iconId)
    {
        return  freewheelFormat::setStatus($status, "iconNear", $iconId);
    }

    private static function googleUpdateAutomated($attributes)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        global $foundBusinessesList, $foundAddressList;

        $msg = "";
        try {
            $displayUpdates = rrwParam::isDebugMode("displayUpdates");
            $radiusMiles = rrwParam::Number("radius", $attributes);
            if (empty($radiusMiles))
                $radiusMiles = 10; // 2 miles
            if ($displayUpdates) $msg .= "I#312 radius is $radiusMiles miles $eol";
            // individual case
            $foundBusinessesList = array(); // list of items processed
            $foundAddressList = array();
            // update google finds businesses near to an icon or trail
            //      if moved then route it
            //      if bizUsed and no access then route it
            // get near trails
            //      if new then route it
            //      if moved then route it
            //      if bizUsed and no access then route it
            global $wpdbExtra;
            // ----------------------------------------------------------------------------------  update google based on near trail, and route it
            // distance has been recently done, and near by was done some time ago
            $msg .= freewheelingeasy_build_businessAccess::moveDates2Trails();       // update to most current data
            $date60 = date("Y-m-d", strtotime("-60 days"));

            $sqlFind = "select distinct trId from $wpdbExtra->trails
                                    where POSITION('2' in trDateNear) = 1
                                    and '$date60' > trDateNear
                                    ORDER BY mergeSequence ASC";
            $recsFind = $wpdbExtra->get_resultsA($sqlFind);
            $msg .= "I#311 found " . $wpdbExtra->num_rows . " trails to process with $sqlFind $eol";
            if (0 < $wpdbExtra->num_rows) {
                $trailId = $recsFind[0]["trId"];
                $msg .= "found trailId $trailId to run $eol";
                $msg .= self::updateTrail($trailId);
            } else {
                $msg .= "I#315 no trails to process $eol";
                $msg .= freewheelFormat::taskCompleted("Near Trails");
            }
        } catch (Exception $ex) {
            $msg .= $ex->getMessage() . "$errorBeg  E#2077 searchByIconSql $errorEnd";
            throw new Exception($msg);
        }
        return $msg;
    } // end function googleUpdateAutomated

    static private function fixVerifyBusinessLater()
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $sqlBiz = "select bizId, bizName from $wpdbExtra->business
                left join where $wpdbExtra->codesBizUsed on code = bizUsed and " . freewheeling_kml_common::selectOnlyGoogleId("bizId");
        $recBizMany = $wpdbExtra->get_resultsA($sqlBiz);
        $updateCnt = 0;
        foreach ($recBizMany as $recBiz) {
            $updateCnt++;
            if ($updateCnt >= 500)
                break;
            $bizId = $recBiz["bizId"];
            $bizName = $recBiz["bizName"];
            $msg .= self::maybeUpdateDatabaseWithPlaceId($bizId, $bizName);
            $cntSkip = 0;
            $msg .= freewheelingeasy_build_businessAccess::route_one_bizId($bizId, $cntSkip);
            if (rrwUtil::isTimeUp(freewheelingEasy_fix_Class::$checkLoopingTimeOut)) {
                $msg .= rrwUtil::TimeUpMessage(
                    "E#447",
                    "fixVerifyBusinessLater",
                    ""
                );
                break;
            }
        }
        return $msg;
    } // end of fixVerBusiness

    static private function ProcessBizAge($bizAge)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        global $processingThing;
        $msg = "";
        try {
            $debugProgress = false;

            $processingThing = "businesses with google scan >  $bizAge days";
            $sqlScan = "select bizId, bizName from $wpdbExtra->business
    						where googleScanned < (now() - interval $bizAge day)
    						and bizUsed > 0";
            $sqlScan .= " order by bizLat asc, googleScanned asc, bizId ";
            $msg .= "$sqlScan $eol";
            $recBizIds = $wpdbExtra->get_resultsA($sqlScan);
            $howMany = $wpdbExtra->num_rows;
            $msg .= "there are $howMany biz with an age over $bizAge days $eol";
            if ($debugProgress) $msg .= rrwUtil::print_r($recBizIds, true, "I#518 looping data ");
            $cntUpdateLoop = 0;
            foreach ($recBizIds as $recBizId) {
                $bizId = $recBizId["bizId"];
                $bizName = $recBizId["bizName"];
                if (!freewheeling_kml_common::is_googleID($bizId)) {
                    if (strlen($bizId) > 40)
                        $msg .= "$errorBeg E#480 $bizId is not a google id $errorEnd $eol";
                    continue;
                }
                $cntUpdateLoop++;
                $stopCount = rrwParam::Integer("limit");
                if (0 == $stopCount)
                    $stopCount = 20;
                if ($stopCount < $cntUpdateLoop) {
                    $msg .= "$errorBeg E#526 we processed $stopCount of the $howMany $errorEnd Please try again $eol";
                    break;
                }
                $msg .= self::maybeUpdateDatabaseWithPlaceId($bizId, $bizName);      // update one business and sets the
                if (rrwUtil::isTimeUp(freewheelingEasy_fix_Class::$checkLoopingTimeOut)) {
                    $msg .= rrwUtil::TimeUpMessage(
                        "E#650",
                        " loop over business for age > $bizAge days",
                        "https://edit.shaw-weil.com/googleupdate/?bizAge=bizAge $eol"
                    );
                    break;
                }
            } // end for
            $msg .= "I#295 Processed $cntUpdateLoop  $processingThing $eol ";
        } catch (Exception $ex) {
            $msg .= $ex->getMessage() . "E#699 high level catch $eol";
        }
        return $msg;
    } // end function ProcessBizAge


    public static function isOurType($google_types, $name, $bizId, &$msgOutput): bool
    {
        // return true for our types, false otherwise
        // return true if BizToAlwaysProcess which was set by ?force is in the query
        global $categoryArray;
        global $eol, $errorBeg, $errorEnd;
        global $BizToAlwaysProcess;

        if (!is_array($BizToAlwaysProcess))
            $msgOutput .= self::buildBizToAlwaysProcess();  // list business with incorrect/missing types
        $force = rrwParam::Boolean("force");
        if (!empty($force))
            return  true;
        if (empty($name)) {
            $msgOutput .= "$eol I#622 empty name Forced to ignore ignored type checking.$eol";
            return false;
        }
        if (empty($google_types)) {
            $msgOutput .= "$eol I#290 $name - $google_types - empty types forced to ignore ignored type checking.$eol";
            return false;
        }
        if (strpos($google_types, "campground") !== false && strlen($name) < 4) {
            $msgOutput .= "$eol I#361 $name - $google_types - is a campsite number. Not our type $eol";
            return false;
        }
        if (in_array($bizId, $BizToAlwaysProcess)) {
            $msgOutput .= "$eol I#637 $name - $google_types - Forced to ignore ignored type checking.$eol";
            return true;
        }
        $debugTypeCheck = false;
        if (!is_array($categoryArray)) {
            $categoryArray = self::goodTypes();  // list of desired types
            if ($debugTypeCheck) $msgOutput .= rrwUtil::print_r($categoryArray, true, "categoryArray");
        }
        $types = explode(",", $google_types);
        //       if ( $debugTypeCheck )$msg .= rrwUtil::print_r( $types, true, "extracted types" );
        foreach ($types as $type) {
            if (in_array($type, $categoryArray)) {
                $msgOutput .= " &nbsp;I#845 has type $type ";
                return  true;
            }
        }
        if (strpos($name, "Canoe Launch") !== false || strpos($name, "Kayak Launch") !== false) {
            $google_types .= ",Boat Launch";
            $msgOutput .= " I#369 Appended Boat Launch";
            return  true;
        }
        $msgOutput .= "I#377 $name has google type ($google_types), does not contain type of interest $eol";
        return  false;
    }
    static private
    function goodTypes()
    {
        $good = array(
            //         "local_government_office",
            "cafe",
            "bar",
            "restaurant",
            "convenience_store",
            "grocery_store",
            "bakery",
            "supermarket",
            "meal_takeaway",
            "lodging",
            "campground",
            "bicycle_store",
            "laundry",
        );
        return $good;
    }
    static public function CleanUpStreet($bizStreet)
    {
        $StreetClean = str_replace("Street", "St", $bizStreet);
        $StreetClean = str_replace("Stree", "St", $StreetClean);
        $StreetClean = str_replace("Drive", "Dr", $StreetClean);
        $StreetClean = str_replace("Driv", "Dr", $StreetClean);
        $StreetClean = str_replace("Avenue", "Ave", $StreetClean);
        $StreetClean = str_replace("Avenu", "Ave", $StreetClean);
        $StreetClean = str_replace("Highway", "Hwy", $StreetClean);
        $StreetClean = str_replace("Highwa", "Hwy", $StreetClean);
        $StreetClean = str_replace("Boulevard", "Blvd", $StreetClean);
        $StreetClean = str_replace("Boulevar", "Blvd", $StreetClean);
        $StreetClean = str_replace("Road", "Rd", $StreetClean);
        $StreetClean = str_replace("Roa", "Rd", $StreetClean);
        $StreetClean = str_replace("East ", "E ", $StreetClean);
        $StreetClean = str_replace("West ", "W ", $StreetClean);
        $StreetClean = str_replace("South ", "S ", $StreetClean);
        $StreetClean = str_replace("North ", "N ", $StreetClean);
        return trim($StreetClean);
    }
    static private
    function delete_if_in_list($item, $foundList, $bizId)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_history;
        $msg = "";
        $missing = true;
        foreach ($foundList as $found) {
            $msg .= "==$found==";
            if (strcmp(trim($found), trim($item)) == 0) {
                $msg .= "found a match ===$eol";
                $sqlDel1 = "delete from $wpdbExtra->business where bizId = '$bizId' ";
                $wpdbExtra->query($sqlDel1);
                $sqlDel2 = "delete from $wpdbExtra->services where svcid = '$bizId' ";
                $wpdbExtra->query($sqlDel2);
                $sqlDel4 = "delete from $rrw_history where hisid = '$bizId' ";
                $wpdbExtra->query($sqlDel4);
                $msg .= "$eol deleted $sqlDel1 $eol $sqlDel2 $eol $sqlDel4... $eol $sqlDel4 $eol";
                $missing = false;
                break;
            }
        }
        if ($missing)
            $msg .= "did not find a match to ====$item========== $eol";
        // $msg .= rrwUtil::print_r($foundBusinessesList, true, "found list");
        return $msg;
    }
    static private function updateTrail($trailId, $limit5mile = false)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        global $jsonPagesTotal;
        global $jsonPagesDetailTotal;
        $msg = "";
        $debugIconSql = rrwParam::isDebugMode("debugIconSql");
        $iconList = "";
        try {
            $msg .= "<h1>near $trailId </h1>$eol";
            $sql = "select iconId, iconName, milepostPrefix, milepost from $wpdbExtra->icons
                    where  '$trailId' = trailId ";
            if ($limit5mile)
                $sql .= "and onMap like '%mile%' and (milepost mod 5)  = 0 ";
            $sql .= " order by milepost";
            // $msg .= "$eol $sql $eol";
            $recIcons = $wpdbExtra->get_resultsA($sql);
            $iconCntToProcess = $wpdbExtra->num_rows;
            $msg .= "I#532 found $iconCntToProcess icons to process $eol";
            $mpMin = "";
            $iconCnt = 0;
            $fullProcessCnt = 0;
            foreach ($recIcons as $recIcon) {
                $iconCnt++;
                $iconId = $recIcon["iconId"];
                $iconName = $recIcon["iconName"];
                $iconList .= "#$iconId - $iconName " . rrwFormat::milePostText($recIcon["milepost"], $recIcon["milepostPrefix"]) . ",  &nbsp;     ";
                $msg .= self::updateIconId($iconId, $fullProcessCnt); // also updated the icon processed date.
                if (rrwUtil::isTimeUp(freewheelingEasy_fix_Class::$checkLoopingTimeOut)) {
                    $msg .= rrwUtil::TimeUpMessage(
                        "E#358",
                        " looping over Trail $trailId, processed $fullProcessCnt new, skipped " . ($iconCnt - $fullProcessCnt) . " icons of $iconCntToProcess  $eol ",
                        ""
                    );
                    break;
                }
            } // end foreach $recIcons

            $seconds = rrwUtil::deltaTimer("");
            $msg .= "$eol $eol I#536 Finished <strong>processing $fullProcessCnt new, skipped " . ($iconCnt - $fullProcessCnt) . " icons of $iconCntToProcess</strong> in $seconds seconds $eol  $iconList $eol
                    using $jsonPagesTotal nearby json pages,
					$jsonPagesDetailTotal detail json pages$eol $eol";
        } catch (Exception $ex) {
            $msg .= $ex->getMessage() . "$errorBeg  E#334 bottom of google-update:updateTrail $errorEnd";
            throw new Exception($msg);
        }
        return $msg;
    } // end function searchByIconSql

    static private function updateIconId($iconId, &$fullProcessCnt)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $debugSearchByIcons = rrwParam::isDebugMode("debugSearchByIcons");
        $msg = "";
        try {
            $daysIgnore = rrwParam::Number("daysignore");
            if ($daysIgnore == 0)
                $daysIgnore = 30;
            $force = rrwParam::Boolean("force");
            $sqlIcon = "select latitude, longitude, icDateNear, iconName, iconId, milepostPrefix,trailId
                     from $wpdbExtra->icons where iconId = '$iconId' ";
            if ($debugSearchByIcons) $msg .= "search By point id: $sqlIcon $eol";
            $recIcons = $wpdbExtra->get_resultsA($sqlIcon);
            if ($debugSearchByIcons) $msg .= rrwUtil::print_r($recIcons, true, "recIcons");
            if ($wpdbExtra->num_rows < 1) {
                $msg .= "$errorBeg E#553 an icon with the id $iconId was not found
                $errorEnd $sqlIcon $eol";
                return $msg;
            }
            $recIcon = $recIcons[0];
            $latitude = $recIcon["latitude"];
            $longitude = $recIcon["longitude"];
            $icDateNear = $recIcon["icDateNear"];
            $iconName = $recIcon["iconName"];
            $trailId = $recIcon["trailId"];
            $msg .= "<h3>Processing location $trailId - $iconName ($iconId) ... </h3>";
            $today = new DateTime();
            $iiTwo = strpos($icDateNear, "2");
            $processDate = substr($icDateNear, $iiTwo, 10);
            try {
                $processDate = new DateTime($processDate);
                $diff = $today->diff($processDate);
                $days = $diff->days + 1;
            } catch (Exception $ex) {
                $msg .= "E#297 $errorBeg" .  $ex->getMessage() . " $errorEnd $eol";
                $days = 100;    // force to recalculate
            }
            if ($force) {
                $why = "location last updated $days days ago, but forced to process $eol";
            } elseif ($diff->invert == 0) {
                $msg .= "location $days days in the future,
                        skip for now E#835 <a href='/update-google?iconId=$iconId'
                        target='reset' > update this icon again. </a>$eol";
                return $msg;
            } elseif ($days < $daysIgnore) {
                $msg .= " E#495 location last updated less than $days days ago,
                        skip for now E#834 <a href='/update-google?iconId=$iconId'
                        target='reset' > update this icon again. </a> $eol ";
                return $msg;
            } else {
                $why = "location last updated $days days ago, $eol ";
            }
            $fullProcessCnt++;
            $msg .= "$eol -------------------<h1>I#728 processing icon $iconName $why</h1>
                <a href='/update-google?Iconid=$iconId' target='reset' >
                    update this icon again. </a> $eol ";
            $msg .= self::searchByLatLng($latitude, $longitude, 7.0, null, $iconId); // in update icon

            $sqlIconDate = "update $wpdbExtra->icons set icDateNear = now()
                    where iconId = '$iconId'";
            $msg .= "I#558 $sqlIconDate "  . $eol;
            $cnt = $wpdbExtra->query($sqlIconDate);
        } catch (Exception $ex) {
            $msg .= $ex->getMessage() . "$errorBeg  E#529 bottom of google-update:updateIconId $errorEnd";
            throw new Exception($msg);
        }

        return $msg;
    } // end function updateIconId

    static private
    function buildKnownServiceTypes()
    {

        global $wpdbExtra;
        $msg = "";
        $debugKnownServiceTypes = rrwParam::isDebugMode("debugKnownServiceTypes");
        if ($debugKnownServiceTypes) echo "I#2105 buildKnownServiceTypes ";
        $sqlKnown2 = "select code, googleType from $wpdbExtra->codes where googleType is not null
                and codetype = 'establishment' ";
        $recCodes = $wpdbExtra->get_resultsA($sqlKnown2);
        self::$knownServiceTypes = array();
        foreach ($recCodes as $recCode)
            self::$knownServiceTypes[$recCode["googleType"]] = $recCode["code"];

        $sqlAllCode = "SELECT COLUMN_NAME FROM information_schema.COLUMNS WHERE table_name = '$wpdbExtra->services' and length(column_name) < 5";
        $recAllCode = $wpdbExtra->get_resultsA($sqlAllCode);
        self::$blankOutServiceCodes = array();
        foreach ($recAllCode as $recCode)
            self::$blankOutServiceCodes[$recCode["COLUMN_NAME"]] = 0;
        return $msg;
    }

    static public function searchByLatLng($latitude, $longitude, $radiusMiles, $categorySelect, $item)
    {
        // give latitude, longitude, search for nearby businesses
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        try {
            $debugLatLog = rrwParam::isDebugMode("debugLatLog");
            $force = rrwParam::Boolean("force");

            if ($debugLatLog)
                $msg .= "I#2043 " . str_repeat("-", 50) . "searchByLatLng: ( $latitude, $longitude, radius of $radiusMiles ) $eol";
            if (is_null($categorySelect))
                $categories = self::goodTypes();
            else
                $categories = array($categorySelect);
            if ($debugLatLog) $msg .= rrwUtil::print_r($categories, true, "I#2044list of categories to process");
            $range = freeWheeling_edit_setGlobals::trailInfoEmpty();
            if ($debugLatLog) $msg .= rrwUtil::print_r($range, true, "I#2045 limits of the lat lng");
            if ($latitude < $range["south"] || $latitude > $range["north"]) {
                $msg .= "$errorBeg E#2040 latitude out of range " . $range["south"] . "< $latitude
                                < " . $range["north"] . " $errorEnd";
                return $msg;
            }
            if ($longitude < $range["west"] || $longitude > $range["east"]) {
                $msg .= "$errorBeg <E#2041 longitude out of range  " . $range["west"] . " <$longitude
                                < " . $range["east"] . " $errorEnd";
                return $msg;
            }

            $cntCategory = 0;
            foreach ($categories as $category) {
                $cntCategory++;
                if ($cntCategory > 30)
                    throw new Exception("$msg $errorBeg I#2042 Attempting to process over 30 categories $errorEnd");
                $msg .= "$eol ^^^^^^ <strong>$category</strong> " . str_repeat("V", 120) . " <strong>$category --------</strong> $eol ";
                $msg .= self::UpdateBusinessByLatLng($latitude, $longitude, $radiusMiles, $category, $item);
            } // foreach ( $categories as $category )
        } catch (Exception $ex) {
            $msg .= $ex->getMessage() . "$errorBeg  E#2046 searchByLatLng $errorEnd";
            throw new Exception($msg);
        }
        return $msg;
    } // end function searchByLatLng


    static public function searchForBikeShops($attr)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_regions;
        $msg = "";
        try {
            $msg .= freeWheeling_edit_setGlobals::setGlobals("amenity search");
            $msg .= "search for bike shops";
            $startCnt = rrwParam::Integer("start");
            if (0 == $startCnt)
                $startCnt = 1000;
            $destInc = .5;
            $sql = "select ceil(max(north)) north, floor(min(south))south, ceil(max(east)) east, floor(min(west)) west from $rrw_regions ";
            $msg .= "$sql $eol";
            $range = $wpdbExtra->get_resultsA($sql);
            if (1 != $wpdbExtra->num_rows)
                throw new Exception("$errorBeg E#360 did not find a record for $errorEnd $sql $eol");
            $rangeNorth = $range[0]["north"];
            $rangeSouth = $range[0]["south"];
            $rangeEast = $range[0]["east"];
            $rangeWest = $range[0]["west"];
            $cnt = 0;
            $msg .= "Range is a square $rangeNorth, $rangeWest by $rangeSouth, $rangeEast $eol";
            $msg .= "$rangeSouth < $rangeNorth; $eol";
            for ($iiNorth = $rangeSouth; $iiNorth <= $rangeNorth; $iiNorth += $destInc) {
                $msg .= "iiNorth is $iiNorth $eol";
                for ($iiWest = $rangeEast; $iiWest >= $rangeWest; $iiWest -= $destInc) {
                    $cnt++;
                    $msg .= "$cnt center = $iiNorth, $iiWest $eol";
                    $msg .= self::searchByLatLng($iiNorth, $iiWest, 23, "bicycle_store", "$rangeNorth,$rangeWest"); // in search for bike shops
                } // end iiWest
            } // end iiNorth
        } // end try
        catch (Exception $ex) {
            $msg .= $ex->getMessage() . "$errorBeg  E#367 searchForBikeShops $errorEnd";
            throw new exception($msg);
        }
        $msg .= freewheeling_Google_Costs::googleCosts("searchForBikeShops");
        $msg .= freewheeling_WriteUp::saveMsg2Files("update-bike-shops" . date("Y-m-d His") . ".htm", $msg);
        $msg .= "$eol The that, the next step is to
        <a href='https://edit.shaw-weil.com/makehtml/?task=bike' target='update' >
        make the bike shop list for liking up  </a>$eol";

        return $msg;
    } // end function searchForBikeShops
    /*
    static private function searchByAddress($address, $radiusMiles)
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        try {
            $msg .= "searchByAddress ";
            $debugLatLog = false;
            $debugProgress = false;
            $debugPlaceArray = false;
            $category = implode(",", self::goodTypes());
            list($msgTemp8, $addressPages) = self::getJsonPlacesAddress($address, $category, $radiusMiles);
            $msg .= $msgTemp8;
            if (!array_key_exists("results", $addressPages)) {
                $msg .= "$errorBeg E#502 Did not find a results key $errorEnd";
                $msg .= rrwUtil::print_r($addressPages, true, "address stuff");
                return $msg;
            }
            $latitude = $addressPages["results"][0]["geometry"]["location"]["lat"];
            $longitude = $addressPages["results"][0]["geometry"]["location"]["lng"];
            $msg .= "trying latitude, longitude $latitude, $longitude $eol";
            $msg .= self::searchByLatLng($latitude, $longitude, $radiusMiles,null,$address); // search By Address
        } catch (Exception $ex) {
            $msg .= $ex->getMessage() . "$errorBeg " . $ex->getMessage() . " E#2064 searchByAddress $errorEnd
                    in searchByAddress($address, $radiusMiles) ";
            throw new exception($msg);
        }
        return $msg;
    } // end function searchByAddress
*/

    static public function UpdateTheScannedDate($place_id, $debugProgress = false)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        if (freewheeling_kml_common::is_googleID($place_id)) {
            $newDate = "now()";
        } else {
            $newDate = "'1900-01-01'";  // force non-google id to older date
        }
        $sqlGoogleTime = "update $wpdbExtra->business set googleScanned = $newDate where place_id = '$place_id'";
        $cnt = $wpdbExtra->query($sqlGoogleTime);
        if ($debugProgress) $msg .= "update $cnt record with a current google scan time $sqlGoogleTime $eol";
        return $msg;
    }
    static private
    function excludedTypes($type)
    {
        if (is_array($type))
            $type = join(",", $type);
        if (strpos($type, "doctor,health") !== false)
            return true;
        if (strpos($type, "lawyer") !== false)
            return true;
        if (strpos($type, "route") !== false)
            return true;
        return false;
    }

    static public function UpdateBusinessByLatLng($latitude, $longitude, $radiusMiles, $category, $item): string
    {
        global $eol, $errorBeg, $errorEnd;

        freeWheeling_edit_setGlobals::notAllowedToEdit("json request");
        $msg = "";
        try {
            $debugTestGetMapApi = rrwParam::isDebugMode("debugTestGetMapApi");
            $debugTestGetIds = rrwParam::isDebugMode("debugTestGetIds");
            $radiusMeters = $radiusMiles * freeWheel::metersPerMile;
            //$msg .= "radius = $radiusMeters = $radiusMiles * " . freeWheel::metersPerMile . ";$eol";
            if ($debugTestGetMapApi) $msg .= "I#2047 getJsonPlacesLatLng: lat = $latitude,  lng = $longitude , category = $category.
                    circle radius = $radiusMiles miles, $radiusMeters m $eol";
            $post = '{ "maxResultCount": 20,"rankPreference": "DISTANCE", "includedTypes": "' . $category . '", "locationRestriction": { "circle": { "center": { "latitude": ' . $latitude . ',        "longitude": ' . $longitude . ' },
                "radius": ' . $radiusMeters . ' } }
                } ';

            if ($debugTestGetMapApi) $msg .= "<pre>$post</pre>";
            // needs at least one ? parameter since &key=.... is appended
            $url = "https://places.googleapis.com/v1/places:searchNearby?fields=places.displayName,places.id,places.primaryType";
            if ($debugTestGetMapApi) $msg .= "I#2048 calling appendApiKeyToUrlWithDate ( '$url' $eol";
            $msg .= freewheelAPI_2025::appendApiKeyToUrlWithDate($url);
            //  $url = str_replace("&key", "?Goog-Api-Key=", $url);
            if ($debugTestGetMapApi) $msg .= "I#2049 calling fetchURLcontents ( '$url' $eol";
            $placesJson = rrwUtil::fetchURLcontents($url, $post);
            $placeText = "$url $eol $eol " . rrwUtil::print_r($placesJson, true, "I#2096 send places to services Report$eol Begin of the file $eol");
            $msg .= freewheeling_writeup::saveReport("places-$item-", $placeText);

            if ($debugTestGetMapApi) $msg .= "<pre>$placesJson</pre>";
            if (null === $placesJson || empty($placesJson)) {
                $errormsg = "$errorBeg E#2082 getJsonPlacesLatLng did not return any data $errorEnd";
                return "$msg $errormsg";
            }
            $places = json_decode($placesJson, true);
            if (!is_array($places)) {
                $msg .= "E#2052 places is not an array: = $eol <pre>$placesJson</pre> ";
                $errmsg = "$errorBeg E#2071 getJsonPlacesLatLng did not return an array $errorEnd";
                throw new Exception($errmsg);
            }
            if ($debugTestGetIds) $msg .= rrwUtil::print_r($places, true, "I#2072 places ");
            if (!array_key_exists("places", $places)) {
                $msg .= "$errorBeg E#2051 getJsonPlacesLatLng did not return a places key $errorEnd";
                $msg .= rrwUtil::print_r($places, true, "I#2070 places stuff");
                throw new Exception($msg);
            }
            $placeList = $places["places"];
            $placeIds = array();
            $cnt = 0;
            $limit = rrwParam::number("limit", array(), 20);
            foreach ($placeList as $value) {
                $cnt++;
                if ($cnt > $limit)
                    break;
                if ($debugTestGetIds) $msg .= rrwUtil::print_r($value, true, "I#2053 value ");
                $bizId = $value["id"];
                $name = $value["displayName"]["text"];
                $placeIds[$bizId] = $name;
                $msg .= self::maybeUpdateDatabaseWithPlaceId($bizId, $name);
                if ($debugTestGetIds) $msg .= "I#2073 places[$bizId] = " . rrwUtil::print_r($value, true, "I#2056 value") . $eol;
            }
            if ($debugTestGetIds) $msg .= rrwUtil::print_r($placeIds, true, "I#2076 final places");
        } catch (Exception $ex) {
            $msg .= "$errorBeg " . $ex->getMessage() . $errorEnd;
        }
        return $msg;
    }
    static private function maybeUpdateDatabaseWithPlaceId($placeId, $name)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        try {
            $debugMaybe = false;
            if (empty($placeId) || !freewheeling_kml_common::is_googleID($placeId)) {
                $msg .= "$errorBeg E#2057 updateDatabaseWithPlaceId invalid placeId '$placeId' $errorEnd $eol";
                return $msg;
            }
            $bizLink = FreewheelFormat::bizLink($placeId, $name);
            $sqlPlace = "select * from $wpdbExtra->business where bizId = '$placeId' ";
            $recs = $wpdbExtra->get_resultsA($sqlPlace);
            if (1 == $wpdbExtra->num_rows) {
                self::$bizRecord = $recs[0]; // save the record for later use
                if ($debugMaybe) $msg .= "I#2063 $bizLink has " . count(self::$bizRecord) . " records $eol";
                $googleScanned = self::$bizRecord["googleScanned"];
                try {
                    $date1 = new DateTime($googleScanned);
                    $date2 = new DateTime();
                    $interval = $date1->diff($date2);
                    $days = $interval->days;
                } catch (Exception $ex) {
                    $msg .= "$errorBeg E#2061 invalid googleScanned date in database $googleScanned $errorEnd $eol";
                    $days = 1000;
                }
                if ($days < 60) {
                    $msg .= "I#2062 $bizLink -Google scan is $googleScanned, <strong>only $days days old</strong>, not updating $eol";
                    return $msg;
                }
                $msg .= str_repeat("V", 80) . $eol;
                $msg .= "I#2067 $bizLink -Google scan is $googleScanned, <strong>$days days old</strong>, lets update $eol";
            } elseif (0 == $wpdbExtra->num_rows) {
                $msg .= str_repeat("V", 80) . $eol;
                $msg .= "I#5 $bizLink - not in database, lets add it $eol";
                try {
                    $insert1 = $wpdbExtra->insert($wpdbExtra->business, array("place_id" => $placeId, "bizId" => $placeId, "BizName" => $name));
                    if (1 != $insert1) {
                        throw new Exception("$msg $errorBeg E#2066 $bizLink attempted to create a new business entry but failed $errorEnd
                            updateDatabaseWithPlaceId id '" . $placeId . "', '" . $name . "' $eol");
                    }
                    $insert2 = $wpdbExtra->insert($wpdbExtra->services, array("svcId" => $placeId, "svcName" => $name));
                    if (1 != $insert2) {
                        throw new Exception("$msg $errorBeg E#2095 $bizLink attempted to create a new services entry but failed $errorEnd
                            updateDatabaseWithPlaceId id '" . $placeId . "', '" . $name . "' $eol");
                    }
                    $msg .= insertIntoHistory($placeId, "Google insert - new business $placeId, $name");
                    self::$bizRecord = array(); // clear out the old record
                    $msg .= "I#2065 $bizLink created with $placeId, $name $eol";
                } catch (Exception $ex) {
                    $msg .= "$errorBeg E#2059 " . $ex->getMessage() . " attempted to create a new entry but failed $errorEnd";
                    throw new Exception($msg);
                }
            } else {
                throw new Exception("$msg $errorBeg E#2078 Expected one row of data but got " . $wpdbExtra->num_rows .
                    " rows $errorEnd");
            }
            $msg .= self::UpdateDatabaseWithPlaceId($placeId, $name);
        } catch (Exception $ex) {
            $msg .= $ex->getMessage() . "$errorBeg E#2060 updateDatabaseWithPlaceId $errorEnd ";
        } // end catch
        return $msg;
    } // end function maybeUpdateDatabaseWithPlaceId

    static public function UpdateDatabaseWithPlaceId($placeId, $name)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        try {
            $debugUpdate = false;
            if (empty($placeId) || !freewheeling_kml_common::is_googleID($placeId)) {
                $msg .= "$errorBeg E#2079 updateDatabaseWithPlaceId invalid placeId '$placeId' $errorEnd $eol";
                return $msg;
            }
            if (count(self::$bizRecord) < 1) {
                // did not come in through maybeUpdateDatabaseWithPlaceId
                $sqlPlace = "select * from $wpdbExtra->business where bizId = '$placeId' ";
                $recs = $wpdbExtra->get_resultsA($sqlPlace);
                if (1 == $wpdbExtra->num_rows) {
                    self::$bizRecord = $recs[0]; // save the record for later use
                } else {
                    throw new Exception("$msg $errorBeg E#2099 updateDatabaseWithPlaceId did not find a record for placeId '$placeId' $errorEnd $eol");
                }
            }
            $url = "https://places.googleapis.com/v1/places/$placeId";
            $url .= "?fields=nationalPhoneNumber,websiteUri,";
            $url .= "formattedAddress,rating,displayName,businessStatus,";
            $url .= "googleMapsUri,types,location,postalAddress";
            freewheelAPI_2025::appendApiKeyToUrlWithDate($url);
            if ($debugUpdate) $msg .= "I#2055 fetching business details from Google Places API $url $eol";
            $bizJason = rrwUtil::fetchURLcontents($url);
            if (null === $bizJason || empty($bizJason)) {
                $msgErr = "$errorBeg E#2080 updateDatabaseWithPlaceId did not return any data $errorEnd $url $eol";
                throw new Exception($msgErr);
            }
            $placeText = "$url $eol $eol " . rrwUtil::print_r($bizJason, true, "I#2058 send places to savedReports$eol Begin of the file $eol");
            $msg .= freewheeling_writeup::saveReport("details-$placeId-", $placeText);

            self::$bizDetail = json_decode($bizJason, true);
            if (!is_array(self::$bizDetail)) {
                $msg .= "$errorBeg E#2081 UpdateDatabaseWithPlaceId details is not an array: = $errorEnd <pre>$bizJason</pre> $eol ";
                return $msg;
            }
            if (0 == count(self::$bizDetail)) {
                $msg .= "$errorBeg E#2083 UpdateDatabaseWithPlaceId: details[placeId] is an empty array $errorEnd <pre>$bizJason</pre> $eol ";
                return $msg;
            }
            if ($debugUpdate) $msg .= "<pre>$bizJason</pre>$eol";
            $msg .= self::processBizJason2Database($placeId);
        } catch (Exception $ex) {
            $msg .= "$errorBeg " . $ex->getMessage() . " updateDatabaseWithPlaceId $errorEnd ";
        } // end catch
        return $msg;
    } // end function UpdateDatabaseWithPlaceId

    private static function processBizJason2Database($placeId)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $wpdb;
        $msg = "";
        // self::BizDetail is the json array from google places details
        // self::BizRecord is the current business record being updated
        // self::Update is the array of fields to be updated
        try {
            // now compare the fields we care about
            $debugCompare = rrwParam::isDebugMode("debugCompare");
            if ($debugCompare) $msg .=  rrwUtil::print_r(self::$bizRecord["BizName"], true, "I#2088 in processBizJason2Database for $placeId,");
            self::$updateBusiness = array();
            self::$latLonChanged = false;
            $msg .= self::compareTable("businessStatus", "bizUsed", $placeId);

            //$msg .= self::compare2("displayName","text", "BizName", $placeId);    // leave bizName alone
            $msg .= self::compareTypes("types", $placeId);                          // update types table n he services table
            $msg .= self::compare2("postalAddress", "addressLines", "BizStreet", $placeId);
            $msg .= self::compare2("postalAddress", "locality", "BizCity", $placeId);
            $msg .= self::compareTable("administrativeArea", "BizState", $placeId);
            $msg .= self::compare2("postalAddress", "postalCode", "BizZIP", $placeId);
            //$msg .= self::compare("displayName", "BizPropName", $placeId);
            //$msg .= self::compare("displayName", "BizGGreet", $placeId);
            $msg .= self::compare("nationalPhoneNumber", "BizPhone", $placeId);
            //$msg .= self::compare("displayName", "BizPhone2", $placeId);
            //$msg .= self::compare("displayName", "BizFax", $placeId);
            //$msg .= self::compare("internationalPhoneNumber", "Biz800", $placeId);
            //    $msg .= self::compare("displayName", "BizEmail", $placeId);
            $msg .= self::compare("websiteUri", "BizWWW", $placeId);
            $msg .= self::compare("googleMapsUri", "googleMapUrl", $placeId);
            $msg .= self::compare("rating", "googleRating", $placeId);
            $msg .= self::compareLatLon("latitude", "BizLat", "longitude", "BizLng", $placeId); // sets latLonChanged and point

            if (0 == count(self::$updateBusiness)) { // more than placeId
                $msg .= "I#2091 no changes to be made to " . FreewheelFormat::bizLink($placeId, self::$bizRecord["BizName"]) . " $eol";
                $sqlScan = "update $wpdbExtra->business set googleScanned = '" . date("Y-m-d") . "' where place_Id = '$placeId'";
                if ($debugCompare) $msg .= $sqlScan . $eol;
                $wpdbExtra->query($sqlScan);
            } else {
                $where = array("bizId" => $placeId);
                self::$updateBusiness["googleScanned"] = date("Y-m-d");
                $updateVar = self::$updateBusiness;
                if ($debugCompare) $msg .= rrwUtil::print_r($where, true, "I#2097 updating business with where ");
                $msg .= rrwUtil::print_r($updateVar, true, "I#2098 updating business with");
                if ($debugCompare) $msg .= "I#2089 updating business '$wpdbExtra->business')  $eol";
                $numUpdated = $wpdb->update($wpdbExtra->business, $updateVar, array("place_id" => $placeId));
                $msg .= "I#2090 updated $placeId " . FreewheelFormat::bizLink($placeId, self::$bizRecord["BizName"]) . " $eol";
            }
            $bizName = self::$bizRecord["BizName"];
            $msg .= self::UpdateServices($placeId, $bizName);
            if (self::$latLonChanged) {
                $cntSkip = 0;
                $msg .= freewheelingeasy_build_businessAccess::route_one_bizId($placeId, $cntSkip);
            }
        } catch (Exception $ex) {
            $msg .= "$errorBeg " . $ex->getMessage() . " processBizJason2Database $errorEnd ";
        } // end catch
        return $msg;
    }
    static public function UpdateServices($bizId, $bizName)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        try {
            $debugServices = false;
            if ($debugServices) $msg .= "I#2092 in UpdateServices for $bizId, $bizName $eol";
            if (empty($bizId) || !freewheeling_kml_common::is_googleID($bizId)) {
                $msg .= "$errorBeg E#2123 UpdateServices invalid bizId '$bizId' $errorEnd $eol";
                return $msg;
            }
            if (count(self::$knownServiceTypes) == 0) {
                $msg .= self::buildKnownServiceTypes();
            }
            $sqlServiceExisting = "select google_types from $wpdbExtra->services where svcId = '$bizId'";
            $recTypes = $wpdbExtra->get_var($sqlServiceExisting);
            if (empty($recTypes)) {
                $msg .= "$errorBeg E#2100 UpdateServices did not find a google types for svcId '$bizId' $errorEnd $sqlServiceExisting $eol";
                throw new Exception($msg);
            }
            if ($debugServices) $msg .= "I#2103 existing google types for $bizId, $bizName is '$recTypes' $eol";
            // TODO wipe out existing codes
            $updateServices = array();                   // array to hold the update
            $googleTypes = explode(",", $recTypes);
            //$msg .= rrwUtil::print_r(self::$knownServiceTypes, true, "I#2102 google types for known Service Types are ");
            foreach ($googleTypes as $type) {
                //$msg .= "I#2104 processing type '$type'";
                if (strpos("restaurant", $type) !== false) {
                    $updateServices["FR"] = 1;              // ignore the various type of restaurants
                    continue;
                }
                if (strpos("cafe", $type) !== false) {
                    $updateServices["FR"] = 1;              // ignore the various type of cafes
                    continue;
                }
                if (array_key_exists($type, self::$knownServiceTypes)) {
                    $code = self::$knownServiceTypes[$type];
                    $updateServices[$code] = 1;
                    continue;
                }
            } // end foreach
            if (0 == count($updateServices)) {
                $msg .= "$errorBeg E#2094 UpdateServices did not find any known types for svcId '$bizId' - $recTypes $errorEnd $eol";
                throw new Exception($msg);
            }
            $msg .= rrwUtil::print_r($updateServices, true, "I#2101 updating services for $bizId, $bizName with $recTypes");
            $msg .= insertIntoHistory($bizId, "found google service codes - $recTypes");
            $where = array("svcId" => $bizId);
            if ($debugServices) $msg .= rrwUtil::print_r(self::$blankOutServiceCodes, true, "I#2107 updating services for $bizId, $bizName with where ");
            $updateServicesString = implode(",", array_keys($updateServices));
            $msg .= "blank Out service codes " . $wpdbExtra->update($wpdbExtra->services, self::$blankOutServiceCodes, $where) . " $updateServicesString $eol";
            $msg .= "update services " . $wpdbExtra->update($wpdbExtra->services, $updateServices, $where) . $eol;
            $msg .= freeWheelingClean::updateMasterServiceCodes($bizId);
            $msg .= insertIntoHistory($bizId, "found service changed - $updateServicesString");
        } catch (Exception $ex) {
            $msg .= "$errorBeg " . $ex->getMessage() . " updateServicesString $errorEnd ";
        } // end catch
        return $msg;
    } // end function UpdateServices

    static private function compareTypes($jsonField, $placeId)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        try {
            $debug = false;
            if ($debug) $msg .= "I#2074 in compareArray bizData has " . count(self::$bizRecord) . " records $eol";
            $jsonValue = self::$bizDetail[$jsonField];  // get new value
            if (empty($jsonValue)) {
                $msg .= "I#2075 compareArray $jsonField is empty  nothing to compare $eol";
                return $msg; // nothing new to compare
            }
            $jsonValue = join(",", $jsonValue); // convert array to comma separated list
            $sqlService = "select google_types from $wpdbExtra->services where svcId = '$placeId'";
            $dbValue = $wpdbExtra->get_var($sqlService);
            if ($jsonValue == $dbValue) {
                if ($debug) $msg .= "I#2086 compareArray $jsonField has not changed $eol";
                return $msg; // nothing new to compare
            }
            $cnt = $wpdbExtra->update($wpdbExtra->services, array("google_types" => $jsonValue), array("svcId" => $placeId));
            if ($cnt == false) {
                $msg .= "$errorBeg E#2087 compareArray failed to update services $errorEnd ";
                $msg .= rrwUtil::print_r($jsonValue, true, "E#2112 type List which is being sent to services, svcId = $placeId, ");
            } else {
                if ($debug) $msg .= "I#2085 updated services.google_types from '$dbValue' to '$jsonValue' $eol";
                $msg .= insertIntoHistory($placeId, "Google changed - google_types - $dbValue -> $jsonValue");
            }
        } catch (Exception $ex) {
            $msg .= "$errorBeg " . $ex->getMessage() . " compareArray $jsonField, $placeId $errorEnd ";
        } // end catch
        return $msg;
    } // end function compareArray

    static private function compareTable($jsonField, $dbField, $placeId)
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        try {
            $debug = rrwParam::isDebugMode("debugCompareTable");
            if ($debug)  $msg .= "I#2069 in compareTable bizData has " . count(self::$bizRecord) . " records $eol";
            $conversion = array(
                "OPERATIONAL" => 1,                             //open
                "CLOSED_TEMPORARILY" => 2,
                "CLOSED_PERMANENTLY" => -1,
                "District of Columbia" => "DC",
                "Maryland" => "MD",
                "New Jersey" => "NJ",
                "New York" => "NY",
                "Ohio" => "OH",
                "Pennsylvania" => "PA",
                "Virginia" => "VA",
                "West Virginia" => "WV",
                "Delaware" => "DE",
                "North Carolina" => "NC",
                "South Carolina" => "SC",
                "Tennessee" => "TN",
                "Kentucky" => "KY"
            );
            if ("administrativeArea" == $jsonField) {
                if (!array_key_exists("postalAddress", self::$bizDetail)) {
                    $msg .= "$errorBeg I#2113 'postalAddress' does not exist in json data, nothing to compare $errorEnd";
                    $msg .= rrwUtil::print_r(self::$bizDetail, true, "I#2120 bizDetail");
                    return $msg; // nothing new to compare
                }
                $temp = self::$bizDetail["postalAddress"];
                if (!array_key_exists($jsonField, $temp)) {
                    $msg .= "$errorBeg I#2084 [postalAddress] '$jsonField' does not exist in json data, nothing to compare $errorEnd";
                    $msg .= rrwUtil::print_r(self::$bizDetail, true, "I#2121 bizDetail");
                    return $msg; // nothing new to compare
                }
                $jsonValue = self::$bizDetail["postalAddress"][$jsonField];
            } else {
                $jsonValue = self::$bizDetail[$jsonField];  // get new value
            }
            if ($debug) $msg .= "I#2124 compareTable jsonField '$jsonField', jsonValue '$jsonValue' $eol";
            if (empty($jsonValue)) {
                $msg .= "I#2068 compareTable $jsonField is empty, nothing to compare $eol";
                return $msg; // nothing new to compare
            }
            if (array_key_exists($jsonValue, $conversion)) {
                $jsonValue = $conversion[$jsonValue];
            } else {
                $msg .= "$errorBeg E#2122 unrecognized value from google places $jsonField = '$jsonValue' $errorEnd";
            }
            if ($debug) $msg .= "I#2117 compareTable after conversion jsonField '$jsonField', jsonValue '$jsonValue' $eol";
            $msg .= self::compareFinal($jsonValue, $dbField, $placeId);
        } catch (Exception $ex) {
            $msg .= "$errorBeg " . $ex->getMessage() . " compareTable $jsonField, $dbField $errorEnd ";
        } // end catch
        return $msg;
    } // end function compareTable

    static private function compare2($jsonField1, $jsonField2, $dbField, $placeId)
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        try {
            $debug = false;
            if ($debug) $msg .= "I2016 compare2 $jsonField1, $jsonField2, $dbField, $placeId =  " . self::$bizDetail[$jsonField1][$jsonField2] . $eol;
            if (!array_key_exists($jsonField1, self::$bizDetail)) {
                $msg .= "$errorBeg I#2110 '$jsonField1' does not exist in json data, nothing to compare $errorEnd";
                $msg .= rrwUtil::print_r(self::$bizDetail, true, "I#2111 bizDetail");
                return $msg; // nothing new to compare
            }
            if (!array_key_exists($jsonField2, self::$bizDetail[$jsonField1])) {
                $msg .= "$errorBeg I#2153 '$jsonField2' does not exist in $jsonField1, nothing to compare $errorEnd";
                $msg .= rrwUtil::print_r(self::$bizDetail[$jsonField1], true, "I#2054 bizDetail[$jsonField1]");
                return $msg; // nothing new to compare
            }
            $jsonValue = self::$bizDetail[$jsonField1][$jsonField2];
            if (empty($jsonValue)) {
                return $msg; // nothing new to compare
            }
            if (is_array($jsonValue)) {
                $jsonValue = join(" ", $jsonValue); // convert array to comma separated list
            }
            $msg .= self::compareFinal($jsonValue, $dbField, $placeId);
        } catch (Exception $ex) {
            $msg .= "$errorBeg " . $ex->getMessage() . " comparePostalAddress $jsonField1,$jsonField2, $dbField, $errorEnd ";
        } // end catch
        return $msg;
    } // end function comparePostalAddress static private function comparePostalAddress($jsonField, $dbField, $placeId)


    static private function compareLatLon($jsonFieldLat, $dbFieldLat, $jsonFieldLon, $dbFieldLon, $placeId)
    {
        global $eol, $errorBeg, $errorEnd;

        $msg = "";
        try {
            $debugLatLon = false;
            $jsonValueLat = self::$bizDetail["location"][$jsonFieldLat];
            $jsonValueLon = self::$bizDetail["location"][$jsonFieldLon];
            if (empty($jsonValueLat) && empty($jsonValueLon)) {
                return $msg; // nothing new to compare
            }
            $jsonValueLat = round($jsonValueLat, freeWheel::latRoundTo);
            $jsonValueLon = round($jsonValueLon, freeWheel::latRoundTo);
            $msg .= self::compareFinal($jsonValueLat, $dbFieldLat, $placeId);
            $msg .= self::compareFinal($jsonValueLon, $dbFieldLon, $placeId);

            $bizLat = self::$bizRecord[$dbFieldLat];
            $bizLon = self::$bizRecord[$dbFieldLon];

            if ($debugLatLon) $msg .= "distanceMeters = freewheeling_calculations::distanceMeters($bizLat, $bizLon, $jsonValueLat, $jsonValueLon);";
            $distanceMeters = freewheeling_calculations::distanceMeters($bizLat, $bizLon, $jsonValueLat, $jsonValueLon);
            if ($distanceMeters > 20) { // more than 20 meters
                self::$latLonChanged = true;
            } else {
                self::$latLonChanged = false;
            }
        } catch (Exception $ex) {
            $msg .= "$errorBeg " . $ex->getMessage() . " compareLatLon $jsonFieldLat, $dbFieldLat, $jsonFieldLon, $dbFieldLon $errorEnd ";
        } // end catch
        return $msg;
    } // end function compareLatLon

    static private function compare($jsonField, $dbField, $placeId)
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        try {
            $debug = false;
            if ($debug) $msg .= "I#2093 bizData has " . count(self::$bizRecord) . " records $eol";
            if (!array_key_exists($jsonField, self::$bizDetail)) {
                if ($debug) $msg .= "I#2114 '$jsonField' does not exist in json data, nothing to compare $eol";
                return $msg; // nothing new to compare
            }
            $jsonValue = self::$bizDetail[$jsonField];
            if (empty($jsonValue)) {
                if ($debug) $msg .= "I#2118 '$jsonField'jsonValue is empty, nothing to compare $eol";
                return $msg; // nothing new to compare
            }
            $msg .= self::compareFinal($jsonValue, $dbField, $placeId);
        } catch (Exception $ex) {
            $msg .= "$errorBeg " . $ex->getMessage() . " compare $jsonField, $dbField $errorEnd ";
        } // end catch
        return $msg;
    } // end function compare

    static private function compareFinal($jsonValue, $dbField, $placeId)
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        try {
            $debug = false;
            if (array_key_exists($dbField, self::$bizRecord)) {
                $dbValue = self::$bizRecord[$dbField];
                if (is_null($dbValue))
                    $dbValue = "";
                // field exists
            } else {
                $msg .= "$errorBeg E#2050 compareFinal field $dbField does not exist in business $placeId $errorEnd " .
                    rrwUtil::print_r(self::$bizRecord, true, "E#existing business record");
                throw new Exception($msg);
            }
            if ($debug) $msg .= "I#2015 compareFinal comparing $dbField, jsonValue '$jsonValue', dbValue '$dbValue' for $placeId $eol";
            if ($jsonValue == $dbValue) {
                // values are equal do nothing
                return $msg;
            }
            // old value vs new value is different
            self::$updateBusiness[$dbField] = $jsonValue;   // cause new value to database
            $historyRecord = "Google change - '$dbField' -- '$dbValue' -> '$jsonValue'";
            $msg .= insertIntoHistory($placeId, $historyRecord);
            if ($debug) $msg .= "$historyRecord .$eol";
        } catch (Exception $ex) {
            $msg .= "$errorBeg " . $ex->getMessage() . " compareFinal $jsonValue, $dbField $errorEnd ";
        } // end catch
        return $msg;
    } // end function compareFinal


    static private     function getJsonPlacestoken($latLngOrToken, $category, $radiusMiles = 0.5)
    {
        global $eol, $errorBeg, $errorEnd;
        freeWheeling_edit_setGlobals::notAllowedToEdit("json token");
        sleep(2); // token not valid until a few seconds after the first call
        $url = "https://maps.googleapis.com/maps/api/place/nearbysearch/json";
        $url .= "?pagetoken=$latLngOrToken"; //
        list($msgTemp13, $places) = self::getJsonPlacesUrl($url, $category, $radiusMiles);
        return array($msgTemp13, $places);
    }
    static private function getJsonPlacesAddress($address, $category, $radiusMiles = 0.5)
    {
        global $eol, $errorBeg, $errorEnd;
        if (freeWheeling_edit_setGlobals::notAllowedToEdit("getJsonPlacesAddress")) {
            $msgErr = "$errorBeg E#616 You need to login to perform this task $errorEnd ";
            throw new Exception($msgErr);
        }
        $url = "https://maps.googleapis.com/maps/api/place/textsearch/json";
        $url .= "?query=$address";
        list($msgTemp14, $places) = self::getJsonPlacesUrl($url, $category, $radiusMiles);
        return array($msgTemp14, $places);
    }
    static private
    function getJsonPlacesUrl($url, $category = "", $radiusMiles = 0.5)
    {
        global $eol, $errorBeg, $errorEnd;
        global $meters2Mile;
        // returns an array of places
        $msg = "";
        $debugGetJsonPlacesUrl = false;
        if (freeWheeling_edit_setGlobals::notAllowedToEdit("getJsonPlacesUrl"))
            throw new Exception("$msg $errorBeg E#597 getJsonPlacesUrl permission has not been granted. Are you logged in? $errorEnd");
        if ($debugGetJsonPlacesUrl) $msg .= "$eol input - getJsonPlacesUrl ( $url, $category, $radiusMiles $eol)";

        if (strpos($url, "pagetoken") !== false) {
            $msg .= "got page token $eol";
            // no parameters are allowed
            $iiAmp = strpos("&", $url);
            if ($iiAmp !== false) {
                if ($debugGetJsonPlacesUrl) $msg .= "found amp at $iiAmp " . substr($url, $iiAmp) . $eol;
                $url = substr($url, 0, $iiAmp); // remove stuff
            }
        } else {
            $url = str_replace(" ", "+", $url);
            $radius = $radiusMiles * $meters2Mile; // miles to meters
            $url .= "&radius=$radius";
            if (!empty($category) && strpos(",", $category) === false)
                $url .= "&type=$category";
        }
        freewheelAPI_2025::appendApiKeyToUrlWithDate($url);
        if ($debugGetJsonPlacesUrl) $msg .= "<strong>final</strong> - getJsonPlacesUrl $url $eol ";
        $places = self::getJsonPlacesJustUrl($url, $msg);
        if (! is_array($places)) {
            $msgErr = "$errorBeg E#617 getJsonPlacesUrl did not return an array $errorEnd";
            $msg .= rrwUtil::print_r($places, true, "places 4");
            $msg .= rrwFormat::backtrace($msgErr);
            throw new Exception($msg);
        }
        if (array_key_exists("status", $places)) {
            if ($places["status"] !== "OK") {
                $msg .= "no matches" . $places["status"] . $url;
            }
        }
        return array($msg, $places);
    } // end getJsonPlacesUrl
    static private function getJsonPlacesJustUrl($url, &$msgOutput)
    {
        // returns an array of places
        // caller should check that places["status"] = "OK"
        global $eol, $errorBeg, $errorEnd;

        $debugJsonUrl = false;
        $searchTime = new DateTime();
        if ($debugJsonUrl) $msgOutput .= "into getJsonPlacesJustUrl with $eol $url $eol";
        $numTries = 0;
        $places = array();
        $placesJson = "";
        while (1) {
            $numTries++;
            if ($numTries > 4) {
                $msgOutput .= "$errorBeg E#519 getJsonPlaces: too many tries  while asking for $eol
                        ======url $url $eol ====== result $eol ========= $errorEnd";
                if (strlen($placesJson) < 10) {
                    $places = array("$errorBeg E#546 the result is less than 10 characters $errorEnd");
                } else {
                    $places = json_decode($placesJson, true);
                }
                $msgOutput .= rrwUtil::print_r($places, true, "Places  5") . "================= $eol";
                break;
            }
            freewheelAPI_2025::appendApiKeyToUrlWithDate($url);
            if ($debugJsonUrl) $msgOutput .= "calling fetchURLcontents  with $eol $url $eol";

            $placesJson = rrwUtil::fetchURLcontents($url, "", 120);
            if ($debugJsonUrl) $msgOutput .= " -------------$eol $placesJson ---------$eol)";
            if (strpos($placesJson, '"status" : "OK"') !== false) {
                $places = json_decode($placesJson, true);
                $readableTime = date('Y-m-d-H:i:s');
                $filename = "places-$readableTime.txt";
                $placeText = "$url $eol $eol " . rrwUtil::print_r($places, true, "send places to file");
                $msgOutput .= freewheeling_writeup::saveReport("places-$url-", $placeText);
                $msgOutput .= "I#2115 saved google place file <a href='/write_up?file=$filename'>$filename </a>$eol";
                if ($debugJsonUrl) $msgOutput .= rrwUtil::print_r($places, true, "places 6");
                if (array_key_exists("results", $places)) {
                    // there are a number of results
                    //$msg .=  Google_cost_increase::googleCostIncrease($url, count($places["results"]));
                }
                return $places;
            }
            if (strpos($placesJson, '"status" : "OVER_QUERY_LIMIT"') !== false) {
                $msgOutput .= "$errorBeg E#691 query limit error $eol
						<a href='https://console.cloud.google.com/iam-admin/quotas?project=roys-spot-api-1515971835287'>
						See</a> $eol ======url  $url $eol ====== result $placesJson $eol ========= $errorEnd";
                $places = json_decode($placesJson, true);
                throw new Exception("$msgOutput thats it");
            } elseif (strpos($placesJson, 'NOT_FOUND') !== false) {
                $msgOutput .= "$errorBeg E#318 got NOT_FOUND for
                         ======url $url $eol ====== result $placesJson $eol ========= $errorEnd";
                $places = json_decode($placesJson, true);
                break;
            } elseif (strpos($placesJson, '"status" : "ZERO_RESULTS"') !== false) {
                $msgOutput .= "$errorBeg E#595 no results found error $eol
    ======url $url $eol ====== result $placesJson $eol ========= $errorEnd";
                $places = json_decode($placesJson, true);
                break;
            } elseif (strpos($placesJson, 'illegal request') !== false) {
                $msgOutput .= "$errorBeg E#686 Your client has issued a malformed or illegal request. $eol
    ======url $url $eol ====== result $placesJson $eol ========= $errorEnd";
                $places = json_decode($placesJson, true);
                break;
            } elseif (strpos($placesJson, 'INVALID_REQUEST') !== false) {
                sleep(1);
                $msgOutput .= "got INVALID REQUEST sleep 1 second for $numTries tries &nbsp; $url $eol";
                continue;
            } else {
                $diff = $searchTime->diff(new DateTime());
                $seconds = $diff->s;
                if ($seconds > 10) {
                    $errmsg = "$msgOutput $errorBeg E#741 Time limit reached end inside getJsonPlaces " . date("H:i:s") .
                        " taking $seconds $errorEnd";
                    throw (new Exception($errmsg));
                }
            }
        } // end while (1)
        return $places;
    } // end getJsonPlacesJustUrl
    static
    function readJsonArray($filename)
    {
        // $dirPlugs = plugin_dir_path( __FILE__ );
        global $eol, $errorBeg, $errorEnd;
        global $freewheeling_prebuilt_dire;
        $fileNameFull = "$freewheeling_prebuilt_dire/$filename";
        // print "readJsonArray:fileNameFull $fileNameFull $eol";
        if (!file_exists($fileNameFull)) {
            return "$errorBeg no file by the name of $fileNameFull E#288 exists.";
        }
        $fp = fopen($fileNameFull, "r");
        $json = fread($fp, filesize($fileNameFull));
        fclose($fp);
        // print "$json ===============================================================================";
        $out = json_decode($json, true);
        // var_dump ($out);
        return $out;
    }
    static public
    function getJsonDetail2($place_id, $debugGetJsonDetail = false)
    {
        global $eol, $errorBeg, $errorEnd;
        global $jsonPagesDetailTotal;
        global $foundBusinessesList, $foundAddressList;
        global $cntCalls;
        // returns an array of places
        $msg = "";
        $debugJasonDetail = false;
        if (isset($cntCalls))
            $cntCalls++;
        else
            $cntCalls = 0;
        $searchTime = new datetime();
        if (freeWheeling_edit_setGlobals::notAllowedToEdit("jasonDetail"))
            throw new Exception("$msg E#598 getJsonDetail permission has not been granted. Are you logged in? $errorEnd");
        $msg .= " =================================================================================
    ===================================================================================
    $eol";
        $url = "https://places.googleapis.com/v1/places/$place_id";
        $url .= "&fields=places.internationalPhoneNumber,places.nationalPhoneNumber,places.websiteUri,";
        $url .= "places.formattedAddress,places.rating,places.displayName,places.permanentlyClosed,places.businessStatus,";
        $url .= "geometry,types,place_id,formatted_address";
        freewheelAPI_2025::appendApiKeyToUrlWithDate($url);
        $url = str_replace("&force=1", "", $url);
        $url = str_replace("?force=1", "", $url);
        $url = str_replace("&force=please", "", $url);
        $url = str_replace("?force=please", "", $url);
        $ii = strpos($url, "placeid=");
        $jj = strpos($url, "&", $ii);
        $key = substr($url, $ii + 8, $jj - $ii - 8);
        $urlPrint = substr($url, 0, $ii) .
            "placeid=<a href='https://edit.shaw-weil.com/edit-biz/?bizId=$key' target='edit'>$key</a>" .
            "$eol &nbsp; &nbsp; &nbsp; &nbsp; &field" . substr($url, $jj);
        if ($debugJasonDetail) $msg .= "asking Google about $urlPrint $eol";
        $diff = $searchTime->diff(new datetime());
        $seconds = $diff->s;
        if ($seconds > 5) {
            $errmsg = "$msg Time limit reached end inside getJsonDetail " . date("H:i:s") . " taking $seconds $eol";
            throw (new Exception($errmsg));
        }
        $msg .= "\n
    <!-- getJsonDetail:url --- $url -->\n";
        $placesJson = rrwUtil::fetchURLcontents($url, "", 120);

        if (strpos($placesJson, '"status" : "OK"') === false) {
            $errormsg = "$msg $errorBeg getJsonDetail: E#404 while asking for $eol $place_id $eol
    ======url $url $eol ====== result $eol $placesJson $errorEnd
    " . rrwUtil::print_r($placesJson, true, "status not okay ");
            return array($msg, json_decode($placesJson, true));
            throw (new Exception($errormsg));
        }
        if ($debugGetJsonDetail) $msg .= "$placesJson $eol";
        $places = json_decode($placesJson, true);

        $placeText = "$url $eol $eol " . rrwUtil::print_r($places, true, "send places to file");
        $msg .= freewheeling_writeup::saveReport("detail-$place_id-", $placeText);
        $jsonPagesDetailTotal++;
        return array($msg, $places);
    }
    static private
    function BreakUpAddress($detail, &$msg)
    {
        global $eol, $errorBeg, $errorEnd;
        $houseNumber = "";
        $street = "";
        $city = "";
        $state = "";
        $zip = "";
        $debugAddress = false;;
        if (array_key_exists("address_components", $detail)) {
            if ($debugAddress) $msg .= rrwUtil::print_r($detail["address_components"], true, "address_components");
            foreach ($detail["address_components"] as $item) {
                if (count($item["types"]) < 1) {
                    $msg .= "$errorBeg E#561 address_components item has no types $errorEnd";
                    $msg .= rrwUtil::print_r($item, true, "$errorBeg E#520 address_components item has no types");
                    $msg .= $errorEnd;
                    continue;
                }
                $type = $item["types"][0];
                $shortname = $item["short_name"];
                switch ($type) {
                    case "street_number":
                        $houseNumber = $shortname;
                        break;
                    case "route":
                        $street = $shortname;
                        break;
                    case "locality":
                        $city = $shortname;
                        break;
                    case "neighborhood":
                        $city = $shortname;
                        break;
                    case "administrative_area_level_3":
                        if (empty($city) || "Universal" == $city)
                            $city = $shortname;
                        break;
                    case "administrative_area_level_1":
                        $state = $shortname;
                        break;
                    case "postal_code":
                        $zip = $shortname;
                        break;
                    case "zip":
                } // end switch
            } // end foreach ($detail["address_components"] as $item)
            // print "BreakUpAddress:address_components: $street, $city, $state, $zip $eol";
        } elseif (array_key_exists("vicinity", $detail)) {
            if ($debugAddress) $msg .= rrwUtil::print_r($detail["vicinity"], true, "vicinity");
            $vicinity = $detail["vicinity"];
            $iiComma = strpos($vicinity, ",");
            if ($iiComma !== false) {
                $street = substr($vicinity, 0, $iiComma);
                $city = substr($vicinity, $iiComma + 1);
            } else {
                $city = $vicinity;
            }
            $state = "";
            $zip = "";
            // print "BreakUpAddress:vicinity: $street, $city, $state, $zip $eol";
        } else {
            $street = $detail;
            $city = "";
            $state = "";
            $zip = "";
        }
        if (!empty($houseNumber))
            $street = "$houseNumber $street";
        return array($street, $city, $state, $zip);
    } //BreakUpAddress( $detail )

    static private
    function buildBizToAlwaysProcess()
    {
        global $wpdbExtra, $rrw_exceptions;
        global $eol, $errorBeg, $errorEnd;
        global $BizToAlwaysProcess;
        $msg = "";
        $BizToAlwaysProcess = array();
        $sqlIgnore = "select fixBizId from $rrw_exceptions
    where fixType = 'ignoreGoogleTypes'";
        $recIgnores = $wpdbExtra->get_resultsA($sqlIgnore);
        foreach ($recIgnores as $recIgnore) {
            array_push($BizToAlwaysProcess, $recIgnore["fixBizId"]);
        }
        return $msg;
    } // end buildBizToAlwaysProcess()
} // end class freewheeling_edit_google