<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.com
 *
 */
class freewheelingeasy_edit_html
{
    static public
    function EditHtml($attr)
    {
        global $eol, $errorBeg, $errorEnd;
        try {
            $debugEditIcon = rrwParam::Boolean("debugEditIcon");
            $msg = "";
            error_reporting(E_ALL );
            $viewOnly = rrwParam::Boolean("viewonly");
            if (!$viewOnly)
                freeWheeling_edit_setGlobals::notAllowedToEdit("edit icon");
            $msg .= freeWheeling_edit_setGlobals::setGlobals("freewheelingEditIcon");
            $update_name = rrwParam::String("update_name", $attr, "");
            if (empty($update_name)) {
                $trailId = freeWheelParam::trail();
                $msg .= self::processHtml($trailId);
                return $msg;
            }
        } catch (Exception $ex) {
            $msg .= "$errorBeg E#689 top level error locating an icon" . $ex->getMessage() . $errorEnd;
        }
        return $msg;
    } // end function EditHtml

    static public
    function processHtml($trailId)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_codes;
        $msg = "";
        // assert $iconId  is the correct iconId of an existing icon
        $view = rrwParam::Boolean("view");

        $displayHtml = new rrwDisplayTable();
        $displayHtml->tablename($wpdbExtra->html);
        $displayHtml->setOutputBizHistoryRecord(false);
        $displayHtml->noListRequest();  // do not allow list request
        $displayHtml->sortDefault("htmTrailId");
        $displayHtml->keyname("htmTrailId");
        $displayHtml->keyvalue($trailId);
        if (!empty($view)) {
            // Adds an edit block to the front of the table
            $displayHtml->columns("edit correction here", "comment", 250);
            $displayHtml->listdata_noedit();
        }
        $displayHtml->columnRead("Trail Id", "htmTrailId", 69, 1);
        $displayHtml->columns("Google Verify Meta", "googleVerifyMeta", 250);
        $displayHtml->columns("Google Tag Manager", "googleTagManager", 450);
        $displayHtml->columnRead("URL in the book", "bookURL", 60, 1);
        $displayHtml->columnRead("General Location", "Location", 450, 1);
        $displayHtml->columnRead("Surface Description", "surfacedescription", 450,mode:1);
         $displayHtml->columnRead("Paved Miles", "pavedmiles", 450, mode: 1);
         $displayHtml->columnRead("Character Description", "characterdescription", 450, mode: 1);
         $displayHtml->columnRead("Usage", "Usage", 450, mode: 1);
         $displayHtml->columnRead("Amenities Collection", "AmenitiesCollection", 450, mode: 1);
         $displayHtml->columnRead("unknown Count", "unknownCount", 450, mode: 1);
         $displayHtml->columnRead("Page Number", "pageNumber", 450, mode: 1);
         $displayHtml->columnRead("Book URL", "bookURL", 450, mode: 1);
         $displayHtml->columnRead("Version Text", "VersionText", 450, mode: 1);
         $displayHtml->columnRead("oldest Segment", "oldestSegment", 450, mode: 1);
         $displayHtml->columnRead("Last Edit", "lastedit", 450, mode: 1);
       $displayHtml->columnRead("Topo Names", "topoNames", 450, mode: 1);
       $displayHtml->columnRead("Drive Time", "DriveTime", 450, mode: 1);
       $displayHtml->columnRead("Trail Description", name: "htmTrailDescription", size: 450, mode: 1);
       $displayHtml->columnRead("First Section", "htmFirstSection", 450, mode: 1);
       $displayHtml->columnRead("Development", "htmDevelopment", 450, mode: 1);
       $displayHtml->columnRead("Extension", "htmExtension", 450, mode: 1);
       $displayHtml->columnRead("Access Points", "htmAccessPoints", 450, mode: 1);
       $displayHtml->columnRead("Amenities List", "htmAmenitiesList", 450, mode: 1);
       $displayHtml->columnRead("Local History", "htmLocalHistory", 450, mode: 1);
       $displayHtml->columnRead("Organization Address", "htmOrganizationAddress", 450, mode: 1);
 $displayHtml->columnRead("Resources", "htmResources", 450, mode: 1);
 $displayHtml->columnRead("Extracted", "Extracted", 450, mode: 1);
 $displayHtml->columnRead("htmKey", "htmKey", 450, mode: 1);



        //  ------------------------------------ setup done, get to processing
        $msg .= $displayHtml->DoAction();
        $msg .= $displayHtml->DisplayAllHistory($trailId);
        return $msg;
    } // end function processHtml

} // end class
