<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.com
 *
 */
class freewheelingeasy_edit_icon
{
    static public
    function freewheelingEditIcon($attr)
    {
        global $eol, $errorBeg, $errorEnd;
        try {
            $debugEditIcon = rrwParam::Boolean("debugEditIcon");
            $msg = "";
            error_reporting(E_ALL | E_STRICT);
            $viewOnly = rrwParam::Boolean("viewonly");
            if (!$viewOnly)
                freeWheeling_edit_setGlobals::notAllowedToEdit("edit icon");
            $msg .= freeWheeling_edit_setGlobals::setGlobals("freewheelingEditIcon");
            $update_name = rrwParam::String("update_name", $attr, "");
            $update_value = rrwParam::Integer("update_value", $attr, "");
            if ($update_name == "iconId") {
                $msg .= self::processIconId($update_value);
                return $msg;
            } // end action processing
            if ($debugEditIcon) $msg .= "E#278 looking for iconId in get variables" . rrwUtil::print_r($_GET, true, "_get variables get") .
                rrwUtil::print_r($_COOKIE, true, "_get variables cookie");
            $iconId = freeWheelParam::icon($attr, true);
            if (!empty($iconId)) {
                $msg .= self::processIconId($iconId);
            } else {
                $msg .= "$errorBeg E#250 no parameter given. Expected iconName, iconId, $errorEnd ";
                $msg .= rrwUtil::print_r($_GET, true, "_get variables #2");
                return $msg;
            }
        } catch (Exception $ex) {
            $msg .= "$errorBeg E#251 top level error locating an icon" . $ex->getMessage() . $errorEnd;
        }
        return $msg;
    }

    static public
    function processIconId($iconId)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_codes;
        $msg = "";
        // assert $iconId  is the correct iconId of an existing icon
        $view = rrwParam::Boolean("view");
        $sqlIcon = "select latitude, longitude, icDateNear, onMap, iconName from $wpdbExtra->icons where iconId = $iconId";
        $recIcons = $wpdbExtra->get_resultsA($sqlIcon);
        if ($wpdbExtra->num_rows != 1) {
            print rrwFormat::backtrace("missing iconId $iconId");
            throw new Exception("$errorBeg E#254 no icon found in process iconId($iconId) $errorEnd");
        }
        $latitude = $recIcons[0]["latitude"];
        $longitude = $recIcons[0]["longitude"];
        $icDateNear = $recIcons[0]["icDateNear"];
        $onMap = $recIcons[0]["onMap"];
        $iconName = $recIcons[0]["iconName"];

        $mapLink = FreewheelFormat::iconIdMapLink($iconId,);
        $latLngLink = FreewheelFormat::latitudeMapLink($latitude, $longitude, "latMap");
        if (strpos($onMap, "amen") === false) {
            $displayAmenity = "";        // not an amenity
        } else {
            $pageName = $iconName . "-" . "$iconId";
            $displayAmenity = "<a href='https://edit.shaw-weil.com/freewheelingeasy-amenity/?amenity=$pageName' >amenity</a>";
            $msg .= "This icon is not on the map.  It is not displayed on the map.  ";
        }

        $displayIcon = new rrwDisplayTable();
        $displayIcon->tablename($wpdbExtra->icons);
        $displayIcon->setOutputBizHistoryRecord(false);
        $displayIcon->noListRequest();  // do not allow list request
        $displayIcon->sortDefault("iconName");
        $displayIcon->keyname("iconId");
        $displayIcon->keyvalue($iconId);
        if (!empty($view)) {
            // Adds an edit block to the front of the table
            $displayIcon->columns("edit correction here", "comment", 250);
            $displayIcon->listdata_noedit();
        }
        $displayIcon->columns("icon Name", "iconName", 69, 1);
        $displayIcon->columns("Description", "ptDescription", 250);
        $displayIcon->DropDownSelf("Mile Post Prefix", "milePostPrefix");
        $displayIcon->columns("Mile Post", "milepost", 20);
        $sqlOnMap = "SELECT code as value, codeDescription as display FROM $rrw_codes
					where codetype = 'isonmap' order by codesort";
        $displayIcon->DropDownOther("Is On Map", "onMap", 30, $sqlOnMap, $displayAmenity);
        $sqltrailhead = "SELECT code as value, codeDescription as display FROM $rrw_codes
					where codetype = 'trailhead' order by codesort";
        $displayIcon->DropDownOther("Is a trail head", "isTrailHead", 30, $sqltrailhead);
        $displayIcon->columns("Icon display(style)", "iconstyle", 50);
        $displayIcon->DropDownSelf("show in step millage chart", "isMileageStep");
        $displayIcon->DropDownSelf("Show in amenity list", "isAmenityList");
        $displayIcon->columnread("Trail id", "trailId", 10, 1);
        $displayIcon->columnread("Sequence", "sort", 10, 1);
        $displayIcon->columnread("Source", "source", 60, 1);
        $displayIcon->columns("associated line", "iconLineId", 10);
        $displayIcon->columnread("icon id", "iconId", 60, 1, $mapLink);
        $displayIcon->columnread("latitude", "latitude", 60, 1, $latLngLink);
        $displayIcon->columnread("longitude", "longitude", 60, 1);
        $displayIcon->columnread("processed near by place on ", "icDateNear", 60, 1);

        //  ------------------------------------ setup done, get to processing
        $msg .= $displayIcon->DoAction();
        $msg .= $displayIcon->DisplayAllHistory($iconId);
        return $msg;
    } // end function processicon

    static public function deleteRoutes($iconId)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_icons, $rrw_business;
        $msg = "";
        $sql = "select mileDisplayStart, mileDisplayEnd, milePostPrefix from $rrw_icons where iconId = $iconId ";
        $recIcons = $wpdbExtra->get_resultsA($sql);
        if ($wpdbExtra->num_rows != 1)
            return "$msg $errorBeg E#252 did not get just one row of icons from $errorEnd $sql $eol";
        $mileDisplayEnd = $recIcons[0]["mileDisplayEnd"];
        $mileDisplayStart = $recIcons[0]["mileDisplayStart"];
        $milePostPrefix = $recIcons[0]["milePostPrefix"];
        $sqlDel = "update $rrw_business set trailMilepostPrefix = '', trailmilepost = 0
					where trailmilepost <= $mileDisplayEnd and trailmilepost >= $mileDisplayStart
					and trailMilepostPrefix = '$milePostPrefix'";
        $msg .= "deleted " . $wpdbExtra->query($sqlDel) . " routes - $milePostPrefix - from $mileDisplayStart to $mileDisplayEnd $eol";

        return $msg;
    }
} // end class
