<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.co
 */
class freewheelingeasy_land
{
    public static
    function CreatePageOfTrailLinks()
    {
        // called by freewheelingEasy_kml_trailList::kml_trailList {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";

        $msg .= freeWheeling_edit_setGlobals::setGlobals("CreatePageOfTrailLinks");
        $linkingContents = "";

        $csvContents = "";
        $sqlTrail = "select distinct trId, trName, landingPage,
						ihtc, storeUrl from $wpdbExtra->trails
						where useInCurrentDraft = 1 order by trName ";
        $recTrails = $wpdbExtra->get_resultsA($sqlTrail);
        $linkingContents .= "These are the landing page links that have been extracted from the current draft version of the
		<a class-'external' href='https://freewheelingeasy.com/' > book FreeWheeling Easy</a> $eol
		Some trails do not have a website. For those I located a relevant site such as
		Chamber of Commerce, tourist information center, or trail aggregator that had useful trail information.
		If none of those could be found, the link points to the write-up from the
		<a class-'external' href='https://freewheelingeasy.com/' > book FreeWheeling Easy</a>$eol $eol
		If you wish to receive notification whenever changes are made to this list or to the current draft of the book FreeWheeling Easy
		<a href='https://freewheelingeasy.com/receive-notices/'> then subscribe on this page</a> to our e-mail list.$eol
        If you notice an error, or have a better suggestion, please use the
		<a href='https:/webmaster-feedback/' >webmaster feedback form</a>.
		Enter the better link in the message field. $eol $eol
        <table>\n";
        $linkingContents .= rrwFormat::HeaderRow("Corridor", "Trail Name linked to trail website", "Trail Landing page", "Store Page");
        $csvContents = "Corridor,Trail Name,Trail Landing page, Store Page\n";
        $cnt = 0;
        $color = rrwUtil::colorSwap();
        foreach ($recTrails as $recTrail) {
            $cnt++;
            $trId = $recTrail["trId"];
            $trailName = $recTrail["trName"];
            $landingPage = $recTrail["landingPage"];
            $displayIHTC = $recTrail["ihtc"];
            $storeurl = $recTrail["storeUrl"];

            if (empty($landingPage)) {
                $landingPageDisplay = ""; // default nothing there
                // more code here to point to the trail name.freewheelingeasy.com if available.
                // or maybe that code should be in extracting the data from the html file
            } else {
                $landingPageDisplay = "<a class='external' href='$landingPage' >$landingPage</a>"; // default
                if (substr($landingPage, 0, 7) == "http://") {
                    $landingPageDisplay .= "<span style='color:red;' > Note: http not secure</span>";
                }
            }
            $trnameDisplay = rrwFormat::PencilIcon("edit-trail/?trailname=$trailName") .
                $trailName;
            $storeDisplay = self::formatStoreUrlLink($trId, $storeurl);
            $color = rrwUtil::colorSwap($color);
            $linkingContents .= rrwformat::CellRow($color, $displayIHTC, $trnameDisplay, $landingPageDisplay, $storeDisplay);
            $csvContents .= "$displayIHTC,$trailName, $landingPage, $storeurl\n";
            //       $html .;= rrwFormat::CellRow $color, $trailName, $landingPageDisplay );
        }
        $linkingContents .= "</table>\n";
        $linkingContents .= "$eol Updated " . date("F j Y") . ", more recent data may be available at
				https:/links";
        // and a<a href='https:/get.php?file=$lingingcsv'>.CSV version. $eol";
        //		$msg .= "$sqlTrail $eol";
        $msg .= "Output $cnt links to file " .
            freewheeling_writeup::saveFile("data", "linking.html", $linkingContents);
        $msg .= "Output $cnt links to file " .
            freewheeling_writeup::saveFile("data", "linking.csv", $csvContents);
        $msg .= $eol;
        return $msg;
    } // end CreatePageOfTrailLinks

    private static function formatStoreUrlLink($trailId, $storeUrl)
    {
        if (empty($storeurl) || "none" == $storeurl) { // no store url, so provide optiton to assign one
            $storeDisplay = '<form action="/landing" method="post">
                <input type="hidden" name="trailId" value="$trailId">
                <input type="hidden" name="task" value="storeupdate">
                <input type="text" name="storeurl" value="https://">
                <input type="submit" value="Assign">
                </form>';
        } else { // we have a store url
            if (strpos($storeurl, "freewheel") === false && strpos($storeurl, "shaw") === false)
                $class = "";
            else
                $class = "class='external'";
            $storeDisplay = "<a $class href='$storeurl' target='landing'> has store</a>";
        }

        return $storeDisplay;
    } // end formatStoreUrlLink

    static private function assignStoreUrl($storeUrl = "")
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_trails;
        $msg = "";
        $debug = rrwParam::Boolean("debug");
        try {
            $trailId = freeWheelParam::trail();
            if (empty($storeUrl)) {
                $sql = "select landingPage from $rrw_trails where trid = '$trailId'";
                if ($debug) $msg .= "$sql $eol";
                $rec = $wpdbExtra->get_resultsA($sql);
                if ($wpdbExtra->num_rows != 1)
                    return "$msg $errorBeg E#484 sql did noy return one row $errorEnd ";
                if ($debug) $msg .= rrwUtil::print_r($rec, true, "record");
                $storeUrl = $rec[0]["landingPage"];
                if (substr($storeUrl, -1) == "/")
                    $storeUrl .= "store";
                else
                    $storeUrl .= "/store";
            } else {
                // the input uol is what we want
            }
            $sqlUUpdate = "update $rrw_trails set storeurl ='$storeUrl' where trid ='$trailId'";
            $wpdbExtra->query($sqlUUpdate);
        } catch (Exception $ex) {
            $msg .= "$errorBeg E#485 freewheelingeasy_edit_land:land
                        " . $ex->getMessage() . $errorEnd;
        }
        $msg .= "<a href='/landing' > show list </a> $eol";
        return $msg;
    } // end assignStoreUrl

    static private
    function detail($attr)
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        try {
            $msg .= "a listing of landing pages $eol";
        } catch (Exception $ex) {
            $msg .= "$errorBeg E#400 freewheelingeasy_edit_land:detail
                        " . $ex->getMessage() . $errorEnd;
        }
        return $msg;
    } // end detail

} // class freewheelingeasy_land {
