<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.com
 *
 */
class freewheelingeasy_edit_line
{
    static public
    function editLine($attr)
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        try {
            error_reporting(E_ALL | E_STRICT);
            print "edit-line.php calling param line $eol";
            $lineId = freeWheelParam::line($attr);
            $task = rrwParam::String("task", $attr);

            if ("deleteRoutes" == $task) {
                $msg .= self::deleteRoutes($lineId);
                return $msg;
            }
            $viewOnly = rrwParam::Boolean("viewonly");
            if (!$viewOnly)
                freeWheeling_edit_setGlobals::notAllowedToEdit("edit business");
            $msg .= freeWheeling_edit_setGlobals::setGlobals("freewheelingEditLine");
            if (empty($lineId))
                throw new Exception("$errorBeg E#628 no parameter given. Expected lineName, lineId, $errorEnd");
            $msg .= self::processLineId($lineId);
        } catch (Exception $ex) {
            $msg .= "$errorBeg E#317 top level error locating an line" . $ex->getMessage() . $errorEnd . rrwUtil::print_r($_POST, true, "_post variables #2") . $eol;
        }
        return $msg;
    }

    static public
    function processLineId($lineId)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        // assert $lineId  is the correct lineId of an existing line
        $view = rrwParam::Boolean("view");
        $msg .= freewheelingeasy_kml_merge::UpdateInternalLineFieldsFromPoints($lineId);  // make sure the line variables up to date
        $sql = "select lineName, latStart, lngStart, latEnd, lngEnd, lineIconId, mapStyle from $wpdbExtra->lines where lineId = $lineId";
        $lineRec = $wpdbExtra->get_resultsA($sql);
        if ($wpdbExtra->num_rows != 1) {
            throw new Exception("$msg $errorBeg  E#269 no line found in processLineId($lineId) $eol $sql $errorEnd");
        }
        $latStart = $lineRec[0]["latStart"];
        $lngStart = $lineRec[0]["lngStart"];
        $latEnd = $lineRec[0]["latEnd"];
        $lngEnd = $lineRec[0]["lngEnd"];
        $lineName = $lineRec[0]["lineName"];
        $lineIconId = $lineRec[0]["lineIconId"];
        $mapStyle = $lineRec[0]["mapStyle"];
        $displayLine = new rrwDisplayTable();
        $displayLine->tablename($wpdbExtra->lines);
        $displayLine->setOutputBizHistoryRecord(false);
        $displayLine->noListRequest();  // do not allow list request
        $displayLine->sortDefault("lineName");
        $displayLine->keyname("lineId");
        $displayLine->keyvalue($lineId);
        if (!empty($view)) {
            // Adds an edit block to the front of the table
            $displayLine->columns("edit correction here", "comment", 250);
            $displayLine->listdata_noedit();
        }
        $mapLinkStart = freeWheelFormat::latitudeMapLink($latStart, $lngStart);
        $mapLinkEnd = freeWheelFormat::latitudeMapLink($latEnd, $lngEnd);
        $lineMapLink = freeWheelFormat::lineIdMapLink($lineId, $lineName);

        $displayLine->columnread("Trail id", "trailId", 20, 1);
        $displayLine->columns("line Name", "lineName", 69, $lineMapLink);
        $displayLine->columns("Description", "lineDescription", 250);
        $displayLine->columns("Routes", "Routes", 60);
        //$displayLine->DropDownSelf("map Style", "mapstyle", 50);
        $sqlStyle = "select code as value, codeDescription as display FROM  $wpdbExtra->codesSurface ";
        $displayLine->DropDownOther("map Style", "mapstyle", 50, $sqlStyle);
        //$displayLine->columnColor("map Style", "mapstyle", 20, 10);
        $displayLine->columnread("Sequence", "sequence", 10, 1);
        $displayLine->columnread("Source", "source", 60, 1);
        $link2icon = freeWheelFormat::EditIconLink($lineIconId, "associated Icon");
        $displayLine->columns("associated Icon", "lineIconId", 10, $link2icon);
        $displayLine->columnread("line id", "lineId", 60, 1);
        $displayLine->columnread("length meters", "lengthMeters", 60, 1);
        $displayLine->columnread("latitude Start", "latStart", 60, 1, $mapLinkStart);
        $displayLine->columnread("longitude Start", "lngStart", 60, 1);
        $displayLine->columnread("latitude End", "latEnd", 60, 1, $mapLinkEnd);
        $displayLine->columnread("longitude End", "lngEnd", 60, 1);
        $displayLine->columnread("line id", "lineId", 10, 1);

        //  ------------------------------------ setup done, get to processing
        $msg .= $displayLine->DoAction();
        $msg .= $displayLine->DisplayAllHistory($lineId);
        $msg .= freewheelingeasy_kml_merge::UpdateInternalLineFieldsFromPoints($lineId);  // make sure the line variables up to date
        return $msg;
    } // end function processLine

    static private
    function deleteRoutes($lineId)
    {
        // delete all business routes that on start this line
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $sql = "select mileDisplayStart, mileDisplayEnd, milePostPrefix from $wpdbExtra->lines where lineId = $lineId ";
        $recLines = $wpdbExtra->get_resultsA($sql);
        if ($wpdbExtra->num_rows != 1)
            return "$msg $errorBeg E#255 did not get just one row of lines from $errorEnd $sql $eol";
        $mileDisplayEnd = $recLines[0]["mileDisplayEnd"];
        $mileDisplayStart = $recLines[0]["mileDisplayStart"];
        $milePostPrefix = $recLines[0]["milePostPrefix"];
        $sqlDel = "update $wpdbExtra->business set trailMilepostPrefix = '', trailMilepost = 0
					where trailMilepost <= $mileDisplayEnd and trailMilepost >= $mileDisplayStart
					and trailMilepostPrefix = '$milePostPrefix'";
        $msg .= "deleted " . $wpdbExtra->query($sqlDel) . " routes - $milePostPrefix - from $mileDisplayStart to $mileDisplayEnd $eol";

        return $msg;
    }
} // end class
