<?PHP
class freewheeling_makeTOC
{

    public static function makeTocFiles()
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $draftFile = "DraftTrail.html";
        $draftFileNE = "DraftTrail-NE.html";
        $msg .= freewheelingEasy_kml_trailList::formatAction(
            "Updated the book draft table of contents NorthEast",
            "$draftFileNE"
        );
        $msg .= self::createOneTocFile($draftFileNE, "N-algy-riv") . $eol;
        $msg .= freewheelingEasy_kml_trailList::formatAction(
            "Updated the book draft table of contents ",
            "$draftFile, $draftFile "
        ) . $eol;
        $msg .= self::createOneTocFile($draftFile);     // done list to get all trails in the json file
        return $msg;
    }

    /**
     * Creates a table for line detail selection.
     *
     * This function generates an HTML table that displays links to line details, step charts, and trail maps for  trails and groups.
     * It retrieves trail and group information from the database, checks for the existence of corresponding HTML files, and constructs
     * links to these files if they exist. The resulting table is saved to a milage-charts/__LineDetailSelectionTable.html.
     *
     * @global object $wpdbExtra The database connection object.
     * @global string $eol The end-of-line character(s).
     * @return string A message indicating the number of trails found and any errors encountered.
     */
    public static function createLineDetailSelectionTable()
    {
        global $wpdbExtra;
        global $eol;
        $msg = "";
        try {
            $debugColumnBreak = rrwParam::isDebugMode("debugColumnBreak", false);
            $detailLink = array();
            $trailSelect = "select trId, trName from $wpdbExtra->trails
                                 union
                            select grpId, grpName from $wpdbExtra->trail_routes order by trname";
            $recTrails = $wpdbExtra->get_resultsA($trailSelect);
            $cnt = 0;
            $msg .= "found " . count($recTrails) . " trails $eol";
            // return  "$msg $eol temp check hanging ---------  after counting -----------4-----$eol";

            foreach ($recTrails as $recTrail) {
                $cnt++;

                $trId = $recTrail["trId"];
                $trName = $recTrail["trName"];
                // ---------------------------------------------------------   line detail by trail/group
                $dataFileName = "$trId" . "-routeDetail.html";
                $subDire = "miles-by-type";
                $sourceFile = freewheeling_WriteUp::fullNameFromShortName($subDire, $dataFileName);
                //  $msg .= "checking for $dataFileName || $sourceFile $eol";
                if (file_exists($sourceFile)) {
                    $lineLink[$cnt] = "<a href='/write-up/?file=/$subDire/$dataFileName' > line Detail,</a>";
                } else {
                    // $msg .= "---------------------------------------------------------------------  file not found $sourceFile $eol";
                    $lineLink[$cnt] = "";
                }
                // ---------------------------------------------------------   stair step charts by rail/group
                $dataFileName = "$trId" . "-stepChart.html";
                $subDire = "mileage-chart";
                $sourceFile = freewheeling_WriteUp::fullNameFromShortName($subDire, $dataFileName);
                //  $msg .= "checking for $dataFileName || $sourceFile $eol";
                if (file_exists($sourceFile)) {
                    $stepLink[$cnt] = "<a href='/write-up/?file=/$subDire/$dataFileName' > step milage</a>";
                } else {
                    // $msg .= "---------------------------------------------------------------------  file not found $sourceFile $eol";
                    $stepLink[$cnt] = "";
                }
                // ---------------------------------------------------------   stair step charts by rail/group
                $dataFileName = "$trId" . "-access.html";
                $subDire = "trailheads-html";
                $sourceFile = freewheeling_WriteUp::fullNameFromShortName($subDire, $dataFileName);
                //  $msg .= "checking for $dataFileName || $sourceFile $eol";
                if (file_exists($sourceFile)) {
                    $headLink[$cnt] = "<a href='/write-up/?file=/$subDire/$dataFileName' > trailhead</a>";
                    $msg .= "I#330 found $cnt  $sourceFile $eol";
                } else {
                    // $msg .= "---------------------------------------------------------------------  file not found $sourceFile $eol";
                    $headLink[$cnt] = "";
                }
                // ---------------------------------------------------------   trail map
                $mapLink[$cnt] = "not yet implemented";
                $trLink[$cnt] = $trName;
                //   $mapLink = freewheelFormat::TrailLink($trId, $trName, "map");
            } //
            $msg .= "gathered  $cnt trails. output to " .  count($detailLink) .  " lines $eol";
            //  return  "$msg $eol temp check hanging ---------  after gathering -----------4-----$eol";
            $numCols = 3;
            $numRows = intval($cnt / $numCols);
            $msg .= "numCols: $numCols, numRows: $numRows $eol";
            for ($cnt = $cnt + 1; $cnt <= $numRows + 21; $cnt++) {
                $lineLink[$cnt] = "";
                $mapLink[$cnt] = "";;
                $trLink[$cnt] = "";
                $headLink[$cnt] = "";
            }

            $output = "<table border='0' >";
            for ($ii = 1; $ii <= $numRows; $ii++) {
                $jj = $ii + $numRows;
                $kk = $ii + $numRows + $numRows;
                if ($debugColumnBreak) $msg .= " items $ii, $jj, $kk $eol";
                $output .= rrwFormat::CellRow(
                    $lineLink[$ii],
                    $stepLink[$ii],
                    $headLink[$ii],
                    $trLink[$ii],
                    $lineLink[$jj],
                    $stepLink[$jj],
                    $headLink[$jj],
                    $trLink[$jj],
                    $lineLink[$kk],
                    $stepLink[$kk],
                    $headLink[$kk],
                    $trLink[$kk]
                );;
            }
            $output .= "</table>";
            $fileName = "LineDetailSelectionTable.html";

            $msg .= freewheeling_Writeup::saveFileWithCompare("mileage-chart", $fileName, $output);
        } catch (Exception $ex) {
            $msg .= "error: " . $ex->getMessage() . $eol;
        }
        return $msg;
    }

    /**
     * Creates a single table of contents file from a draft file.
     *
     * @param string $draftFile The path to the draft file to process
     * @param string $volume The volume identifier to filter content (default: "%" for all volumes)
     * @param string $sortOrder The field to sort by (default: "trName" for translation name)
     * @return mixed Returns the result of the TOC file creation process
     * @static
     */
    public static function createOneTocFile($draftFile, $volume = "%", $sortOrder = "trName")
    {
        global $eol, $errorBeg, $errorEnd;
        global  $wpdbExtra;
        global $tocCnt;
        global $freewheeling_prebuilt_dire_trails_html;     // full path to prebuilt trails-html
        global $freewheeling_pages_trails_html_url;          // url to prebuilt trails-html
        global $freewheeling_www_book_dire;
        $msg = "";
        # does a loops through table looking for item with next date/trail name to print
        # 	when found prints it and marks as printed
        $debugColumnBreak = false;
        $debugRecords = rrwParam::Boolean("debugRecords");
        $debugTocTable = rrwParam::Boolean("debugTocTable");
        $debugItem = rrwParam::String("debugItem");
        $jsonTableFile = "tocTable.json";
        $tocCnt = 0;
        $output = ""; // freewheeling draft contents
        $toctable = array(); // toctable.json -  trail info file
        $output .= "\n <!-- index created " . date("Y-m-d H:i T") . " -->\n
	<form action='https://fwe.royweil.com/' method='post' >
	<table border='0' >";
        $output .= rrwFormat::HeaderRow(
            "Trail Name linked to trail website ",
            "info",
            "Published",
            "last Updated",
            "|",
            "Trail Name linked to trail website ",
            "info",
            "Published",
            "last Updated"
        );
        if ($volume == "")
            $sqlWhereVolume = "";
        else
            $sqlWhereVolume = "where bookVolume like '$volume' ";
        $sql = "select count(*)  from $wpdbExtra->trails
				left join $wpdbExtra->regions on trailId = trId
                left join $wpdbExtra->html on trId = HtmTrailId
                $sqlWhereVolume";
        $totalNumLines = $wpdbExtra->get_var($sql);
        $numRows = $totalNumLines / 2;
        if ($debugColumnBreak) print "Total  lines: $totalNumLines with $numRows  rows$eol";
        $sql = str_replace(
            "count(*)",
            "distinct trId, trName, spurOf, inddFileName,
                                        north, south, east, west, landingPage,
                                        bookVolume, oldestSegment, useInCurrentDraft ",
            $sql
        );
        $sql .= "order by trName ";
        $msg .= "$sql $eol";
        if ($debugRecords) $msg .= "sql: $sql $eol";
        $recTrails = $wpdbExtra->get_resultsA($sql);
        $outputRow = array(); // two column output handler
        $color = rrwUtil::colorSwap();
        $xmlTrailFile = ABSPATH . "writups.xml";
        $xmlMapFile = ABSPATH . "map.xml";
        $msg .= "creating site map to <a href='/sitemap.xml' >$xmlTrailFile </a>$eol";
        $fpTrail = fopen($xmlTrailFile, "w");
        $msg .= siteMapbuild::siteMapHeader($fpTrail);


        foreach ($recTrails as $recTrail) {
            $trId = $recTrail["trId"];

            if ($trId == $debugItem)
                $debugRecords = true;
            else
                $debugRecords = false;
            $trName = $recTrail["trName"];
            if ($debugRecords) $msg .= $trId . " ---- $trName  $eol";
            $inddFileName = $recTrail["inddFileName"];
            $spurOf = $recTrail["spurOf"];
            $north = $recTrail["north"];
            $south = $recTrail["south"];
            $east = $recTrail["east"];
            $west = $recTrail["west"];
            $region = $recTrail["bookVolume"];
            $landingPage = $recTrail["landingPage"];
            $useInCurrentDraft = $recTrail["useInCurrentDraft"];
            $oldest = $recTrail["oldestSegment"];
            if (empty($oldest) || $oldest == "0000-00-00")
                $trDate = "2001-00-00";
            else
                $trDate = substr($recTrail["oldestSegment"], 0, 10);
            if ($debugRecords) $msg .= rrwUtil::print_r($recTrail, true, "trail information from the database");
            if (strpos($trId, "dummy") !== false)
                continue;
            // --------------------------------------------------------- make map cell
            if (empty($north)) {
                // if additional items are added, then modify the
                $msg .= " &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Missing regional coordinates for
                            <strong>$trName</strong> $eol ";
                $toctable[$trId] = freeWheeling_edit_setGlobals::trailInfoEmpty("all");
                $mapcell = "";
            } else {
                $toctable[$trId] = array(
                    "north" => $north,
                    "south" => $south,
                    "east" => $east,
                    "west" => $west
                );
                $mapcell = FreeWheelFormat::EditTrailLink($trId, $trName);
                siteMapbuild::createXMLforMap($fpTrail, $trId, $trDate);
            }
            $toctable[$trId]["trName"] = $trName;
            $toctable[$trId]["trailId"] = $trId;
            $toctable[$trId]["useInCurrentDraft"] = $useInCurrentDraft;
            $toctable[$trId]["inddFileName"] = $inddFileName;
            $toctable[$trId]["landingPage"] = $landingPage;
            $toctable[$trId]["oldestSegment"] = $trDate;
            $toctable[$trId]["sqlWhere"] = "trailId = '$trId'";
            if ($debugTocTable) $msg .= $trId . " ---- $trName $eol";
            $tocCnt++;
            // --------------------------------------------------------- get the elements of the output line
            $trNameLink = FreeWheelFormat::EditTrailLink($trId);  //link to map and external web site
            // is there a website.freewheeling.com or is prepuilt html available
            if (is_dir("$freewheeling_www_book_dire/$trId")) {
                $msg .= "I#351 found $freewheeling_www_book_dire/$trId directory$eol";
                $writeCell = "<a class='external' href='https://$trId.freewheelingeasy.com' >writeup</a>";
            } else {
                if (is_file("$freewheeling_prebuilt_dire_trails_html/$inddFileName.html")) {
                    $writeCell = "<a href='$freewheeling_pages_trails_html_url/$inddFileName.html'> writeup</a>";
                } else {
                    $writeCell = "";
                }
            }
            if ($region == "N-algy-riv" && !empty($inddFileName))
                $published = "yes";
            else
                $published = "";
            if (empty($trDate) || $trDate < "2000-01-01")
                $cellDate = "";
            else
                $cellDate = $trDate;
            // ----------------------------------------------------------- build the line
            $partLine = rrwFormat::Cells($trNameLink, $writeCell, $published, $cellDate);
            if ($useInCurrentDraft == 1)
                array_push($outputRow, $partLine);
        } // end  foreach ( $recTrails as $recTrail )

        $msg .= siteMapbuild::siteMapFooter($fpTrail);
        $rows = count($outputRow);
        $rows = intval($rows / 2);
        $color = rrwUtil::colorSwap();
        for ($ii = 0; $ii < $rows; $ii++) {
            $color = rrwUtil::colorSwap($color);
            $output .= "<tr style='background-color:$color'>" . $outputRow[$ii] .
                rrwFormat::Cell("|") . $outputRow[$ii + $rows] . "</tr>";
        }
        if ($debugColumnBreak) {
            print "<table>\n";
            $color = rrwUtil::colorSwap();
            for ($ii = $numRows - 3; $ii < $numRows + 3; $ii++) {
                $color = rrwUtil::colorSwap($color);
                print "<tr style='background-color:$color' ><td>$ii</td> " . $outputRow[$ii] . "</tr>\n";
            }
            print "</table>\n";
        }
        $output .= "</table>\n</form>\n";
        $sqlRoutes = "select grpid trailId, grpname trName,
					ifNull(north, 42) north, ifNull(south,40) south, ifNull(east,-79) east, ifNull(west, -80) west,
							linesql sqlWhere from $wpdbExtra->trail_routes
				left join $wpdbExtra->regions on trailId = grpid ";
        //where orth is not null ";
        $recGrps = $wpdbExtra->get_resultsA($sqlRoutes);
        foreach ($recGrps as $recGrp) {
            $grpid = $recGrp["trailId"];
            $toctable[$grpid] = $recGrp;
            $toctable[$grpid]["inddFileName"] = "";
        }
        $msg .= "found a total of " . count($toctable) . " trails/groupings and " . count($outputRow) . " entries on the draft page.$eol";
        $jsonTableOutput = json_encode($toctable);
        $readableJsonContent = rrwUtil::print_r($toctable, true, "toctable");
        $readableJsonOutputFile = str_replace(".json", ".html", $jsonTableFile);

        $msg .= freewheeling_Writeup::saveFileWithCompare("data", $readableJsonOutputFile, $readableJsonContent);
        $msg .= freewheeling_Writeup::saveFileWithCompare("data", $jsonTableFile, $jsonTableOutput);
        $msg .= freewheeling_Writeup::saveFileWithCompare("data", $draftFile, $output);
        $msg .= $eol;
        return $msg;
    } // end function DisplayTable( )
} // end class freewheeling_makeTOC