<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.com
 *
 */


/*
*   the route field of a line is a comma separated list of routes that the line is part of
*   This field is used on wo different ways
*       1. used as a selection criteria for the map display to show only the selected trail and it spur trails
*       2. used to gather lines into long distance routes i.e.epta, gap,
*
*   The routes are automatically updated based on database values as part of the kml create process (imposeRoutesTrail())
*        can also be completely updated fix/?task=imposeRoutes (imposeRoutesAll())

*/

/**
 * Class freewheelingeasy_edit_routes
 *
 * This class provides functionality to impose routes on trails and spur trails.
 * It updates the routes in the database based on the provided criteria.
 */
class freewheelingeasy_edit_routes
{
    /**
     * Processes the route setter based on the provided attribute.
     *
     * This function handles the display and processing of route setter data.
     * It initializes a display table, sets up columns, and processes actions.
     *
     * @param mixed $attribute The attribute used for processing the route setter.
     * @return string The message containing the result of the processing and display.
     */
    static public
    function editRoutes($attribute)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        if (freeWheeling_edit_setGlobals::notAllowedToEdit("edit icon")) {
            return " You must be login to edit this data $eol";
        }
        // assert $iconId  is the correct iconId of an existing icon
        $keyId = rrwParam::Integer("keyId", $attribute, 0);
        $displayRouteSetter = new rrwDisplayTable();
        $displayRouteSetter->tablename($wpdbExtra->route_setter);
        $displayRouteSetter->keyname("keyId");
        $displayRouteSetter->keyvalue($keyId);
        $displayRouteSetter->setOutputBizHistoryRecord(false);
        $displayRouteSetter->sortDefault("trailId");
        $displayRouteSetter->DropDownOther("Trail Id", "trailId", 69, "select trId trailId,trName from $wpdbExtra->trails order by trName, trId");
        $displayRouteSetter->columns("Route Description", "description", 250);
        $displayRouteSetter->columns("Route ID", "route", 250);
        $displayRouteSetter->columns("Line Name Start - higher ibn list", "lineNameStart", 100);
        $displayRouteSetter->columns("Line Name End - later n the list", "lineNameEnd", 100);

        //  ------------------------------------ setup done, get to processing
        $msg .= $displayRouteSetter->DoAction();
        $msg .= $displayRouteSetter->DisplayAllHistory($keyId);
        return $msg;
    } // end function editRoutes

    public static function imposeRoutesAll()
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $msg .= "<strong>Imposing all Routes</strong>
                        <a href='edit-route-setter' target='edit'> edit imposed routes</a>$eol";

        $sqlWipe = "update $wpdbExtra->lines set routes = '' ";
        $wpdbExtra->query($sqlWipe);

        $msg .= self::imposeRoutes("%");
        $msg .= createLineText::createZZLineTrails();
        return $msg;
    }


    /**
     * imposeRoutes
     *
     * This method imposes routes on trails and spur trails by updating the lines.routes field in the database.
     * It processes three main tasks:
     * 1. Imposes routes on each trail to plot itself.
     * 2. Imposes routes based on the IHTC Corridor field.
     * 3. Imposes routes with the on route field on the trails table.
     * 4. Imposes routes on spur trails.
     * 5. Imposes routes from the route_setter list.
     * 5.
     *
     * @return string Message log of the imposed routes process.
     * @throws Exception If the number of trails exceeds 300.
     */
    private static  function imposeRoutes($trailId, $debugRouteSetter = false)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        try {
            $msg = "";
            if ("debugEnabler" == $trailId)
                $debugRouteSetter = true;
            else
                $debugRouteSetter = false;
            $debugRouteRanges = false;
            if ($debugRouteSetter) $msg .= "<strong>Impose Routes</strong>
                        <a href='edit-route-setter' target='edit'> edit imposed routes</a>$eol;";

            // ---------------------------------------------- deal with the each trail to plot itself, initialize to trail id
            $sqlItem = "update $wpdbExtra->lines set routes = trailId where trailId like '$trailId'";
            if ($debugRouteSetter) $msg .= " $sqlItem $eol";
            $items = $wpdbExtra->query($sqlItem);
            if ($debugRouteSetter) $msg .= "I#583 $sqlItem found $items to update $eol";
            if ($items === false) {
                if ($debugRouteSetter) $msg .= "$errorBeg E#584 error assigning trail id to routes, no lins $errorEnd $sqlItem $eol";
                return $msg;
            }
            // ---------------------------------------------- deal with the ihtc corridors
            $sqlTrails = "SELECT trId, ihtc FROM $wpdbExtra->trails ORDER BY trName";
            if ($debugRouteSetter) $msg .= "$eol I#688 $sqlTrails $eol";
            $recTrails = $wpdbExtra->get_resultsA($sqlTrails);
            foreach ($recTrails as $recTrail) {
                $trId = $recTrail["trId"];
                $ihtc = $recTrail["ihtc"];
                $msg .= self::imposeOneRoute($trId, $ihtc);
            }
            // ---------------------------------------------- deal with the on route field
            $sqlOnRoute = "select trId, onRoutes from $wpdbExtra->trails where trId like '$trailId'";
            $onRoutes = $wpdbExtra->get_resultsA($sqlOnRoute);
            foreach ($onRoutes as $onRoute) {
                $trId = $onRoute["trId"];
                $Routes = $onRoute["onRoutes"];
                if (empty($Routes) || is_null($Routes))
                    continue;
                $msg .= self::imposeOneRoute($trId, $Routes);
            }
            // ---------------------------------------------- deal with the on spur of
            $sqlSpurOf = "select trId, spurOf from $wpdbExtra->trails where trId like '$trailId'";
            $spurOfs = $wpdbExtra->get_resultsA($sqlSpurOf);
            foreach ($spurOfs as $spurOf) {
                $trId = $spurOf["trId"];
                $spurOf = $spurOf["spurOf"];
                if (empty($spurOf) || is_null($spurOf))
                    continue;
                $msg .= self::imposeOneRoute($trId, $spurOf);
            }

            // ---------------------------------------------- deal with the route setter list
            // this list has trailId, route, lineNameStart, lineNameEnd
            // it imposes the route on the trailId from lineNameStart to lineNameEnd
            // if lineNameEnd is blank, then lineNameStart is a lineName
            $sqlItem = "SELECT trailId, route, lineNameStart, lineNameEnd FROM $wpdbExtra->route_setter ORDER BY trailId, route";
            $recItems = $wpdbExtra->get_resultsA($sqlItem);
            if ($debugRouteRanges) $msg .= "$eol I#344 $sqlItem $eol";
            foreach ($recItems as $Item) {
                $thisTrailId = $Item["trailId"];
                $RouteToAdd = $Item["route"];
                $lineNameStart = $Item["lineNameStart"];
                $lineNameEnd = $Item["lineNameEnd"];
                if ($debugRouteRanges) $msg .= "I#345  trailId '$thisTrailId', RouteToAdd '$RouteToAdd', lineNameStart '$lineNameStart', lineNameEnd '$lineNameEnd' $eol";
                if (empty($lineNameEnd)) {
                    // just a single line is set to RouteToAdd
                    $sqlUpdate = "UPDATE $wpdbExtra->lines SET routes = CONCAT(routes, ',$RouteToAdd') WHERE lineName = '$lineNameStart' ";
                    if ($debugRouteRanges) $msg .= "I#444 only one line $sqlUpdate $eol";
                    $cnt = $wpdbExtra->query($sqlUpdate);
                    continue;
                }
                $sqlLineStart = "SELECT sequence FROM $wpdbExtra->lines WHERE trailId = '$thisTrailId' AND lineName = '$lineNameStart'  ";
                $SequenceStart = $wpdbExtra->get_var($sqlLineStart);
                if (empty($SequenceStart)) {
                    $msg .= "$errorBeg E#656 no sequence found for line Name $lineNameStart $errorEnd
                                '$sqlLineStart' $eol";
                    throw new Exception($msg);
                }
                $sqlLineEnd = "SELECT sequence FROM $wpdbExtra->lines WHERE trailId = '$thisTrailId' AND lineName = '$lineNameEnd'  ";
                $SequenceEnd = $wpdbExtra->get_var($sqlLineEnd);
                if (empty($SequenceEnd)) {
                    $msg .= "$errorBeg E#586 no sequence found for line Name $lineNameEnd $errorEnd
                                '$sqlLineEnd' $eol";
                    throw new Exception($msg);
                }
                if ($SequenceEnd < $SequenceStart) {
                    $msg .= "$errorBeg E#678 end sequence less than start sequence $errorEnd
                              start  'SequenceStart' - $sqlLineStart,  end 'SequenceEnd' - $sqlLineEnd $eol";
                    throw new Exception($msg);
                }
                if ($debugRouteRanges) $msg .= "I#735 calling imposeOneRoute($thisTrailId, $RouteToAdd, $SequenceStart, $SequenceEnd) $eol $eol";
                $msg .= self::imposeOneRoute($thisTrailId, $RouteToAdd, $SequenceStart, $SequenceEnd);
            } //foreach
            $debugRouteSetter = false;
        } catch (Exception $ex) {
            $msg .= "$errorBeg E#653 top level error impose routes" . $ex->getMessage() . $errorEnd;
        }
        return $msg;
    } // end function ImposeRoutes

    /**
     * imposeOneRoute
     *
     * This private method imposes a single route on a trail by updating the database.
     * It adds the specified route to the lines within the given sequence range.it
     *
     * @param int $trailId The ID of the trail to impose the route on.
     * @param string $RouteToAdd The route to add to the trail.
     * @param int $rtSequenceStart The starting sequence number for the route (default is 0).
     * @param int $rtSequenceEnd The ending sequence number for the route (default is 2000000).
     *
     * @return string Message log of the imposed route process.
     */
    private static function imposeOneRoute($trailId, $RouteToAdd, $rtSequenceStart = 0, $rtSequenceEnd = 2000000, $debugRouteSetter = false)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";

        if ("cando" == $trailId && "gap" == $RouteToAdd) {
            $msg .= "I#371 $trailId added $RouteToAdd  $eol";
            $msg .= rrwFormat::backtrace();
            return $msg;
        }

        $updateCnt = 0;
        /*
        $msg .= rrwUtil::print_r($RouteToAdd, "RouteToAdd");
        $msg .= rrwUtil::print_r($trailId, "trailId");
        $msg .= rrwUtil::print_r($rtSequenceStart, "rtSequenceStart");
        $msg .= rrwUtil::print_r($rtSequenceEnd, "rtSequenceEnd");
     */
        $sqlRoutes = "
            SELECT lineId
            FROM $wpdbExtra->lines
            WHERE trailID = '$trailId'
                AND sequence >= '$rtSequenceStart'
                AND sequence <= '$rtSequenceEnd'
                AND routes NOT LIKE '%$RouteToAdd%'
        ";
        if ($debugRouteSetter) $msg .= " $sqlRoutes $eol";
        $recRoutes = $wpdbExtra->get_resultsA($sqlRoutes);
        foreach ($recRoutes as $Route) {
            $lineId = $Route["lineId"];
            $sqlUpdate = "UPDATE $wpdbExtra->lines SET routes = CONCAT(routes, ',$RouteToAdd') WHERE lineID = '$lineId' ";
            if ($debugRouteSetter) $msg .= "I#452  $sqlUpdate $eol";
            $cnt = $wpdbExtra->query($sqlUpdate);
            $updateCnt = $updateCnt + $cnt;
        }
        if ($updateCnt > 0) {
            // $msg .= "I#445 $updateCnt routes on $trailId added $RouteToAdd  $eol";
        }
        return $msg;
    }
} // end class freewheelingeasy_edit_routes