<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.com
 *
 */
class freewheeling_Edit_Segments
{
    private static $NumFiles;
    public static
    function freewheelingEditSegments($Attributes)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_segments, $rrw_trail_mile;
        error_reporting(E_ALL | E_STRICT);
        try {
            $msg = "";
            $msg .= freeWheeling_edit_setGlobals::setGlobals("freewheelingEditSegments");
            $segmentid = rrwParam::String("segmentid");
            $route = rrwParam::String("route");
            $action = rrwParam::String("action");
            $endicon = rrwParam::String("endicon");
            if ($action == "new") {
                $data = array(
                    "starticon" => $endicon,
                );
                $cnt = $wpdbExtra->insert($rrw_segments, $data);
                $segmentid = $wpdbExtra->insert_id;
            }
            if (empty($segmentid)) {
                $msg .= " $errorBeg E#551 missing the segment ID to be processed $errorEnd";
                return $msg;
            }
            if (empty($route)) {
                $msg .= "looking for route '$route' $eol ";
                $sqlIcons = "select starticon, endicon from $rrw_segments where segmentid = $segmentid";
                $recIcons = $wpdbExtra->get_resultsA($sqlIcons);
                $starticon = $recIcons[0]["starticon"];
                $endicon = $recIcons[0]["endicon"];
                $sqlroute = "select distinct mile_route from $rrw_trail_mile
					where mile_iconName = '$starticon' or mile_iconName = '$endicon'";
                $msg .= "$sqlroute $eol";
                $recRoutes = $wpdbExtra->get_resultsA($sqlroute);
                if ($wpdbExtra->num_rows > 1) {
                    $msg .= "$errorBeg E#284 found $wpdbExtra->num_rows expected one for $starticon or $endicon $errorEnd $sqlroute $eol";
                    $msg .= rrwUtil::print_r($recRoutes, true, "routes found");
                    return $msg;
                }
                if ($wpdbExtra->num_rows < 1) {
                    $msg .= "$errorBeg E#430 found no routes for either $starticon or $endicon $errorEnd";
                    $msg .= rrwUtil::print_r($recRoutes, true, "routes found");
                    return $msg;
                }
                $route = $recRoutes[0]["mile_route"];
                $msg .= "$errorBeg E#285 the recalulate all will need to ne run to fix segment reports. ";
            }
            $msg .= freewheeling_Edit_Segments::editForm($segmentid, $route);

            return $msg;
            /*
            $sql = "select grpid, grpName, grpDescription, linesql from $rrw_trail_routes
							where grpid = '$route'";
            $recGrps = $wpdbExtra->get_resultsA( $sql );
            if ( $wpdbExtra->num_rows != 1 )
                throw new Exception( "$msg $errorBeg E#636 found " . $wpdbExtra->num_rows . " when expecting one $errorEnd" );
            $recGrp = $recGrps[ 0 ];
            $msgTemp = freewheelingeasy_build_segment_report::createSegReportsJson( $recGrp );
            $msg .= $eol;
*/
        } catch (Exception $e) {
            $msg .= $e->getMessage() . $eol;
        }
        return $msg;
    }
    static private
    function editForm($segmentid, $route)
    {
        global $wpdbExtra, $rrw_trail_mile, $rrw_trail_rating_set, $rrw_segments;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        //	$msg .= "requested segment # $segmentid along $route $eol ";
        $action = rrwParam::String("action");
        //		$msg .= "action is $action for $segmentid with $route $eol";
        if ($action == "update") {
            //		$starticon = rrwParam::String( "starticon" );
            //		$endicon = rrwParam::String( "endicon" );
            //			$msg .= "calling reset Client $eol";
            //			$msg .= resetComment( $route, $starticon, $endicon, $segmentid );
        }
        if (freeWheeling_edit_setGlobals::notAllowedToEdit("editForm"))
            throw new Exception("$msg $errorBeg E#602 You do not have permisson to Edit Segments.
								Please <a href='/wp-admin/'>login</a> $errorEnd");
        //	$msg .= "PrintForm: Started $eol";
        $displaySegment = new rrwDisplayTable();

        $msg .= $displaySegment->resetDisplayTable();
        $msg .= $displaySegment->tablename("$rrw_segments");
        $msg .= $displaySegment->KeyName("segmentid");
        $msg .= $displaySegment->setOutputBizHistoryRecord(true, "seg - ");
        $msg .= $displaySegment->columnread("segmentid", "segmentid", 10, 1);
        $msg .= $displaySegment->notInTable("along route ", "route", 40, $route);
        $sqlIconList = "select distinct mile_Iconname as value,
							concat(mile_Iconname, ' (', round(milesalongtrail,1),')')
							display from $rrw_trail_mile where mile_route = '$route'
							order by `milesAlongTrail`";
        $msg .= $displaySegment->DropDownOther("start location", "starticon", 50, $sqlIconList);
        $msg .= $displaySegment->DropDownOther("end location", "endicon", 50, $sqlIconList);
        $msg .= $displaySegment->columns("Title", "title", 69);
        $msg .= $displaySegment->columns("public Information", "descpublic", 700);
        $msg .= $displaySegment->columns("public Source", "publicSource", 250);
        $msg .= $displaySegment->columns("Internal Information", "descinternal", 700);
        $msg .= $displaySegment->columns("Source of Information", "source", 700);
        $msg .= $displaySegment->columns("Next steps", "gap_next_steps", 700);
        $msg .= $displaySegment->columns("DCNR gap number", "Gap_DCNR_Number", 45);
        $msg .= $displaySegment->columns("DCNR top 10", "DCNR_TOP10", 45);
        $msg .= $displaySegment->columns("DCNR incorrect data", "gap_dcnr_meta_correct", 700);
        $msg .= $displaySegment->columns("EPTA trail name", "gap_trail", 69);
        $msg .= $displaySegment->columns("milage", "gap_mileage", 69);
        $msg .= $displaySegment->columns("Connections", "gap_connections", 69);
        $msg .= $displaySegment->columns("Municipality", "gap_municipality", 69);
        $msg .= $displaySegment->columns("county", "gap_county", 69);
        $msg .= $displaySegment->columns("Owner", "gap_ownership", 69);
        $msg .= $displaySegment->columns("Section Manager", "gap_manager", 69);
        $msg .= $displaySegment->columns("Local Champion", "gap_local_champion", 69);
        $msg .= $displaySegment->columns("local Opositon", "gap_opositon", 69);
        $msg .= $displaySegment->columns("Cost Esitimate", "gap_cost", 69);
        $msg .= $displaySegment->columns("match status", "gap_match", 69);
        $selectHighMedLow = "select rating_name 'value', rating_name display
								from $rrw_trail_rating_set order by rating_sort";
        $msg .= $displaySegment->DropDownOther("Location rating", "gap_location", 10, $selectHighMedLow);
        $msg .= $displaySegment->DropDownOther("ownership rating", "gap_ownership", 10, $selectHighMedLow);
        $msg .= $displaySegment->DropDownOther("feasibility rating", "gap_feasibility", 10, $selectHighMedLow);
        $msg .= $displaySegment->DropDownOther("capacity rating", "gap_capacity", 10, $selectHighMedLow);
        $msg .= $displaySegment->DropDownOther("design rating", "gap_design", 10, $selectHighMedLow);
        $msg .= $displaySegment->DropDownOther("construction rating", "gap_construction", 10, $selectHighMedLow);
        $msg .= $displaySegment->DropDownOther(
            "major infrastructure rating",
            "gap_major_infrastructure",
            10,
            $selectHighMedLow
        );
        $msg .= $displaySegment->DropDownOther("environmental rating", "gap_environmental", 10, $selectHighMedLow);
        $msg .= $displaySegment->DropDownOther("road seperation rating", "gap_road_separation", 10, $selectHighMedLow);
        $msg .= $displaySegment->DropDownOther("funding rating", "gap_funding", 10, $selectHighMedLow);
        $msg .= $displaySegment->DropDownOther("impact rating", "gap_impact", 10, $selectHighMedLow);
        $msg .= $displaySegment->DropDownOther("maintenance rating", "gap_maintenance", 10, $selectHighMedLow);
        $msg .= $displaySegment->DropDownOther("support rating", "gap_support", 10, $selectHighMedLow);
        $msg .= $displaySegment->DoAction();
        $msg .= freewheelingeasy_build_segment_report::freewheelingBuildOneSegmentReport($route);
        $sql = "select endicon from $rrw_segments  where segmentid = $segmentid ";
        $endicon = $wpdbExtra->get_var($sql);
        $msg .= "<a href='https://edit.shaw-weil.com/edit-segment/?action=new&route=$route&ensicon=$endicon'
						>Create a New Entryfollowing this one</a> $eol";
        $msg .= $displaySegment->DisplayAllHistory("seg - $segmentid");

        return "$msg $eol";
    }
} // end class
