<?php


class freewheelingEasy_setIconRange
{
    //
    // Adjust the milepost range for amenity points for those trails who have finished distance calculations
    // is invoked after a distance calculation is done
    // ToDo: If the range changes, then rebuild the amenity file.
    //
    public static function setIconRange()
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $debugRange = rrwParam::isDebugMode("debugRange");
        $msg = "";

        if ($debugRange) $msg .= rrwUtil::deltaTimer("start of setIconRange") . $eol;
        $msg .= freeWheeling_edit_setGlobals::setGlobals("freewheelingEasy_setIconRange");

        $milePostBuffer = 6;

        $sqlTrails = "select trId, trName, trMilePostPrefix from $wpdbExtra->trails";

        if ($debugRange) $msg .= "$sqlTrails $eol";

        $recTrails = $wpdbExtra->get_resultsA($sqlTrails);
        foreach ($recTrails as $recTrail) {
            $trailId = $recTrail["trId"];
            $trailName = $recTrail["trName"];
            $sqlWhere = "trailId = '$trailId' ";
            $updatesForThisTrail = 0;

            $sqlLimits = "select max(milepost) maxMile, min(milepost) as minMile from $wpdbExtra->icons
                                where $sqlWhere order by milepost asc";
            $recLimits = $wpdbExtra->get_resultsA($sqlLimits); // find the min and max milepost
            $max = $recLimits[0]["maxMile"] + $milePostBuffer;
            $min = $recLimits[0]["minMile"] - $milePostBuffer; // for the end points


            $sqlIcons = "select iconId, iconName, milepost from $wpdbExtra->icons
                        where $sqlWhere and
                        onMap like '%amen%' order by milepost ";
            $recIcons = $wpdbExtra->get_resultsA($sqlIcons);
            switch ($wpdbExtra->num_rows) {
                case 0:
                    if ($debugRange) $msg .= "$errorBeg E#685 No amenity icons found for $trailId-- $trailName $errorEnd $sqlIcons $eol";
                    break;;
                case 1:
                    $iconId = $recIcons[0]["iconId"];
                    $iconName = $recIcons[0]["iconName"];
                    $sqlUpdateRange = "update $wpdbExtra->icons set mileDisplayStart = $min, mileDisplayEnd = $max where iconId = $iconId";
                    $numUpdated = $wpdbExtra->query($sqlUpdateRange);
                    $updatesForThisTrail += $numUpdated;
                    if ($debugRange) $msg .= self::updateAmenityIfNeeded($numUpdated, $iconId, $iconName, $trailName);
                    break;
                default:
                    // more than one icon
                    $pastSplit = $min;
                    $recIcons[count($recIcons)]["milepost"] = $max + $milePostBuffer; // add a dummy record, to handle the last one
                    if ($debugRange) {
                        $msg .= "milage at end point is " .  $recIcons[count($recIcons) - 2]["milepost"] . $eol;
                        $msg .= "milage at end point is " .  $recIcons[count($recIcons) - 1]["milepost"] . $eol;
                    }
                    for ($ii = 0; $ii < count($recIcons) - 1; $ii++) {
                        $thisIconId = $recIcons[$ii]["iconId"];
                        $thisIconName = $recIcons[$ii]["iconName"];
                        $newSplit = ($recIcons[$ii]["milepost"] + $recIcons[$ii + 1]["milepost"]) / 2;
                        $sqlMax = "update $wpdbExtra->icons set mileDisplayStart = $pastSplit, mileDisplayEnd = $newSplit  where iconId = $thisIconId";       //set max for pervious one
                        $numUpdated = $wpdbExtra->query($sqlMax);
                        $updatesForThisTrail += $numUpdated;
                        $msg .= self::updateAmenityIfNeeded($numUpdated, $thisIconId, $thisIconName, $trailName);
                        $pastSplit = $newSplit;
                    } // end for $ii = 0; $ii < count($recIcons) - 1; $ii++ // looping through the icons for a given trail

            } // end switch ($wpdbExtra->num_rows) // which is for one trail
            if ($debugRange) { // print the results
                $sqlIcons = "select iconId, iconName,mileDisplayStart, mileDisplayEnd, milepost from $wpdbExtra->icons
                        where $sqlWhere and
                        onMap like '%amen%' order by milepost ";
                $recIcons = $wpdbExtra->get_resultsA($sqlIcons);
                $msg .= "<table>";
                $color = rrwFormat::colorSwap();
                foreach ($recIcons as $recIcon) {
                    $color = rrwFormat::colorSwap($color);
                    $milepost = $recIcon["milepost"];
                    $iconName = $recIcon["iconName"];
                    $mileDisplayStart = $recIcon["mileDisplayStart"];
                    $mileDisplayEnd = $recIcon["mileDisplayEnd"];
                    $msg .= rrwFormat::CellRow($color, $iconName,  $mileDisplayStart);
                    $msg .= rrwFormat::CellRow($color, "",  $milepost,);
                    $msg .= rrwFormat::CellRow($color, "",  $mileDisplayEnd);
                } // end foreach
                $msg .= "</table>";
                // break;  // if debugging do only one trail

            }
            if ($updatesForThisTrail > 0) {
                $msg .= "I#512 Updated $updatesForThisTrail amenity ranges for $trailName $eol";
            }
        } // end  foreach ($recTrails as $recTrail) // looping through all the trails
        if ($debugRange) $msg .= rrwUtil::deltaTimer("updating the icon amenity ranges took") . $eol;
        return $msg;
    } // end function setIconRange

    private static function updateAmenityIfNeeded($numUpdated, $pointId, $pointName, $trailName)
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        if (0 == $numUpdated) {
            //$msg .= "I#511 No Change in amenity range of $trailName:#$pointId, $pointName $eol";
        } else {
            $msg .= "E#522 Changed amenity range of $trailName:#$pointId, $pointName $eol";
        }
        return $msg;
    } // end function updateAmenityIfNeeded

} // end class  freewheelingEasy_setIconRange