<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.com
 */
class freewheelingEditTrail
{

    public static function editTrail($attr)
    {
        // uses the table_class to allow editing of the trail table
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        try {
            $msg = "";
            $debugTrail = false;
            $msg .= freeWheeling_edit_setGlobals::setGlobals("edit-trail");
            $viewOnly = rrwParam::Boolean("viewonly");
            if (!$viewOnly)
                freeWheeling_edit_setGlobals::notAllowedToEdit("edit business");
            // -------------------------------------  set up the display_tables
            // $msg .= rrwParam::paramDump($attr, "before call to find Trail Data");
            $trailId = freeWheelParam::trail($attr);
            if (empty($trailId)) {
                $msg .= "$errorBeg E#809 no trailId specified $errorEnd";
                return $msg;
            }
            $task = rrwParam::String("task");

            if ($debugTrail) $msg .= rrwUtil::print_r($_GET, true, "GET");
            if ($debugTrail) $msg .= rrwUtil::print_r($_POST, true, "POST");
            if ($task == "email") {
                $msg .= self::editTrailEmail();
                return $msg;
            }

            $msg .= "<h2>Trail $trailId</h2>";
            $table = new rrwDisplayTable();
            $table->tablename($wpdbExtra->trails);
            $table->keyname("trid");
            $table->sortDefault("trid");
            $table->setOutputBizHistoryRecord(true);
            $table->columnread("Trail Id", "trid", 20, 1);
            $table->columns("Trail Name", "trname", 30);
            $sqlTrailNames = "select trId val, trName display from $wpdbExtra->trails union select '' val, '' display order by display;";
            $table->DropDownOther("Spur/side trail of", "spurOf",  50, $sqlTrailNames);
            $table->columns("Trail milepost prefix", "trMilepostPrefix", 30);
            $table->DropDownSelf("trail Region", "bookVolume");
            $table->DropDownSelf("is on these routes", "onRoutes");
            $table->DropDownSelf("use In Current Draft", "useInCurrentDraft");
            $table->columnUrlOrId("Trail URL landing page", "landingPage", "");
            $table->columnUrlOrId("store page", "storeurl", "");
            $table->columnUrlOrId(".indd source page", "inddFileName", "");
            $table->columns("description from document", "description", 400);
            $table->columns("Merge Sequence ", "mergeSequence", 30);
            $table->columns("Oldest Near run", "trDateNear", 30, "extracted from icon table");
            $table->columnread("oldest Routed Date ", "trDateRouted", 30, 1, "extracted from access table");
            $table->columns("e-mail from document ", "tremailpublic", 69);
            $table->columns("e-mail owners", "tremailprivate", 69);


            $action = rrwParam::String("action");
            if (empty($action))
                $action = "edit";
            $msg .= $table->DoAction();
            $table = new rrwDisplayTable();
            $msg .= $table->DisplayAllHistory($trailId);
            $msg .= "<a href='https:/calculate/?trailId=$trailId'> display mileposts";
        } catch (Exception $ex) {
            $msg .= $ex->getMessage();
        }
        return $msg;
    }
    public static function editTrailEmail()
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $msg .= freewheeling_edit_create_views("findSitesWithoutEmail");
        $sqlTrails = "select distinct trid, trName, tremailpublic, tremailprivate from $wpdbExtra->trailLines where routes like '%epta%'
					and (tremailpublic = '' or tremailprivate ='')
					order by trName";
        //    $msg .= "$sqlTrails $eol";
        $recTrails = $wpdbExtra->get_resultsA($sqlTrails);
        $msg .= "<table>\n";
        $msg .= rrwFormat::HeaderRow("Trail", "Public E-Mail", "Private E-Mail");
        foreach ($recTrails as $recTrail) {
            $trailId = $recTrail["trid"];
            $trName = $recTrail["trName"];
            $tremailpublic = $recTrail["tremailpublic"];
            $tremailprivate = $recTrail["tremailprivate"];
            $nameLink = "<a href='/edit-trail?trailId=$trailId' target='trailedit' >$trName</a>";
            print "$nameLink $eol";
            $msg .= rrwformat::CellRow($nameLink, $tremailpublic, $tremailprivate);
        }
        $msg .= "</table>\n";
        return $msg;
        // more to come
        $sqlEmail = "select tremail from $wpdbExtra->trails where not (treMail = '' or treMail is null) and not trId = 'erie2pgh' ";
        //	$msg .= "$sqlEmail $eol";
        $recEmails = $wpdbExtra->get_resultsA($sqlEmail);
        $msg .= "<strong>Trail group emails</strong> $eol";
        foreach ($recEmails as $recEmail) {
            $email = $recEmail["tremail"];
            $msg .= "<a href='mailto:$email' >$email,</a> ";
        }
        $sqlEmail = "select tremail from $wpdbExtra->trails where not (treMail = '' or treMail is null) and trId = 'erie2pgh'";
        //	$msg .= "$eol $sqlEmail $eol";
        $recEmails = $wpdbExtra->get_resultsA($sqlEmail);
        $msg .= "$eol <strong>interested parties emails</strong> $eol";
        foreach ($recEmails as $recEmail) {
            $email = $recEmail["tremail"];
            $msg .= "<a href='mailto:$email' >$email,</a> ";
        }
        $msg .= $eol;
        return $msg;
    } // end editTrailEmail
} // end class freewheelingEditTrail
