<?php
/*		Freewheeling Easy Mapping Application
 *
 *		A collection of routines for display of trail maps and amenities
 *
 *		copyright Roy R Weil 2019 - https://royweil.com
 *
 */
function edit_service($attrs)
{
    global $eol, $errorBeg, $errorEnd;
    global $wpdbExtra, $rrw_business, $rrw_services, $rrw_codes;
    try {
        $msg = "";
        $msg .= freeWheeling_edit_setGlobals::setGlobals("edit-service");

        error_reporting(E_ALL | E_STRICT);
        ini_set("display_errors", 1);
        if (freeWheeling_edit_setGlobals::notAllowedToEdit("edit_service"))
            throw new Exception("$msg  $errorBeg E#618 edit service is not allowed $errorEnd");
        // -------------------------------------  set up the display_tables
        $svcid = rrwParam::String("svcid");
        if (empty($svcid))
            $svcid = rrwParam::String("bizId");
        if (empty($svcid))
            $svcid = rrwParam::String("serviceid");
        if (empty($svcid)) {
            $lookfor = rrwParam::String("search");
            if (empty($lookfor)) {
                $msg .= freewheeling_amen_search::printSelectionForm();
                return $msg;
            } else {
                $msg .= freewheeling_amen_search::freewheeling_mapping_findName($lookfor);
                $msg .= freewheeling_amen_search::printSelectionForm();
                return $msg;
            }
        }
        $sqlBiz = "select svcname from $rrw_services where svcid = '$svcid'";
        $recBizs = $wpdbExtra->get_results($sqlBiz, ARRAY_A);
        if (0 == $wpdbExtra->num_rows) {
            $msg .= "$errorBeg E#362 did not find a service with the id of '$svcid' $errorEnd";
            return $msg;
        }
        $bizName = $recBizs[0]["svcname"];
        $msg .= "<h1>$bizName - <span style  =' font-size:smaller;'>
			<a href='/edit-biz/?bizId=$svcid'> business</a></span></h1>$eol";
        $tableService = new rrwDisplayTable();
        $tableService->tablename($rrw_services);
        $tableService->sortDefault("svcid");
        $tableService->keyname("svcid");
        $tableService->keyvalue($svcid);
        $tableService->columnread("service Id", "svcid", 30, 1);
        $tableService->columnread("bussiness Name ", "svcName", 60, 1);
        $tableService->columnread("google Services", "google_types", 69, 1);
        $tableService->setOutputBizHistoryRecord(true);
        $sqlAmen = "select code, codeDescription from $rrw_codes
					where (codetype = 'establishment')
					and codeSort < 900 order by codesort ";
        $recAmens = $wpdbExtra->get_resultsA($sqlAmen);
        $codePrev = "not yet";
        foreach ($recAmens as $recAmen) {
            $code = $recAmen["code"];
            if ($codePrev == $code)
                continue;
            $codePrev = $code;
            if (current_user_can("edit_posts")) {
                $tableService->checkBoxOneOrZero($recAmen["codeDescription"], $code);
                $style = "";
            } else {
                if (strcmp($code, "1") == 0)
                    $style = "style='color=green'";
                else
                    $style = "";
                $tableService->columns("<span $style >" . $recAmen["codeDescription"] . "</span>", $code, 10, 1);
            }
        }
        //  ------------------------------------ setup done, get to processing
        $msg .= $tableService->DoAction();
        $msg .= freewheeling_edit_create_views("after edit biz");
        $msg .= "<h1>$bizName - <span style  =' font-size:smaller;'>
			<a href='/edit-biz/?bizId=$svcid'> business</a></span></h1>$eol";
    } catch (Exception $ex) {
        $msg .= $ex->getMessage();
    }
    return $msg;
} //  edit_service( $attrs )
