<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.com
 *
 */
class freewheelingeasy_edit_update_database
{
    //* update the database based on the _get parameters
    // only allowed from certain addresses
    // used primarily by the wordpress macro that extracts data from the html trail file
    public static
    function edit_update_database($attributes)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_force_access;
        global $freeWheelingEasy_ipHome;
        error_reporting( E_ALL);
        ini_set("display_errors", true);
        $msg = "";
        $msg .= freeWheeling_edit_setGlobals::setGlobals("freewheelingeasy_edit_update_database");
        $msg .= rrwUtil::DisplayTimeDiff("");
        $ip = $_SERVER['REMOTE_ADDR'];
        if ($ip != $freeWheelingEasy_ipHome) {
            $msg .= "$errorBeg E#310 looking for local ip found $ip $errorEnd ";
            return $msg;
        }
        $task = rrwParam::String("task", $attributes);
        $table = rrwParam::String("table", $attributes);
        $field = rrwParam::String("field", $attributes);
        $newValue = rrwParam::String("newValue", $attributes);
        $keyField = rrwParam::String("keyField", $attributes);
        $keyValue = rrwParam::String("keyValue", $attributes);
        $sql = rrwParam::String("sql");
        $max2check = rrwParam::Number("max2check");
        if (!empty($sql))
            $debugUpdate = true;
        else
            $debugUpdate = true;
        if ($debugUpdate) $msg .= " $table:$keyValue - $field = $newValue";

        if (empty($table) || empty($field) || strlen($newValue) < 1 || empty($keyField) || empty($keyValue)) {
            $msg .= "$errorBeg E#660 missing parameters $errorEnd";
            $msg .= "task is $task $eol";
            $msg .= rrwUtil::print_r($_GET, true, "input parameters$errorEnd");
            return $msg;
        }
        switch ($table) {
            case "urlList":
                if (strpos($newValue, "www.w3.org") !== false) {
                    $msg .= "$newValue was ignored because all files have it";
                    return $msg;
                }

                $table = $wpdbExtra->prefix . "2rrw_urlList";
                $data = array(
                    $field => $newValue,
                    $keyField => $keyValue
                );
                $key = "";
                $cnt = $wpdbExtra->replace($table, $data);
                break;
            case "icons":
            case "lines":
            case "regions":
            case "trails":
                $table = "00rrw_$table";
                $table = $wpdbExtra->prefix . $table;
                $data = array($field => $newValue);
                $key = array($keyField => $keyValue);
                $cnt = $wpdbExtra->update($table, $data, $key);
                break;
            case "dino":
                $table = "pillowan_wp541.wpprrj_00rrwdinos";
                $data = array($field => $newValue);
                $key = array($keyField => $keyValue);
                $cnt = $wpdbExtra->update($table, $data, $key);
                break;
            case "force_access":
                $table = $rrw_force_access;
                $data = array($field => $newValue);
                $key = array($keyField => $keyValue);
                $cnt = 0;
                foreach (array($rrw_force_access, $wpdbExtra->business, $wpdbExtra->businessServices) as $table) {
                    $cnt += $wpdbExtra->update($table, $data, $key);
                }
                break;
            default:
                return "$msg $errorBeg E#468 trying to update an unknown table '$table' $errorEnd";
        }

        if ($debugUpdate) {
            $msg .= rrwUtil::print_r($data, true, "data to update");
            $msg .= rrwUtil::print_r($key, true, "key for update");
        }
        $msg .= insertIntoHistory($keyValue, "$table:$keyValue:$field = $newValue");
        if ($cnt === false) {
            $msg .= "$errorBeg E#592 the query returned false $errorEnd";
        } elseif (0 == $cnt) {
            $msg .= "$errorBeg E#591 the query updated zero rows $errorEnd";
        } else {
            $msg .= "success update of $cnt rows $table:$keyValue:$field = $newValue";
        }
        $msg .= rrwUtil::DisplayTimeDiff(" for $max2check items");
        return $msg;
    } // end function


} // end class
