<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.com
 *
 */
class freeWheelingEmail
{
    public static function milageCheck($attributes)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        global $freewheeling_prebuilt_dire;
        try {
            $debugCheck = rrwParam::String("debug", $attributes);
            $debugMiles = rrwParam::String("debugmiles", $attributes);
            $deugStartEnd = rrwParam::String("deugetartend", $attributes);
            $msg = "";
            // https://www.a2hosting.com/kb/installable-applications/optimization-and-configuration/wordpress2/sending-e-mail-in-wordpress
            $msg .= freeWheeling_edit_setGlobals::setGlobals("milageCheck");
            $trailId = freeWheelParam::trail($attributes);
            $emailFile = rrwParam::String("file", $attributes);
            $mailIt = rrwParam::String("mailit", $attributes);

            if (empty($emailFile))
                $emailFile = "checkMiles1.txt";
            if ($debugCheck) {
                if ($mailIt)
                    $msg .= "Emailing ";
                else
                    $msg .= "Showing ";
                $msg .= "Emailing $trailId with message file = $emailFile $eol ";
            }
            if (empty($trailId)) {
                $msg .= "<form >";
                $msg .= freewheelingEasy_kml_trailList::trailSelectionBox(
                    true,
                    "Create an email for the selected trail"
                );
                $msg .= "</form>";
                return $msg;
            }
            $msg .= "<a href='https://edit.shaw-weil.com/detail-mapping/?trailId=$trailId'
                target = 'map' > map</a>$eol
        ----------------------------------------- $eol";
            $lengthSurface = freeWheelingBuildBook::getLengthSurfaceLine($trailId);
            $msg .= "lengthSurface - $lengthSurface $eol";
            return $msg;
            while ("," == substr($type, -1)) {
                $miletypes = substr($miletypes, 0, strlen($miletypes) - 2); // remove trail comma
                $miletypes = trim($miletypes);
            }
            $recTrail["miletypes"] = "$miletypes \n";
            if ($debugCheck) $msg .= rrwUtil::print_r($recTrail, true, "miles type");
            list($msgTemp, $email) = buildEmail($emailFile, $recTrail);
            $htmlemail = str_replace("\n", $eol, $email);
            if (strcmp("Subject", substr($email, 0, 7)) != 0) {
                $msg .= "$errorBeg E#272 Missing subject $errorEnd";
                $subject = "missing";
            } else {
                $iiLineEnd = strpos($email, "\n");
                $subject = substr($email, 8, $iiLineEnd - 8);
                $email = substr($email, $iiLineEnd);
            }
            $emailpublic = $recTrail["tremailpublic"];
            $emailprivate = $recTrail["tremailprivate"];
            $emailto = processemilto("", trim($emailpublic));
            $emailto = processemilto($emailto, trim($emailprivate));
            $headers = 'From: webmaster@edit.pgherie.org' . "\r\n" .
                'Reply-To: webmaster@edit.pgherie.org' . "\r\n" .
                'CC: milagecheck@shaw-weil.com';
            $query = parse_url($_SERVER['REQUEST_URI'], PHP_URL_QUERY);
            $sendreqest = "<a href='?$query&mailit=please'>looks good, mail it</a>$eol
			To: $emailto $eol
			Subject: $subject $eol";
            if (!empty($mailit)) {
                $resultOfMail = wp_mail("locCheck@royweil.com", $subject, $email, $headers);
                if ($resultOfMail) {
                    $sendreqest .= "mail  accepted for delivery";
                    $msg .= insertIntoHistory($trailId, "mail  accepted for delivery $emailto");
                } else {
                    $sendreqest .= "$errorBeg E#286 Mail rejected for delivery $emailto $errorEnd";
                    //          $msg .= insertIntoHistory( $trailId, "760 Mail rejected for delivery" );
                }
            }
            if ($debugCheck) {
                $msg .= "mailserver_url = get_option( 'mailserver_url' );" . get_option('mailserver_url') . $eol;
                $msg .= "SMTP_HOST " . SMTP_HOST . $eol;
                $msg .= "SMTP_FROMNAME " . SMTP_FROMNAME . $eol;
                $msg .= "SMTP_PASSWORD " . SMTP_PASSWORD . $eol;
            }
            $msg .= "$msgTemp $htmlemail $sendreqest $eol History of sent emails";
            $table = new rrwDisplayTable();
            $msg .= $table->DisplayAllHistory($trailId);
        } catch (Exception $ex) {
            $msg .= "$errorBeg E#589  bottom of milageCheck " . $ex->getMessage() . $errorEnd;
        }
        return $msg;
    } // end of milageCheck

    function processemilto($emailto, $newemail)
    {
        if (strpos($newemail, "@") === false)
            return $emailto;
        if (empty($emailto))
            return $newemail;
        return ("$emailto, $newemail");
    }
    function buildEmail($textOrFile, $replaces, $headers = "")
    {
        global $eol, $errorBeg, $errorEnd;
        global $freewheeling_prebuilt_dire;
        $msg = "";
        //$msg .= rrwUtil::print_r( $replaces, true, "information to be replaced " );
        if (strlen($textOrFile) < 50) {
            $text = file_get_contents(__DIR__ . "/email-templates/$textOrFile");
        } else {
            $text = $textOrFile;
        }
        //   $msg .= rrwUtil::print_r( $replaces, true, "replaces" );
        foreach ($replaces as $key => $value) {
            $key = strtolower($key);
            $text = str_replace("%$key%", $value, $text);
        }
        $result = array(
            "msg" => $msg,
            "email" => $text
        );
        if (!empty($headers)) {
            $endLine = strpos($text, "\n");
            $line = substr($text, 0, $endLine);
            if (substr($line, 0, 8) != "Subject:") {
                return "$msg $errorBeg the $line is missing 'Subject:' at the beginning $errorEnd";
            } // send the mail
        }
        //  $msg .= rrwUtil::print_r( $result, true, "result" );
        return array($msg, $text);
        return $result;
    }
} // end of class
