<?php
/*Freewheeling Easy Mapping Application
 *
 *		A collection of routines for display of trail maps and amenities
 *
 *		copyright Roy R Weil 2019 - https://royweil.com
 *
 */
/*
Plugin Name: FreeWheelingEasy Edit
Plugin URI:  https://plugins.RoyWeil.com/freewheeling-easy-edit/
Description: Allow editing of businesses and services
Author:      Roy Weil
Author URI:  https://RoyWeil.com
Donate URI: https://plugins.royweil.com/donate
Requires at least: 6.0
Tested up to: 4.9.6.0.1
Stable tag: 2.2.71	// change in .patch indicates a data, but not the code
License: private
Version: 10.2.59
Text Domain: freewheelingeasy-edit
Domain Path: /lang
*/
error_reporting(E_ALL);
ini_set("display_error", true);
global $eol, $errorBeg, $errorEnd;
$eol = "<br />";
$debugStrayCharacters = false;
if ($debugStrayCharacters) print "E#615 before any includes $eol";
// the following are in the ww-include directory
require_once "freewheelingeasy-wpdpExtra.php";
require_once "display_tables_class.php";
require_once "plugin_update_check.php";
require_once "html_parser.php";
require_once "rrwFormat.php";
require_once "rrw_util_inc.php";
if ($debugStrayCharacters) print "$eol E#594 freewheeling edit.php - before rrw_util_inc $eol";
require_once "rrw_util_inc.php";    // common set of utility functions
if ($debugStrayCharacters) print "$eol E#478 freewheeling edit.php - after rrw_util_inc; $eol";
require_once "rrwParam.php";         // functions to get mapping parameters from the url
if ($debugStrayCharacters) print "$eol E#704 freewheeling edit.php - after the parm, ww-include $eol";
$MyUpdateChecker = new PluginUpdateChecker_2_0(
    "https://pluginserver.royweil.com/freewheeling-edit.php",
    __FILE__,
    "freewheeling-edit",
    1
);
require_once "includes-edit/lineTable.php";
require_once "includes-edit/kmlCommon.php";
require_once "includes-edit/shove-distance_inc.php";

//require_once ABSPATH .  "wp_content/plugins/freewheeling-map/constants.php";
// in this directory
require_once "build-amenities.php";
require_once "build-book.php";
require_once "build-charts.php";
require_once "build-region-buffer.php";
require_once "build-trailHeads-display.php";
require_once "build-website.php";
require_once "edit-amensearch.php";
require_once "edit-accesses-business-build.php";
if ($debugStrayCharacters) print "E#648 freewheeling edit.php - middle 3 edit includes $eol";
require_once "build-segment-report.php";
require_once "build-surface.php";
require_once 'edit-calculateMP.php';
if ($debugStrayCharacters) print "E#657 freewheeling edit.php - middle 1 edit includes $eol";
require_once "edit-change-biz-Id.php";
require_once "edit-biz.php";
require_once "edit-bizRoute.php";
require_once "edit-comment.php";
require_once "edit-counts.php";
require_once "edit-distance.php";
require_once "freewheelingeasy-edit-googlevsdatabase.php";
if ($debugStrayCharacters) print "E#658 freewheeling edit.php - middle 2 edit includes $eol";
require_once 'edit-google-costs.php';
require_once 'edit-google-update.php';
require_once "edit-html.php";
require_once "edit-icon.php";
require_once "edit-line.php";
require_once "edit-landing.php";
require_once "edit-maketoc.php";
require_once "freewheelingeasy-edit-product.php";
require_once 'edit-segments.php';
require_once "freewheelingeasy-edit-service.php";
require_once "edit-trail.php";
require_once "freewheelingeasy-edit-update-database.php";
require_once "edit-extract-data-from-html.php";
require_once 'freewheelingeasy-email.php';
if ($debugStrayCharacters) print "E#599 freewheeling edit.php - after edit,before kml includes $eol";
require_once "kml-clean.php";
require_once "edit-route-setter.php";
require_once "edit-seticonrange.php";
require_once "kml-bookdates.php";
require_once "kml-clean.php";
require_once "kml-create-kml.php";
require_once "kml-image2icon.php";
require_once "kml-merge.php";
require_once "kml-mileage-icon-to-line";
// require_once "kml-points.php";           // no longer used
require_once "kml-text-lines.php";
require_once "kml-text-points.php";
require_once "kml-read.php";
require_once "kml-trailList.php";
require_once "map-formats.php";
require_once "milestone.php";
require_once "mural.php";
// the following are in freewheel-map directory
$freewheel_map = "/home/pillowan/www-royweil-testsite/wp-content/plugins/freewheeling-map";
require_once "$freewheel_map/constants.php";
require_once "$freewheel_map/map-api-2025.php";
require_once "$freewheel_map/map-write.php";
if ($debugStrayCharacters) print "E#564 freewheeling edit.php - after all the includes $eol";
function freewheelingeasy_set_userOptions()
{
    global $eol, $errorBeg, $errorEnd;
    $msg = "";
    $doMakeHtml = false;
    $pastAmen = get_user_option("rrw_amenityIrail");
    $thisAmen = $pastAmen;
    $thisAmenPlus = str_replace(" ", "+", $thisAmen);
    $msg .= "<!--Current amenity trail is $thisAmen = $pastAmen -->$eol";
    if (isset($_POST["amenityTrail"])) {
        $thisAmen = $_POST["amenityTrail"];
        $thisAmenPlus = str_replace(" ", "+", $thisAmen);
        $userId = get_current_user_id();
        if ($userId < 1) {
            $msg .= "$errorBeg E#708 found user id of $userId $errorEnd";
            return $msg;
        }
        update_user_option(get_current_user_id(), "rrw_amenityIrail", $thisAmen);
        //		$msg .= "amenities:  $pastAmen != $thisAmen $eol";
        if ($pastAmen != $thisAmen) {
            $doMakeHtml = true;
        }
    }
    $pastDays = get_user_option(freeWheel::updateOlderBusinesses);
    if (isset($_POST["days"])) {
        $sinceDays = $_POST["days"];
        $pastDays = get_user_option(freeWheel::updateOlderBusinesses);
        $results = update_user_option(get_current_user_id(), freeWheel::updateOlderBusinesses, $sinceDays);
        //		$msg .= " - days test: $pastDays != $sinceDays $eol";
        if ($pastDays != $sinceDays)
            $doMakeHtml = true;
    }
    $msg .= "
<form method='post' >
<table><tr><td>
Number of days for a Business Listing to be flagged as not current
        (i.e. with red edit icon)?
<input type='text' name='days' id='days' value='$pastDays' />
</td><td valign='top' >
<input type='submit' value='submit' />
</td></tr></table>
</form>
";
    return $msg;
}
function updateDataField($placeId, $field, $value, $user = '')
{
    global $wpdbExtra;
    global $eol, $errorBeg, $errorEnd;
    $debugDate = false;
    $msg = "";
    $type = strtolower(substr($field, 0, 3));
    switch ($type) {
        case "biz":
        case "goo": //googleScanned,mapurl, rating
        case "tri": // tripadvisor
        case "fac": //facebook
        case "yel": // yelp
        case "met": //meters to trail
        case "tra": //trail lat,lng, mile, biz routine
            $table = $wpdbExtra->business;
            $key = "bizId";
            break;
        case "ico":
        case "onm": // onMap
        case "ist": // is trailHead
            $table = $wpdbExtra->business;
            $key = "iconId";
            break;
        default:
            throw new Exception("$errorBeg E#676 not recognized field name
                    trying to update $placeId - $field to $value
                    $errorEnd  " . rrwFormat::backtrace());
    }
    $sql = "select $field from $table where $key = '$placeId'";
    $oldValue = $wpdbExtra->get_var($sql);
    if ($wpdbExtra->num_rows != 1)
        throw new Exception("$errorBeg E#695 unknown placeId trying to update $placeId - $field to $value
                    $errorEnd  " . rrwFormat::backtrace());
    $comment = "$field : $oldValue --> $value ";
    if ($oldValue != $value) {
        $updateData = array($field => $value);
        $where = array($key => $placeId);
        $wpdbExtra->update($table, $updateData, $where);
    }
    if (empty($user))
        $user = username();
    $updateData = array(
        'hisComment' => $comment,
        'hisUpdater' => $user,
        'hisId' => $placeId,
    );
    $wpdbExtra->insert($wpdbExtra->history, $updateData);
    return $msg;
}
function findTrailIdGet($attr)
{
    $debugGet = false;
    $msg = "";
    $msg .= freeWheeling_edit_setGlobals::setGlobals("findTrailIdGet");
    // ^^^^ msg not displayed.
    $trailSearch = rrwParam::String("trailsearch", $attr);
    $trailSearch = str_replace("\&#39;", "", $trailSearch);
    if ($debugGet)
        write_log(htmlspecialchars("Debug findTrailIdGet $trailSearch <br />", ENT_QUOTES));
    $trailInfo = freeWheeling_edit_setGlobals::getTrailInfo($trailSearch);
    $trailInfoJson = json_encode($trailInfo);
    write_log($msg);
    return $trailInfoJson;
}
function username($user = "")
{
    if (empty($user)) {
        $current_user = wp_get_current_user();
        if (!$current_user->exists()) {
            if (strpos($user, "oogle") == 1)
                $userTemp = "Google";
            else
                $userTemp = "Unknown";
        } else
            $userTemp = $current_user->display_name;
    } else {
        $userTemp = $user;
    }
    return $userTemp;
}
function insertIntoHistory($place_id, $comment, $user = "")
{
    // inserts data in to the history table
    // does ot change the business record
    global $wpdbExtra;
    global $eol, $errorBeg, $errorEnd;
    $debugDate = rrwParam::isDebugMode("debugDate");
    $msg = "";
    $msg .= freeWheeling_edit_setGlobals::setGlobals("insertIntoHistory");
    if ($debugDate) $msg .= "I#314 insertIntoHistory: $place_id, $comment, user = '$user' $eol";
    // look for a date in the comment
    $date = ""; //found date in the comment
    preg_match_all('/\d{2}\/\d{4}/', $comment, $matches);
    if (count($matches) >  0) {
        // found a two digit date
        $date = $matches[0];
    } else {
        // no two digit date, try a one digit date}
        preg_match_all('/\d{1}\/\d{4}/', $comment, $matches);
        if (count($matches) >  0) {
            // found a one digit date
            $date = "0" . $matches[0]; // prepend a zero to the one digit date
        }
        if ($debugDate) $msg .= "insertIntoHistory:date one char " . rrwUtil::print_r($date, true) . $eol;
    }
    if (empty($date)) { // no date found
        if ($debugDate) $msg .= "insertIntoHistory:date not found in comment '$comment' $eol";
        $commentDate = date("Y-n-j H:i:s"); // use current date; // no date in the comment
    } else {
        $commentDate = $date;
    }
    if (empty(trim($comment))) {
        return $msg;
    }
    if (empty($user)) // if user name not passed in, get it
        $user = username(); // get the current user
    $data2Update = array(
        'hisComment' => $comment,
        'hisUpdater' => $user,
        'hisId' => $place_id,
        'hisDate' => $commentDate,
    );
    if ($debugDate) $msg .= rrwUtil::print_r($data2Update, true, "Data to be inserted int history") . $eol;
    $cntUpdate = $wpdbExtra->insert($wpdbExtra->history, $data2Update);
    $msg .= freewheelingeasy_calculateMP::Update_BizVerifyDisplay($place_id);
    if (strcmp(substr($comment, 0, 8), "bizUsed:") == 0) {
        $bizVerify = trim(substr($comment, 8));
        if (strpos($comment, "/") === false)
            $nowDate = date("m/Y");
        else
            $nowDate = "";
        $sqlVerified = "update $wpdbExtra->business set BizVerifyDisplay =
							' $bizVerify $nowDate' where bizId = '$place_id' ";
        $msg .= $wpdbExtra->query($sqlVerified);
    }
    return $msg;
}
function freewheeling_edit_create_views($whereFrom = "", $force = false)
{
    // 	only executed when one or more of the tables change format
    return freeWheelingClean::updateViewTables($whereFrom, $force);
}
add_shortcode('freewheeling-build-segment-dump', array("freewheelingeasy_build_segment_report", "dumpSegmentData"));
add_shortcode('freewheeling-build-segment-report', array("freewheelingeasy_build_segment_report", "freewheelingBuildSegmentReport"));
add_shortcode('freewheeling-build-surface', array("freewheelingeasy_surface", "buildSurface"));
add_shortcode('freewheeling-edit-textarea', array("freewheeling_textarea", "makeTextArea"));
add_shortcode("freewheeling_build_website", array("freewheeling_build_website", "buildWebsiteFromUpload"));
add_shortcode('freewheeling-display-milestone', array('freewheelingeasy_milestones', 'createMilestoneDisplay'));
add_shortcode('freewheeling-edit-access', array("freewheelingeasy_build_businessAccess", "editAccess"));
add_shortcode('freewheeling-edit-amensearch', array('freewheeling_amen_search', 'amensearch'));
add_shortcode('freewheeling-edit-amenpush', array('freewheeling_amen_search', 'pushDevToProduction'));
add_shortcode("Freewheeling-edit-bikeshop-search", array("freewheelingeasy_google", "searchForBikeShops"));
add_shortcode('freewheeling-edit-businessaccess', array('freewheelingeasy_build_businessAccess', 'freewheelingeasyBuildBusinessAccess'));
add_shortcode('freewheeling-edit-businesslist', 'businesslist');
add_shortcode('freewheeling-edit-change-bizId', array("freewheeling_change_bizId", 'change_bizId'));
add_shortcode('freewheeling-edit-charts', array("FreewheelingBuildMileageChart", "buildManyCharts"));
add_shortcode('freewheeling-edit-dino', array("freewheelingeasy_kml_ParkingTxtFiles", 'UpdateDinomiteFiles'));
add_shortcode("freewheeling-edit-delete-bizid", array("freewheeling_change_bizId", "deleteBizId"));
add_shortcode('freewheeling-edit-distance', array("FreewheelingEditDistance", 'distanceManual'));
add_shortcode('freewheeling-edit-editbiz', array('freewheelingeasy_editbiz', 'editbiz'));
add_shortcode('freewheeling-edit-editbizroute', array('freewheelingeasy_edit_bizroute', 'editRoutes'));
add_shortcode('freewheeling-edit-edit-html', array('freewheelingeasy_edit_html', 'EditHtml'));
add_shortcode('freewheeling-edit-editicon', array('freewheelingeasy_edit_icon', 'freewheelingEditIcon'));
add_shortcode('freewheeling-edit-edit-service', 'edit_service');
add_shortcode('freewheeling-edit-edittrail', array('freewheelingEditTrail', 'editTrail'));
add_shortcode('freewheeling-edit-editcomment', 'editcomment');
add_shortcode('freewheeling-edit-counts', array("freewheelingEasyCounts", "counts"));
add_shortcode('freewheeling-edit-emailmileage', array("freeWheelingEmail", "milageCheck"));
add_shortcode('freewheeling-edit-googlecosts', array("freewheeling_Google_Costs", "googleCostPage"));
add_shortcode('freewheeling-edit_impose_routes', array('freewheelingeasy_edit_routes', 'ImposeRoutes'));
add_shortcode('freewheeling-edit-editline', array("freewheelingeasy_edit_line", "editline"));
add_shortcode('freewheeling-edit-kmlClean', array('freeWheelingClean', 'kmlClean'));
add_shortcode('freewheeling-edit-makeAmenity', array('freewheelingeasy_make_amenities', 'makeAmenity'));
add_shortcode('freewheeling-edit-makeTrailHeads', array('freewheel_trailHeads', 'gatherPushTrailHead'));
add_shortcode('freewheeling-edit-makeHtml', 'freewheeling_mapping_makeHtml');
add_shortcode('freewheeling-edit-milestone', array('freewheelingeasy_milestones', 'edit'));
add_shortcode('freewheeling-display-milestone', array('freewheelingeasy_milestones', 'createMilestoneDisplay'));
add_shortcode('freewheeling-edit-product', array('freewheelingeasy_edit_product', 'edit'));
add_shortcode('freewheeling-edit-findTrailId', "findTrailIdGet");
add_shortcode('freewheeling-edit_route_setter', array('freewheelingeasy_edit_routes', 'editRoutes'));
add_shortcode('freewheeling-edit-segments', array("freewheeling_Edit_Segments", "freewheelingEditSegments"));
add_shortcode('freewheeling-edit-googlevsdatabase', array("freewheelingeasy_googlVs_Database", "googleVsDatabase"));
add_shortcode('freewheeling-landing_list', array("freewheelingeasy_land", "CreatePageOfTrailLinks"));
add_shortcode('freewheeling-landing_detail', array("freewheelingeasy_land", "detail"));
add_shortcode('freewheeling-edit-calculate', array('freewheelingeasy_calculateMP', 'calculateMilepost'));
add_shortcode('freewheeling-edit-setcookie', "freewheelingeasy_set_userOptions");
add_shortcode('freewheeling-edit-setIconRange', array('freewheelingEasy_setIconRange', 'setIconRange'));
add_shortcode('freewheeling-edit-update-database', array('freewheelingeasy_edit_update_database', 'edit_update_database'));
add_shortcode('freewheeling-edit-updategoogle', array('freeWheelingGoogleUpdate', 'googleUpdateManual'));
add_shortcode('freewheeling-kml-build-list', array('freewheelingEasy_kml_trailList', 'kml_trailList'));
add_shortcode('freewheeling-kml-read', array('freewheeling_kml_read', 'doKmlRead'));
add_shortcode('freewheeling-kml-merge', array('freewheelingeasy_kml_merge', 'mergeManual'));
add_shortcode('freewheeling-easy-kml-mileage-icon-to-line', 'mileageIcon2Line');
add_shortcode('freewheelingeasy-kml-create-text', array('createLineText', 'createZZDataFiles'));
add_shortcode('freewheelingeasy-kml-list-kmls', array('Freewheelingeasy_kml_create', 'listKMLs'));
add_shortcode('freewheelingeasy-kml-image', 'milepostPictureToPoint');
add_shortcode('freewheelingeasy_kml_bookdate', array("freewheelingeasy_kml_book_date", "bookDate"));
add_shortcode('freewheeling-easy-map-makeChart', array("FreewheelingBuildMileageChart", "makeChartSelection"));
add_shortcode("freewheeling-mural", array("Mural", "parseHtml"));
add_shortcode("freewheeling-webStatus", array("freewheelingEasy_fix_Class", "webStatus"));
