<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.com

 * function trimTo( $lookFor )
 *		edit self::$buffer and remove all characters before 'lookFor'
 *		throw error if lookFor not found
 * function trimPast( $lookFor )
 *		edit self::$buffer and remove all characters before 'lookFor' and lookFor as well
 *		throw error if lookFor not found
 * function extractTo( $lookFor )
 *		returns from the start of buffer,upto, not including, lookFor
 *		throw error if lookFor not found
 *		returns array($msgTemp, found string)
 * function removeTags( $text )
 * 		removes matching tags from $text
 *		returns ($msg, cleaned out $text)
 * function findHref($text)
 *		returns an array of URLs associated with a href
 *		return ($msg, array of URLs);
 *function findHTTPs(self::$buffer, *$msg)
 *		returns an array of URLs in the buffer
 * function extractToEmptyLine( )
 *		===  rrwParse::extract("\n\n");
 * function recursiveDirectoryIterator ($directory, $files
 *		return a list of all files under directory
 */

class rrwParser
{
    public String $buffer = "";

    public function __construct($buffer = "")
    {
        $this->buffer = $buffer;
    }

    public function fetchURLcontents($sourceFile)
    {
        global $eol;
        if (true) $msg = "I#976 in fetchURLcontents($sourceFile) $eol";
        $this->buffer = rrwUtil::fetchURLcontents($sourceFile);
        $msg .= "I#970 " . strlen($this->buffer) . " characters read from $sourceFile $eol";

        return $msg;
    }

    public function trimTo($lookFor)
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        try {
            if (empty($lookFor))
                throw new Exception("E#973 lookFor is empty in trimTo() $eol");
            $iiLook = strpos($this->buffer, $lookFor);
            if ($iiLook === false)
                throw new Exception("$msg $errorBeg E#971 did not find $lookFor in buffer $errorEnd");
            $this->buffer = substr($this->buffer, $iiLook);
            //$msg .= "trimmed to $lookFor $eol";
        } catch (Exception $e) {
            $msg .= $this->printSomeBuffer("E#972  at bottom of trimTo($lookFor) $eol") . $e->getMessage() . $eol;
        }
        return $msg;
    }
    public function trimPast($lookFor)
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        try {
            $msg .= $this->trimTo($lookFor);
            $this->buffer = substr($this->buffer, strlen($lookFor));
        } catch (Exception $e) {
            $msg .= $this->printSomeBuffer("E#982  at bottom of trimPast($lookFor) $eol") . $e->getMessage() . $eol;
        }
        return $msg;
    }
    public  function extractTo($lookFor, &$extracted)
    {
        $msg = "";
        try {
            global $eol;
            $msg = "";
            $debug = false;
            if ($debug) {
                $msg .= "I#976 in extractTo($lookFor) buffer has " . strlen($this->buffer) . " characters $eol";
                $msg .= $this->printSomeBuffer("at start of extractTo($lookFor)", 200);
            }
            $iiLook = strpos($this->buffer, $lookFor);
            if ($iiLook === false)
                throw new Exception("$msg  E#936 did not find $lookFor in buffer $eol");
            $extracted = substr($this->buffer, 0, $iiLook);
            $msg .= $this->trimPast($lookFor);
        } catch (Exception $e) {
            $msg .= $this->printSomeBuffer("E#982  at bottom of extractTo($lookFor) $eol") . $e->getMessage() . $eol;
        }
        if ($debug) {
            $msg .= "I#976 in extractTo($lookFor) found " . strlen($extracted) . " characters '$extracted' $eol";
            $msg .= $this->printSomeBuffer("after extractTo($lookFor)", 200);
        }
        return $msg;
    }
    public function extractPast($lookFor, &$extracted)
    {
        $msg = "";
        try {
            global $eol;
            $msg = "";
            $debug = false;
            if ($debug) {
                $lookForDisplay = htmlspecialchars($lookFor);
                $msg .= "I#976 in extractPast($lookForDisplay) buffer has " . strlen($this->buffer) . " characters $eol";
                $msg .= $this->printSomeBuffer("at start of extractPast($lookForDisplay)", 200);
            }
            $iiLook = strpos($this->buffer, $lookFor);
            if ($iiLook === false)
                throw new Exception("$msg  E#936 did not find $lookFor in buffer $eol");
            $extracted = substr($this->buffer, 0, $iiLook + strlen($lookFor));
            $msg .= $this->trimPast($lookFor);
        } catch (Exception $e) {
            $msg .= $this->printSomeBuffer("E#982  at bottom of extractPast($lookFor) $eol") . $e->getMessage() . $eol;
        }
        if ($debug) {
            $extractedDisplay = htmlspecialchars($extracted);
            $msg .= "I#977 in extractPast($lookForDisplay) found " . strlen($extracted) . " characters '$extractedDisplay' $eol";
            $msg .= $this->printSomeBuffer("after extractPast($lookForDisplay)", 200);
        }
        return $msg;
    }

    public function trimParagraph(&$paragraph)
    {
        global $eol;
        $msg = "";
        try {
            if (strncmp($this->buffer, "<p", 2) != 0) {
                $msg = $this->printSomeBuffer("E#937 buffer does not start with p in getParagraph() $eol");
                throw new Exception($msg);
            }
            $msg .= $this->extractPast("</p>", $paragraph);
            $paragraph .=  "</p>"; // put back the </p> at end

        } catch (Exception $e) {
            $msg .= $this->printSomeBuffer("E#982 exception at bottom of getParagraph() $eol") . $e->getMessage() . $eol;
        }
        return $msg;
    } // end getParagraph

    public  function trimPastEmptyLine()
    {
        return $this->trimPast("\n\n");
    }

    public  function removeTags(&$text)
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        try {

            $cnt = 0;
            $iiLookEnd = 0;
            if (empty($text))
                return "";
            //  throw new Exception("E#923 text is empty in removeTags() $eol");
            while (1) {
                $cnt++;
                if ($cnt > 50)
                    throw new Exception("$msg $errorBeg E#924 to many tags found $errorEnd" . htmlspecialchars($text) . $eol);
                if ($iiLookEnd >= strlen($text))
                    break;
                $iiLookBeg = strpos($text, "<", $iiLookEnd);
                if (false === $iiLookBeg)
                    break;
                $iiLookEnd = strpos($text, ">", $iiLookBeg);
                if (false === $iiLookEnd)
                    break;

                $text = substr($text, 0, $iiLookBeg) . substr($text, $iiLookEnd + 1);
                $numRemoved = $iiLookEnd - $iiLookBeg;
                $iiLookEnd = $iiLookEnd - $numRemoved;
            }
            $text = trim($text);
        } catch (Exception $e) {
            $msg .= "E#982  at bottom of removeTags() $eol";
            $msg .= $this->printSomeBuffer(" ", 0) . $e->getMessage() . $eol;
        }
        return $msg;
    } // end removeTags

    public function printSomeBuffer($description, $numChars = 120)
    {
        global $eol;
        $msg = "";
        $msg .= str_repeat("-", 120) . "$description $eol";
        $msg .= htmlspecialchars(substr($this->buffer, 0, $numChars)) . $eol;
        $msg .= str_repeat("-", 100) . $eol;
        return $msg;
    } // end printSomeBuffer

} // end class
