<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.com
 */
//start of include freewheeling_kml_common.php
global $kmlOutputDire,  $docOutputHtmlDire, $localWebDire, $linesOutputDire;
$website = "freewheelingeasy";
$kmlOutputDire = "C:/1and1MiscCopy/www-$website/kml/"; # kml files for each trail that has all the data
$localWebDire = "C:/inetpub/wwwroot/fwe/";
$docOutputHtmlDire = "$localWebDire/trails-html/"; # html files of the write-up
$linesOutputDire = $kmlOutputDire . "zz_";
global $eol, $errorBeg, $errorEnd;
global $startAt, $endAt;
//error_reporting(E_ALL | E_STRICT);
ini_set('display_errors', '1');
$eol = "<br />\n";
$errorBeg = "$eol$eol<font color='red'>";
//$rrwErrorLogin = "$errorEnd <form action='/wp-admin'><input type='submit' value='go to login' /></form>";
$errorEnd = "</font>$eol$eol";
$noteBeg = "<font color='pink'>";
$noteEnd = "</font>";
global $Freewheeling_maxKmlNumber;
$Freewheeling_maxKmlNumber = 995;
class freewheeling_kml_common
{
    private $milepostPrefix = "MP ";
    public static function array_mSort($arrayToSort, $cols)
    {
        $sortColumns = array();
        foreach ($cols as $col => $order) {
            $sortColumns[$col] = array();
            foreach ($arrayToSort as $k => $row) {
                $sortColumns[$col]['_' . $k] = strtolower($row[$col]);
            }
        }
        $eval = 'array_multisort(';
        foreach ($cols as $col => $order) {
            $eval .= '$sortColumns[\'' . $col . '\'],' . $order . ',';
        }
        $eval = substr($eval, 0, -1) . ');';
        eval($eval);
        $ret = array();
        foreach ($sortColumns as $col => $arr) {
            foreach ($arr as $k => $v) {
                $k = substr($k, 1);
                if (!isset($ret[$k])) $ret[$k] = $arrayToSort[$k];
                $ret[$k][$col] = $arrayToSort[$k][$col];
            }
        }
        return $ret;
    } // end of array_mSort
    /**
     * Retrieves the line record given the icon data.
     *
     * This function queries the database to find a line record that matches the given latitude and longitude
     * within the specified bounds. If multiple records are found, it returns the one with the highest latMax value.
     */
    public static function get_lineRecGivenIconData($iconId, $iconName, $latitude, $longitude): array
    {
        global $meters2Mile;
        global $wpdbExtra;
        if (0 == $meters2Mile) {
            $msgErr = rrwFormat::backtrace("E#1734 in get_lineRecGivenIconData:meters2Miles is zero");
            print $msgErr;
            throw new Exception($msgErr);
        }
        $padding[0] = 0;
        $padding[1] = 10 / $meters2Mile;   // wit a 10 foot padding
        foreach ($padding as $pad) {
            $sql = "select * from $wpdbExtra->lines where
                    (latMin - $pad) <= $latitude and $latitude <= (latMax + $pad) and
                    (lngMin - $pad) <= $longitude and $longitude <= (lngMax + $pad) ";
            $recLines = $wpdbExtra->get_resultsA($sql);
            switch (count($recLines)) {
                case 0:
                    break; // try again with a larger padding
                case 1:
                    return $recLines[0];    // found the line
                default:
                    $max = 0;       // multiple lines found, return the one with the highest latMax
                    foreach ($recLines as $recLine) {
                        $recMax = $recLine["latMax"];
                        if ($recMax > $max) {
                            $max = $recMax;
                            $lineRec = $recLine;
                        }
                    } // end of foreach
                    return $lineRec;
            }   // end of switch
        } // end of foreach padding
        return array(); // no line found
    } // end of get_line Id of the given Icon Data
    public static function filename2webName($fileName)
    {
        $site_url = site_url();
        $webName = str_replace("/home/pillowan/", "", $fileName);
        $iiSlash = strpos($webName, "/");
        if ($iiSlash !== false) {
            $webName = substr($webName, $iiSlash + 1);
        }
        $webName = "$site_url/$webName";
        return "$webName";
    }
    public static function findLatestTrailFile($trailId)
    {
        global $freewheelingeasy_kml_directory;
        $msg = "";
        $version = self::findLatestTrailFileThisVersion($trailId, $msg);
        $filename = "$freewheelingeasy_kml_directory/$trailId$version.kml";
        return $filename;
    }
    /**
     * Finds the highest number version of a file for a given trail ID.
     *
     * @param string $trailId The ID of the trail.
     * @param string &$msg A reference to a message string that will store any debug messages.
     * @return int The highest version number found.
     * @throws Exception If no version of the file is found.
     */
    public static function findLatestTrailFileThisVersion($trailId, &$msg): Int
    {
        global $eol, $errorBeg, $errorEnd;
        global $freewheelingeasy_kml_directory;
        global $Freewheeling_maxKmlNumber;
        global $wpdbExtra;
        $debugThisVersion = false;
        $sql = "select trId from $wpdbExtra->trails where trId = '$trailId'";
        $wpdbExtra->get_var($sql);
        if ($wpdbExtra->num_rows != 1) {
            $sql = "select grpId from $wpdbExtra->trail_routes where grpId = '$trailId'";
            $wpdbExtra->get_var($sql);
            if ($wpdbExtra->num_rows != 1) {
                $msg .= "I#1750 id <strong>$trailId</strong> is neither a trail id or a group id $eol";
                $msg .= rrwFormat::backtrace("I#1762 id <strong>'$trailId'</strong> is neither a trail id or a group id");
                return 0;   // non existent version number;
            }
            $msg .= "I#1730 id <strong>$trailId</strong> is a group id no kml file available$eol";
            return 0;   // non existent version number;
        }
        if ($debugThisVersion) print "findLatestTrailFileThisVersion:Processing file $trailId ";
        $didNotFind = true;
        if (! isset($Freewheeling_maxKmlNumber) || $Freewheeling_maxKmlNumber < 10 || $Freewheeling_maxKmlNumber > 999) {
            $msg .= "$errorBeg E#1731 max version number is $Freewheeling_maxKmlNumber $errorEnd";
            throw new Exception($msg);
        }
        $cnt = 0;
        for ($version = $Freewheeling_maxKmlNumber; $version > 7; $version--) {
            $cnt++;
            if ($cnt > 1101)
                throw new Exception("$errorBeg E#1733 too many iterations in the findLatestTrailFileThisVersion $errorEnd");
            $fileTemp = "$freewheelingeasy_kml_directory/$trailId$version.kml";
            $fileTemp2 = "$freewheelingeasy_kml_directory/$trailId$version.kmz";
            if ($debugThisVersion) $msg .= "$fileTemp$eol";
            if (file_exists($fileTemp) || file_exists($fileTemp2)) {
                $didNotFind = false;
                break;
            }
        }
        if ($version >= $Freewheeling_maxKmlNumber) {
            $msg .= "$errorBeg E#1740 version number is $version which is greater or equal than max version $Freewheeling_maxKmlNumber
                        trailId ''$trailId' in $freewheelingeasy_kml_directory/$trailId $errorEnd";
            throw new Exception($msg);
        }
        if ($didNotFind) {
            throw new Exception("$msg E#1039 $errorBeg We did not find a version NN of the
                        trailId ''$trailId' in $freewheelingeasy_kml_directory/$trailId $errorEnd
                        " . rrwFormat::Backtrace());
        }
        return $version;
    }
    /**
     * Finds the next available trail file for a given trail ID.
     *
     * This function searches for the next available KML or KMZ file for a given trail ID,
     * starting from the maximum KML number and decrementing until it finds an existing file.
     * If no file is found and the $create parameter is true, it sets the version to 10.
     * If no file is found and the $create parameter is false, it throws an exception.
     * If the next version exceeds the maximum allowed value, it throws an exception.
     *
     * @param string $trailId The ID of the trail to find the next file for.
     * @param bool $create Whether to create a new file if none is found. Default is false.
     * @return string The path to the next available trail file.
     * @throws Exception If no file is found and $create is false, or if the version exceeds the maximum allowed value.
     */
    /**
     * Finds the next available trail file for a given trail ID.
     *
     * This function searches for the next available KML file for a given trail ID,
     * starting from the maximum KML number and decrementing until it finds an existing file.
     * If no file is found and the $create parameter is true, it sets the version to 10.
     * If no file is found and the $create parameter is false, it throws an exception.
     * If the next version exceeds the maximum allowed value, it throws an exception.
     *
     * @param string $trailId The ID of the trail to find the next file for.
     * @param bool $create Whether to create a new file if none is found. Default is false.
     * @return string The path to the next available trail file.
     * @throws Exception If no file is found and $create is false, or if the version exceeds the maximum allowed value.
     */
    public static function findNextTrailFile($trailId, $create = false)
    {
        global $eol, $errorBeg, $errorEnd;
        global $Freewheeling_maxKmlNumber;
        global $freewheelingeasy_kml_directory;
        $debugFndNext = rrwParam::Boolean("debugFndNext", array(), false);
        //print "Processing file trailId ";
        if ($debugFndNext) print "findNextTrailFile: starting at $Freewheeling_maxKmlNumber and going down " .
            ($create ? "true" : "false") . $eol;
        // find the current version of the file
        $missingFile = true; //record if we found the file
        for ($version = $Freewheeling_maxKmlNumber; $version > 7; $version--) {
            $fileTemp = "$freewheelingeasy_kml_directory/$trailId$version.kml";
            //    if ($debugFndNext) print "$fileTemp$eol";
            if (file_exists($fileTemp)) {
                $missingFile = false;
                // print "found it $fileTemp $eol";
                break;
            }
        }
        if ($missingFile) {
            if ($create) {
                $version = 10;  // start a new file, should be two digits
            } else {
                $msgErr = " $errorBeg E#1751 We did not find a version NN of the
						trailId ''$trailId' in $freewheelingeasy_kml_directory/$trailId $errorEnd
                        " . rrwFormat::Backtrace();
                throw new Exception($msgErr);
            }
        }
        if ($debugFndNext) print "$eol current file is $fileTemp $eol";
        $version = $version + 1;
        if ($version > $Freewheeling_maxKmlNumber) {
            throw new Exception("$errorBeg E#1754 Version number exceeds the maximum allowed value $Freewheeling_maxKmlNumber $errorEnd");
        }
        $temp = strtolower("$freewheelingeasy_kml_directory/$trailId$version.kml");
        if ($debugFndNext) print "E1763 final output is $temp $eol";
        return $temp;
    }
    public static function findTrailId($trailNamePart)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_trails;
        # did he pass the trail ID ?
        $sql = "select trId from $rrw_trails where trId = '$trailNamePart'";
        // print "$eol$sql$eol";
        $trId = $wpdbExtra->get_var($sql);
        if ($wpdbExtra->num_rows == 1)
            return $trId;
        # Not the trail ID lets see if we can find something
        $trId = $wpdbExtra->get_var($sql);
        if ($wpdbExtra->num_rows == 1)
            return $trId;
        $msgTemp = rrwFormat::backtrace();
        throw new Exception("$errorBeg E#1732 not not find a match to '$trailNamePart' in trails $eol, $msgTemp");
    }
    public static function findTrailFullName($trailId)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_trails;
        $sql = "select trName from $rrw_trails where trId = '$trailId' ";
        #print "$sql$eol";
        $trName = $wpdbExtra->get_var($sql);
        if ($wpdbExtra->num_rows == 1)
            return $trName;
        $msgErr = "$errorBeg findTrailFullName: did not return a trail name from sql: $eol$sql$errorEnd";
        throw new Exception($msgErr);
    }
    public static function setHasWriteup($fileName)
    {
        global $eol, $errorBeg, $errorEnd;
        global $docOutputHtmlDire, $eol;
        $fullFile1 = "$docOutputHtmlDire/$fileName.html";
        if (file_exists($fullFile1))
            $hasWriteup = true;
        else
            $hasWriteup = false;
        //	print "has a write up is $hasWriteup $eol";
        return $hasWriteup;
    }
    public static function cleanStyleUrl($itemStyle, $CheckItemName)
    {
        /* remove number from the tail end
     * change sn_ylw ==> trailUnknown
     * change msn_ylw ==> msn_iconUnknown
     * trailOpenUnaligned == > trailOpen
     * look at first three character of the name expecting TO TR TC TU BL
     * look at first  character of the name expecting Parking, Endpoint
     */
        global $eol, $itemName;
        $debugCleanStyleUrl = rrwParam::Boolean("debugCleanStyleUrl");
        if (is_null($itemStyle))
            return "#unknownGap";
        if ($debugCleanStyleUrl) print "---style input is " . htmlspecialchars($itemStyle, ENT_QUOTES) .
            " name is $CheckItemName item name is $itemName $eol";
        $style = trim($itemStyle);
        if (strpos(" " . $style, "Style_35") > 0)
            return $style;
        $loop = 0;
        while (is_numeric(substr($style, strlen($style) - 1, 1)) && $loop < 10) {
            $loop++;
            $style = substr($style, 0, strlen($style) - 1);
        }
        if (strcmp(substr($style, 1, 6), "sn_ylw") == 0) {
            $style = "#unknownGap";
        } elseif (strcmp(substr($style, 1, 7), "msn_ylw") == 0) {
            $style = "#msn_iconUnknown";
        } elseif (strcmp(substr($style, 1, 7), "msn_ylw") == 0) {
            $style = "#unknownGap";
        } elseif (
            strcmp($style, "trailOpenUnaligned") == 0 ||
            strcmp($style, "track-none") == 0 ||
            strcmp($style, "trailUnknown") == 0
        ) {
            $style = '#unknownGap';
        } elseif (strcmp($style, "#msn_iconbike") == 0) {
            $style = '#msn_icon_bike';
        }
        if ($debugCleanStyleUrl) {
            print "Name is $itemName $eol";
        }
        if (is_null($itemName))
            $itemName = "msn_flag";
        if (strncmp($itemName, "Parking", 7) == 0) {
            $style = "#m_ylw-pushpin";
        }
        if (
            strcmp($itemName, "Endpoint") == 0 ||
            strcmp($itemName, "Untitled Placemark") == 0 ||
            strcmp($style, "#waypoint") == 0
        ) {
            $style = "#msn_flag";
        }
        if ($CheckItemName) {
            if (" " == substr($itemName, 2, 1)) {   // does it have a 2 character prefix
                $char = substr($itemName, 0, 2);
                if ($debugCleanStyleUrl) print "E#1738 looking for two characters **$char** $eol";
                $style = createLineText::lineInputPrefix($char);
                $itemName = substr($itemName, 3);
            }
        }
        if (strcmp($itemName, "Path") == 0) {
            $style = createLineText::lineInputPrefix("TU");
            $itemName = "Open Trail";
        }
        if ($debugCleanStyleUrl) {
            print " $itemName  out becomes  " . htmlspecialchars($style, ENT_QUOTES) . $eol;
        }
        return $style;
    }
    /**
     * Updates the minimum and maximum coordinates of a line and returns the results.
     * The result contains only keys that are valid for updating a line.
     *
     * This function takes an array of item coordinates, finds the minimum and maximum
     * latitude and longitude values, and then removes these values from the results.
     * It also extracts a message from the results and assigns it to the provided
     * message reference variable.
     *
     * @param string $itemCoords An array of item coordinates.
     * @param string &$msg A reference to a message variable that will be updated with the message from the results.
     * @return array The results array with the min/max latitude and longitude values removed.
     */
    public static function updateMinMaxOfLine(String $itemCoords, &$msg)
    {
        $results = self::findMinMax($itemCoords);
        unset($results["maxlat"]);
        unset($results["minlat"]);
        unset($results["maxlon"]);
        unset($results["minlon"]);
        unset($results["north"]);
        unset($results["south"]);
        unset($results["east"]);
        unset($results["west"]);
        $msg = $results["msg"];
        unset($results["msg"]);
        return $results;
    }
    /**
     * Finds the minimum and maximum values in a given point list.
     *
     * @param string $aPointList The list of points to search for minimum and maximum values.
     * @param string &$outputMsg A reference to a messages that will store any error messages.
     * @return void
     */
    public static function findMinMax(string $itemCoords): array
    {
        global $eol, $errorBeg, $errorEnd;
        // returns an array of results
        // latStart, latEnd, lngStart, lngEnd, latMax, lngMax, latMin, lngMin
        $outputMsg = "";
        $DebugMinMax = false;
        if (strlen($itemCoords) < 1) {
            $errMsg = "$errorBeg freewheeling_kml_common::findMinMax: E#1742 No coordinates to process $errorEnd";
            $errMsg .= rrwFormat::backtrace("$errMsg");
            throw new Exception($errMsg);
        }
        $seq = 0;
        $minlat = 181;
        $minlon = 181;
        $maxlat = -181;
        $maxlon = -181;
        $sumDist = 0;
        if (substr($itemCoords, 0, 4) == "enc:") {
            $itemCoords = substr($itemCoords, 4);
            if ($DebugMinMax) $outputMsg .= substr($itemCoords, 0, 20) . $eol;
            $itemCoords = polyline::decode($itemCoords);
            $latStart = $itemCoords[0];
            $lngStart = $itemCoords[1];
            $latPrv = $latStart;
            $lonPrv = $lngStart;
            for ($ii = 0; $ii < count($itemCoords); $ii = $ii + 2) {
                $seq++;
                $lat = $itemCoords[$ii + 1];
                $lon = $itemCoords[$ii];
                if ($DebugMinMax && $ii < 20) $outputMsg .= " $ii - $lat, $lon ";
                if ($minlat > $lat)
                    $minlat = $lat;
                if ($minlon > $lon)
                    $minlon = $lon;
                if ($maxlat < $lat)
                    $maxlat = $lat;
                if ($maxlon < $lon)
                    $maxlon = $lon;
                $sumDist += freewheeling_calculations::distanceMeters($latPrv, $lonPrv, $lat, $lon);
                if ($DebugMinMax) $outputMsg .= rrwFormat::CellRow($seq, $sumDist, $minlat, $lat, $maxlat,   $minlon, $lon, $maxlon);
                $latPrv = $lat;
                $lonPrv = $lon;
            }
            $outputMsg .= $eol;
            $outputMsg .= "$errorBeg e#1739 may need to calculate distance $errorEnd";
        } else {
            // itemCoords is a string of lat,lon,elv points
            if ($DebugMinMax) $outputMsg .= rrwUtil::print_r($itemCoords, true, "findMinMax:itemCoords");
            $coords = explode(" ", $itemCoords); # break into lat,lon,elv groups
            if (count($coords) < 1) // is it a real line
            {
                $outputMsg .= "there are too few points for line data $itemCoords it is ignored $eol";
                $errMsg = "$errorBeg freewheeling_kml_common::findMinMax: E#1761 No coordinates to process $errorEnd";
                $errMsg .= rrwFormat::backtrace("$errMsg");
                throw new Exception($errMsg);
            }
            if ($DebugMinMax) $outputMsg .= rrwUtil::print_r($coords, true, "findMinMax:coords");
            $seq = 0;
            $pt = explode(",", $coords[0]);
            if (3 != count($pt)) {
                throw new Exception("540 something confused about coordinates $eol itemCoords = $itemCoords $eol This coordinate = $coords[0]");
            }
            $latStart = $pt[1];
            $lngStart = $pt[0];
            $latPrv = $latStart;
            $lonPrv = $lngStart;
            if ($DebugMinMax) {
                $outputMsg .= "There are " . count($coords) . " coordinates $eol <table>";
                $outputMsg .= rrwFormat::HeaderRow("Seq", "accumulated distance", "minlat", "Lat",  "maxlat", "minlon", "Lon", "maxlon");
            }
            foreach ($coords as $coord) {
                if (strlen(trim($coord)) > 10) {
                    $pt = explode(",", $coord);
                    $seq = $seq + 1;
                    $lat = $pt[1];
                    $lon = $pt[0];
                    if ($minlat > $lat)
                        $minlat = $lat;
                    if ($minlon > $lon)
                        $minlon = $lon;
                    if ($maxlat < $lat)
                        $maxlat = $lat;
                    if ($maxlon < $lon)
                        $maxlon = $lon;
                    $sumDist += freewheeling_calculations::distanceMeters($latPrv, $lonPrv, $lat, $lon);
                    if ($DebugMinMax) $outputMsg .= rrwFormat::CellRow($seq, $sumDist, $minlat, $lat, $maxlat,   $minlon, $lon, $maxlon);
                    $latPrv = $lat;
                    $lonPrv = $lon;
                } // end got coords
            } //  end fo loop through cords
        } // if polyline
        if ($DebugMinMax) $outputMsg .= "</table>";
        $result = array(
            "latStart" => $latStart,
            "lngStart" => $lngStart,
            "latEnd" => $latPrv,
            "lngEnd" => $lonPrv,
            "maxlat" => $maxlat,
            "minlat" => $minlat,
            "latmax" => $maxlat,
            "latmin" => $minlat,
            "maxlon" => $maxlon,
            "minlon" => $minlon,
            "lngMax" => $maxlon,
            "lngMin" => $minlon,
            "north" => $maxlat,
            "south" => $minlat,
            "east" => $maxlon,
            "west" => $minlon,
            "lengthMeters" => $sumDist,
            "msg" => $outputMsg,
        );
        return $result;
    }
    /*
private static function returnDistanceInMeters($h, $j, $l, $b)
{
    $g = new google . maps . LatLng($h, $j);
    $d = new google . maps . LatLng($l, $b);
    $a = google . maps . geometry . spherical . computeDistanceBetween($g, $d);
    return ($a);
}
*/
    public static function UpdateLineRangeBounds($lineId, $itemCoords, $trailId)
    {   // update the line item with the min, max, start, end, length, trailId values
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $debug = false;
        try {
            if ($debug) {
                $msg .= "UpdateRangeBounds #1: Item: $lineId  - length: " . strlen($itemCoords) .
                    " - $itemCoords $eol $eol";
            }
            if (!$result = self::findMinMax($itemCoords)) {
                $msg .= "$errorBeg UpdateRangeBounds #2: Item: $lineId  - length: " . strlen($itemCoords) .
                    " - $itemCoords E#1747 Find min max had problems $errorEnd";
                throw new Exception($msg);
            }
            if ($debug) {
                $msg .= "$eol UpdateRangeBounds #3:Item:$lineId, " .
                    $result["distanceMeters"] . " meters $eol ";
                $msg .= rrwUtil::print_r($result, true, "UpdateLineRangeBounds:to be updated");
            }
            $updateRange = array(
                "latStart" => $result["latStart"],
                "lngStart" => $result["lngStart"],
                "latEnd" => $result["latEnd"],
                "lngEnd" => $result["lngEnd"],
                "lngmax" => $result["maxlon"],
                "lngmin" => $result["minlon"],
                "latmin" => $result["minlat"],
                "latmax" => $result["maxlat"],
                "lengthMeters" => $result["lengthMeters"],
                "lineIconId " => 0,
                "trailId" => $trailId,
                "pointList" => $itemCoords,
            );
            if ($debug) {
                $msg .= "Updating I#1737 lineId = $lineId with range data";
                $msg .= rrwUtil::print_r($updateRange, true, "new range data");
            }
            $recUpdated = $wpdbExtra->update($wpdbExtra->lines, $updateRange, array("lineId" => $lineId));
        } catch (Exception $e) {
            $msg .= $errorBeg . "E#1736 in UpdateLineRangeBounds: " . $e->getMessage() . $errorEnd;
            throw new Exception($msg);
        }
        return $msg;
    }
    /*
private static function SplitLineMaybe() {
	/* 	look for point that is way off the previous point.
		break the line into two pieces at that point.
		Assume that this is called  after a call to writeLineToDatabase()
			that is because we assume the globals are set from that call.
	global $itemName, $itemCoords, $itemStyle, $itemType, $itemDesc, $itemId, $debug;
	global $eol, $errorBeg, $errorEnd;
	$coords = explode( " ", $itemCoords ); # break into lat,lon,elv groups
	if (count($coords) < 5 ) {
		//  ignore short lines. user should of fixed by hand
		return false;
	}
	$splitLine_debug = rrwParam::Boolean("splitLine_debug");
	#dump_r ($coords); print $eol;
	$seq = 0;
	$coordAccumulation = "";
	$noSplitYet = true;
	#print "call split for line $itemId $eol";
	foreach ( $coords as $coord ) {
		$coordAccumulation = "$coordAccumulation $coord";
		$lenCoord = strlen( $coord );
		if ( strlen( trim( $coord ) ) > 10 && $noSplitYet ) {
			$pt = explode( ",", $coord );
			#dump_r($pt);
			$seq = $seq + 1;
			$lat = $pt[ 1 ];
			$lon = $pt[ 0 ];
			if ( $seq == 1 ) {
				$lastLat = $lat;
				$lastLon = $lon;
			}
			if ( ( abs( $lastLon - $lon ) > .1 ) || ( abs( $lastLat - $lat ) > .1 ) ) {
				if ( $splitLine_debug ) print "Split line requested --$itemId--" .
				"**$itemCoords$eol$eol";
				$itemCoords = $coordAccumulation;
				$strposStart = strlen( $itemCoords ) - ( $lenCoord + 5 );
				//	$iiSpace = strpos($itemCoords, " ", $strposStart);
				//	print " $strposStart - $iiSpace $eol ";
				//	$itemCoords = substr($itemCoords,0, $iiSpace);
				if ( $splitLine_debug ) print "begin line --$itemId-- " . "**$itemCoords$eol$eol";
				if ( strlen( $itemCoords ) > 5 ) # check for leftover segment
					writeLineToDatabase(); // this changes the exiting line.
				$coordAccumulation = "  $lastLon,$lastLat,0 "; // Start over at the same point the accumulator
				$noSplitYet = false;
			}
			$lastLat = $lat;
			$lastLon = $lon;
		}
	}
	if ( !$noSplitYet ) {
		$itemCoords = $coordAccumulation;
		$itemId = ""; // force to create a new line
		if ( $splitLine_debug ) print "end line --$itemId--  **$itemCoords$eol$eol";
		if ( strlen( $itemCoords ) > 5 ) # check for leftover segment
			writeLineToDatabase(); // do it
	}
}
*/
    public static function readWriteTo($fpIn, $fpOut, $lookFor, $checkStyle, $fromFileName)
    {
        /*		look for	 	is the termination character string
    		check Style	verify that we have a good style name
    */
        // read and write until we find what we are looking for.
        // Do not write out the found line
        // $fromFileName used for error message only
        global $eol, $errorBeg, $errorEnd;
        global $styleList;
        $debugReadWriteTo = rrwParam::Boolean("debugReadWriteTo");
        if ($debugReadWriteTo) print "================================ start read write to";
        $linesOutCnt = 0;
        $linesInCnt = 0;
        $isPath = false;
        while ($line = fgets($fpIn)) {
            $linesInCnt++;
            $latestName = "";
            if (strpos($line, $lookFor) > -1) {
                $tmp = htmlspecialchars($lookFor, ENT_QUOTES);
                if ($debugReadWriteTo) print "readWriteTo: Write out $linesOutCnt  lines while looking for $tmp in file $fromFileName$eol";
                return 0;
            }
            if (strpos($line, "<name>")) # false if not  found
            {
                $latestName = $line;
                #print "$isPath   $line $eol";
                if (strpos($line, "Trail Paths")) {
                    $isPath = false; // moved to trail paths true;
                }
                if (strpos($line, "Folder")) {
                    $isPath = false;
                }
            }
            if (strpos($line, "<open>")) # false if not  found
            {
                if ($isPath) {
                    fwrite($fpOut, "<Style>\n");
                    fwrite($fpOut, "   <ListStyle>\n");
                    if (strcmp($_GET["trail"], "all") == 0) #determine if trail paths expandable
                        fwrite($fpOut, "      <listItemType>checkHideChildren</listItemType>\n");
                    else
                        fwrite($fpOut, "      <listItemType>check</listItemType>\n");
                    fwrite($fpOut, "      <bgColor>00ffffff</bgColor>\n");
                    //	fwrite($fpOut, "      <maxSnippetLines>2</maxSnippetLines>\n");
                    fwrite($fpOut, "   </ListStyle>\n");
                    $line = "</Style>\n";
                }
            }
            if (strpos($line, "Style id") > 0 || strpos($line, "StyleMap id") > 0) {
                $id = explode('"', $line);
                $tempId = $id[1];
                if ($debugReadWriteTo) print "readWriteTo: Style id is $tempId $eol";
                $styleList["#$tempId"] = 1;
            }
            if (strpos($line, "<styleUrl") > -1) {
                if ($debugReadWriteTo) print "readWriteTo: $eol line 01 == " . htmlspecialchars($line, ENT_QUOTES) . " $eol";
                $iGT = strpos($line, ">");
                $iLT = strpos($line, "<", $iGT);
                $style1 = substr($line, $iGT + 1, $iLT - $iGT - 1);
                $style = self::cleanStyleUrl($style1, false);
                if ($debugReadWriteTo) print "readWriteTo: Style before $style1, style after $style";
                $line = substr($line, 0, $iGT + 1) . $style . substr($line, $iLT);
                if ($debugReadWriteTo) print "readWriteTo:   line == " . htmlspecialchars($line, ENT_QUOTES) . " $eol";
                if ($checkStyle) {
                    if (!array_key_exists("$style", $styleList)) {
                        print "$errorBeg readWriteTo: Unknown style about line
							$linesInCnt from file $fromFileName " .
                            htmlspecialchars($latestName, ENT_QUOTES) . " of '$style' $eol Should be one of $eol";
                        print rrwUtil::print_r($styleList, true, "style list");
                        print "E#1040 $errorEnd";
                    }
                }
            }
            fwrite($fpOut, $line);
            $linesOutCnt++;
        }
        if ($debugReadWriteTo) {
            print "read $linesInCnt and output $linesOutCnt $eol";
            print "================================ end read write to";
        }
        return $linesOutCnt;
    }
    /*
private static function readDiscard($fpIn, $fpOut, $lookFor)
{
    // read  until we find what we are looking for.
    // Discard the found line as well
    global $eol, $errorBeg, $errorEnd;
    $cnt = 0;
    while ($line = fgets($fpIn)) {
        if (strpos($line, $lookFor) > -1) {
            $tmp = htmlspecialchars($lookFor, ENT_QUOTES);
            print "$errorBeg E#1756 Discarded $cnt lines while looking for $tmp $errorEnd";
            return;
        }
        $cnt = $cnt + 1;
    }
}
    */
    public static function readWriteStyle($kmlStyleFileName, $fpOut, $debug = false)
    { // read a style file and output it to th final file
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $debug = false;
        if ($debug) $msg .= "$eol E#1753 Load styles from $kmlStyleFileName ";
        $StyleContents = freewheeling_Writeup::getFileContents("kmlStyles", $kmlStyleFileName);
        fwrite($fpOut, $StyleContents);
        if ($debug) $msg .= " wrote " . strlen($StyleContents) . " bytes of data$eol";
        return $msg;
    }
    public static function findItem($fp, $item, $skipCnt)
    {
        global $eol, $errorBeg, $errorEnd;
        // read in the lines associated with the $item.  use to fond the first LookAt
        $Accumulation = "";
        $cnt = 0;
        //print "Looking for $item$eol";
        while (($line = fgets($fp)) && ($skipCnt >= 0)) {
            if (strpos($line, $item) > 0) {
                print "find the item $item$eol";
                $skipCnt = $skipCnt - 1;
                if ($skipCnt <= 0) {
                    $Accumulation = $line;
                    while ($line = fgets($fp)) {
                        $Accumulation = $Accumulation . $line;
                        $cnt = $cnt + 1;
                        //print htmlspecialchars("accumulating $Accumulation" ,ENT_QUOTES) . "$eol";
                        if (strpos($line, "/$item") > 0) {
                            print "Accumulated $cnt lines while gathering $item$eol";
                            fseek($fp, 0, SEEK_SET);
                            return $Accumulation;
                        }
                    }
                } //if ($skipCnt <= 0)
            } // if (strpos($line, $item) > 0 )458
        } //while ($line = fgets($fp) && $skipCnt >= 0)
        print "Accumulated $cnt lines while gathering $item$eol";
        fseek($fp, 0, SEEK_SET);
        return $Accumulation;
    } //  function findItem($item, $skipCnt)
    public static function parkingDescription($pointName, $lat40, $lon80, $isTrailHead)
    {
        if ($isTrailHead > 0)
            $trailHeadDisplay = " TrailHead";
        else
            $trailHeadDisplay = "";
        return "<!--GPS common description -->$pointName$trailHeadDisplay - GPS $lat40, $lon80,0 <br \>;
			 ";
        /*
    //			 <input type='hidden' name='ToAddress' value='$lat40,$lon80 ($pointName$trailHeadDisplay)' /></form>
    return "<!--GPS common description -->$pointName TrailHead - GPS $lat40, $lon80,0 <br />
			Directions: <strong>To here - " .
        "Enter the start address:</strong><form action='http://maps.google.com/maps' " .
        "method='get' target='_blank > " .
        "<input type='text' size='40' maxlength='40' name='startAddress' id='startAddress' value='' /><br />" .
        "<input value='Get Directions' type='submit' >" .
        "<input type='hidden' name='ToAddress' value='$lat40,$lon80 ($pointName TrailHead)' /></form>";
        */
    }
    public static function displayIconsLines($trailIdOrKMLname, $title = "")
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $msg .= freeWheeling_edit_setGlobals::setGlobals("freewheeling_kml_common::displayIconsLines");
        if (strpos($trailIdOrKMLname, "kml")) {
            $trailId = str_replace(".kml", "", $trailIdOrKMLname);
            $iiSlash = strrpos($trailId, "/");
            $trailId = substr($trailId, $iiSlash + 1);
        } else {
            $trailId = $trailIdOrKMLname;
        }
        if (empty($trailId)) {
            $trailId = freeWheelParam::trail();
            if (empty($trailId)) {
                $msg .= "$errorBeg E#1057 Please specify a trail id $errorEnd";
                return $msg;
            }
        }
        $msg .= self::displayIconsAndLines($trailId, $title);
        return $msg;
    } // function displayIconsLines($trailId, $title = "")
    /**
     * Display lines for a given group ID.
     *
     * This function retrieves the SQL query for lines associated with the specified group ID
     * from the `trail_routes` table and then displays the lines using the retrieved SQL query.
     *
     * @param string $grpId The ID of the group whose lines are to be displayed.
     * @param string $title Optional. The title to be displayed with the lines. Default is an empty string.
     * @return string The lines associated with the given group ID, or a message indicating no lines were found.
     */
    public static function displayLinesEnds($trailOrGroupId, $title = "")
    {
        global $wpdbExtra;
        $msg = "";
        $$msg .= freeWheelingClean::ImposeMilepostPrefix(); // male shure things are right
        $msg .= freewheelingeasy_edit_routes::imposeRoutesAll();
        $sqlWhere = self::sqlWhereForGroupOrTrailLines($trailOrGroupId);
        $sqlLines = " select TrailId,LineName, mapStyle,  routes,  latStart,latEnd,  lngStart,  lngEnd, sequence, LineId, lineIconId
                    from $wpdbExtra->lines
                    where $sqlWhere
                    order by sequence ";
            //join $wpdbExtra->surfaces on mapStyle = code
            //           $msg .= $sqlLines . $eol
        ;
        $msg .= "<h1>$title</h1>";
        $msg .= "<table>\n";
        $msg .= rrwFormat::HeaderRow(
            "Trail Id",
            "Line Name",
            "Surface",
            "routes",
            "Start Lat",
            "End Lat",
            "Start Lng",
            "End Lng",
            "Sequence",
            "Line ID",
            "Icon Id"
        );
        $lines = $wpdbExtra->get_resultsA($sqlLines);
        $pastLatitude = $lines[0]["latStart"];
        $pastLongitude = $lines[0]["lngStart"];
        foreach ($lines as $line) {
            if ($pastLatitude != $line["latStart"] || $pastLongitude != $line["lngStart"]) {
                $msg .= rrwFormat::CellRow(
                    "&nbsp;",
                    "&nbsp;",
                    "&nbsp;",
                    "gap here"
                );
            }
            $msg .= rrwFormat::CellRow(
                $line["TrailId"],
                $line["LineName"],
                $line["mapStyle"],
                $line["routes"],
                $line["latStart"],
                $line["latEnd"],
                $line["lngStart"],
                $line["lngEnd"],
                $line["sequence"],
                $line["LineId"],
                $line["lineIconId"]
            );
            $pastLatitude = $line["latEnd"];
            $pastLongitude = $line["lngEnd"];
        }
        $msg .= "</table>";
        return $msg;
    }
    /**
     * Retrieves line records for a given trail ID or group ID.
     *
     * This function attempts to fetch line records from the database based on the provided trail ID or group ID.
     * If no records are found for the trail ID, it will attempt to fetch records using the group ID.
     *
     * @param int|string $trailIdOrGroupId The trail ID or group ID to search for line records.
     * @param string $orderBy The column name to order the results by.
     * @param string &$msg A reference to a message string that will be appended with error information if no records are found.
     *
     * @return array The retrieved line records.
     *
     * @throws Exception If no line records are found for the given trail ID or group ID.
     */
    public static function sqlWhereForGroupOrTrailLines(String $trailIdOrGroupId): String
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $debug = false;
        $sqlWhere = "trId = '$trailIdOrGroupId'";
        $sqlTryTrails = "select trId from $wpdbExtra->trails where  $sqlWhere ";
        $wpdbExtra->get_var($sqlTryTrails);
        if ($debug) print "try1 got $wpdbExtra->num_rows $sqlTryTrails $eol";
        if (1 !== $wpdbExtra->num_rows) {
            // apparently not a trail id, try a group id
            $sqlTryGroups = "select lineSql from $wpdbExtra->trail_routes where grpId = '$trailIdOrGroupId' ";
            $sqlWhere = $wpdbExtra->get_var($sqlTryGroups);
            if ($debug) print "try2 got $wpdbExtra->num_rows $sqlTryGroups $eol";
            if (1 !== $wpdbExtra->num_rows) {
                $msgErr = rrwFormat::backtrace("E#1058 No lines found for the given group/trail '$trailIdOrGroupId'");
                $msgErr .= " $sqlTryTrails $eol $sqlTryGroups $eol";
                throw new Exception($msgErr);
            }
        } else {
            $sqlWhere = " trailId = '$trailIdOrGroupId' ";    // it is a trail id, change trId to trailId
        }
        if ($debug) print "sqlWhere is $sqlWhere $eol";
        return $sqlWhere;
    }
    public static function sqlWhereForGroupOrTrailIcons($trailIdOrGroupId)
    {
        $msg = "";
        try {
            $sqlWhere = self::sqlWhereForGroupOrTrailLines($trailIdOrGroupId);
            $sqlWhere2 = str_replace(" trailId", "icon.trailId ", $sqlWhere);
            return $sqlWhere2;
        } catch (Exception $e) {
            $msg .= $e->getMessage() . "E#1755 ";
            $msg .= rrwFormat::backtrace($msg, 8);
            throw new Exception($msg);
        }
    }
    public static function get_TrailOrGroupName($trailIdOrGroupId)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $sqlGroup = "select grpName from $wpdbExtra->trail_routes where grpId = '$trailIdOrGroupId' ";
        $groupName = $wpdbExtra->get_var($sqlGroup);
        if (! empty($groupName))
            return $groupName;
        $sqlTrail = "select trName from $wpdbExtra->trails where trId = '$trailIdOrGroupId' ";
        $trailName = $wpdbExtra->get_var($sqlTrail);
        if (! empty($trailName))
            return $trailName;
        return "trailIdOrGroupId";
    }
    public static function displayLines($trailId, $title = "")
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        global $freewheelingeasy_latLngTolerance;
        global $meters2Mile;
        $msg = "";
        $debugLines = rrwParam::isDebugMode("debugLines");
        try {
            $msg .= "<h1>$title</h1>";
            $msg .= "<table>\n";
            $msg .= rrwFormat::HeaderRow(
                "Line Name",
                "Surface",
                "routes",
                "MP start",
                "Start Lat",
                "End Lat",
                "Start Lng",
                "End Lng",
                "Sequence",
                "Line ID",
                "Icon Id"
            );
            $sqlWhere = self::sqlWhereForGroupOrTrailLines($trailId);
            $sqlDisplay = "SELECT sequence , lineMPstart, latStart, latEnd, lngStart, lngEnd,
                    lineId, lineName, mapStyle, lineIconId, routes, codeDescription
                        FROM $wpdbExtra->lines line
                        left join $wpdbExtra->codesSurface on mapStyle = code
                        where $sqlWhere
                        order by sequence ";
            if ($debugLines);
            $msg .= "I#1763 sqlDisplay is $sqlDisplay $eol";
            //
            $displays = $wpdbExtra->get_resultsA($sqlDisplay);
            $mapStyleLast = "not yet set";
            $latEndLast = 0;
            $lngEndLast = 0;
            if ($debugLines) $msg .= "found " . count($displays) . " lines to display $eol";
            if (0 == $wpdbExtra->num_rows) {
                $msg .= "</table> $errorBeg E#1052 No lines found to display for '$sqlWhere' of '$title' $errorEnd $sqlDisplay $eol";
                return $msg;
            }
            $latEndLast = $displays[0]["latStart"];
            $lngEndLast = $displays[0]["lngStart"];
            $sql = "select trMilepostPrefix from " . $wpdbExtra->trails . " where trId = '$trailId' ";
            $milepostPrefix = $wpdbExtra->get_var($sql);
            foreach ($displays as $display) {
                $mapStyle = $display["mapStyle"];
                if (empty($mapStyle))
                    $mapStyle = "invalid surface code'" . $display["mapStyle"] . "'";
                else
                    $mapStyle = $display["codeDescription"];
                $sequence = $display["sequence"];
                $lineId = $display["lineId"];
                $MPstart = $display["lineMPstart"];
                $MPstart = freewheelFormat::Milepost($milepostPrefix,  $MPstart);
                $routes = $display["routes"];
                if ($mapStyle != $mapStyleLast)
                    $mapStyleDisplay = $mapStyle;
                else
                    $mapStyleDisplay = '&nbsp; &nbsp; &nbsp; "';
                $mapStyleLast = $mapStyle;
                $latStart = $display["latStart"];
                $lngStart = $display["lngStart"];
                //		$msg .= rrwFormat::CellRow $latEndLast, $latStart , abs($latEndLast - $latStart) );
                if (
                    abs($latEndLast - $latStart) > $freewheelingeasy_latLngTolerance ||
                    abs($lngEndLast - $lngStart) > $freewheelingeasy_latLngTolerance
                ) {
                    $distanceDiffMeters = freewheeling_calculations::distanceMeters($latStart, $latEndLast, $lngStart, $lngEndLast,);
                    $distanceDiffMiles = $distanceDiffMeters / $meters2Mile;;
                    $msg .= rrwFormat::CellRow(
                        "",
                        "E#1748  gap in line work of $distanceDiffMeters meters, $distanceDiffMiles miles",
                        freewheeling_kml_common::displayLats($latStart),
                        freewheeling_kml_common::displayLats($latEndLast),
                        freewheeling_kml_common::displayLats($lngStart),
                        freewheeling_kml_common::displayLats($lngEndLast),
                        $sequence,
                        $lineId,
                        $display["lineIconId"]
                    );
                }
                $latEndLast = $display["latEnd"];   // save for next compare
                $lngEndLast = $display["lngEnd"];
                $lineName = $display["lineName"];
                $EditLineLink = freeWheelFormat::EditLineLink($lineId);
                $msg .= rrwFormat::CellRowColor(
                    $EditLineLink,
                    $mapStyleDisplay,
                    $routes,
                    "", // $MPstart is never set anywhere in the code, so leaving it blank for now
                    freewheeling_kml_common::displayLats($latStart),
                    freewheeling_kml_common::displayLats($latEndLast),
                    freewheeling_kml_common::displayLats($lngStart),
                    freewheeling_kml_common::displayLats($lngEndLast),
                    $sequence,
                    $display["lineId"],
                    $display["lineIconId"]
                );
            }
            $msg .= "</table>\n";
            $version = self::findLatestTrailFileThisVersion($trailId, $msg);
            if ($version > 10) {
                $msg .= "<a href='https://edit.shaw-weil.com/wp-content/uploads/kml/$trailId$version.kml' >
				            KML file is I#1764 $trailId$version.kml</a>$eol";
                $aqlNext = "select trId from $wpdbExtra->trails where trailId = '$trailId' ";
            }
        } catch (Exception $e) {
            $msgErr = $e->getMessage();
            $msg .= $errorBeg . "E#1765 in displayLines: $msgErr $errorEnd";
        }
        return $msg;
        //https://edit.shaw-weil.com/wp-content/uploads/kml/bayfront194.kml
    }
    public static function displayIconsAndLines($trailId, $title = "")
    {
        global $eol;
        try {
            $msg = "";
            $msg .= self::displayIcons($trailId, $title);
            $msg .= self::displayLines($trailId, $title);
            $msg .= self::displayPreviousNext($trailId);
        } catch (Exception $e) {
            $msg .= "E#1766 " . $e->getMessage() . $eol;
        }
        return $msg;
    }
    /**
     * Iterates through a list of route names, skipping empty entries and the "connect_erie" route.
     * For each valid route, constructs a SQL WHERE clause to filter icons by group or trail,
     * then queries the database for distinct trails associated with the route.
     * Outputs HTML links for merging lines for each trail, with special handling to output links
     * for the previous and current trail when a match is found.
     *
     * Debug information is printed if $debugDpn is enabled, showing SQL queries and WHERE clauses.
     *
     * Variables:
     * - $routeLists: Array of route names to process.
     * - $wpdbExtra: Database object for executing queries.
     * - $trailId: Current trail ID to match against.
     * - $msg: Message string to accumulate output.
     * - $eol: End-of-line character(s) for formatting.
     *
     * The output is appended to $msg, including route information and HTML links for trail merging.
     */
    private static function displayPreviousNext($trailId)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        try {
            $debugDpn = rrwParam::isDebugMode("debugDpn");
            // if trailId is a group, then the query will return empty
            $sqlTrails = "select trId, trName , onRoutes from $wpdbExtra->trails where trId = '$trailId' ";
            if ($debugDpn) print "E#1749 sqlTrails is $sqlTrails $eol";
            $recTrails = $wpdbExtra->get_resultsA($sqlTrails);
            if (0 == $wpdbExtra->num_rows) {
                $msg .= "not a group $sqlTrails $eol";
                return $msg;    // probably a group id
            }
            // now find out the routes for this trail, and list each of them
            $routeList = $recTrails[0]["onRoutes"];
            if (!empty(trim($routeList))) {
                $routeLists = explode(",", $routeList);
                foreach ($routeLists as $recRoute) {
                    if (empty(trim($recRoute)))
                        continue;
                    if ("connect_erie" == $recRoute)
                        continue;
                    $msg .= "[ Route <strong>$recRoute</strong> ] ";
                    try {
                        $sqlWhereIcons = freewheeling_kml_common::sqlWhereForGroupOrTrailIcons($recRoute);
                    } catch (Exception $e) {
                        $msg .= "Route not yet created $eol";
                        continue;
                    }
                    if ($debugDpn) print "E#1743 sqlWhereIcons before  $sqlWhereIcons $eol";
                    $sqlWhereIcons = str_replace("icon.trailId", "trailId", $sqlWhereIcons);
                    if ($debugDpn) print "E#1745 sqlWhereIcons after  $sqlWhereIcons $eol";
                    $sqlTrails = "select distinct trId, trName
                                from $wpdbExtra->lines
                                join $wpdbExtra->trails on trId = trailId
                                where $sqlWhereIcons order by trSequence";
                    if ($debugDpn) print "E#1757 sqlTrails is $sqlTrails $eol";
                    if ($debugDpn) print "E#1744 sqlWhereIcons is $sqlWhereIcons $eol";
                    $recTrailsList = $wpdbExtra->get_resultsA($sqlTrails);
                    //   $msg .= "found $wpdbExtra->num_rows trails in route -- $sqlTrails$eol";
                    $pastTrailId = "";
                    $pastTrailName = "";
                    $alreadyOutputPrevious = false;
                    foreach ($recTrailsList as $recTrail) {
                        $trailIdTable = $recTrail["trId"];
                        $trailNameTable = $recTrail["trName"];
                        if ($alreadyOutputPrevious) {
                            $msg .= "<a href='https://edit.shaw-weil.com/mergelines/?trailid=$trailIdTable' > [ $trailIdTable  ] </a>";
                            $alreadyOutputPrevious = false;
                            break;
                        }
                        if ($trailIdTable == $trailId) {
                            $msg .= "<a href='https://edit.shaw-weil.com/mergelines/?trailid=$pastTrailId' > [ $pastTrailId  ] </a>";
                            $msg .= "<a href='https://edit.shaw-weil.com/mergelines/?trailid=$trailIdTable' > [ $trailIdTable  ] </a>";
                            $alreadyOutputPrevious = true;
                        }
                        $pastTrailId = $trailIdTable;
                        $pastTrailName = $trailNameTable;
                    } // foreach ($recTrails as $recTrail)
                    $msg .= $eol;;
                } // foreach ($routeLists as $recRoute)
            }
            $sqlSpur = "select spurOf from $wpdbExtra->trails where trId = '$trailId' ";
            $spurOfs = $wpdbExtra->get_var($sqlSpur);
            if (!empty(trim($spurOfs))) {
                $spurs = explode(",", $spurOfs);
                $msg .= "[ Route <strong>Spur Trails</strong> ] ";
                foreach ($spurs as $spur) {
                    $msg .= "<a href='https://edit.shaw-weil.com/mergelines/?trailid=$spur' > [ $spur  ] </a>";
                }
                $msg .= "$eol";
            } // if (!empty(trim($spurOfs)))
        } catch (Exception $e) {
            $msg .= $errorBeg . "E#1746 in displayPreviousNext: " . $e->getMessage() . $errorEnd;
        }
        return $msg;
    } // end function displayPreviousNext($trailId)
    public static function displayIcons($trailId, $title = "")
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_icons;
        global $freewheeling_pagesPreBuiltUrl;
        $msg = "";
        $msg .= "<h1>$title</h1>";
        $linkRefresh = "<a href='/refresh-table?trailId=$trailId' target='display'>
        <img src='$freewheeling_pagesPreBuiltUrl/images/refresh.webp'
        height='15px' width='15px' alt='refresh' ></a>";
        $msg .= "<table><tr><th>$linkRefresh $trailId <a href='download-a-kml-file/?trailId=$trailId' >
                    Download Load  KML</a></th><th colspan='6' >$title</th></tr>";
        $sqlWhere = self::sqlWhereForGroupOrTrailIcons($trailId);
        $sqlIcons = "select distinct icon.*, codeDescription from $rrw_icons icon
                                join $wpdbExtra->lines line on icon.trailId = line.trailId
                                left join $wpdbExtra->trailHeads on icon.isTrailHead = code
                                where $sqlWhere and not onMap = '" . freeWheel::estimated_milepost . "'
                                order by sort, milepost";
        //   $msg .= $sqlIcons . $eol;
        $recIcons = $wpdbExtra->get_resultsA($sqlIcons);
        //
        $msg .= rrwFormat::HeaderRow(
            "Icon Name",
            "type",
            "milepost",
            "isa trail head",
            "Latitude",
            "Longitude",
            "Sort",
            "Icon ID",
            "line ID"
        );
        if ($wpdbExtra->num_rows == 0) {
            $sqlLines = "select * from $wpdbExtra->lines where trailId = '$trailId' ";
            $recLines = $wpdbExtra->get_resultsA($sqlLines);
            if ($wpdbExtra->num_rows == 0 || $recLines === false) {
                throw new Exception(" $msg </table>$errorBeg E#1758 No icons, no lines -
                        Are you sure the trail id id correct> $errorEnd $sqlIcons $eol");
            }
            $msg .= "<tr><td colspan=10> $errorBeg E#1759 No trail icons found to display for trailId = '$trailId' of '$title' $errorEnd
				$sqlIcons $eol You might need to add &newTrail=please to th url $errorEnd </td></tr>";
        }
        foreach ($recIcons as $recIcon) {
            $iconName = $recIcon["iconName"];
            $latitude = $recIcon["latitude"];
            $longitude = $recIcon["longitude"];
            $milepost = $recIcon["milepost"];
            $milePostPrefix = $recIcon["milePostPrefix"];
            $codeDescription = $recIcon["codeDescription"];
            $lineId = $recIcon["iconLineId"];
            $iconId = $recIcon["iconId"];
            $onMap = $recIcon["onMap"];
            $sort = $recIcon["sort"];
            $isTrailHead = $recIcon["isTrailHead"];
            $iconNameNoSpace = str_replace(" ", "+", $iconName);
            $EditIconLink = FreewheelFormat::EditIconLink($iconId, $iconName);
            $onMapDisplay = $onMap;
            if (1 == $isTrailHead)
                $onMapDisplay .= " is TrailHead";
            $msg .= rrwFormat::CellRowColor(
                $EditIconLink,
                $onMapDisplay,
                FreewheelFormat::milePost3($milePostPrefix, $milepost),
                $codeDescription,
                freewheeling_kml_common::displayLats($latitude),
                freewheeling_kml_common::displayLats($longitude),
                $sort,
                $iconId,
                $lineId
            );
        }
        $msg .= "</table>\n";
        return $msg;
    }
    public static function displayLats($item)
    {
        return number_format($item, freeWheel::latRoundTo, ".", "");
    }
    /**
     * Generates a SQL selection condition for Google items based on the given field.
     *
     * This method creates a SQL condition that checks if the given field starts with
     * either 'ChIJ' or 'EidD', which are prefixes commonly used in Google identifiers.
     */
    public static function selectOnlyGoogleId($field)
    {
        $sqlSelect = "(substring($field,1,4) = 'ChIJ' or
                        substring($field,1,4) = 'EidD')";
        return $sqlSelect;
    }
    public static function is_googleID($googleId)
    {
        $tmp = substr($googleId, 0, 4);
        if ($tmp == "ChIJ")
            return $googleId;
        else
            return false;
    }
    public static function is_trailId($id)
    {
        global $wpdbExtra, $rrw_trails;
        $sqlTrail = "select trId from $rrw_trails where trId = '$id'
                        or trName = '$id' ";
        $trId = $wpdbExtra->get_var($sqlTrail);
        if (empty($trId))
            return false;
        else
            return $trId;
    }
    /*
        public static function is_grpId($id)
        {
            global $wpdbExtra, $rrw_trail_routes;
            $sqlTrail = "select grpId from $rrw_trail_routes where grpId = '$id'
                            or grpName = '$id' ";;
            $grpId = $wpdbExtra->get_var($sqlTrail);
            if (empty($grpId))
                return false;
            else
                return $grpId;
        }
            */
    /*
        public static function is_lineId($id)
        {
            global $wpdbExtra, $rrw_lines;
            $sqlLine = "select lineId from $rrw_lines where lineId = '$id'
                            or lineName = '$id'";;
            $lineId = $wpdbExtra->get_var($sqlLine);
            if (empty($lineId))
                return false;
            else
                return $lineId;
        }
                */
    public static function is_iconId(&$id)
    {
        global $wpdbExtra, $rrw_icons;
        $sqlLine = "select iconId from $rrw_icons where iconId = '$id' ";
        $iconId = $wpdbExtra->get_var($sqlLine);
        if (empty($iconId))
            return false;
        else {
            $id = $iconId;
            return true;
        }
    }
    public static function is_iconName(&$id)
    {
        global $wpdbExtra, $rrw_icons;
        global $eol, $errorBeg, $errorEnd;
        $sqlLine = "select iconId from $rrw_icons where iconName = '$id' ";
        $iconId = $wpdbExtra->get_var($sqlLine);
        if (empty($iconId))
            return false;
        else {
            $id = $iconId;
            return true;
        }
    }
    public static function CompressCoords($itemCoords, &$outputMsg)
    {
        // the third output parameter is the pointList in lat lon order(not yet implemented)
        global $eol, $errorBeg, $errorEnd;
        $debug = rrwParam::Boolean("debug");
        if ($debug) $outputMsg .= "<strong>I#1741 CompressCoords before compress</strong> " .
            strlen($itemCoords) . "$eol "; //"'$itemCoords' $eol";
        $coords = str_replace("  ", " ", $itemCoords);
        $coords = explode(" ", $coords); # break into lat,lon,elv groups
        $seq = 0;
        if (count($coords) < 1) {
            $outputMsg .= "E#1752 CompressCoords: there are no points for line number data  '$itemCoords$eol' ";
            return false; # therefore can out update, may want to consider a delete
        }
        $pointList = "";
        $coordPast = "200.,200,0 "; // something that will never match
        $cntDuplicates = 0;
        foreach ($coords as $coord) {
            $coord = trim($coord);
            if (empty($coord))
                continue;
            $points = explode(",", $coord);
            $coord = self::displayLats($points[0]) . "," . self::displayLats($points[1]) . ",0 ";
            //	 $msg .= "I#1760 compare '$coordPast', '$coord' $eol";
            if ($coordPast == $coord || empty($coord)) {
                $cntDuplicates++;
                continue; // remove duplicate coords
            }
            $pointList .= $coord;
            $coordPast = $coord;
        }
        $pointList = trim($pointList);
        if ($debug) {
            $outputMsg .= "removed $cntDuplicates duplicates $eol <strong>I654 CompressCoords after compress length is </strong> " .
                strlen($pointList) . "$eol"; //  '$pointList' $eol
            //       ================================================ $eol";
        }
        return $pointList;
    } // end CompressCoords
} // end class freewheeling_kml_common
