<?php
/*     Freewheeling Easy Mapping Application
 *
 *		A collection of routines for display of trail maps and amenities
 *
 *		copyright Roy R Weil 2019 - https://royweil.com
 *
 */
/*	function to determine distance and direction between tow points
 *	result is entered nto the amenities database.
 *
 *	shoveDistance ($bizId, $iconName, $iconLat, $iconLng, $bizLat, $bizLng)
 *				Update the business "metersFrom trail"
 *	shoveDuration($iconName, $iconLat, $iconLng, $bizLat, $bizLng, $bizName = ""){
 *				Update the icon "metersFrom Pitt and  minutesFromPitt "
 *	getGoogleRoute ($iconLat, $iconLng, $iconMilepost, $bizLat, $bizLng,  $bizId, $mode,
 *						$debugDistance, milePostDirection
 *				Calculates  distance, direction, time, route between points, ignore on trail distance
 *				returns list($msgTemp, $data)
 *	distanceMeters($lat1, $lon1, $lat2, $lon2)
 *				meters between two points
 *	newPoint($start_latitude, $start_longitude, $angle, $distance
 *				return lat,lon of a point angle,dist from origin
 */
require_once "olc.php";
require_once "polyline_inc.php";
class freewheelingeasy_edit_shove
{
    private static $listOfTrailSegments = array(
        "Armstrong.* Trail<",
        "Bayfront Bikeway",
        "BicyclePA Rte",
        "Chesapeake and Ohio Canal Towpath",
        "Depot St Spur",
        "New York State Bicycle Rte",
        "NY-5 W",
        "pedestrian overpass",
        "Rails-To-Trails",
        "Sligo Branch Line",
        " on .* Trail System ",
        " on .* Trail ",
        " onto .* Trail ",
        " toward .* Trail ",
    );
    private static $listOfNonTrailSegments = array(
        "toward Appalachian",
    );
    static public function latLonMoved($iconId = "")
    {   //  update calculated values in the point record
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $debugLatLonMoved = rrwParam::Boolean("debugLatLonMoved");
        try {
            if (rrwUtil::isTimeUp(freewheelingEasy_fix_Class::$checkLoopingTimeOut)) {
                $msg .= rrwUtil::TimeUpMessage(
                    "E#1816",
                    " in latLonMoved($iconId) ",
                    ""
                );
                throw new Exception($msg);
            }
            if ($debugLatLonMoved) $msg .= "E#1817 latLonMoved( $iconId ) $eol";
            if (empty($iconId)) {
                return "$errorBeg E#1808 conId is empty in the latLonMoved routine $errorEnd";
            } elseif (is_numeric($iconId)) {
                $sqlWhere = " where iconId = $iconId ";
            } elseif ("all" == $iconId) {
                $msg .= rrwFormat::backtrace("$errorBeg E#1818 latLonMoved called with iconId = $iconId  $errorEnd");
                throw new Exception($msg);
            } else {
                throw new Exception("$msg $errorBeg E#1819 unknown point of '$iconId' $errorEnd");
            }
            $sqlEmpty = "update $wpdbExtra->icons set iconPoint = Point(latitude, longitude), plusCode = null,
                                minutesFromPgh = null $sqlWhere";
            $cnt = $wpdbExtra->query($sqlEmpty);   // reset the point so the following will do something
            // $msg .= "$errorBeg I#1825 reset iconPoint $iconId, and nulled  minutes from Pittsburgh, plusCode $sqlEmpty $errorEnd";
            $sqlPlus = "select latitude, longitude, iconName, iconId from $wpdbExtra->icons
            where plusCode is null or minutesFromPgh = null";
            $recsPlus = $wpdbExtra->get_resultsA($sqlPlus);
            if ($debugLatLonMoved) $msg .= "I#1802 found " . $wpdbExtra->num_rows . " points  to update with $sqlPlus $eol";
            $cntUpdated = 0;
            foreach ($recsPlus as $recPlus) {
                if (rrwUtil::isTimeUp(freewheelingEasy_fix_Class::$checkLoopingTimeOut)) {
                    $msg .= rrwUtil::TimeUpMessage(
                        "E#1820",
                        " in latLonMoved($iconId) ",
                        ""
                    );
                    throw new Exception($msg);
                }
                $latitude = $recPlus["latitude"];
                $longitude = $recPlus["longitude"];
                $iconId = $recPlus["iconId"];
                $iconName = $recPlus["iconName"];
                if (0 == $latitude || 0 == $longitude) {
                    $link = freeWheelFormat::EditIconLink($iconId, $iconName);
                    $msg .= "$errorBeg E#1821 point $link has latitude $latitude, longitude $longitude $errorEnd";
                } else {
                    // ---------------------------------------------------------------  update plusCode
                    $plusCodeCalculated = OpenLocationCode::encode($latitude, $longitude);
                    $updateSql = " set plusCode = '$plusCodeCalculated', ";
                    // ---------------------------------------------------------------  update icon point
                    $updateSql .= " iconPoint = Point($latitude, $longitude), ";
                    // ---------------------------------------------------------------  update meters/tim from pitt
                    $pittLat = 40.441621;
                    $pittLng = -80.00659;
                    try {   // incase getGoogleRoute fails
                        if ($debugLatLonMoved) $msg .= "I#1826 iconId = $iconId, $iconName, $latitude, $longitude, $pittLat, $pittLng $eol";
                        $data = getGoogleRoute($latitude, $longitude, $pittLat, $pittLng, $iconName, "driving", $msg, "latLonMoved"); // Direction does not matter here
                        $updateSql .= " minutesFromPgh = " . $data["minutesFromPgh"];
                        // ---------------------------------------------------------------  update the database
                        $updateData = "update $wpdbExtra->icons $updateSql where iconId = $iconId ";
                        //                  $msg .= "$updateData $eol";
                        if ($debugLatLonMoved) $msg .= "I#1827 $updateData $eol";
                        $cnt = $wpdbExtra->query($updateData);
                        $cntUpdated++;
                    } catch (Exception $ex) {
                        $msg .= "$errorBeg E#1822 " . $ex->getMessage() . $eol;
                        throw new Exception($msg);
                    }
                } //
            } // end foreach
            if (0 < $cntUpdated)
                if ($debugLatLonMoved) $msg .= "I#1833 moved $cntUpdated to match up with the lines $eol";
            return $msg;
        } catch (Exception $ex) {
            throw new Exception("$msg $errorBeg " . $ex->getMessage() . $errorEnd);
        }
    } // end latLonMoved
    public static function isLeg_a_trailSegment($html)
    {
        global $wpdbExtra;
        // return true if leg is part of the trail
        if (count(self::$listOfTrailSegments) < 100) {        //  have we added the list of trail names yet
            $sql = "select trName from $wpdbExtra->trails
                        union
                    select grpName from $wpdbExtra->trail_routes where not grpName like '%on-road%' ";
            $recs = $wpdbExtra->get_resultsA($sql);           // get the list of trail names
            foreach ($recs as $rec) {
                self::$listOfTrailSegments[] = $rec["trName"];  // add the trail names to the list
            }
            //  print rrwUtil::print_r(self::$listOfTrailSegments, true, "listOfTrailSegments");
        }
        foreach (self::$listOfNonTrailSegments as $match) { // if any of these are found then it is not a trail segment
            $match = "!^.*$match.*$!";
            if (preg_match($match, $html) == 1)
                return false;
        }
        foreach (self::$listOfTrailSegments as $match) { // if any of these are found then it is a trail segment
            $match = "!^.*$match.*$!";
            if (preg_match($match, $html) == 1) {
                //         print "$eol On trail because $match - in - $html ";
                return true;
            }
        }
        return false;
    }
} // end class freewheelingeasy_edit_shove
class freewheeling_calculations
{
    /*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
    /*::                                                                         :*/
    /*::  This routine calculates the distance between two points (given the     :*/
    /*::  latitude/longitude of those points). It is being used to calculate     :*/
    /*::  the distance between two locations using GeoDataSource(TM) Products    :*/
    /*::                                                                         :*/
    /*::  Definitions:                                                           :*/
    /*::    South latitudes are negative, east longitudes are positive           :*/
    /*::                                                                         :*/
    /*::  Passed to function:                                                    :*/
    /*::    lat1, lon1 = Latitude and Longitude of point 1 (in decimal degrees)  :*/
    /*::    lat2, lon2 = Latitude and Longitude of point 2 (in decimal degrees)  :*/
    /*::    unit = the unit you desire for results                               :*/
    /*::           where: 'M' is statute miles (default)                         :*/
    /*::                  'K' is kilometers                                      :*/
    /*::                  'N' is nautical miles                                  :*/
    /*..				  'X' is meters
/*..				  ''
/*::  Worldwide cities and other features databases with latitude longitude  :*/
    /*::  are available at https://www.geodatasource.com                          :*/
    /*::                                                                         :*/
    /*::  For enquiries, please contact sales@geodatasource.com                  :*/
    /*::                                                                         :*/
    /*::  Official Web site: https://www.geodatasource.com                        :*/
    /*::                                                                         :*/
    /*::         GeoDataSource.com (C) All Rights Reserved 2018                  :*/
    /*::                                                                         :*/
    /*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
    public static function distanceMeters($lat1, $lon1, $lat2, $lon2, $debugMeters = false)
    {
        global $meters2Mile;
        global $eol, $errorBeg, $errorEnd;
        if (($lat1 == $lat2) && ($lon1 == $lon2)) {
            if ($debugMeters) print "points are equal $eol";
            return 0;
        }
        if (is_string($lat1)) $lat1 = (float)($lat1);
        if (is_string($lon1)) $lon1 = (float)($lon1);
        if (is_string($lat2)) $lat2 = (float)($lat2);
        if (is_string($lon2)) $lon2 = (float)($lon2);
        if ($debugMeters) print "distanceMeters( $lat1, $lon1, $lat2, $lon2 ) $eol";
        $theta = $lon1 - $lon2;
        if ($debugMeters) print "theta is $theta, ";
        $arcAngle = (sin($lat1 * M_PI / 180) * sin($lat2 * M_PI / 180)) +
            (cos($lat1 * M_PI / 180) * cos($lat2 * M_PI / 180) * cos($theta * M_PI / 180));
        if ($debugMeters) print " arcAngle is $arcAngle ";
        $miles = acos($arcAngle);
        $miles = rad2deg($miles);
        //    }
        $miles = $miles * 60.0 * 1.1515;
        $meters = $miles * $meters2Mile;
        if ($debugMeters) print "miles is $miles,  meters2Mile is $meters2Mile, meters is $meters";
        if (is_nan($meters)) {
            if ($debugMeters) print " meters is nan $eol";
            $meters = $theta * 60 * 1.1515 * $meters2Mile;
        }
        if ($debugMeters) print " meters final = $meters $eol ";
        return $meters;
    }  // end function distanceMeters
} // end class freewheeling_calculations
function distanceMeters($lat1, $lon1, $lat2, $lon2, $debugMeters = false)
{
    return freewheeling_calculations::distanceMeters($lat1, $lon1, $lat2, $lon2, $debugMeters);
}
function getGoogleRoute($iconLat, $iconLng, $bizLat, $bizLng, $bizId, $mode, &$msg, $whereFrom): array
{
    global $eol, $errorBeg, $errorEnd;
    /* asks google for a route between two points
        * verifies that google returned one route with legs
        * rejects trail legs at the front of the list
        * accumulates the distance and time of the legs
        * uses the legs to calculate the distance and time and polyline
        * returns the distance, time, and route polyline
     */
    try {
        $debugRoute = rrwParam::isDebugMode("debugRoute"); //  rrwParam::Boolean("debugRoute", array(), false);
        $OutputArray = array();
        $OutputArray["error"] = 0;
        if ($debugRoute) {
            $msg .= "into getGoogleRoute ( $iconLat, $iconLng, $bizLat, $bizLng,$eol";
            $msg .= " getGoogleRoute( $iconLat, $iconLng, $bizLat, $bizLng, $mode ) $eol";
        }
        $routeData = getGooglesVersionOfRoute($iconLat, $iconLng, $bizLat, $bizLng, $mode, $msg);
        if ($debugRoute) {
            //  $msg .= rrwUtil::print_r($routeData, true, "I$754 #route data as delivered from getGooglesVersionOfRoute");
        }
        if (array_key_exists("routes", $routeData)) {
            $legs = $routeData["routes"][0]["legs"];
        } else {
            $link1 = "https://maps.google.com/maps/dir/$iconLat,$iconLng/$bizLat,$bizLng";
            $msg .= "$errorBeg E#1823 No route found for point at
				$iconLat, $iconLng, $bizId at $bizLat, $bizLng <a href='$link1' target='route' >map route</a>$errorEnd " .
                rrwUtil::print_r($routeData, true, "Route data");
            throw new Exception("$msg");
        }
        // now remove the trail legs at the front of the list that are rail segments
        if ($debugRoute) $msg .= rrwUtil::print_r($legs, true, "I#1828 initial found legs of this route before removal front trail legs");
        while (count($legs) > 0) {
            if ($debugRoute) {
                //  $msg .= rrwUtil::print_r($legs["steps"][0], true, "I#1829 current first leg of the route");
                //   $msg .= rrwUtil::print_r($legs[0], true, "I#1062 legs[0] of this route");
                //   $msg .= rrwUtil::print_r($legs[0]["steps"], true, "I#1650 legs[0][\"steps\"] of this route");
                $msg .= rrwUtil::print_r($legs[0]["steps"][0], true, "I#1830 legs[0][\"steps\"][0] of this route");
            }
            if (count($legs[0]["steps"]) == 0) {
                $msg .= "$errorBeg E#1824 No steps in the legs of this route $errorEnd";
                $msg .= rrwUtil::print_r($legs, true, "legs data");
                $OutputArray["error"] = 587;
                break;
            }
            $startLat = $legs[0]["steps"][0]["start_location"]["lat"];
            $startLng = $legs[0]["steps"][0]["start_location"]["lng"];
            $html = $legs[0]["steps"][0]["html_instructions"];
            $html = freewheelingRemoveTags($html);
            if (freewheelingeasy_edit_shove::isLeg_a_trailSegment($html)) {
                if ($debugRoute) $msg .= "I#1831 $html is a trail segment remove it and try again $eol";
                $startLat = $legs[0]["steps"][0]["end_location"]["lat"];
                $startLng = $legs[0]["steps"][0]["end_location"]["lng"];
                if ($debugRoute) $msg .= "I#1800 Moved start lat lon to $startLat, $startLng  $eol";
                array_shift($legs[0]["steps"]);
            } else {
                if ($debugRoute) $msg .= "I#1801 we are done this is $html "; //    array_shift($legs);
                break;
            }
            break;
        } // end while ( count( $legs ) > 0 )
        if ($debugRoute) $msg .= rrwUtil::print_r($legs, true, "I#1067 after remove of steps of this route");
        if (count($legs) != 1) {
            $msg .= "$errorBeg E#1832 There is more than one legs to this route $errorEnd";
            $msg .= " getGooglesVersionOfRoute( $iconLat, $iconLng, $bizLat, $bizLng, $mode,$msg)$eol";
            $msg .= rrwUtil::print_r($legs, true, "legs data");
            $OutputArray["error"] = 588;
        }
        if ($debugRoute) $msg .= "I#1803 Moved before distanceOfLegs to $startLat, $startLng, $eol";
        $result = distanceOfLegs($legs, $iconLat, $iconLng, $msg, $debugRoute);
        if ($debugRoute) $msg .= "I#1804 getGoogleRoute:Moved after distanceOfLegs to $startLat, $startLng, " . $result["startLat"] . $result["startLng"]  . $eol;
        if ($debugRoute) $msg .= rrwUtil::print_r($result, true, "after call to distance of legs");
        $routeMeters = $result["routeMeters"];
        $routeSeconds = $result["routeSeconds"];
        $trailMeters = $result["trailmeters"];
        //    $startLat = $result["startLat"];
        //    $startLng = $result["startLng"];
        $routePolyline = $result["routePolyline"];
        $routeLatLon = $result["routeLatLon"];
        $minutes = round($routeSeconds / 60, 0);
        $durationText = round(($routeSeconds / 60), 1) . " min";
        $startLat = trim($startLat);
        $startLng = trim($startLng);
        $bizLat = trim($bizLat);
        $bizLng = trim($bizLng);
        $maplink = "https://maps.google.com/maps/dir/$startLat,$startLng/$bizLat,$bizLng"; // w==> walking, there is no biking
        //  $msg .= "<a href='$maplink' target='map'> I#1834 along trail distance $trailMeters m,</a>\n";
        // get the point along the route
        $OutputArray["distanceMeters"] = $routeMeters;
        $OutputArray["trailmeters"] = $trailMeters;
        $OutputArray["minutesFromPgh"] = $minutes;
        $OutputArray["startLat"] = $startLat;
        $OutputArray["startLng"] = $startLng;
        $OutputArray["routePolyline"] = $routePolyline;
        $OutputArray["routeLatLon"] = $routeLatLon;
        $OutputArray["legs"] = rrwUtil::print_r($legs, true, "legs of this route");
        $OutputArray["steps"] = $result["steps"];
        $temp = "'bizId' =>'$bizId',";
        foreach ($OutputArray as $key => $value) {
            $temp .= "'$key'  =. '$value',";
        }
        $OutputArray["fix"] = $temp;
    } catch (Exception $ex) {
        throw new exception("$msg E#1805 " . $ex->getMessage() . $eol);
    }
    if ($debugRoute) $msg .= rrwUtil::print_r($OutputArray, true, "E#1068 final out from get Google Route");
    return $OutputArray;
}
function distanceOfLegs(
    $googleDirection,
    &$startLat,
    &$startLng,
    &$msg,
    $debugDistOfLegs = false  // not used replaced below
): array {
    // steps though the legs of the route and accumulates the distance and time
    // returns a result array that contains the route of rhe legs minus the intial on trail legs.
    // the result array contains the polyline and the latlon of the route
    // called from getGoogleRoute
    global $eol, $errorBeg, $errorEnd;
    $routeMeters = 0;
    $routeSeconds = 0;
    $trailSeconds = 0;
    $leg = $googleDirection[0];
    $cntLegs = 0;
    $trailmeters = 0;
    $steps = "";
    $routeCoords = array();
    $debugDistOfLegs = rrwParam::Boolean("debugDistOfLegs", array(), false);
    $debugPolyLine =  rrwParam::Boolean("debugStartPoint", array(), false);
    $debugStartPoint = rrwParam::Boolean("debugStartPoint", array(), false);
    //  $msg .= rrwUtil::print_r( $googleDirection, true, "first step" );
    $OnTrailLegOkay = true;  // trail legs can only be permitted at start
    foreach ($leg["steps"] as $step) {
        $cntLegs++;
        if ($debugStartPoint) $msg .= rrwUtil::print_r($step, true, "step #$cntLegs");
        if ($cntLegs == 1 &&  $OnTrailLegOkay) {
            // accert the first step has data. if not then following get error???
            $startLat = $step["start_location"]["lat"];
            $startLng = $step["start_location"]["lng"];
            $routeCoords = array();
            if ($debugStartPoint) $msg .= "saving first startLat $startLat, $startLng on step #$cntLegs $eol";
        }
        $html = $step["html_instructions"];
        $html = freewheelingRemoveTags($html);
        $steps .= "Step #$cntLegs instructions: '$html', step distance " .
            $step["distance"]["value"] . ", startpoint is
            $startLat - " . $step["start_location"]["lat"] . ", " .
            $step["start_location"]["lng"] . " ... ";
        $tempPoly = $step["polyline"]["points"];
        if ($OnTrailLegOkay && freewheelingeasy_edit_shove::isLeg_a_trailSegment($html)) {
            $steps .= "On Trail $eol ";
            if ($debugDistOfLegs) $msg .= "$eol segment mode - on trail -- $html";
            $trailmeters += $step["distance"]["value"];
            $trailSeconds += $step["duration"]["value"];
            $routeCoords = array();                     // start line over
            $startLat = $step["end_location"]["lat"];
            $startLng = $step["end_location"]["lng"];
            if ($debugStartPoint || $debugDistOfLegs) $msg .= "saving end startLat $startLat, $startLng on step #$cntLegs $eol";
        } else {
            $OnTrailLegOkay = false;
            $steps .= " On road or walk $eol";
            if ($debugPolyLine) $msg .= rrwUtil::print_r($tempPoly, true, "tempPoly ");
            // append this step to the accumulated so far
            $routeCoords = array_merge($routeCoords, Polyline::decode($tempPoly));
            if ($debugPolyLine) $msg .= rrwUtil::print_r($routeCoords, true, "routecoordinates ");
            $routeMeters += $step["distance"]["value"]; // route distance in meters]
            $routeSeconds += $step["duration"]["value"];
        }
        if ($debugDistOfLegs) $msg .= "end of $steps $eol";
    } // end forforeach ( $leg[ "steps" ] as $step )
    $linecords = "";
    for ($ii = 0; $ii < count($routeCoords); $ii = $ii + 2) {
        $lat = $routeCoords[$ii];
        $lon = $routeCoords[$ii + 1];
        $linecords .= "$lon,$lat,0 ";
    }
    if ($debugPolyLine) $msg .= "output " . count($routeCoords) / 2 . " coordinate triples$eol";
    $result = array(
        "startLat" => $startLat,
        "startLng" => $startLng,
        "trailmeters" => $trailmeters,
        "routeMeters" => $routeMeters,
        "routeSeconds" => $routeSeconds,
        "steps" => $steps,
    );
    if ($debugStartPoint) $msg .= "oputputting startLat $startLat, $startLng on step #$cntLegs $eol";
    if ($debugDistOfLegs) $msg .= rrwUtil::print_r($result, true, "distanceOfLegs result");
    $result["routePolyline"] = Polyline::encode($routeCoords);
    $result["routeLatLon"] = $linecords;
    if ($debugPolyLine) $msg .= "result['routePolyline'] = $routeCoords $eol";
    return $result;
}
function freewheelingRemoveTags($buffer)
{
    // remove the <  > items from the buffer
    // and turn into non html text
    global $eol, $errorBeg, $errorEnd;
    $debugremoveTag = false;
    $iiOpen = strpos($buffer, "<");
    $cnt = 0;
    while ($iiOpen !== false) {
        if ($debugremoveTag) print "freewheelingRemoveTags:before:
                                    " . htmlspecialchars($buffer, ENT_QUOTES) . "<br/>";
        $cnt++;
        if ($cnt > 50)
            throw new Exception("$errorBeg E#1806 too many timea around remove tags                              $errorEnd");
        $iiClose = strpos($buffer, ">", $iiOpen);
        if ($debugremoveTag) print "freewheelingRemoveTags: open, close  $iiOpen, $iiClose<br/> ";
        if ($iiClose === false) {
            throw new Exception("$errorBeg E#1807 did not fnd cllosing > in html
                $errorEnd $iiOpen, $iiClose $eol 123456789012345678901234567890 $eol
                " . htmlspecialchars($buffer, ENT_QUOTES) . $eol);
        }
        $buffer = substr($buffer, 0, $iiOpen) . substr($buffer, $iiClose + 1);
        if ($debugremoveTag) print "freewheelingRemoveTags:after: " . htmlspecialchars($buffer, ENT_QUOTES) . "<br/>";
        $iiOpen = strpos($buffer, "<");
        if ($debugremoveTag) print "freewheelingRemoveTags: open  $iiOpen<br/> ";
    }
    $buffer = htmlspecialchars($buffer, ENT_QUOTES);
    return $buffer;
}
function freewheeling_removeTagItem($buffer, $searchItem)
{
    // find the search item which is th e middle of a tag remove the tag
    // wf the tag is a <a then go aftr the <.a> as well
    // iimiddle points to the middle of an html tag
    // find the two ends  <  > and remove all between
    global $eol, $errorBeg, $errorEnd;
    $msg = "";
    $debugRemove = false;
    $iimiddle = strpos($buffer, $searchItem);
    $cntFound = 0;
    while ($iimiddle > 1) {
        $cntFound++;
        if ($cntFound > 10)
            throw new Exception("$msg $errorBeg E#1809 too many tags found $errorEnd");
        $iiEnd = strpos($buffer, ">", $iimiddle);
        $iiStart = strrpos($buffer, "<", $iimiddle - strlen($buffer));
        if ($debugRemove) {
            $msg .= "removeTagItem:firstLook:$iiStart:$iiEnd: $eol";
            //      return array($msg,$buffer);
        }
        if ($debugRemove) print "   if ( $iiEnd - $iiStart > 100 || $iiEnd < $iiStart ) ";
        if ($iiEnd - $iiStart > 130 || $iiEnd < $iiStart) {
            print("iiEnd == $iiEnd");
            print("iiStart == $iiStart");
            $temp2 = $iiEnd - $iiStart;
            print("iiEnd - iiStart == $temp2");
            $temp = "$msg  $errorBeg E#1810 range to long in
                                freewheeling_removeTagItem $temp2 greater than 100";
            $x = 1;
            print $temp
                . substr($buffer, $iiStart - 20, 80) . $errorEnd;
            throw new Exception($temp);
        }
        if ($debugRemove) $msg .= "removeTagItem:before:$iiStart:$iiEnd: " .
            htmlspecialchars(substr($buffer, $iiStart - 5, $iiEnd - $iiStart + 20), ENT_QUOTES) . $eol;
        $removeThing1 = substr($buffer, $iiStart, 2);
        $removeThing2 = substr($buffer, $iiStart, 10);
        $buffer = substr($buffer, 0, $iiStart) . substr($buffer, $iiEnd + 1);
        if ($debugRemove) $msg .= "removeTagItem:after:$iiStart:$iiEnd: " .
            htmlspecialchars(substr($buffer, $iiStart - 5, $iiEnd - $iiStart + 20), ENT_QUOTES) . $eol;
        if ($removeThing1 == "<a") {
            $iiStart = strpos($buffer, "<", $iiStart);
            $iiEnd = strpos($buffer, ">", $iiStart);
            $buffer = substr($buffer, 0, $iiStart) . substr($buffer, $iiEnd + 1);
        }
        if ($removeThing2 == "<!-- start") {
            $iiEnd = strpos($buffer, "<-- end", $iiStart);
            $iiEnd = strpos($buffer, ">", $iiEnd);
            $buffer = substr($buffer, 0, $iiStart) . substr($buffer, $iiEnd + 1);
        }
        if ($debugRemove) $msg .= "removeTagItem:final:$iiStart:$iiEnd: " .
            htmlspecialchars(substr($buffer, $iiStart - 5, $iiEnd - $iiStart + 20), ENT_QUOTES) . $eol;
        if ($debugRemove) $msg .= $eol;
        $iimiddle = strpos($buffer, $searchItem, $iiEnd);
    }
    return array($msg, $buffer);
} // End Function freewheeling_removeTagItem
function getGooglesVersionOfRoute($iconLat, $iconLng, $bizLat, $bizLng, $mode, &$msg)
{
    global $eol, $errorBeg, $errorEnd;
    if (freeWheeling_edit_setGlobals::notAllowedToEdit("getGooglesVersionOfRoute")) {
        $msgErr = "$errorBeg E#1811 You need to login to perform this task $errorEnd ";
        throw new Exception($msgErr);
    }
    try {
        $url = "https://maps.googleapis.com/maps/api/directions/json";
        $url .= "?origin=$iconLat,$iconLng";
        $url .= "&destination=$bizLat,$bizLng";
        $url .= "&mode=$mode&units=imperial";
        //    if ( freeWheeling_edit_setGlobals::notAllowedToEdit("getGooglesVersionOfRoute") )
        //        throw new Exception( "$errorBeg E#1047 getGooglesVersionOfRoute permission has not been granted. Are you logged in? $errorEnd" );
        freewheelAPI_2025::appendApiKeyToUrlWithDate($url);
        //    print "$url $eol";
        $routeJson = rrwUtil::fetchURLcontents($url, "", 120);
        if (strpos($routeJson, '"status" : "OK"') === false) {
            $msg .= "$errorBeg getGooglesVersionOfRoute: E#1812 while asking for directions between
				icon $iconLat, $iconLng and location $bizLat, $bizLng $eol
				$url $eol ====== result $routeJson $errorEnd";
            $msg .= rrwFormat::backTrace(" in getGooglesVersionOfRoute");
            throw new Exception("E#1813 No route found for point at $iconLat, $iconLng, $bizLat, $bizLng");
            return array(); // return an empty array - no route found
        }
        //	$msg .= "$placesJson $eol";
        $route = json_decode($routeJson, true);
    } catch (Exception $ex) {
        throw new exception("$errorBeg " .  $ex->getMessage() . " getGooglesVersionOfRoute($iconLat, $iconLng, $bizLat, $bizLng, $mode, '') $errorEnd");
    }
    return $route;
}
function GetMilesRoute($lat1, $lng1, $lat2, $lng2)
{
    global $meters2Mile;
    $msg = "";
    list($msg, $route) = getGooglesVersionOfRoute($lat1, $lng1, $lat2, $lng2, "bicycling", $msg);
    $meters = $route["routes"][0]["legs"][0]["distance"]["value"];
    $temp = ", $meters meters, " . round($meters / $meters2Mile, 2) . "miles";
    $dist = $route["routes"][0]["legs"][0]["distance"]["text"] . $temp;
    $steps = $route["routes"][0]["legs"][0]["steps"];
    return array($msg, $steps, $dist);
}
/**
 * Calculate the initial bearing (forward azimuth) between two geographic points.
 *
 * @param float $lat1, lat1 - Latitude, Longitude of the starting point in decimal degrees.
 * @param float $lat2, lat2 - Latitude ,Longitudeof the destination point in decimal degrees.
 * @return float Initial bearing in degrees from north.
 */
function freewheeling_mapping_bearing($lat1, $lon1, $lat2, $lon2): float
{
    global $eol;
    // θ = atan2( sin Δλ ⋅ cos φ2 , cos φ1 ⋅ sin φ2 − sin φ1 ⋅ cos φ2 ⋅ cos Δλ )
    $angleHeading1 = (rad2deg(atan2(
        sin(deg2rad($lon2) - deg2rad($lon1)) *
            cos(deg2rad($lat2)),
        cos(deg2rad($lat1)) * sin(deg2rad($lat2)) - sin(deg2rad($lat1)) * cos(deg2rad($lat2)) *
            cos(deg2rad($lon2) - deg2rad($lon1))
    )));
    $angleHeading = fmod($angleHeading1 + 360.0, 360.0);   // normalize to 0..360
    // print "bearing from $lat1, $lon1 to $lat2, $lon2 is $angleHeading1 or $angleHeading degrees $eol";
    return intval($angleHeading);
}
function CompassFromLatitude($lat1, $lon1, $lat2, $lon2)
{
    $bearing1 = freewheeling_mapping_bearing($lat1, $lon1, $lat2, $lon2);
    return getCompassDirection($bearing1);
}
function getCompassDirection($bearing)
{
    $tmp = round($bearing / 22.5);
    switch ($tmp) {
        case 0:
            $direction = "N";
            break;
        case 1:
            $direction = "NNE";
            break;
        case 2:
            $direction = "NE";
            break;
        case 3:
            $direction = "ENE";
            break;
        case 4:
            $direction = "E";
            break;
        case 5:
            $direction = "ESE";
            break;
        case 6:
            $direction = "SE";
            break;
        case 7:
            $direction = "SSE";
            break;
        case 8:
            $direction = "S";
            break;
        case 9:
            $direction = "SSW";
            break;
        case 10:
            $direction = "SW";
            break;
        case 11:
            $direction = "WSW";
            break;
        case 12:
            $direction = "W";
            break;
        case 13:
            $direction = "WNW";
            break;
        case 14:
            $direction = "NW";
            break;
        case 15:
            $direction = "NNW";
            break;
        case 16:
            $direction = "N";
            break;
        default:
            $direction = "unknown";
    }
    return "$direction";
}

function destinationPoint($lat, $lon, $bearing, $distMiles)
{
    // $dist = miles
    // $brng = degrees
    global $meters2Mile;
    $meters = $distMiles * $meters2Mile; // distance in meters
    $degree = deg2rad($bearing);
    $dx = $meters * cos($degree);
    $dy = $meters * sin($degree);
    $dlon = $dx / 11320 * cos(deg2rad($lon));
    $dlat = $dy / 110540;
    $lonFinal = $lon + $dlon;
    $latFinal = $lat + $dlat;
    return array($latFinal, $lonFinal);
}
function getIconNameFromlatlon($latitude, $longitude)
{
    global $wpdbExtra, $rrw_icons;
    global $eol, $errorBeg, $errorEnd;
    $debugIconFromLat = true;
    $msg = "";
    $sql = "select iconName, iconId, ST_Distance(Point($latitude, $longitude), iconpoint) distDegrees from $rrw_icons
			order by ST_Distance(Point($latitude, $longitude), iconpoint) asc limit 1";
    $recsIcons = $wpdbExtra->get_results($sql, ARRAY_A);
    if ($debugIconFromLat) $msg .= " $sql ";
    foreach ($recsIcons as $recsIcon) {
        $iconName = $recsIcon["iconName"];
        $iconId = $recsIcon["iconId"];
        $distDegrees = $recsIcon["distDegrees"];
    }
    if ($debugIconFromLat) $msg .= " - $iconName, $iconId $eol ";
    return array($iconName, $iconId, $msg, $distDegrees);
}
