<?php
/*
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.com
 *
 *
 *  Search through one or all documents
 * do a find various database items and update the database
 *      oldest date
 *      version text
 * Author: Roy Weil
 * LICENSE
 */
class freewheelingeasy_kml_book_date
{

    public static function DateFormat($aDate, $debugDateFormat = false)
    {
        // accept in format   M/YYYY  or  D mmm YYYY
        // return  YYYY-MM-DD or bad format "2001-10-10"
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        if ($debugDateFormat) print " DateFormat input  '" . htmlspecialchars($aDate, ENT_QUOTES) . "'  ---- ";
        $aDate = str_replace(".", " ", $aDate);
        $aDate = str_replace("</p>", " ", $aDate);
        $aDate = trim($aDate);
        if (empty($aDate)) {
            return "2001-11-11";
        } elseif (false !== strpos($aDate, "2002 edi")) {
            return "2002-06-01";
        } elseif (false !== strpos($aDate, "/")) {
            $oldestArray = explode("/", $aDate); // assume  m/Y
            if (1 == strlen($oldestArray[0]))
                $oldestArray[0] = "0" . $oldestArray[0];
            return $oldestArray[1] . "-" . $oldestArray[0] . "-01";
        }
        $tempDate = new DateTime($aDate);
        $finalDate = $tempDate->format("Y-m-d");
        if ($debugDateFormat) print " date out " . $finalDate . $eol;
        return $finalDate;
    }
    /*

        //    $aDate = str_replace( ".", "", $aDate );
        $iiSlash = strpos($aDate, "/");
        if (false !== $iiSlash) {
            $oldestArray = explode("/", $aDate);
            if (1 == strlen($oldestArray[0]))
                $oldestArray[0] = "0" . $oldestArray[0];
            $finalDate = $oldestArray[1] . "-" . $oldestArray[0] . "-01";
        } else
            $tempDate = new DateTime($finalDate);
        $finalDate = $tempDate->format("Y-m-d");
        if ($debugDateFormat) print " date out " . $finalDate . $eol;
        return $finalDate;
    }
    */
    public static
    function bookDate($attr)
    {
        global $eol, $errorBeg, $errorEnd;
        global $pageCnt;
        $msg = "";
        try {
            $_GET['nohead'] = true;
            $msg .= freeWheeling_edit_setGlobals::setGlobals("freewheelingeasy kml book date");
            $msg .= freewheeling_edit_create_views("at freewheelingeasy kml book date", true);
            global $pageCnt;
            $pageCnt = 0;
            $msg .= "
<style>
.pageBreak {
    page-break-after: always;
    break-before: always;
    font-size: 16px;
	}
tr {
    page-break-inside:avoid;
}
.highlightText {
	background-color: BurlyWood ;
}
</style>
";
            $msg .= "<table>";
            $msg .= freewheelingeasy_kml_book_date::PrintBookDates(
                "Volume - North East - Trails",
                "N-algy-riv",
                "E-con-vy",
                false
            );
            $msg .= freewheelingeasy_kml_book_date::PrintBookDates(
                "Not in Book -out of Range or headings",
                "E-con-vy5",
                "",
                false
            );
            $msg .= freewheelingeasy_kml_book_date::PrintBookDates(
                "Volume - West - Trails",
                "NW-Ohio",
                "SW-wva",
                true
            );
            $msg .= freewheelingeasy_kml_book_date::PrintBookDates(
                "Volume - South East - Trails",
                "ES-Gap",
                "",
                false
            );
            $msg .= freewheelingeasy_kml_book_date::PrintBookDates(
                "Volume - Near Pittsburgh - Trails",
                "nr-pit",
                "",
                false
            );
            $msg .= freewheelingeasy_kml_book_date::PrintBookDates("Volume - Not in the book", "not in book", "Road", false);
        } catch (Exception $ex) {
            $msg .= "$eol E#316 Exception " . $ex->getMessage() . $eol;
        }
        $msg .= freewheelingeasy_kml_book_date::PrintBookDates(
            "Paved Trails",
            "",
            "",
            true
        );
        $msg .= freewheelingeasy_kml_book_date::PrintBookDates("All Trails by Name", "%", "", false);
        $msg .= freewheelingeasy_kml_book_date::PrintBookDates("All Trails by Distance", "%", "", false);
        $msg .= "</table>";
        $msg .= "<div class='pagebreak'> \n";
        $msg .= self::missingSomething(
            "lastEdit = null or lastEdit = '000-00-00'",
            " Missing the last edit value"
        );
        $msg .= self::missingSomething(
            "oldestSegment < '2001-12-12' ",
            " Missing the oldestSegment value"
        );
        $msg .= "</div>";
        return $msg;
    }
    private static function missingSomething($sqlWhere, $title)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $sql = "select trid, trname,lastEdit,oldestsegment from $wpdbExtra->trails
                    join $wpdbExtra->html on trid = htmtrailId
                    where $sqlWhere order by trname";
        $recs = $wpdbExtra->get_resultsA($sql);
        $msg .= " <h1 > Versions $title </h1>
            <table>
            " . rrwFormat::HeaderRow("trail id", "trail Name", "lastEdit", "Oldest segement");
        foreach ($recs as $rec) {
            $msg .= rrwFormat::CellRow(
                $rec["trid"],
                $rec["trname"],
                $rec["lastEdit"],
                $rec["oldestsegment"]
            );
        }
        $msg .= "</table>\n";
        return $msg;
    }
    private static
    function PrintBookDates($sectionName, $sectionCode1, $sectionCode2, $dummy)
    {
        global $eol, $errorBeg, $errorEnd;
        global $pageCnt;
        global $wpdbExtra;
        $msg = "";
        $debugDate = false;
		$color = rrwUtil::colorSwap();
        if ($debugDate) $msg .= "book calc";
        if (strpos($sectionName, "Not") === false) {
            $pageBefore = true;
            $msg .= "
            <div class='pageBreak'>" .
                rrwFormat::CellRow("<h1> Versions for $sectionName </h1>");
        } else {
            $pageBefore = false;
            $msg .= "<h1  >Versions for $sectionName</h1>$eol";
        }
        $pageCnt++;
        // Reads the database.<br />
        // Displays latest version information for <br />.
        $trid = array();
        $trName = array();
        $trDoc = array();
        $trVol = array();
        $trDate = array();
        $trNorth = array();
        $trSouth = array();
        $trEast = array();
        $trWest = array();
        $monthPast = 0;
        $needVariables = "trId, trName, bookVolume, lastEdit,oldestSegment,VersionText,unknownCount,inddFileName, minutesFromPgh, floor(minutesFromPgh/ 15) timeGroup ";
        $sql = "select $needVariables
                from $wpdbExtra->trails tr
                join $wpdbExtra->html on trId = htmTrailId
                join $wpdbExtra->icons on trId = trailId
                where lastEdit is not null and lastEdit != '0000-00-00'
                and bookVolume like '$sectionCode1' ";
        if (strpos($sectionName, "aved") !== false) {
            $sql = "select $needVariables
                from $wpdbExtra->trails tr
                join $wpdbExtra->html on trid = htmtrailId
                join $wpdbExtra->icons on trId = trailId
                where not pavedmiles = 0 ";
            $paved = true;
        } else
            $paved = false;
        if (strlen($sectionCode2) > 0)
            $sql .= " or bookVolume = '$sectionCode2' ";
        if (strpos($sectionName, "Name") !== false) {
            $orderby = "name";
            $sql .= " order by trName, oldestSegment, lastEdit, trsequence  ";
        } elseif (strpos($sectionName, "Distance") !== false) {
            $orderby = "distance";
            $sql .= " order by floor(minutesfromPgh/ 15), oldestSegment, lastEdit, trsequence ";
        } else {
            $orderby = "date";
            $sql .= " order by oldestSegment, lastEdit, trSequence  ";
        }
        if ($debugDate) $msg .= "$sql $eol";
        $recs = $wpdbExtra->get_resultsA($sql);
        $cnt = 0;
        // $msg .= "<table>\n";
        $msg .= rrwFormat::CellHeaderSize(200, 10, 10, 10);
        $msg .= "<tr style='page-break-inside:avoid; ' >";
        $msg .= rrwFormat::cellHeader("Trail");
        $msg .= rrwFormat::cellHeader("Oldest");
        $msg .= rrwFormat::cellHeader("Edited");
        if ($paved)
            $msg .= rrwFormat::cellHeader("miles");
        else
            $msg .= rrwFormat::cellHeader("Unk");
        $msg .= rrwFormat::cellHeader("Travel");
        $msg .= rrwFormat::cellHeader("Version Text");
        $msg .= ("</tr>");
        $namePast = "Not Yet";
        $timeGroupPast = 0;
        $printdivideString = "\n\n<tr><td colspan='10'><hr></td></tr>\n";
        foreach ($recs as $rec) {
            $cnt++;
			$color = rrwUtil::colorSwap( $color );
            //		if ($cnt == 1) dump_r ($rec);
            $name = $rec["trName"];
            if ($namePast == $name)
                continue;
            $namePast = $name;
            $Vol = $rec["bookVolume"];
            $lastEdit = $rec["lastEdit"];
            $oldestSegment = $rec["oldestSegment"];
            $versionText = $rec["VersionText"];
            $unknowns = $rec["unknownCount"];
            if (0 == $unknowns)
                $unknowns = "";
            $trailId = $rec["trId"];
            $inddFileName = $rec["inddFileName"];
            if (empty($inddFileName))
                $nameDisplay = $name;
            else
                $nameDisplay = "<a href='https://freewheelingeasy.com/?bookname=$trailId'
                            target='namepage' >$name</a> ";

            $timePgh = $rec["minutesFromPgh"];
            $timeGroup = $rec["timeGroup"];
            $hour = floor($timePgh / 60);
            $min = $timePgh - ($hour * 60);
            $min = sprintf("%02d", $min);
            $travelTime = "$hour:$min";
            $ii = strpos($versionText, "Conditions");
            if ($ii > 0)
                $versionText = substr($versionText, 0, $ii);
            $versionText = self::highlightOlderDates($versionText, $inddFileName);

            $dateOld = date_create($oldestSegment);
            $now = date_create("now");
            $age = $now->diff($dateOld);
            $monthsOld = number_format($age->days / 30, 0);
            if ($monthsOld > 260)
                $monthsOld = "";

            $dateEdit = date_create($lastEdit);
            $now = date_create("now");
            $age = $now->diff($dateEdit);
            $monthsEdit =  number_format($age->days / 30, 0);
            if ($monthsEdit > 260)
                $monthsEdit = "";

            if ($timeGroupPast != $timeGroup && "distance" == $orderby)
                $msg .= rrwFormat::CellRow("<strong>over " . $timeGroup * 15 . "
                        minutes from Pittsburgh </strong> ");
            $timeGroupPast = $timeGroup;

            # ------------------------------------------------- $msg .=  the row os data
            $msg .= rrwFormat::CellRow($color,
                "style='page-break-inside:avoid; backgroundcolor=$color'",
                $nameDisplay,
                $monthsOld,
                $monthsEdit,
                $unknowns,
                $travelTime,
                $versionText
            );
        } // end 	while ($rec = odbc_fetch_array($recs) )
        //  $msg .= "</table>";
        if ($pageBefore)
            $msg .= "</div>
            "; // end pageBreak div
        return $msg;
    } // end function BookDates
    private static function highlightOlderDates($versionText, $inddFileName)
    {
        global $eol, $errorBeg, $errorEnd;
        // bold the $year text in the string $versionText if old
        if ("JihlightEnabler" == $inddFileName)
            $debugHighlight = true;
        else
            $debugHighlight = false;
        if (strlen($versionText) < 20)
            return $versionText; // supper short
        $iiSpace = strpos($versionText, " ", 9);
        if (false !== $iiSpace)
            $versionText = substr($versionText, $iiSpace); // remove edit date
        $versionText = str_replace("\n", " ", $versionText);
        $versionText = str_replace(
            "based on personal observation while",
            " ",
            $versionText
        );
        if ($debugHighlight) print "<br />-----$versionText ----
                            " . strlen($versionText) . ", <br />";
        $yearlimit = date("Y");
        for ($year = 1989; $year < $yearlimit; $year++) {
            $cnt = 0;
            $chrYear = chr($year);
            $iiYear = strpos($versionText, "$year");
            // print "$iiYear = strpos($versionText, $year););<br /> ";
            while (false !== $iiYear) {
                if ($debugHighlight) print "$iiYear = strpos($versionText, $year););<br /> ";
                $cnt++;
                if ($cnt > 10)
                    return $versionText . " termninated "; // goto next year
                if ("/" == substr($versionText, $iiYear - 1, 1)) {
                    if ($debugHighlight) print "format is mm/yyyy or <space>m/yyyy $eol";
                    $month = substr($versionText, $iiYear - 2, 1);
                    $month = rtrim($month);
                } else {
                    if ($debugHighlight) print "assume format mmm YYYY " . substr($versionText, $iiYear - 20, 24) . $eol;
                    if (substr($versionText, $iiYear - 4, 1) == " ")
                        $month = substr($versionText, $iiYear - 3, 3);
                    elseif (substr($versionText, $iiYear - 5, 1) == " ")
                        $month = substr($versionText, $iiYear - 4, 3);
                    else {
                        $month = 01;
                        print "$errorBeg E#337 month not three or four characters in '" . substr($versionText, $iiYear - 20, 24) . "', file $inddFileName $errorEnd'";
                    }
                    if (
                        " in" == $month || "ure" == $month || " to" == $month ||
                        "ive" == $month || " ; " == $month
                    )
                        $month = "01";
                }
                $dateString = "$year-$month-01";
                if ($debugHighlight) print "convert '$dateString' to date time $eol";
                $dateString = trim($dateString);
                try {
                    $itemDate = new DateTime($dateString);
                } catch (Exception $ex) {
                    print "$errorBeg E#514 bad date character #$iiYear in
                    '$dateString' file --  $inddFileName $errorEnd
                    $versionText $eol";
                    $itemDate = new DateTime("$year-01-01");
                }
                $dateCurrent = new DateTime();
                if ($debugHighlight) print $itemDate->format("Y-m") .
                    " - " . $dateCurrent->format("Y-m") . $eol;
                $age = $dateCurrent->diff($itemDate);
                $days = $age->format("%a");
                if ($debugHighlight) print "days --- $days  <br />";
                $monthsOld = floor($days / 30);
                if ($debugHighlight) print "monthsOld $monthsOld $eol";
                if ($monthsOld > 30) {
                    // highlight it
                    $span = "<span class='highlightText' >";
                    $iiStart = strlen($versionText) - $iiYear;
                    foreach (array(",", "biking", "bicycling", "Bicycled") as $lookfor) {
                        $iicomma = strrpos($versionText, $lookfor, -$iiStart);
                        if (false === $iicomma) {
                            if ($debugHighlight) print "not found $lookfor $eol";
                            continue;
                        }
                        $iicomma = $iicomma + strlen($lookfor);
                        break;
                    }
                    if (false === $iicomma)
                        $iicomma = $iiYear - 10;
                    $iiend = $iiYear + 4;
                    $versionText = substr($versionText, 0, $iicomma + 1) . $span .
                        substr($versionText, $iicomma, $iiend - $iicomma) .
                        "</span>" . substr($versionText, $iiend);
                    if ($debugHighlight) print "final -- $versionText $eol";
                    $iinew = $iiend + strlen($span) + 7;
                } else {
                    $iinew = $iiYear + 3;
                }
                $iiYear = strpos($versionText, "$year", $iinew);
            } // end while $iiYear
        } // end for($iiYear...
        return $versionText;
    } // end highlightOlderDates

} // end class freewheelingeasy_kml_book_date