<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2024 - https://royweil.com
 */
class freeWheelingClean
{
    public static $okayLabel     = "<span style='color:green;'> okay</span><br />\n";
    public static $warningLabel = "<span style='color:lightgreen;'> warning</span><br />\n";
    public static $problemLabel = "<span style='color:red;'> problem</span><br />\n";
    public static function kmlClean($attributes)
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        try {
            $msg .= freeWheeling_edit_setGlobals::setGlobals("kmlClean1 ");
            $msg .= self::updateViewTables("start of kml clean") .
                "I#1500 database view tables have been updated $eol";
            $task = rrwParam::String("task", $attributes);
            switch (strtoLower($task)) {
                case "milage":
                case "mileage":
                    $msg .= self::freewheelingeasy_Mileage($attributes);
                    break;
                case "database_tables":
                case strtoLower("makeAll"):
                    // do nothing since the views have already been updated
                    $msg .= "$eol I#1502 task makeAll does nothing further database view tables have been updated ";
                    break;
                case "reset":
                    $msg .= self::kmlCleanResets($attributes);
                    break;
                case strtoLower("Consistency"):
                    $msg .= self::Consistency();
                    break;
                default:
                    $msg .= self::checkForAnomalies();
                    break;
            }
        } catch (Exception $ex) {
            $msg .= "$errorBeg " . $ex->getMessage() . $errorEnd;
        }
        return $msg;
    }
    private static function Consistency()
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $sql = " select 'icon' type, latitude, longitude, milepostPrefix, milepost from $wpdbExtra->icons
                    where milepost is not null and latitude != 0 and longitude != 0
             union
             select 'biz', trailLatitude, trailLongitude, trailMilepostPrefix, trailMilepost
                    from $wpdbExtra->business
                    where trailMilepost is not null and trailLatitude != 0 and trailLongitude != 0
                   order by latitude, longitude,milepostPrefix, milepost";
        $recsLats = $wpdbExtra->get_resultsA($sql);
        $cntChecked = 0;
        $cntInvalid = 0;
        $latitudePast = "not yet";
        $longitudePast = "not yet";
        $milepostPrefixPast = "not yet";
        $milepostPast = "not yet";
        $typePast = "not yet";
        foreach ($recsLats as $recsLat) {
            $cntChecked++;
            if ($cntChecked > 50)
                break;
            $type = $recsLat["type"];
            $latitude = $recsLat["latitude"];
            $longitude = $recsLat["longitude"];
            $milepostPrefix = $recsLat["milepostPrefix"];
            $milepost = $recsLat["milepost"];
            if ($latitudePast == $latitude && $longitudePast == $longitude) {
                if ($milepostPrefixPast != $milepostPrefix || $milepostPast != $milepost)
                    $cntInvalid++;
                $msg .= "$typePast $milepostPrefixPast $milepostPast !=
                     $type $milepostPrefix $milepost
                    &nbsp; &nbsp; $latitude, $longitude $eol";
            }
            $latitudePast = $latitude;
            $longitudePast = $longitude;
            $milepostPrefixPast = $milepostPrefix;
            $milepostPast = $milepost;
            $typePast = $type;
        }
        $msg .= "Checked $cntChecked mileposts, found $cntInvalid invalid $eol";
        return $msg;
    }
    private static function  freewheelingeasy_Mileage($attrs)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $msg .= "milage discrepancies ...";
        $prefix = rrwParam::String("prefix");
        $sqlMiles = "select 'icon' type, iconId, iconName, latitude, longitude, milepostPrefix, milepost
                    from $wpdbExtra->icons
                    where milepost is not null and not milepostPrefix = '' ";
        if (!empty($prefix))
            $sqlMiles .= " and milepostPrefix = '$prefix'";
        $sqlMiles .= "union
                select 'business', bizId, bizName, trailLatitude, trailLongitude, trailMilepostPrefix, trailMilepost
                    from $wpdbExtra->business
                    where (not trailMilepost = '' or trailMilepost = 0 )
                    and not trailMilepostPrefix = ''
                    and bizUsed > 0 ";
        if (!empty($prefix))
            $sqlMiles .= " and trailMilepostPrefix = '$prefix'";
        $sqlMiles .= " order by milepostPrefix, latitude, longitude, milepost ";
        $recMiles = $wpdbExtra->get_resultsA($sqlMiles);
        $msg .= "$eol $sqlMiles $eol ";
        $msg .= "found " . $wpdbExtra->num_rows . "rows of data $eol ";
        $pastPrefix = "not yet ";
        $pastLongitude = "not yet ";
        $pastLatitude = "not yet ";
        $cntPrefix = 0;
        $cntChecked = 0;
        $okay = true;
        $pastLatitude = "not yet";
        $pastLongitude = "not yet";
        $pastMilepost = "not yet";
        $pastIconId = "not yet";
        $pastIconName = "not yet";
        $pastType = "not yet";
        foreach ($recMiles as $recMile) {
            $cntChecked++;
            if ($cntChecked > 5000)
                break;
            $milepostPrefix = $recMile["milepostPrefix"];
            $longitude = $recMile["longitude"];
            $latitude = $recMile["latitude"];
            $milepost = $recMile["milepost"];
            $iconName = $recMile["iconName"];
            $iconId = $recMile["iconId"];
            $type = $recMile["type"];
            if ("icon" == $pastType)
                $mapPastLink = freeWheelFormat::iconIdMapLink($pastIconId);     // is is a business record
            else
                $mapPastLink = freeWheelFormat::bizIdMapLink($pastIconId);
            if ("icon" == $type)
                $mapLink = freeWheelFormat::iconIdMapLink($iconId);     // is is a business record
            else
                $mapLink = freeWheelFormat::bizIdMapLink($iconId);
            if ($pastPrefix == $milepostPrefix) {
                if ($pastLatitude == $latitude && $pastLongitude == $longitude) {
                    if (abs($pastMilepost - $milepost) > .02) {
                        $msg .= "$errorBeg E#1533 milepost - $pastMilepost  not equal $milepost  $errorEnd";
                        $msg .= " $mapPastLink $pastIconName, $mapLink $iconName $eol";
                        $okay = false;
                    } else {
                    }
                } else {
                    $msg .= "$errorBeg E#1529 latitude $pastLatitude  not equal $latitude, longitude $pastLongitude not equal $longitude  $errorEnd";
                    $msg .= " $mapPastLink $pastIconName,$eol $mapLink $iconName $eol";
                    $okay = false;
                }
            } else {
                $msg .= "$errorBeg E#1534 milepost $pastPrefix  not equal $milepostPrefix $errorEnd";
                $msg .= " $mapPastLink $pastIconName, $eol $mapLink $iconName $eol";
                $okay = false;
            }
            $cntPrefix++;
            $pastPrefix = $milepostPrefix;
            $pastMilepost = $milepost;
            $pastLongitude = $longitude;
            $pastLatitude = $latitude;
            $pastType = $type;
            $pastIconId = $iconId;
            $pastIconName = $iconName;
        } // end foreach
        $msg .= "checked $cntChecked ";
        if ($okay) {
            $msg .=   self::$okayLabel;
        }
        return $msg;
    } // end freewheelingeasy_Milage()
    private static function checkForAnomalies()
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = '';
        try {
            error_reporting(E_ALL);
            ini_set("display_errors ", 1);
            // update the views in case e structure of things has changed
            $msg .= self::updateViewTables("at checkForAnomalies to be sure we have good data ");
            // ======================== Update the grouping variables
            //return " in checkForAnomalies ";
            $msg .= "
<table>
    <tr>
        <td>";
            // ------------------------------------------------------------------  start of fixes that need to be done because of line/point changes
            $msg .= "<strong>First the fixes</strong>$eol";
            // $msg .= freewheelingeasy_edit_routes::ImposeRoutesAll(); // done before continuity check
            $msg .= self::checkOrImposeMilepostIconStyle();  //-----------------------------------------------   fix iconStyle of mileposts
            $msg .= freewheeling_WriteUp::cleanOldSavedReports();
            // ------------------ end of fixes, now checking
            $msg .= "<strong>Now the checking begins</strong>$eol";
            $msg .= "<h2>billing</h2> $eol";
            $msg .= self::checkBillingCodesForDuplicate();
            // ------------------------------------------------------------------------------------------------  lines
            $msg .= "<h2>lines</h2> $eol";
            $msg .= shouldBeZero(
                "SELECT distinct trailId,routes FROM $wpdbExtra->lines where routes like '%e2p%' and routes like '%connect%'",
                " lines with both e2p and connect "
            );
            $msg .= shouldBeZero("SELECT distinct trailId,routes FROM $wpdbExtra->lines where trailId like '%road%' and
             routes like '%connect%'", "road lines with a connect");
            $msg .= shouldBeZero(
                "select trailId, lineId, lineName from $wpdbExtra->lines where not trailId in
                        (select DISTINCT trId from $wpdbExtra->trails)",
                "lines that are not associated with a trail"
            );
            $msg .= shouldBeZero(
                "SELECT trailId, lineId, lineIconId
            FROM `$wpdbExtra->lines` where lineIconId not in
                (select iconId from $wpdbExtra->icons) AND not lineIconId = 0",
                "lines with invalid link to a icons"
            );
            $msg .= shouldBeZero(
                "select mapStyle, trailId, trName, lineName, lineId
						from $wpdbExtra->trailLines
	  					where mapStyle not in (select code from $wpdbExtra->codesSurface)
						order by trailId, sequence ",
                "line surface not in the list of <a href='/edit-surface/' >valid line surfaces</a> "
            );
            $filename = "kmlStyleLines.txt";
            $sqlSurface = "select code, codeDescription from $wpdbExtra->codesSurface";
            $recsSurface = $wpdbExtra->get_resultsA($sqlSurface);
            $fileContents = freewheeling_WriteUp::getFileContents("kmlStyles", $filename);
            $badCnt = 0;
            foreach ($recsSurface as $recSurface) {
                $kmlStyle = $recSurface["code"];
                $kmlStyle = substr($kmlStyle, 1);
                $codeDescription = $recSurface["codeDescription"];
                $iiStyle = strpos($fileContents, $kmlStyle);
                if ($iiStyle === false) {
                    $msg .= "$errorBeg E#1544 kml style $codeDescription ($kmlStyle) not in $filename $errorEnd";
                    $badCnt++;
                }
            }
            if (0 == $badCnt) {
                $msg .= "all valid surfaces are in the kmlStyles files ..." . self::$okayLabel;
            }
            // return "----------------------------------------------------------------------------------------------------  icons";
            $msg .= "<h2>icons</h2> $eol";
            $msg .= self::checkIconsForDuplicateName();
            $msg .= shouldBeZero(
                "SELECT trailId, count(*) FROM `07rrw_junctions`
                        where junctionCode = -5 group by trailId having count(*) > 1",
                "Junctions assigning a milage to each end of trail "
            );
            // return "$msg $eol after checkIconsForDuplicateName $eol";
            $msg .= shouldBeZero(
                "SELECT iconId, iconName, isTrailHead
                FROM $wpdbExtra->icons
                where not isTrailHead in (select code from " . $wpdbExtra->codesTrailHeads . ") ",
                "icon isTrailHead not valid value (3,2,1,0,-4,-5)"
                // TODO: get the list of valid values from the database
            );
            error_reporting(E_ALL);
            ini_set("display_errors ", 1);
            $msg .= shouldBeZero(
                "SELECT trailId, iconName, iconId,  milepost, iconStyle, onMap
                FROM $wpdbExtra->icons
                where onMap not in (SELECT code FROM $wpdbExtra->iconOnMap)",
                "point type (onMap) is not valid <a href='/edit-iconOnMap/' >valid point types</a> "
            );
            //return "$msg $eol first three $eol";
            $msg .= shouldBeZero(
                "SELECT trailId, iconName, milepostPrefix,  milepost, iconStyle, onMap
                FROM $wpdbExtra->icons
                where position(milepost in iconStyle) = 0 and milepost = floor(milepost)
                and (( position('milepost' in iconName) != 0 or position('MP ' in iconName) != 0 ))
                and position('amp' in iconName) = 0",
                "milepost in icon name, but not in iconStyle"
            );
            // return "$msg $eol milepost in icon name $eol";
            $msg .= shouldBeZero(
                "select iconName, latitude, longitude from $wpdbExtra->icons where latitude is null or longitude is null ",
                "icons without a latitude or longitude "
            );
            $msg .= shouldBeZero(
                "SELECT iconId, trailId, iconName, milepostPrefix , milepost
                    FROM `$wpdbExtra->icons`
                    where not milepost = '' and milepostPrefix = '' ORDER BY `trailId` ASC",
                "icons with a milage, but no mile post prefix"
            );
            $msg .= shouldBeZero("SELECT iconName, latitude, longitude, trailId, milepost FROM `$wpdbExtra->icons` where latitude in
        (SELECT latitude FROM `$wpdbExtra->icons`
                group by latitude, longitude, trailId
                having count(*) > 1)", "duplicate latitude on for icons");
            $msg .= shouldBeZero(
                "select trailId, iconId, iconName from $wpdbExtra->icons where not trailId in
                    (select DISTINCT trId from $wpdbExtra->trails)",
                "icons not associated with a known trail"
            );
            //return "Halfway through icons";
            $msg .= shouldBeZero(
                "SELECT trailId, iconId, iconLineId
            FROM `$wpdbExtra->icons` where iconLineId not in
                (select lineId from $wpdbExtra->lines) AND not iconLineId = 0",
                "icons with invalid link to a line"
            );
            $msg .= shouldBeZero(
                "select iconId, onMap from  $wpdbExtra->icons where not onMap
                    in ( SELECT code FROM $wpdbExtra->codes  where codetype = 'isOnMap' )",
                "icons with an invalid onMap code"
            );
            $msg .= shouldBeZero(
                "SELECT iconName, isTrailHead, iconStyle FROM `$wpdbExtra->icons`
            where iconStyle = '' or iconStyle is null or iconStyle = '.png' ",
                "IconStyle is empty or null or bad"
            );
            $msg .= shouldBeZero(
                "SELECT trailId, iconName, isTrailHead, iconStyle FROM `$wpdbExtra->icons`
            where not iconStyle like '%.png' ",
                "IconStyle is not a png"
            );
            $msgTemp = freewheelingeasy_kml_merge::updateTheJunctionsMileages();;
            if (empty($msgTemp)) {
                $msg .= "junction sequences are " . self::$okayLabel . $eol;
            } else {
                $msg .= "junction sequences ... " . self::$problemLabel . $msgTemp;
            }
            //return "----------------------------------------------------------------------------------------------------- mileposts";
            $msg .= "<h2>mileposts</h2> $eol";
            $msg .= "icons with a milepost prefix and no milage not checked yet$eol";
            /*
            $msg .= shouldBeZero(
                "select iconId, milepostPrefix, milepost from $wpdbExtra->icons
                                where milepost is  null and not milepostPrefix = '' ",
                "icons with a milepost prefix and no milage"
            );
            */
            $msg .= "icons with a milepost prefix and no milage not yet checked $eol";
            /*
            $msg .= shouldBeZero(
                "select iconName, milepostPrefix, trailId from $wpdbExtra->icons
                                where milepost is null and not milepostPrefix = ''
                                and onMap like '%amen%' order by milepostPrefix, trailId",
                "Amenity icons with no Milage"
            );
            */
            $msg .= shouldBeZero(
                "SELECT iconName, iconId FROM `$wpdbExtra->icons`
                where (iconName like '%milepost%' OR iconName like 'MP%' )
                        and not onMap like '%mile%'",
                "Milepost name not a milepost icon"
            );
            // ------------------------------------------------------------------------------------------------------  segments
            $msg .= "<h2>Segments</h2> $eol";
            $msg .= shouldBeZero(
                "SELECT count(*), startIcon, endIcon FROM $wpdbExtra->segments group by startIcon, endIcon having count(*) > 1",
                "Duplicate Start/end iconNames in segment list"
            );
            $msg .= shouldBeZero(
                "SELECT trailId, iconName FROM `$wpdbExtra->icons`
                    where ((iconName like '%launch%' and
                            not (iconName like '%boat%' OR iconName like '%canoe%')) or
                        iconName like 'LP%' ) and not onMap = 'launch' ",
                "Launch point name not a launch point icon"
            );
            // -------------------------------------------------------------------------------------------------------  codes
            $msg .= "<h2>Codes</h2> $eol";
            $msg .= shouldBeZero(
                "SELECT iconId, iconName, onMap FROM `$wpdbExtra->icons`
                    where not onMap in (SELECT code FROM `$wpdbExtra->iconOnMap`)",
                "invalid onMap value "
            );
            // ---------------------------------------------------------------------------------------------------------  trails
            $msg .= "<b>trails</b> $eol";
            $msg .= shouldBeZero(
                "SELECT trId, trName, spurOf, bookVolume FROM $wpdbExtra->trails
                where bookVolume = '' or bookVolume is null
                 ORDER BY bookVolume ASC",
                "trails with no book volume"
            );
            $msg .= shouldBeZero(
                "SELECT trId, trName FROM `$wpdbExtra->trails`
                    left join $wpdbExtra->html on trId = htmTrailId
                         where (htmTrailId is null or htmTrailId = '')and spurOf = '' ",
                " trails with missing html data "
            );
            $msg .= shouldBeZero(
                "SELECT trId, trName, spurOf FROM `$wpdbExtra->trails` where spurOf not in
                         (select trId from $wpdbExtra->trails)  and not spurOf = ''
                        order by spurOf, trName",
                "trails with spurOf not in the list of trails"
            );
            // ------------------------------------------------------------------------------------  business
            $msg .= "<h2>Business</h2> $eol";
            /*
        $msg .= shouldBeZero(
            "SELECT bizId, BizName, bizUsed FROM `$wpdbExtra->business` where bizName like '%|%'",
            "businesses with a vertical bar in the name"
            );
*/
            $msg .= shouldBeZero(
                "SELECT bizId, BizName, bizUsed FROM `$wpdbExtra->business`
                    where bizName is null or bizName = ''",
                "Business with no name "
            );
            $msg .= shouldBeZero(
                "select bizId, bizName, BizVerifyDisplay from `$wpdbExtra->business`
                                        where bizUsed = -6",
                "businesses with display status = 'route later'"
            );
            $msg .= shouldBeZero(
                "select bizId, bizName, BizVerifyDisplay from `$wpdbExtra->business`
                                        where bizUsed > 1 and bizUsed != 5 and
                                        bizId not in (select accBizId from $wpdbExtra->access) ",
                "businesses with no access information "
            );
            $msg .= shouldBeZero(
                "select bizId, bizName from $wpdbExtra->business where bizUsed > 0
            and (
            BizVerifyDisplay like '%Closed%'
            or BizVerifyDisplay like '%duplicate%'
            or BizVerifyDisplay = 'reject%' ) ",
                "used but closed, duplicate or reject"
            );
            $msg .= shouldBeZero(
                "select bizId, bizName, place_id from $wpdbExtra->business
            where not bizId = place_id and not place_id = '' ",
                "businesses where bizId not equal place_id "
            );
            $msg .= shouldBeZero(
                "select svcId, svcName from $wpdbExtra->services where svcId not in
            (select bizId from $wpdbExtra->business)",
                "service with no businesses information "
            );
            $msg .= shouldBeZero(
                "SELECT bizId FROM `$wpdbExtra->business`
                                where googleMapUrl = '' and not BizLat = ''
                                    and " . freewheeling_kml_common::selectOnlyGoogleId('bizId'),
                "Google business missing google map URL "
            );
            $msg .= shouldBeZero(
                "SELECT bizId, bizLat, bizLng, bizId bisLink, bizName search, bizId deleteThis FROM `$wpdbExtra->business`
                                where (bizLat is null or bizLng is null) and  bizUsed > 0 and bizUsed != 5 and bizUsed != -100
                                order by bizName ",
                "Business missing latitude or longitude "
            );
            $msg .= shouldBeZero(
                "select * from `$wpdbExtra->business` where bizUsed > 0
                        and bizId in (
                                select svcId from $wpdbExtra->services
                                where p and not (F || B || L || K || O || T || A || C)
                                     )",
                "government places with hospitality"
            );
            $msg .= shouldBeZero(
                "select bizId, bizName from `$wpdbExtra->business`
                            where bizUsed > 0
                            and bizId in (
                                select svcId from $wpdbExtra->services
                                where not (F || B || L || K || O || S || T || A || C )
                                     )",
                "displayed with no services <a href='/fix?task=service&limit=20' target='edit'>fix</a>"
            );
            $msg .= shouldBeZero(
                "select accBizId, trailMilepostPrefix from $wpdbExtra->access
                                where trailMilepost is null and
                                      not trailMilepostPrefix = '' ",
                " has milepost prefix, but no milage"
            );
            // -----------------------------------------------------------------------------------------------------------  service
            $msg .= "<h2>service</h2> $eol";
            $sql = "select distinct svcId, svcName, google_types from $wpdbExtra->services join $wpdbExtra->history on svcId = hisId
            where f = 0 and google_types like '%food%' and
            0 = (select count(*) from $wpdbExtra->history where hisId = svcId and ( hisComment like 'user change - F - 1 -> 0'
            or hisComment like 'user change - FX - 1 -> 0'))";
            $msg .= shouldBeZero($sql, "google says is food but services has no 'F'");
            $sql = "select distinct hisId, svcId, google_types from $wpdbExtra->services join $wpdbExtra->history on svcId = hisId
            where L = 0 and google_types like '%lodging%' and
            0 = (select count(*) from $wpdbExtra->history where hisId = svcId and ( hisComment like 'user change - L - 1 -> 0'
            or hisComment like 'user change - LX - 1 -> 0'))";
            $msg .= shouldBeZero($sql, "google says is lodging but services has no 'L'");
            //  duplicates
            /*  duplicates should be caught be sql indexes
            $msg .= duplicateItems("Duplicate Line names", $wpdbExtra->lines, "lineName");
            $msg .= duplicateItems("Duplicate trail sequence numbers.", $wpdbExtra->trails, "trName, trId, trSequence");
            $msg .= duplicateItems("detecting duplicate lines", $wpdbExtra->lines, "latStart, latEnd, lngStart, lngEnd");
            */
            $msg .= shouldBeZero(
                "SELECT trailId, lineName from $wpdbExtra->lines where lengthMeters < 1 ",
                " all trails have length> 1"
            );
            $msg .= shouldBeZero(
                "select bizId from $wpdbExtra->business where bizUsed > 0
                                    and bizverifyDisplay like 'duplicate'",
                "duplicate business but still used"
            );
            $msg .= shouldBeZero(
                "select bizId, bizName, svcName from $wpdbExtra->businessServices where not bizName = svcName",
                "business name does not match service name <a href='/fix/?task=imposeNames&limit=30' target='edit' >fix</a>"
            );
            $msg .= shouldBeZero("select bizId, bizName, place_id from $wpdbExtra->business
            where bizName = '' or bizName is null", "business with no name ");
            $msg .= shouldBeZero("SELECT bizId, bizName, bizStreet, bizCity, bizState FROM `$wpdbExtra->business`
            where bizState is null or bizState = ''", "Business with no state name <a href='/fix?task=state&limit=20' target='edit'> fix</a>");
            $msg .= shouldBeZero("SELECT bizId, bizName, bizStreet, bizCity, bizState FROM `$wpdbExtra->business`
            where bizCity is null or bizCity = ''", "Business with no city name <a href='/fix?task=city&limit=20' target='edit'> fix</a>");
            $msg .= shouldBeZero(
                "SELECT trailId, accBizId FROM $wpdbExtra->access where metersToTrail > 0 and
                        (trailMilepostPrefix is null or trailMilepostPrefix = '')",
                "biz with distance to trail, but no Mile prefix"
            );
            $msg .= shouldBeZero(
                "SELECT bizId, bizName from $wpdbExtra->business
                    where bizUsed < 0 and (bizLat is null or bizLng is null) and bizUsed != -100",
                "Open business missing latitude or longitude "
            );
            $msg .= shouldBeZero(
                "SELECT bizId, bizName from $wpdbExtra->business
                     where bizUsed < 0 and (bizLat = '' or bizLng = '') and bizUsed != -100",
                "Open business missing latitude or longitude "
            );
            // -------------------------------------------------------------------------------------------------------------------  Access
            $msg .= "<h2>Access</h2> $eol";
            $msg .= shouldBeZero(
                "SELECT trailId, accBizId, accBizName, accId FROM $wpdbExtra->access where
                trailId not in (select trId from $wpdbExtra->trails) ",
                "Access entries with an invalid trailId "
            );
            $msg .= shouldBeZero(
                "select bizId, bizName, accBizId, accBizName from $wpdbExtra->business
                    join $wpdbExtra->access on bizId = accBizId
                    where not bizName = accBizName order by bizName",
                "bizName does not match AccessName"
            );
            $msg .= shouldBeZero(
                "SELECT trailId, accBizId FROM $wpdbExtra->access where metersToTrail > 0 and
                (trailMilepostPrefix is null or trailMilepostPrefix = '')",
                "biz with distance to trail, but no Mile prefix"
            );
            /*
            $msg .= shouldBeZero(
                "SELECT accBizId FROM $wpdbExtra->access
                    where trailMilepost is not null and
                        (trailMilepostPrefix is null or
            );
            */
            $msg .= shouldBeZero(
                "select accBizId, trailMilepostPrefix from $wpdbExtra->access
                                where trailMilepost is null and
                                      not trailMilepostPrefix = '' ",
                " has milepost prefix, but no milage"
            );
            // -------------------------------------------------------------------------------------------------------------------  regions
            $msg .= "<h2>Regions</h2> $eol";
            $msg .= shouldBeZero(
                "select trailId from $wpdbExtra->regions where not trailId in
            (select DISTINCT trId from $wpdbExtra->trails union select grpId from $wpdbExtra->trail_routes)",
                "regions trailId not a valid trail trailId"
            );
            $msg .= shouldBeZero(
                "select distinct trailId, lineName, lineId from $wpdbExtra->lines where not trailId in
            (select DISTINCT trailId from $wpdbExtra->regions)",
                "Line trailId not a valid region"
            );
            $msg .= shouldBeZero(
                "select distinct trailId, IconName, iconId from $wpdbExtra->icons where not trailId in
            (select DISTINCT trailId from $wpdbExtra->regions)",
                "Point trailId not a valid region"
            );
            // ===================================================================== start column 2",
            $msg .= "</td>
        <td>&nbsp;</td>
        <td width=200px'>";
            //  =====================================================================    latitudes, longitudes problems
            $msg .= "<h2>Latitude and Longitude</h2> $eol";
            $msg .= latitudeCheck("$wpdbExtra->regions", "north", "east");
            $msg .= latitudeCheck("$wpdbExtra->regions", "south", "west");
            $msg .= latitudeCheck("$wpdbExtra->regions", "labelNorth", "labelEast");
            $msg .= latitudeCheck($wpdbExtra->icons, "latitude", "longitude");
            $msg .= latitudeCheck($wpdbExtra->business, "BizLat", "BizLng");
            $msg .= latitudeCheck($wpdbExtra->lines, "latStart", "LngStart");
            $msg .= latitudeCheck($wpdbExtra->lines, "latEnd", "LngEnd");
            $msg .= latitudeCheck($wpdbExtra->lines, "latMax", "LngMax");
            $msg .= latitudeCheck($wpdbExtra->lines, "latMin", "LngMin");
            // =======================================================================start column 3
            $msg .= "</td>
        <td>&nbsp;</td>
        <td>";
            //               $msg .= "E#1514 Segment and continuity checks disabled";
            /*
                // -------------------------------------------------------------------------------------------------  segments
                $msg .= "<h2>Segments</h2> $eol";
                $msg .= shouldBeZero(
                    "SELECT startIcon,segmentId FROM `$wpdbExtra->segments`
            where startIcon not in (select iconName from $wpdbExtra->icons)",
                    "start icon in segments, not in icon list"
                );
                $msg .= shouldBeZero(
                    "SELECT endIcon,segmentId FROM `$wpdbExtra->segments`
            where endIcon not in (select iconName from $wpdbExtra->icons)",
                    "end icon in segments, not in icon list"
*/
            // =============================================== routes
            $msg .= "<h2> continuity</h2> $eol";
            $msg .= self::CheckLineWorkContinuity();
            $msg .= "$eol <h2> segment  </h2> $eol $eol";
            //                $msg .= freewheelingeasy_build_segment_report::freewheelingBuildAllSegmentReports();
            // ================================= business
            $msg .= "</td>
    </tr>
</table>\n";
            $msg .= "======================================= caution items -- may not be problem, but think about it $eol";
            $headerMixed = "<strong>These trails have miscellaneous milepost prefixes:</strong>$eol";
            $sqlPrefix = "select distinct trailId, trName, milepostPrefix from $wpdbExtra->trailIcons
                            where milepost is not null
                            order by trailId, trName, milepostPrefix ";
            $recPrefixes = $wpdbExtra->get_resultsA($sqlPrefix);
            $msg .= "<table>";
            $trailIdPast = "not yet";
            $milepostPrefixPast = "not yet";
            $color = rrwUtil::colorSwap();
            foreach ($recPrefixes as $recPrefix) {
                $trailId = $recPrefix["trailId"];
                $trName = $recPrefix["trName"];
                $milepostPrefix = $recPrefix["milepostPrefix"];
                $mapLink = freeWheelFormat::trailLink($trailId, $trName);
                if ($trailId == $trailIdPast) {
                    // trail id is equal. therefore milepostPrefix is not equal
                    $color = rrwUtil::colorSwap($color);
                    $sqlPrefixMixed = "select iconId, iconName,  milepostPrefix, milepost
                                from $wpdbExtra->icons where trailId = '$trailId' and milepost is not null
                                order by milepostPrefix, milepost ";
                    if (! empty($headerMixed)) {
                        $msg .= $headerMixed;
                        $headerMixed = "";
                    }
                    $msg .= rrwFormat::CellRow($color, "$mapLink$trailId", $trName, $milepostPrefix, $sqlPrefixMixed);
                    $msg .= rrwFormat::CellRow($color, $trailIdPast, $trName, $milepostPrefixPast);
                }
                $trailIdPast = $trailId;
                $milepostPrefixPast = $milepostPrefix;
            }
            $msg .= "</table>";
            //  missing trail prefix
            $sql = "select distinct trId, trName from $wpdbExtra->trails
                            where trMilepostPrefix is null or trMilepostPrefix = ''
                            order by trId, trName ";
            $msg .= "<strong>trails with missing milepost prefixs</strong> $eol";
            $recs = $wpdbExtra->get_resultsA($sql);
            foreach ($recs as $rec) {
                $trId = $rec["trId"];
                $trName = $rec["trName"];
                $link = freeWheelFormat::trailLink($trId, $trName);
                $msg .= "[ $link ]";
            } //
            //  missing trailhead parking
            $msg .= "$eol <strong>These trailheads do not have parking </strong> $eol ";
            $sqlMissLines = "SELECT iconName FROM `$wpdbExtra->icons` where iconStyle like '%flag%' and istrailhead = 2";
            $rectsNames = $wpdbExtra->get_resultsA($sqlMissLines);
            foreach ($rectsNames as $rectsName) {
                $iconName = $rectsName["iconName"];
                $iconNameDisplay = "<a href='edit-icon?iconName=$iconName' target='cleanitem'>$iconName</a> ";
                $msg .= "[ $iconNameDisplay ] ";
            }
            // -------------------------------------------------------------- missing linework
            $msg .= "$eol<strong>The following trails do not have any line work</strong> $eol ";
            $sqlMissLines = "select trId, trName from $wpdbExtra->trails where not trId in (select trailId from $wpdbExtra->lines )";
            $msg .= "$sqlMissLines $eol";
            $recMissLines = $wpdbExtra->get_resultsA($sqlMissLines);
            foreach ($recMissLines as $recMissLine) {
                $trId = $recMissLine["trId"];
                $trName = $recMissLine["trName"];
                $link = freeWheelFormat::trailLink($trId, $trName);
                $msg .= "[ $link ]";
            }
            $msg .= "$eol";
            // ------------------------------------------------------------------- missing regions
            $msg .= shouldBeZero(
                "SELECT trId, trName FROM $wpdbExtra->trails
                        where trId not in (select trailId from $wpdbExtra->regions);",
                " trails with missing region "
            );
            // -------------------------------------------------------------- missing trail with no parking
            $msg .= "$eol <strong>Trails that have no places </strong>$eol";
            $sqlTrNames = "select distinct trId, trName from $wpdbExtra->trails where not trId in (select DISTINCT trailId from $wpdbExtra->icons)";
            $msg .= "$sqlTrNames $eol";
            $rectsNames = $wpdbExtra->get_resultsA($sqlTrNames);
            foreach ($rectsNames as $rectsName) {
                $trId = $rectsName["trId"];
                $trName = $rectsName["trName"];
                $link = freeWheelFormat::trailLink($trId, $trName);
                $msg .= "[ $link ]";
            }
            $msg .= "$eol";
            $msg .= shouldBeZero("select trId, landingPage, bookUrl from $wpdbExtra->trails
                                join $wpdbExtra->html on trId = htmTrailId
                    where not landingPage = bookUrl", "landing pages disagree with the book URL ");
            $msg .= shouldBeZero(
                "SELECT bizId, bizLat, bizLng, bizId bisLink, bizName search, bizId deletethis FROM `$wpdbExtra->business`
                                            where (bizLat is null or bizLng is null) and  bizUsed <= 0 and bizUsed != -100
                                            order by bizName ",
                "Not used business missing latitude or longitude "
            );
            $timeUse = rrwUtil::elapsedTime();
            $msg .= "$eol Clean took $timeUse seconds.$eol";
        } catch (Exception $ex) {
            $msg .= "$errorBeg " . $ex->getMessage() . $errorEnd;
            print $msg;
        }
        return $msg;
    }
    private static function kmlCleanResets($attibutes)
    {
        //    *   General cleanup function - updates fields that a function of other fields
        //    *       service main code that are function of subcodes code
        //    *       iconstyle  that is a function of onMap
        //    *       proprocate bizName to service name, fix name
        //    *         Political to not relevant
        //    *     standardize iconStyle names
        //    *     set missing plusCode, time to PGH
        //    *     update routes for on road,closed, noTrail segments
        //    *     Clean up double save and trim
        //    *
        global $eol;
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        try {
            // ------------------------------------------------------------------------------------------   clean up service data
            $msg .= self::updateViewTables("at kmlCleanResets to be sure we have good data ");
            "E#1503 database view tables have been updated " . self::$okayLabel;
            $msg .= "updates setting master code results - ";
            $msg .= self::updateMasterServiceCodes("");
            $msg .= self::$okayLabel;
            // -------------------------------------------------------------------    match business name to access, service, exceptions name,
            $msg .= self::upDateSubTablesNamesToMatchBusinessNames();
            //  --------------------------------------------------------------------------------------  force political  entices to not relevant-
            $msg .= self::$okayLabel . " force political  entries to not relevant, ";
            $sql = "update `$wpdbExtra->business` set bizUsed = -7 where bizUsed > 0
                and bizId in
                    ( select svcId from $wpdbExtra->services
                    where p and not (F || B || L || K || O || T || A || C) ) ";
            $cnt = $wpdbExtra->query($sql);
            $msg .= "updated $cnt " .  self::$okayLabel;
            // ------------------------------------------------------------------------------------------   update trim and double spaces
            $msg .= "update trim and double spaces -  ";
            foreach (freewheeling_change_bizId::tablesWithPointNames() as $field => $table) {
                $sqlBiz = "update $table set $field = trim($field) ";
                $cnt = $wpdbExtra->query($sqlBiz);
                $msg .= self::fixDoubleSpace($field, $table);
            }
            $msg .=    self::$okayLabel;
            // -------------------------------------------------------------------------------------------    update some BizVerifyDisplay
            $msg .= " fix bizVerify Display ...";
            $sqlDisplay = "select bizId from $wpdbExtra->business where 0"; // get nothing or now
            $recBizIds = $wpdbExtra->get_resultsA($sqlDisplay);
            $cnt = 0;
            foreach ($recBizIds as $recBizId) {
                $cnt++;
                $bizId = $recBizId["bizId"];
                $msg .= freewheelingeasy_calculateMP::Update_BizVerifyDisplay($bizId);
            }
            $msg .=  "updated $cnt  " . self::$okayLabel;
            //-----------------------------------------------------------------------------------------------   reset sql special POINTS
            $msg .= "<table>
        <tr>
            <td width='300px'> \n";
            // update points
            $msg .= "<strong>Recalculate the calculated point data </strong>$eol";
            $items = array(
                "icons|latitude|longitude|iconPoint",
                "lines|latStart|lngStart|lnBegPoint",
                "lines|latEnd|lngEnd|lnEndPoint",
                "business|bizLat|bizLng|bizPoint",
                "access|trailLatitude|trailLongitude|accTrailPoint"
            );
            foreach ($items as $item) {
                list($table, $lat, $lon, $item) = explode("|", $item);
                $tableReal = $wpdbExtra->$table;
                $sql = "update $tableReal set $item = Point($lat, $lon) where not $item = Point($lat, $lon) ";
                // $msg .= " $sql $eol";
                $cnt = $wpdbExtra->query($sql);
                $msg .= "updated $cnt Points for ($table, $lat, $lon, $item) " . self::$okayLabel;
            } // end foreach
            //  ---------------------- -------------------------------------------------------------   update iconStyle
            $msg .= "<h2>Force some updates, based on rules</h2> $eol";
            $msg .= "Standardize some of the icon styles ... ";
            changeIconStyle('#msn_grn_circle', 'flag');
            changeIconStyle('#m_ylw-pushpin', 'flag');
            $msg .= self::$okayLabel  . "force icon style based on onMap ";
            $sqlLaunch = "update $wpdbExtra->icons set iconStyle = 'flag.png'
                        where onMap = 'launch' and not iconStyle = 'flag.png'";
            $cnt = $wpdbExtra->query($sqlLaunch);
            $sqlLaunch = "update $wpdbExtra->icons set iconStyle = 'park.png'
                        where onMap = 'park' and not iconStyle = 'park.png'";
            $cnt = $wpdbExtra->query($sqlLaunch);
            $msg .= self::checkOrImposeMilepostIconStyle();  //-----------------------------------------------   fix iconStyle of mileposts
            // --------------------------------------------------------------------------------------    update segments
            $msg .= self::$okayLabel  . "Deleting segments that are empty ...";
            $sqlSegmentsNull = "delete from $wpdbExtra->segments where startIcon = '' and endIcon ='' and descpublic ='' ";
            $segDeleted = $wpdbExtra->query($sqlSegmentsNull);
            $msg .= "found $segDeleted  " .  self::$okayLabel;
            // update lines
            $msg .= self::upDateRoutesBasedOnMapStyle("onroad", "where mapStyle = '#trailOnRoad' or mapStyle = '#bikelane'");
            $msg .= self::upDateRoutesBasedOnMapStyle("closed", "where mapStyle = '#trailClosed'");
            $msg .= self::upDateRoutesBasedOnMapStyle("notrail", "where mapStyle = '#trailClosed' or mapStyle = 'straight'");
            $msg .= self::$okayLabel;
            // ------------------------------------------------------------------------------------- force all businesses to have a service
            $sql = "select bizId, bizName from $wpdbExtra->business where bizId not in
            (select svcId from $wpdbExtra->services)";
            $recs = $wpdbExtra->get_resultsA($sql);
            foreach ($recs as $rec) {
                $svcId = $rec["bizId"];
                $msg .= "insert into $wpdbExtra->services (svcId ) values ('$svcId'); $eol";
            }
            $msg .= self::$okayLabel;
            // ------------------------------------------------------------------------------------- force service name to match business name
            $sqlName = "select bizId, bizName, svcName from $wpdbExtra->businessServices where not bizName = svcName";
            $recName = $wpdbExtra->get_resultsA($sqlName);
            $cnt = 0;
            foreach ($recName as $rec) {
                $cnt++;
                $bizId = $rec["bizId"];
                $bizName = $rec["bizName"];
                $svcName = $rec["svcName"];
                $update = array("svcName" => $bizName);
                $where = array("svcId" => $bizId);
                $wpdbExtra->update($wpdbExtra->services, $update, $where);
                $msg .= insertIntoHistory($bizId, "kmlReset change - svcName - $svcName -> $bizName");
            }
            $msg .= "update $cnt service names the did not match business name $eol";
            // ---------------------------------------------------------------------------------------------  give/receives onMap values
            $sql = "update $wpdbExtra->icons set onMap= 'launch' WHERE isTrailHead = -4;";
            $sql = "update $wpdbExtra->icons set onMap= 'milepost' WHERE isTrailHead = -5;";
            // --------------------------------------------------------   final cleanup i\of related data, since some values are changed.
            $msg .= self::pointFixNullMinutesFromPgh_PlusCodes();  // ----------------------------------------------   fix plus codes
            $msg .= self::updateViewTables("at end kmlCleanResets because we messed with the data ");
            $msg .= freewheelingeasy_make_amenities::createAllAmenityPages(false);  // no display
            $msg .= " <strong>I#1504 finished kmlClean Reset</strong>  ";
            $msg .= self::checkForAnomalies();
        } // end try
        catch (Exception $ex) {
            $msg .=  "$errorBeg  error Thrown E#1517 at bottom of kmlCleanResets  " . $ex->getMessage() . $errorEnd;
        }
        return $msg;
    } // end function kmlCleanResets
    private static function checkBillingCodesForDuplicate()
    {
        global $eol;
        global $wpdbExtra;
        $msg = "";
        $sqlCodes = "select billYearMonth, billType,billApiKey,count(*) cnt from $wpdbExtra->googleBilling
                            group by billYearMonth, billType, billApiKey having count(*) > 1
                            order by billYearMonth desc, billType, billApiKey ";
        $recCodes = $wpdbExtra->get_resultsA($sqlCodes);
        $cntCodes = count($recCodes);
        if ($cntCodes > 0) {
            $msg .= "<strong>Duplicate billing codes</strong>$eol";
            foreach ($recCodes as $recCode) {
                $billYearMonth = $recCode["billYearMonth"];
                $billType = $recCode["billType"];
                $billApiKey = $recCode["billApiKey"];
                $cnt = $recCode["cnt"];
                $msg .= "E# Month $billYearMonth, Type $billType, Api '$billApiKey' is used by $cnt times $eol";
            }
        } else {
            $msg .= "I#1548 No duplicate billing codes found. " . self::$okayLabel;
        }
        return $msg;
    }
    /**
     * Updates the master service codes in the services table based on subcode values.
     *
     * This function performs multiple SQL update statements to recalculate and set
     * the master service codes (such as B, F, C, K, L, O, T) in the services table,
     * based on the values of their respective subcodes. It may update all services
     * or a specific service if $svcId is provided.
     *
     * @param string $svcId Optional. The service ID to update. If empty, updates all services.
     * @return string Message indicating the results of the update operations.
     */
    public static function updateMasterServiceCodes($svcId)
    {
        global $eol;
        global $wpdbExtra;
        $msg = "";
        if (empty($svcId))
            $where = "";
        else
            $where = "and svcId = '$svcId'";
        $sqlMaster = "update $wpdbExtra->services set b=0, f=0, c=0, k=0, l=0, o=0, t=0 where 1=1 $where";
        $msg .= "I#1546  Reset master values - " . $wpdbExtra->query($sqlMaster);
        $sql = "update $wpdbExtra->services set B='1' where BR = '1' or BS = '1' or BR = '1' $where";
        $msg .= ", B-" . $wpdbExtra->query($sql);
        $sql = "update $wpdbExtra->services set f='1' where (FB = '1' or FF = '1' or FG = '1'
                or fr = '1' or FS = '1' or FX = '1') $where";
        $msg .= ", F-" . $wpdbExtra->query($sql);
        $sql = "update $wpdbExtra->services set C='1' where CK = '1' or CL = '1' or CR = '1' $where";
        $msg .= ", C-" . $wpdbExtra->query($sql);
        $sql = "update $wpdbExtra->services set K='1' where KC = '1' or KG = '1' or KP = '1'
                        or KD = '1' or KU = '1' $where";
        $msg .= ", K-" . $wpdbExtra->query($sql);
        $sql = "update $wpdbExtra->services set L='1' where LB = '1' or LH = '1' or LM = '1'
                                                             or LS = '1' or LX = '1' or LY = '1' $where";
        $msg .= ", L-" . $wpdbExtra->query($sql);
        $sql = "update $wpdbExtra->services set O='1' where OB = '1' or OC = '1' or OI = '1' or OL = '1'
                                                             or OM = '1' or OP = '1' $where";
        $msg .= ", O-" . $wpdbExtra->query($sql);
        $sql = "update $wpdbExtra->services set T ='1' where (TG = '1' or TL = '1' or TS = '1') $where";
        $msg .= ", T-" . $wpdbExtra->query($sql);
        return "$msg $eol";
    }  // end function updateServiceCodes
    public static function updateSubTablesNamesToMatchBusinessNames()
    {
        //  update access, exception, service names to match business names
        global $wpdbExtra;
        global $eol;
        $msg = "";
        $msg .= "I#1516 update access, exception, service names to match business names - ";
        $debugBizNameMatch = rrwParam::isDebugMode("bizNameMatch");
        $bizNameSearch = array("access" => "accBizId", "services" => "svcId", "exceptions" => "fixBizId",);
        foreach ($bizNameSearch as $ToTable => $toTableBizId) {
            $toTableName = $wpdbExtra->$ToTable;
            $toBizName = str_replace("Id", "name", $toTableBizId);          // i.e. accBizId -> accBizname
            $sqlDiff = "select bizId, bizName from $wpdbExtra->business
                        join $toTableName on bizId = $toTableBizId
                    where not bizName = $toBizName order by bizName";
            $recdiffs = $wpdbExtra->get_resultsA($sqlDiff);
            $cnt = $wpdbExtra->num_rows;
            if ($debugBizNameMatch) $msg .= "I#1541  $sqlDiff found $cnt enties $eol";
            $numUpdated = 0;
            foreach ($recdiffs as $recdiff) {
                $bizNameCorrect = $recdiff["bizName"];
                $bizId = $recdiff["bizId"];
                $updateCnt = $wpdbExtra->update($toTableName, array($toBizName => $bizNameCorrect), array("$toTableBizId" => $bizId));
                if ($debugBizNameMatch) $msg .= "I#1542 updated $updateCnt entry $bizId in $toTableName to $bizNameCorrect -- $eol";
                $numUpdated++;
            }
            if ($debugBizNameMatch) $msg .= "I#1543 updated $numUpdated businesses $eol";
        }
        return $msg;
    } // end function upDateSubTablesNamesToMatchBusinessNames
    static private function pointFixNullMinutesFromPgh_PlusCodes()
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        try {
            $msg .= rrwUtil::deltaTimer();  // set the start time
            $sqlFind = "select iconId from $wpdbExtra->icons where minutesFromPgh is null or plusCode is null";
            $recicons = $wpdbExtra->get_resultsA($sqlFind);
            $msg .= "I#1530 found " . $wpdbExtra->num_rows . " null entries for minutes from PGH or plus codes, ";
            $cnt = 0;
            foreach ($recicons as $recIcon) {
                $cnt++;
                if ($cnt > 1500)    // limit the number of updates to something create than the number of icons
                    throw new Exception("$errorBeg too many updates in pointFixNullMinutesFromPgh_PlusCodes while updating minutesFromPgh $errorEnd");
                $iconId = $recIcon["iconId"];
                $msg .= freewheelingeasy_edit_shove::latLonMoved($iconId);;
            } // end foreach
            if (0 == $cnt && 0 == $wpdbExtra->num_rows)
                $msg .= " no records updated " . self::$okayLabel;
            else
                $msg .= "updated $cnt records " . self::$problemLabel;
        } catch (Exception $e) {
            $msg .= "$msg $errorBeg " . $e->getMessage() . "pointFixNullCalcs()  $errorEnd";
        }
        return $msg;
    }
    public static function updateViewTables($whereFrom = "", $makeAll = false)
    {
        // 	the 07... tables are really views, but they are available as tables
        //      this means that before using one of them, they need to be updated
        //      this is done in the name of accessing efficiencies
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $debugCreate = false;
        $msg .= freeWheeling_edit_setGlobals::setGlobals("freewheeling_edit_create_views");
        // ---------------------------------------------------------------------------------------------
        if (false == $makeAll)
            $makeAll = rrwParam::Boolean("makeall");
        if ($makeAll || $debugCreate) {
            $msg .= "<strong>I#1545 Recreated the views </strong> - $whereFrom $eol";
            $makeAll = true;
        } else {
            // $msg .= "<strong>Updated the views</strong> - $whereFrom ";
        }
        try {
            if (false || $makeAll) {
                $tempView = $wpdbExtra->tempTable;
                $sql = "CREATE OR REPLACE VIEW  $tempView as
					select * from $wpdbExtra->trails
					left join $wpdbExtra->icons on trId = trailId";
                if ($debugCreate) print  " $tempView ";
                $msg .= self::doSql($sql);
                $sql = "DROP TABLE IF EXISTS $wpdbExtra->trailIcons";
                if ($debugCreate) print "$sql $eol";
                $msg .= self::doSql($sql);
                $sql = "create table $wpdbExtra->trailIcons select * from  $tempView";
                $msg .= self::doSql($sql);
                $sql = "ALTER TABLE $wpdbExtra->trailIcons ADD INDEX(`trId`)";
                $msg .= self::doSql($sql);
                $sql = "ALTER TABLE $wpdbExtra->trailIcons ADD  PRIMARY KEY(trId, `iconName`)";
                $msg .= self::doSql($sql);
                $sql = "drop view  $tempView";
                $msg .= self::doSql($sql);
                if ($debugCreate) $msg .= "created view $wpdbExtra->trailIcons $eol";
            } else {
                if ($debugCreate) $msg .= ",$wpdbExtra->trailIcons ";
                $sql = "truncate table $wpdbExtra->trailIcons ";
                $msg .= self::doSql($sql);
                $sql = "insert into $wpdbExtra->trailIcons
                        select * from $wpdbExtra->trails left join $wpdbExtra->icons on trId = trailId";
                $insertCount = $wpdbExtra->query($sql);
                if ($insertCount == 0) {
                    $wpdbExtra->print_error();
                    throw new Exception(message: "$msg $errorBeg E#1515 num rows failed to insert any rows
									perhaps you need a makeall=please $errorEnd $sql $eol");
                }
                if ($debugCreate) $msg .= "updated view $wpdbExtra->trailIcons $eol";
                $debugCreate = false;
            } // end if makeall trailIcons
        } catch (Exception $ex) {
            $msg .= "$errorBeg " . $ex->getmessage() . $errorEnd;
            $wpdbExtra->print_error();
        }
        // ---------------------------------------------------------------------------------------------  trailLines
        if (false || $makeAll) {
            $tempView = $wpdbExtra->tempTable;
            if ($debugCreate) $msg .= ", $tempView ";
            $sql = "CREATE OR REPLACE VIEW `$tempView` as
					select * from $wpdbExtra->trails
					join $wpdbExtra->lines on trId = trailId";
            $msg .= self::doSql($sql);
            $sql = "DROP TABLE IF EXISTS $wpdbExtra->trailLines";
            $msg .= self::doSql($sql);
            $sql = "create table $wpdbExtra->trailLines select * from `$tempView`";
            $msg .= self::doSql($sql);
            $sql = "ALTER TABLE $wpdbExtra->trailLines ADD INDEX(`trId`)";
            $msg .= self::doSql($sql);
            $sql = "ALTER TABLE $wpdbExtra->trailLines ADD INDEX(`lineName`)";
            $msg .= self::doSql($sql);
            $sql = "ALTER TABLE $wpdbExtra->trailLines ADD PRIMARY KEY(`lineId`)";
            $msg .= self::doSql($sql);
            $sql = "drop view `$tempView`";
            $msg .= self::doSql($sql);
            if ($debugCreate) $msg .= "created view $wpdbExtra->trailLines $eol";
        } else {
            if ($debugCreate) $msg .= ", $wpdbExtra->trailLines ";
            $sql = "truncate table $wpdbExtra->trailLines ";
            $msg .= self::doSql($sql);
            $sql = "insert into $wpdbExtra->trailLines select * from $wpdbExtra->trails join $wpdbExtra->lines on trId = trailId";
            $msg .= self::doSql($sql);
            if ($debugCreate) $msg .= "updated view $wpdbExtra->trailLines $eol";
        }
        $sql = "truncate table $wpdbExtra->businessServices ";
        $cnt = $wpdbExtra->query($sql);
        if (false === $cnt) {
            $msg .= "$errorBeg E#1540 table $wpdbExtra->businessServices failed to truncate "
                . $wpdbExtra->print_error() . $errorEnd;
            $makeall = true;    // cause creation of the table
        }
        // --------------------------------------------------------------------------------------------- businessServices
        if (false || $makeAll) {
            $tempView = $wpdbExtra->tempTable;
            if ($debugCreate) $msg .= ", $tempView ";
            $sql = "CREATE OR REPLACE VIEW `$tempView` as
					select * from $wpdbExtra->business
					left join $wpdbExtra->services on bizId = svcId";
            if ($debugCreate) $msg .= "starting $tempView $sql $eol";
            $msg .= self::doSql($sql);
            $sql = "DROP TABLE IF EXISTS $wpdbExtra->businessServices";
            $msg .= self::doSql($sql);
            $sql = "create table $wpdbExtra->businessServices select * from `$tempView`";
            $msg .= self::doSql($sql);
            $sql = "ALTER TABLE $wpdbExtra->businessServices ADD PRIMARY KEY(`bizId`)";
            $msg .= self::doSql($sql);
            $sql = "drop view `$tempView`";
            $msg .= self::doSql($sql);
            if ($debugCreate) $msg .= "created view $wpdbExtra->businessServices $eol";
        } else {
            if ($debugCreate) $msg .= ", $wpdbExtra->businessServices ";
            try {
                $sql = "truncate table $wpdbExtra->businessServices ";
            } catch (Exception $ex) {
                $wpdbExtra->print_error();
                throw new Exception("$msg $errorBeg E#1519 num rows failed to insert any rows");
            }
            $msg .= self::doSql($sql);
            $sql = "insert into $wpdbExtra->businessServices select * from $wpdbExtra->business left join $wpdbExtra->services on bizId = svcId";
            $msg .= self::doSql($sql);
            if ($debugCreate) $msg .= "updated view $wpdbExtra->businessServices $eol";
        }
        $debugCreate = false;
        return $msg;
    }   // end function create_views
    private static function doSql($sql)
    {
        // execute the sql statement. if debug is on, print the sql and the number of records updated
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $debugDoSql = rrwParam::Boolean("debugdosql");
        $msg = "";
        if ($debugDoSql) $msg .= "$sql ";
        $cnt = $wpdbExtra->query($sql);
        if ($cnt === false) {
            $wpdbExtra->print_error();
            throw new Exception("$msg E#1520 $errorBeg create view:doSql:fail $errorEnd $sql $eol");
        }
        if ($debugDoSql)
            $msg .= "Updated $cnt records. $eol";
        return $msg;;
    } //
    public static function CheckLineWorkContinuity()
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $msg .= freewheelingeasy_edit_routes::imposeRoutesAll();
        $sqlTitle = "select grpId, grpName, lineSql, is_continuous from $wpdbExtra->trail_routes
                where is_continuous = 1
						order by grpId ";
        $recTitles = $wpdbExtra->get_resultsA($sqlTitle);
        foreach ($recTitles as $recTitle) {
            $title = $recTitle["grpName"];
            $grpId = $recTitle["grpId"];
            $msg .= self::checkSingleContinuity($grpId, $title);
        }
        return $msg;
    }
    private static function checkSingleContinuity($trailIdOrGroupId, $title)
    {
        // route selection is a comma separated list of desired routes to include
        // is the trail of the route
        // Check each line for match between end of previous and start of current
        global $wpdbExtra, $eol, $errorBeg, $errorEnd;
        global $meters2Mile;
        $msg = "";
        $debugConCheck = rrwParam::Boolean("debugconcheck");
        if (strpos($title, "Oil xx") !== false)
            $debugConCheck = true;
        if ($debugConCheck) $msg .= " CheckContinuityOne ($trailIdOrGroupId, $title) $eol";
        $sqlWhere = freewheeling_kml_common::sqlWhereForGroupOrTrailLines($trailIdOrGroupId);
        $sqlLine = "select lineId, latEnd, lngEnd, latStart, lngStart, sequence, trailId,
                                lineName, lengthMeters, routes
                    from $wpdbExtra->lines
                     where $sqlWhere
                    order by sequence ";
        if ($debugConCheck) $msg .= "$sqlLine $eol";
        $reclines = $wpdbExtra->get_resultsA($sqlLine);
        if ($wpdbExtra->num_rows == 0) {
            $msg .= "$errorBeg E#1525 got zero rows of data for where $title  $errorEnd $sqlLine $eol";
            return $msg;
        }
        $pastLatitudeEnd = $reclines[0]["latStart"];
        $pastLongitudeEnd = $reclines[0]["lngStart"];
        $pastLineName = $reclines[0]["lineName"];
        $pastLineId = $reclines[0]["lineId"];
        $pastTrailId = $reclines[0]["trailId"];
        $pastRoute = $reclines[0]["routes"];
        $totalLengthMeters = 0;
        $badConnections = 0;
        foreach ($reclines as $recLine) {
            if (($pastLatitudeEnd != $recLine["latStart"]) || ($pastLongitudeEnd != $recLine["lngStart"])) {
                if ($badConnections == 0) {
                    $msg .= "E#1539 <strong>$title</strong> ($title) is not continuous $eol ";
                }
                $lineName = $recLine["lineName"];
                $trailId = $recLine["trailId"];
                $route = $recLine["routes"];
                $lineId = $recLine["lineId"];
                $linkEnd = FreewheelFormat::latitudeMapLink($pastLatitudeEnd, $pastLongitudeEnd);
                $linkStart = FreewheelFormat::latitudeMapLink($recLine["latStart"], $recLine["lngStart"]);
                $linkMap1 = FreewheelFormat::EditLineLink($pastLineId);
                $linkMap2 = FreewheelFormat::EditLineLink($lineId);
                $distanceMeter = distanceMeters($pastLatitudeEnd, $pastLongitudeEnd, $recLine["latStart"], $recLine["lngStart"]);
                $startCoords = $recLine["latStart"] . "," . $recLine["lngStart"];
                $msg .= "$errorBeg $sqlLine $errorEnd
                E#1510 $pastLatitudeEnd, $pastLongitudeEnd $linkMap1 past line Name = $pastTrailId/$pastLineName' with $pastRoute does not end
                        where $eol
                E#1501 $startCoords $linkMap2 connect to $trailId/$lineName with $route begins $eol
            <a href=\"https://www.google.com/maps/dir/'$pastLatitudeEnd, $pastLongitudeEnd'/$startCoords/\"" .
                    " target='lineCheck'> connect points </a> --
                    end coordinate $linkEnd $pastLatitudeEnd, $pastLongitudeEnd, start coordinates $linkStart " .
                    $recLine['latStart'] . "," . $recLine['lngStart'] . ", distance of <strong>$distanceMeter </strong> $eol";
                $badConnections++;
            }
            $lengthMeters = $recLine["lengthMeters"];
            $totalLengthMeters += $lengthMeters;
            //  https://www.google.com/maps/dir/'42.1389703,-80.0915787'/42.1362706,-80.0667735/
            $pastLatitudeEnd = $recLine["latEnd"];
            $pastLongitudeEnd = $recLine["lngEnd"];
            $pastLineName = $recLine["lineName"];
            $pastLineId = $recLine["lineId"];
            $pastTrailId = $recLine["trailId"];
            $pastRoute = $recLine["routes"];
        } // end foreach line
        if ($badConnections == 0) {
            $msg .= "$title is " . round($totalLengthMeters / 1000, 1) .  " km/ " . round($totalLengthMeters / $meters2Mile, 1)  . " miles" .  self::$okayLabel;
        }
        return $msg;
    }
    // end function CheckContinuityOne
    public static function fixDoubleSpace($field, $tablename)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $totalAdjusted = 0;
        $numRemoved = 1;
        $loopCnt = 0;
        $numRemoved = 1;
        while ($numRemoved > 0) {
            $loopCnt++;
            if ($loopCnt > 10) {
                throw new Exception("E#1523 removing double spaces:Sql:fail field = $field, tablename = $tablename $eol");
            }
            $sglRemoved = "update $tablename set $field = replace ($field, '  ',' ') ";
            $numRemoved = $wpdbExtra->query($sglRemoved);
            if ($numRemoved != 0 && (false === $numRemoved || empty($numRemoved))) {
                throw new Exception("E#1524 removing double spaces:Sql:fail field = $field, tablename = $tablename $eol -$numRemoved- $sglRemoved $eol");
            }
            $totalAdjusted += $numRemoved;
        }
        return $totalAdjusted;
    }
    private static function upDateRoutesBasedOnMapStyle($route, $sqlWhere)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $debugRoutes = rrwParam::Boolean("debugRoutes");
        $msg = "";
        $sqlDel = "update `$wpdbExtra->lines` set routes = replace(routes, ', $route', '') ";
        if ($debugRoutes) $msg .= "$sqlDel $eol";
        $deleteCnt = $wpdbExtra->query($sqlDel);
        $sqlAdd = "update `$wpdbExtra->lines` set routes = concat(routes, ', $route') $sqlWhere";
        if ($debugRoutes) $msg .= "$sqlAdd $eol";
        $addCnt = $wpdbExtra->query($sqlAdd);
        $msg .= "[ <strong>$route</strong> count was $deleteCnt, now $addCnt ] ";
        return $msg;
    }
    /**
     * Updates the icon with the line match information.
     *
     * This function updates the icon's line ID and sort order in the database based on the provided
     * latitude, longitude, and record lines. It also generates a map link for checking the line.
     *
     * @param int $iconId The ID of the icon to update.
     * @param float $latitude The latitude of the icon's location.
     * @param float $longitude The longitude of the icon's location.
     * @param array $recLines An array of record lines containing line match information.
     *
     * @return array An array containing a message and a map link for line checking.
     */
    public static function updateIconwiththelineMatch($iconId, $latitude, $longitude, $recLines)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $recLine = $recLines[0];
        $latMax = $recLine["latMax"];
        $latMin = $recLine["latMin"];
        $lngMax = $recLine["lngMax"];
        $lngMin = $recLine["lngMin"];
        $lineId = $recLine["lineId"];
        $latMid = $latMax / 2 + $latMin / 2;
        $lngMid = $lngMax / 2 + $lngMin / 2;
        $sequence = $recLine["sequence"];
        $maplink = "<a href='https://www.google.com/maps/dir/?api=1&origin=$latitude,$longitude" .
            "&destination=$latMid,$lngMid' target='linecheck'> in the box </a> ";
        $sort = "$sequence - Unknown";
        $sqlUpdate = "update $wpdbExtra->icons set iconLineId = $lineId, sort = '$sort'
                    where iconId = $iconId";
        $numUpdated = $wpdbExtra->query($sqlUpdate);
        return array($msg, $maplink);
    } // end function updateIconwiththelineMatch
    private static function checkIconsForDuplicateName()
    { // #1
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $sqlIcons = "SELECT distinct iconName, trailId FROM $wpdbExtra->icons
                where not trailId = 'mileposts' and not iconName like 'Milepost%' and not iconName like '%estimated%'
                group by iconName having count(*) > 1";
        $recIcons = $wpdbExtra->get_resultsA($sqlIcons);
        foreach ($recIcons as $recIcon) {   //  loop through the duplicate names
            $iconName = $recIcon["iconName"];
            $trailId = $recIcon["trailId"];
            $sqlMatch = "select latitude, longitude, trailId ,iconId, iconName, milepostPrefix, milepost, onMap, isTrailHead from $wpdbExtra->icons
                        where iconName = '$iconName' ";
            $recMatch = $wpdbExtra->get_resultsA($sqlMatch);
            if ($wpdbExtra->num_rows < 2) {
                $msg .= "$errorBeg E#1505 only one duplicate found expected more for iconName - $iconName $errorEnd";
                continue;
            }
            for ($ii = 0; $ii < $wpdbExtra->num_rows - 1; $ii++) {  // loop through the same name icons
                if ($recMatch[$ii]["latitude"] != $recMatch[$ii + 1]["latitude"]) {
                    $msg .= self::displayDuplicateError($recMatch, $ii, "latitudes are different");
                    continue;
                }
                if ($recMatch[$ii]["longitude"] != $recMatch[$ii + 1]["longitude"]) {
                    $msg .= self::displayDuplicateError($recMatch, $ii, "longitudes are different");
                    continue;
                }
                if ($recMatch[$ii]["trailId"] == $recMatch[$ii + 1]["trailId"]) {
                    $msg .= self::displayDuplicateError($recMatch, $ii, "duplicate trailId and iconName");
                    continue;
                }
                if (
                    $recMatch[$ii]["milepostPrefix"] == $recMatch[$ii + 1]["milepostPrefix"] &&
                    $recMatch[$ii]["milepost"] != $recMatch[$ii + 1]["milepost"]
                ) {
                    $msg .= self::displayDuplicateError($recMatch, $ii, "same prefix but different mileage");
                    continue;
                }
                // if we get here, we have a duplicate name at the same location on different trails which is a "junction"
            } // end for ii
        } // end foreach recIcons
        return $msg;
    } // end function checkIconsForDuplicateName
    private static function displayDuplicateError($recMatch, $ii, $errorType)
    {
        global $errorBeg, $errorEnd;
        $msg = "";
        $lat1 = $recMatch[$ii]["latitude"];
        $lat2 = $recMatch[$ii + 1]["latitude"];
        $lon1 = $recMatch[$ii]["longitude"];
        $lon2 = $recMatch[$ii + 1]["longitude"];
        $trailId1 = $recMatch[$ii]["trailId"];
        $trailId2 = $recMatch[$ii + 1]["trailId"];
        $dist = distanceMeters($lon1, $lat1, $lon2, $lat2);
        $icon1Link = FreewheelFormat::EditIconLink($recMatch[$ii]["iconId"]);
        $icon2Link = FreewheelFormat::EditIconLink($recMatch[$ii + 1]["iconId"]);
        $msg .= "$errorBeg E#1506 $errorType Distance = $dist meters $errorEnd
                    ($trailId1/$icon1Link), ($trailId2/$icon2Link)";
        $msg .=  self::displayTwoDatabaseIcons($recMatch[$ii]["iconId"],  $recMatch[$ii + 1]["iconId"]);
        return $msg;
    }
    private static function displayTwoDatabaseIcons($iconId1, $iconId2)
    {
        global $wpdbExtra;
        global $eol;
        $msg = "";
        $sqlIcons = "SELECT * from $wpdbExtra->icons
                where iconId = $iconId1 or iconId = $iconId2 ";
        $msg .= "<table> \n";
        $recIcons = $wpdbExtra->get_resultsA($sqlIcons);
        foreach ($recIcons as $recIcon) {
            $trailId = $recIcon["trailId"];
            $iconId = $recIcon["iconId"];
            $iconName = $recIcon["iconName"];
            $latitude = $recIcon["latitude"];
            $longitude = $recIcon["longitude"];
            $onMap = $recIcon["onMap"];
            $isTrailHead = $recIcon["isTrailHead"];
            $milepostPrefix = $recIcon["milePostPrefix"];
            $milepost = $recIcon["milepost"];
            $link = freeWheelFormat::EditIconLink($iconId, $iconName);
            $msg .= rrwFormat::CellRow($trailId, $link, $latitude, $longitude, $onMap, $isTrailHead, $milepostPrefix, $milepost);
        }
        $msg .= "</table> \n";
        return $msg;
    } // end function displayTwoDatabaseIcons
    /**
     * Updates the mileages of trail junctions based on their junction codes.
     *
     * This function processes the junctions in the database and updates the mileages
     * for trail junctions with specific codes (-4 and -5). It ensures that the mileages
     * are correctly propagated from the end of one trail to the start of the next.
     *
     *  Assume that icons have a mileage, common points are named the same and have give (-4), receive (-5) codes
     *
     * @return string $msg A message detailing the operations performed and any errors encountered.
     */

    public static function ImposeMilepostPrefix()
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $debugPostPrefix = rrwParam::isDebugMode("debugpostprefix", false);
        $sqlPrefix = "update $wpdbExtra->icons
                        join $wpdbExtra->trails on trId = trailId
                    set milepostPrefix = trmilepostprefix";
        if ($debugPostPrefix) $msg .= "$sqlPrefix  $eol";
        $cntFixPrefix = $wpdbExtra->query($sqlPrefix);      // set the icon milepost prefix to the trail milepost prefix
        if ($debugPostPrefix) $msg .= "fixed $cntFixPrefix icons with the trail milepost prefix $eol";
        $sqlPrefix = "update $wpdbExtra->access
                        join $wpdbExtra->trails on trId = trailId
                    set trailMilepostPrefix  = trMilepostPrefix";
        if ($debugPostPrefix) $msg .= "$sqlPrefix  $eol";
        $cntCntAccessPrefix = $wpdbExtra->query($sqlPrefix);      // set the access milepost prefix to the trail milepost prefix
        if ($debugPostPrefix) $msg .= "fixed $cntCntAccessPrefix accesses with the trail milepost prefix $eol";
        $sqlBlankMile = "delete from $wpdbExtra->access where trailMilepost = '' or trailMilepost is null";
        if ($debugPostPrefix) $msg .= "$sqlBlankMile  $eol";
        $cntBlank =  $wpdbExtra->query($sqlBlankMile);
        if ($debugPostPrefix) $msg .= "deleted $cntBlank accesses where there was a blank mileoost $eol";
        return $msg;
    } // end function ImposeMilepostPrefix
    /**
     * Generates and updates the icon style for a milepost icon.
     *
     */
    public static function checkOrImposeMilepostIconStyle()
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $debugImposeMile = rrwParam::isDebugMode("debugImposeMile", true);
        try {
            $sqlMilpostsInvald = "select trailId, iconId, iconName, iconStyle from $wpdbExtra->icons
                        where iconName like '%Milepost%'
                                 and (substring(iconStyle,1,5) != 'mpEst' and substring(iconStyle,1,5) != 'mpPic')
                                  and position('.' in iconName) = 0";
            $recMileposts = $wpdbExtra->get_resultsA($sqlMilpostsInvald);
            if (0 != $wpdbExtra->num_rows) {
                $msg .= "$errorBeg I#99 found " . $wpdbExtra->num_rows . " points with milepost in their name, but iconstyle
                                    not a milepost $errorEnd $sqlMilpostsInvald $eol";
                $msg .=  "<table>" . rrwFormat::CellHeaderRow("Icon Name", "Old Style", "New Style", "Status");
                foreach ($recMileposts as $recMilepost) {
                    $trailId = $recMilepost["trailId"];
                    $iconId = $recMilepost["iconId"];
                    $iconName = $recMilepost["iconName"];
                    $iconStylePast = $recMilepost["iconStyle"];
                    $msg .= "$trailId-$iconName $iconStylePast";
                    $displayIconName = freewheelFormat::EditIconLink($iconId) . $iconName;
                    $matchSuccess = preg_match("/[^\d]*(\d*)/", $iconName, $match);
                    if (count($match) != 2) {
                        $msg .= self::displayImposeStyle($displayIconName, $iconStylePast, "", "E#1513 iconname $iconName parse did return two itens");
                        continue;
                    }
                    $milepost = $match[1];
                    //print "$milepost $eol";
                    if (! is_numeric($milepost)) {
                        $milepostGuess = $match[1];
                        $msg .= self::displayImposeStyle($displayIconName, $iconStylePast, "", "E#1531 $iconName parsed number'$milepostGuess is not a number");
                        continue;
                    }
                    if (strpos($iconName, ".") !== false) {
                        if ("flag.png" == $iconStylePast)
                            continue; // we have milepost 5.5. and a flag
                        $msg .= self::displayImposeStyle($displayIconName, $iconStylePast, "", "E#1535 $iconName parsed number '$milepost is not an integer and not flag.png");
                        continue;
                    }
                    // we have a number at the end of the iconname and known invalid style
                    $tail = "$milepost.png";
                    if (stripos($iconName, "Estimated") !== false) {
                        $iconStyle = "mpEst$tail";
                    } elseif (substr($iconName, 0, 2) == "MP") {
                        $iconStyle = "mpPic$tail";
                    } elseif (stripos($iconName, "Milepost") !== false) {
                        $iconStyle = "mpPic$tail";
                    } else {
                        $msg .= self::displayImposeStyle($displayIconName, $iconStylePast, "", "E#1536 $iconName does not have 'milepost' or 'MP' in the name $eol");
                        continue;
                    }
                    $msg .= self::displayImposeStyle($displayIconName, $iconStylePast, $iconStyle, "updated");
                    $sql = "update $wpdbExtra->icons set iconStyle = '$iconStyle' where iconId = $iconId";
                    $msg .= $wpdbExtra->query($sql);
                } // end foreach recMileposts
                $msg .= "</table>";
            } // end if num_rows != 0
        } catch (Exception $ex) {
            $msg .= "$errorBeg E#1522 " . $ex->getMessage() . "at bottom of imposeMilepostIconStyle $errorEnd";
            throw new Exception($msg);
        }
        return $msg;
    } // end function imposeMilepostIconStyle
    private static function displayImposeStyle($iconname, $oldStyle, $newStyle, $status)
    {
        return rrwFormat::CellRow($iconname, $oldStyle, $newStyle, $status);
    }
} // end class freeWheelingClean
function latitudeCheck($table, $latName, $lngName)
{
    global $eol, $wpdbExtra;
    global $ignoreLatLng;
    $msg = "";
    if (empty($ignoreLatLng)) {
        $sqlIgnoe = "select fixValue from $wpdbExtra->exceptions where fixType = 'ignoreLatLonCheck'";
        $recIgnores = $wpdbExtra->get_resultsA($sqlIgnoe);
        $ignoreLatLng = "";
        foreach ($recIgnores as $recIgnore) {
            $ignoreLatLng .= ", '" . str_replace("'", "\'", $recIgnore["fixValue"]) . "'";
        }
        $ignoreLatLng = substr($ignoreLatLng, 2);
        // $msg .= "ignoreLatLng = $ignoreLatLng $eol";
    }
    $BizOutsideBounds = " and not bizName in ($ignoreLatLng) ";
    $tableDisplayName = substr($table, 10);
    $tableDisplayName = str_replace("_", "", $tableDisplayName);
    $trailInfo = freeWheeling_edit_setGlobals::trailInfoEmpty("dummy", "not found");
    $maxlat = $trailInfo["north"];
    $minlat = $trailInfo["south"];
    $maxlng = $trailInfo["west"];
    $minlng = $trailInfo["east"];
    switch ($table) {
        case $wpdbExtra->business:
            $selectItems = "bizId, bizName";
            break;
        case $wpdbExtra->regions:
        case $wpdbExtra->icons:
        case $wpdbExtra->lines:
            $selectItems = "trailId";
            break;
        default:
            $selectItems = "*";
            break;
    }
    $sql2 = "SELECT $selectItems, $lngName, $latName
                FROM `$table` WHERE ($lngName > $minlng or $lngName < $maxlng or
				$latName > $maxlat or $latName < $minlat)";
    // if ( $table==$wpdbExtra->regions )
    // $sql2 .=" and not trailId = 'emerald' and not trailId = 'county' and not trailId= 'regionPaths' " ;
    if ($table == $wpdbExtra->business)
        $sql2 .= "and not $lngName = 0 $BizOutsideBounds ";
    else
        $sql2 .= " and $lngName is null";
    $msg .= shouldBeZero($sql2, " $tableDisplayName - $latName");
    return $msg;
} // end function latitudeCheck
function duplicateItems($task, $table, $fields)
{
    global $wpdbExtra;
    global $eol, $errorBeg, $errorEnd;
    $msg = "";
    $debugDups = rrwParam::isDebugMode("debugDups", false);
    try {
        $msg .= "$task ... table=$table, fields=$fields $eol";
        $sql = "select count(*), $fields from $table "; //where not trailId = 'mileposts' ";
        $sql .= "group by $fields having count(*) > 1 ";
        $msg .= "$sql  $eol";
        $recs = $wpdbExtra->get_resultsA($sql);
        if (is_null($recs)) {
            return "$msg $errorBeg E#1512 perhaps an invalid sql $eol $sql $errorEnd";
        }
        $found = count($recs);
        // $msg .= " found $found -- $sql $eol";
        $firsttime = true;
        foreach ($recs as $rec) {
            if ($table == $wpdbExtra->lines) {
                // $msg .= "looking for duplicate lines ... ";
                $sql = "select * from $table where $fields  " . $rec[$fields];
                $reclines = $wpdbExtra->get_resultsA($sql);
                foreach ($reclines as $recline) {
                    if ($firsttime) {
                        $msg .= "<span style='color:red;'> Problems</span>
                    <table>";
                        $firsttime = false;
                    }
                    $msg .= rrwFormat::CellRow(
                        $recline["trailId"],
                        $recline["lineId"],
                        $recline["lineName"],
                        $recline["latStart"],
                        $recline["latEnd"],
                        $recline[$fields],
                    );
                }
            } elseif ($table == $wpdbExtra->icons) {
                // $msg .= "looking for duplicate icons ... ";
                $sql = "select * from $table where latitude = " . $rec['latitude'];
                $reclines = $wpdbExtra->get_resultsA($sql);
                foreach ($reclines as $recline) {
                    if ($firsttime) {
                        $msg .= "<span style='color:red;'> Problems</span>
                        <table>";
                        $firsttime = false;
                    }
                    $msg .= rrwFormat::CellRow(
                        $recline["trailId"],
                        $recline["iconId"],
                        $recline["iconName"]
                    );
                }
            } else {
                $msg .= rrwFormat::CellRow("$errorBeg E#1511 Unknown table entered of $table $errorEnd $sql $eol");
            }
        }
        if ($firsttime) {
            $msg .= freeWheelingClean::$okayLabel;
        } else
            $msg .= "</table>";
    } catch (Exception $ex) {
        $msg .= "$errorBeg E#1527 " . $ex->getMessage() . "at bottom of duplicateItems $errorEnd";
        throw new Exception($msg);
    }
    return $msg;
}
function changeLineStyle($old, $new)
{
    global $wpdbExtra;
    $msg = "";
    $sql = "update $wpdbExtra->lines set mapstyle = '$new' where mapstyle = '$old' ";
    $msg .= $wpdbExtra->query($sql);
    return $msg;
}
function changeIconStyle($old, $new)
{
    global $wpdbExtra;
    $sql = "update $wpdbExtra->icons set iconstyle = '$new' ";
    if ($new == "flag")
        $sql .= ", istrailhead = 0 ";
    $sql .= " where iconstyle = '$old' ";
    return $wpdbExtra->query($sql);
}
function shouldBeZeroExtra($sql, $problemDescription = "", $extra = "")
{
    return shouldBeZero($sql, $problemDescription, false, $extra = "");
}
function shouldBeZero($sql, $problemDescription = "", $displaySQL = false, $extra = "")
{
    global $wpdbExtra;
    global $eol, $errorBeg, $errorEnd;
    $msg = "";
    try {
        $sqlWho = "select iconStyle from $wpdbExtra->icons where iconName = 'north end bridge' ";
        $style = $wpdbExtra->get_var($sqlWho);
        //$msg .= str_repeat("-", 50) . "$style $eol";
        if ($displaySQL)  print "$problemDescription  ---=---  $sql $eol";
        $recs = $wpdbExtra->get_resultsA($sql);
        if ($displaySQL)  print "$problemDescription  ---=---  $recs $eol";
        $found = $wpdbExtra->num_rows;
        if (0 == $found) {
            $msg .= "$problemDescription ... " . freeWheelingClean::$okayLabel;
            return $msg;
        }
        if ($displaySQL) print "$problemDescription  found $found problems $eol";
        $msg .= "<strong>$problemDescription ... </strong>" . freeWheelingClean::$problemLabel . " $eol
                        Found $found Records, but should be zero with the following query$eol $sql $eol
                        <table>\n";
        $color = "white";
        if ($displaySQL) print " about to loop through records $eol";
        foreach ($recs as $rec) {
            $msg .= "<tr style='background-color:$color'>\n";       // we add rrwFormat::Cell($value) the $msg
            foreach ($rec as $item => $value) {
                switch ($item) {
                    case "deletethis":
                    case "deleteThis":
                        $value = "[ <a href='/changebizId?task=delete&amp;bizId=$value' target='anoma'>delete</a> ]";
                        break;
                    case "iconId":
                        $value = FreewheelFormat::EditIconLink($value);
                        $value = str_replace("href", "target='anoma' href", $value);
                        break;
                    case "lineiconId":
                    case "lineIconId":
                        $value = FreewheelFormat::EditlineLink($value);
                        $value = str_replace("href", "target='anoma' href", $value);
                        break;
                    case "isTrailHead":
                        $value = freewheelFormat::DisplayIsTrailHead($value);
                        break;
                    case "iconName":
                    case "startIcon":
                    case "endIcon":
                        $value = FreewheelFormat::EditIconLink("", $value);
                        $value = str_replace("href", "target='anoma' href", $value);
                        break;
                    case "latitude":
                    case "longitude":
                    case "bizlat":
                    case "bizlng":
                    case "bizLat":
                    case "bizLng":
                    case "trailLatitude":
                    case "trailLongitude":
                    case "google_types":
                        //  display the value no name
                        break;
                    case "bizName":
                        $value = "";
                        break;
                    case "lineId":
                        $valueSingleSpace = str_replace("  ", " ", $value);
                        $value = freeWheelFormat::EditlineLink($value) . " ] ";
                        $value = str_replace("href", "target='anoma' href", $value);
                        break;
                    case "bizId":
                    case "bizid":
                    case "accBizId":
                    case "htmbizId":
                        $value .= freeWheelFormat::BizLink($value);
                        $value = str_replace("href", "target='anoma' href", $value);
                        break;
                    case "search":
                        $value = " <a href='/amensearch?search=$value' target='anoma'>search name</a> ]";
                        break;
                    case "svcId":
                        $value = freeWheelFormat::EditServiceLink($value);
                        $value = str_replace("href", "target='anoma' href", $value);
                        break;
                    case "hisId":
                        $value = freewheelingeasy_make_amenities::formatHistoryLink($value);
                        $value = str_replace("href", "target='anoma' href", $value);
                        break;
                    case "trailId":
                    case "trId":
                    case "trid":
                    case "htmTrailid":
                        $value = freeWheelFormat::TrailLink($value);
                        $value = str_replace("href", "target='anoma' href", $value);
                        break;
                    case "segmentId":
                        $value = "<a href='https://edit.shaw-weil.com/edit-segment/?segmentId=$value' target='segment'>seg#$value</a>";
                        break;
                    case "AccIconName":
                        $value = rrwFormat::Cell("Icon name may have been changed " .
                            "<a href='/changebizId?old=$value'&new=' target='iconName'>'$value'<a>");
                        break;
                    case "landingPage":
                        $landingPage = $value;
                        $value = "landingPage - <a href='$value' target='landingPage'>$value</a>
                                            <img src='https://freewheelingeasy.com/prebuilt/images/pngtree-vector-copy-icon-png-image_695355.jpg' height='20 px' width='20 px'
                                            onclick=\"FreeWheelCopyText('$landingPage')\">";
                        break;
                    case "bookurl":
                    case "bookUrl":
                        $value = "bookurl - <a href='$value' target='bookurl'>$value</a>";
                        break;
                    case "bookVolume":
                        if (key_exists("trId", $rec)) {
                            $trailid = $rec["trId"];
                            $trailLnk = freeWheelFormat::TrailLink($trailid);
                        } else {
                            $trailLnk = " add trailId to sql";
                        }
                        $value = "bookVolume - <a href='$value' target='bookVolume'>$value $trailLnk</a>";
                        break;
                    case "svcName":
                        break;           // ddisplay the service name no link
                    case "isTrailHeadDisplay":
                        break; // do not display the trail head display
                    default:
                        $value = "*** '$item' is '$value'";
                } // end switch
                $msg .= rrwFormat::cell($value);
            } // end foreach  ($rec as $item => $value)
            if (! empty($extra)) {
                $msg .= rrwFormat::cell($extra);
            }
            $msg .= "</tr>\n";
            $color = rrwFormat::colorSwap($color);
        } // end foreach  ($recs as $rec)
        $msg .= "</table>\n";
    } catch (Exception $ex) {
        $msg .= "</tr></table>";
        $msg .= "$errorBeg E#1528 " . $ex->getMessage() . "at bottom of shouldBeZero $errorEnd";
        throw new Exception($msg);
    }
    return $msg;
}
function CheckSegmentSequence()
{
    global $wpdbExtra,
        $wpdbExtra;
    global $eol,
        $errorBeg,
        $errorEnd;
    $msg = "";
    $sqlRoutes = "select grpid from $wpdbExtra->trail_routes where is_continuous = 1";
    $recRoutes = $wpdbExtra->get_resultsA($sqlRoutes);
    foreach ($recRoutes as $recRoute) {
        $grpid = $recRoute["grpid"];
        $msg .= CheckOneSegmentSequence($grpid);
    }
    return $msg;
}
function CheckOneSegmentSequence($route)
{
    global $wpdbExtra, $wpdbExtra;
    global $eol, $errorBeg, $errorEnd;
    $msg = "";
    if ($route == "all2tid xx") $debugChaeckOne = true;
    else $debugChaeckOne = false;
    $clean = true;
    $sql = "SELECT startIcon, endIcon, milesAlongTrail,segmentId  FROM `$wpdbExtra->segments`
                join $wpdbExtra->trailMile on endIcon=mile_iconName where mile_route='$route'
                                order by milesalongtrail,
                                startIcon,
                                endIcon";
    if ($debugChaeckOne) $msg .= "$sql $eol";
    $recsegs = $wpdbExtra->get_resultsA($sql);
    if ($wpdbExtra->num_rows == 0) {
        $msg .= "$errorBeg E#1532 got zero rows of data for where mile_route = '$route' $errorEnd";
    } else {
        $endIconPast = $recsegs[0]["startIcon"];
        foreach ($recsegs as $recseg) {
            $startIcon = $recseg["startIcon"];
            $endIcon = $recseg["endIcon"];
            $milesAlongTrail = $recseg["milesAlongTrail"];
            $segmentId = $recseg["segmentId"];
            if ($startIcon == $endIcon)
                continue;
            if (strcmp($endIconPast, $startIcon) != 0) {
                $clean = false;
                $msg .= "$sql $errorBeg E#1526 on segement report
                        <a href='https://edit.shaw-weil.com/status-build/" .
                    "?route=$route' >$route</a>, $endIconPast
                        does not match $startIcon -> $endIcon,
                        id=$segmentId $errorEnd";
            }
            $endIconPast = $endIcon;
        }
    }
    if ($clean) {
        $msg .= "continuty of segement report $route is " . freeWheelingClean::$okayLabel;
    }
    return $msg;
} // end  edit_service( $attrs )
