<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.com
                                                          [\r\n]{2,}
 */
class Freewheelingeasy_kml_create
{
    public static
    function listKMLs($attr)
    {
        global $eol, $errorBeg, $errorEnd;
        try {
            $msg = "";
            $msg .= freeWheeling_edit_setGlobals::setGlobals();
            $trailId = freeWheelParam::trail($attr);
            if (empty($trailId)) {
                $msg .= "<form >";
                $msg .= freewheelingEasy_kml_trailList::trailSelectionBox();
                $msg .= "</form>";
                return $msg;
            }
            $msg .= Freewheelingeasy_kml_create::listKMLForTrailId($trailId);
        } catch (Exception $ex) {
            $msg .= $ex->getMessage() . "$errorBeg E#296 list KMLS somewhere $errorEnd";
        }
        return $msg;
    }
    public static
    function listKMLForTrailId($trailId)
    {
        global $eol, $errorBeg, $errorEnd;
        global $freewheelingeasy_kml_directory;
        $msg = "";
        $debugListKml = false;
        $msg .= '
        <script>
        function pleaseWait() {
        document.getElementById("kmllist").innerHTML =
                "<h1 color=\'red\'>please wait</h1>";
        return true;
        }
        </script>
        ';
        $dir = $freewheelingeasy_kml_directory;
        // Open a directory, and read its contents
        $list = array();
        if (!is_dir($dir)) {
            $msg .= "$errorBeg E#572 bad directory '$dir' $errorEnd";
            return $msg;
        }
        if ($dh = opendir($dir)) {
            while (($file = readdir($dh)) !== false) {
                if (!is_dir("$dir/$file"))
                    array_push($list, $file);
            }
            closedir($dh);
        }
        sort($list);
        //      if ( $debugListKml )$msg .= rrwUtil::print_r( $list, true, "list of available kmls" );
        $direUrl = str_replace("/home/pillowan/www-shaw-weil-edit/", "", $dir);
        $href = "<a  href='https://edit.shaw-weil.com/$direUrl";
        $downloadThis = "";
        $matchString = "/^$trailId" . '[0-9]+.kml/';
        if ($debugListKml) $msg .= "match String $matchString $eol";
        $msg .= "<div id='kmllist'>\n";
        for ($iiItem = 0; $iiItem < count($list); $iiItem++) {
            $item = $list[$iiItem];
            $result = preg_match($matchString, $item, $match);
            if ($result === false)
                throw new exception("$msg $errorBeg E#626 preg_match had an error $errorEnd $matchString $eol");
            if ($result == 0)
                continue; // no match
            if ($debugListKml) $msg .= rrwUtil::print_r($match[0], true, "found match");
            $downloadThis = $item;
            $msg .= " [ $href/$downloadThis' onclick='pleaseWait();''>$downloadThis ] ";
        } // end for ( $iiItem = 0; $iiItem < count( $list ); $iiItem++
        $msg .= "\n</div>\n";
        if (empty($downloadThis)) {
            $msg .= "$msg $errorBeg e#493 did not find $trailId in the kml list using match string $matchString$errorEnd";
            $msg .= Freewheelingeasy_kml_create::formatListKMLs($list, $href);
            return $msg;
        }
        $msg .= "$eol $eol $href/$downloadThis' > Click to download the KML  $downloadThis </a>$eol$eol";
        return $msg;
    }
    private static
    function formatListKMLs($list, $href)
    {
        $msg = "";
        $numCols = 8;
        $numRows = intval(count($list) / $numCols);
        $msg .= "<table>\n";
        for ($iiItem = 0; $iiItem < $numRows; $iiItem++) {
            $msg .= "<tr>\n";
            for ($ii = $iiItem; $ii < count($list); $ii = $ii + $numRows) {
                if ($ii >= count($list))
                    continue;
                $file = $list[$ii];
                $msg .= rrwFormat::Cell("$href/$file' >$file</a>");
            }
            $msg .= "</tr>\n";
        }
        $msg .= "</table>\n";
        return $msg;
    }
    public static function  createKMLFromDatabase($trailId)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        try {
            $msg .= "<a id='top'></a>";
            $msg .= self::jumpToLinks();
            $trailId = freewheeling_kml_common::findTrailId($trailId);
            if (strlen($trailId) < 1) {
                $msg .= "$errorBeg E#575 makeTempFile: Could not find trailId  '$trailId' in the parameters $errorEnd";
            }
            //     return  "$msg $eol temp check hanging --------after -----createKMLFromDatabase-------3-----$eol";
            $debugMakeKML = false;
            $tempfilePathFile = Freewheelingeasy_kml_create::makeTempFile($trailId, "Document", $msg); # this build the basic KML file of data
            # Temp file is created, merge it with Start, styles, and terminations
            $finalFile = freewheeling_kml_common::findNextTrailFile($trailId, true);
            if (empty($finalFile)) {
                throw new Exception("$msg $errorBeg E#563  asked for findNextTrailFile($trailId, true) got nothing $errorEnd");
            }
            if ($debugMakeKML) {
                $msg .= "Creating final file of $finalFile $eol";
            }
            $fpTemp = fopen("$tempfilePathFile", "r");
            if (!is_resource($fpTemp)) {
                $msg .= "$errorBeg The file $tempfilePathFile was not found.$errorEnd";
                throw new Exception($msg);
            }
            $fpNext_kml = fopen($finalFile, "w");
            if (!is_resource($fpNext_kml)) {
                $msg .= "$errorBeg The file $finalFile was not found or created.$errorEnd";
                throw new Exception($msg);
            }
            if ($debugMakeKML) $msg .= "Creating file <strong>$finalFile</strong> from $tempfilePathFile...";
            $line = fgets($fpTemp); // remove the <xml line
            $googleXmlHeader = '<?xml version="1.0" encoding="utf-8"?>
<kml
xmlns="http://www.opengis.net/kml/2.2"
xmlns:kml="http://www.opengis.net/kml/2.2"
xmlns:atom="http://www.w3.org/2005/Atom">
';
            fwrite($fpNext_kml, $googleXmlHeader);
            if ($debugMakeKML) $msg .= "read write to ($tempfilePathFile.. $eol";
            freewheeling_kml_common::readWriteTo($fpTemp, $fpNext_kml, "<Folder", true, $tempfilePathFile); // the Icons/lines folder
            $msg .= freewheeling_kml_common::readWriteStyle("kmlStyleLines.txt", $fpNext_kml, $debugMakeKML);
            $msg .= freewheeling_kml_common::readWriteStyle("kmlStyleIcons.txt", $fpNext_kml, $debugMakeKML);
            if ($debugMakeKML) $msg .= "write first folder $eol";
            //	readWriteStyle("kmlStyleTopo.kml", $fpNext_kml);
            // pull in the rest of the temp  trail
            fwrite($fpNext_kml, "    <Folder>\r\n"); // get the icon folder
            $cntData = freewheeling_kml_common::readWriteTo($fpTemp, $fpNext_kml, "</Document", false, $tempfilePathFile); // the lines folder
            if ($debugMakeKML) $msg .= "write closing $eol";
            fwrite($fpNext_kml, "</Document>\r\n"); // close the document
            fwrite($fpNext_kml, "</kml>");
            fclose($fpTemp);
            fclose($fpNext_kml);
            unlink($tempfilePathFile);
            //    return  "$msg $eol temp check hanging --------after ----- unlink($tempfilePathFile);-------3-----$eol";
            $ff = new Freewheeling_kml_common();
            $webKml = $ff->filename2webName($finalFile);
            $msg .= "I#633 Created from database a Google Earth file <a href='$webKml'>$webKml</a> $eol";
            $msg .= freewheeling_kml_common::displayIconsAndLines($trailId);
            $msg .= self::updateTrSource($finalFile);
            $msg .= "<a id='displayAfterMerge'>" . self::jumpToLinks() . "</a>";
            //      return  "$msg $eol temp check hanging --------before ----- moveOlder2Obsolete;-------3-----$eol";
            $msg .= Freewheelingeasy_kml_create::moveOlder2Obsolete($trailId);
            //    return  "$msg $eol temp check hanging --------after ----- moveOlder2Obsolete);-------3-----$eol";
            $msg .= FreewheelingBuildMileageChart::outputMileByTypeFiles2($trailId);
        } catch (Exception $ex) {
            $msgErr = "Exception in createKMLFromDatabase: " . $ex->getMessage() . " E#621 thrown out of makeTempFile $eol";
            throw new Exception("$msg $errorBeg E#301 $msgErr $errorEnd");
        }
        return $msg;
    } // end public static function  createKMLFromDatabase($trailId)
    /**
     * Updates the trSource field in the trails table with the filename extracted from the given trailFullName.
     *
     * @param string $trailFullName The full name of the trail, including the path and the .kml extension.
     * @return string An error message if an exception occurs, otherwise an empty string.
     */
    public static function updateTrSource($trailFullName)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $debugTrSource = false;
        try {
            $iiSlash = strrpos($trailFullName, "/");
            $filename = substr($trailFullName, $iiSlash + 1);
            $trailId = substr($filename, 0, -6);  // remove the dd.kml
            if (is_numeric(substr($trailId, -1))) {
                $trailId = substr($filename, 0, -7);  // remove the ddd.kml
            }
            if ($debugTrSource) $msg .= "updateTrSource($trailFullName) $filename, $trailId$eol";
            $sql = "update $wpdbExtra->trails set trSource = '$filename' where trId = '$trailId'";
            if ($debugTrSource) $msg .= "$eol$sql$eol";
            $wpdbExtra->query($sql);
        } catch (Exception $ex) {
            $msg .= $ex->getMessage() . "E#873 thrown out of updateTrSource $eol";
        }
        return $msg;
    } // end public static function updateTrSource($trailFullName)
    public static     function makeTempFile($trailId, $DocOrFolder, &$msg)
    {
        /*	make a valid kml file without any stype elements
         *	DocOrFolder is either "Document" or "Folder" depending on who makes the call.
         *  It is the top level container after the "kml" line
         *  if it is the fwe file creater then it is a "Folder"
         *  if is makeOneFile then is is a "Document"
         *
         */
        global $freewheeling_prebuilt_dire, $out;
        global $eol, $errorBeg, $errorEnd;
        $debugMakeTempFile = rrwParam::Boolean("debugMakeTempFile", array(), false);
        if ($debugMakeTempFile) $msg .= "into makeTempFile($trailId, $DocOrFolder)";
        try {
            $trailId = freewheeling_kml_common::findTrailId($trailId);
            if (strlen($trailId) < 1) {
                $msg .= "$errorBeg E#579 makeTempFile: Could not find '$trailId' in the
				'trails' table $errorEnd";
                throw new Exception($msg);
            }
            $trailFullName = freewheeling_kml_common::findTrailFullName($trailId);
            $msg .= "$eol<strong>$trailFullName ... </strong>";
            if (strlen($trailFullName) < 2) {
                $msg .= "$errorBeg makeTempFile: Missing full trail name in database using E#425 $trailId $errorEnd";
                throw new Exception($msg);
            }
            $tempfile = "$freewheeling_prebuilt_dire/temp$trailId.kml";
            if ($debugMakeTempFile) {
                $msg .= " E#510 Creating file $tempfile$eol";
            }
            $out = new XMLWriter();
            $out->openURI($tempfile);
            $out->setIndent(true);
            $out->startDocument();
            $out->startElement($DocOrFolder);
            $out->writeElement("name", $trailFullName);
            $desc = self::buildDescription($trailId, false);
            $out->writeElement("visibility", "1");
            if ($DocOrFolder == "Folder")
                $out->writeElement("open", 0); # closed for the big file list of trails only
            else
                $out->writeElement("open", "1"); # open if just for one trail in the KML
            $out->writeElement("description", $desc);
            date_default_timezone_set('America/New_York');
            //$out->writeElement("FreewheelingEasy:version", date('l jS \of F Y h:i:s A') ) ;
            $msg .= Freewheelingeasy_kml_create::outputLookAt($out, $trailId, $trailFullName);
            $msg .= Freewheelingeasy_kml_create::outputFolderOfIcons($out, $trailId, $trailFullName);
            $msg .= Freewheelingeasy_kml_create::outputFolderOfLines($out, $trailId, $trailFullName, $DocOrFolder);
            $out->endElement(); // Document
            $out->endDocument();
            $out->flush(true);
            return $tempfile;
        } catch (Exception $ex) {
            throw new Exception($msg . $ex->getMessage() . "E#556 thrown out of makeTempFile $eol");
        }
    }
    private static
    function copyIt($source, $dest, $msg = "")
    {
        global $eol, $errorBeg, $errorEnd;
        $msg .= "about to copy $source to $dest --- $msg ";
        if (!@copy($source, $dest)) {
            $msg .= "<span style='color:red' >copy command failed  copy ($source, $dest) </span><br />";
            return false;
        }
        $msg .= "Successfully copied $eol";
        return true;
    }
    private static
    function outputFolderOfLines($out, $trailId, $trailFullName, $DocOrFolder)
    {
        global $eol, $errorBeg, $errorEnd;
        global $sequentialIDs; // switch to create unique ID=
        global $cntLines;
        global $wpdbExtra;
        /*	Outputs af files of line points in textual format for the display routine.
         *  appends to the $out kml file the linework for this trail.
         */
        $msg = "";
        $outputFolderOfLines_debug = false;
        if ($outputFolderOfLines_debug) $msg .= "outputFolderOfLines ( out, $trailId, $trailFullName, $DocOrFolder)$eol";
        //	openDatabase();
        /*
        $fileZZFull = "$freewheeling_prebuilt_dire/data/zz_$trailId.txt";
        		$msg .= "Outputing line work to $fileZZFull $eol";
        		$fpLines = fopen( $fileZZFull , "w" );
        */
        $out->startElement("Folder");
        $out->writeElement("name", "Trail Paths");
        $out->writeElement("visibility", "1");
        if ($DocOrFolder == "Folder")
            $out->writeElement("open", 0); # closed for the big file list of trails only
        else
            $out->writeElement("open", "1"); # open if just for one trail in the KML
        $msg .= Freewheelingeasy_kml_create::outputLookAt($out, $trailId, $trailFullName);
        $out->startElement("Style");
        $out->startElement("ListStyle");
        $out->writeElement("listItemType", "check");
        $out->writeElement("bgColor", "00ffffff");
        $out->endElement(); // end ListStyle
        $out->endElement(); // end Style
        $sql = " select * from $wpdbExtra->lines where trailId = '$trailId' order by sequence ";
        $msg .= "$sql$eol";
        $recs2 = $wpdbExtra->get_resultsA($sql);
        $cnt = 0;
        /* <Placemark id="_line954">
   <name>Wellsburg Park</name>
   <styleUrl>   <styleUrl>#trail
			</styleUrl>
   <LineString>
    <extrude>0</extrude>
    <tessellate>1</tessellate>
    <coordinates>-80.6106038,40.2917222,0 -80.6104870,40.2922776,0 -80.6102731,40.2927720,0 -80.6102080,40.2928073,0 -80.6097755,40.2928269,0 -80.6097070,40.2928116,0 -80.6096615,40.2927748,0 -80.6096491,40.2927156,0 -80.6096696,40.2922640,0 -80.6096876,40.2917409,0 -80.6096769,40.2911519,0 -80.6096175,40.2898020,0 -80.6095909,40.2893106,0</coordinates>
   </LineString>
  </Placemark>
  */
        foreach ($recs2 as $recLine) {
            $cnt++;
            $out->startElement("Placemark");
            $cntLines++;
            if ($sequentialIDs)
                $out->writeAttribute("id", "_" . $sequentialIDs++);
            else
                $out->writeAttribute("id", "_line" . $recLine["lineId"]);
            $lineName = $recLine["lineName"];
            $out->writeElement("name", $lineName);
            $style1 = $recLine["mapstyle"];
            $style = freewheeling_kml_common::cleanStyleUrl($style1, false);
            $out->writeElement("styleUrl", $style);
            $out->startElement("LineString");
            $out->writeElement("extrude", 0);
            $out->writeElement("tessellate", 1);
            $coordin = $recLine["pointList"];
            $len1 = strlen($coordin);
            if ($outputFolderOfLines_debug) $msg .= "$lineName -- $len1  -----------------------------
                        " . $len1 . "<br />$coordin$eol";
            $out->writeElement("coordinates", $coordin);
            $out->endElement(); // end LineString
            $out->endElement(); // end Placemark
        }
        if ($outputFolderOfLines_debug)
            $msg .= "outputRegionBox($trailId, $trailFullName, $DocOrFolder)$eol";
        if ($cnt <> 0) {
            Freewheelingeasy_kml_create::outputRegionBox($trailId, $trailFullName, $DocOrFolder, $out);
        }
        $out->endElement(); // Folder trail paths
        /*
        		fclose( $fpLines );
        */
        if ($outputFolderOfLines_debug) $msg .= "$sql -- found $cnt line$eol";
        return $msg;
    } //
    /**
     * Outputs a folder of parking icons in KML format.
     *
     * This function generates a KML folder containing parking icons for a specific trail.
     * It retrieves icon data from the database, processes it, and writes the corresponding
     * KML elements to the provided XMLWriter object.
     *
     * * the style of item in the KML file is determined by the onMap field in the icons table.
     *          This is a code that is looked up in the codes table to find the google type to use for this icon.
     *
     * @param XMLWriter $out The XMLWriter object to write the KML elements to.
     * @param int $trailId The ID of the trail for which to output parking icons.
     * @param string $trailFullName The full name of the trail.
     * @return string A message containing debug information and any errors encountered.
     */
    private static function outputFolderOfIcons($out, $trailId, $trailFullName)
    {
        global $eol, $errorBeg, $errorEnd;
        global $sequentialIDs; // switch to create unique ID=
        global $cntIcons;
        global $wpdbExtra;
        $msg = "";
        $debugIcons = rrwParam::isDebugMode("debugIcons");
        $sqlOnMap = "select code, googleType from $wpdbExtra->codes
                where codetype = 'isonmap' ";
        $recCodes = $wpdbExtra->get_resultsa($sqlOnMap);
        $onMapList = array();
        foreach ($recCodes as $recCode) {
            $onMapList[$recCode["code"]] = $recCode["googleType"];
        }
        $out->startElement("Folder");
        $out->writeElement("name", "Parking icons");
        $out->writeElement("visibility", "1");
        $out->writeElement("open", "1");
        $msg .= Freewheelingeasy_kml_create::outputLookAt($out, $trailId, $trailFullName); # View point - what shows from where
        $sql = "select * from $wpdbExtra->icons where trailId = '$trailId' order by milepost, iconName";
        if ($debugIcons)  $msg .= "outputFolderOfIcons $sql $eol";
        $recs2 = $wpdbExtra->get_resultsA($sql);
        if ($debugIcons) $msg .= "outputFolderOfIcons found " . count($recs2) . " icons to add$eol";
        $cnt = 0;
        foreach ($recs2 as $rec) {
            $pointName = $rec["iconName"];
            if ($debugIcons) $msg .= " adding $pointName to the kml file $eol";
            # dump_r($rec);
            //
            $onMap = $rec["onMap"];
            if (! array_key_exists($onMap, $onMapList)) {
                $iconId = $rec["iconId"];
                $editLink = freewheelFormat::editIconLink($iconId);
                $msg .= "$errorBeg E#601 point $editLink has given onMap '$onMap' which is not in the allowed list of " . join(", ", array_keys($onMapList)) .  $errorEnd;
                $onMap = "launch";
            } // end if (! array_key_exists($onMap, $onMapList))
            $kmlStyle = $onMapList[$onMap];

            $cnt = $cnt + 1;
            $out->startElement("Placemark");
            $cntIcons++;
            if ($sequentialIDs)
                $out->writeAttribute("id", "_" . $sequentialIDs++);
            else
                $out->writeAttribute("id", "_icon" . $rec["iconId"]);
            $iconName = $rec["iconName"];
            $out->writeElement("name", $iconName);
            $desc = $rec["ptDescription"];
            if (!is_null($desc) && $ii = strpos($desc, '<!--GPS common>')) {
                $desc = substr($desc, 0, $ii - 1);
            }
            $isTrailHead = $rec["isTrailHead"];
            $desc = $desc . freewheeling_kml_common::parkingDescription(
                $rec["iconName"],
                $rec["latitude"],
                $rec["longitude"],
                $isTrailHead
            );
            $out->startElement("description");
            $out->writeCData("$desc");
            $out->endElement(); // description
            $msg .= Freewheelingeasy_kml_create::outputLookAtElements(
                $rec["longitude"],
                $rec["latitude"],
                0,
                $out
            );
            #$msg .= "Style before " . $rec["iconstyle"] . " , style after $style$eol";
            $out->writeElement("styleUrl", $kmlStyle);
            $msg .= Freewheelingeasy_kml_create::outoutIconRegion($rec["latitude"], $rec["longitude"], $out); # turns icons off and on
            $out->startElement("Point");
            $coord = $rec["longitude"] . "," . $rec["latitude"] . ",0 ";
            $out->writeElement("coordinates", $coord);
            $out->endElement(); // end Point
            $out->endElement(); // end Placemark
        } // end foreach ($recs2 as $rec)
        $out->endElement(); // Folder Parking icons
        if ($debugIcons) {
            $msg .= " Output $cnt icons$eol";
        } // end if ($debugIcons)
        return $msg;
    } // end private static function outputFolderOfIcons($out, $trailId, $trailFullName)

    // private static function outputFolderOfIcons(  $out, $trailID
    /**
     * Outputs a LookAt element for a given latitude and longitude.
     *
     * This function generates a LookAt element for a given latitude and longitude
     * and writes the corresponding KML elements to the provided XMLWriter object.
     *
     * @param float $lat The latitude of the LookAt element.
     * @param float $lon The longitude of the LookAt element.
     * @param float $alt The altitude of the LookAt element.
     * @param XMLWriter $out The XMLWriter object to write the KML elements to.
     * @return string A message containing debug information and any errors encountered.
     */
    /*
    private static function outputFolderOfTopos($out, $trailId)
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $topos = self::fetchtopoNames($trailId);
        $toposList = explode(",", $topos);
        $out->startElement("Folder");
        for ($ii = 0; $ii < count($toposList); $ii++) {
            $topo = trim($toposList[$ii]);
            $topoFileName = "/temp/kmltopo/$topo.kml";
            error_reporting(0);
            if (!$fpTopo = fopen($topoFileName, "r")) {
                error_reporting(E_ALL | E_STRICT);
                $msg .= "$errorBeg E#431 Unable to find topo file $topoFileName $errorEnd";
            } else {
                error_reporting(E_ALL | E_STRICT);
                $data = fread($fpTopo, 6000);
                $out->writeRaw($data);
                fclose($fpTopo);
            }
        }
        $out->endElement(); # </Folder>
        return $msg;
    }
        */
    private static function outoutIconRegion($lat, $lon, $out)
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $incrument = .5;
        $out->startElement("Region");
        $out->startElement("latlonBox");
        $out->writeElement("north", $lat + $incrument);
        $out->writeElement("south", $lat - $incrument);
        $out->writeElement("east", $lon + $incrument);
        $out->writeElement("west", $lon - $incrument);
        $out->endElement(); // latlonBox
        $out->startElement("Lod");
        $out->writeElement("minLodPixels", 1500);
        $out->writeElement("maxLodPixels", -1);
        $out->endElement(); // Lod
        $out->endElement(); // Region
        return $msg;
    } // end private static function outoutVewRangeIcons()
    private static
    function outputRegionBox($trailId, $trailFullName, $DocOrFolder, $out)
    {
        global $north, $east, $west, $south; # save for multiple calls
        global $cntTrails;
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $debugRegionBox = false;
        $outputRegionBox_debug = false;
        if ($debugRegionBox) $msg .= "outputRegionBox($trailId, $trailFullName, $DocOrFolder)$eol";
        //	openDatabase ();
        foreach (array(/*"boundry", */"lineBuffer") as $linefield) {
            $msg .= Freewheelingeasy_kml_create::fetchRange($trailId); // fills in the globals $north, $east, $west, $south, $rangeLookat
            $itemDescCleaned = Freewheelingeasy_kml_create::buildDescription($trailId, $outputRegionBox_debug);
            $out->startElement("Placemark");
            $cntTrails++;
            $out->writeElement("name", $trailFullName);
            $out->writeElement("description", $itemDescCleaned);
            if ($DocOrFolder == "Folder")
                $out->writeElement("styleUrl", "#invisbleRegion"); # hidden for the big file list of trails only
            else
                $out->writeElement("styleUrl", "#visbleRegion");; # open if just for one trail in the KML
            $out->startElement("Polygon");
            $out->writeElement("extrude", 0);
            $out->writeElement("altitudeMode", "clampToGround");
            $out->startElement("outerBoundaryIs");
            $out->startElement("LinearRing");
            $sql = "select $linefield from $wpdbExtra->regions where trailID = '$trailId' ";
            $coords = $wpdbExtra->get_var($sql);
            if ($wpdbExtra->num_rows != 1) {
                $msg .= "$errorBeg E#562 No region entry for $sql $errorEnd";
                $coords = "";
            }
            if ($outputRegionBox_debug) {
                $msg .= "outputRegionBox_debug: " . strlen($coords) . "<br />$coords<br />";
            }
            if (strlen($coords) < 10) {
                $coords = "$west,$north,1000 $east,$north,1000 $east,$south,1000 $west,$south,1000 $west,$north,1000";
            }
            $coords = trim($coords);
            $out->writeElement("coordinates", $coords);
            $out->endElement(); // LinearRing
            $out->endElement(); // outerBoundaryIs
            $out->endElement(); // Polygon
            $out->endElement(); // Placemark
        } // end foreach ( array( "boundry", "lineBuffer" ) as $linefield )
        return $msg;
    } // end private static function outputRegionBox()
    private static
    function fetchRange($trailId)
    {
        global $connect, $eol;
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        if (!isset($north)) {
            $sql = "select * from $wpdbExtra->regions where trailId = '$trailId'";
            $recs = $wpdbExtra->get_resultsA($sql);
            #$msg .= "$sql$eol";
            if ($wpdbExtra->num_rows == 0) {
                $msg .= "$errorBeg E#607 No region data found for trailId $trailId $errorEnd";
                // no region data - fake it and force a read
                $rec = freeWheeling_edit_setGlobals::trailInfoEmpty($trailId, '');
                unset($rec["sqlWhere"]);
                unset($rec["trname"]);
                unset($rec["inddFileName"]);
                $msg .= rrwUtil::print_r($rec, true, "new region record");
                $wpdbExtra->insert($wpdbExtra->regions, $rec);
            } else {
                $rec = $recs[0];
            }
            $msg .= Freewheelingeasy_kml_create::loadGlobal($rec);
        }
        return $msg;;
    }
    private static
    function fetchTopoNames($trailId)
    {
        global $connect, $eol;
        global $wpdbExtra;
        $msg = "";
        $sql = "select topoNames from $wpdbExtra->trails where trid = '$trailId'";
        #$msg .= "$sql$eol";
        $temp = $wpdbExtra->get_var($sql);
        return $temp;
    }
    private static function loadGlobal($rec)
    {
        global $eol, $errorBeg, $errorEnd;
        global $errorBeg, $errorEnd;
        $msg = "";
        if (!is_array($rec)) {
            $msg .= "$errorBeg Looking for an entry in the Regions table, but got $rec E#427 $errorEnd";
            throw new Exception($msg);
        }
        global $north, $east, $west, $south, $rangeLookat, $minLodPixels, $longMiddle, $latiMiddle; # save for mutiple calls
        #dump_r ($rec);
        $north = $rec["north"];
        $south = $rec["south"];
        $west = $rec["west"];
        $east = $rec["east"];
        if ($north > 90) {
            $msg .= "$errorBeg North value of $north E#428 $errorEnd";
            $north = 90;
        }
        $longMiddle = ($east + $west) / 2; # find the middle of the region
        $latiMiddle = ($north + $south) / 2; # which is where will center the viewpoint
        $distEW = ($east - $west) / .11; # .13 and .11 is an atempt to make the
        $distNS = ($north - $south) / .13; # the same pixels per difference
        if ($distEW > $distNS)
            $distMax = $distEW;
        else
            $distMax = $distNS;
        $rangeLookat = $distMax * 10000;
        if ($rangeLookat > 20000)
            $rangeLookat = 20000;
        #$msg .= "kmlCreate:loadGlobal: size is  $distEW * $distNS = ";
        $area = sqrt($distEW * $distNS);
        $minLodPixels = $area * 800;
        #$msg .= " $area  --&gt $minLodPixels <br/>";
        #	$minLodPixels = $rec["minLodPixels"];
        return $msg;
    }
    private static
    function outputLookAt($out, $trailId, $trailFullName)
    {
        # Routine to output a LookAt item for the given trail
        # use globals save for mutiple calls
        global $north, $east, $west, $south, $rangeLookat, $minLodPixels, $longMiddle, $latiMiddle; # save for mutiple calls
        $msg = "";
        $msg .= Freewheelingeasy_kml_create::fetchRange($trailId);
        $msg .= Freewheelingeasy_kml_create::outputLookAtElements($longMiddle, $latiMiddle, $rangeLookat, $out);
        return $msg;
    } // private static function outputLookAt ($trailId)
    private static function outputLookAtElements($lon, $lat, $range, $out)
    {
        # $range = 0 is an icon, so use a small default range.
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $out->startElement("LookAt");
        $out->WriteElement("longitude", $lon);
        $out->writeElement("latitude", $lat);
        $out->writeElement("altitude", 0);
        $out->writeElement("heading", 0);
        $out->writeElement("tilt", 0);
        if ($range == 0)
            $out->writeElement("range", 100);
        else
            $out->writeElement("range", $range);
        $out->writeElement("altitudeMode", "clampToGround");
        $out->endElement(); // Lookat
        return $msg;
    } // end private static function outputLookAtElements ($lng, $lat, $range)
    private static
    function buildDescription($trailIdInput, $debugBuildDescription)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        global $website;
        global $trailIdPrev;
        $msg = "";
        $trailId = strtolower($trailIdInput);
        if (!is_null($trailIdPrev)) {
            $displayError = true; #first time through for this trail display errors
            $trailIdPrev = $trailId;
        } else {
            $displayError = true; # second time though for this trail
        }
        $sql = "select description, inddFileName, landingPage, trName from $wpdbExtra->trails where lower(trid) = '$trailId'";
        if ($debugBuildDescription) $msg .= "$sql $eol";
        $recsDesc = $wpdbExtra->get_resultsA($sql);
        if ($wpdbExtra->num_rows == 1) {
            $recDesc = $recsDesc[0];
            if (strlen($recDesc["description"]) > 2) {
                $description = $recDesc["description"];
                $description = str_replace("\x92", "'", $description); # left handed quote
                $description = str_replace("//shaw-weil.com/trails", "/trails", $description);
            } else {
                $description = "";
            }
            // assert cleaned up description from previous runs
            if (strlen($recDesc["inddFileName"]) > 2) {
                $url = $recDesc["inddFileName"];
                //	$ii = strrpos($url, "/");
                //	$filename = substr($url, $ii+1);
                $filename = $url;
                $url = htmlspecialchars($url, ENT_QUOTES);
                $url = str_replace(" ", "+", $url);
                $urlLink = "Click <a href='https:/trail/" . $url . "' >
					for FreeWheeling Easy write-up.</a>$eol";
                if (!freewheeling_kml_common::setHasWriteup($filename)) {
                    if ($displayError) $msg .= "$errorBeg Name of &quot;<strong>$filename</strong>&quot;
						 $eol i.e. the Word file has not been HTMLed or name does not match</font>E#421 $errorEnd";
                    $urlLink = "";
                }
            } else { # no fwe write-up link found
                if ($displayError) $msg .= "$eol<font color='red'>No $website URL entered in the Trails table
						for <strong>$trailId</strong></font>$eol";
                $urlLink = "";
            }
            if (strlen($recDesc["landingPage"]) > 2) {
                $trailWebLink = "Click <a href='" . $recDesc["landingPage"] . "' > for " . $recDesc["trName"] . "</a> website.$eol";
            } else {
                $trailWebLink = "";
            }
        } else { # no record found
            $description = "";
            $urlLink = "";
            $trailWebLink = "";
            if ($displayError) $msg .= "$eol<font color='red'>no region found at $sql</font>$eol";
        }
        if (!empty($urlLink)) {
            $ii = strpos($description, "<br />Zoom in for");
            if ($ii !== false) {
                $description = substr($description, 0, $ii); // remove the previus zoom
                $description .= "<br />Zoom in for trailheads<br />$trailWebLink$urlLink";
            }
        }
        return $description;
    } # end private static function buildDescription
    private static function moveOlder2Obsolete($trailId, $saveHowFarBack = 5)
    {
        global $eol, $errorBeg, $errorEnd;
        global $freewheelingeasy_kml_directory;
        global $wpdbExtra;
        $msg = "";
        $ThisVersion = "needs the ";
        //      return  "$msg $eol temp check hanging --------before ----- findLatestTrailFileThisVersion;-------3-----$eol";
        $ThisVersion = freewheeling_kml_common::findLatestTrailFileThisVersion($trailId, $msg);
        $sqlTrailSource = "update $wpdbExtra->trails set trSource = '$trailId$ThisVersion' where trid = '$trailId' ";
        $wpdbExtra->query($sqlTrailSource);
        $msg .= "Updated the trails table with the new version number $trailId$ThisVersion $eol";
        $msg .= " ------------- ****************** FreewheelFormat::EditTrailLink($trailId) $eol";
        print " for (ii = $ThisVersion - 10; ii < $ThisVersion - $saveHowFarBack + 1; ii++) { $eol";
        //   return  "$msg $eol temp check hanging --------before -----obsolete-----3-----$eol";
        //  return  "$msg $eol temp check hanging --------after ----- EditTrailLink);-------3-----$eol";
        for ($ii = $ThisVersion - 10; $ii < $ThisVersion - $saveHowFarBack + 1; $ii++) {
            $msg .= " $ii ";
            $filenameFull = "$freewheelingeasy_kml_directory/$trailId$ii.kml";
            //   $msg .= "does file exist $ii = $filenameFull $eol";
            if (file_exists($filenameFull)) {
                $to = "$freewheelingeasy_kml_directory/Obsolete/$trailId$ii.kml";
                $msg .= " rename ($filenameFull, $to) $eol";
                rename($filenameFull, $to);
            }
        }
        return  "$msg $eol temp check hanging --------after obsolete ----- EditTrailLink);-------3-----$eol";
    }
    public static function jumpToLinks()
    {
        global $eol;
        return "[ <a href='#top'>Top</a> ] [ <a href='#displayAfterMerge'>after first merge</a> ] [
                    <a href='#displayAfterDistance'>after distance merge</a> $eol";
    }
} // end class Freewheelingeasy_kml_create
