<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.com
 *
 */
function milepostPictureToPoint()
{
    // given a collection of images in a directory, create icons/points for them
    // principal used when takeing pictures of mileposts, or other points of interest
    global $errorBeg, $errorEnd, $eol;
    global $wpdbExtra, $rrw_icons;
    $msg = "";
    try {
        $msg .= freeWheeling_edit_setGlobals::setGlobals("milepostPictureToPoint");
        $dirPath = "/home/pillowan/www-shaw-weil-edit/wp-content/uploads/mileposts/";
        if ($handle = opendir($dirPath)) {
            echo "Directory handle: $handle\n";
            $sqlDel = "delete from $rrw_icons where trailId= 'mileposts'";
            $wpdbExtra->Query($sqlDel);
            foreach (new DirectoryIterator($dirPath) as $fileInfo) {
                if ($fileInfo->isDot() || $fileInfo->isDir()) continue;
                $entry = $fileInfo->getFilename();
                $file = "$dirPath$entry";
                $msg .= "I3826 Trying get_image_location($file, $entry) $eol";
                $msg .= get_image_location($file, $entry);
            }
        } else {
            $msg .= "directory $dirPath did not open";
        }
    } catch (Exception $ex) {
        $msg .= "$errorBeg E#849 error " . $ex->getMessage() . " during milepostPictureToPoint $errorEnd";
    }
    return $msg;
} // end milepostPictureToPoint
// get geo-data from image
function get_image_location($fileNameFull, $fileName)
{
    global $errorBeg, $errorEnd, $eol;
    global $wpdbExtra;
    $msg = "";
    $debugLats = false;
    if (!is_file($fileNameFull))
        throw new Exception("File $fileNameFull does not exist");
    $info = exif_read_data($fileNameFull);
    $lat = 0;
    $lng = 0;
    if ($info === false)
        throw new exception("No exif data found in $fileNameFull");
    //		$msg .= rrwUtil::print_r( $info, true, "image data" );
    $direction = array('N', 'S', 'E', 'W');
    if (
        isset($info['GPSLatitude'], $info['GPSLongitude'], $info['GPSLatitudeRef'], $info['GPSLongitudeRef']) &&
        in_array($info['GPSLatitudeRef'], $direction) && in_array($info['GPSLongitudeRef'], $direction)
    ) {
        $lat_degrees_a = explode('/', $info['GPSLatitude'][0]);
        $lat_minutes_a = explode('/', $info['GPSLatitude'][1]);
        $lat_seconds_a = explode('/', $info['GPSLatitude'][2]);
        $lng_degrees_a = explode('/', $info['GPSLongitude'][0]);
        $lng_minutes_a = explode('/', $info['GPSLongitude'][1]);
        $lng_seconds_a = explode('/', $info['GPSLongitude'][2]);
        if ($debugLats) $msg .= rrwUtil::print_r($info["GPSLatitude"], true, "lat");
        $lat_degrees = $lat_degrees_a[0] / $lat_degrees_a[1];
        $lat_minutes = $lat_minutes_a[0] / $lat_minutes_a[1];
        $lat_seconds = $lat_seconds_a[0] / $lat_seconds_a[1];
        $lng_degrees = $lng_degrees_a[0] / $lng_degrees_a[1];
        $lng_minutes = $lng_minutes_a[0] / $lng_minutes_a[1];
        $lng_seconds = $lng_seconds_a[0] / $lng_seconds_a[1];
        $lat = (float)$lat_degrees + ((($lat_minutes * 60) + ($lat_seconds)) / 3600);
        $lng = (float)$lng_degrees + ((($lng_minutes * 60) + ($lng_seconds)) / 3600);
        $lat = freewheeling_kml_common::displayLats($lat);
        $lng = freewheeling_kml_common::displayLats($lng);
        if ($debugLats) $msg .= rrwUtil::print_r($lat_degrees, true, "lat_degrees");
        if ($debugLats) $msg .= rrwUtil::print_r($lat_minutes, true, "lat_minutes");
        if ($debugLats) $msg .= rrwUtil::print_r($lat_seconds, true, "lat_seconds");
        if ($debugLats) $msg .= rrwUtil::print_r($lat_minutes * 60, true, "lat minutes * 60 ");
        if ($debugLats) $msg .= rrwUtil::print_r($lat_seconds / 3600, true, "lat seconds / 3600");
        if ($debugLats) $msg .= rrwUtil::print_r($lat, true, "lat");
        //If the latitude is South, make it negative.
        //If the longitude is west, make it negative
        $lat = $info['GPSLatitudeRef'] == 'S' ? $lat * -1 : $lat;
        $lng = $info['GPSLongitudeRef'] == 'W' ? $lng * -1 : $lng;
    } else {
        $msg .= "$errorBeg No GPS data found in $fileNameFull $errorEnd";
        return $msg;
    }
    $debugTrailSearch = true;
    $filename = $info["FileName"];
    $iconName = str_replace(".jpg", "", $filename);
    $iiSpace = strrpos($filename, " ");
    if (false === $iiSpace)
        $iiSpace = strlen($filename) - 3;   // if no space, assume the last 3 characters are the milepost
    else {
        $trailId = str_replace(".jpg", "", $filename);
        $milepost = trim(substr($iconName, $iiSpace));    // milepost is the last characters
        $trailId = trim(substr($filename, 0, $iiSpace)); // maybe trailId, maybe milepost prefix, maybe 'milepost'
        $trailId = str_replace("milepost", "", $trailId);
        if ($debugTrailSearch) $msg .= "trailId = $trailId, milepost = $milepost $eol";
        $sql = "select trId trailId from $wpdbExtra->trails where trmilepostPrefix = '$trailId' "; // maybe trailId, maybe milepost prefix
        if ($debugTrailSearch) $msg .= "$sql $eol";
        $recIds = $wpdbExtra->get_resultsA($sql);
        if ($wpdbExtra->num_rows != 0) {    // it is a milepost prefix
            $trailId = $recIds[0]["trailId"]; // get the real trailId
        } else {
            $sql2 = "select trailId from $wpdbExtra->icons where trailId = '$trailId' ";  // maybe trailId
            if ($debugTrailSearch) $msg .= "$sql $eol";
            $recIds = $wpdbExtra->get_resultsA($sql2);
            if ($wpdbExtra->num_rows == 0) {
                $msg .= "$errorBeg E#259 partial filename of '$trailId'
                                    is not a milepost prefix nor trail name $errorEnd
                                    $sql $eol $sql2 $eol";
                return $msg;
            }
        }
        $data = array(
            "trailId" => $trailId,
            "iconName" => $iconName,
            "OnMap" => "place",
            "iconStyle" => "mpPic$milepost.png",
            "milepost" => $milepost,
            "latitude" => $lat,
            "longitude" => $lng,
            "source" => $filename,
        );
        $msg .= rrwUtil::print_r($data, true, "output this data");
        $wpdbExtra->replace($wpdbExtra->icons, $data);
        $msg .= "file = $fileNameFull, 'lat' => $lat, 'lng' => $lng $eol ";
        $sqlIconId = "select iconId from $wpdbExtra->icons where trailId = '$trailId' and milepost = '$milepost' and latitude = $lat and longitude = $lng";
        $iconId = $wpdbExtra->get_var($sqlIconId);
        $msg .= "caling LatLonMoved($iconId) $eol";
        $msg .= freewheelingeasy_edit_shove::latLonMoved($iconId);
        $msg .= "after calling iconId = $iconId $eol";
    }
    return $msg;
} // end function get_image_location( $file )