<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.com
 */
class freewheelingeasy_kml_merge
{
    /** based on the provided attributes , or based on th 'mergeNeeded' field       *
     */
    public static function mergeManual($attributes)  // from he web page
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $debugMerge = rrwParam::isDebugMode("debugMerge", true);
        $progressMerge = rrwParam::isDebugMode("progressMerge", true);
        try {
            $msg .= freeWheeling_edit_setGlobals::setGlobals("freewheelingeasy kml merge");
            $trailId = freeWheelParam::trail($attributes);
            if (empty($trailId)) {
                // no trail specified, ask
                $msg .= "<form method='post' action=''>";
                $msg .= freewheelingEasy_kml_trailList::trailSelectionBox(
                    false,
                    "select a trail to recalculate",
                    "Recalculate"
                );
                $msg .= "</form>";
                return $msg;
            }
            $debugCleanWhich = rrwParam::isDebugMode("debugCleanWhich", false);   // set to true to see which routine is messing up
            $msg .= var_dump($debugCleanWhich);
            if ($debugCleanWhich) $msg .= freewheeling_kml_common::displayLines($trailId, "I#2500 In mergeTrail($trailId");
            $automated = rrwParam::Boolean("automated", $attributes);
            if ($progressMerge)  $msg .= "I#2501 mergeManual($automated) $eol";
            if ($automated) {
                $msg .= "trying automated merge $eol";
                print "trying automated merge $eol";
                $msg .= self::mergeAutoMated($attributes);
            } else {
                if ($debugMerge)
                    $msg .= " not automated";
                if ($debugMerge || $progressMerge)
                    $msg .= "trailId = $trailId $eol";
                if (freeWheeling_edit_setGlobals::notAllowedToEdit(" create a KML file from the database", $trailId))
                    return "$msg one needs to be logged in to merge a trail $eol";
                if ($debugMerge || $progressMerge)
                    $msg .= "In to freewheelingEasy-kmlMerge ($trailId) $eol";
                $msg .= self::mergeTrail($trailId, $attributes);
                $msg .= "I#2502 after merge Manual";
            }
        } catch (Exception $e1) {
            $msg .= $eol . $e1->getMessage() . "E#2503 thrown out of freewheelingEasy-kmlMerge $eol";
        }
        try {
            $msg .= freewheeling_writeup::saveReport("kml_Merge-$trailId-", $msg, "html");
        } catch (Exception $ex) {
            $msg .= $ex->getMessage() . "$errorBeg  E#2504 update junction mileages $errorEnd";
        }
        return $msg;
    } // end mergeManual
    /**
     * This function is typically called from a cron job to automate the merging of trails.
     * It processes trails in the database and merges them based on their merge status.
     *
     */
    public static function mergeAutoMated($attributes) // from the cron job
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        try {
            $debugAutomated = rrwParam::isDebugMode("debugAutomated", true);
            $attributes["allowed"] = true;      // allow the merge to happen even if not logged in
            $selectTrail = "select trId, mergeStatus from $wpdbExtra->trails
                                where position('ready' in mergeStatus) != 0 order by mergeSequence";
            $recsTrails = $wpdbExtra->get_resultsA($selectTrail);
            $mergedCnt = 0;
            $debugAutoProgress = rrwParam::isDebugMode("debugAutoProgress", false);
            if ($debugAutomated) $msg .= "I#2586 mergeAutomated found $wpdbExtra->num_rows trails to look at$eol";
            if (0 == $wpdbExtra->num_rows) {
                $msg .= "I#2587 No trails to merge $eol";
                $msg .= freewheelFormat::taskCompleted("mergeTrail");
                return $msg;
            }
            foreach ($recsTrails as $recTrail) {
                $trailId = $recTrail["trId"];
                $mergeStatus = $recTrail["mergeStatus"];
                // if ($debugAutomated) $msg .= "I#25037 trail $trailId is $mergeStatus $eol";
                if (substr($mergeStatus, 0, 10) == "inProgress") {
                    $msg .= "trail $trailId is $mergeStatus $eol";
                    $msg .= self::emailIfLongTimeInProgress($mergeStatus);
                    continue;
                } elseif (substr($mergeStatus, 0, 4) == "done") {
                    if ($debugAutoProgress) $msg .= "trail $trailId is $mergeStatus So try next trail $eol";
                    continue;
                } elseif (substr($mergeStatus, 0, 5) == "error") {
                    if ($debugAutoProgress) $msg .= "trail $trailId is $mergeStatus So try next trail $eol";
                    continue;
                } elseif (substr($mergeStatus, 0, 5) == "ready") {
                    if ($debugAutoProgress)  $msg .= "trail $trailId is $mergeStatus, lets mergeTrail($trailId) $eol";
                    $msg .= self::mergeTrail($trailId, $attributes);
                    $mergedCnt++;
                    return $msg;
                } else {
                    // $msg .= "trail $trailId is $mergeStatus $eol";
                    continue;   // not ready to merge
                } // end if based on status
                // now the milepost distribution stuff oly get here if merge is good
            } // end foreach trail
        } catch (Exception $e1) {
            $msg .= self::set_mergeStatus("error", $trailId);
            $msg .= $eol . $e1->getMessage() . "E#2602 thrown out of freewheelingEasy-kmlMerge $eol";
            throw new Exception($msg);
        }
    }
    /**
     * Merges trail data and performs various operations on it.
     *
     * This function merges trail data based on the provided trail ID and attributes.
     * It performs several operations such as reversing lines, matching start and end lines,
     * assigning sequence numbers, building a table of points along lines, and updating junction mileages.
     */
    public static function mergeTrail($trailId, $attributes)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        try { // and now and build merge kml file
            ini_set("display_errors", 1);
            error_reporting(E_ALL);
            $debugCleanWhich = rrwParam::isDebugMode("debugCleanWhich");   // set to true to see which routine is messing up
            if ($debugCleanWhich) $msg .= "I#2591 mergeTrail($trailId) $eol";
            $msg .= freewheeling_kml_common::displayLines($trailId, "I#2589 Start of  mergeTrail($trailId");
            $debugClean = rrwParam::isDebugMode("debugClean", false);   // set to true to see what is being cleaned
            $msg .= freewheelingeasy_kml_merge::set_mergeStatus('inProgress', $trailId);
            $msg .= "<h1>$trailId</h1> $eol";
            $sqlCheck = "select trId from $wpdbExtra->trails where trId = '$trailId'";
            $recCheck = $wpdbExtra->get_resultsA($sqlCheck);
            if (empty($recCheck)) {
                $msg .= "E#2588 trail '$trailId' not found in the database $eol";
                return $msg;
            }
            $msg .= freewheeling_edit_create_views();
            $msg .= freewheeling_kml_read::deleteMeRecords();
            if ($debugCleanWhich) $msg .=  freewheeling_kml_common::displayLines($trailId, "I#2590 About to  reverseLines ");
            $msg .= self::reverseLines($attributes, $trailId);             // reverse lines if requested
            if ($debugCleanWhich) $msg .=  freewheeling_kml_common::displayLines($trailId, "I#2592 About to  breakLine $eol");
            $msg .= self::breakLine($trailId);
            if ($debugCleanWhich) $msg .=  freewheeling_kml_common::displayLines($trailId, "I#2594 About to  match start end lines $eol");
            $msg .= self::everyLineMatchStart();
            if ($debugCleanWhich) $msg .= freewheeling_kml_common::displayLines($trailId, "I#2593 mergeTrail::Before match start end lines");
            $msg .= self::assignSequenceNumbersOnLines($trailId);
            if ($debugCleanWhich) $msg .=  freewheeling_kml_common::displayLines($trailId, "I#2585 About to  assign Icon sort All Icons $eol");
            $msg .= self::iconsMissingIconStyle($trailId);
            if ($debugCleanWhich) $msg .= freewheeling_kml_common::displayIcons($trailId, "I#2595before assign sequence numbers");
            $msg .= self::assignSortFieldInIcon($trailId);
            if ($debugCleanWhich) $msg .= freewheeling_kml_common::displayIcons($trailId, "I#2516 before BuildTableOfPointsALongLines");
            $msg .= self::updateTheJunctionsMileages();
            $msg .= self::UpdateInternalLineFieldsFromPoints($trailId);
            // now let us go for the distance stuff
            if (! key_exists("trailId", $attributes)) {
                $attributes["trailId"] = $trailId;    // for the next routine
            }
            if ($debugCleanWhich) $msg .=  freewheeling_kml_common::displayIconsLines($trailId, "I#2517 just before distance calcs $eol");
            $msg .= FreewheelingEditDistance::distanceCalculator($trailId, $attributes);
            if (strpos($msg, "E#") !== false) {
                $msg .= freewheelingeasy_kml_merge::set_mergeStatus('error', $trailId);
            } else {
                $automated = rrwParam::Boolean("automated", $attributes);
                if ($automated) {       //   If this is an automated run, and we got here, then we are done
                    $msg .= freewheelingeasy_kml_merge::set_mergeStatus('done', $trailId);
                } else {
                    // In progress status still pending - will be set to 'done' on 'accept distance' button
                } // end if automated
            } // end if error
        } catch (Exception $e1) {
            $msg .= freewheelingeasy_kml_merge::set_mergeStatus('error', $trailId); //  remove in Progress
            $msg .= $eol . $e1->getMessage() . "E#2518 thrown out of kml_merge::mergeTrail$eol";
            throw new Exception($msg);
        }
        return $msg;
    }
    /**
     * - Sets the status for the trail merge operation.
     * - If status is "done":
     *   - Retrieves the minimum and maximum mileposts for the specified trail.
     *   - Finds all access points with matching milepost prefix and within the min/max milepost range.
     *   - Updates the `trailMilepost` of these access points to 99999.
     *   - Throws an exception if the expected number of records is not one.
     *
     * @param string $status  The status to set for the merge operation (e.g., "done", "error", "in progress").
     * @param int    $trailId The ID of the trail being merged.
     * @return string         A message describing the status update and any actions taken.
     */
    /**
     * - Sets the status for the trail merge operation.
     * - If status is "done":
     *   - Retrieves the minimum and maximum mileposts for the specified trail.
     *   - Finds all access points with matching milepost prefix and within the min/max milepost range.
     *   - Updates the `trailMilepost` of these access points to 99999.
     *   - Throws an exception if the expected number of records is not one.
     *
     * @param string $status  The status to set for the merge operation (e.g., "done", "error", "in progress").
     * @param int    $trailId The ID of the trail being merged.
     * @return string         A message describing the status update and any actions taken.
     */
    public static function set_mergeStatus($status, $trailId)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $msg .= freewheelFormat::setStatus($status, "trailMerge", $trailId); // our status
        if ("done" == $status) {
            // good mileages, reset access points
            // find the min and max milepost for the trail
            $sqlMiles = "select distinct milepostPrefix, max(milePost) as maxMile, min(milePost) as minMile
                    from $wpdbExtra->icons where trailId = '$trailId'
                    and milePost is not null and not milePost = 99999";
            $recMiles = $wpdbExtra->get_resultsA($sqlMiles);
            if (1 != $wpdbExtra->num_rows) {
                $msg .= "$errorBeg E#2519 in set_mergeStatus($status, $trailId,) " .
                    "Expected one record for max/min milepost, got " . $wpdbExtra->num_rows . " $errorEnd $sqlMiles $eol";
                throw new Exception($msg);
            }
            $maxMile = $recMiles[0]["maxMile"];
            $minMile = $recMiles[0]["minMile"];
            $milepostPrefix = $recMiles[0]["milepostPrefix"];
            $sqlAccess = "select accId from $wpdbExtra->access
                        where trailMilepostPrefix = '$milepostPrefix'
                        and trailMilepost >= $minMile and trailMilepost <= $maxMile";
            $recAllAccess = $wpdbExtra->get_resultsA($sqlAccess);
            $msg .= "I#2596 found " . $wpdbExtra->num_rows . " access points with milepost prefix $milepostPrefix between $minMile and $maxMile $eol";
            foreach ($recAllAccess as $recAccess) {
                $accId = $recAccess["accId"];
                $sqlUpdate = "update $wpdbExtra->access set trailMilepost = 99999 where accId = $accId";
                $wpdbExtra->query($sqlUpdate);
            } // end foreach access point
        } // if done
        return $msg;
    }
    public static function mergeStatus()
    {
        global $wpdbExtra;
        global $eol;
        $msg = "";
        try {
            $sql = "select trName, trId, mergeStatus, trDateNear, trDateRouted, mergeSequence,trSequence
                    from $wpdbExtra->trails order by mergeSequence, mergeStatus, trName";
            $recs = $wpdbExtra->get_resultsA($sql);
            $msg .= "<table>" . rrwFormat::CellHeaderRow("Trail", "last merge", "Icons Date Near - Set on", "Date Routed", "Edit", "Trail Sequence", " ", " ");
            $color = "white";
            foreach ($recs as $rec) {
                $color = rrwUtil::colorSwap($color);
                $trailName = $rec["trName"];
                $trailId = $rec["trId"];
                $mergeStatus = $rec["mergeStatus"];
                $trDateNear = $rec["trDateNear"];
                $trDateRouted = $rec["trDateRouted"];
                $mergeSequence = $rec["mergeSequence"];
                $trSequence = $rec["trSequence"];
                $doMerge = "<a href='https://edit.shaw-weil.com/mergelines/?trail=$trailId' target='merge' >$trailName</a>";
                $editLink = freeWheelFormat::EditTrailLink($trailId);
                $msg .= rrwFormat::cellRow($color, $doMerge, $mergeStatus, $trDateNear, $trDateRouted, $editLink, $trSequence, " ", " ");
            }
            $msg .= "</table>";
            $msg .= "<ul>
            <li>Number 100 through 2000 are Erie to Pittsburgh in group of 100s. each 100 group should be run in order yo preserve
                        the sequence of milepost numbering across trails boundaries.</li>
            <li>2000 to 3000 are Erie to pittsburgh, any sequence11</li>
                    <li>10,000 to 11,000 are pittsburgh to DC  trails.</li>
                    <li>11,000 to 12,000 are pittsburgh to DC spur trails</li>
                    <li>13,000 to 14,000 are PA Wild trails</li>
                    <li>14,000 to 15,000 are PA Wild spur trails</li>
                    </ul>";
        } catch (Exception $e1) {
            $msg .= $eol . $e1->getMessage() . "E#2524 thrown out of freewheelingEasy-kmlMerge $eol";
        }
        return $msg;
    }
    public static function mergeForce($attributes)
    {
        global $wpdbExtra;
        global $eol;
        $msg = "";
        $sqlForce = " update $wpdbExtra->trails set mergeStatus = replace (mergeStatus, 'error', 'ready') where mergeSequence < 99999;";
        $msg .= "$sqlForce $eol";
        $msg .= " Updated " . $wpdbExtra->query($sqlForce) . " Statuses $eol";
        $sqlForce = " update $wpdbExtra->trails set mergeStatus = replace (mergeStatus, 'inProgress', 'ready')where mergeSequence < 99999;";
        $msg .= "$sqlForce $eol";
        $msg .= " Updated " . $wpdbExtra->query($sqlForce) . " Statuses $eol";
        $msg .= "$eol $eol update $wpdbExtra->trails set mergeStatus = 'ready'";
        return $msg;
    }
    private static function emailIfLongTimeInProgress($mergeStatus)
    {
        return "";
        $iiWhen = strpos($mergeStatus, " ");
        if (false !== $iiWhen)
            $when = substr($mergeStatus, $iiWhen + 1); // remove done or inProgress
        $msg .= "when = '$when' $eol";
        $iiWhen = strrpos($when, " ");
        if (false !== $iiWhen)
            $when = substr($when, 0, $iiWhen); // remove the micro seconds
        $when = trim($when);
        $when = str_replace(" ", "T", $when);
        $msg .= "when = '$when' $eol";
        return $msg;
        $when = new DateTime($when);
        $msg .= $when->format("Y-m-d H:i:s u:v") . $eol;
        $diffInterval = $when->diff(new DateTime());
        $diffHours = $diffInterval->h + ($diffInterval->days * 24) + ($diffInterval->i / 60);
        $msg .= "diffHours = $diffHours $eol";
        if ($diffHours > 2) {
            $msgErr = "$errorBeg E#2597 trail $trailId is $mergeStatus for $diffHours hours $errorEnd";
            // << TODO >>  send email
            return "$msg $msgErr";
        }
    }
    /**
     * Matches start and end points of lines that are very close to each other and merges them.
     *
     * This method is called from fix task-line ends and from kml merge just before assigning
     * lineId to icons. It identifies line segments whose start/end points are within a small
     * distance threshold and moves them to a common averaged position to create proper connections.
     *
     * The method:
     * 1. Creates a temporary table to find pairs of lines where one line's start point
     *    is very close to another line's end point
     * 2. For each close pair, calculates the average position of the two points
     * 3. Finds all lines that have start or end points near this average position
     * 4. Moves those start/end points to the averaged position to create proper connections
     *
     * Uses a distance threshold of 1.0 meter converted to degrees for spatial calculations.
     * The method includes extensive debug output when debugMatch parameter is enabled.
     *
     *
     * @return string HTML formatted message with results and debug information
     * @throws Exception If too many lines (>10) are found near a calculated position
     */
    static public function everyLineMatchStart()
    {
        // called from fix task-line ends
        // called from kml merge just before assign lineId to icons.
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        global $freewheel_degrees2Meters;
        $msg = "";
        $msgMove = "";
        $debugMatch = rrwParam::Boolean("debugMatch", array(), false);
        try {
            $latCheckMeters = 1.0;
            $latCheckDegrees = $latCheckMeters / $freewheel_degrees2Meters;
            if ($debugMatch) $msg .= "I#2526 everyLineMatchStart() with degree diff = $latCheckDegrees $eol";
            $lineLine = "_rrw_07_linesLines";
            $sqlDrop = "DROP TABLE IF EXISTS  $lineLine";
            $wpdbExtra->query($sqlDrop);
            $sqlCreate = "create table $lineLine
                    select l1.lineId id1, l2.lineId id2, l1.latStart, l1.lngStart, l2.latEnd, l2.lngEnd,
                    st_distance(point(l1.latStart, l1.lngStart), point(l2.latEnd, l2.lngEnd)) dist
                        from $wpdbExtra->lines l1
                        join $wpdbExtra->lines l2
                    where st_distance(point(l1.latStart, l1.lngStart), point(l2.latEnd, l2.lngEnd)) < $latCheckDegrees
         ";
            if ($debugMatch)   $msg .= "$sqlDrop $eol $sqlCreate $eol ";
            $wpdbExtra->query($sqlCreate);
            $sqlCount = "select count(*) from $lineLine";
            $cnt = $wpdbExtra->get_var($sqlCount);
            $msg .= "I#2598 created $lineLine with $cnt rows $eol <table>";
            $sqlList = "select * from $lineLine where dist != 0";
            $recLines = $wpdbExtra->get_resultsA($sqlList);
            $color = "white";
            $cntMisMatch = $wpdbExtra->num_rows;
            $msg .= "I#2525 there are $cntMisMatch groupings (end points that are really close and should be  moved$eol";
            if (0 == $cntMisMatch) {
                return $msg;
            }
            foreach ($recLines as $rec) {
                $color = rrwUtil::colorSwap($color);
                if ($debugMatch)  $msg .= rrwFormat::CellRow(
                    "white",
                    $rec["id1"],
                    $rec["id2"],
                    $rec["latStart"],
                    $rec["lngStart"],
                    $rec["latEnd"],
                    $rec["lngEnd"],
                    ($rec["dist"] * $freewheel_degrees2Meters) . " m",
                    distanceMeters($rec["latStart"], $rec["lngStart"], $rec["latEnd"], $rec["lngEnd"]),
                );
                // now the average of the two points
                $latFinal = round(($rec["latStart"] / 2) + ($rec["latEnd"] / 2),  freeWheel::latRoundTo);
                $lngFinal = round(($rec["lngStart"] / 2) + ($rec["lngEnd"] / 2),  freeWheel::latRoundTo);
                $pad = 10 / $freewheel_degrees2Meters;
                $sqlChange = "select trailId, lineId, lineName, latStart, lngStart, latEnd, lngEnd
                    from $wpdbExtra->lines
                        where (latStart  < ($latFinal + $pad) and latStart  > ($latFinal - $pad) and
                        lngStart  < ($lngFinal + $pad) and lngStart  > ($lngFinal - $pad)) or
                        (latEnd  < ($latFinal + $pad) and latEnd  > ($latFinal - $pad) and
                        lngEnd  < ($lngFinal + $pad) and lngEnd  > ($lngFinal - $pad))";
                $recChange = $wpdbExtra->get_resultsA($sqlChange);
                $howMany = $wpdbExtra->num_rows;
                if ($debugMatch) $msg .= "I#2599 found $howMany lines with lat/lng near $latFinal, $lngFinal $eol";
                if ($howMany > 10)
                    throw new Exception("E#2527 found $howMany lines with lat/lng near $latFinal, $lngFinal $eol");
                if (0 == $howMany) {
                    $msg .= "E#2600 no lines with lat/lng near $latFinal, $lngFinal $eol";
                    continue;
                }
                if ($debugMatch) {
                    $msg .= rrwFormat::cellRow("", "");
                    $msg .= rrwFormat::cellRow($color, "", "", "lat final", $latFinal, $lngFinal, "", "");
                    $distStart = distanceMeters($rec["latStart"], $rec["lngStart"], $latFinal, $lngFinal);
                    $distEnd = distanceMeters($rec["latEnd"], $rec["lngEnd"], $latFinal, $lngFinal);
                    $msg .= rrwFormat::cellRow($color, $recChange[0]["trailId"],  $recChange[0]["lineName"], "dist Start", $distStart, "dist end", $distEnd);
                    $msg .= rrwFormat::cellRow($color, "lineId", "name",  "latStart", "lngStart", "diff Start", "latEnd", "lngEnd", "diff end");
                }
                foreach ($recChange as $recChangeLine) {
                    $id1 = $recChangeLine["lineId"];
                    $lineName = $recChangeLine["lineName"];
                    $latStart = $recChangeLine["latStart"];
                    $lngStart = $recChangeLine["lngStart"];
                    $latEnd = $recChangeLine["latEnd"];
                    $lngEnd = $recChangeLine["lngEnd"];
                    $distStart = distanceMeters($latStart, $lngStart, $latFinal, $lngFinal);
                    $distEnd = distanceMeters($latEnd, $lngEnd, $latFinal, $lngFinal);
                    $msg .= rrwFormat::CellRow("MoveStartOrEndOfLine", $id1, $lineName, $latStart, $lngStart, $distStart, $latEnd, $lngEnd,  $distEnd);
                    $msg .= self::MoveStartOrEndOfLine($id1, $lineName, $latFinal, $lngFinal, $latCheckMeters); // in case latStart is not matched
                }
                if ($debugMatch)  $msg .= rrwFormat::cellRow("", "", "",  "", "", "", "", "");
            }
        } catch (Exception $e1) {
            $msg .= $eol . $e1->getMessage() . "E#2528 thrown out of everyLineMatchStart $eol";
        }
        $msg .= "</table> $eol";
        return $msg;
    }  // end everyLineMatchStart
    /*
    public static function MovePointInSegment($lineId, $lineName, $lat, $lng)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $debugEndCHeck = rrwParam::Boolean("debugEndCHeck", array(), false);
        $lat = round($lat, freeWheel::latRoundTo);
        $lng = round($lng, freeWheel::latRoundTo);
        if ($debugEndCHeck) $msg .= "I#2601 MoveStartOrEndOfLine($lineId, $lineName, $lat, $lng, $moveIfLessMeters) $eol";
        $sqlPointList = "select pointList from $wpdbExtra->lines where lineId = $lineId";
        $pointList = $wpdbExtra->get_var($sqlPointList);
        $pointArray = explode(" ", $pointList);
        if (count($pointArray) < 2) {
            $editLink = freeWheelFormat::EditLineLink($lineId);
            $msg .= "E#2529 line $editLink $lineName has less than 2 points $eol";
            return $msg;
        }
        if ($debugEndCHeck) $msg .= rrwUtil::print_r($pointArray, true, "pointArray before ");
        $coordStart = explode(",", $pointArray[0]);
        if (3 != count($coordStart)) {
            $msg .= "E#2603 line $lineName start of $pointArray[0] does not have 3 numbers $eol " .
                rrwUtil::print_r($pointList, true, "pointList data");
            return $msg;
        }
        $lastPointer = count($pointArray) - 1;
        if (empty($pointArray[$lastPointer])) {
            $lastPointer--;
        }
        if ($debugEndCHeck) $msg .= "Last point is $lastPointer $eol";
        $coordEnd = explode(",", $pointArray[$lastPointer]);
        if (3 != count($coordEnd)) {
            $msg .= "E#2605 line $lineName end of $pointArray[$lastPointer] does not have 3 numbers $eol " .
                rrwUtil::print_r($pointList, true, "pointList data") . $eol .
                rrwUtil::print_r($pointArray, true, "points from pointList");
            return $msg;
        }
        $msgShort = "";
        if ($debugEndCHeck) $msg .= "  if ($coordStart[1] == $lat && $coordStart[0] == $lng) $eol";
        if ($coordStart[1] == $lat && $coordStart[0] == $lng) {
            // nothing to do  here
        } else {
            // move the point if close
            $distMeter = distanceMeters($coordStart[1], $coordStart[0], $lat, $lng);
            if ($debugEndCHeck) $msg .= "distance for start line point $distMeter $eol";
            if ($distMeter < $moveIfLessMeters) {
                $pointArray[0] = $lng . "," . $lat . ",0";
                $pointList = implode(" ", $pointArray);
                $sqlLnBegPoint = "update $wpdbExtra->lines set pointList = '$pointList' where lineId = $lineId";
                if ($debugEndCHeck) $msg .= "$sqlLnBegPoint $eol";
                $cnt = $wpdbExtra->query($sqlLnBegPoint);
                if ($debugEndCHeck) $msg .= "updated $cnt rows $eol";
                $msg .= self::UpdateInternalLineFieldsFromPoints($lineId);
                $latOld = $coordStart[1];
                $lngOld = $coordStart[0];
                $msgShort .= "moved start of line $lineName from $latOld, $lngOld  to $lat, $lng";
            }
        }
        if ($debugEndCHeck) $msg .= "  if ($coordEnd[1] == $lat && $coordEnd[0] == $lng) $eol";
        if ($coordEnd[1] == $lat && $coordEnd[0] == $lng) {
            if ($debugEndCHeck) $msg .= "end point is the same $eol";
        } else {
            // move the point if close
            $distMeter = distanceMeters($coordEnd[1], $coordEnd[0], $lat, $lng);
            if ($debugEndCHeck) $msg .= "distance for end line point $distMeter $eol";
            if ($distMeter < $moveIfLessMeters) {
                $pointArray[$lastPointer] = $lng . "," . $lat . ",0";
                $pointList = implode(" ", $pointArray);
                $sqlLineEndPoint = "update $wpdbExtra->lines set pointList = '$pointList' where lineId = $lineId";
                if ($debugEndCHeck) $msg .= "$sqlLineEndPoint $eol";
                $cnt = $wpdbExtra->query($sqlLineEndPoint);
                if ($debugEndCHeck) $msg .= "updated $cnt rows $eol";
                $msg .= self::UpdateInternalLineFieldsFromPoints($lineId);
                $latOld = $coordEnd[1];
                $lngOld = $coordEnd[0];
                $msgShort .= "moved end of line $lineName from $latOld, $lngOld  to $lat, $lng";
            }
        }
        $sqlIcon = " select iconId, latitude, longitude, st_distance(point(latitude, longitude), point($lat, $lng)) *1.0 dist
                 from $wpdbExtra->icons where st_distance(point(latitude, longitude), point($lat, $lng)) < .0001";
        foreach ($wpdbExtra->get_resultsA($sqlIcon) as $recIcon) {
            $iconId = $recIcon["iconId"];
            $distMeter = distanceMeters($recIcon["latitude"], $recIcon["longitude"], $lat, $lng);
            if ($distMeter < $moveIfLessMeters) {
                $sql = "update $wpdbExtra->icons set latitude = $lat, longitude = $lng where iconId = $iconId";
                if ($debugEndCHeck) $msg .= "updated point from " . $recIcon['latitude'] . ", " . $recIcon['longitude'] . " to $lat, $lng $eol";
                if ($debugEndCHeck) $msg .= "$sql $eol";
                $wpdbExtra->query($sql);
                $latOld = $recIcon['latitude'];
                $lngOld = $recIcon['longitude'];
                $msgShort .= "moved start of line $lineName from $latOld, $lngOld to $lat, $lng";
            }
        }
        if (strlen($msgShort) > 0) {
            $msg .= "I#2608 $msgShort $eol";
        }
        return "<div style='visibility:hidden>$msg</div>$msgShort";
    } // end MoveStartOrEndOfLine
     */


    /**
     * Move the start and/or end point of a line to a target coordinate when within a given distance,
     * and optionally move nearby icons to the same coordinate.
     *
     * Process:
     * - Fetches the line's pointList and validates it has at least two points.
     * - Rounds input latitude/longitude to freeWheel::latRoundTo.
     * - If the first or last point is within $moveIfLessMeters of ($lat, $lng), updates that point
     *   (stored as "lng,lat,alt") and persists the new pointList.
     * - Refreshes derived line fields via UpdateInternalLineFieldsFromPoints($lineId).
     * - Locates nearby icons and, if within $moveIfLessMeters, updates their latitude/longitude.
     * - Accumulates debug output when rrwParam::Boolean("debugEndCHeck") is true and returns it hidden in HTML,
     *   along with a short visible summary of changes.
     *
     * Side effects:
     * - Updates rows in $wpdbExtra->lines and $wpdbExtra->icons.
     *    *
     * @param int        $lineId            The ID of the line to adjust.
     * @param string     $lineName          Display name of the line for logging.
     * @param float      $lat               Target latitude to snap endpoints/icons to.
     * @param float      $lng               Target longitude to snap endpoints/icons to.
     * @param float|int  $moveIfLessMeters  Maximum allowed distance (meters) to move points/icons.
     *
     * @return string A visible short summary of changes plus a hidden debug block when enabled.
     *
     * @see self::UpdateInternalLineFieldsFromPoints()
     * @see distanceMeters()
     */
    public static function MoveStartOrEndOfLine($lineId, $lineName, $lat, $lng, $moveIfLessMeters)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $debugEndCHeck = rrwParam::Boolean("debugEndCHeck", array(), false);
        $lat = round($lat, freeWheel::latRoundTo);
        $lng = round($lng, freeWheel::latRoundTo);
        if ($debugEndCHeck) $msg .= "I#2537 MoveStartOrEndOfLine($lineId, $lineName, $lat, $lng, $moveIfLessMeters) $eol";
        $sqlPointList = "select pointList from $wpdbExtra->lines where lineId = $lineId";
        $pointList = $wpdbExtra->get_var($sqlPointList);
        $pointArray = explode(" ", $pointList);
        if (count($pointArray) < 2) {
            $editLink = freeWheelFormat::EditLineLink($lineId);
            $msg .= "E#2536 line $editLink $lineName has less than 2 points $eol";
            return $msg;
        }
        $lastPointer = count($pointArray) - 1;
        // check start of line
        if ($debugEndCHeck) $msg .= rrwUtil::print_r($pointArray, true, "pointArray before ");

        $adjustStart = self::checkMoveOnePoint($pointArray[0], $lat, $lng);;
        $adjustEnd = self::checkMoveOnePoint($pointArray[$lastPointer], $lat, $lng);
        if ($debugEndCHeck) $msg .= "adjustStart = $adjustStart, adjustEnd = $adjustEnd $eol";
        if ($adjustStart || $adjustEnd) {
            // point moved in pointArray
            $newPointList = implode(" ", $pointArray);
            $sqlUpdate = "update $wpdbExtra->lines set pointList = '$newPointList' where lineId = $lineId";
            if ($debugEndCHeck) $msg .= "$sqlUpdate $eol";
            $cnt = $wpdbExtra->query($sqlUpdate);
            if ($debugEndCHeck) $msg .= "updated $cnt rows $eol";
        }
        return $msg;
    }
    private static function checkMoveIcons($lat, $lng)
    {
        global $eol;
        $msg = "";
        $debugEndCHeck = rrwParam::isDebugMode("checkMoveIcons",);
        //
        $sqlIcon = " select iconId, iconName, latitude, longitude, st_distance(point(latitude, longitude), point($lat, $lng)) *1.0 dist
                 from $wpdbExtra->icons where st_distance(point(latitude, longitude), point($lat, $lng)) < .0001";
        $recIcons = $wpdbExtra->get_resultsA($sqlIcon); // this lets sql do a rough filter of icons within .0001 degrees, then we can do a more precise distance check in PHP
        foreach ($recIcons as $recIcon) {
            $iconId = $recIcon["iconId"];
            $iconName = $recIcon["iconName"];
            $distMeter = distanceMeters($recIcon["latitude"], $recIcon["longitude"], $lat, $lng);
            if ($distMeter < $moveIfLessMeters) {
                $sql = "update $wpdbExtra->icons set latitude = $lat, longitude = $lng where iconId = $iconId";
                if ($debugEndCHeck) $msg .= "updated point from " . $recIcon['latitude'] . ", " . $recIcon['longitude'] . " to $lat, $lng $eol";
                if ($debugEndCHeck) $msg .= "$sql $eol";
                $wpdbExtra->query($sql);
                $latOld = $recIcon['latitude'];
                $lngOld = $recIcon['longitude'];
                $msg .= "moved icon $iconName from $latOld, $lngOld to $lat, $lng $eol";
            }
        }

        return $msg;;
    } // end checkMoveIcons
    /**
     * Adjusts a single KML coordinate string in place if its latitude or longitude
     * is within a small tolerance of the provided target values.
     *
     * The input must be a comma-separated string in the form "lng,lat,alt" containing
     * exactly three components. The method:
     * - Splits the string and validates component count.
     * - Rounds parsed lat/lng using freeWheel::latRoundTo.
     * - Compares against $lat/$lng with a tolerance of 1e-6 degrees.
     * - If either component is within tolerance, rewrites the string to "$lng,$lat,0".
     *
     * @param string &$pointArrayElement KML coordinate string "lng,lat,alt"; updated in place if an adjustment occurs.
     * @param float  $lat                Target latitude to compare against.
     * @param float  $lng                Target longitude to compare against.
     *
     * @return bool True if the coordinate was within tolerance and updated; false otherwise.
     *
     * @throws \Exception If the coordinate string does not contain exactly three comma-separated values.
     */
    private static function checkMoveOnePoint(&$pointArrayElement, $lat, $lng)
    {
        $adjust = false;
        $coord = explode(",", $pointArrayElement);
        if (3 != count($coord)) {
            $message = rrwFormat::backtrace("E#2606 point $pointArrayElement does not have 3 numbers", 5);
            throw new Exception($message);
        }
        $toleranceDegrees = .000001;
        $latPoint = round($coord[1], freeWheel::latRoundTo);
        $lngPoint = round($coord[0], freeWheel::latRoundTo);
        $adjust = false;
        if (abs($latPoint - $lat) < $toleranceDegrees) {
            $adjust = true;
        }
        if (abs($lngPoint - $lng) < $toleranceDegrees) {
            $adjust = true;
        }
        if ($adjust) {
            $pointArrayElement = $lng . "," . $lat . ",0";
        }
        return $adjust;
    }
    /**
     * Reverses lines based on the provided attributes and trail ID.
     *
     * This function processes the "reverse" and "sequence" parameters from the attributes
     * to determine which lines need to be reversed. It constructs SQL queries to fetch
     * the relevant line IDs and then reverses each line.
     * The trailId parameter is used to prevent keystroke errors from reversing lines in the wrong trail.
     *
     * @param array $attributes An associative array of attributes that may contain "reverse" and "sequence" keys.
     *      The "reverse" parameter is a comma-separated list of line IDs to reverse.
     *      The "sequence" parameter is a range of sequence numbers to reverse.
     * @param int $trailId The ID of the trail for which lines are being reversed.
     * @return string A message detailing the operations performed.
     * @throws Exception If the "sequence" parameter is not in the correct format.
     * @throws Exception line with id is not found.
     */
    private static function reverseLines($attributes, $trailId)
    {
        $msg = "";
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $debugReversing = false;
        $msg .= "I#2540 reverse lines if requested, ?reverse=<lineId1,lineId2,...>, ?sequence=<start,end> $eol";
        $reverseList = rrwParam::String("reverse", $attributes);
        $msg .= "I#2541 reverseList $reverseList $eol";
        if (!empty($reverseList)) {
            $ranges = explode(",", $reverseList);
            $msg .= rrwUtil::print_r($ranges, true, "i#2542 ranges to process");
            foreach ($ranges as $reverse) {
                if (empty($reverse))
                    continue;
                $msg .= self::reverseLineId($reverse, $trailId);
            }
        }
        $sequence = rrwParam::String("sequence");
        if (!empty($sequence)) {
            $range = explode(",", $sequence);
            if (count($range) != 2)
                throw new Exception("$msg $errorBeg E#2543 range should ne nnn,nnn $errorEnd");
            $sqlRev = "select lineId from $wpdbExtra->lines where sequence >= $range[0] " .
                " and sequence <= $range[1] and trailId = '$trailId' " .
                " order by sequence";
            $msg .= "$sqlRev $eol Reverse lines between " . $range[0] . "
                    a               nd " . $range[1] . $eol;
            if ($debugReversing) $msg .= " Range sql $sqlRev $eol ";
            $lineRevs = $wpdbExtra->get_resultsA($sqlRev);
            if (empty($lineRevs) || 0 == $wpdbExtra->num_rows)
                throw new Exception("$msg $errorBeg E#2544 no lines found with $trailId, and range  $errorEnd $sqlRev $eol");
            foreach ($lineRevs as $lineRev) {
                $lineId = $lineRev["lineId"];
                $msg .= self::reverseLineId($lineId, $trailId);
                if ($debugReversing) $msg .= " reverse $lineId $eol ";
            }
        } // end if sequence
        return $msg;
    } // end reverseLines
    public static function assignSequenceNumbersOnLines($trailId)
    {
        /*	matches begin end points and list them in order
         *	updates the sequence number which is order along the trail
         * gets starting sequence number from trails.trSequence
         *	provides for reversing the order of the coordinates
         *		?reverse=NN - reverses the line with that line id
         *		?range= NNNN - reverses the lines with sequence number nnnn to  nnnn+1000
         *	calls the kml create routine if a reversal occurred.
         */
        global $sequence;
        global $begLat, $begLng, $endLat, $endLng, $nameById;
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        try {
            $debugMergeLines = rrwParam::isDebugMode("debugMergeLines", false);
            if ($debugMergeLines) $msg .= freewheeling_kml_common::displayIconsLines($trailId, "i#2545 before assigning line sequence ");
            $msg .= "I#2546 Assign Sequence numbers$eol";
            $begLat = array();
            $begLng = array();
            $endLat = array();
            $endLng = array();
            $nameById = array();
            //  ----------------------------- done with reversing. get the initial sequence number
            $sqlSeq = "select trSequence from $wpdbExtra->trails where trId = '$trailId' ";
            $sequence = $wpdbExtra->get_var($sqlSeq);
            if ($sequence == 0)
                $sequence = 500000; // big number beyond assigned range
            $sql = "update $wpdbExtra->lines set sequence = 0 where trailId = '$trailId'";
            if ($debugMergeLines) $msg .= " $sql $eol ";
            $wpdbExtra->query($sql);
            // 	----------------------------- setup done. lets go do it
            $cntMerges = 0;
            $next = array();
            while ($cntMerges < 1) { // do this once
                $cntMerges++;
                // build begin and end point arrays, no order to the array
                $cnt = self::getIndividualPoints($trailId);
                if ($debugMergeLines) $msg .= " found $cnt begin and end points$eol ";
                if ($cnt == 0) {
                    throw new Exception(" $msg $errorBeg E#2547 Found zero points . Is trail name correct ? $errorEnd ");
                }
                if ($cnt == 1) {
                    foreach ($begLat as $keyOfOne => $lat) { // that was easy
                        $msg .= self::UpdateSequence($keyOfOne);
                        return $msg;
                    }
                } else {
                    if ($debugMergeLines) $msg .= " found $cnt begin and end points$eol ";
                    $next = self::matchEndToStart("pass $cntMerges ", $msg);
                    if ($debugMergeLines) $msg .= rrwUtil::print_r($next, true, "I#2548 next array after the matchEndToStart");
                }
            }
            $msg .= self::orderNext($next);
            if ($debugMergeLines) $msg .= freewheeling_kml_common::displayLines($trailId, "I#2549 after assigning line sequence ");
        } catch (Exception $e1) {
            throw new Exception("
                    $msg $eol  E#2550 Exception " . $e1->getMessage() . "at bottom of assignSequenceNumbersOnLines $eol");
        }
        return $msg;
    }
    private static
    function orderNext($next)
    {
        global $eol, $errorBeg, $errorEnd;
        global $sequence;
        $msg = "";
        $msg .= "I#2551 use orderNext to assign sequence numbers $eol";
        $debugNext = rrwParam::Boolean("next");
        ksort($next);
        if ($debugNext) $msg .= self::displayNext($next, "sorted Next: ");
        if (count($next) == 0) {
            $msg .= "E#2552 $errorBeg No lines to process in orderNext $errorEnd $eol";
            throw new Exception($msg);
        } elseif (count($next) == 1) {
            if ($debugNext) $msg .= self::displayNext($next, "only one line: ");
            // only one line
            foreach ($next as $key => $v) {
                $msg .= self::UpdateSequence($key);
                break;
            }
            return $msg;
        }
        $loopNext = 0;
        while (count($next) > 0) {
            $loopNext++;
            if ($loopNext > 60) {
                $msg .= self::displayNext($next, "maybe a circular list: ");
                throw new Exception("$msg $errorBeg E#2553 too may times
                                through main loop of orderNext $errorEnd");
            }
            if ($debugNext) {
                $msg .= $eol . self::displayNext(
                    $next,
                    "loop $loopNext list to be processed this loop"
                );
            }
            //find the key in next that is not in prev i.e. a start of chain
            foreach ($next as $key => $v) {
                if ($debugNext) $msg .= "looking for $key in not in previous  $eol";
                if (in_array($key, $next) === false) {
                    // this $key has no previous
                    if ($debugNext) $msg .= "Start line $key -> ";
                    $sequence = $sequence + 10;
                    $msg .= self::UpdateSequence($key);
                    $loopCnt = 0;
                    while (array_key_exists($key, $next)) {
                        $keyNext = $next[$key];
                        unset($next[$key]);
                        if ($debugNext) $msg .= "$keyNext -> ";
                        $msg .= self::UpdateSequence($keyNext);
                        $loopCnt++;
                        if ($loopCnt > 250)
                            throw new Exception("$msg $errorBeg E#2554 too may times
                                through secondary loop of orderNext $errorEnd");
                        $key = $keyNext;
                    }
                    unset($next[$keyNext]);
                    if ($debugNext) $msg .= $eol;
                    break;
                }
            }
        }
        return $msg;
    }
    /*
    static private
    function mergeLinesMaybe($trailId)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        global $makeFinal;
        $msg = "";
        $msg .= "needs  a rewrite to set matching begin/end points, rather than sequence
                should be done om everyLineMatchStart routine
                Attempt to merge lines disabled $eol";
        return $msg;
        $debugBeforeAfter = rrwParam::Boolean("debugBeforeAfter");
        if ($debugBeforeAfter) $msg .= freewheeling_kml_common::displayIconsLines($trailId, "before merging lines");
        $sqlDisplay = "SELECT sequence , latStart, latEnd, lngStart, lngEnd, " .
            "lineId, lineName, mapStyle, lineIconId, iconName, pointList
		FROM $wpdbExtra->lines
		left join $wpdbExtra->icons on lineIconId = iconId
		where $wpdbExtra->lines.trailId = '$trailId' " .
            "order by sequence ";
        $msg .= "$sqlDisplay $eol";
        $displays = $wpdbExtra->get_resultsA($sqlDisplay);
        $testEnd = "not yet";
        $pointListLengthPast = 0;
        $lineIdpast = -999;
        foreach ($displays as $display) {
            $mapStyle = $display["mapStyle"];
            $sequence = $display["sequence"];
            $iconName = $display["iconName"];
            $lineId = $display["lineId"];
            $latStart = $display["latStart"];
            $lngStart = $display["lngStart"];
            $latEnd = $display["latEnd"];
            $lngEnd = $display["lngEnd"];
            $pointList = $display["pointList"];
            $pointListLength = strlen($pointList);
            $testStart = $mapStyle . $latStart . $lngStart;
            if (
                $testEnd == $testStart &&
                stripos($iconName, "mile") != false &&
                ($pointListLengthPast + $pointListLength) < 4000
            ) {
                // join them
                $msg .= " merge line $lineIdpast and $lineId $eol";
                $sqlUpdate = "update $wpdbExtra->lines set pointList = concat(pointList, ' ', '$pointList'),
							lngEnd = $lngEnd, latEnd = $latEnd
							where lineId = $lineIdpast";
                $msg .= $wpdbExtra->query($sqlUpdate);
                $msg .= $wpdbExtra->delete($wpdbExtra->lines, array("lineId" => $lineId));
                $msg .= self::UpdateInternalLineFieldsFromPoints($trailId);
                $makeFinal = "please"; // an update was made
                $lineId = $lineIdpast;
            }
            $testEnd = $mapStyle . $latEnd . $lngEnd;
            $lineIdpast = $lineId;
            $pointListLengthPast = $pointListLength;
        }
        if ($debugBeforeAfter) $msg .= freewheeling_kml_common::displayIconsLines($trailId, "After merging lines");
        return $msg;
    } // end mergeLinesMaybe
     */
    private static function iconsMissingIconStyle($trailId)
    {
        // look for icons with out a onMap value
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $debug = rrwParam::Boolean("debug");
        $msg .= "iconsMissingIconStyle:Find/assign icons with missing iconStyle $eol";
        $sqlBad = "update $wpdbExtra->icons set iconStyle = 'flag.png' where iconStyle = ''";
        $badCnt = $wpdbExtra->query($sqlBad);
        if ($badCnt != 0)
            $msg .= "E#2555 found and updated  $badCnt blank iconStyles to flag $eol";
        return $msg;
    } // end iconsMissingIconStyle
    private static function assignSortFieldInIcon($trailId)
    {
        /* Assign the line id to the iconLineId field
         * assign the line id to the icon Sort field
         * append something?? to sort field to handle multiple icons on a line
         *
         * Assert that all lines on tis trail have a sequence number
        */
        global $eol, $errorBeg, $errorEnd, $noteBeg, $noteEnd;
        global $wpdbExtra;
        $msg = "";
        try {
            $debug = rrwParam::Boolean("debug");
            $updateCnt = 0;
            // Assert that all lines on tis trail have a sequence number, trust but verify
            $sqlLineCheck = "select lineId, LineName, sequence from $wpdbExtra->lines where trailId = '$trailId'
                        and (sequence = 0 or isNull (sequence) or sequence = '')";
            $recLines = $wpdbExtra->get_resultsA($sqlLineCheck);
            if (0 != $wpdbExtra->num_rows) {
                $msgErr = "errorBeg I#2556 found $wpdbExtra->num_rows lines for $trailId with out a sequence number$errorEnd $sqlLineCheck $eol";
                $msg .= freewheeling_kml_common::displayIconsLines($trailId, "$msgErr");
                $msg .= $msgErr;
                //        throw new Exception($msg);
            } // clean out the previous data
            $sqlClean = "update $wpdbExtra->icons set sort = 0, iconLineId =0 where trailId = '$trailId'";
            $wpdbExtra->query($sqlClean);
            // grt the icons that need sorting
            $sqlIcons = "select iconId, iconName, latitude, longitude, onMap from $wpdbExtra->icons
                        where trailId = '$trailId' and not onMap = '" . freeWheel::estimated_milepost . "'
                                 and position('offline' in onMap) = 0 ";
            $recIcons = $wpdbExtra->get_resultsA($sqlIcons);
            $toBeUpdated = $wpdbExtra->num_rows;
            foreach ($recIcons as $recIcon) {
                $iconId = $recIcon["iconId"];
                $iconName = $recIcon["iconName"];
                $latitude = $recIcon["latitude"];
                $longitude = $recIcon["longitude"];
                $onMap = $recIcon["onMap"];
                // check a box around each line segment to see if this Icon is inside the box
                $recLine = freewheeling_kml_common::get_lineRecGivenIconData($iconId, $iconName, $latitude, $longitude);
                if (0 == count($recLine)) {
                    $msg .= "E#2557 icon $iconId-$iconName at $latitude, $longitude, onMap = $onMap not on a line $eol";
                } else {
                    $msg .= self::makeTheMatch($iconId, $iconName, $recLine["lineId"], $recLine["lineName"], $recLine["sequence"]);
                }
            } // end foreach
            // now check if two icons are on the same line
            $sqlDuplicate = "select iconId from $wpdbExtra->icons
                                    where trailId = '$trailId'and not onMap = '" . freeWheel::estimated_milepost . "'
                                    group by sort having count(*) > 1";
            $recSorts = $wpdbExtra->get_resultsA($sqlDuplicate);
            if (0 == $wpdbExtra->num_rows) {
                $msg .= "I#2558 no duplicate or missing sort fields found $eol";
            } else {
                $msg .= "$noteBeg I#2559 found $wpdbExtra->num_rows duplicate sort fields $noteEnd";
                $msg .= "<table>\n" . rrwFormat::HeaderRow("Icon", "Latitude", "Longitude", "Sort");
                foreach ($recSorts as $recSort) {
                    $iconIdProblem = $recSort["iconId"];
                    $sqlProblems = "select iconId, iconName, latitude, longitude, sort from $wpdbExtra->icons where iconId = $iconIdProblem";
                    $recProblems = $wpdbExtra->get_resultsA($sqlProblems);
                    foreach ($recProblems as $recProblem) {
                        $iconId = $recProblem["iconId"];
                        $iconName = $recProblem["iconName"];
                        $latitude = $recProblem["latitude"];
                        $longitude = $recProblem["longitude"];
                        $sort = $recProblem["sort"];
                        $msg .= rrwFormat::CellRow(" #$iconId - $iconName", $latitude, $longitude, $sort);
                        //     $msg .= "E#2560 icon $iconId-$iconName at $latitude, $longitude matched to line $sort $eol";
                    } // end foreach recProblems
                } // end foreach recProblems
                $msg .= "</table>\n";
            }
            $msg .= "I#2561 updated $updateCnt out of $toBeUpdated sort cords and iconLineId $eol";
        } catch (Exception $e1) {
            $msg .= $e1->getMessage() . "$errorBeg E#2562 Thrown out at the bottom of  assignSortFieldInIcon $errorEnd ";
            throw new Exception($msg);
        }
        return $msg;
    }
    public static function updateTheJunctionsMileages(): string
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd, $noteBeg, $noteEnd;
        $msg = "";
        $debugJunctions = rrwParam::isDebugMode("debugjunctions", false);
        // now work with duplicate names at the trail junctures
        $sqlFind = "select * from $wpdbExtra->trailIcons
                            where isTrailHead in (-4, -5)
                                 order by iconName, isTrailHead desc";
        $recIcons = $wpdbExtra->get_resultsA($sqlFind);
        if ($debugJunctions) {
            $msg .= "found " . $wpdbExtra->num_rows . " points with junctions $eol";
            //    $msg .= rrwUtil::print_r($recIcons, true, "junctions");
            $msg .= "<table>";
        }
        $pastName = "";
        $pastMile = 0;
        $pastTrailId = "";
        $pastMergeSeqence = 0;
        if ($debugJunctions) $msg .= "<table>";
        foreach ($recIcons as $recIcon) {
            $trail = $recIcon["trailId"];
            $iconId = $recIcon["iconId"];
            $iconName = $recIcon["iconName"];
            $junctionCode = $recIcon["isTrailHead"];
            $milepost = $recIcon["milepost"];
            $trailId = $recIcon["trailId"];
            $mergeSequence = $recIcon["mergeSequence"];
            $link = freeWheelFormat::EditIconLink($iconId, $iconName);
            if ($debugJunctions) $msg .= rrwFormat::CellRow($trail, $link, $junctionCode, $milepost);
            switch ($junctionCode) {
                case -4:
                case "give":
                    // the milege is the calculated milepost from the end of the previous trail
                    $pastName = $iconName;
                    $pastMile = $milepost;
                    $pastTrailId = $trailId;
                    $pastMergeSequence = $mergeSequence;
                    if ($debugJunctions) $msg .= rrwFormat::CellRow("give", $iconName, $milepost, $trailId);
                    break;
                case -5:
                case "recieve":
                    if ($debugJunctions) {
                        $msg .= rrwFormat::CellRow("receive", $iconName, $pastMile, $pastTrailId);
                        $msg .= rrwFormat::CellRow("compare name", $pastName, $iconName);
                        $msg .= rrwFormat::CellRow("compare milepost", $pastMile, $milepost);
                    }
                    // this is the start of the next trail, need to move the milepost from end of the trail
                    if ($pastName != $iconName) {
                        $msg .= "$errorBeg I#2506 found a junction ($iconName) that did not match the previous junction ($pastName)
                                        i.e a -5 with no previous -4 $errorEnd";
                        break;
                    }
                    if ($mergeSequence <= $pastMergeSequence || empty($mergeSequence) || empty($pastMergeSequence)) {
                        $msg .= "$noteBeg E#2505 found a junction ($iconName) with a merge sequence ($mergeSequence) that is less than the previous junction ($pastName) with $pastMergeSequence
                                        i.e a -5 with a merge sequence less than the previous -4 $noteEnd";
                    }
                    if ($pastMile != $milepost) {
                        // need to update the next trails staring milepost, and flag it for recompute
                        if (empty($pastMile)) {
                            $msg .= "$iconName with an empty give value. Try merging previous run
                                        <a href='/merge?trailId=#pastTrailId' target='merge'> merge $pastTrailId </a> $eol";
                            break;  // there is no mialge to pass forward.
                        }
                        $sqlIcon = "update $wpdbExtra->icons set milepost = $pastMile  where iconId = $iconId";
                        $msg .= "$sqlIcon; $eol";
                        if ($debugJunctions) $msg .= rrwFormat::cellRow($sqlIcon);
                        $wpdbExtra->query($sqlIcon);
                        $msg .= freewheelingeasy_kml_merge::set_mergeStatus('ready', $trailId); // mileage changed. redo the merge
                    }
                    break;
                default:
                    $msg .= "$errorBeg E#2507 found an invalid junction code ($junctionCode) for junction ($iconName)
                                        should be either -4 or -5. Found: $junctionCode. Please check the junction code for correctness. $errorEnd";
                    break;
            } // end switch junctionCode
            $pastName = $iconName;
            $pastMile = $milepost;
            $pastTrailId = $trailId;
        } // end foreach recIcons
        if ($debugJunctions) $msg .= "</table>";
        return $msg;
    } // end function updateTheJunctionsMileages

    private static function makeTheMatch($iconId, $iconName, $lineId, $lineName, $newSequence)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $sqlUpdate1 = "update $wpdbExtra->icons set sort = '$newSequence-0000', iconLineId = $lineId where iconId = $iconId ";
        $wpdbExtra->query($sqlUpdate1);
        $sqlUpdate2 = "update $wpdbExtra->lines set lineIconId = $iconId where lineID = $lineId";
        $wpdbExtra->query($sqlUpdate2);
        // $msg .= "I#2563 icon #$iconId-$iconName has been assigned to line #$lineId-$lineName $eol";
        return $msg;
    }
    /**
     * Updates the line information from the points in the database.
     * lat start,lngstartmlngstart,lngend,latend,latmax,lngmax,latmin,lngmin, lengthmetters
     * does not change the point list
     *
     * assumes the point list is correct data, routine updates:
     *      Line Length in Meters
     *      Start/end  Latitude, longitude
     *      Start/end Latitude, longitude a sql types 'Point'
     *      Max/Min Latitude, longitude
     *
     * * @param mixed $trailId The ID of the trail or line to update.
     * @return string The result message of the update process.
     */
    public static function UpdateInternalLineFieldsFromPoints($trailId)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        global $meters2Mile;
        $msg = "";
        $debugLengthCalc = false;
        if ($debugLengthCalc) $msg .= "UpdateInternalLineFieldsFromPoints($trailId) $eol";
        if (is_numeric($trailId))
            $sqlWhere = "lineId = $trailId";
        else
            $sqlWhere = " trailid = '$trailId'";
        $msg .= freeWheeling_edit_setGlobals::setGlobals("UpdateInternalLineFieldsFromPoints");
        $sqlLines = "select trailId, latStart, lngStart, latEnd, lngEnd,
                        latMax, lngMax, latMin, lngMin,
				        lineName, lengthMeters, sequence, pointList, lineId
				from $wpdbExtra->lines
				where  $sqlWhere
				order by sequence";
        if ($debugLengthCalc) $msg .= "searching for $sqlLines $eol";
        $recLines = $wpdbExtra->get_resultsA($sqlLines);
        $distSum = 0; // distance along trail at end of line from start
        $sequencePast = 0;
        if (count($recLines) == 0)
            return ("E#2564 did not find any lines to work with check $eol $sqlLines");
        $milePast = 0;
        foreach ($recLines as $recLine) {
            $pointList = $recLine["pointList"];
            $lengthMeters = $recLine["lengthMeters"];
            $sequence = $recLine["sequence"];
            $lineName = $recLine["lineName"];
            $latStartSaved = $recLine["latStart"];
            $lngStartSaved = $recLine["lngStart"];
            $latEndSaved = $recLine["latEnd"];
            $lngEndSaved = $recLine["lngEnd"];
            $latMinSaved = $recLine["latMin"];
            $latMaxSaved = $recLine["latMax"];
            $lngMinSaved = $recLine["lngMin"];
            $lngMaxSaved = $recLine["lngMax"];
            if (strpos($lineName, "Variety Store to Marriann"))
                $debugLengthOneLine = true;
            else
                $debugLengthOneLine = false;
            $lineId = $recLine["lineId"];
            $pointList = trim($pointList);
            $points = explode(" ", $pointList);
            if ($debugLengthOneLine) {
                //              $msg .= rrwUtil::print_r( $points, true, "ponts along the line" );
                $msg .= "<table>" . rrwFormat::HeaderRow("point", "latitude", "logitude", "distance", "sum distance");
            }
            if ($debugLengthOneLine) $msg .= rrwformat::CellRow($lineName, $lengthMeters . " meters " . $lengthMeters / $meters2Mile . "miles");
            if (abs($sequence - $sequencePast) > 11) {
                $milePast = 0;
                if ($debugLengthOneLine) $msg .= "new line segmant $eol";
            }
            if ($debugLengthOneLine)
                $msg .= "miles at atart of line $milePast $eol";
            $firstPoint = true;
            $cntPoints = 0;
            $lineSum = 0;
            // now look at each point on the line
            $caltable = "<table>" . rrwFormat::HeaderRow("new latitude", "now logitude", "past latitude", "passt longitude", "distance");
            $latPast = 0.0;
            $lngPast = 0.0;
            $latMax = -180.0;
            $lngMax = -180.0;
            $latMin = 180.0;
            $lngMin = 180.0;
            foreach ($points as $point) {
                if (empty($point))
                    continue;
                $cntPoints++;
                $latlon = explode(",", $point);
                if (3 != count($latlon)) {
                    $msg .= "E#2565 line $lineName point '$point' does not have 3 numbers $eol pointList = $pointList";
                    throw new Exception("$msg $errorBeg E#2566 UpdateInternalLineFieldsFromPoints: $errorEnd");
                }
                $newLat = round($latlon[1], freeWheel::latRoundTo);
                $newLng = round($latlon[0], freeWheel::latRoundTo);
                $mileNext = 0;
                if ($firstPoint) {
                    $firstPoint = false;
                    $latStart = $newLat;
                    $lngStart = $newLng;
                    if ($debugLengthOneLine) $msg .= rrwformat::CellRow($point, $newLat, $newLng, " ", $lineSum);
                } else {
                    $distance = distanceMeters($newLat, $newLng, $latPast, $lngPast);
                    $lineSum += $distance;
                    $caltable .= rrwformat::CellRow($newLat, $newLng, $latPast, $lngPast, $distance);
                }
                $latMax = max($latMax, $newLat);
                $lngMax = max($lngMax, $newLng);
                $latMin = min($latMin, $newLat);
                $lngMin = min($lngMin, $newLng);
                $latPast = $newLat;
                $lngPast = $newLng;
                $milePast = $mileNext;
            } // end foreach ( $points as $point )
            if ($cntPoints < 2)
                throw new Exception("$msg $errorBeg E#2567 UpdateInternalLineFieldsFromPoints:
						no points on the line $errorEnd $sqlLines $eol
						lineName = '$lineName' $eol ");
            $lineSum = round($lineSum, 0);
            $update = array(
                "lengthMeters" => $lineSum,
                "latStart" => $latStart,
                "lngStart" => $lngStart,
                "latEnd" => $latPast,
                "lngEnd" => $lngPast,
                "latmax" => $latMax,
                "lngmax" => $lngMax,
                "latmin" => $latMin,
                "lngmin" => $lngMin,
            );
            $where = array("lineId" => $lineId);
            $result = $wpdbExtra->update($wpdbExtra->lines, $update, $where);
            if (0 == $result) {
                if ($debugLengthCalc) $msg .= "I#2568 line #$lineId $lineName had no changes $eol";
            } else {
                $msg .= "I#2569 line #$lineId $lineName updated $eol";
                $msg .= "<table>" . rrwFormat::HeaderRow("type", "latStart", "lngStart", "latEnd", "lngEnd", "length", "latMax", "lngMax", "latMin", "lngMin");
                $msg .= rrwFormat::CellRow(
                    "calculated",
                    $latStart,
                    $lngStart,
                    $latPast,
                    $lngPast,
                    $lineSum,
                    $latMax,
                    $lngMax,
                    $latMin,
                    $lngMin
                );
                $msg .= rrwFormat::CellRow(
                    "previous",
                    $latStartSaved,
                    $lngStartSaved,
                    $latEndSaved,
                    $lngEndSaved,
                    $lengthMeters,
                    $latMaxSaved,
                    $lngMaxSaved,
                    $latMinSaved,
                    $lngMinSaved
                );
                $msg .= "</table>";
                $msg .= rrwUtil::print_r($update, true, "update array");
                $msg .= $pointList . $eol;
                $sqlPointData = "update $wpdbExtra->lines set lnBegPoint = point(latStart, lngStart),
                                                          lnEndPoint = point(latEnd, lngEnd)
                                    where lineId = $lineId";
                $cnt = $wpdbExtra->query($sqlPointData);
            } // of if (0 == $result)
        } // end       foreach ( $recLines as $recLine )
        $caltable .= "</table>";
        if ($debugLengthCalc) $msg .= $caltable;
        return $msg;
    } // end function UpdateInternalLineFieldsFromPoints( $trailId )
    private static function displayNext($next, $title)
    {
        global $errorBeg, $errorEnd, $eol;
        $msg = "";
        $msg .= "$title: ";
        foreach ($next as $from => $to) {
            $prev[$to] = $from;
            $msg .= "$from->$to, "; // dislay the list
        }
        $msg .= "$eol";
        return $msg;
    }
    private static
    function getIndividualPoints($trailId)
    {
        global $begLat, $begLng, $endLat, $endLng, $nameById;
        global $errorBeg, $errorEnd, $eol;
        global $wpdbExtra;
        // build a list if points, no calculations or order to the points
        $debuggetIndividualPoints = true;
        $msg = "";
        $sql = "select latStart,lngStart, latEnd,lngEnd, lineId, pointList, lineName from $wpdbExtra->lines";
        $sql .= " where trailId = '$trailId' order by latstart";
        if ($debuggetIndividualPoints) $msg .= "match:looking: $sql $eol";
        $recs = $wpdbExtra->get_resultsA($sql);
        if ($wpdbExtra->num_rows == 0) {
            $begLat = array();
            $begLng = array();
            $endLat = array();
            $endLng = array();
            $nameById = array();
            return 0;
            throw new Exception("$msg $errorBeg E#2570 No points returne from the selection $eol $sql failed
									$errorEnd");
        }
        $cnt = 0;
        foreach ($recs as $rec) {
            $id = $rec["lineId"];
            $begLat[$id] = round($rec["latStart"], freeWheel::latRoundTo);
            $begLng[$id] = round($rec["lngStart"], freeWheel::latRoundTo);
            $endLat[$id] = round($rec["latEnd"], freeWheel::latRoundTo);
            $endLng[$id] = round($rec["lngEnd"], freeWheel::latRoundTo);
            $nameById[$id] = $rec["lineName"];
            //		$pointList[ $id2 ] = $rec[ "pointList" ];
            $cnt++;
        }
        return $cnt;
    } // end private static function  getIndividualPoints (){
    private static     function matchEndToStart($passNum, &$msg)
    {
        /* given the array $endlat build the array next
         * next is a list of lineId pairs where key connects value in order.
         */
        global $begLat, $begLng, $endLat, $endLng, $nameById;
        global $errorBeg, $errorEnd, $eol;
        $cntpnt = 0;
        $cntDup = 0;
        $debugEndToStart = rrwParam::isDebugMode("debugEndToStart", false);
        try {
            if (!isset($begLat) || !isset($endLat) || !is_array($begLat) || !is_array($endLat)) {
                $msg .= "E#2571 matchEndToStart called with out the arrays set $eol";
                throw new Exception("$msg $errorBeg E#2572 matchEndToStart called with out the arrays set $errorEnd");
            }
            if ($debugEndToStart) {
                $msg .= "in $passNum there are " . count($begLat) . " Lat entries.$eol";
                foreach ($endLat as $key2 => $saveLat) {
                    $msg .= $begLat[$key2] . " " . $endLat[$key2] . " -- " .
                        $begLng[$key2] . " " . $endLng[$key2] . " -- " . $nameById[$key2] . $eol;
                }
            }
            $next = array();
            if (count($begLat) < 2) {
                throw new Exception("$msg $errorBeg E#2573 No points returne from the selection $eol pass #$passNum failed
                                    $errorEnd");
            }
            asort($begLat);
            $debugLoop = rrwParam::isDebugMode("debugLoop", false);
            if ($debugLoop) $msg .= "pass $passNum " . rrwUtil::print_r($endLat, true, "endlat just before we loop trrough ")
                . rrwUtil::print_r($begLat, true, "begLat just before we loop trrough ");
            foreach ($endLat as $key2 => $saveLat) { // loop through the end points
                $cntpnt++;
                $saveKey = $key2;
                $saveLng = $endLng[$key2];
                if ($debugLoop) $msg .= "looking for a latitude of $saveLat $eol";
                foreach ($begLat as $key1 => $thisLat) { // now loop through the srting points
                    if ($key1 == $saveKey)
                        continue;
                    if (!key_exists($key1, $begLng)) {
                        $msg .= "looking for $key1 in " . rrwUtil::print_r($begLng, true, "begLng");
                        throw new Exception("$msg $errorBeg E#2574 No points returne from the selection $eol pass #$passNum failed
                                    $errorEnd");
                    }
                    $thisLng = $begLng[$key1];
                    $diff = abs($saveLat - $thisLat);
                    $diff2 = abs($saveLng - $thisLng);
                    if ($debugLoop) $msg .= " &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
											$thisLat === $thisLng yields " .
                        round($diff, 5) . ", " . round($diff2, 5) . $eol;
                    if ($diff < .000002 && $diff2 < .000002) {
                        $next["$saveKey"] = $key1; // found match end point links to this one
                        if ($debugEndToStart) $msg .= "pass 1 - passnum says " . $nameById["$key1"] .
                            " follows " . $nameById["$key2"] . " $key1-&gt;$key2 $eol";
                        break;
                    }
                }
            }
            if ($debugEndToStart)
                $msg .= self::displayNext($next, "result of match start to end");
            return $next;
        } catch (Exception $e1) {
            $msg .= $e1->getMessage() . "$errorBeg #2575 Thrown out at the bottom of  matchEndToStart$errorEnd ";
            throw new Exception($msg);
        }
    } // end private static function  matchEndToStart(){
    private static     function reverseLineId($lineKey, $trail1Id)
    {
        global $errorBeg, $errorEnd, $eol;
        global $wpdbExtra;
        $msg = "";
        if ($lineKey == 0)
            return "E#2576 reverseLineId called with line key = zero $eol";
        $msg .= "reversing $lineKey$eol";
        $sql = "select latStart,lngStart, latEnd,lngEnd, pointList from $wpdbExtra->lines";
        $sql .= " where lineId = '$lineKey' and '$trail1Id' = trailId";
        $msg .= "$sql$eol";
        $recs = $wpdbExtra->get_resultsA($sql);
        if ($wpdbExtra->num_rows == 0) {
            throw new Exception("$msg $errorBeg E#2577 sqlUpdate:select of existing: $sql failed
				--- $eol $sql $errorEnd");;
        }
        $cnt = 0;
        foreach ($recs as $rec) {
            $latStart = $rec["latStart"];
            $lngStart = $rec["lngStart"];
            $latEnd = $rec["latEnd"];
            $lngEnd = $rec["lngEnd"];
            $pointList = $rec["pointList"];
            $pointArray = explode(" ", $pointList);
            $pointArray = array_reverse($pointArray);
            $pointArray = implode(" ", $pointArray);
            $sql = "update $wpdbExtra->lines set latStart = $latEnd, lngStart = $lngEnd, " .
                "latEnd = $latStart, lngEnd = $lngStart, pointList = '$pointArray'";
            $sql .= " where lineId = $lineKey ";
            $msg .= "$sql$eol";
            $recs2 = $wpdbExtra->query($sql);
        }
        return $msg;
    } // end reverseLineId
    private static
    function UpdateSequence($line, $setSequence = 0)
    {
        global $pointsLat, $pointsLng, $pointsid, $pointswhich, $pointList;
        global $sequence;
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        if ($setSequence == 0) {
            $sequence = $sequence + 10;
            $setSequence = $sequence;
        }
        $sql = "update $wpdbExtra->lines set sequence = $setSequence where lineId = $line";
        $wpdbExtra->query($sql);
        return "";
    }
    private static function breakLine($trailId)
    {
        global $errorBeg, $errorEnd, $eol;
        global $wpdbExtra;
        $msg = "";
        $debugBreak = true;
        if ($debugBreak) $msg .= "into Breakline $eol";
        $sqlBreaks = "select latitude, longitude, iconLineId, iconId, iconName
			from $wpdbExtra->icons where (iconName like 'Break Line%' or iconName like 'break line%' )
                    and trailId = '$trailId'";
        $recicons = $wpdbExtra->get_resultsA($sqlBreaks);
        if ($debugBreak) $msg .= "break line: $sqlBreaks $eol";
        if (0 == $wpdbExtra->num_rows) {
            if ($debugBreak) $msg .= "I#2578 No 'Break Lines' found $eol";
            return $msg;
        }
        if (5 < $wpdbExtra->num_rows) {
            $msg .= "$errorBeg E#2579 found " . $wpdbExtra->num_rows . " Break Points place marks' whic is too many $errorEnd $sqlBreaks $eol";
            throw new Exception($msg);
        }
        $cntBreaks = 0;
        foreach ($recicons as $recIcon) {
            $cntBreaks++;
            $breakPoint = $recIcon["iconName"];
            if ($cntBreaks > 10)
                throw new Exception("$msg $errorBeg E#2580 too many 'break Lines'
				$errorEnd ");
            $latitude = round($recIcon["latitude"], freeWheel::latRoundTo);
            $longitude = round($recIcon["longitude"], freeWheel::latRoundTo);
            $msg .= "E#2581 breaking a line at $latitude, $longitude $eol";
            $iconLineId = $recIcon["iconLineId"];
            $iconId = $recIcon["iconId"];
            $sqlLne = "select * from $wpdbExtra->lines where lineId = '$iconLineId'";
            if ($debugBreak) $msg .= "break line: $sqlLne $eol";
            $recLine = $wpdbExtra->get_resultsA($sqlLne);
            if (1 != $wpdbExtra->num_rows)
                throw new Exception("$msg $errorBeg E#2582 did not find just one line $errorEnd $sqlLne $eol");
            $coordString = $recLine[0]["pointList"];
            $lineId = $recLine[0]["lineId"];
            $sequence = $recLine[0]["sequence"];
            $lookFor = "$longitude,$latitude";
            $coordString = freewheeling_kml_common::CompressCoords($coordString, $msg);
            // Break point may not be on the line, find cloest point
            $coords = explode(" ", $coordString);    // make an array of lon, lat,0
            $minDist = 999999;
            foreach ($coords as $coord) {
                $coord = explode(",", $coord);
                $dist = freewheeling_calculations::distanceMeters($latitude, $longitude, $coord[1], $coord[0]);
                if ($dist < $minDist) {
                    $minDist = $dist;
                    $lookFor = $coord[0] . "," . $coord[1];
                }
            }
            // should now have a matching point
            $iiPt = strpos($coordString, $lookFor);
            if (false === $iiPt) {
                $msg .= " $errorBeg E#2583 did not find '$lookFor'
						in the list of coordinates $errorEnd  $coordString $eol";
                throw new Exception("$msg");
            }
            if (0 == $iiPt || (strlen($coordString) - $iiPt) < 76) {
                $msg .= " Breakpoint $breakPoint is at the start or end of the list of coordinates $eol";
                $cnt5 = $wpdbExtra->delete($wpdbExtra->icons, array("iconId" => $iconId));
                if ($debugBreak) $msg .= "delete break $cnt5 $eol";
                continue;
            }
            $coords2 = substr($coordString, $iiPt);
            $iispace = strpos($coordString, " ", $iiPt);
            $coords1 = substr($coordString, 0, $iispace);
            if (strlen($coords1) < 10 || strlen($coords2) < 10) {
                $msg .= " $errorBeg E#2584 coord1, or coord2 is empty $errorEnd $eol";
                $msg .= " looking for $breakPoint at $lookFor $eol";
                $msg .= " Location of the break point $iiPt, length of Coordinates is " . strlen($coordString) . $eol;
                $msg .= rrwUtil::print_r($coordString, true, "original the list of coordinates ");
                $msg .= rrwUtil::print_r($coords1, true, "resultant the list of coordinates ");
                $msg .= rrwUtil::print_r($coords2, true, "resultant the list of coordinates ");
                throw new Exception("$msg $eol");
            }
            $minmax1 = freewheeling_kml_common::updateMinMaxOfLine($coords1, $msg);
            $minmax2 = freewheeling_kml_common::updateMinMaxOfLine($coords2, $msg);
            $lineName1 = $recLine[0]["lineName"] . "-a1";
            $lineName2 = $recLine[0]["lineName"] . "-a2";
            if ($debugBreak) {
                $msg .= rrwUtil::print_r($coords1, true, "front half");
                $msg .= rrwUtil::print_r($minmax1, true, "front half min max");
                $msg .= rrwUtil::print_r($coords2, true, "back half");
                $msg .= rrwUtil::print_r($minmax2, true, "back half min max");
            }
            // replae the orginl line
            $recLine[0]["pointList"] = $coords1;
            $cnt1 = $wpdbExtra->update(
                $wpdbExtra->lines,
                array("pointList" => $coords1),
                array("lineId" => $lineId)
            );
            $cnt2 = $wpdbExtra->update(
                $wpdbExtra->lines,
                array("linename" => $lineName1),
                array("lineId" => $lineId)
            );
            $cnt2 = $wpdbExtra->update(
                $wpdbExtra->lines,
                $minmax1,
                array("lineId" => $lineId)
            );
            // create a new line
            $recLine[0]["pointList"] = $coords2;
            $recLine[0]["lineName"] = $lineName2;
            $recLine[0]["sequence"] = $sequence + 5;
            unset($recLine[0]["lineId"]); // get new lineId
            $cnt3 = $wpdbExtra->insert($wpdbExtra->lines, $recLine[0]);
            $result = freewheeling_kml_common::updateMinMaxOfLine($coords2, $msg);
            $cnt4 = $wpdbExtra->update(
                $wpdbExtra->lines,
                $result,
                array("lineName" => $recLine[0]["lineName"])
            );
            // remove breakpoint
            $cnt5 = $wpdbExtra->delete($wpdbExtra->icons, array("iconId" => $iconId));
            if ($debugBreak) $msg .= "update/delete cnts are
			$cnt1 line 1 coords, $cnt2 line 1 minmax,
			$cnt3 line 2 coords, $cnt4 line 2 minmax, $cnt5 delete break $eol";
        } // end foreach icon
        return $msg;
    } // end breakline
} // end class
