<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.com
*/
class freewheeling_kml_read
{
    private  static $debugProgress = false;
    public static function doKmlRead($attrib)
    {
        global $errorBeg, $errorEnd, $eol;
        global $msgXMLprocess;
        $msg = "";
        $debugKMLRead = rrwParam::isDebugMode("doKmlRead");
        ini_set('display_errors', 1);
        if ($debugKMLRead) $msg .= "I#2490 start kml read$eol";
        $msgXMLprocess = "I#2484 start the xml process " . date("Y-m-d G:i:s") . "$eol";
        try {
            $task = rrwParam::String("task", $attrib);
            $submit = rrwParam::String("submit", $attrib);
            if (0 == strncmp($submit, "Initialize", 10)) {
                $msg .= self::newTrail($attrib);
                return $msg;
            }
            if ("highest" == $task) {
                $msg .= self::highest($attrib);
                return $msg;
            } elseif ("new" == $task) {
                $msg .= self::newTrail($attrib);
                return $msg;
            }
            $msg .= self::kmlRead($attrib);
        } catch (Exception $ex) {
            $msg .= $ex->getMessage() . "$errorBeg  E#702 main upload $errorEnd";
        }
        return $msg;
    }
    private static function kmlRead($attrib)
    {
        global $errorBeg, $errorEnd, $eol;
        global $freewheelingeasy_kml_directory;
        $msg = "";
        $debugKMLRead = rrwParam::isDebugMode("doKmlRead");
        try {
            $msg .= freeWheeling_edit_setGlobals::setGlobals("Kml Read");
            if (self::$debugProgress) $msg .= "E#2491 Starting KmlRead$eol";
            $filename = rrwParam::String("file", $attrib, "");  // file name passed in
            if (!empty($filename)) {
                $fileNameFull = $freewheelingeasy_kml_directory . "/" . $filename;
                if (!file_exists($fileNameFull)) {
                    $msg .= "$errorBeg E#2492 requested file $filename, but  $fileNameFull does not exist $errorEnd";
                    return $msg;
                }
            } else {
                $newTrail = rrwParam::Boolean("newTrail", $attrib, false);
                $filename = self::downloadKMLFile($attrib, $newTrail, $msg);
                $msg .= "I#494 after downloadKMLFile, filename = $filename $eol";
                if (null == $filename) {
                    $msg .= "E#2493 Select the <strong>KML</strong>file to upload $eol
                    <form method='post' enctype='multipart/form-data' >
                        Select kml file to upload:
                        <input type='file'  name='fileToUpload' id='fileToUpload'
                        width=100' value='' />
                        &nbsp; &nbsp;
                        <input type='checkbox' value='please' name='override' />allow overRight &nbsp; &nbsp; &nbsp; &nbsp;
                        <input type='checkbox' value='please' name='newTrail' />This is a new trail &nbsp; &nbsp; &nbsp; &nbsp;
                        <input type='submit' value='Upload File' name='submit' /> &nbsp; &nbsp; &nbsp; &nbsp;
                        <input type='submit' value='Initialize a new trail before read.' name='submit' />
                    </form>
                    $eol";
                    return $msg; // Ask for output  form asking for the file name
                }
            }
            // above gets us yhe file name to process
            if ($debugKMLRead) $msg .= "I$799 calling KMLtoDatabase( $filename) $eol";
            list($trailId, $versionNew) = freewheeling_kml_read::extractTrailIdAndNumber($filename, $msg);
            $msg .= "Trail $trailId version $versionNew $eol";
            if (self::$debugProgress) $msg .= "E#2494 calling KmlToDatabase $filename $eol";
            $msg .= self::KMLtoDatabase($filename);
            if (self::$debugProgress) $msg .= "E#2495 completed KmlToDatabase $eol";
            $msg .= lineBuffer::makeLineBuffer($trailId);
            if (self::$debugProgress) $msg .= "E#2489 completed KmlToDatabase $eol";
            if (self::$debugProgress) $msg .= "E#2496 read is now finished. $filename $eol";
            /*
	           $msg .= freewheelingeasy_kml_merge::updateTheJunctionsMileages();  //----------------------------------------------------------------   update the junctions milages
          if (self::$debugProgress) $msg .= "E#2497 calling displayIconsLines $filename $eol";
	           $msg .= freewheeling_kml_common::displayIconsLines($trailId, "read of $trailId made Database from which kml file was created");
            if (self::$debugProgress) $msg .= "E#2498 calling saveReport $filename $eol";
              $msg .= freewheeling_writeup::saveReport("kmlRead-$trailId-", $msg, "html");
             if (self::$debugProgress) $msg .= "E#2499 calling everyLineMatchStart $filename $eol";
           $msg .= freewheelingeasy_kml_merge::everyLineMatchStart();
*/
            if (self::$debugProgress) $msg .= "E#2488 mergeTrail $filename $eol";
            $msg .= freewheelingeasy_kml_merge::mergeTrail($trailId, $attrib);
        } // end try
        catch (Exception $ex) {
            $msg .= $ex->getMessage() . "$errorBeg  E#483 main upload $errorEnd";
        }
        try {
            if (self::$debugProgress) $msg .= "E#2487 calling saveReport $filename $eol";
            $msg .= freewheeling_writeup::saveReport("kmlReadMerge-$trailId-", $msg, "html");
            if (self::$debugProgress) $msg .= "E#2486 kml read function $filename $eol";
        } catch (Exception $ex) {
            $msg .= $ex->getMessage() . "$errorBeg  E#803 update junction mileages $errorEnd";
        }
        return $msg;
    } // end function kmlRead
    private static function highest($attr)
    {
        global $errorBeg, $errorEnd, $eol;
        $msg = "";
        try {
            $debugHighest = rrwParam::Boolean("debugHighest", $attr, false);
            if ($debugHighest) $msg .= "$eol start highest" . rrwUtil::print_r($attr, true, "attr") . rrwUtil::print_r($_POST, true, "POST") .  rrwUtil::print_r($_GET, true, "GET");
            $msg .= freeWheeling_edit_setGlobals::setGlobals("Kml Read Highest");
            $trailId = freeWheelParam::trail($attr);
            if ($debugHighest) $msg .= "#E491 extract the highest version of the trail $trailId $eol";
            if (empty($trailId))
                throw new Exception("$msg $errorBeg E#490 no trailId found while looking for rrwParam::String(trailId,$errorEnd");
            $versionCurrent = freewheeling_kml_common::findLatestTrailFileThisVersion($trailId, $msg);
            $msg .= "$eol $trailId highest = $versionCurrent ; $eol";
        } catch (Exception $ex) {
            $msg .= $ex->getMessage() . "$errorBeg  E#779 highest $errorEnd";
        }
        return $msg;
    }
    public static function newTrail($attr)
    {
        /*      update Trails table
            *      update regions table
            *      create a new kml file
            *      create a new trail
            *      update the list or regions.
            */
        global $errorBeg, $errorEnd, $eol;
        global $wpdbExtra;
        global $freewheelingeasy_kml_directory;
        $msg = "";
        try {
            $msg .= freeWheeling_edit_setGlobals::setGlobals("Kml Read New Trail");
            $trailId = rrwParam::String("trailId", $attr, "");
            if (empty($trailId)) {
                $msg .= "<form>
            <input type='text' name='trailId' value=''> trail id $eol
            <input type='text' name='trName' value=''> trail name $eol
            <input type='text' name='spur' value=''> Spur of  $eol
            <input type='hidden' name='task' value='new'> $eol
            <input type='submit' name='submit' value='submit'> $eol
               </form> ";
                return $msg;
            }
            $trName = rrwParam::String("trName", $attr, "");
            $spur = rrwParam::String("spur", $attr, "");
            $sqlTrail = "select trId from $wpdbExtra->trails where trId = '$trailId'";
            $trId = $wpdbExtra->get_var($sqlTrail);
            if (empty($trId)) {
                $sqlTrail = "insert into $wpdbExtra->trails (trId, trName, spurOf) values ('$trailId', '$trName','$spur')";
                $msg .= $wpdbExtra->query($sqlTrail);
            }
            $sqlRegion = "select trailId from $wpdbExtra->regions where trailId = '$trailId'";
            $region = $wpdbExtra->get_var($sqlRegion);
            if (empty($region)) {
                $sqlRegion = "insert into $wpdbExtra->regions (trailId, north, south, east, west, source)
                     values ('$trailId', 44, 37, -77, -80, 'newTrail')";
                $msg .= $wpdbExtra->query($sqlRegion) . $eol;
            }
            $filename = "$freewheelingeasy_kml_directory/$trailId" . "10.kml";
            $msg .= "Create a new trail file $filename $eol";
            $fp = fopen($filename, "w");
            fwrite($fp, "new trail $trailId");
            fclose($fp);
            $msg .= freewheelingEasy_kml_trailList::createHomePageSelections();  // rail drop down list
            $msg .= "Trail $trailId created, Go <a href='/edit-trail?trailId=$trailId' >Fill-in additional</a> information $eol";
            $msg .= "copy $filename to c:/1 and 1 Development/trails$eol";
            //         $msg .= self::
        } catch (Exception $ex) {
            $msg .= $ex->getMessage() . "$errorBeg  E#701 main upload $errorEnd";
        }
        return $msg;
    } // end function
    /**
     * Downloads and validates a KML file upload for trail data processing.
     *
     * This method handles the upload of KML files containing trail data from Google Earth,
     * validates the file, checks permissions, and prepares it for database processing.
     *
     * @param array $attr Attributes array (unused in current implementation)
     * @param string &$msgOutput Reference to output message string that gets populated with status messages
     *
     * @return string|null Returns the full path to the uploaded file on success, or null if no file was submitted
     *
     * @throws Exception When:
     *   - User lacks permission to upload (not from allowed IP and not logged in)
     *   - No file is submitted in the upload
     *   - File upload encounters errors
     *   - File already exists and override is not enabled
     *   - Uploaded version is older than current version without override
     *   - Trail ID is not found in database (unless creating new trails is enabled)
     *
     */
    public static function downloadKMLFile($attr, $newTrail, &$msgOutput)
    {
        global $errorBeg, $errorEnd, $eol;
        global $freewheelingeasy_kml_directory;
        global $wpdbExtra;
        global $freeWheelingEasy_ipHome;
        try {
            $ip = $_SERVER['REMOTE_ADDR'];
            if ($freeWheelingEasy_ipHome != $ip) {
                if (freeWheeling_edit_setGlobals::notAllowedToEdit("E#443 Attempt to read a kml file from $ip"))
                    throw new Exception("$errorBeg E#2485 doKmlRead permission has not been granted. Are you logged in? $errorEnd");
            }
            $msgOutput .= freeWheeling_edit_setGlobals::setGlobals("doKmlRead");
            $msgOutput .= "I#3499 Read in a KML file and loads the database
                    based on the data in the KML files $eol
                    Used on a <<trail>>NN.kml file that is the result of
                    working Google earth $eol ";
            // which button did they push
            if (1 != count($_FILES)) { // no file submitted
                $msgOutput .= " Select the <strong>KML</strong>file to upload $eol";
                return null; //    // indicate waiting for an upload
            }
            // $msg .= rrwUtil::print_r($_FILES, true, "files");
            //==================================================form submitted  upload
            if (!array_key_exists("fileToUpload", $_FILES)) {
                $msgOutput .= rrwUtil::print_r($_FILES, true, "files");
                throw new Exception("$msgOutput $errorBeg E#765 no file name  entered $errorEnd");
            }
            $filename = $_FILES['fileToUpload']['name'];
            if (empty($filename)) {
                throw new Exception("$msgOutput $errorBeg E#436 no file name  entered $errorEnd");
            }
            // file name entered
            if ($_FILES['fileToUpload']['error']) { //if  errors...
                $msgOutput .= '$errorBeg E#548 Oops!  Your upload triggered the following error:  ' .
                    $_FILES['fileToUpload']['error'] . $errorEnd;
                throw new Exception("$msgOutput");
            }
            //now is the time to modify the future file name and validate the file
            $new_file_name = strtolower(
                "$freewheelingeasy_kml_directory/$filename"
            ); //rename file
            $fp = @fopen($new_file_name, "r");
            $override = rrwParam::Boolean("override");
            if (is_resource($fp)) {
                fclose($fp);
                if (!$override)
                    throw new Exception("$errorBeg E#638 File $new_file_name already exist. overwrite not allowed $errorEnd");
            }
            $msgOutput .= "upload_dir - $freewheelingeasy_kml_directory - file is $new_file_name - filename is $filename $eol";
            list($trailId, $versionNew) = freewheeling_kml_read::extractTrailIdAndNumber($filename, $msg);
            $versionCurrent = freewheeling_kml_common::findLatestTrailFileThisVersion($trailId, $msgOutput);
            if ($versionCurrent > $versionNew && !$override) {
                throw new Exception("$msgOutput $errorBeg E#640 Current version
                                is $versionCurrent. Upload version is
                                $versionNew which is less than current. $errorEnd");
            }
            //move it to where we want it to be
            $msgOutput .= "upload_dir - $freewheelingeasy_kml_directory - file is $new_file_name $eol";
            move_uploaded_file($_FILES['fileToUpload']['tmp_name'], $new_file_name);
            $msgOutput .= "Congratulations!  Your file ($new_file_name) was uploaded,
                waiting to be processed
                <a href='https://edit.shaw-weil.com/download-a-kml-file/?trailId=$trailId ' >
                Download kml File</a> $eol ";
            // check for good trailId
            $sqlTrId = "select trId from $wpdbExtra->trails where trId= '$trailId'";
            $wpdbExtra->get_resultsA($sqlTrId);
            if (0 == $wpdbExtra->num_rows && $newTrail) {
                // new trail create wpdbExtra->trails entry
                $data = array(
                    "trName" => $trailId,
                    "description" => ' ',
                    "landingPage" => " ",
                    "trId" => $trailId,
                );
                $wpdbExtra->insert($wpdbExtra->trails, $data);
            } elseif (1 != $wpdbExtra->num_rows)
                throw new Exception("$msgOutput $errorBeg E#491 trail id = '$trailId' not in database $errorEnd $sqlTrId $eol");
            return $new_file_name;
        } catch (Exception $ex) {
            throw new Exception("$errorBeg " . $ex->getMessage() . "E#559 $errorEnd");
        }
    } // end do read kml
    /**
     * Finds the newest file in a given directory based on modification time.
     *
     * This function iterates through all files in the specified directory and
     * returns the filename of the file with the most recent modification time.
     * Directories and dot files (. and ..) are excluded from the search.
     *
     * @param string $dire The directory path to search for files
     * @return string The filename of the newest file, or empty string if no files found
     */
    /*
       private static function FindNewestFile($dire)
    {
        $maxTime = 0;
        $maxFile = "";  // no file found
        foreach(new DirectoryIterator($dire) as $fileInfo) {
            if($fileInfo->isDot() || $fileInfo->isDir())
                continue;
            $fileTime = $fileInfo->getMTime();
            if ($maxTime < $fileTime) {
                $maxTime = $fileTime;
                $maxFile = $fileInfo->getFilename();
            }
        } // end for
        return $maxFile;
    }
    */
    public static function KMLtoDatabase($filename)
    {
        global $errorBeg, $errorEnd, $eol;
        global $inside_data, $current_tag, $trailId;
        global $msgXMLprocess;
        global $wpdbExtra, $rrw_regions;
        $msg = "";
        try {
            $current_tag = " ";
            $inside_data = true;
            list($trailId, $number) = freewheeling_kml_read::extractTrailIdAndNumber($filename, $msg);
            $sqlName = "select trName from $wpdbExtra->trails where trId = '$trailId'";
            $trName = $wpdbExtra->get_var($sqlName);
            $msg .= "I#419 Processing trail $trName $eol ";
            $sqlRegion = "select * from $rrw_regions where trailId = '$trailId'";
            $recRegions = $wpdbExtra->get_resultsA($sqlRegion);
            if ($wpdbExtra->num_rows == 0) { // verify region exists
                $rec = freeWheeling_edit_setGlobals::trailInfoEmpty($trailId, $trName);
                unset($rec["sqlWhere"]);
                unset($rec["trname"]);      // case matches te $rec return
                unset($rec["trName"]);      // case matches te $rec return
                unset($rec["inddFileName"]);
                $rec["trailid"] = $trailId;
                $rec["trailId"] = $trailId;
                $msg .= rrwUtil::print_r($rec, true, "I#401 create the new region");
                $cnt = $wpdbExtra->insert($rrw_regions, $rec);
                if (false === $cnt)
                    $msg .= rrwUtil::print_r($rec, true, "$errorBeg E#720 insert failed $eol $errorEnd");
                $msg .= " I#394 Added $cnt rows to the database ";
            }
            //  if ( empty( $newTrail ) )$msg .= freewheeling_kml_common::displayIconsLines( $trailId, "database before input file " );
            $msg .= self::parseKmlToDatabase($trailId);
            //           $msg .= freewheeling_kml_common::displayIconsLines( $trailId, "processed input file input file Database loaded" );
        } catch (Exception $ex) {
            $msg .= "$errorBeg " . $ex->getMessage() . "E#635 $errorEnd";
        }
        return $msg;
    } // end function KMLtoDatabase
    /**
     * Extracts trail ID and number from a filename.
     *
     * This function parses a filename to extract a trail identifier and associated number.
     * It first attempts to find a 3-digit number at the end of the filename (excluding extension).
     * If not found, it looks for a 2-digit number. The remaining part becomes the trail ID.
     * If no valid numeric suffix is found, defaults to number 11 and empty trail ID.
     *
     * @param string $filename The full path or filename to parse
     * @return array An array containing two elements: [trail_id, number]
     *               - trail_id (string): The extracted trail identifier (without numeric suffix)
     *               - number (int|string): The extracted numeric suffix or 11 if none found
     */
    private static function extractTrailIdAndNumber($filename, &$msg)
    {
        global $errorBeg, $errorEnd, $eol;
        $debugExtNum = rrwParam::isDebugMode("extractTrailIdAndNumber");
        if (empty($filename))
            return array("", 11);
        $fileTemp = pathinfo($filename, PATHINFO_FILENAME); // get filename without extension
        $fileTemp = strtolower($fileTemp);
        $number = substr($fileTemp, -3, 3); // get the three ??? digit number
        if (is_numeric($number)) {
            // ends in three digit number
            $trailId = substr($fileTemp, 0, -3);
        } else {
            $number = substr($fileTemp, -2, 2); // get the two ?? digit number
            $trailId = substr($fileTemp, 0, -2);
        }
        if ($debugExtNum) $msg .=  "extracting trailId and number from '$filename', got trailId '$trailId', number '$number' $eol";
        if (!is_numeric($number)) {
            $number = 11;
            $trailId = "";
        }
        if ($debugExtNum) $msg .= "extracting trailId and number from $filename, got trailId $trailId, number $number $eol";
        if (empty($trailId)) {
            $msgErr = "throwing E#484 no trailId , number ($number) found in filename $filename, $eol";
            $msg .= rrwFormat::backtrace($msgErr);
            throw new Exception($msgErr);
        }
        return array($trailId, $number);
    }
    private static
    function contents($parser, $data)
    {
        global $eol, $inside_data, $current_tag, $accum, $out;
        global $itemName, $itemCoords, $itemStyle, $itemType, $itemId, $itemDesc;
        global $msgXMLprocess;
        $debugContent = false;
        if ($debugContent) $msgXMLprocess .= "processing content item of type $current_tag with '$data' $eol";
        switch ($current_tag) {
            case "COORDINATES":
                if ($inside_data)
                    $itemCoords .= $data; // need to concatenate data
                else
                    $itemCoords = $data;
                if ($debugContent) $msgXMLprocess .= "found coordinates of $data merged to $itemCoords $eol ";
                break;
            case "DESCRIPTION":
                if ($inside_data)
                    $itemDesc .= $data; // need to concatenate data
                else
                    $itemDesc = $data;
                break;
            case "NAME":
                if ($inside_data)
                    $itemName .= $data; // need to concatenate data
                else
                    $itemName = $data;
                if ($debugContent) $msgXMLprocess .= "found name of $data merged to $itemName $eol ";
                break;
            case "STYLEURL":
                if ($inside_data)
                    $itemStyle .= $data; // need to concatenate data
                else
                    $itemStyle = $data;
                break;
            default:
                if ($debugContent) $msgXMLprocess .= "did not process contect type $current_tag with '$data' $eol";
        }
        $inside_data = true;
    }
    private static
    function startElement($parser, $name, $attribs)
    {
        global $itemName, $itemCoords, $itemStyle, $itemType, $itemId, $itemDesc;
        global $elementCnt;
        global $eol, $inside_data, $current_tag, $accum, $out;
        global $msgXMLprocess;
        $debugXMLparserBegin = false;
        $elementCnt = $elementCnt + 1;
        switch ($name) {
            case "PLACEMARK":
                if ($debugXMLparserBegin) {
                    $msgXMLprocess .= "Processing element #$elementCnt of type $name $eol";
                }
                $itemName = "";
                $itemCoords = "";
                $itemStyle = "";
                $itemType = "";
                $itemDesc = "";
                if (array_key_exists("ID", $attribs)) {
                    $itemId = $attribs["ID"];
                    if (strncmp($itemId, "_icon", 5) == 0 || strncmp($itemId, "_line", 5) == 0) {
                        $itemId = substr($itemId, 5);
                    } else if (strncmp($itemId, "_", 1) == 0) {
                        $itemId = substr($itemId, 1);
                    } else if (strncmp($itemId, "x", 1) == 0) {
                        $itemId = substr($itemId, 1);
                    }
                } else {
                    $itemId = "";
                }
                #$msgXMLprocess .=  " found placemark at $elementCnt$eol";
                break;
            case "LINESTRING":
                if ($debugXMLparserBegin) {
                    $msgXMLprocess .= "Processing element #$elementCnt of type $name $eol";
                }
                $itemType = "LineString";
                break;
            case "POINT":
                if ($debugXMLparserBegin) {
                    $msgXMLprocess .= "Processing element #$elementCnt of type $name $eol";
                }
                $itemType = "Point";
                break;
            case "LINEARRING":
                if ($debugXMLparserBegin) {
                    $msgXMLprocess .= "Processing element #$elementCnt of type $name $eol";
                }
                $itemType = "LinearRing";
                break;
        }
        $current_tag = $name;
        $inside_data = false;
    } // end function startElement
    private static function endElement($parser, $name)
    {
        global $inside_data, $current_tag, $accum, $out;
        global $idIconMax, $defaultSource, $elementCnt, $pointsCnt, $linesCnt, $trailId;
        global $itemName, $itemCoords, $itemStyle, $itemType, $itemDesc, $itemId, $debug, $placeMarkCnt;
        global $wpdbExtra, $rrw_icons;
        global $debug;
        global $eol, $errorBeg, $errorEnd;
        global $latMax, $latMin, $lonMax, $lonMin, $boundaryUpdated; // gather the range of all points found
        global $msgXMLprocess;
        $msg = "";
        if ($name == "PLACEMARK") {
            $debugPlaceMark = false;
            if (false === strpos($itemName, "milepost 1.1"))
                $debugPoints = false;
            else
                $debugPoints = true;
            if (false === strpos($itemName, "LP stairway to park"))
                $debugLineString = false;
            else
                $debugLineString = true;
            $debugLinearRing = false;
            $placeMarkCnt = $placeMarkCnt + 1;
            if ($debugPlaceMark) $msgXMLprocess .= "endElement placeMark of line $name, $itemId $eol";
            $itemCoords = str_replace("\n", "", $itemCoords);
            $limits = freewheeling_kml_common::findMinMax($itemCoords); // limits on a plackMark
            $latMax = max($latMax, $limits["maxlat"]);
            $latMin = min($latMin, $limits["minlat"]);
            $lonMax = max($lonMax, $limits["maxlon"]);
            $lonMin = min($lonMin, $limits["minlon"]);
            if ($itemStyle == "") {
                $itemStyle = "Unknown";
            }
            $itemName = trim($itemName);
            //$msgXMLprocess .=  "Before $itemStyle, $itemName -- ";
            $itemStyle = freewheeling_kml_common::cleanStyleUrl($itemStyle, true); // also check/change itemname
            //$msgXMLprocess .=  "After $itemStyle, $itemName -- $eol ";
            if ($itemType == "LineString") {
                if ($debugLineString) {
                    $msgXMLprocess .= "I#408 endElement processing lineString $name, $itemId $eol";
                    $msgXMLprocess .= "$itemCoords $eol";
                }
                if (strncmp($itemName, "#", 1) == 0) {
                    $iii = strpos($itemName, " ");
                    $itemStyle = substr($itemName, 0, $iii);
                    $itemName = substr($itemName, $iii + 1);
                }
                if ($debugLineString) $msgXMLprocess .= "Found style $itemStyle in the description of $itemName$eol";
                $trapLoop = 0;
                $itemNameOriginal = $itemName;
                while (strlen($itemCoords) > 4000) {
                    $msgXMLprocess .= "e#405 $itemName length of string is over 4000 characters
							it is " . strlen($itemCoords) . $eol;
                    $trapLoop = $trapLoop + 1;
                    if ($trapLoop > 10) {
                        $msgXMLprocess .= "$errorBeg Too many times around split a line loop$errorEnd";
                        throw new Exception($msgXMLprocess);
                    }
                    //		$msgXMLprocess .= "$errorBeg $itemCoords$errorEnd";
                    $splitLength = strlen($itemCoords) / 2; // spli in middle
                    if (3800 < $splitLength)
                        $splitLength = 3800;
                    $ii = strpos($itemCoords, " ", $splitLength);
                    $jj = strpos($itemCoords, " ", $ii + 2);
                    $newCoords = substr($itemCoords, $ii); // duplicate end/begin
                    $itemCoords = substr($itemCoords, 0, $jj);
                    $msgXMLprocess .= "Split at $ii and $jj  $eol";
                    //         $msgXMLprocess .= "$errorBeg ---- Begin set is  $itemCoords $errorEnd";
                    //         $msgXMLprocess .= "$errorBeg ---- End set is $newCoords $errorEnd";
                    $itemName = "$itemNameOriginal $trapLoop";
                    $msgXMLprocess .= freewheeling_kml_read::writeLineToDatabase($debugPlaceMark);
                    //	adjust the left overs, so they get written after loop
                    $itemName = "$itemNameOriginal $trapLoop + 1";
                    $itemId = "";
                    $itemCoords = $newCoords;
                }
                if ($debugLineString)
                    $msgXMLprocess .= "Calling write line $itemName, $itemId $eol";
                $msgXMLprocess .= freewheeling_kml_read::writeLineToDatabase($debugPlaceMark);
                # end of the line string processing
            } elseif ($itemType == "Point") {
                $updates = array();
                if ($debugPoints) {
                    $msgXMLprocess .= "*******endElement processing point $itemName $eol";
                    $msgXMLprocess .= "$itemCoords, - $itemName, - $itemDesc $eol";
                }
                # need code for processing parking and other icons
                $pointsCnt = $pointsCnt + 1;
                if (strncmp($itemName, "new", 3) == 0) {
                    if ($debugPoints) $msgXMLprocess .= "new element $eol";
                    $itemId = "";
                    $itemName = trim(substr($itemName, 3));
                }
                #$msgXMLprocess .=  "Description before is " . htmlspecialchars(itemDesc,ENT_QUOTES). $eol;
                if ($ii = strpos($itemDesc, "!--GPS")) {
                    if ($ii > 2)
                        $itemDesc = substr($itemDesc, 0, $ii - 1);
                    else
                        $itemDesc = ' '; # has only the GPS data
                }
                // See if the previous item exists
                $sqlItemId = "select iconId from $wpdbExtra->icons where iconId = '$itemId'";
                $itemId = $wpdbExtra->get_var($sqlItemId);
                if (false === $itemId || empty($itemId) || $wpdbExtra->num_rows == 0) {
                    $itemId = "";   // no there, so cause a new one to be created
                }
                if ($itemId == "") {    // maybe the a just entered item
                    // -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- - # a new point
                    if ($itemName == "") {
                        $itemName = "$defaultSource $idIconMax";
                    }
                    $sqlExists = "select iconId from $wpdbExtra->icons where iconName = '$itemName' ";
                    $itemId = $wpdbExtra->get_var($sqlExists);
                    if (false === $itemId) {
                        $insert = array(
                            "iconName" => $itemName,
                            "source" => $defaultSource,
                            "ptdescription" => $itemDesc,
                            "trailId" => $trailId,
                        );
                        if (strpos($itemStyle, "flag") !== false)
                            $insert["iconStyle"] = 'flag.png';
                        else
                            $insert["iconStyle"] = 'park.png';
                        if ($debugPoints)
                            $msgXMLprocess .= rrwUtil::print_r($insert, true, "icon insert iconId $itemId");
                        $result = $wpdbExtra->insert($rrw_icons, $insert);
                        if ($result === false) {
                            $msgXMLprocess = rrwUtil::print_r($insert, true, "$errorBeg E#574 error on the insert $errorEnd");
                            return true; // onto te next item
                        }
                        $itemId = $wpdbExtra->insert_id;
                    }
                } // end new point
                // ----------------------------------------------- old and new points
                // assert itemid is now set
                if ($debugPoints) $msgXMLprocess .= "Processing item id #$itemId $eol";
                $updates = array(
                    "source" => $defaultSource,
                    "ptdescription" => $itemDesc,
                    "trailId" => $trailId,
                );
                $iconStyle = ""; // may or maynot be replaced
                // iconstyle is set by "make amenities",
                if (strpos($itemName, "trailhead") !== false) {
                    $updates["isTrailHead"] = true;
                }
                $coord = preg_split("/,/", $itemCoords);
                if (!is_array($coord)) {
                    throw new Exception("$errorBeg #729 something  wrong with the coordinates $itemCoords $errorEnd");
                }
                if (count($coord) < 1) {
                    throw new Exception("$errorBeg #740 something  wrong with the coordinates $itemCoords $errorEnd");
                }
                if (!array_key_exists(1, $coord)) {
                    $msgXMLprocess .= rrwUtil::print_r($coord, true, "coords");
                    $msgXMLprocess .= ("$errorBeg #744 something  wrong with the coordinates, no key= 1 -  $itemCoords $errorEnd");
                    return true;
                }
                $updates["latitude"] = round($coord[1], freeWheel::latRoundTo);
                $updates["longitude"] = round($coord[0], freeWheel::latRoundTo);
                if ($debugPoints)
                    $msgXMLprocess .= rrwUtil::print_r($updates, true, "I#420 icon updates iconId $itemId");
                //  ------------------------------------  lookfor and deal with mileposts
                $debugMilepost = false;
                if ($debugMilepost) $msgXMLprocess .= "I#641 looking for milepost in $itemName $eol";
                if (stripos($itemName, "milepost") !== false) {
                    if ($debugMilepost) $msgXMLprocess .= "I#625found milepost in $itemName $eol";
                    // it has a name of milepost
                    $ii = strrpos("$itemName", " ");        // find last blank
                    $mile = trim(substr($itemName, $ii));   // assume last word is the numeric milepost
                    if ($debugMilepost) $msgXMLprocess .= "I#634 found milepost in $itemName $mile $eol";
                    if (is_numeric($mile)) {
                        $updates["milepost"] = $mile;
                        $updates["iconstyle"] = "mpPic$mile.png";
                    } else {
                        $msg .= "$errorBeg E#645 $itemName continues 'milepost' but does not end in a number. $errorEnd";
                        $updates["milepost"] = null;
                        $updates["iconstyle"] = "flag.png";  // or maybe park.png
                    }
                    $sql = "select onMap from $wpdbExtra->icons where iconId = '$itemId' ";
                    $onMap = $wpdbExtra->get_var($sql);
                    if ($debugMilepost) $msgXMLprocess .= "I#659 found in databse in $itemName onMap = $onMap $eol";
                    if (empty($onMap)) {
                        $updates["onMap"] = "milepost";
                    }
                    if ($debugMilepost) $msgXMLprocess .= rrwUtil::print_r($updates, true, "i#469 milepost updates iconId $itemId");
                }   // end milepost
                // ------------------------------------  if onmap is forced.
                if ($debugPoints) $msgXMLprocess .= "I#654 switch on $itemName $eol";
                $updates["iconName"] = $itemName;    // save the changed name
                if (" " == substr($itemName, 2, 1)) {
                    $char = substr($itemName, 0, 2);
                    $updates["onMap"] = createLineText::lineInputPrefix($char);
                    $updates["iconstyle"] = createLineText::Icon2Display($char);;
                    $updates["iconName"] = trim(substr($itemName, 3));
                } else {
                    if (0 == $itemId) { # a new placeMack
                        if ($debugPoints) $msgXMLprocess .= "I#649 $itemName has iconId - $itemId $eol";
                        $updates["onMap"] = "launch";
                        $updates["iconstyle"] = 'flag.png';
                        $updates["iconName"] = trim($itemName);
                    } else {
                        if ($debugPoints) $msgXMLprocess .= "I#652 use previous$eol ";
                        # assume there  is no change;
                        unset($updates["onMap"]);
                        unset($updates["iconstyle"]);
                        unset($updates["iconName"]);
                    }
                } // end if third char is blank
                // ------------------------------------ do the update
                if ($debugPoints) $msgXMLprocess .= rrwUtil::print_r($updates, true, "I#492 icon updates iconId $itemId");
                if (is_null($itemId) || empty($itemId)) {
                    //must be a new item, first check for dupliictes.
                    $sqlDuplicateName = "select iconName from $wpdbExtra->icons where iconName = '$itemName' ";
                    $NumThereAlready = $wpdbExtra->get_var($sqlDuplicateName);
                    if ($wpdbExtra->num_rows > 0) {
                        // name already exists,make a new one
                        $sqlNew = "select max(iconId) + 1 from $wpdbExtra->icons ";
                        $maxId = $wpdbExtra->get_var($sqlNew);
                        $updates["iconNsme"] = "$itemName $maxId";
                    } else {
                        $updates["iconName"] = $itemName; // give it a the name name
                    }  // got valid name, now insert the new record
                    $cnt = $wpdbExtra->insert($rrw_icons, $updates);
                    if (false === $cnt) {
                        $msgXMLprocess .= rrwUtil::print_r($updates, true, "$errorBeg E#412 insert failed $errorEnd");
                    } else {
                        $msgXMLprocess .= "insert of icon $itemName worked, with cnt= $cnt $eol";
                    } //
                } else { // end if null
                    // it is an item that we previously had
                    if ("delete me" == $itemName || strpos($itemName, freeWheel::estimated_milepost) !== false) {
                        $wpdbExtra->delete($rrw_icons, array("iconId" => $itemId));
                    } else {
                        $cnt = $wpdbExtra->update($rrw_icons, $updates, array("iconId" => $itemId));
                        if (false === $cnt) {
                            $msgXMLprocess .= rrwUtil::print_r($updates, true, "E#497 the update of icon #$itemId failed, maybe point did not change $eol");
                        } // end 1 != cnt
                    } // end if delete me
                } // end if null
                // end of processing a point
            } // end of processing a point
            elseif ($itemType == "LinearRing") { // only the boundry element is a linear ring
                # update the points for the region box
                if ($debugLinearRing)
                    $msgXMLprocess .= "LinearRing: region coordinate matching:$itemCoords $eol
						Description: $itemDesc$eol";
                if ($ii = strpos($itemDesc, "<br />Zoom in"))
                    $itemDesc = substr($itemDesc, 0, $ii);
                if ($debugLinearRing) $msgXMLprocess .= "LinearRing: Description: $itemDesc$eol";
                $updateTrail = array(
                    "description" => $itemDesc,
                    "trName" => $itemName,
                );
                $updateId = array("trId" => $trailId);
                if ($debugLinearRing) {
                    $msgXMLprocess .= rrwUtil::print_r($updateTrail, true, "update trail") . rrwUtil::print_r($updateId, true, "update trail id");
                    $msgXMLprocess .= "Result of the trail update = " . $wpdbExtra->update($wpdbExtra->trails, $updateTrail, $updateId) . $eol;
                }
                $range = freewheeling_kml_common::findMinMax($itemCoords); // limits of the outline area
                if ($debugLinearRing) {
                    $msgXMLprocess .= rrwUtil::print_r($range, true, "debug linear Ring");
                }
                if ($range["latStart"] != $range["latEnd"] || $range["lngStart"] != $range["lngEnd"]) {
                    $msgXMLprocess .= "$eol  LinearRing: before the append: length=" . strlen($itemCoords) . "$eol$itemCoords$eol";
                    $itemCoords = $itemCoords . " " . $range["lngStart"] . "," . $range["latStart"] . ",0";
                    $msgXMLprocess .= "$eol  LinearRing: after the append: length=" . strlen($itemCoords) . "$eol $itemCoords $eol";
                } else {
                    if ($debugLinearRing) $msgXMLprocess .= "LinearRing: Points match so no append neccesary$eol";
                }
                if ($debugLinearRing) {
                    $msgXMLprocess .= "$eol  LinearRing:" . strlen($itemCoords) . "$eol$itemCoords$eol";
                    $msgXMLprocess .= rrwUtil::print_r($range, true, "range");
                    $msgXMLprocess .= "$eol LinearRing range:" . $range["maxlat"] . ", " . $range["minlat"] . ", " .
                        $range["minlon"] . ", " . $range["maxlon"] . $eol;
                }
                if ($debugLinearRing) $msgXMLprocess .=  "update the  regions calling UpdateRegionBounds $eol";
                $msgXMLprocess .= freewheeling_kml_read::UpdateRegionBounds($range, $itemCoords, $itemStyle, $defaultSource, $trailId);
                $boundaryUpdated = true;
            } else {
                $msgXMLprocess .= "$errorBeg Unknown line type of $itemType at PlaceMark count
						$placeMarkCnt E#432 $errorEnd";
                throw new Exception($msgXMLprocess);
            } //
            $current_tag = '';
            $inside_data = false;
            return true;
        } elseif ($name = 'KML') {
            // ignore irrelevant tag
        } else { // end of placemark
            $itemCoords = str_replace("\n", "", $itemCoords);
            $limits = freewheeling_kml_common::findMinMax($itemCoords); // limits on a plackMark
            $msgXMLprocess .= rrwUtil::print_r($limits, true, "$errorBeg E#438 in endElement:  $name - $itemId " .
                "not a placeMark of type point, lineString, or LinearRing $errorEnd");
        }
        return true;
    } // end of endElement
    private static function UpdateRegionBounds($range, $itemCoords, $itemStyle, $source, $trailId)
    {
        global $wpdbExtra, $rrw_regions;
        global $eol, $errorBeg, $errorEnd;
        $debugSetRegion = false;
        $msg = "";
        if ($debugSetRegion) $msg .= "updateing regions boundry coords$eol";
        $sqlLabel = "select labeleast from $rrw_regions where trailId = '$trailId' ";
        $labeleast = $wpdbExtra->get_var($sqlLabel);
        if ($debugSetRegion) $msg .= "label east is $labeleast $eol";
        $updateRegion = array(
            "boundry" => $itemCoords,
            "bndmapstyle" => $itemStyle,
            "source" => $source,
            "north" => $range["maxlat"],
            "south" => $range["minlat"],
            "west" => $range["minlon"],
            "east" => $range["maxlon"],
        );
        if ($labeleast == -70 || empty($labeleast) || $labeleast = -180) {
            if ($debugSetRegion) $msg .= "update the labels $eol";
            $updateRegion["labeleast"] = $range["maxlon"] / 2 + $range["maxlon"] / 2;
            $updateRegion["labelnorth"] = $range["maxlat"] / 2 + $range["maxlat"] / 2;
        }
        $updatekey = array("trailId" => $trailId);
        if ($debugSetRegion) {
            $msg .= rrwUtil::print_r($updateRegion, true, "region update");
            $msg .= rrwUtil::print_r($updatekey, true, "region update");
        }
        $wpdbExtra->update($rrw_regions, $updateRegion, $updatekey);
        return $msg;
    }
    /**
     * Writes a line entry to the database, either inserting a new record or updating an existing one.
     *
     * This function handles the logic for saving a line (such as a trail or path) to the database.
     * It checks for duplicate names, compresses coordinates, updates min/max values, and manages
     * unique IDs. If the line name is "delete me", it deletes the corresponding record.
     *
     *
     * @return string Message containing debug information or error details.
     * @throws Exception If coordinate compression fails or database operations fail.
     */
    public static
    function writeLineToDatabase($debugWriteLine = false)
    {
        global $eol, $errorBeg, $errorEnd, $inside_data, $current_tag, $accum, $out;
        global $idLineMax, $idIconMax, $defaultSource, $elementCnt, $pointsCnt, $linesCnt, $trailId;
        global $itemName, $itemCoords, $itemStyle, $itemType, $itemDesc, $itemId, $debug;
        global $wpdbExtra;
        $msg = "";
        $debugWriteLine = false;
        if ($itemName == "") {
            $itemName = "$defaultSource $itemId";
        }
        if ($itemName == "delete me") {
            $wpdbExtra->delete($wpdbExtra->lines, array('lineId' => $itemId));
            return $msg;
        }
        if ($debugWriteLine) {
            $msg .= "writeLineToDatabasebase:  $itemId $itemName $eol";
            $msg .= "=================== coords before $eol $itemCoords$eol ================== $eol";
        }
        $coordsCompressed = freewheeling_kml_common::CompressCoords($itemCoords, $msg);
        if ($debugWriteLine) {
            $msg .= "==================== coords after $eol $coordsCompressed $eol ============ $eol";
            $msg .= "Style $itemStyle, $itemName $eol";
        }
        if (strlen($coordsCompressed) < 30) {
            $msg .= "$errorBeg E#476 Attempting to out a one coordinate line of $itemName #$itemId
				$eol, $coordsCompressed, $errorEnd";
            return $msg;
        }
        $updateLine = array(
            "lineName" => $itemName,
            "pointList" => $coordsCompressed,
            "mapstyle" => $itemStyle,
            "source" => $defaultSource,
            "trailId" => $trailId,
        );
        $results2 = freewheeling_kml_common::updateMinMaxOfLine($coordsCompressed, $msg);
        if (empty($results2)) {
            $msg .= "$errorBeg E#486 freewheeling_kml_common::updateMinMaxOfLine failed $errorEnd";
            throw new Exception($msg);
        }
        $updateLine = array_merge($updateLine, $results2);
        $linesCnt = $linesCnt + 1;
        if ($debugWriteLine) $msg .= "itemId is $itemId, idLineMax is $idLineMax $eol";
        if ($itemId == "") { # a new item
            $idLineMax = $idLineMax + 1; # get next number
            $itemId = $idLineMax;
        }
        $sqlExists = "select lineId from $wpdbExtra->lines where lineId = '$itemId' ";
        if ($debugWriteLine) $msg .= "Checking for exists: $sqlExists $eol";
        $wpdbExtra->get_resultsA($sqlExists);
        if (0 == $wpdbExtra->num_rows) {
            //  new item
            $sqlExists = "select lineName from $wpdbExtra->lines where lineName = '$itemName' ";
            if ($debugWriteLine) $msg .= "Checking for exists: $sqlExists $eol";
            $wpdbExtra->get_resultsA($sqlExists);
            if (0 != $wpdbExtra->num_rows) // if duplicate name, change it
                $updateLine['lineName'] = $itemName . "- Duplicate - " . time();
            if ($debugWriteLine) $msg .= "New item with id =$itemId $eol ";
            $cnt = $wpdbExtra->insert($wpdbExtra->lines, $updateLine);
            if (1 != $cnt || false === $cnt) {
                throw new Exception("$errorBeg $msg E#437 did insert when should of done update $errorEnd
              cnt is $cnt, sqlExists =$sqlExists $eol ");
                //              return $msg;
            }
        } else {
            if ($debugWriteLine) $msg .= "Old item with id =$itemId $eol ";
            $key["lineId"] = $itemId;
            $wpdbExtra->update($wpdbExtra->lines, $updateLine, $key);
        }
        if ($debugWriteLine) $msg .= rrwUtil::print_r($updateLine, true, "line data to the database");
        if (rrwUtil::isTimeUp(freewheelingEasy_fix_Class::$checkLoopingTimeOut)) {
            $msgTemp = "I#472 writeLineToDatabase: time is up, so stopping processing of $itemName $eol";
            throw new Exception($msgTemp);
        }
        return $msg;
    } // end of writeLineToDatabase
    private static function parseKmlToDatabase($trailId)
    {
        global $idLineMax, $idIconMax, $defaultSource, $elementCnt, $pointsCnt, $linesCnt, $placeMarkCnt;
        global $wpdbExtra, $rrw_icons;
        global $debug;
        global $msgXMLprocess;
        global $eol, $errorBeg, $errorEnd;
        global $inside_data, $current_tag;
        global $latMax, $latMin, $lonMax, $lonMin, $boundaryUpdated; // gather the range of all points found
        /*
         *	assume		$trailId is in the trails and regions database
         */
        $debug = rrwParam::Boolean("debug");
        $msg = "";
        try {
            $msg .= "I#381 parseKmlToDatabase: with $trailId ... ";
            $debugXML = rrwParam::Boolean("debugxml");
            $current_tag = " ";
            $inside_data = false;
            $fileName = freewheeling_kml_common::findLatestTrailFile($trailId);
            $msg .= "working on file $fileName $eol";
            if (!($fp = fopen($fileName, "r"))) {
                throw new Exception("$msg $errorBeg E#433 could not open XML input  $fileName $errorEnd");
            }
            $defaultSource = str_replace(".kml", "", $fileName); // remove the KML
            $ii = strrpos($fileName, "/");
            if ($ii > 1)
                $defaultSource = substr($defaultSource, $ii + 1); // remove the directory
            if ($debug) $msg .= "I#414 source file name is $defaultSource $eol";
            //	openDatabase();
            $sql = " select max(lineId) as maxId from $wpdbExtra->lines"; # get the next line number
            $idLineMax = $wpdbExtra->get_var($sql);
            $sql = " select max(iconId) as maxId from $rrw_icons"; # get the next icon number
            $idIconMax = $wpdbExtra->get_var($sql);
            if ($debug) $msg .= "parseKmlToDatabase:idLineMax:idIconMax  $idLineMax, $idIconMax $eol";
            $elementCnt = 0;
            $pointsCnt = 0;
            $linesCnt = 0;
            $placeMarkCnt = 0;
            $latMax = -180;
            $latMin = 180;
            $lonMax = -180;
            $lonMin = 180;
            $debugBoundry = false;
            $boundaryUpdated = false;
            $sqlFlagLines = "update $wpdbExtra->lines set lengthMeters = -1 where trailId = '$trailId' ";
            $wpdbExtra->query($sqlFlagLines);
            if ($debugBoundry) $msg .= "boundaryUpdated:beforeParse: $boundaryUpdated **$eol";
            if ($debug) $msg .= "About to do the parse $eol";
            $xml_parser = xml_parser_create();
            xml_set_element_handler(
                $xml_parser,
                "freewheeling_kml_read::startElement",
                "freewheeling_kml_read::endElement"
            );
            xml_set_character_data_handler($xml_parser, "freewheeling_kml_read::contents");
            while ($data = fread($fp, 4096)) {
                if (!xml_parse($xml_parser, $data, feof($fp))) {
                    die(sprintf(
                        "E#461 XML error: %s at line %d",
                        xml_error_string(xml_get_error_code($xml_parser)),
                        xml_get_current_line_number($xml_parser)
                    ));
                }
            }
            fclose($fp);
            $msgXMLprocess .= "I#2740 finished parsing the KML file $fileName  at " . date("Y-m-d G:i:s") . $eol;
            if ($debugXML) $msg .= $msgXMLprocess; // message from the parser routine
            $msgXMLprocess = "I#2741 xmlParserMessage already moved to msg at " . date("Y-m-d G:i:s") . $eol;
            $msg .= "I#2743 parse finished, now deal with missing boundary lines $eol";
            if (!$boundaryUpdated) {
                // no boundry written, make one
                $north = $latMax;
                $south = $latMin;
                $east = $lonMin;
                $west = $lonMax;
                $itemCoords = "$north,$east,0 $south,$east,0 $south,$west,0 $north,$west,0 $north,$east,0";
                $range = freewheeling_kml_common::findMinMax($itemCoords); // limits of the region
                $msg .= freewheeling_kml_read::UpdateRegionBounds(
                    $range,
                    $itemCoords,
                    "#visbleRegion",
                    $defaultSource,
                    $trailId
                );
            }
            $msg .= self::deleteMeRecords();
            $sql = "select count(*) from $wpdbExtra->lines where trailId = '$trailId' ";
            $cntLines = $wpdbExtra->get_var($sql);
            $sql = "select count(*) from $rrw_icons where trailId = '$trailId'";
            $cnticons = $wpdbExtra->get_var($sql);
            $msg .= "<strong>I#374 xmlParser finished - Created/Updated $cntLines lines, $cnticons places in the database
				from $fileName</strong>$eol";
            return $msg;
        } catch (Exception $ex) {
            $msg .= "$errorBeg " . $ex->getMessage() . "E#489 $errorEnd";
            return $msg;
        }
    } // end kml2database
    public static
    function deleteMeRecords()
    {
        global $wpdbExtra, $rrw_icons;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $debugDeleteme = rrwParam::Boolean("debugdeleteme");
        if ($debugDeleteme) $msg .= "process ========== 'delete me'request";
        $cnt = $wpdbExtra->delete("$wpdbExtra->lines", array("lineName" => "delete me"));
        $msg .= "I#630 deleted $cnt lines as requested. $eol";
        $cnt = $wpdbExtra->delete("$rrw_icons", array("iconName" => "delete me"));
        $msg .= "I#643 deleted $cnt icons as requested.  $eol";
        $cnt = $wpdbExtra->delete($wpdbExtra->lines, array("lengthMeters" => -1));
        $msg .= "I#644 deleted $cnt lines not in KML.  $eol";
        return $msg;
    }
    /*
    public static function assignIconLineIdAlIcons($trailId)
    {
        // goe each icon, find the nearest line
        //      assign the line id to that line
        //      create a sort based on the lines sort order, and the icons position on the line
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        global $lat; // just used to get the count.
        $msg = "";
        $debugAssign = false;
        $msg .= "assign IconLineId for all line $eol";
        //$sqlWhereLine = $wpdbExtra->sqlWhereLines($trailId);
        // wipe out existing relation ships.
        $sql = "update $wpdbExtra->icons set iconLineId = 0,sort = 0 where " . $wpdbExtra->sqlWhereIcons($trailId);
        $cntIcons = $wpdbExtra->query($sql);
        // build the lat array
        $msg .= freewheeling_kml_splitLine::BuildTableOfPointsALongLines($trailId);
        $msg .= "I#786 there are " . count($lat) . " points along the $trailId $eol ";
        // -------------------------------------------- work through each icon point
        $sqlPoints = "select iconName, iconId, latitude, longitude, milepost, onMap
                    from $wpdbExtra->icons where " . $wpdbExtra->sqlWhereIcons($trailId);
        $recPoints = $wpdbExtra->get_resultsA($sqlPoints);
        $msg .= "I#302 there are " . $wpdbExtra->num_rows . " milepost, launch
				and break line points $eol";
        $msg .= FreewheelingEditDistance::setMilepostPrefix($trailId);      // set the prefix for the trail
        $msg .= freeWheelingClean::checkOrImposeMilepostIconStyle();        // update all the milepost icons to be a png file
        foreach ($recPoints as $recPoint) {
            $latitude = $recPoint["latitude"];
            $longitude = $recPoint["longitude"];
            $iconName = $recPoint["iconName"];
            $iconId = $recPoint["iconId"];
            // find the matching line -- Just looking for the lineId, Sequence
            $result = freewheeling_kml_splitLine::GivenLatLonFindNearestLatLonLinePoint($latitude, $longitude);
            if ($debugAssign) $msg .= $result["msg"];
            // if no nerest line. assume that above set matchPoint to -1, lineId to 0, and sequence to 0
            $lineId = $result["lineId"];
            $lineSequence = $result["sequence"];
            $sort = $lineSequence  . "-" . $result["matchPoint"];   // order of icons along the line
            $sqlSave = "Update  $wpdbExtra->icons set iconLineId = $lineId, sort = '$sort'
						where iconId = $iconId";
            if ($debugAssign) $msg .= "$sqlSave $eol";
            $cnt = $wpdbExtra->query($sqlSave);
            if ($cnt != 1) {
                $msg .= "$errorBeg E#441 Updated $cnt records, expected one
									for icon $iconName with $iconId $sqlSave$errorEnd";
                $msg .= rrwUtil::print_r($result, true, "result");
            }
        }
        return $msg;
    } //end function  assignIconLineIdAlIcons
    */
} //	end class
