<?php
class createLineText
{
    private static $surface = array();
    private static $lineInputPrefix = array();

    public static function createZZDataFiles()
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        try {
            $msg = "";
            $debugCounty = false;
            error_reporting(E_ALL);
            $msg .= freeWheeling_edit_setGlobals::setGlobals("createZZDataFiles");
            //   $msg .= self::createLinesTrail2Biz();
            // make the zz-line.txt file with all the lines
            $msg .= self::createZZLineTrails();
            $msg .= freewheeling_makeTOC::makeTocFiles();

            $msg .= self::CreateLinesCounty($debugCounty);
            $msg .= $eol;
        } catch (Exception $ex) {
            $msg .= "$errorBeg E#460 " . $ex->getMessage() . " $errorEnd";
        }
        return $msg;
    }
    public static function createZZLineTrails()
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        try {
            $msg = "";

            $sqlLines = " select trailId, trname, lineName, lineId,
                        routes, mapstyle, pointList
                        from $wpdbExtra->trailLines
      					where not trailId = 'county' and not trailId like 'road%'
                        order by trailId, sequence ";
            $fileName = "zz-lines.txt";
            $msg .= self::createLinesTxtFile($sqlLines, $fileName);
        } catch (Exception $ex) {
            $msg .= "$errorBeg E#448 " . $ex->getMessage() . " $errorEnd";
            throw new Exception($msg);
        }
        return $msg;
    }
    static private     function CreateLinesCounty($debugCounty)
    {
        global $eol, $errorBeg, $errorEnd;
        global $freewheeling_prebuilt_dire, $freewheeling_pagesPreBuiltUrl;
        $msg = "";
        $debugCounty = false;
        /*
         *  white square and obscure square go at the front of the county file
         */
        // now sdd the county lines, the obscure area,
        $left = -90;
        $right = -60;
        $top = 50;
        $bottom = 30;
        $points = "Points: $left,$top,1000, $left,$bottom,1000 $right,$bottom,1000 $right,$top,1000 $left,$top,1000";

        $backgrnd = "Desc: County lines <br />(county
Style: #ffffffcou05
Range: -77., 43.0021058, -77.9900382, 38.0
Routes: county, eliminate_google_map
$points
";
        //points: -83,43,1000 -83,38,1000 -77,38,1000 -77,43,1000 -83,43,1000
        $outLines = self::firstLine("data/zz_county.txt");
        $outLines .= str_replace("County", "White Square", $backgrnd);
        $obscure = str_replace("cou05", "obs05", $backgrnd);
        $obscure = str_replace("county", "obscure", $obscure);
        $obscure = str_replace("County", "Obscure Square", $obscure);
        $outLines .= $obscure;
        if ($debugCounty) $msg .= ", &nbsp;  Added 8 lines for white, obsure maps ";
        $outLines .= $backgrnd;
        $kk = 0;
        $ii = 0;
        $lineCnt = 0;
        $color = "#f2f2f2"; //	$color = "#cce5ff";	// outside counties
        $xml = simplexml_load_file("$freewheeling_prebuilt_dire/county10.kml");
        foreach ($xml->Document as $xmlDocument) {
            if ($debugCounty) $msg .= " &nbsp; <strong>Source document title - " . $xmlDocument->name . "</strong> %eol";
            //				dump_r(xmlDocument);
            //		break;
            foreach ($xmlDocument->Folder as $xmlFloder) {
                if ($debugCounty) $msg .= "&nbsp;  &nbsp; <strong>" . $xmlFloder->name . "</strong>";
                //				dump_r( $xmlFloder );
                foreach ($xmlFloder->Placemark as $xmlPlacemark) {
                    $kk++;
                    if ($kk > 100)
                        $color = "#f2f2f2";
                    $county = $xmlPlacemark[0]->name;
                    $county = str_replace("<at><openparen>", "", $county);
                    $county = str_replace("<closeparen>", "", $county);
                    $county = str_replace("<", "", $county);
                    $county = str_replace("/>", "", $county);
                    $county = trim($county) . " <br/>(County line)";
                    if ($debugCounty) $msg .= " $kk -- $county,";
                    //					dump_r ( $xmlPlacemark[0]->Polygon->outerBoundaryIs->LinearRing);
                    $coords = $xmlPlacemark[0]->Polygon->outerBoundaryIs->LinearRing->coordinates;
                    $coords = trim($coords);
                    $outLines .= "Desc: $county <br /> (County Lines)\n";
                    $outLines .= "Style: $color" . "cou01\n";
                    $outLines .= "Range: -77., 43.0021058, -77.9900382, 40.0\n";
                    $outLines .= "Routes: county, eliminate_google_map \n";
                    $outLines .= "Points: $coords\n";
                    $lineCnt++;
                }
            }
        }
        if ($debugCounty) $msg .= ", Added $lineCnt lines for county ";
        $msg .= freewheeling_Writeup::saveFile("data", "zz_county.txt", $outLines);
        return $msg;
    }
    private static
    function firstLine($title)
    {
        return "Title: $title\n";
    }
    public static
    function createLinesTrail2Biz($bizId = "")
    {
        /*  if no bizId then create entire file
         *   if biz id then add that business at the front of the file
         */
        // make the trail to business txt file
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        global $freewheeling_prebuilt_dire;

        $msg = "";
        if (empty($bizId))
            $sqlwherExtra = "";
        else
            $sqlwherExtra = " and bizId= '$bizId'";
        $sqlBiz = " select '' trailId,
								concat(trailmilepostPrefix, ' ', trailmilepost) trname,
								bizname lineName,
                                bizId lineId,
								concat(trailId,',',bizName,',',bizid) routes,
								'#google' mapstyle,
								trail2bizroute pointList
								from $wpdbExtra->businessServices
                                left join $wpdbExtra->access on bizId = accBizId
						where not trim(trail2bizroute)  = '' $sqlwherExtra
						and bizUsed > 0 and p = 0
						order by trailMilepostPrefix, trailMilepost ";
        //					concat('enc:', trail2bizroute) pointList
        if (false) $msg .= "$sqlBiz $eol";
        $fileName = "xx_trail2biz.txt"; //  $fileName = "zz_trail2biz.txt";//  file is way too big
        if (empty($bizId)) {
            $msg .= "$fileName - $sqlBiz";
            $msg .= self::createLinesTxtFile($sqlBiz, $fileName);
        } else {
            throw new Exception("$errorBeg e#697 CODE OF PREAPPENDING ONE BIZ  NOT IMPLEMENTED $errorEnd");
            $fileNameFull = "$freewheeling_prebuilt_dire/$fileName";
            $fpLines = fopen($fileNameFull, "r");
            $recLines = $wpdbExtra->get_resultsA($sqlBiz);
            if ($wpdbExtra->num_rows != 1)
                throw new Exception("$msg $errorBeg E#298 looking foe one business, but found " . $wpdbExtra->num_rows) . "
                                        $errorEnd $sqlBiz $eol";
            $outline = self::oneItemForLineWork($recLines[0], $msg);
            fwrite($fpLines, $outline);
            fclose($fpLines);
            $msg .= "Prepended one business to  $eol";
        }
        return "$msg, ";
    }
    public static
    function createLinesTxtFile($sql, $outFile, $displayParams = false)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        try {
            $msg = "";
            if ($displayParams) $msg .= "createLinesTxtFile - $outFile - $sql $eol";
            $outlines = self::firstline($outFile);
            $reclines = $wpdbExtra->get_resultsA($sql);
            $cnt = 0;
            foreach ($reclines as $recLine) {
                $cnt++;
                $outline = self::oneItemForLineWork($recLine, $msg);
                if (strlen($outline) > 35000) {
                    $msg .= "$errorBeg E#456 route business to line too long: " . strlen($outline) . $eol .
                        substr($outline, 0, 200) . "$errorEnd $sql $eol";
                    $msg .= "$errorBeg E#457 route outlines too long, so far $cnt entries of " .
                        $wpdbExtra->num_rows . " rows/$wpdbExtra->num_rows $errorEnd";
                    break;
                }
                $outlines .= $outline;
            }
            $msg .= "$eol &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;" .
                freewheeling_Writeup::saveFileWithCompare("data", $outFile, $outlines);
            if ($cnt < 900 || 1 == $cnt) {
                //              $msg .= "$errorBeg E#665 process only $cnt lines, expected > 900 $outFile $errorEnd $sql $eol";
            }
            return $msg;
        } catch (Exception $ex) {
            return "$msg Create lines_txt_file: " . $ex->getMessage();
        }
    }
    private static function oneItemForLineWork($recLine, &$outputMsg): string
    {
        global $eol, $errorBeg, $errorEnd;
        $debugLongRoutes = false;
        $lineName = $recLine["lineName"];
        $lineId = $recLine["lineId"];
        if (strpos($lineName, "debugEnabler") === false)
            $debugLine = false;
        else
            $debugLine = true;
        $trailId = $recLine["trailId"];
        $routes = $recLine["routes"];
        $routes .= ", $trailId";
        $style = $recLine["mapstyle"];
        if ($debugLine) $outputMsg .= "$eol$style, $lineName";
        $trName = $recLine["trname"];
        $NotSet = "not set";
        try {
            $styleOut = self::LineColor($style) .
                self::lineType($style, $NotSet) .
                self::lineWeight($style, $NotSet);
            $desc = freewheelingeasy_calculateMP::getSurfaceDescriptions($style);
        } catch (Exception $ex) {
            $outputMsg .= "$errorBeg problems with style '$style' on line $trName " . $ex->getMessage() . $errorEnd;
            // just keep going using the invalid style name
            $styleOut = self::LineColor($style) .
                self::lineType($NotSet, $NotSet) .
                self::lineWeight($NotSet, $NotSet);
            $desc = freewheelingeasy_calculateMP::getSurfaceDescriptions($NotSet);
        }
        $desc = "$trName<br />$desc<br />" . $lineName;
        $coords = $recLine["pointList"];
        $range =freewheeling_kml_common::findMinMax($coords); //biz route
        if (false === $range) {
            $outputMsg .= "$errorBeg E#264freewheeling_kml_common::findMinMax failed on $lineName $errorEnd";
            $outputMsg .= "cord list is $coords $eol";
            return $outputMsg;
        }
        $bounds = $range["maxlon"] . ", " . $range["maxlat"] . ", " .
            $range["minlon"] . ", " . $range["minlat"];
        $outputMsg .= $range["msg"];
        if (strlen($coords) > 4090) {
            $maplink = freeWheelFormat::EditLineLink($lineId, $lineName, $coords);
            if ($debugLongRoutes) $outputMsg .= sprintf("%7d %s $eol", strlen($coords), $maplink);
            $iiSpace = strrpos($coords, " ", -3);
            $endCoords = substr($coords, $iiSpace);
            $coords = substr($coords, 0, 4070);
            $iiSpace = strrpos($coords, " ");
            $coords = substr($coords, 0, $iiSpace) . $endCoords;
        }
        $desc = strtolower($desc);
        $outline = "Desc: $desc \nStyle: $styleOut\nRange: $bounds\nRoutes: $routes\nPoints: $coords\n";
        return $outline;
    } // end function oneItemForLineWork

    /**
     * Sets the surface data by fetching records from the database and populating the static surface array.
     *
     * This method retrieves surface data from two database tables (`surfaces` and `iconOnMap`) using a UNION query.
     * It then processes each record and stores relevant information in the static `$surface` array and `$lineInputPrefix` array.
     *
     * Global Variables:
     * - $wpdbExtra: The global database object used for executing queries.
     *
     * Static Properties:
     * - self::$surface: An array that stores surface data indexed by surface code.
     * - self::$lineInputPrefix: An array that maps line input prefixes to surface codes.
     *
     * Database Fields:
     * - code: The unique code for the surface.
     * - googleType: The type of road or trail as defined by Google.
     * - freeWheelingIcon: The prefix used for line input.
     * - codeDescription: The description of the surface code.
     * - codeCSS: The CSS color code for the surface.
     * - GoogleIcon: The icon associated with the surface.
     *
     * Debugging:
     * - If the debug block is enabled (currently set to `false`), it prints the contents of the `$surface` and `$lineInputPrefix` arrays.
     *
     * @global object $wpdbExtra The global database object.
     */
    private static function buildSurfaceArray()
    {
        global $wpdbExtra;
        if (0 == count(self::$surface)) {
            $sqlSurfaces = "select * from $wpdbExtra->codesSurface ";
            $recSurfaces = $wpdbExtra->get_resultsA($sqlSurfaces);
            foreach ($recSurfaces as $recSurface) {
                $item = array(
                    "code" => $recSurface["code"],
                    "roadVsTrail" => $recSurface["classification"],
                    "lineInputPrefix" => $recSurface["inputCode"],
                    "description" => $recSurface["codeDescription"],
                    "color" => $recSurface["codeCSS"],
                    "icon" => $recSurface["lineDisplay"],
                );
                self::$surface[$recSurface["code"]] = $item;
                self::$lineInputPrefix[$recSurface["inputCode"]] = $recSurface["code"];
            } // end foreach recSurfaces
            if (false) {
                print rrwUtil::print_r(self::$surface, true, "surface");
                print rrwUtil::print_r(self::$lineInputPrefix, true, "lineInputPrefix");
            } // end if false
        } // end if 0 == count
    }
    public static function lineInputPrefix($prefix)
    {
        global $eol, $errorBeg, $errorEnd;
        static $cntLoop = 0;
        $cntLoop++;
        if ($cntLoop > 10) // should never happen
            return "error E#268 too many loops";
        self::buildSurfaceArray();
        $prefix = trim($prefix);
        if ("ST" == $prefix || "St" == $prefix)
            return "LP";    // deal with St George and churches
        if (!array_key_exists($prefix, self::$lineInputPrefix)) {
            //   print rrwFormat::backtrace("$errorBeg E#261 style '$prefix' not found in lineInputPrefix $errorEnd");
            return self::$lineInputPrefix["TU"];    // no warning
        }
        return self::$lineInputPrefix[trim($prefix)];
    } // end function

    private static function LineColor($style)
    {
        global $eol, $errorBeg, $errorEnd;
        self::buildSurfaceArray();
        $style = trim($style);
        if (!array_key_exists($style, self::$surface)) {
            $msgErr = " E#262 style $style not found in surface ";
            $trace = rrwFormat::backtrace("262 trace");
            $iiLine = strpos($trace, "[lineId]");
            print "$iiLine *******************$eol $trace $eol ";
            print " extractfrom '" . htmlspecialchars(substr($trace, $iiLine, 30)) . "' $eol ";
            $lineId = substr($trace, $iiLine + 12, 4);
            $msgErr .= freewheelFormat::EditLineLink($lineId);
            print("$errorBeg $msgErr $errorEnd");
            return "#000000";
        }
        $color = self::$surface[$style]["color"];
        return $color;
    } // end function LineColor
    public static function Icon2Display($style)
    {
        global $eol, $errorBeg, $errorEnd;
        self::buildSurfaceArray();
        if (!array_key_exists($style, self::$surface)) {
            print rrwFormat::backtrace("$errorBeg E#387 style $style not found in surface $errorEnd");
            return "#000000";
        }
        $icon = self::$surface[$style]["icon"];
        return $icon;
    } // end function LineColor

    public static function lineType($style)
    {
        global $eol, $errorBeg, $errorEnd;
        self::buildSurfaceArray();
        if (!array_key_exists($style, self::$surface)) {
            print rrwFormat::backtrace("$errorBeg E#263 style $style not found in surface $errorEnd");
            return "das";;
        }
        $roadVsTrail = self::$surface[$style]["roadVsTrail"];
        switch ($roadVsTrail) {
            case "off_road":
            case "closed":
                return "sol";
            case "on_road":
                return "dot";
            default:
                return "das";
        }
    }
    private static
    function lineWeight($style, $NotSet, $group = "")
    {
        global $eol, $errorBeg, $errorEnd;
        if ("oneBiz" == $style)
            return 19;
        return 4;
    } // end function lineWeight
} // end class
