<?php


class freewheelingeasy_kml_ParkingTxtFiles
{
    /*  Updates the text files having to do with point data
     *  UpdateParkingTxtFiles
     *  UpdateOneOnMapTxtFiles($onMapType)  - output a txt file for the given onMap type
     *  UpdateDinoMiteFiles() - output a txt file for the dinoMite locations
     *  UpdateOrbitFiles() - output a txt file for the orbit locations
     *  UpdateBusinessTxtFiles  - output a txt file for the business locations
     *  UpdateMilePostTxtFiles  - output a txt file for the milepost locations
     *  createGPSfiles - create the GPS files from the txt files
    */



    public static function UpdateOrbitFiles()
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $msg .= freeWheeling_edit_setGlobals::setGlobals("UpdateParkingTxtFile");
        $sqlOrbit = "select name, inner_au, outer_au from $wpdbExtra->orbits";
        $recOrbits = $wpdbExtra->get_resultsA($sqlOrbit);
        $jsonOrbits = json_encode($recOrbits);
        // $msg .= rrwUtil::print_r($recOrbits, true, "orbit data");
        $msg .= freewheeling_WriteUp::saveFileWithCompare("data", "jsonOrbits.txt",   $jsonOrbits, "file");
        return $msg;
    }

    public static function UpdateParkingTxtFiles()
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $msg .= freeWheeling_edit_setGlobals::setGlobals("UpdateParkingTxtFile");
        $msg .= freewheeling_edit_create_views("at UpdateParkingTxtFiles");
        $sqlTypes = "Select distinct onMap from $wpdbExtra->icons order by onMap ";
        $recTypes = $wpdbExtra->get_resultsA($sqlTypes);
        foreach ($recTypes as $recType) {
            $onMap = $recType["onMap"];
            $types = explode(",", $onMap);   // handle multiple types
            foreach ($types as $type) {
                $type = trim($type);
                if (empty($type))
                    continue;
                if (0 == strncmp("mile", $type, 4))
                    continue; // milepost are handled differently
                $msg .= self::UpdateOneOnMapTxtFiles($type);
            } // that is all the map types
        } // that is all the map types
        $sqlEndPoints = "select 0 milepost, lineName iconName, lineId iconId, 'flag.jpg' iconStyle,
		'line start point ' ptDescription, latStart latitude, lngStart longitude,
         trailId milepostPrefix, 0 sort, '' plusCode, trailId,
         0 isTrailHead, 'no' onMap, trName, '' bizId
		 from $wpdbExtra->trailLines order by trailId, latMin";
        $msg .= self::UpdateParkingTxtFileSqlFinal($sqlEndPoints, "line start");
        $msg .= "<hr>";
        return $msg;
    }
    public static function UpdateOneOnMapTxtFiles($onMapType)
    {
        // called based on onMap type from above and when amenities change
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $parkingFile = "icons_$onMapType";
        $sqlFinal = self::selectDataTable() .
            " where  onMap like '%$onMapType%'  order by trName, sort";
        $msg .= self::UpdateParkingTxtFileSqlFinal($sqlFinal, $parkingFile);
        return $msg;
    }


    public static function UpdateDinoMiteFiles()
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $msg .= freeWheeling_edit_setGlobals::setGlobals("UpdateParkingTxtFile");
        $sqlDinoPoints = "select keyId milepost, dinoName iconName, keyid iconId,
        if (mapDate < '2021-01-01', 'dinoRed.png', 'dino.png')  iconStyle,
		filename trailId,  latitude, longitude,
        streetViewList  milepostPrefix, 0 sort, '' plusCode, keyId,
         0 isTrailHead, '1' onMap, '', dinoName trName
		 from pillowan_wp541.wpprrj_00rrwdinos order by keyId";
        // that is really $wpdbExtra->dinosaurs but the pefix is wrong here
        $msg .= "DinoMite points sql: $sqlDinoPoints $eol";
        $msg .= self::UpdateParkingTxtFileSqlFinal($sqlDinoPoints, "dinomites");
        $msg .= freewheeling_amen_search::pushDevToProduction(array("allow" => 1));
        $msg .= "<hr>";
        return $msg;
    }
    private static function selectDataTable()
    {
        global $wpdbExtra;
        return "select distinct milepost, iconName, iconId,
                        iconStyle, ptDescription,
                        latitude, longitude,
                        milepostPrefix, sort, plusCode, trailId,
                        isTrailHead, onMap, trName, '' bizId
                    from $wpdbExtra->trailIcons
                   ";
    }
    private static function selectAccessMileposts()
    {
        global $wpdbExtra;;
        return "select distinct trailmilepost milepost, accbizname iconName, accid iconId,
                       concat('mpPic',trailmilepost) iconStyle, 'access Point' ptDescription,
                        traillatitude latitude, trailLongitude longitude,
                        trailMilepostPrefix  milepostPrefix, accid sort, 'xx' plusCode, 'yy' trailId,
                        0 isTrailHead, 1 onMap, 'trail' trName, accBizId bizId
                    from $wpdbExtra->access
                   ";
    }
    // ------------------------------------------------------  business????.txt
    public static
    function UpdateBusinessTxtFiles()
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $msg .= freeWheeling_edit_setGlobals::setGlobals("UpdateBusinessTxtFiles");
        $msg .= freewheeling_edit_create_views("at UpdateBusinessTxtFiles");
        // fist find the business locations
        $sqlbizlat = "select trailmilepost milepost, bizname iconName, bizId iconId,
                    bizstyle iconStyle, BizDirections ptDescription,
                    bizlat latitude, bizlng longitude,
                    trailMilepostPrefix milepostPrefix, '' sort, '' plusCode, '' trailId,
                    '1' isTrailHead, '1' onMap, '' trName , bizId
             from $wpdbExtra->business
             left join $wpdbExtra->access on bizId = accBizId
             where bizUsed > 0 and bizlat is not null ";
        $sqlBizLatOrder = "$sqlbizlat order by bizlat, bizlng, bizname, bizId ";
        //    $msg .= self::UpdateParkingTxtFileSqlFinal($sqlBizLatOrder, "businesslocations");
        // << TODO -  need to implement drawing lines from trail to Business locations
        // still using business locations
        $sqlcamp = "$sqlbizlat and k = 1 order by  bizlat, bizlng, bizname, bizId";
        //       $msg .= "$sqlcamp $eol ";
        $sqlcamp = str_replace("$wpdbExtra->business", "$wpdbExtra->businessServices", $sqlcamp);
        $msg .= self::UpdateParkingTxtFileSqlFinal($sqlcamp, "camp");
        // use traillocatons
        $sqlTrailLat = "$sqlbizlat ";
        $sqlTrailLat = str_replace("bizlat", "trailLatitude", $sqlTrailLat);
        $sqlTrailLat = str_replace("bizlng", "trailLongitude", $sqlTrailLat);
        $sqlTrailLatOrder = " $sqlTrailLat
                order by milepostPrefix, milepost ";
        //$msg .= "$sqlTrailLatorder $eol";
        $msg .= self::UpdateParkingTxtFileSqlFinal($sqlTrailLatOrder, "businesslaunch");
        $selectDataicon = str_replace("bizId", "iconName", self::selectDataTable());
        $sqlAlMile = " ($sqlTrailLat) UNION (" . $selectDataicon .
            " where onMap = 'launch' and not milepostPrefix = ''  )
                    order by milepostPrefix, milepost";
        //      $msg .= "$sqlAlMile $eol ";
        $msg .= self::UpdateParkingTxtFileSqlFinal($sqlAlMile, "launch");
        return "$msg $eol";
    }
    public static function UpdateMilePostTxtFiles()
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $debugUpdate = false;
        $sqlCenters = "select distinct trName iconName, 0 iconId, 'trail.png' iconStyle,
                            description ptDescription, labelNorth latitude, labelEast longitude, milepostPrefix,
                            trSequence sort, ' ' plusCode,
                            trId trailId, 1 isTrailHead, 1 onMap, 0 milepost
                        from $wpdbExtra->trailIcons
                            join $wpdbExtra->regions on trid = $wpdbExtra->regions.trailId
			             order by trName, labelNorth, LabelEast ";
        //      $msg .= "E#552 trail centers - $sqlCenters $eol";
        $msg .= self::UpdateParkingTxtFileSqlFinal($sqlCenters, "trailcenters");
        $msg .= "<hr>";
        $sqlMile = self::selectDataTable() .
            " where onMap like '%mile%' and  00 = (milepost MOD 10) ";
        if ($debugUpdate) $msg .= "E#566 milepost 10 - $sqlMile $eol";
        $msg .= self::UpdateParkingTxtFileSqlFinal($sqlMile, "milepost-10");
        $sqlMile = str_replace("10", "5) and !(00 = (milepost mod 10) ", $sqlMile);
        if ($debugUpdate) $msg .= "E#571 milepost 5 - $sqlMile $eol";
        $msg .= self::UpdateParkingTxtFileSqlFinal($sqlMile, "milepost-05");
        $sqlMile = str_replace("5", "1) and !(00 = (milepost mod 5) ", $sqlMile);
        $msg .= self::UpdateParkingTxtFileSqlFinal($sqlMile, "milepost-01");
        $sqlMile = self::selectDataTable() .
            " where onMap like '%mile%' and (00 = (milepost MOD 1)) ";
        if ($debugUpdate) $msg .= "E#573 milepost 01 - $sqlMile $eol";
        $msg .= self::UpdateParkingTxtFileSqlFinal($sqlMile, "milepost-other");

        $msg .= self::UpdateParkingTxtFilesAccess();
        $msg .= "<hr>";
        return $msg;
    }
    public static function UpdateParkingTxtFilesAccess()
    {
        $sqlMile = self::selectAccessMileposts();
        return self::UpdateParkingTxtFileSqlFinal($sqlMile, "milepost_access");
    }
    // ------------------------------------------------------------------ common output generator
    private static
    function UpdateParkingTxtFileSqlFinal($sqlFinal, $type)
    {
        /* read the database of parking icons or businesses
                and updates the the parking.txt, business_locs/trailId file that
         *  s read by the google map display routines.
         *  called from toctable/index.php
         *	image icons are built int the following order
         *		$items = array("Lodging", "Restaurant", "Bar", "Church", "Bikeshop");
         *
         *	routine expects data to be ordered by latitude, longitude to avoid duplicates
         */
        // expect something that has fields of trail and icon
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;

        try {
            $msg = "";
            if ("milepost_xx" == $type)
                $debugParking = true;
            else
                $debugParking = false;
            if ($debugParking)
                $msg .= "$sqlFinal $eol";
            $parkingFile = "$type.txt";
            $outputTxt = "<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'>
<html xmlns='http://www.w3.org/1999/xhtml'>
<head>
<meta http-equiv='Content-Type' content='text/html; charset=utf-8' />
<meta name='freewheeling-points' content='$type' />
<title>This file contains $type data</title>
</head>
<body>
";
            $outputCsv = "";
            $outputTxt .= date("Y-m-d_Hi") . " | lat | lng | name | style | description | " .
                " milepost | trail | sort | plusCode | trailhead  |x|\r\n";
            $recD = $wpdbExtra->get_resultsA($sqlFinal);
            $cntSelected = $wpdbExtra->num_rows;
            $cntPointsOut = 0;
            $nameprev = "not yet";
            $latPrev = 0;
            $lngPrev = 0;
            if ($wpdbExtra->num_rows == 0) {
                $msg .= "$msg $errorBeg E#392 No records found for $type $errorEnd
                            $sqlFinal $eol ";
                return $msg;
            }
            if ($debugParking) $msg .= "I#364 there are " . count($recD) . " items to output $eol;";
            foreach ($recD as $rec) {
                $name = freewheelingeasy_kml_ParkingTxtFiles::cleanDelimiter($rec["iconName"]);
                if (strpos($name, "debugEnabler") !== false)
                    $debugSelection = true;
                else
                    $debugSelection = false;
                $trailId = $rec["trailId"];
                if ("debugEnabler" == $trailId)
                    $debugSelection = true;
                else
                    $debugSelection = false;
                $line = "got rejected ";
                // name is same as past one. building the type of icon to output
                //      if ($debugSelection) $msg .= rrwUtil::print_r($rec, true, "E#580 UpdateParkingTxtFileSqlFinal:icon selection question");
                $iconStyle = $rec["iconStyle"];
                if (empty($iconStyle))
                    continue;
                $description = self::cleanDelimiter($rec["iconName"]);
                $latDetail = $rec["latitude"];
                $lat = round($latDetail, freeWheel::latRoundTo);
                $lngDetail = $rec["longitude"];
                $lng = round($lngDetail, freeWheel::latRoundTo);
                $trailName = $rec["iconName"];
                $sort = $rec["sort"];
                $plusCode = $rec["plusCode"];
                $trailMilepostPrefix = $rec["milepostPrefix"];
                if (empty($trailMilepostPrefix))
                    $trailMilepostPrefix = "";
                $isTrailHead = $rec["isTrailHead"];
                $onMap = $rec["onMap"];
                $milepost = FreewheelFormat::milepost2($trailMilepostPrefix, $rec["milepost"]);
                $description = trim($description);
                $iconId = $rec["iconId"];
                // gto the data for one icon
                if ($onMap == "park")
                    $iconStyle = "park";
                if (false !== strpos($onMap, "amen"))
                    $name = "$name-$iconId";
                if (empty($description))
                    $description = $name;
                $line = "$trailId|$lat|$lng|$name|$iconStyle|$description|";
                $line .= "$milepost|$trailName|$sort|$plusCode|$isTrailHead|\n";
                if ($debugParking /*&& strpos($trailName, "Coal")*/) $msg .= "$line $eol";
                if ($debugSelection) $msg .= "$line $eol";
                $cntPointsOut++;
                $outputTxt .= $line;
                $outputCsv .= "$lng,$lat,$description\n";
            } // end while
            // close off the file
            $outputTxt .= "</body></html>\n";
            if ($cntPointsOut != $cntSelected)
                $msg .= " &nbsp;  &nbsp;  &nbsp;  &nbsp; Output $cntPointsOut
                            parking points from $cntSelected for $parkingFile $eol";
            $msg .= freewheeling_WriteUp::saveFileWithCompare("data", $parkingFile, $outputTxt, "pointFile");
        } catch (Exception $e) {
            $msgErr = "E#365 Updating $parkingFile with $cntSelected items from $sqlFinal $eol";
            $msgErr .= rrwUtil::print_r($recD[0], true, "E#366 first record");
            $msgErr .= " $msg $msgErr $errorBeg E#368 bottom of UpdateParkingTxtFileSqlFinal" . $e->getMessage() . " $errorEnd ";
            throw new Exception($msgErr);
        }
        return "$msg";
    }
    private static
    function cleanDelimiter($item): string
    {
        if (empty($item))
            return "";
        return str_replace("|", " ", $item);
    }   // end cleanDelimiter
    /*

    private static
    function createGPSfiles($parkingPath, $gpsOut = array("garmin_poi", "gpx"))
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $msg .= " $errorBeg E#666 createGPSfiles not yet implemented $errorEnd";
        return $msg;
        $msg .= "<h1>Update GPS Files</h1> Reads the database, updates the file  $freewheeling_prebuilt_dire/data/parking.";
        foreach ($gpsOut as $ext) {
            $msg .= "$gpsOut, ";
            if (file_exists($parkingPath . $ext))
                unlink("$parkingPath.$ext");
        }
        $msg .= $eol;
        $command = "C:/progra~2/GPSBabel/GPSBabel.exe ";
        $command .= " -i csv -f $parkingPath.csv -o kml -F $parkingPath.kml -i kml,points=0,line_width=6,labels=0,prec=7 -f $parkingPath.kml ";
        foreach ($gpsOut as $ext) {
            $command .= " -o $ext -F $parkingPath.$ext ";
        } // do all the required at one pass
        $command = str_replace("/", "\\", $command);
        $msg .= "$command$eol";
        $last_line = exec($command, $output);
        foreach ($output as $line)
            $msg .= "$line$eol";
        $msg .= $last_line;
        foreach ($gpsOut as $ext) {
            if (!file_exists("$parkingPath.$ext"))
                $msg .= "$errorBeg E#667$ext file did not get created. $errorEnd";
            else
                $msg .= "gps file $parkingPath.$ext created$eol";
        }
    }
    */
} // end class freewheelingeasy_kml_ParkingTxtFiles
