<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2019 - https://royweil.com
 *
 */
class freewheelingEasy_kml_trailList
{

    public static function calculate90by90()
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        global $meters2Mile, $feet2Miles;
        global $csvPast, $csv;
        $roundMilesTo = 2;
        $msg = "";
        $HistoryFile = "";
        $debugHistory = false;
        $msg .= freeWheeling_edit_setGlobals::setGlobals("calculate90by90");
        return "E#300 Calculate 90 X 90 does not implemented now$eol";
        $routes = array("dobbs_freeport", "dobbs_newken");
        foreach ($routes as $route) {
            $htmlDetail = "";
            $htmlSummaryDown = "";
            $csv = "";
            // figure out which lines to ue=se
            $sqlGrp = "select linesql, grpName from $wpdbExtra->trail_routes where grpid = '$route'  ";
            $recGrps = $wpdbExtra->get_resultsA($sqlGrp);
            $sqlWhere = $recGrps[0]["linesql"];
            $grpName = $recGrps[0]["grpName"];
            //  miles now() by type
            $sqlNow = "select sum(lengthMeters) totalMeters, googleType from $wpdbExtra->lines
						join $wpdbExtra->codesSurface on code = mapstyle
						where $sqlWhere  group by googleType";
            $recnows = $wpdbExtra->get_resultsA($sqlNow);
            $totalTodayMeters = 0;
            if (3 != $wpdbExtra->num_rows)
                throw new Exception("$msg $errorBeg e#415 expected three rows, but got " . $wpdbExtra->num_rows . " for $errorEnd $sqlNow $eol");
            foreach ($recnows as $recNow) {
                $lengthMeters = $recNow["totalMeters"];
                $lengthMiles = round($recNow["totalMeters"] / $meters2Mile, $roundMilesTo);
                $type = $recNow["googleType"];
                switch ($type) {
                    case "on_road":
                        $totalonRoadMeters = $lengthMeters;
                        break;
                    case "off_road":
                        $totalOffRoadMeters = $lengthMeters;
                        break;
                    case "other":
                        $totalotherMeters = $lengthMeters;
                        break;
                    default:
                        $msg .= "$errorBeg E#608 unknown mapstyle/googletype $type $errorEnd";
                }
                $totalTodayMeters += $lengthMeters;
            }
            $totalonRoadMiles = round($totalonRoadMeters / $meters2Mile, $roundMilesTo);
            $totalOffRoadMiles = round($totalOffRoadMeters / $meters2Mile, $roundMilesTo);
            $totalotherMiles = round($totalotherMeters / $meters2Mile, $roundMilesTo);
            $totalTodayMiles = $totalOffRoadMiles + $totalonRoadMiles + $totalotherMiles;
            //  --------------------------------------- header lines of history detail
            $htmlDetail .= "<h3>$grpName</h3>";
            $htmlDetail .= "<table>\n";
            $htmlDetail .= self::printline(
                " ",
                "motor free",
                "On-road",
                "other",
                "motor free",
                "On-road",
                "other",
                "total",
                "percent",
                "percent",
                "percent",
                "percent"
            );
            $htmlDetail .= self::printline(
                " ",
                "Delta mi",
                "Delta mi",
                "Delta mi",
                "miles",
                "miles",
                "miles",
                "miles",
                "motor free",
                "On-road",
                "total",
                "goal"
            );
            $htmlSummaryDown .= "<h3>$grpName</h3>";
            $htmlSummaryDown .= "<table>\n";
            $htmlSummaryDown .= "<tr><td width=100px>&nbsp;</td><td>&nbsp;</td>
            <td width=70px>motor free</td><td>&nbsp;</td>
            <td width=50px>On-Road</td><td>&nbsp;</td>
            <td width=50px>Other</td><td>&nbsp;</td>
            <td>Miles / Action</td><td>&nbsp;</td>";
            // end header
            $today = new DateTime();
            $dateDisplay = $today->format("Y M d");
            $htmlSummaryDown .= self::formatDateMile(
                $dateDisplay,
                $totalonRoadMiles,
                $totalOffRoadMiles,
                $totalotherMiles,
                $totalTodayMiles
            );
            $HistoryFile .= "<table>\n";
            $csvPast = date("M d, Y");
            $HistoryFile .= self::printline(
                date("M d, Y"),
                $totalOffRoadMeters,
                $totalOffRoadMiles,
                $totalonRoadMeters,
                $totalonRoadMiles,
                $totalotherMeters,
                $totalotherMiles,
                $totalTodayMeters
            );
            // check we got each type
            $sql2 = "select sum(lengthMeters) from $wpdbExtra->lines where $sqlWhere ";
            $totalMeters = $wpdbExtra->get_var($sql2);
            $HistoryFile .= "$grpName is " . round($totalMeters / $meters2Mile, 3) . " miles total$eol";
            $totalMiles = round($totalMeters / $meters2Mile, $roundMilesTo);
            if ($totalTodayMiles != $totalMiles)
                $msg .= "$errorBeg E#624 rounded sum of sections ($totalTodayMiles)
                does not agree with extracted total ($totalMiles) $errorEnd";
            /*
                        $sqlDelta = "select RCyear, sum(off_road_ft) offroadFeet,
            					sum(on_road_ft) onroadFeet, sum(other_ft) otherFeet
            					from $wpdbExtra->route_changes where $sqlWhere
            					group by RCyear order by RCyear desc ";
                        $recDeltas = $wpdbExtra->get_resultsA( $sqlDelta );
                        $thisyear = 0;
                        $totalOffRoadMiles = 0;
                        $totalonRoadMiles = 0;
                        $totalotherMiles = 0;
                        foreach ( $recDeltas as $recDelta ) { // oneline per year
                            $year = $recDelta[ "RCyear" ] - 1;
                            $offRoadMiles = round( $recDelta[ "offroadFeet" ] / $feet2Miles, $roundMilesTo );
                            $onRoadMiles = round( $recDelta[ "onroadFeet" ] / $feet2Miles, $roundMilesTo );
                            $otherMiles = round( $recDelta[ "otherFeet" ] / $feet2Miles, $roundMilesTo );
                            if ( $thisyear < $year )
                                $thisyear = $year;
                            $totalOffRoadMiles -= $offRoadMiles;
                            $totalonRoadMiles -= $onRoadMiles;
                            $totalotherMiles -= $otherMiles;
                            $totalMiles = $totalMiles - $offRoadMiles - $onRoadMiles - $otherMiles;
                            $csvPast = "Dec 31, $year";
                            $msgTemp = self::printline( "Dec 31, $year",
                                $offRoadMiles, $totalOffRoadMiles,
                                $onRoadMiles, $totalonRoadMiles,
                                $otherMiles, $totalotherMiles,
                                $totalMiles );
                            $HistoryFile .= $msgTemp;
                            $htmlDetail .= $msgTemp;
                        } // end of one line per ear
            */
            $HistoryFile .= rrwFormat::CellRow(
                "&nbsp;",
                "&nbsp;",
                "&nbsp;",
                "&nbsp;",
                "&nbsp;",
                "&nbsp;",
                "&nbsp;",
                "&nbsp;"
            );
            $HistoryFile .= "</table>\n";
            $csvPast = "want first yr";
            $htmlDetail .= "<tr><td colspan='20' ><hr></td></tr>\n";
            $sqlDelta = "select RCyear, off_road_ft,  on_road_ft,
					other_ft, description from $wpdbExtra->route_changes where $sqlWhere
					order by RCyear desc, rcsort asc ";
            $yearPast = "2022";
            $subtotalOffRoadFeet = 0;
            $subtotalonRoadFeet = 0;
            $subtotalotherFeet = 0;
            $subtotalOffRoadMeters = 0;
            $subtotalonRoadMeters = 0;
            $subtotalotherMeters = 0;
            $subtotalOffRoadMiles = 0;
            $subtotalonRoadMiles = 0;
            $subtotalotherMiles = 0;
            $recDeltas = $wpdbExtra->get_resultsA($sqlDelta);
            $yearsummaryPast = "notyet";
            foreach ($recDeltas as $recDelta) { //  lopp through each record
                $year = $recDelta["RCyear"];
                $description = $recDelta["description"];
                if ($yearPast != $year) {
                    $htmlSummaryDown .= self::formatDateMile(
                        "$year Dec 31",
                        $totalonRoadMiles,
                        $totalOffRoadMiles,
                        $totalotherMiles,
                        $totalMiles
                    );
                    /*                   $htmlDetail .= self::printline( "Dec 31, $yearPast",
                        $subtotalOffRoadFeet, $totalOffRoadFeet,
                        $subtotalonRoadFeet, $totalonRoadFeet,
                        $subtotalotherFeet, $totalotherFeet,
                        $totalMiles );
 // now the csv files
                    $p1 = round( $subtotalOffRoadFeet / $totalFeet * 100, 2 );
                    $p2 = round( $subtotalonRoadFeet / $totalFeet * 100, 2 );
                    $p3 = $p1 + $p2;
                    $p4 = 90;
*/
                    $subtotalOffRoadFeet = 0;
                    $subtotalonRoadFeet = 0;
                    $subtotalotherMeters = 0;
                    $subtotalOffRoadMiles = 0;
                    $subtotalonRoadMiles = 0;
                    $subtotalotherMiles = 0;
                    $yearPast = $year;
                } // end of year change
                if (empty($description))
                    continue; // use blank description a the last year to trigger totals
                $offRoadFeet = $recDelta["off_road_ft"];
                $onRoadFeet = $recDelta["on_road_ft"];
                $otherFeet = $recDelta["other_ft"];
                $offRoadMiles = round($offRoadFeet / $feet2Miles, $roundMilesTo);
                $onRoadMiles = round($onRoadFeet / $feet2Miles, $roundMilesTo);
                $otherMiles = round($otherFeet / $feet2Miles, $roundMilesTo);
                $totalOffRoadMiles -= $offRoadMiles;
                $totalonRoadMiles -= $onRoadMiles;
                $totalotherMiles -= $otherMiles;
                $subtotalOffRoadMiles -= $offRoadMiles;
                $subtotalonRoadMiles -= $onRoadMiles;
                $subtotalotherMiles -= $otherMiles;
                $totalMiles = $totalMiles + $offRoadMiles + $onRoadMiles + $otherMiles;
                $htmlSummaryDown .= self::formatchange(
                    $onRoadFeet,
                    $offRoadFeet,
                    $otherFeet,
                    "$description"
                );
                $htmlDetail .= rrwFormat::CellRow(
                    "&nbsp;",
                    $offRoadMiles,
                    $onRoadMiles,
                    $otherMiles,
                    "<td colspan=16>$description</td>"
                );
            } // end  foreach of the mialges deltas
            $htmlDetail .= "</table>\n";
            $htmlSummaryDown .= "</table>\n";
            $source = '
			<style type="text/css" media="print" >
				.freewheelingHiddenPrint  {
				display:none;
			}
			</style>
			';
            $link = FreewheelFormat::groupIdMapLink($route, "$groupName current map ");;
            $link = str_replace("?", "?showinstructions=on&", $link);
            $source .= "<div class='freewheelingHiddenPrint'>Data extracted " . date("M d, Y") .
                " $link
                [ <a class='external' href='https://2020.eriepittsburghtrail.org/mainline-trails/' > miles by trail </a>
              ]";
            do_shortcode("[freewheeling-easy-map-write-up file=data/route-homepageselectionn.html ]") . "
				</div> <!-- end<div class='freewheelingHiddenPrint' --> ";
            $htmlDetail .= "$source$eol";
            $HistoryFile .= "$source$eol";
            $htmlSummaryDown .= "$source$eol";
            $calculateMP = new freewheelingeasy_calculateMP();
            // no idea why there arefour files with the same data
            $msg .= freewheeling_Writeup::saveFile("data", "history-detail-$route", $source);
            $msg .= freewheeling_Writeup::saveFile("data", "history-$route", $source);
            $msg .= freewheeling_Writeup::saveFile("data", "history-complete-$route", $source);
            $msg .= freewheeling_Writeup::saveFile("data", "history-csv-Route", $source);
            // ------------------------------------  detail pushed out, now do the summary
        }
        global $wp;
        $current_url = add_query_arg($wp->query_string, '', home_url($wp->request));
        $msg .= $eol;
        return $msg;
    }
    private static function formatDateMile(
        $dateDisplay,
        $totalonRoadMiles,
        $totalOffRoadMiles,
        $totalotherMiles,
        $totalMiles
    ) {
        $msg = "";
        $color = rrwUtil::ColorSwap(); // make gray color
        $color = rrwUtil::ColorSwap($color); // make gray color
        $roundTo = 1;
        $msg .= "<tr style='background-color:$color'>";
        $msg .= rrwFormat::Cell("$dateDisplay");
        $msg .= rrwFormat::Cell("&nbsp;", "&nbsp;", "&nbsp;");
        $msg .= rrwFormat::Cell("&nbsp;", "&nbsp;", "&nbsp;");
        $msg .= rrwFormat::Cell("&nbsp;", "&nbsp;", "&nbsp;");
        $percentOn = round($totalonRoadMiles / $totalMiles * 100, $roundTo);
        $percentOff = round($totalOffRoadMiles / $totalMiles * 100, $roundTo);
        $percentOther = round($totalotherMiles / $totalMiles * 100, $roundTo);
        $msg .= rrwFormat::Cell(round($totalMiles, $roundTo) . " total EPT mi.</td> ");
        $msg .= rrwFormat::Cell("$totalOffRoadMiles miles Motor Free ($percentOff%), ");
        $msg .= rrwFormat::Cell("$totalonRoadMiles miles on-Road ($percentOn%), ");
        $msg .= rrwFormat::Cell("$totalotherMiles miles Closed, Undeveloped, Unknown ($percentOther%)");
        $msg .= "\n</tr>";
        return $msg;
    }
    private static function formatchange($feet1, $feet2, $feet3, $Desc)
    {
        $msg = "";

        $msg .= "<tr>";
        $msg .= rrwFormat::Cell("&nbsp;");
        $msg .= rrwFormat::Cell(self::FormatCellBlankIfZreo($feet1));
        $msg .= rrwFormat::Cell(self::FormatCellBlankIfZreo($feet2));
        $msg .= rrwFormat::Cell(self::FormatCellBlankIfZreo($feet3));
        $msg .= "<td colspan='16'> $Desc</td>";
        return $msg;
    }
    private static function FormatCellBlankIfZreo($feet)
    {
        if (0 == $feet)
            return "&nbsp;";
        else
            return "$feet ft";
    }
    static private function printline(
        $year,
        $offroad,
        $totalOffRoad,
        $onroad,
        $totalonroad,
        $other,
        $totalother,
        $totalMiles,
        $p1 = "",
        $p2 = "",
        $p3 = "",
        $p4 = ""
    ) {
        global $csvPast, $csv;
        $msg = "";

        if (empty(trim($year)))
            return rrwFormat::CellRow(
                $year,
                $offroad,
                $totalOffRoad,
                $onroad,
                $totalonroad,
                $other,
                $totalother,
                $totalMiles,
                $p1,
                $p2,
                $p3,
                $p4
            );
        $p1 = round($totalOffRoad / $totalMiles * 100, 2);
        $p2 = round($totalonroad / $totalMiles * 100, 2);
        $p3 = $p1 + $p2;
        $p4 = 90;
        if ($csvPast != $year) {
            $csv .= " $year, $totalOffRoad,  $totalonroad, $totalother, $totalMiles, " .
                "$p1, $p2, $p3, $p4 \n";
            $csvPast = $year;
        }
        $msg .= rrwFormat::CellRow(
            $year,
            $offroad,
            $onroad,
            $other,
            $totalOffRoad,
            $totalonroad,
            $totalother,
            $totalMiles,
            $p1,
            $p2,
            $p3,
            $p4
        );
        return $msg;
    }
    public static
    function create90X90File()
    {
        $msg = "";
        $msg .= self::calculate90by90();
        $msg .= "<hr />";
        $msg .= freewheeling_WriteUp::getFileContents("data", "history-dobbs_newken.html");
        $msg .= "<hr />";
        $msg .= freewheeling_WriteUp::getFileContents("data", "historyDetail-Calcdobbs_newken.html");
        return $msg;
    }
    public static
    function kml_trailList()
    {
        // build the .txt files and some .html files
        error_reporting(E_ALL);
        ini_set("display_errors", true);
        $debugSteps = false;
        $msg = "";
        $msg .= freeWheeling_edit_setGlobals::setGlobals("freewheelingEasy_kml_trailList::kml_trailList");
        $parkingCSVFile = "/data/parking.csv";
        $linkingFile = "linking.html";
        $filName90x90 = "90by90.html";
        if ($debugSteps) self::testBizServ(1);
        $msg .= freewheeling_edit_create_views("at build list");
        if ($debugSteps) self::testBizServ(1);
        $msg .= self::formatAction("Updated the 90 by 90 progess chart");
        if ($debugSteps) self::testBizServ(3);
        $msg .= self::calculate90by90();
        if ($debugSteps) self::testBizServ(3);
        $msg .= self::formatAction("Updated the home Page Selection Box and Checkboxes");
        if ($debugSteps) self::testBizServ(4);
        $msg .= self::createHomePageSelections();
        if ($debugSteps) self::testBizServ(5);
        $msg .= self::formatAction("Update busines styles ");
        if ($debugSteps) self::testBizServ(6);
        $msg .= freewheelingeasy_editbiz::updateBizStyles();
        if ($debugSteps) self::testBizServ(7);
        $msg .= self::formatAction("Updated parking txt files");
        if ($debugSteps) self::testBizServ(8);
        $msg .= freewheelingeasy_kml_ParkingTxtFiles::UpdateDinomiteFiles();
        if ($debugSteps) self::testBizServ(9);
        $msg .= freewheelingeasy_kml_ParkingTxtFiles::UpdateOrbitFiles();
        if ($debugSteps) self::testBizServ(10);
        $msg .= freewheelingeasy_kml_ParkingTxtFiles::UpdateParkingTxtFiles();
        if ($debugSteps) self::testBizServ(11);
        $msg .= freewheelingeasy_kml_ParkingTxtFiles::UpdateMilePostTxtFiles();
        if ($debugSteps) self::testBizServ(12);
        $msg .= freewheelingeasy_kml_ParkingTxtFiles::UpdateBusinessTxtFiles();
        if ($debugSteps) self::testBizServ(13);
        $msg .= createLineText::createZZDataFiles();
        $msg .= self::formatAction("Updated link html file", $linkingFile);
        $msg .= freewheelingeasy_land::CreatePageOfTrailLinks($linkingFile);
        $msg .= self::formatAction("Updated various zz lines files", "");
        return $msg;
    }

    private static function testBizServ($number)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        print "testBizServ before $number $eol";
        $sql = "select * from $wpdbExtra->businessServices    limit 1";
        $rec = $wpdbExtra->get_resultsA($sql);
        print "testBizServ aftrr $number $eol";
        return true;
    }

    public static
    function formatAction($description, $file = "")
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        if (!empty($description))
            $msg .= "<h2>$description</h2>";
        return $msg;
    }
    static public
    function trailSelectionBox($addgaps = false, $title =
    "Type/select %trail% name to view a specific trail", $buttonText = "View it")
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        if ($addgaps)
            $trailroute = "trail/route";
        else
            $trailroute = "trail";
        $title = str_replace("%trail%", $trailroute, $title);
        $homepageselectionn = "
		<h2>$title</h2>$eol
		<select id='trailId' name='trailId' style='width:300px' autofocus='autofocus' > \n";
        $sqlTrails = "select trid, trname from $wpdbExtra->trails where trid in (select distinct trailId from $wpdbExtra->lines)";
        if ($addgaps) {
            $sqlTrails .= " union select grpid, concat (grpname, ' (', linesql, ')' ) from $wpdbExtra->trail_routes ";
        }
        $sqlTrails .= " order by trname ";
        $recTrails = $wpdbExtra->get_resultsA($sqlTrails);
        $pastSelect = rrwParam::String("trail_route_name");
        foreach ($recTrails as $recTrail) {
            $trailname = $recTrail["trname"];
            $trailId = $recTrail["trid"];
            $trailname = str_replace("'", "", $trailname);
            $trailname = str_replace("%", "", $trailname);
            $trailname = str_replace("routes like", "", $trailname);
            $trailname = str_replace(" or ", ",", $trailname);
            $trid = $recTrail["trid"];
            $homepageselectionn .= "<option value='$trailId' ";
            if ($pastSelect == $trailname)
                $homepageselectionn .= " selected='selected' ";
            $homepageselectionn .= " >$trailname</option>\n";
        }
        $homepageselectionn .= "</select>
        <input name='Submit' type='submit' value='$buttonText' />";
        return $homepageselectionn;
    }
    static public
    function SelectionBoxSql($trail_route_name)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $trail_route_name = urldecode($trail_route_name);
        $iiParenOpen = strpos($trail_route_name, "(");
        print "iiParenOpen = '$iiParenOpen'";
        if ($iiParenOpen !== false) {
            $iiParenClose = strpos($trail_route_name, ")");
            $grpid = trim(
                substr($trail_route_name, $iiParenOpen + 1, $iiParenClose - $iiParenOpen - 1)
            );
            if (is_null($grpid))
                throw new Exception("$errorBeg E#410 Unknown route of '$grpid' $errorEnd");
            $sqlRoute = "select linesql from $wpdbExtra->trail_routes where grpid = '$grpid' ";
            $sqlOut = $wpdbExtra->get_var($sqlRoute);
        } else {
            $sqlTrail = "select trid from $wpdbExtra->trails where trname = '$trail_route_name' ";
            $trailId = $wpdbExtra->get_var($sqlTrail);
            if (is_null($trailId))
                throw new Exception("$errorBeg E#409 Unknown trail of '$trail_route_name' $errorEnd
                            $sqlTrail $eol num rows = " . $wpdbExtra->num_rows . $eol);
            $sqlOut = " trailId = '$trailId' ";
        }
        return $sqlOut;
    }
    public static function createHomePageSelections()
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $homepageselectionn = "";
        $sqlRoutes = "select grpid, grpName, linesql from $wpdbExtra->trail_routes order by grpname ";
        $recRoutes = $wpdbExtra->get_resultsA($sqlRoutes);
        $homepageselectionn .= "<form method='post' action='/google-map/' >\n";
        $homepageselectionn .= "<table><tr>";
        $homepageselectionn .= "<td>" . self::trailSelectionBox(true) . "$eol$eol"; // no groups
        //     $homepageselectionn .= "<input type='hidden' name='showInstructions' value='please' />";
        $homepageselectionn .= "\n</td>\n<td>";
        $homepageselectionn .= "<input type='checkbox'   name='showinstructions'/>
						<lable for='showinstructions'>Show instructions and line details</lable>$eol";
        $homepageselectionn .= "<input type='checkbox'   name='highlightepta'/>
						<lable for='highlightepta'>Highlight EPTA, instructions and line details</lable>$eol";
        $homepageselectionn .= "<input type='checkbox' name='counties'/>
						<lable for='counties'>Blank out the google map data, show county lines</lable>$eol";
        $homepageselectionn .= "<input type='checkbox' name='allmileposts' />
						<lable for='allmileposts'>display Check millage
                                along the trail </lable>$eol";
        $homepageselectionn .= " <input type='checkbox' name='businesslocations' />
						<lable for='businesslocations' >
                            display business icons(not implemented)</lable>$eol";
        $homepageselectionn .= "<input type='checkbox' name='trailcenters' />
						<lable for='traillable'>display trail labels </lable>$eol";
        $homepageselectionn .= "<input type='checkbox' name='trail2biz' />
						<lable for='trail2biz'  >display the route from trail to business </lable>$eol";
        $homepageselectionn .= "<input type='checkbox' name='highlightgaps' />
						<lable for='highlightgaps'>Highlight the unknown</lable>$eol";
        $homepageselectionn .= "<br />";
        $homepageselectionn .= "<input type='checkbox' name='hideamenities' />
						<lable for='hideamenities'>hide amenity icons icons on
                                trail</lable>$eol";
        $homepageselectionn .= "<input type='checkbox'   name='hideparking' />
						<lable for='hideparking'>Hide parking lots</lable>$eol";
        $homepageselectionn .= "<input type='checkbox'   name='hidecamp' />
						<lable for='hidecamp'>Hide campsites</lable>$eol";
        $homepageselectionn .= "<input type='checkbox'   name='hidemiles' />
						<lable for='hidemiles'>Hide mileposts</lable>$eol";
        $homepageselectionn .= "</td>\n</tr></table>";
        $homepageselectionn .= "</form>";
        $msg .= freewheeling_Writeup::saveFileWithCompare("data", "route-homepageselectionn.html", $homepageselectionn);
        return $msg;
    }
} // end class
class siteMapbuild
{
    public static function createXMLforMap($fp, $trid, $trDate)
    {
        $mapUrl = "https://freewheelingeasy.com/google-map/?trailId=$trid&amp;nohead=please/";
        self::CreateXMLforLink($fp, $mapUrl, $trDate, .7);
        return "";
    }   // end function createXMLforMap( )
    public static function   siteMapHeader($fp)
    {
        $eol = "\n";
        $xmlHeader = "<?xml version='1.0' encoding='UTF-8'?>\n";
        //$xmlHeader .= 'urlset xmlns:xsi="http://www.w3.org/2001/XMLSchema-instanc
        // xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd"
        // xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">' . $eol;

        $xmlHeader .= "<urlset xmlns='http://www.sitemaps.org/schemas/sitemap/0.9'>$eol";
        fwrite($fp, $xmlHeader);
        return "";
    }
    public static function  CreateXMLforLink($fp, $writecellhref, $trDate, $priority)
    {
        $eol = "\n";
        try {
            fwrite($fp, "<url>$eol");
            fwrite($fp, "  <loc>$writecellhref</loc>$eol");
            fwrite($fp, "  <lastmod>$trDate</lastmod>$eol");
            fwrite($fp, "  <changefreq>weekly</changefreq>$eol");
            fwrite($fp, "  <priority>$priority</priority>$eol");
            fwrite($fp, "</url>$eol");
            return "";
        } catch (Exception $e) {
            throw new Exception("error writing to xml $writecellhref $eol");
        }
    } // end function CreateXMLforLink( )
    public static function siteMapFooter($fp)
    {   // close out the xml tags and close the file
        $eol = "\n";
        fwrite($fp, "  </urlset>$eol");
        fclose($fp);
        return "";
    } //

} // end class siteMapbuild
