<?php
class FreewheelFormat
{
    private static $bizUsedTranslate;
    private static $webStatusTranslate;
    private static $milepostPrefix = "MP "; // used by formatMilepost if none provided, set at opportune times
    //  public static $staleDate = "";
    public function __construct()
    {
        //      $this->staleDate = date("Y-m-d", strtotime("-60 days"));
    }
    public static function get_staleDate()
    {
        return date("Y-m-d", strtotime("-60 days"));
    }
    public static function get_degrees4TenMiles()
    {
        // from https://calculator.academy/degrees-to-feet-calculator/
        return 0.1448;
    }
    // the collection of routines below are used to create editing links to the items, with a link to the map
    public static function groupIdMapLink($groupId, $display = "")
    {
        return self::formatMapLink2("groupId=$groupId", $display);
    }
    public static function iconIdMapLink($iconId, $display = "map")
    {
        return self::formatMapLink2("iconId=$iconId", $display);
    }
    public static function lineIdMapLink($lineId, $display = "map")
    {
        return self::formatMapLink2("lineId=$lineId", $display);
    }
    public static function latitudeMapLink($latitude, $longitude, $display = "map")
    {
        return self::formatMapLink2("?latitude=$latitude,$longitude", $display);
    }
    public static function bizIdMapLink($bizId, $display = "map")
    {
        return self::formatMapLink2("?bizId=$bizId", $display);
    }
    public static function trailIdMapLink($trailId, $display = "map")
    {
        return self::formatMapLink2("?trailId=$trailId", $display);
    }
    private static function formatMapLink2($thing, $text = "map")
    {
        global $freewheeling_pagesPreBuiltUrl;
        $text = " map ";
        $options = "&allmileposts=0&nohead=please' ";
        $http = "<a  target='map' href='/google-map/?$thing$options' > $text</a>";
        return " $http ";
    }
    // this collection of routines outputs a pencil icon, and plain text
    public static function BizLink($bizId, $textOut = "", $target = "edit")
    {
        global $wpdbExtra, $rrw_business;
        global $eol, $errorBeg, $errorEnd;
        $debugBizLine = rrwParam::isDebugMode("debugBizLine", false);
        if ($debugBizLine) {
            print "in BizLink($bizId, $textOut, $target) $eol";
        }
        if (empty($bizId))
            return "$errorBeg E#871 BizLink: no business name/id entered $errorEnd ";
        if (empty($textOut)) {
            $sqlBiz = "select bizName, bizWWW from $rrw_business where bizId = '$bizId' ";
            $recs = $wpdbExtra->get_resultsA($sqlBiz);
            if ($wpdbExtra->num_rows != 1) {
                print rrwFormat::backtrace("$errorBeg E#872 found " . $wpdbExtra->num_rows . "
                                    for bizName in formatBizLink $errorEnd $sqlBiz $eol");
                $$textOut = "Biz Name not found $errorEnd";
            } else {
                $bizName = $recs[0]["bizName"];
                $bizWWW = $recs[0]["bizWWW"];
                if (empty($bizWWW)) {
                    $textOut = $bizName;
                } else {
                    $textOut = "<a href='$bizWWW' target='biz' class='external'>$bizName</a>";
                }
            }
        }
        $sqlBizVerified = "select bizVerified from $rrw_business where bizId = '$bizId' ";
        $bizVerified = $wpdbExtra->get_var($sqlBizVerified);
        // print "in bizLink CommonLink($bizId, $BizName, biz, $target, $bizverified); $eol";
        return self::CommonLink($bizId, $textOut, "biz", $target);
    }
    public static function editGroupLink($groupId, $textOut = "", $target = "edit")
    {
        global $wpdbExtra;
        if (empty($textOut))
            $textOut = $wpdbExtra->get_var("select groupName from $wpdbExtra->trail_routes where groupId = '$groupId' ");
        return self::CommonLink($groupId, $textOut, "group", $target);
    }
    public static function EditIconLink($iconId, $textOut = "", $target = "edit")
    {
        global $wpdbExtra;
        if (empty($iconId) && !empty($textOut))
            $iconId = $wpdbExtra->get_var("select iconId from $wpdbExtra->icons where iconName = '$textOut' ");
        if (empty($textOut))
            $textOut = $wpdbExtra->get_var("select iconName from $wpdbExtra->icons where iconId = '$iconId' ");
        if (empty($textOut))
            $textOut = "icon not found";
        return self::CommonLink($iconId, $textOut, "icon", $target);
    }
    public static function EditLineLink($lineId, $textOut = "", $target = "edit")
    {
        global $wpdbExtra;
        if (empty($textOut))
            $textOut = $wpdbExtra->get_var("select lineName from $wpdbExtra->lines where lineId = '$lineId' ");
        if (empty($textOut))
            $textOut = "line $lineId not found";
        return self::CommonLink($lineId, $textOut, "line", $target);
    }
    public static function EditHTMLink($Html_Id, $textOut = "", $target = "edit")
    {
        return self::CommonLink($Html_Id, $textOut, "html", $target);
    }
    public static function EditServiceLink($svcId, $textOut = "", $target = "edit")
    {
        global $wpdbExtra, $rrw_services;
        if (empty($textOut)) {
            $sqlSvc = "select svcName from $wpdbExtra->services where svcId = '$svcId' ";
            $textOut = $wpdbExtra->get_var($sqlSvc);
            if (empty($textOut))
                $textOut = "Service Name not found";
        }
        return self::CommonLink($svcId, $textOut, "service", $target);
    }
    public static function EditTrailLink($trailId, $textOut = "", $target = "edit")
    {
        global $wpdbExtra;
        $recs = $wpdbExtra->get_resultsA("select trName, landingPage from $wpdbExtra->trails where trId = '$trailId' ");
        if (1 != $wpdbExtra->num_rows)
            $textOut = "missing trail name $trailId";
        $trName = $recs[0]["trName"];
        if (empty($textOut)) {
            $landingPage = $recs[0]["landingPage"];
            if (!empty($landingPage))
                $textOut = "<a class= 'external' href='$landingPage' > $trName</a>";
            else
                $textOut = $trName;
        }
        return self::CommonLink($trailId, $textOut, "trail", $target);
    }
    public static function TrailLink($trailId, $trailName = "", $target = "edit")
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra, $rrw_trails;
        if (empty($trailName))
            $trailName = $wpdbExtra->get_var("select trName from $rrw_trails where trId = '$trailId' ");
        if ($wpdbExtra->num_rows == 0) {
            return "$errorBeg E#876 trailName is blank and trail id of '$trailId' could
                    not find a match. $errorEnd";
        }
        return self::CommonLink($trailId, $trailName, "trail", $target);
    }
    /**
     * Generates a common editing link for various actions such as line, icon, service, biz, or trail.
     *
     * @param string $itemid The ID of the item.
     * @param string $textOut The text to be displayed.
     * @param string $action The action type (line, icon, service, biz, trail).
     * @param string $target The target attribute for the link (default is "edit").
     *
     * @return string The generated HTML link.
     *
     * @throws Exception If both $itemid and $textOut are empty.
     */
    public static function CommonLink($itemid, $textOut, $action, $target = "edit")
    {
        global $freewheelingeasy_pencilIconImage, $freewheeling_pagesPreBuiltUrl;
        global $eol, $errorBeg, $errorEnd;
        if (false !== strpos($textOut, "debugEnabler"))
            $debugCommon = false;
        else
            $debugCommon = false;
        if ($debugCommon) {
            print "common: $itemid, $textOut $eol ";
            print rrwFormat::backtrace("E#417 inside formatCommonLink: ", 3);
        }
        if (empty($itemid)) {
            // no item id therefor an edit link is not possible
            if (empty($textOut)) {
                throw new Exception("$errorBeg
               E#434 both  itemid '$itemid' and textOut '$textOut' are blank $eol
                    Perhaps here is a region without a matching trail
                    $errorEnd" . rrwFormat::backtrace(" E#416 inside formatCommonLink"));
            } else {
                return "&quot;$textOut&quot";  // no item id but with a textOut";
            }
        }
        // build a the link to the map
        $itemIdName = "";
        switch ($action) {
            case "line":
                $mapSource = 'lineName';
                $itemIdName = "lineId";
                break;
            case "icon":
                $mapSource = "iconName";
                $itemIdName = "iconId";
                break;
            case "service":
            case "biz":
                $mapSource = "bizName";
                $itemIdName = "bizId";
                break;
            case "trail":
                $mapSource = "trailName";
                $itemIdName = "trId";
                break;
            default:
                print "$errorBeg E#481 unknown action  - formatCommonLink($itemid, $textOut, $action, $target ) $errorEnd";
                $mapSource = 'lineName';
                break;
        }
        if (! empty($itemIdName)) {
            $mapLink = "<a href='/google-map/?$itemIdName=$itemid' target='map' > map </a>\n";
        } else {
            $mapLink = "";
        }
        // build the link to the map
        $itemNameLink = "";
        $itemNameLink .= "$mapLink";
        $itemNameLink .= freeWheel::editViewStart;
        // display the edit pencil icon
        $encodedItemIdName = urlencode($itemIdName);
        $encodedItemId = urlencode($itemid);
        $itemNameLink .= "<a href='https://edit.shaw-weil.com" .
            "/edit-$action/?$encodedItemIdName=$encodedItemId' ";
        // assert either item id or itemName or both contain something
        $itemNameLink .= " target=\"$target\" > \n$freewheelingeasy_pencilIconImage</a>";
        $itemNameLink .= freeWheel::editViewEnd;
        $itemNameLink .= $textOut;
        // now the display thing
        if ($debugCommon) print htmlspecialchars($itemNameLink, ENT_QUOTES) . $eol;
        return $itemNameLink;
    } // end function CommonLink
    /**
     * Formats a milepost value with optional prefix.
     *
     * This function rounds the given milepost to two decimal places, formats it to one decimal place,
     * removes any trailing zeros and decimal points, and optionally prepends a prefix with " MP".
     *
     * @param float  $milepost        The milepost value to format.
     * @param string $milepostPrefix  (Optional) A prefix to prepend to the formatted milepost. Default is an empty string.
     *
     * @return string The formatted milepost, optionally prefixed.
     */
    public static function milePost(string|null $milepostPrefix, $milepost, $numPlaces = 1)
    {
        global $eol;
        //  print " E#232 function milepost ($milepostPrefix $milepost) $eol";
        try {
            $debug = rrwParam::isDebugMode("debugMilepost");
            if ($debug) {
                print "start milePost($milepostPrefix, $milepost, $numPlaces) $eol";
                print rrwFormat::backtrace("E#231 in milePost function: ", 5);
            }
            $steps = "";
            if (empty($milepostPrefix)) {
                $milepostPrefix = "MP";
            }
            if ($milepost == 0)
                return "$milepostPrefix zero";
            if (empty($milepost))
                return "";
            $temp = round($milepost, $numPlaces);    // round to nearest 0.0
            $steps .= "#1-$temp";
            $formatString = "%0" . $numPlaces . "f";
            $temp = sprintf($formatString, $temp);    // format to $numPlaces decimal places
            $steps .= "#2-$temp";
            $temp = rtrim($temp, "0");        // remove trailing 0's
            $steps .= "#3-$temp";
            $temp = rtrim($temp, ".");        // remove trailing decimal point


            if ($milepost == 0)
                $temp = "zero";
            $temp1 = $milepostPrefix;
            $temp1 .= " $temp";
            return $temp1;
        } catch (Exception $e) {
            $msgErr = rrwFormat::backtrace("E#234 in milePost function: " . $e->getMessage(), 5);
            return $msgErr;
        } // end catch
    } // end function milePost($milepost, $milepostPrefix = "")
    public static function milePost2($milepostPrefix, $milepost)
    {
        return self::milePost($milepostPrefix, $milepost, 2);
    } // end function milePost2($milepost, $milepostPrefix = "")
    public static function milePost3($milepostPrefix, $milepost)
    {
        return self::milePost($milepostPrefix, $milepost, 3);
    } // end function milePost3($milepost, $milepostPrefix = "")
    public static function webStatus2bizUsed($webStatus)
    {
        global $wpdbExtra, $rrw_codes;
        if (!is_array(self::$webStatusTranslate)) {
            self::$webStatusTranslate = array();
            $sql = "select code, codeDescription from $rrw_codes where codetype = 'webstatus'";
            $results = $wpdbExtra->get_resultsA($sql);
            foreach ($results as $row) {
                $code = $row["code"];
                $codeDescription = $row["codeDescription"];
                self::$webStatusTranslate[$codeDescription] = $code;
            }
        }
        if (array_key_exists($webStatus, self::$webStatusTranslate))
            return self::$webStatusTranslate[$webStatus];
        else
            return $webStatus;
    } // end function webStatus2bizUsed($webStatus)
    public static function bizUsed2webStatus($bizUsed)
    {
        global $wpdbExtra, $rrw_codes;
        if (!is_array(self::$bizUsedTranslate)) {
            self::$bizUsedTranslate = array();
            $sql = "select code, codeDescription from $rrw_codes where codetype = 'bizused'";
            $results = $wpdbExtra->get_resultsA($sql);
            foreach ($results as $row) {
                $code = $row["code"];
                $codeDescription = $row["codeDescription"];
                self::$bizUsedTranslate[$code] = $codeDescription;
            }
        }
        if (array_key_exists($bizUsed, self::$bizUsedTranslate))
            return self::$bizUsedTranslate[$bizUsed];
        else
            return $bizUsed;
    } // end function bizUsed2webStatus($bizUsed)
    /**
     * Sets the status of a specific record in the database based on the provided type and ID.
     *
     * @param string $status The status to set. If the status is not "done", a trailer will be appended.
     * @param string $type The type of record to update. Can be "access", "biz", "icon", or "trail".
     * @param int $Id The ID of the record to update.
     *
     * @throws Exception If an unknown type is provided.
     */
    public static function setStatus($status, $type, $Id)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $actionDate = new DateTime();
        $actionDate = $actionDate->format("Y-m-d H:i:s");
        if ("done" != $status)
            $trailer = "** $status *****";
        else
            $trailer = "";
        switch ($type) {
            case "access":
                $sql = "update $wpdbExtra->access set accDateNear = '$status $actionDate $trailer' where accId = '$Id'";
                break;
            case "biz":
                $sql = "update $wpdbExtra->business set bizDateRouted = '$status $actionDate $trailer' where bizId = '$Id'";
                break;
            case "iconNear":
                $sql = "update $wpdbExtra->icons set icDateNear = '$status $actionDate $trailer' where iconId = '$Id'";
                break;
            case "iconRouted":
                $sql = "update $wpdbExtra->icons set icDateRouted = '$status $actionDate $trailer' where iconId = '$Id'";
                break;
            case "trailMerge":
                $sql = "update $wpdbExtra->trails set mergeStatus = '$status $actionDate $trailer' where trId = '$Id'";
                break;
            case "trailNear":
                $sql = "update $wpdbExtra->trails set trDateNear = '$status $actionDate $trailer' where trId = '$Id'";
                break;
            case "trailRouted":
                $sql = "update $wpdbExtra->trails set trDateRouted = '$status $actionDate $trailer' where trId = '$Id'";
                break;
            default:
                $msgErr = rrwFormat::backtrace("$errorBeg E#467 '$type' provided to setStatus function.$errorEnd");
                throw new Exception($msgErr);
        }
        $wpdbExtra->query($sql);
        return "";
    } // end function setStatus($status, $type, $Id)
    /**
     * Calculates the number of days since a given date and returns a formatted string.
     *
     * @param string $date The date to compare against the current date.
     * @param int $daysLimit The limit of days to determine if the output should be red. Default is 30.
     * @return string A formatted string representing the number of days since the given date.
     *                Returns "today" if the date is today, a formatted string in red if the days exceed the limit,
     *                or a formatted string of days otherwise.
     */
    public static function daysSince($date, $daysLimit = 30)
    {
        global $eol;
        if (empty($date) || is_null($date))
            return "";
        $dateThen = new DateTime($date);
        $dateDiff = $dateThen->diff(new DateTime());
        $days = $dateDiff->days;
        if ($days == 0)
            return "today";
        if ($days > 365) {
            $years = floor($days / 365);
            $days = "$years years";
        } else {
            if ($days < 10)
                $days = "0$days days";
            else
                $days = "$days days";
        }
        if ($dateDiff->days > $daysLimit)
            return "<font color='red'>$days</font>";  // red if over 30 days
        else
            return $days;
    } // end function daysSince($date)
    public static function DisplayIsTrailHead($value)
    {
        if (is_null($value) || $value == "" || $value == "0") {
            $msgTemp = "not a trailhead";
        } else {
            $msgTemp = "is a trailhead ";
        }
        return $msgTemp;
    }
    /**
     * DisplayServicesForABusiness
     *
     * This function retrieves and displays the services associated with a given business ID.
     * It queries the database for distinct service codes and their descriptions, as well as
     * the Google types associated with the service. It then checks if the business has each
     * service code and constructs a message listing the codes and their descriptions.
     *
     * @param int $svcId The ID of the service to display.
     * @return string A message listing the service codes and their descriptions for the business.
     */
    public static function DisplayServicesForABusiness($svcId)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $sqlCode = "select distinct code, codeDescription from 07rrw_codes_establishment ";
        $codes = $wpdbExtra->get_resultsA($sqlCode);
        //   $msg .= "found " . $wpdbExtra->num_rows . " rows in codes_establishment$eol";
        $sqlGoogle = "select google_types from $wpdbExtra->services where svcId = '$svcId' ";
        $googleTypes = $wpdbExtra->get_var($sqlGoogle);
        $msg .= "Google types: $googleTypes$eol";
        $cnt = 0;
        foreach ($codes as $code) {
            $cnt++;
            $codeFound = $code["code"];
            $sqlBiz = "select $codeFound from $wpdbExtra->services where svcId = '$svcId' ";
            $isCode = $wpdbExtra->get_var($sqlBiz);
            //   $msg .= "$eol for $codeFound " . $wpdbExtra->num_rows . " in services with '$isCode'$eol";
            if (0 == $isCode || empty($isCode) || $wpdbExtra->num_rows == 0)
                continue;   // this business does not have this code
            $desc =  $code["codeDescription"];
            $msg .= "$codeFound $desc, ";
        } // end foreach
        return $msg;
    } // end function DisplayServicesForABusiness($bizId)
    public static function taskCompleted($whichOne)
    {
        global $eol;
        $msg = "";
        $msg .= freewheelingeasy_build_businessAccess::MoveDates2Trails();       // update to most current data
        $msg .= " the $whichOne;e update task is Completed $eol";
        $msg .= "<h1>$whichOne Completed</h1>";
        return $msg;
    } // end function taskCompleted($whichOne)
} // end class Freewheeling_format