<?php
require_once "html_parser.php";
class Mural
{

    public static  function parseHtml($attribute)
    {
        global $eol;
        $msg = "";
        $debugHtml = false;
        $paragraph = "";
        $output = "";
        $extracted = "";
        try {
            ini_set('display_errors', 1);
            $msg .= "hello world from mural.php #5 " . $eol;
            $sourceFile = "https://edit.shaw-weil.com/LindenMural.html";
            $parse =  new rrwParser("");
            $msg = $parse->fetchURLcontents($sourceFile);
            if ($debugHtml) $msg .= $parse->printSomeBuffer("after content read", 1000);
            $msg .= $parse->trimTo("River Side");
            $msg .= $parse->trimPast("</p");
            $msg .= $parse->trimTo("<p");
            $msg .= strlen($parse->buffer) . " characters left in $sourceFile $eol";
            $msg .= $parse->printSomeBuffer(strlen($parse->buffer) . " characters at start $sourceFile");
            $extracted = "";
            $msg .= $parse->trimParagraph($extracted);
            $msg .= $parse->trimTo("<p");
            $msg .= "E#977 first paragraph '$extracted' $eol";      // get first paragraph

            $sectionCnt = 0;
            while (strlen($parse->buffer) > 10) {
                $sectionCnt++;
                if ($sectionCnt > 100) {
                    $msg .= "E#3001 too many sections $eol";
                    break;
                }
                $msg .= $parse->removeTags($extracted);  //remove all tags from extracted text
                $output .= str_repeat(".", 120) . "start of section #$sectionCnt" . $eol;
                $output .= "<h2>$extracted #$sectionCnt </h2>" . $eol;
                $extracted = "";
                $paragraph = "";
                $msg .= $parse->trimParagraph($paragraph);
                $msg .= $parse->trimTo("<p");
                //$msg .= "E#978 first paragraph '$paragraph'";      // get first paragraph
                $paragraphCnt = 0;
                $paragraph2 = "";
                while (strpos($paragraph2, "<span") === false) {
                    //$msg .= "top of while loop " . htmlspecialchars($paragraph2) . $eol;
                    $paragraphCnt++;
                    if ($paragraphCnt > 15) {
                        $msg .= "E#3000 too many paragraphs in section $eol";
                        break;
                    }
                    $paragraph .= $paragraph2;
                    $paragraph2 = "";
                    $msg .= $parse->trimParagraph($paragraph2);
                    if (strlen($parse->buffer) < 10) {
                        $paragraph .= $paragraph2;
                        break;
                    }
                    $msg .= $parse->trimTo("<p");
                }
                $output .= $paragraph . $eol;
                $output .= str_repeat(".", 120) . "section end #$sectionCnt" . $eol;
                // we now have the first paragraph of the ext section
                $extracted = $paragraph2;
            } // end while more buffer
        } catch (Exception $e) {
            $msg .= "  at bottom of mural.php parseHtml() $eol" . $e->getMessage() . $eol;
        }
        $msg .= $output;
        return $msg;
    }
}
