<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2024 - https://royweil.com
 *
 */
class freeWheel
{
    // used to delaminate private output in html files displayed by mapWrite::getFileContents
    const editViewStart = "\n<!-- start wipe -->";
    const editViewEnd = "<!-- end wipe -->\n";
    //    VVVVVVVV option name for number of days to change to biz link to red because out of date
    const rrw_days2redOptionName = "freewheeling_edit_days2red";  //   in various displays
    const estimated_milepost = "estimatedmile";    // text used in onMap name to indicate estimated milepost -See __construct
    // rounding constants
    const latRoundTo = 7;                   // within .017 meter
    const mileRoundTo = 3;                  // within 5.28 feet
    const meterRoundTo = 2;                 // within 1 centimeter
    //
    // distance constants
    const metersPerMile = 1609.33400001;
    const milePerMeter = 0.00062137119224;      // 1/1609.344
    const feetPerMiles =   5280.00000001;
    const milePerFoot = 0.00018939393939;       // 1/5280
    const metersPerDegree = 111132;          // varies with latitude but this is close enough
    const degreePerMeter = 0.000008983152841195; // 1/111320
    public $allowanceForDistanceMove = 3;    // meters, how close a point must be to be considered for moving
    // name of wordPress Options
    const updateOlderBusinesses = "freeWheel_updateOlderBusinesses";
    /*
    private function __construct()
    {
        global $wpdbExtra;
        $sqlOnMap = "select code from $wpdbExtra->codes
                where codetype = 'isonmap' and code like '%est%' order by code";
        $EstimatedOnMap = $wpdbExtra->get_var($sqlOnMap);
        if (freeWheel::estimated_milepost != $EstimatedOnMap)
            throw new Exception("E#233 estimated milepost constant '" . freeWheel::estimated_milepost . "' does not match the value in the database '$EstimatedOnMap'");
    } // end __construct
*/
} // end class freeWheel
class   freeWheeling_edit_setGlobals
{
    static public function map_setConstants()
    {
        global $eol, $errorBeg, $errorEnd, $noteBeg, $noteEnd;
        global $meters2Mile, $feet2Miles;
        global $freewheeling_prebuilt_dire;
        global $freewheeling_prebuilt_dire_production;
        global $freewheeling_pagesPreBuiltUrl;
        global $freewheeling_prebuilt_dire_trails_html; // internal access via file system
        global $freewheeling_pages_trails_html_url;      // external access via web
        global $freewheeling_pages_icon_html_url;       // external access via web for the amenity, google, distance icons always production
        global $freewheeling_pages_milepost_url;        // external access via web for the mile posts icons, maybe dev or production
        global $freewheel_degrees2Meters;
        global $freewheelingeasy_images_URL;
        global $freeWheelingEasy_ipHome;
        global $freewheelingeasy_kml_directory;
        global $freewheeling_kmlStyles_directory;
        global $freewheelingeasy_latLngTolerance;
        global $freewheelingeasy_pencilIconImage;
        global $freewheelingeasy_stylesheet;
        global $freewheeling_www_book_dire;
        // temp variables
        $debugHost = false;
        $prebuiltDireName = "prebuilt";
        $host = get_site_url();
        if ($debugHost) print "host is $host $eol ";
        if (strpos($host, "edit.shaw") !== false) {     // where stuff gets built and tested, then moved to production
            $freewheeling_prebuilt_dire = "/home/pillowan/www-freewheel-dev/$prebuiltDireName";
        } else {
            $freewheeling_prebuilt_dire = "/home/pillowan/www-freewheelingeasy/$prebuiltDireName";
        }
        $freewheeling_pagesPreBuiltUrl = "https://freewheelingeasy.com/$prebuiltDireName";      // external
        $freewheeling_prebuilt_dire_production = "/home/pillowan/www-freewheelingeasy/$prebuiltDireName";
        $freewheeling_prebuilt_dire_trails_html = "$freewheeling_prebuilt_dire_production/trails-html";
        $freewheeling_pages_trails_html_url = "https://freewheelingeasy.com/$prebuiltDireName/trails-html";
        $freewheeling_pages_icon_html_url = "https://freewheelingeasy.com/$prebuiltDireName/";
        $site_url = get_site_url();
        if ($debugHost) print "site_url is $site_url $eol ";
        if (strpos($site_url, "edit") === false && strpos($site_url, "dev") === false) {
            $freewheeling_pages_milepost_url = "https://freewheelingeasy.com/$prebuiltDireName/icon-milepost/";
        } else {
            $freewheeling_pages_milepost_url = "https://dev.freewheelingeasy.com/$prebuiltDireName/icon-milepost/";
        }
        $freewheeling_www_book_dire = "/home/pillowan/www-book";
        if ($debugHost) print "$freewheeling_pagesPreBuiltUrl $eol $freewheeling_prebuilt_dire $eol";
        $uploadInfo = wp_upload_dir();
        // formatting variables used everywhere
        $eol = "<br />\n";
        $errorBeg = "$eol<font color='red'>";
        $errorEnd = "</font>$eol$eol";
        $noteBeg = "<font color='purple'>";
        $noteEnd = "</font>";
        // distance constants
        $meters2Mile = 1609.33400001;
        $feet2Miles =   5280.00000001;
        $freewheel_degrees2Meters = 140000.00001;
        $freewheelingeasy_images_URL = "$freewheeling_pagesPreBuiltUrl/images";
        $freeWheelingEasy_ipHome = "74.109.252.43";
        $freewheelingeasy_kml_directory = $uploadInfo["basedir"] . "/kml";
        $freewheeling_kmlStyles_directory = "/home/pillowan/www-shaw-weil-edit/wp-content/plugins/freewheeling-edit/kmlStyles";
        $freewheelingeasy_latLngTolerance = .00002;
        $freewheelingeasy_pencilIconImage = "<img alt='Edit ' src='$freewheelingeasy_images_URL/penicon.gif' />";
        $freewheelingeasy_stylesheet = "
<link rel='stylesheet' type='text/css' media='all' href='$freewheeling_pagesPreBuiltUrl/amen.css' />";
        return "";
    }
    static public
    function setGlobals($from = "not specified")
    {   /*  set the global variables used in the freewheeling_edit.php
        *  this provide access to the database and various tables.
        */
        global $eol, $errorBeg, $errorEnd;
        // database globals
        global $rrw_codes;
        global $rrw_html, $rrw_icons, $rrw_lines, $rrw_towns, $rrw_regions, $rrw_exceptions, $rrw_trails;
        global $wpdbExtra, $rrw_history, $rrw_business, $rrw_services, $rrw_products;
        global $rrw_trail_routes, $rrw_segments, $rrw_trail_mile, $rrw_trail_rating_set,
            $rrw_route_changes, $rrw_force_access;
        // set table constants
        $msg = "";
        rrwUtil::elapsedTime();  // start the timing clock
        // if (false) $msg .= "Set Globals from $from $eol";
        $msg .= self::map_setConstants();
        // $wpdbExtra = new wpdbExtra();
        $wpdbExtra->show_errors();
        // prefix 0 implies segment data
        $rrw_business = $wpdbExtra->prefix . "1rrw_business";
        $rrw_codes = $wpdbExtra->prefix . "0rrw_codes";
        $rrw_force_access = $wpdbExtra->prefix . "0rrw_force_access";
        $rrw_history = $wpdbExtra->prefix . "1rrw_history";
        $rrw_html = $wpdbExtra->prefix . "1rrw_html";
        $rrw_icons = $wpdbExtra->prefix . "00rrw_icons";
        $rrw_lines = $wpdbExtra->prefix . "00rrw_lines";
        $rrw_products = $wpdbExtra->prefix . "3rrw_products";
        $rrw_towns = $wpdbExtra->prefix . "00rrw_towns";
        $rrw_trail_mile = $wpdbExtra->prefix . "4rrw_trail_mile";
        $rrw_trail_rating_set = $wpdbExtra->prefix . "0rrw_trail_rating_set";
        $rrw_trail_routes = $wpdbExtra->prefix . "0rrw_trail_routes";
        $rrw_trails = $wpdbExtra->prefix . "00rrw_trails";
        $rrw_route_changes = $wpdbExtra->prefix . "0rrw_route_changes";
        $rrw_segments = $wpdbExtra->prefix . "0rrw_segments";
        // if (substr($from,0,1) != "x")
        // print " &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ---From $from - set rrw_segments to $rrw_segments <br />";
        // prefix 1 implies basic business data
        $rrw_services = $wpdbExtra->prefix . "1rrw_services";
        // prefix 2 implies combinations of location and business data
        // prefix 3 implies location data derived from kml files
        //      $rrw_mileposts = $wpdbExtra->prefix . "4rrw_mileposts";
        $rrw_regions = $wpdbExtra->prefix . "00rrw_regions";
        $rrw_exceptions = $wpdbExtra->prefix . "0rrw_exceptions";
        // prefix 07 implies a sql view
        // prefix 4 implies a temporary table. recreated before each use
        return $msg;
    }
    static public function rrw_updateTheMenu()
    {
        $msg = "";
        $thisAmen = get_user_option("freewheeling_amenityTrail");
        $thisAmenPlus = str_replace(" ", "+", $thisAmen);
        $msg .= "
<script>
    var element = document.getElementById( 'menu-menu-1' );
    var text1 = element.innerHTML;
    var text2 = text1.replace( 'Belmar', '$thisAmenPlus' );
    var text3 = text2.replace( 'Belmar', '$thisAmen' );
    element.innerHTML = text3;
</script>
";
        return $msg;
    }
    public static function formatCommentsOnly()
    {
        return  "<h1 style='color:red' > You have been taken to an special
            website for editing the data</h1><br />Please enter a comment in the field
            about the change that you think should be made. Someone will review. If they
            imap_rfc822_write_address we will send the result of that review.";
    }
    public static
    function notAllowedToEdit($what, $trailId = "")
    {
        global $eol, $errorBeg, $errorEnd;
        $debugNotAllowed = false;
        $allowed = self::allowedToEdit($what, $trailId);
        if ($debugNotAllowed) print "AllowedToEdit returned '$allowed' $eol";
        if ($allowed) {
            if ($debugNotAllowed) print "notAllowedToEdit returned false $eol";
            return false;
        } else {
            if ($debugNotAllowed) print "notAllowedToEdit returned true $eol";
            return true;
        }
    }
    public static function allowedToComment()
    {
        return false;
    }
    /**
     * Determines if the current user is allowed to edit a specific resource.
     *
     * Checks user permissions through multiple methods: WordPress post editing capability,
     * freeWheeling edit privileges, or a configured allowed parameter. If the user lacks
     * permission, displays a login form and returns false.
     *
     * @param string $what The resource or action the user wants to edit (required, must not be empty)
     * @param string $trailId Optional. The trail ID to check for specific trail edit privileges (future feature)
     *
     * @return bool True if the user is allowed to edit the specified resource, false otherwise
     */
    public static function allowedToEdit($what, $trailId = ""): bool
    {
        global $eol, $errorBeg, $errorEnd;
        $debugAllowedToEdit = rrwParam::Boolean("debugAllowedToEdit");
        //
        try {
            if ($debugAllowedToEdit) print "I#399 allowedToEdit( $what , $trailId ) $eol";
            if (empty($what))
                return false;   // must tell us what you want to edit
            $allowed = rrwParam::String("allowed");
            $ip = $_SERVER['REMOTE_ADDR'];
            if ($debugAllowedToEdit) print 'I#240 current_user_can( "edit_posts" )' .
                current_user_can("edit_posts") . $eol;
            if (current_user_can("edit_posts")) {
                if ($debugAllowedToEdit) print "I#241 allowedToEdit because of edit posts $eol";
                return true;
            } elseif (freeWheeling_edit_setGlobals::isAllowedToEditAny())
                return true;
            elseif (!empty($allowed))
                return true;
            else {
                print freeWheeling_edit_setGlobals::showLoginForm($what);
                return false;
            }
        } catch (Exception $e) {
            throw new Exception("#2275 in allowed to edit: " . $e->getMessage());
        }
    }
    public static function showLoginForm($msg1)
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $passWoodHelp = "I do not know/lost my password,
                <a href='https://edit.shaw-weil.com/wp-login.php?action=lostpassword'>
                    help me change it</a> ";
        $msg .= "$errorBeg E#2276 you need permission to $msg1 $errorEnd $passWoodHelp or login$eol$eol";
        $msg .= "<div class='wp_login_form'>";
        $args = array(
            'echo' => false,
            'label_username' => 'Email Address',
        );
        $msg .= wp_login_form($args);
        $msg .= $passWoodHelp;
        return $msg;
    }
    static public function isAllowedToEditAny()
    {
        if (current_user_can("administrator"))
            return true;
        else
            return false;
    }
    static public function getTrailInfo($trailOrGroupID)
    {
        // trailId      maybe trailId, or grpID
        //              may have slashes (/) which remove
        // trailIdLower make it all lower case
        //  returns a trailInfo array that contains some of the trail database information
        global $eol, $errorBeg, $errorEnd;
        $debugGetTrail = rrwParam::isDebugMode("debugGetTrail", false);
        try {
            if ($debugGetTrail) print "getTrailInfo( $trailOrGroupID ) $eol";
            if (empty($trailOrGroupID)) {
                $trailInfo = freeWheeling_edit_setGlobals::trailInfoEmpty("", "Western PA and Eastern Ohio Trails");
                return $trailInfo;
            }
            $trailId = trim(stripslashes($trailOrGroupID));
            $trailIdLower = strtolower($trailId);
            if ($debugGetTrail) print "going for the tocTable filename $eol";
            $tocTableFile = freewheeling_WriteUp::fullNameFromShortName("data", "tocTable.json");
            if ($debugGetTrail) print " tocTable filename = $tocTableFile $eol";
            $tocTableOutput = file_get_contents($tocTableFile);
            $trailInfo = json_decode($tocTableOutput, true);
            if (!is_array($trailInfo))
                throw new Exception("E#2277 Json decode did not make an array $eol $tocTableOutput");
            // is it the exact trail id
            if (array_key_exists($trailIdLower, $trailInfo)) {
                $result = $trailInfo[$trailIdLower];
                if ($debugGetTrail) print "Found an exact match to '$trailId' returning " . rrwUtil::print_r($result, true, 'fileinfo E#2275 ');
                return $result;
            }
            // not the trail id, maybe the trail name, or indesign filename
            foreach ($trailInfo as $key => $trail) {
                if (strcasecmp($trail["trName"], $trailId) == 0)
                    return $trailInfo[$key];
                if (strcasecmp($trail["inddFileName"], $trailId) == 0)
                    return $trailInfo[$key];
            }
            if ($debugGetTrail) {
                print "$errorBeg E#2278 No match in the table $errorEnd looking for '$trailId' <table>";
                print rrwFormat::HeaderRow("Trail Name", "Html File Name", "Trail Id");
                foreach ($trailInfo as $key => $trail) {
                    print rrwFormat::cellRow($trail["trName"], $trail["inddFileName"], $trail["trailId"]);
                }
                print "</table>";
            }
            if ($debugGetTrail) print "No match found in toc table $eol";
            $trailInfo = freeWheeling_edit_setGlobals::trailInfoEmpty("", "Western PA and Eastern Ohio Trails");
            return $trailInfo;
        } catch (Exception $e) {
            print rrwFormat::backtrace("from get trail nfo");
            throw new Exception("$errorBeg E#2279 end of getTrailInfo" . $e->getMessage() . $errorEnd);
        }
    } // end getTrailInfo
    public static
    function trailInfoEmpty($trId = 'no trail id', $trName = 'no trail name')
    {
        $temp = array(
            "north" => "42.6",
            "south" => "38.76",
            "east" => "-75.8",
            "west" => "-81.8",
            "trname" => $trName,
            "trName" => $trName,
            "trailId" => $trId,
            "labelNorth" => 39,
            "labelEast" => -77.5,
            "sqlWhere" => "trailId = '$trId'",
            "inddFileName" => "",
        );
        return $temp;
    }
} // end