/*		Freewheeling Easy Mapping Application
 *
 *		A collection of routines for display of trail maps and amenities
 *
 *		copyright Roy R Weil 2019 - https://royweil.com
 *
 *

*/
var debugLines = false;
var fileString; // contents of the input file desc, style, range, points
var iiBeg; // steps though the fileString
var xmlhttpLine; // read trail lines text file
var infoWindowsOpen = [];
//  set in the calling parameter to initlize
function processLine(checkLengthOfData, cntRead) {
    // process one line of data, hopefully of type checkLengthOfData

    if (fileString.length < 3000) {
        var debugProcessLine = false;
    } else {
        var debugProcessLine = false;
    }
    var lookLen = checkLengthOfData.length;
    if (debugProcessLine) {
        logLine("processLine:checkLengthOfData, length,filelength: " + checkLengthOfData + ", "
            + lookLen + "," + fileString.length);
        logLine("iiBeg, test var : " + iiBeg + ", "
            + fileString.substring(iiBeg, iiBeg + lookLen));
    }
    var testvar = fileString.substring(iiBeg, iiBeg + lookLen);
    if (debugProcessLine) {
        logLine("testvar: " + testvar);
    }
    if (testvar !== checkLengthOfData) {
        logLine("E#1588 line #" + cntRead + " looking for " + checkLengthOfData);
        logLine(" Unknown keyword start at " + iiBeg + ", found '" + testvar + "'");
        logLine("e r r o r file not found");
        logLine(fileString.substring(iiBeg, iiBeg + 200));
        if ("readfle failure" == fileString.substring(0, 15)) {
            _freewheelingmap_readNextFileAndOutput(); //try next file
            return "readfile failure";
        }
        throw "E#1589 Unknown keyword start at " + iiBeg + ", found '" + testvar + "'";
    }
    var iiLineEnd = fileString.indexOf("\n", iiBeg);
    if (debugProcessLine) {
        logLine("I#1590 line end is: " + iiLineEnd);
    }
    var result = fileString.substring(iiBeg + lookLen, iiLineEnd);
    iiBeg = iiLineEnd + 1;
    if (debugProcessLine) {
        logLine("I#1580 found the data for " + checkLengthOfData + " == " + result);
    }
    return result.trim();
}
function _freewheelingmap_processtrailLines() // here is where the work is done
{

    if (xmlhttpLine.readyState !== 4)
        return; // do nothing until we have the complete files
    if (xmlhttpLine.status !== 200) { // got some sort of error .
        logLine("I#1591 E R R O R xmlhttpLine.status = " + xmlhttpLine.status
            + " - while processing the trail file");
        return false;
    }
    var debugLines = true;
    var debugSelections = false;
    var debugCoordinatesSplit = false;
    var lineSymbolDot = { // setup dotted lines
        path: 'M 0,0 0,1',
        strokeOpacity: 1,
        scale: 4
    };
    var lineSymbolDotHeavy = { // setup dotted lines
        path: 'M 0,0 0,1',
        strokeOpacity: 1,
        scale: 8
    };
    var lineSymbolDash = { // setup dashed lines
        path: 'M 0,0 0,1',
        strokeOpacity: 1,
        scale: 4
    };
    var lineSymbolDashHeavy = { // setup dashed lines
        path: 'M 0,0 0,1',
        strokeOpacity: 1,
        scale: 8
    };

    fileString = xmlhttpLine.responseText;
    var iiEnd = fileString.length;
    if (iiEnd < 200) {
        logLine("I#1492 E R R O R size of text is : " + iiEnd);
    }
    var ii;
    iiBeg = 0;
    var cntRead = 0;
    var cntShown = 0;
    var totalPoints = 0;

    var filename = processLine("Title:", cntRead);
    logLine("I#1593 -------------------------------------------  processing file " + filename + ", length " + iiEnd + "  ------------ ");
    if (filename === "readfile failure") {
        logLine("E#1600 the file had a read error");
        _freewheelingmap_readNextFileAndOutput(); // try  for the next file
        return false;
    }
    if (debugSelections) {
        logLine(" I#1601 -------------------------- ");
        logLine("search route weights'" + freeWheeling_route_weights + "'");
        logLine("line search routes '" + freewheeling_line_search + "'");
        logLine("business search description '" + freewheeling_business_search + "'");
    }
    var cntReadThisFile = 0;
    var cntDisplayThisFile = 0;
    while (iiBeg < iiEnd - 10) {
        cntRead++;
        cntReadThisFile++;
        var description = processLine("Desc:", cntRead); // includes trail name, surface, line name
        if (description.indexOf("DebugEnabler ") != -1) {
            debugSelections = true;
        } else {
            debugSelections = false;
        }
        //        if (cntRead < 50)  // debug selections
        //           debugSelections = true;    // turn on debug for first 50 lines;
        if (description.indexOf("DebugEnabler") < 0) {
            debugLines = false;
            debugCoordinatesSplit = false;
        } else {
            debugLines = false;
            debugCoordinatesSplit = false;
        }
        if (debugLines) {
            logLine("I#1594 xx description: " + description);
            logLine("iiBeg after return: " + iiBeg);
        }
        var style = processLine("Style: ", cntRead);
        var range = processLine("Range: ", cntRead);
        var routes = processLine("Routes:", cntRead);
        var coords = processLine("Points:", cntRead);
        if (debugSelections) {
            logLine("I#1595 description to search " + description);// + " --Desc -" + description.substring(0, 50));
        }
        // ===================================================== line section occurs here
        // assert freewheeling_line_search is set to lower case in freewheelingMap.php
        // assert routes are always lower case
        specialWeight = 0;;
        // looking for a specific line in the zz-line.txt file
        if ("zz-lines.txt" == filename && freewheeling_line_search != "") {
            if (description.indexOf(freewheeling_line_search) == -1) {
                if (debugSelections)
                    logLine("I#1603 not this '" + description + "'");
                continue; // requested a selection of line(s), this is not it
            }
        } else {
            if (debugSelections)
                logLine("I#1581 found " + description + "specialWeight = 10");
            specialWeight == 10;
        }
        // looking for a specific business in the trail2bizOne.txt fil
        if ("trail2bizOne.txt" == filename && freewheeling_line_search != "") {
            if (routes.indexOf(freewheeling_line_search != "") == -1) {
                continue; // requested a selection of line(s), this is not it
            }
        } else {
            specialWeight == 10;

        }
        // zz_county.txt always displays if it is in the list

        // we have found something to display
        if (debugSelections) {
            logLine("I#1583 Displaying item " + description + "  " + color + "  " + weight + "  " + lineType);
        }
        cntDisplayThisFile++;
        var path = [];
        if (coords.startsWith("enc:") == true) {
            path = coords.substring(4);
            path = google.maps.geometry.encoding.decodePath(path);
            if (debugCoordinatesSplit) {
                logLine("I#1596 Encoded length = " + path.length);
                logLine("start is " + path.substr(0, 30));
                logLine(path[0]);
                logLine("found " + path.length + " points ");
            }
            totalPoints += path.length;
        } else {
            if (debugCoordinatesSplit) {
                logLine("I#1584 xxcoords: " + coords);
            }
            // build coordinate path
            var coordArr = coords.split(" ");
            if (debugCoordinatesSplit) {
                logLine("I#1585 split got  : " + coordArr.length + "pairs");
            }
            path = [];
            for (ii = 0; ii < coordArr.length; ii++) {
                var coors = coordArr[ii].split(",");
                if (debugCoordinatesSplit) {
                    logLine("I#1597 split got  : " + coors.length + "numbers");
                }
                if (coors.length === 3) {
                    var coord = new google.maps.LatLng(coors[1], coors[0]);
                    path.push(coord);
                    if (debugCoordinatesSplit) {
                        logLine("I#1598 path push : " + coors[0] + ", " + coors[1]);
                    }
                    totalPoints++;
                }
            }
        } // end 				logLine("xxstyle: " + style);
        var color = style.substr(0, 7);
        var lineType = style.substr(7, 3);
        var weight = style.substr(10, 2);
        //   --------------------------------------------------------adjust line weights
        if (debugLines) {
            logLine("I#1599 Displaying item " + description + "  " + color + "  " + weight + "  " + lineType);
        }
        if (lineType == "gap") {
            specialWeight = FreewheelingEasy_GapWeight;
        }
        if ("" != freeWheeling_route_weights && routes.includes(freeWheeling_route)
            && description.indexOf(freeWheeling_route_weights) != -1) {
            // asked for a specific route "epta"
            specialWeight = 8;
            if (debugSelections)
                logLine("I#1586 found route '" + freeWheeling_route_weights + "' in '" + routes);
        }
        weight = Math.max(weight, specialWeight);
        if (debugLines) {
            logLine("I#1587 xxstyle: " + style + "  xxrange: " + range);
            logLine("xxcolor: " + color + "  xxlinetype: " + lineType);
            logLine("xxweight: " + weight + "  xxlinetype: " + lineType);
        }
        // -------------------- variables are set - create the line and popup
        var polyThing;
        var clickable = false;
        var ParkingInfoWindow = new google.maps.InfoWindow({
            content: "loading...",
            zIndex: 50,
            PixelOffset: (10, 10)
        });
        if (lineType == 'cou' || lineType == 'obs') {
            var white = "#ffffffff";
            polyThing = new google.maps.Polygon({ // a county boundry
                map: mapScreen,
                infowin: ParkingInfoWindow,
                path: path,
                desc: description,
                strokeOpacity: 1,
                strokeWeight: 2,
                strokeColor: "#AED6F1",
                fillColor: color,
                fillOpacity: 0.9,
                zIndex: 10,
                clickable: false,
            })
            clickable = true;
        } else {
            polyThing = new google.maps.Polyline({
                map: mapScreen,
                infowin: ParkingInfoWindow,
                path: path,
                desc: description,
                strokeOpacity: 1,
                strokeColor: color,
                strokeWeight: weight,
                zIndex: 20,
            });
            clickable = true;
        }
        if (lineType == 'dot') {
            if (weight > 6) {
                polyThing.setOptions({
                    icons: [{
                        icon: lineSymbolDotHeavy,
                        offset: '0',
                        repeat: '25px'
                    }]
                });
            } else {
                polyThing.setOptions({
                    icons: [{
                        icon: lineSymbolDot,
                        offset: '0',
                        repeat: '14px'
                    }]
                });
            }
            polyThing.setOptions({
                strokeWeight: 25,
                strokeOpacity: 0
            });
        }
        if (lineType == 'das') {
            if (weight > 6) {
                polyThing.setOptions({
                    icons: [{
                        icon: lineSymbolDashHeavy,
                        offset: '0',
                        repeat: '25px'
                    }]
                });
            } else {
                polyThing.setOptions({
                    icons: [{
                        icon: lineSymbolDash,
                        offset: '0',
                        repeat: '14px'
                    }]
                });
            }
            polyThing.setOptions({
                strokeWeight: 25,
                strokeOpacity: 0
            });
        }
        if (lineType == 'obs') {
            polyThing.setOptions({
                fillOpacity: .8
            });
        }
        if (weight == 0) {
            polyThing.setOptions({
                strokeOpacity: 0
            });
        }
        cntShown++;
        if (clickable) {
            google.maps.event.addListener(polyThing, 'mouseover', function (ev) {
                if (debugLineHover) {
                    logLine("I#1582 into the polyThing mouseover");
                    console.dir("event data " + JSON.stringify(ev));
                    logLine("lat" + ev.latLng.lat);
                }
                infoWindowsOpen.forEach(closeinfo);
                var ParkingInfoWindow = new google.maps.InfoWindow({
                    content: "loading...",
                    zIndex: 50,
                    PixelOffset: (10, 10)
                });
                ParkingInfoWindow.setPosition(ev.latLng);
                ParkingInfoWindow.setContent(this.desc);
                ParkingInfoWindow.open(mapScreen, this);
                infoWindowsOpen.push(ParkingInfoWindow); // save it away for close
                setTimeout('infoWindowsOpen.forEach (closeinfo)', '4500');
                if (debugLineHover) {
                    logLine("I#1592 exit the polyThing hover");
                }
            });
        }
        if (cntRead > 25000) {
            logLine("read over 2500 lines, something may be wrong");
            return;
        }

    } // end while
    logLine("I#2261 " + cntReadThisFile + " Times through the while loop, Displayed " + cntDisplayThisFile + " of " + filename);
    //		map.fitBounds(bounds);
    var a = totalPoints / cntShown;
    var a = a.toFixed(2);
    if (freewheeling_debugLineTotals) {
        logLine("read " + cntRead + ", displayed " + cntShown + " lines");
        logLine("total " + totalPoints + " points " + a + " pnt/line");
    }
    logif(debugBounds, "Final bounds " + bounds);
    _freewheelingmap_readNextFileAndOutput();
} // end of _freewheelingmap_processtrailLines()

function buildPathArray(coords, description) {
    if (description.indexOf("debugEnabler") < 0) {
        var debugCoordinatesSplit = false;
    } else {
        var debugCoordinatesSplit = false;
    }
    var pathTemp = [];
    if (coords.substring(0, 7) === "Encoded") {
        pathTemp = "enc:" + coords.substring(8);
    } else {
        if (debugCoordinatesSplit) {
            logLine("xxcoords: " + coords);
        }
        // build coordinate pathTemp
        var coordArr = coords.split(" ");
        if (debugCoordinatesSplit) {
            logLine("split got  : " + coordArr.length + "pairs");
        }
        pathTemp = [];
        for (ii = 0; ii < coordArr.length; ii++) {
            var coors = coordArr[ii].split(",");
            if (debugCoordinatesSplit) {
                logLine("split got  : " + coors.length + "numbers");
            }
            if (coors.length === 3) {
                var coord = new google.maps.LatLng(coors[1], coors[0]);
                bounds.extend(coord);
                if (false && debugBounds) {
                    logLine("bounds " + bounds);
                }
                pathTemp.push(coord);
                if (debugCoordinatesSplit) {
                    logLine("path push : " + coors[0] + ", " + coors[1]);
                }
            }
        }
    } // end 				logLine("xxstyle: " + style);
    return pathTemp;
}
function closeinfo(item) {
    if (debugLineHover) {
        logLine(" into closeinfo");
    }
    item.close();
}
