/*		Freewheeling Easy Mapping Application
 *
 *		A collection of routines for display of trail maps and amenities
 *
 *		copyright Roy R Weil 2019 - https://royweil.com
 *

      rweil routines to display the freewheeling easy google map
    at the bottom your script, include the following;
<script type='text/javascript' src='//freewheelingeasy.com/trailmap/markercluster.js' > </script>
<script  type='text/javascript'>
    resizeMapCanvas2Page ('mapCanvas', heightPad, widthPad, north, south, east, west);
    google.maps.event.addEventListener('load', initialize('mapCanvas') );
</script>
";
*/

class freewheeling_cluster_group {
    constructor(name, makercluster, minZoom, maxZoom) {
        this.markers = makercluster.markers_;
        return new freewheeling_marker_group(name, this.markers, minZoom, maxZoom)
    }
} //  end class freewheeling_markerGroup
class freewheeling_marker_group {
    constructor(name, makers, minZoom, maxZoom) {
        logLine("cluster construct " + name);
        this.name = name;
        this.markers = makers;
        this.maxZoom = maxZoom;
        this.minZoom = minZoom;
        this.visibility = false;
        this.numMarkers = this.markers.length;
    }
    doVisible() {
        var debugVis = true;
        var zoomlevel = mapScreen.getZoom();
        var vis = true;
        var ii;
        if (zoomlevel > this.maxZoom || zoomlevel < this.minZoom)
            vis = false;
        if (this.visibility !== vis) { // aleady that way
            if (false) {
                logif(debugVis, this.name + "- " + this.numMarkers)
                logif(debugVis, "current = " + this.visibility + ", future = " + vis);
            }
            setZoomStatus("zoom level = " + zoomlevel + this.name + " - setting " + vis);
            for (ii = 0; ii < this.numMarkers; ii++) {
                try {
                    this.markers[ii].setVisible(vis);
                } catch (err) {
                    logErr("E#2229 setvis " + ii);
                    logErr(this.markers[ii]);
                }
            }
            this.visibility = vis;
        }
        setZoomStatus("zoom level = " + zoomlevel);
    }
} // end class freewheeling_markerGroup

var markerGroups = []; //an array of freewheeling_markerGroup
function logLine(msg) {
    console.log(msg);
    return true;
}
function logErr(msg) {
    console.error(msg);
    return true;
}

function logif(debug, msg) {
    if (debug)
        console.log(msg);
    return true;
}
var debugBounds = false;
var debugfileNames = false;
var debugLineHover = false; // used in lines.js
var debugLines = false;
var debugParking = false;
var mapScreen; // the googlemap thing
var iconParkCluster;
var bounds; // dispaly limits of the current google map
var ctaLayer;
var xmlhttpLine; // read trail lines text file
var parkingvisibla = false;
var isWordPress; // used to create the correct URL for accessing data and icons
var MarkersAreSetup = false; // parking icons not set up
var processType = "not set";
//  set in the calling parameter to initlize
function freewheeling_reportWindowSize() {
    if (false) {
        var ma = document.getElementById("masthead").style.height;
        ma = window.innerHeight - ma;
        logLine("newHeight = " + (window.innerHeight - ma));
        logLine("window size - " + window.innerHeight + ", " + window.innerWidth);
        logLine("masthead thing" + document.getElementById("masthead").style.height);
        logLine("masthead size - " + ma);
    }
}

function _freewheelingmap_ResizeMapCanvas2Page(canvasId, heightPad, widthPad,
    north, south, east, west) {

    debugBounds = false;
    logif(debugBounds, "starting _freewheelingmap_ResizeMapCanvas2Page");
    var newHeight = parent.innerHeight;
    logif(debugBounds, 'new height is ' + newHeight);
    newHeight = newHeight - heightPad;
    newHeight = newHeight + 'px';
    if (newHeight === 'NaNpx') {
        newHeight = '750px';
    }
    if (debugBounds) {
        logLine('new height is ' + newHeight);
        logLine("Map Canvas is " + canvasId);
    }
    var canvas = document.getElementById(canvasId);
    if (canvas === null) {
        alert("Canvas is null, something wrong with _freewheelingmap_ResizeMapCanvas2Page(canvasId, heightPad, widthPad, north, south, east, west)  ");
        return;
    }
    document.getElementById(canvasId).style.height = newHeight;
    var newWidth = parent.innerWidth;
    logif(debugBounds, 'new Width is ' + newWidth);
    newWidth = newWidth - widthPad;
    newWidth = newWidth + 'px';
    if (newWidth === 'NaNpx') {
        newWidth = '700px';
    }
    if (debugBounds) {
        logLine('new Width is ' + newWidth);
    }
    document.getElementById(canvasId).style.width = "100%";
    var swCorner = new google.maps.LatLng(south, west);
    var neCorner = new google.maps.LatLng(north, east);
    bounds = new google.maps.LatLngBounds(swCorner, neCorner);
    logif(debugBounds, 'bounds in  _freewheelingmap_ResizeMapCanvas2Page ' + bounds);

} // end of resizeMapCanvas2Page
var exclude = [];
function turnit(item, label) {
    // save selection in cookies
    // redisplay with the new parameters
    exclude.length = 0;
    if (!document.getElementById("Parking").checked) exclude.push("park");
    if (!document.getElementById("indoor").checked) exclude.push("Lodging");
    if (!document.getElementById("camp").checked) exclude.push("Camping");
    if (!document.getElementById("restaurant").checked) exclude.push("Restaurant");
    if (!document.getElementById("bar").checked) exclude.push("Bar");
    if (!document.getElementById("grocery").checked) exclude.push("Grocery");
    if (!document.getElementById("bikeshop").checked) exclude.push("Bikeshop");
    logLine("turnoff " + exclude);
    processZoom();
}
function _freewheelingmap_Initialize(canvasId, WordPressSelect, title) {
    // Normal parking icon

    logLine("_freewheelingmap_Initialize:title: " + title);

    var titleAd = "<table width='100%'><tr><td>&nbsp;</td><td style='font-size:24pt; font-weight:bold'>" + title + "</td><td style='font-size:8pt; test-align:right'>"
        + "This map brought to you by the book "
        + "<a href='https://freewheelingeasy.com' class='freewheeling-amenities-external' > "
        + "Freewheeling Easy in Western Pennsylvania</a> . &nbsp; &nbsp; &nbsp; "
        + "&copy <a href='https://brokenlinks.royweil.com/' class='freewheeling-amenities-external'>"
        + "Roy Weil Consultng</a>.</td></tr><tr><td colspan='2' style='font-size:8pt;' >"
        + "Display - "
        + "<input type='checkbox' checked id='Parking' "
        + "onclick='turnit(this, \"park\")'>parking &nbsp; &nbsp; "
        + "<input type='checkbox' checked id='indoor' "
        + "onclick='turnit(this, \"indoor\")'>Indoor lodging &nbsp; &nbsp; "
        + "<input type='checkbox' checked  id='camp' "
        + "onclick='turnit(this,\"camp\")'>Campground &nbsp; &nbsp; "
        + "<input type='checkbox' checked id='restaurant'"
        + "onclick='turnit(this, \"restaurant\")' >Restaurant &nbsp; &nbsp; "
        + "<input type='checkbox' checked id='bar'"
        + "onclick='turnit(this, \"bar\")' >Bar &nbsp; &nbsp; "
        + "<input type='checkbox' checked id='grocery'"
        + "onclick='turnit(this, \"grocery\")' >Grocery &nbsp; &nbsp; "
        + "<input type='checkbox' checked  id='bikeshop'"
        + "onclick='turnit(this, \"bike\")'>bike shop &nbsp; &nbsp; </td></tr></table> \n";
    isWordPress = WordPressSelect;
    if (debugBounds) {
        logLine("starting _freewheelingmap_Initialize");
    }
    // set up the map
    var mapCenter = bounds.getCenter();
    if (debugBounds) {
        logLine(' Center ' + mapCenter.toString());
    }
    var mapOptions = {
        //		center: mapCenter,
        gestureHandling: 'greedy',
        scaleControl: true,
        scaleControl: "bottom-left",

        // streetViewControl: true,
        //		mapTypeId: google.maps.MapTypeId.TERRAIN
    };
    if (debugParking) {
        logLine("creat a map variable");
    }
    mapScreen = new google.maps.Map(document.getElementById(canvasId), mapOptions);
    logLine(bounds);
    logLine(mapOptions);
    mapScreen.fitBounds(bounds);
    if (freeWheeling_kmlmap.length > 5) { // set in the url for extra mapping
        logLine("I#2221 _freewheelingmap_Initialize:kmlmap " + freeWheeling_kmlmap);
        var kmlLayer = new google.maps.KmlLayer({
            url: freeWheeling_kmlmap,
            suppressInfoWindows: true
        });
    } // end of if freeWheeling_kmlmap.length
    mapScreen.addListener('zoom_changed', () => {
        processZoom();
    });
    //    mapScreen.addListener('zoom_changed', processZoom);
    window.onresize = freewheeling_reportWindowSize();
    // scriptDire is set in the freewheelingmap.php as a print "var "
    if (debugfileNames) {
        logLine("scriptDire: " + scriptDire);
    }
    var mapBounds = mapScreen.getBounds();
    logLine(mapBounds);
    _freewheelingmap_readNextFileAndOutput();
    _freewheelingmap_readAndOutputLegend();
    var mapBounds = mapScreen.getBounds();
    logLine(mapBounds);
} // end of initalize

function setZoomStatus(msg) {

    var statusloc = document.getElementById("zoomlevel");
    statusloc.innerHTML = msg;
    if (freewheeling_pagesPreBuiltUrl.indexOf("dev") > 0) {
        statusloc.style.display = "block";
    } else {
        statusloc.style.display = "none";
    }   //  end indexOf
}
function processZoom() {
    //      logLine("zoom_changed");
    var zoomlevel = mapScreen.getZoom();
    setZoomStatus("zoom level = " + zoomlevel);
    var ii;
    var debug_zoom = false;
    if (zoomlevel === undefined)
        return; // not yet ready to change zoom
    logif(debug_zoom, "there are " + markerGroups.length + " groups of markers");
    for (ii = 0; ii < markerGroups.length; ii++) {
        //       logif(debug_zoom, markerGroups[ii] );
        logif(debug_zoom, "Zoom limits is " + markerGroups[ii].maxZoom + "-"
            + markerGroups[ii].minZoom);
        var howMany = markerGroups[ii].numMarkers;
        logif(debug_zoom, "markerGroups [" + ii + "] has " + howMany + "points");
        markerGroups[ii].doVisible();
    }
    return true;
} // end processZoom
function getNextFile() {
    logif(freewheeling_debug_fileload, "I#2225 start with "
        + FreeWheelingEasy_linesSource);
    if (FreeWheelingEasy_linesSource.trim() === "") {
        logif(freewheeling_debug_fileload, "I getNextFile empty string");
        return ["", "done"];
    }
    var next = FreeWheelingEasy_linesSource.split(",");
    var thisOne = next.shift(); // remove first element
    FreeWheelingEasy_linesSource = next.join();
    logif(freewheeling_debug_fileload, "I leftovers "
        + FreeWheelingEasy_linesSource);
    var fileAndType = thisOne.split("|");
    var filename = freewheeling_getDataUrl + fileAndType[0];
    filename = filename + ".txt";
    var type = fileAndType[1];
    logif(freewheeling_debug_fileload, "I filename " + filename);
    logif(freewheeling_debug_fileload, "I fileType " + type);
    return [filename, type];
}
function _freewheelingmap_readNextFileAndOutput() {
    // start the trail lines

    var dataFile;
    freewheeling_debug_fileload = false;
    // processType is a global variable, referenced by parking.js
    [dataFile, processType] = getNextFile();
    logif(freewheeling_debug_fileload, "I#2240 readNextFileandOutput:dataFile " + dataFile + " processType -" + processType);
    if ("done" === processType) {
        logif(freewheeling_debug_fileload, " finished");
        return; // re are done, noting more to display
    }
    if (window.XMLHttpRequest) {
        xmlhttpLine = new XMLHttpRequest(); // code for IE7+, Firefox, Chrome, Opera, Safari
    } else {
        xmlhttpLine = new ActiveXObject("Microsoft.XMLHTTP"); // code for IE6, IE5
    }
    if (processType == "line") {
        xmlhttpLine.onreadystatechange = _freewheelingmap_processtrailLines;
    } else {
        xmlhttpLine.onreadystatechange = _freewheelingmap_processMileposts;
    }
    console.log("I#1654 requesting file " + dataFile);
    xmlhttpLine.open("GET", dataFile);
    xmlhttpLine.send();
}
function _freewheelingmap_readAndOutputLegend() {
    const legendControlDiv = document.createElement('div');
    const legendImage = document.createElement('img');
    legendImage.src = freewheelingeasy_legendFile;
    legendImage.style.width = 'auto';
    legendImage.style.height = freewheelingeasy_legendFileHeight;
    legendImage.hidden = true;
    legendImage.onclick = function () {
        legendImage.hidden = !legendImage.hidden;
        legendKey.hidden = !legendKey.hidden;
    };
    legendControlDiv.appendChild(legendImage);
    const legendKey = document.createElement('img');
    legendKey.src = freewheelingeasy_legendKeyFile;
    legendKey.style.width = 'auto';
    legendKey.style.height = '50px';
    legendKey.onclick = function () {
        legendImage.hidden = !legendImage.hidden;
        legendKey.hidden = !legendKey.hidden;
    };
    legendControlDiv.appendChild(legendKey);
    mapScreen.controls[google.maps.ControlPosition.BOTTOM_LEFT].push(legendControlDiv);
} // end of readAndOutputLegend

// document.write ( "<form><input type='button' onClick='doSomething();' value='Do Something'></form>");
function _freewheelingmap_doSomething() {
    var z1 = mapScreen.getZoom();
    mapScreen.setCenter(mapCenter);
    mapScreen.setZoom(12);
    if (debugBounds) {
        logLine(z1);
    }
    logLine(ctaLayer.getStatus());
    logLine(ctaLayer.getDefaultViewport());
    logLine(ctaLayer.getMetadata());
}
