/*		Freewheeling Easy Mapping Application
 *
 *      A collection of routines for display of trail maps and amenities
 *
 *		copyright Roy R Weil 2019 - https://royweil.com
 *
 */
//	rweil routines to output paring icons google map
// called from call back of a xmllhttpRequest in freewheelingeasy_map.js

function _freewheelingmap_processMileposts () {
    var allDebug = false;
    var debugMilePostData = allDebug;
    var debugIconURL = allDebug;
    var debugViewRange = allDebug;
    var debugListDisplayed = allDebug;
    var debugExclude = allDebug;
    var debugIconType = allDebug;
    var infoWindowsOpen = [];

    if (xmlhttpLine.readyState !== 4)
        return; // do nothing until we have the complete files
    if (xmlhttpLine.status !== 200) { // got some sort of error .
        console.log("E#1565 xmlhttpLine.status = " + xmlhttpLine.status
            + " - while processing the trail file");
        return false;
    }
    if (freewheeling_debug_fileload) {
        console.log("E#1566 Start points");
    }
    fileString = xmlhttpLine.responseText;
    if (fileString.length < 50) {
        console.log("E#1567 the input files is less than 59 characters ");
        console.log(fileString);
    }
    var iiTitle1 = fileString.indexOf("<title") + 7;
    var iiTitle2 = fileString.indexOf("</title");
    var title = fileString.substring(iiTitle1, iiTitle2);
    var iiFileName = title.lastIndexOf(".");
    var filename = title.substr(0, iiFileName);
    console.log(" --------------------------------------   ");
    console.log(title);
    var iiBody = fileString.indexOf("<body");
    iiBody = fileString.indexOf(">", iiBody);
    fileString = fileString.substr(iiBody + 1);
    var data1 = fileString.split("|");
    console.log("data1.length " + data1.length);
    console.log(filename + ",  " + data1[0]);

    var itemCnt = 0; // number of items per line in the file
    for (iiFirst = 0; iiFirst < 20; iiFirst = iiFirst + 1) {
        if (debugMilePostData) {
            console.log("x search " + iiFirst + " - " + data1[iiFirst]);
        }
        if (data1[iiFirst] === "x") {
            itemCnt = iiFirst;
            break;
        }
    }
    if (itemCnt === 0) {
        console.log("E R R O R  E#1560 did not find an x in " + title);
        console.log(fileString.substr(1, 200));
        console.log(" ===================== ");
        itemCnt = 10;
    }
    if (debugMilePostData) {
        console.log("Milepost item cnt is " + itemCnt);
        for (ii = 0; ii < 44; ii = ii + 1) {
            console.log(ii + " - " + data1[ii]);
        }
    }
    var minClusterZoom = 9;
    var maxClusterZoom = 100;
    var ShouldRangeBeChecked = false;
    var clusterURL = freewheeling_pages_icon_html_url + "/icon-google/mile.png";
    var clusterZIndexTop = 999; // undefined MAX ZIndex + 10;
    var clusterZIndex = clusterZIndexTop;
    var notClustered = true;
    /*
    var allow = document.getElementById("allowdrag");
    if (allow === null || typeof allow === "undefined" || allow.value === "undefined") {
        allow = "NotAllowed";
    }
    var allowed = false;
    console.log("before allow.value is " + allowed.valueOf());
    if (allow.value == true) {
        allowed.value = true;
    } else {
        allowed.value = true;
    }
    console.log("after allow.value is " + allowed.valueOf());
    console.log("file process type = " + processType);
    */
    switch (processType) {
        case "mile":
        case "mile10":
            minClusterZoom = 10;
            break;
        case "mile05":
            minClusterZoom = 11;
            break;
        case "mile01":
            minClusterZoom = 12;
            break;
        case "launch":
            clusterURL = freewheeling_pages_icon_html_url + "/icon-google/flag.png";
            minClusterZoom = 13;
            clusterZIndex = clusterZIndexTop - 1;
            break;
        case "park":
            clusterURL = freewheeling_pages_icon_html_url + "/icon-google/park.png";
            minClusterZoom = 12;
            clusterZIndex = clusterZIndexTop - 3;
            notClustered = false;
            break;
        case "boat":
            clusterURL = freewheeling_pages_icon_html_url + "/icon-google/camp.png";
            minClusterZoom = 12;
            clusterZIndex = clusterZIndexTop - 3;
            break;
        case "camp":
            clusterURL = freewheeling_pages_icon_html_url + "/icon-google/camp.png";
            minClusterZoom = 12;
            clusterZIndex = clusterZIndexTop - 3;
            break;
        case "dino":
            clusterURL = freewheeling_pages_icon_html_url + "/icon-google/dino.png";
            minClusterZoom = 11;
            ShouldRangeBeChecked = true;
            clusterZIndex = clusterZIndexTop - 4;
            notClustered = false;
            break;
        case "amen":
        case "location":
            if (debugExclude) console.log("exclude" + exclude);
            minClusterZoom = 11;
            ShouldRangeBeChecked = true;
            clusterZIndex = clusterZIndexTop - 4;
            notClustered = false;
            break;
        default:
            logErr("E#1561 unknown type " + processType);
            break;
    } // end switch for adding markers
    var cntInfo = 0;
    var cntSkipName = 0;
    var cntSkipDupLatLng = 0;
    var cntSkipDuplicate = 0;
    var cntSkipLatZero = 0;
    var cntSkipLaunch = 0;
    var cntSkipNoMiles = 0;
    var cntSkipRange = 0;
    var markers_milepost = [];
    var milepostLngShift;
    if (title.indexOf("amen.txt")) {
        milepostLngShift = .00005;
    } else {
        milepostLngShift = 0;
    }
    // init to test for points outside the window
    mapBounds = mapScreen.getBounds();
    if ('undefined' == typeof mapBounds) {
        var latMaxLimit = 90;
        var latMinLimit = -90;;
        var lngMaxLimit = 90;
        var lngMinLimit = -90;
    } else {
        var latMaxLimit = mapBounds.getNorthEast().lat() + 0.3;
        var latMinLimit = mapBounds.getSouthWest().lat() - 0.3;
        var lngMaxLimit = mapBounds.getNorthEast().lng() + 0.3;
        var lngMinLimit = mapBounds.getSouthWest().lng() - 0.3;
    }
    // save last point, to avoid duplicate  - assumes point are i lat,lng order
    var latPast = 200;
    var lngPast = 200;
    if (debugViewRange) {
        console.log("north limit is " + latMaxLimit + ", min " + latMinLimit);
        console.log("eastWest limit is " + lngMaxLimit + ", min " + lngMinLimit);
    }
    var ii;
    var imageExtension = "png";
    var iconBlankURL = freewheeling_pages_icon_html_url + "/icon-milepost/imgBlank.jpg";
    var iconParkURL = freewheeling_pages_icon_html_url + "/icon-amenities/park." + imageExtension;
    var iconCampURL = freewheeling_pages_icon_html_url + "/icon-amenities/Camping.png";
    var iconDinoURL = freewheeling_pages_icon_html_url + "/icon-google/dino.png";
    var iconDinoRedURL = freewheeling_pages_icon_html_url + "/icon-google/dinoRed.png";
    console.log("bizNameRequest " + freewheeling_bizNameRequest);
    if (debugIconURL) {
        console.log("processType " + processType);
        console.log("iconBlankURL " + iconBlankURL);
        console.log("iconParkURL " + iconParkURL);
    }
    nextMarker: for (ii = itemCnt + 1; ii < data1.length; ii = ii + itemCnt) {
        //			console.log("ii is " + ii + "-- " + data1[ii + 4]);
        if (data1[ii].indexOf("body></html") !== -1) {
            break;
        }
        cntInfo++;
        var trailId = data1[ii + 0];
        trailId = trailId.substr(1);
        var lat = data1[ii + 1];
        var lng = data1[ii + 2];
        var bizName = data1[ii + 3];
        var dinoName = data1[ii + 3];
        var amenityName = data1[ii + 3];
        amenityName = amenityName.replace(/ /g, "-");
        var iconstyle = data1[ii + 4];
        if (iconstyle === undefined) {
            console.log("E#1562 iconstyle === undefined " + bizName);
        }
        var description = data1[ii + 5];
        if (debugMilePostData) {
            console.log(ii + " LatLng " + lat + ", " + lng);
        }
        if (lat == "" || lng == "") {
            cntSkipLatZero++;
            continue; // reject missing latitude, longitude
        }
        if (isNaN(lat) || isNaN(lng)) {
            console.log("The latitude " + lat + "or longitude " + lng
                + " is not a number. now what? ");
            for (kk = ii; kk < ii + 20; kk = kk + 1) {
                console.log(data1[kk]);
            }
            break;
        }
        if (false) {
            console.log(cntInfo + " _ " + description + " -" + lat + ">" + latMaxLimit + "," + lat + "<"
                + latMinLimit + "," + lng + ">" + lngMaxLimit + "," + lng + "<" + lngMinLimit);
        }
        if (ShouldRangeBeChecked && (lat > latMaxLimit || lat < latMinLimit || lng > lngMaxLimit || lng < lngMinLimit)) {
            cntSkipRange++;
            continue; // reject not in view
        }
        if (lat == latPast && lng == lngPast) {
            cntSkipDupLatLng++;
            continue; // reject already displayed something here
        }
        latPast = lat;
        lngPast = lng;
        var milepostMilage = data1[ii + 6];
        if (milepostMilage === undefined) {
            milepostMilage = "";
        }
        var trail = data1[ii + 7];
        var isTrailHead = data1[ii + 8];
        var plusCode = data1[ii + 9];
        if (milepostMilage == "99.000") {
            debugIconURL = true;
        } else {
            debugIconURL = false;
        }
        // --------------------------------------------- Got data, should re reject
        //	console.log(lat + "," + lng + "," + milepostMilage + "," + bizid);
        if (debugListDisplayed) console.log("display " + bizName);
        var markerOptions;
        var myLatLng = new google.maps.LatLng(lat, lng); // + milepostLngShift);
        var dragState = true;

        switch (processType) {
            case "launch":
                if (milepostMilage.length < 1) {
                    cntSkipNoMiles++;
                    continue;
                }
                icon = iconBlankURL;
                markerOptions = {
                    //                map: mapScreen,
                    icon: icon,
                    label: milepostMilage,
                    title: bizName + "-" + trail + " - " + description
                };
                break;
            case "dino":
                switch (iconstyle) {
                    case "dinoRed.png":
                        iconURL = iconDinoRedURL;
                        break;
                    case "dino.png":
                        iconURL = iconDinoURL;
                        break;
                    default:
                        console.log("Unknown icon style of " + iconstyle);
                        break;
                } // end icon switch
                markerOptions = {
                    //                map: mapScreen,
                    icon: iconURL,
                    title: bizName,
                    label: "",
                    trailId: trailId,
                    dinoName: dinoName,
                    amenityName: amenityName,
                    pano: milepostMilage,

                }; // end make options
                break;

            case "mile10":
            case "mile05":
            case "mile01":
                var fileIcon = freewheeling_pages_milepost_url + iconstyle;
                if (debugMilePostData) {
                    console.log("map iconstyle " + iconstyle);
                    console.log("map freewheeling_pages_icon_html_url " + freewheeling_pages_icon_html_url);
                    console.log("map icon " + fileIcon);
                }
                markerOptions = {
                    //                map: mapScreen,
                    position: myLatLng,
                    icon: fileIcon,
                    title: bizName + "-" + this.trail + " - " + description
                };
                break;
            case "park":
                markerOptions = {
                    //                map: mapScreen,
                    icon: iconParkURL,
                    title: bizName + " near MP " + milepostMilage + " on " + trail + " - " + description,
                    amenityName: amenityName,
                    label: ""
                };
                break;
            case "camp":
                if (cntInfo < 5) {
                    //   logLine( myLatLng  + bizName);
                }
                markerOptions = {
                    //                map: mapScreen,
                    icon: iconCampURL,
                    title: bizName + " near MP " + milepostMilage + " on " + trail + " - " + description,
                    amenityName: amenityName,
                    label: ""
                };
                break;
            case "trailcenter":
                markerOptions = {
                    //                map: mapScreen,
                    icon: iconParkURL,
                    title: " MP " + milepostMilage + " on " + trail + " - " + description,
                    trailName: dinoName,
                    label: description
                };
                break;
            case "amen":
            case "location":
                if (freewheeling_bizNameRequest != '') {
                    if (bizName.indexOf(freewheeling_bizNameRequest) < 0) {
                        cntSkipName++;
                        continue; // reject - only what one business
                    }
                    console.log("displaying icon" + iconstyle);
                }
                switch (iconstyle) { // this is looking a
                    case "park":
                        iconstyle = "park.png";
                        break;
                    case "launch":
                        cntSkipLaunch++;
                        continue; // ignore it
                    default:
                        // do nothing - the associated icon should be visible
                        break;
                }
                iconstyle = iconstyle.replace("jpg", imageExtension);
                // code here to use exclude
                var iconURL = freewheeling_pages_icon_html_url + "/icon-amenities/" + iconstyle;
                if (iconURL.includes("undef")) {
                    console.log("E#1563 " + bizName + " - " + iconURL);
                }
                markerOptions = {
                    //                map: mapScreen,
                    icon: iconURL,
                    title: "near MP " + milepostMilage + " on " + trail + " - " + description,
                    amenityName: amenityName,
                    label: ""
                };
                break;
            case "line":
                logErr("E#2255 E R R O R into mileposts with a line ");
                return;
            default:
                logErr("E887 E R R O R into mileposts with unknown type " + processType);
                return;
        } // end switch
        // common maker options
        //   markerOptions["gmpDraggable"] = true;
        //markerOptions["draggable"] = true;
        markerOptions["map"] = mapScreen;
        markerOptions["position"] = myLatLng;
        markerOptions["visible"] = false;
        markerOptions["zIndex"] = clusterZIndex;
        for (jj = 0; jj < markers_milepost.length; jj = jj + 1) {
            if (markers_milepost[jj].positions == myLatLng) {
                console.log("duplicate" + bizname + " - " + markers_milepost.title);
                cntSkipDuplicate++;
                continue;
            }
        }
        var marker = new google.maps.Marker(markerOptions);
        if (debugIconURL) {
            console.log("markers_milepost.length" + markers_milepost.length);
            console.log("marker" + markerOptions);
        }

        if (debugIconType) {
            console.log("icon process type " + processType);
        };
        switch (processType) { // handle clickable markers that launch a page
            case "dino":
                buildupPanorama(marker);
                //in the dinomitedays/pano plugin
                // cases marker to become clickable to open panorama window
                break;
            case "amen":
                marker.addListener('click', function () {
                    var url = "https://freewheelingeasy.com/prebuilt/amenities/" + this.amenityName + ".html'";
                    window.open(url, "mapIt");
                });
                break;
            default:
            // only the above icons are clickable.
        } // end switch (processid)
        markers_milepost.push(marker);
    } // end for (ii = itemCnt + 1; ii < data1.length; ii = ii + itemCnt) {
    // assert markerList is built as a collection of markers

    if (notClustered) {
        item = new freewheeling_marker_group(processType, markers_milepost, minClusterZoom, maxClusterZoom);
    } else {
        markerCluster = new MarkerClusterer(mapScreen, markers_milepost);
        markerCluster.ignoreHidden_ = true;
        markerCluster.averageCenter_ = true;
        markerCluster.gridSize_ = 30;
        var white = "#ffffff";
        var red = "#ff0000";
        var icon = {
            url: clusterURL,
            height: 25,
            width: 25,
            textSize: 17,
            textColor: red,
            fontWeight: "bold"
        };
        var anchor = new google.maps.Point(-25, -25);
        markerCluster.styles_[0] = icon;
        markerCluster.styles_[1] = icon;
        markerCluster.styles_[2] = icon;
        markerCluster.styles_[3] = icon;
        markerCluster.styles_[4] = icon;
        logLine(markerCluster);
        item = new freewheeling_cluster_group(processType, markerCluster, minClusterZoom,
            maxClusterZoom);
        /*
            console.log("markerCluster");
            //      logLine(markerGroups[ii]);
            logLine(markerGroups[ii].maxZoom);
            //    logLine(markerGroups[ii].makerList);
            logLine(markerGroups[ii].makerList.length);
        */
    } //  end  if (notClustered)
    markerGroups.push(item);
    processZoom();
    cntDisplay = cntInfo - cntSkipLatZero - cntSkipName - cntSkipRange - cntSkipDuplicate
        - cntSkipDupLatLng - cntSkipLaunch - cntSkipNoMiles;
    console.log(processType + " read " + cntInfo
        + "\n Name skipped " + cntSkipName
        + "\n ranged skipped " + cntSkipRange
        + "\n duplicate skipped " + cntSkipDuplicate
        + "\n lat/lng duplicate Skipped " + cntSkipDupLatLng
        + "\n lat.lng zero skipped " + cntSkipLatZero
        + "\n launch skipped " + cntSkipLaunch
        + "\n No miles skipped " + cntSkipNoMiles
        + "\n displayed " + cntDisplay
        + "\n markers_milepost.length " + markers_milepost.length);
    _freewheelingmap_readNextFileAndOutput(); // get the next file, or display
} // end function _freewheelingmap_processMileposts
