<?php
//      Freewheeling Easy Mapping Application
//		A collection of routines for display of trail maps and amenities
//  	copyright Roy R Weil 2019 - https://royweil.com
/*
Plugin Name: FreeWheelingEasy Map
Plugin URI:  https://plugins.RoyWeil.com/freewheeling-easy-map
Description: create shortcode for display of a Google Map with our (Roy's) trail lines
Author:      Roy Weil
Author URI:  https://RoyWeil.com
Donate URI: https://plugins.royweil.com/donate
Requires at least: 6.0.1
Tested up to: 6.8.2
depends: rrw-utilities-common
License: private
Version: 3.5.2.466
Text Domain: freewheelingeasy-map
Domain Path: /lang
*/
//
global $trId, $trName, $trDoc, $trDate, $trVol, $trTime, $trNorth;
$trDoc = array();
// in the www-include directory
require_once "freewheelingeasy-wpdpExtra.php";
require_once "rrwFormat.php";
require_once "rrwParam.php";
// // in this directory
require_once "constants.php";
// require_once "map-api.php";      //replaced because google changed billing
require_once "map-api-2025.php";
require_once "map-buildpages.php";
require_once "map-segments.php";
require_once "pano/updatePanorama.php";
require_once "map-write.php";
// in the includes-map directory
//require_once "includes-map/polyline_inc.php";
class FreeWheeling_DisplayMap
{
    public static function displayMap($attr)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        global $freewheelingeasy_images_URL;
        global $freewheeling_pagesPreBuiltUrl;
        global $freewheeling_pages_icon_html_url;
        global $freewheeling_pages_milepost_url;
        global $freewheel_degrees2Meters;
        global $degreePerMeter, $metersPerMile;
        global $meters2Mile;
        $msg = "";
        try {
            ini_set("display_errors", true);
            error_reporting(E_ALL);
            $debugMap = rrwParam::isDebugMode("debugMap", false);
            if ($debugMap) {
                ini_set('upload_max_size', '256M');
                ini_set('display_errors', true);
            }
            $html = "";         // the main body of the page, with no debug
            $headerStyleScript = "";        //
            if ($debugMap) $msg .= rrwUtil::print_r($_POST, true, "Post it");
            $msg .= freeWheeling_edit_setGlobals::setGlobals("display map");
            $headerStyleScript .= "
		<style >
	.freewheeling-amenities-external {
	background-position: right center;
	background-repeat: no-repeat;
	background-image: linear-gradient(transparent, transparent), url('data:image/svg+xml,%3C%3Fxml%20version%3D%221.0%22%20encoding%3D%22UTF-8%22%3F%3E%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2210%22%20height%3D%2210%22%3E%3Cg%20transform%3D%22translate%28-826.429%20-698.791%29%22%3E%3Crect%20width%3D%225.982%22%20height%3D%225.982%22%20x%3D%22826.929%22%20y%3D%22702.309%22%20fill%3D%22%23fff%22%20stroke%3D%22%2306c%22%2F%3E%3Cg%3E%3Cpath%20d%3D%22M831.194%20698.791h5.234v5.391l-1.571%201.545-1.31-1.31-2.725%202.725-2.689-2.689%202.808-2.808-1.311-1.311z%22%20fill%3D%22%2306f%22%2F%3E%3Cpath%20d%3D%22M835.424%20699.795l.022%204.885-1.817-1.817-2.881%202.881-1.228-1.228%202.881-2.881-1.851-1.851z%22%20fill%3D%22%23fff%22%2F%3E%3C%2Fg%3E%3C%2Fg%3E%3C%2Fsvg%3E');
	padding-right: 13px;
}
</style>
";
            $scriptDire = plugins_url("") . "/freewheeling-map";
            if ($debugMap) $msg .= "scripts output now get parameters $eol";
            //		$headerStyleScript .= rrwUtil::print_r($_POST, true, "Post");
            //		$headerStyleScript .= rrwUtil::print_r($savedAttributes, true, "attributes");
            if ($debugMap) {
                $msg .= rrwUtil::print_r($_GET, true, "get");
                $msg .= rrwUtil::print_r($_POST, true, "post");
                $msg .= rrwUtil::print_r($attr, true, "attributes");
            }
            // --------------------------------------------                                            input to determine boundaries of the map
            $debugInput = rrwParam::isDebugMode("debugInput", false);
            $dino = rrwParam::Boolean("dino", $attr);
            $latitude = rrwParam::number("latitude", $attr);
            $longitude = rrwParam::number("longitude", $attr);
            $lineName = "";     //gets set if there is a line id input
            $iconId = freeWheelParam::icon($attr, false);
            $lineId = freeWheelParam::line($attr);
            $orbits = rrwParam::String("orbits", $attr);
            if ($debugInput) print "orbits no stop  = $orbits $eol";
            $spokes = rrwParam::String("spokes", $attr);
            if ($debugInput) print "spokes = $spokes $eol";
            $trailId = freeWheelParam::trail($attr, false);
            if ($debugInput) print "trailId = $trailId $eol";
            $bizId = freeWheelParam::business($attr, false);
            $bizNameRequest = freeWheelParam::get_businessName($attr, false);
            $fountainLat = 40.441823;
            $fountainLong = -80.012775;
            $circleScript  = "";
            $spokeScript = "";

            if ($dino) {
                // -------------------------------------------------------------------------------------set boundaries for dinosaur map
                $iconId = "";
                $lineId = "";
                $trailId = "";
                $bizId = "";
                $bizNameRequest = "";
                $obits = "";
                $north = 40.45993;
                $south = 40.42123;
                $east = -79.93846;
                $west = -80.02305;
                $titleLine  = "Dinosaurs of Pittsburgh";
                $routesRequestedSql = "";
                $routesRequestedList = "";      // list of things to unt for n the description
            } else {
                // --------------------------------------------------------------------------------------- set boundaries in case of no input
                if ($debugMap) $msg .= "I#2268 no input $eol";
                $thisTrail = freeWheeling_edit_setGlobals::getTrailInfo("all");
                if ($debugMap) $msg .= rrwUtil::print_r($thisTrail, true, "I#2269 results getinfo for thisTrail");
                $north = $thisTrail["north"];
                $south = $thisTrail["south"];
                $east = $thisTrail["east"];
                $west = $thisTrail["west"];
                $titleLine = htmlspecialchars($thisTrail["trName"], ENT_QUOTES);
                $routesRequestedSql = $thisTrail["sqlWhere"];
                $routesRequestedList = "";      // list of things to unt for n the ddescrion
                // must likely these will grt overwritten by a specific request.
            }
            if ($debugMap) $msg .= "input data 2 : dino = $dino,  trailId = $trailId, latitude = $latitude, longitude = $longitude,
                            iconid = $iconId, lineId = $lineId, bizId = $bizId, bizName = $bizNameRequest $eol";
            if ($debugMap) $msg .= "input: bizId = $bizId,  bizNameRequest = $bizNameRequest, iconId = $iconId $eol";
            //                                                      range items
            $kmlmap = rrwParam::String("kmlmap", $attr);        // some additional random map
            $route = rrwParam::String("route", $attr);          // a route request like "epta", "gap",
            //                                                      other
            $showInstructions = rrwParam::Boolean("showInstructions", $attr);
            //----------------------------------------------------  that is all the input now determine what to display
            //  ----------------------------------------------- ------------------- iset boundaries in the order of latitude,, icon, line, business, trail. planet walk, pgh spokes

            if (!empty($latitude)) {
                $iiComma = strpos($latitude, ",");   // assume latitude and longitude are separated by a comma
                if ($iiComma === false) {
                    if ($longitude == 0) {
                        $msg .= "$errorBeg E#2224 latitude and longitude must be separated by a comma, input was '$latitude' $errorEnd";
                        throw new Exception($msg);
                    }
                } else {
                    $latitude = trim($latitude);
                    $longitude = substr($latitude, $iiComma + 1);
                    $latitude = substr($latitude, 0, $iiComma - 1);
                }
                $inc = 1000 / $freewheel_degrees2Meters;
                if ($debugMap) print "I#464 latitude = '$latitude', longitude = '$longitude', Inrument = $inc $eol";
                $north = $latitude + $inc;
                $south = $latitude - $inc;
                $east = $longitude + $inc;
                $west = $longitude - $inc;
                $titleLine  = "Around $latitude, $longitude";
                $routesRequestedSql = "";
            }
            if (!empty($iconId)) {     // ----------------------------------- point
                if ($debugMap) $msg .= "I#2223 iconId = $iconId $eol";
                $routesRequestedSql = "select latitude, longitude, iconName titleLine from $wpdbExtra->icons where (iconId = '$iconId' )";
                $msg .= self::setRange($routesRequestedSql, $north, $south, $east, $west, $titleLine);
            }
            if (!empty($lineId)) {     // ----------------------------------- line
                $lineName = freeWheelParam::get_lineName($attr);
                if ($debugMap) $msg .= "I# 822 lineName = $lineName, lineId = $lineId $eol";
                $routesRequestedSql = "select ((latStart +latEnd)/2) latitude, ((lngStart + lngEnd)/2)  longitude, linename titleLine
                        from $wpdbExtra->lines where lineId = '$lineId' or lineName = '$lineName' ";
                $msg .= self::setRange($routesRequestedSql, $north, $south, $east, $west, $titleLine);
                $routesRequestedList = "'$lineName'";
            }
            if (!empty($bizNameRequest)) {
                $sqlBizId = $wpdbExtra->prepare1arg("select accBizId from $wpdbExtra->access where accBizName = %s", "$bizNameRequest");
                //   $sqlBizId = "select accBizId from $wpdbExtra->access where accBizName = '$bizNameRequest'";
                $bizId = $wpdbExtra->get_var($sqlBizId);
            }
            $OneBizFileName = "trail2bizOne";   // even though it says one, may produce more than one
            if (!empty($bizId)) {
                // ------------------------------------------------------------------------------------------------- business
                if ($debugMap) $msg .= "bizNameRequest = $bizNameRequest, bizId = $bizId $eol";
                $routesRequestedSql = "select trail2bizroute, accBizName, trailmilepostprefix, trailmilepost, metersToTrail
                         from $wpdbExtra->access
                         where (accBizId = '$bizId' ) and metersToTrail =
                         (select min(meterstotrail) from $wpdbExtra->access
                         where (accBizId = '$bizId') )";
                if ($debugMap) $msg .= "$errorBeg E#2230 looking for bussness access $errorEnd  $routesRequestedSql $eol";
                $recs = $wpdbExtra->get_resultsA($routesRequestedSql);
                if ($recs === false) {
                    $msg .= "$errorBeg E#2207 failure looking for bussness access $errorEnd  $routesRequestedSql $eol";
                    throw new Exception($msg);
                }
                if (count($recs) == 0) {
                    $msg .= "$errorBeg E#2233 no records found for #$bizId or $bizNameRequest $errorEnd";
                    return $msg;
                } else {
                    $titleLine = htmlspecialchars($recs[0]["accBizName"] . " - ", ENT_QUOTES);
                }
                foreach ($recs as $rec) {
                    $metersToTrail = $rec["metersToTrail"];
                    $titleLine .= htmlspecialchars($recs[0]["accBizName"] . " - ", ENT_QUOTES);
                    $titleLine .= rrwFormat::milePostText($rec["trailmilepost"], $rec["trailmilepostprefix"]) . ", $metersToTrail meters from trail  ";
                }
                $sqlLines = "select concat(trailmilepostPrefix, trailmilepost, ', meters to Trail ', metersToTrail) trname,
                        trailmilepost trailId, accBizName lineName, accBizId lineId,
                        '' routes, '#oneBiz' mapstyle, trail2bizroute pointList
                        from $wpdbExtra->access
                        where accBizId = '$bizId' and
                                metersToTrail = (select min(metersToTrail) from $wpdbExtra->access
                                where accBizId = '$bizId') ";
                if ($debugMap) $msg .= "sqlLines = $sqlLines $eol";
                $OneBizFileName = "trail2bizOne";   // even though it says one, may produce more than one
                $msg .= createLineText::createLinesTxtFile($sqlLines, "$OneBizFileName.txt");
                $coords = $rec["trail2bizroute"];       // last one is used to get the range
                $result = freewheeling_kml_common::findMinMax($coords);
                $north = $result["north"] + 0.003;
                $south = $result["south"] - 0.003;
                $east = $result["east"] + 0.003;
                $west = $result["west"] - 0.003;
                $_GET["allmileposts"] = "true";
            }
            if (!empty($trailId)) {
                //$msg .= "$errorBeg I#2201 looking for trail info for $trailId $errorEnd $eol";
                // ----------------------------------------------------------------------------------- trailname/trailId
                if ($debugMap) $msg .= "I#2200 trailId = getTrailInfo($trailId) $eol";
                $thisTrail = freeWheeling_edit_setGlobals::getTrailInfo($trailId);
                if ($debugMap) $msg .= rrwUtil::print_r($thisTrail,  true, "results getinfo for '$trailId'");
                $north = $thisTrail["north"];
                $south = $thisTrail["south"];
                $east = $thisTrail["east"];
                $west = $thisTrail["west"];
                $titleLine = htmlspecialchars($thisTrail["trName"], ENT_QUOTES);
                $routesRequestedSql = $thisTrail["sqlWhere"];
            }
            //  ----------------------------------------------  in the order of latitude, dinosaurs, icon, line, business, trail

            if (!empty($orbits)) {
                // ----------------------------------------------------------------------------------- orbits
                $debugOrbits = rrwParam::Boolean("debugOrbits");
                print "orbits processing = $orbits $eol";
                if ($debugOrbits) $msg .= "orbits = $orbits $eol";
                $AU2meters = 149597870.7;
                if ($debugOrbits) $msg .= "AU2meters = $AU2meters $eol";
                $homeDistanceMiles = 4.179;
                $homeDistanceMeters = $homeDistanceMiles * $meters2Mile;
                if ($debugOrbits) $msg .= "homeDistanceMiles = $homeDistanceMiles, homeDistanceMeters = $homeDistanceMeters $eol";
                $sqlFountain = "select $fountainLat latitude, $fountainLong longitude, 'Point State Park' titleLine";
                $msgTemp = self::setRange($sqlFountain, $north, $south, $east, $west, $titleLine, .03);
                if ($debugOrbits) $msg .= $msgTemp;
                $routesRequestedSql  = "";              // no trail lines
                // based the ratio of orbits on distance from fountain to home equals earth distance from sun
                $homeDistanceMiles = 4.179;
                $homeDistanceMeters = $homeDistanceMiles * $meters2Mile;
                $sqlEarthdistance = "select inner_au /2 + outer_au /2 distance
                         from $wpdbExtra->orbits where name = 'Earth'";
                $ditanceEarchAU = $wpdbExtra->get_var($sqlEarthdistance);
                $ratio = $homeDistanceMeters / $ditanceEarchAU;
                $distanceEarthhomeMeters = $ditanceEarchAU * $ratio;
                $distanceEarthhomeMiles = $distanceEarthhomeMeters / $meters2Mile;
                if ($debugOrbits) $msg .= "ditanceEarchSunAU = $ditanceEarchAU, Ratio = $ratio, home meters = $distanceEarthhomeMeters,
                         home miles = $distanceEarthhomeMiles $eol";
                $sqldistanceAU = "select inner_au /2 + outer_au /2 distance, name
                         from $wpdbExtra->orbits  order by inner_au";
                $recs = $wpdbExtra->get_resultsA($sqldistanceAU);
                foreach ($recs as $rec) {
                    $distanceAU = $rec["distance"];
                    $name = $rec["name"];
                    if ($distanceAU == 0)
                        $distanceMeters = 27.8;
                    else
                        $distanceMeters = $distanceAU * $ratio;
                    $distanceMiles = $distanceMeters / $meters2Mile;
                    if ($debugOrbits) $msg .= " $name - distanceAU = $distanceAU, distanceMeters = $distanceMeters,
                                                distanceMiles = $distanceMiles $eol";
                    $circleScript .= "
                    const cityCircle$name = new google.maps.Circle({
                            strokeColor: '#FF0000',
                            strokeOpacity: 0.35,
                            strokeWeight: 6,
                            map: mapScreen,
                            fillColor: '#FF0000',
                            fillOpacity: 0,
                            center: myLatlng,
                            radius: $distanceMeters,
                            });
                    ";
                } // endforeach
                // this code sets the range bounds and title line based on what the user requested
                // default (set here) is centered around the Pittsburgh fountain
                // setRange expect a sql statement to find the center point and title, optional parameter for distance in degrees
                $sqlFountain = "select $fountainLat latitude, $fountainLong longitude, 'Point State Park' titleLine";
                $msgTemp = self::setRange(
                    $sqlFountain,
                    $north,
                    $south,
                    $east,
                    $west,
                    $titleLine,
                    .03
                );
                $msg .= $msgTemp;
            } // end of orbits
            if (!empty($spokes)) { //the spokes ootof pitsburgh
                $spokeLengthDegrees = 5  * $metersPerMile * $degreePerMeter; // 5 miles
                $sqlFountain = "select $fountainLat latitude, $fountainLong longitude, 'Point State Park' titleLine";
                $msgTemp = self::setRange($sqlFountain, $north, $south, $east, $west, $titleLine, $spokeLengthDegrees);
                // this may get overwritten by other input
                $msg .= $msgTemp;
                //TODO create the spokes
            } // end of spokes

            $headerStyleScript .= "
<!-- scripts added by the freewheeling Easy plugin  ========================== -->
<noscript><p>Google maps requires that JavaScript be enabled.</p></noscript>
<script type='text/javascript' src='$scriptDire/freewheelingeasy-map.js' > </script>
<script type='text/javascript' src='$scriptDire/freewheelingeasy-points.js' > </script>
<script type='text/javascript' src='$scriptDire/freewheelingeasy-lines.js' > </script>
<script type='text/javascript' src='$scriptDire/pano/buildPanorama.js' > </script>
<script type='text/javascript' src='$scriptDire/markerclustererplus-4.0.1.min.js'></script>

<script src= 'https://maps.googleapis.com/maps/api/js?key=AIza" . "SyAuNXpAR_dsGK8Q03QhEHowq93qVISqUUo&v=weekly' > </script>
<script type='text/javascript' src='https://unpkg.com/@googlemaps/markerclusterer@2.0.15/dist/index.min.js'></script>
<!-- end of scripts added by the freewheeling Easy plugin
-->
	";
            $headerStyleScript .= "
            <div id='zoomlevel'>zoom level goes here  </div><br />
            <div id='mapCanvas' style='width:100px; height:100px; margin:0; padding:5px' >
            one moment while we calculate the line work
            </div>
<script>
            /* vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv- map setup */
        var freewheeling_logStyles = 'Color:#ff0000;';
        var freewheeling_debug_fileload = false;
        var freewheeling_debugLineTotals = false;
        var freewheeling_debugIconTotals = false;
        var freewheeling_getDataUrl = '" .
                plugins_url("/freewheeling-map/freewheelingeasy-getfile.php/?file=/data/") . "'
        var freewheeling_pagesPreBuiltUrl = '$freewheeling_pagesPreBuiltUrl';
        var freewheeling_pages_icon_html_url = '$freewheeling_pages_icon_html_url';
        var freewheeling_pages_milepost_url = '$freewheeling_pages_milepost_url';
        var freewheelingeasy_images_URL = '$freewheelingeasy_images_URL';
        var freeWheeling_kmlmap  = \"$kmlmap\";
        var freeWheeling_route_weights= \"$route\";
        var freewheeling_bizNameRequest = \"$bizNameRequest\";
        ";
            if ($dino) {
                $legendFile = "legendDino.webp";
                $headerStyleScript .= "var freewheelingeasy_legendFileHeight = '50px';\n";
            } else {
                $legendFile = "legend.svg";
                $headerStyleScript .= "var freewheelingeasy_legendFileHeight = '150px';\n";
            }
            $fullLegendFile = "$freewheelingeasy_images_URL/$legendFile";
            $headerStyleScript .= "var freewheelingeasy_legendFile = '$fullLegendFile';\n";
            $headerStyleScript .= "var freewheelingeasy_legendKeyFile = '$freewheelingeasy_images_URL/legendKey.webp';\n";

            // check boxes that set variables
            // $headerStyleScript .= fetchandVar( "endpoints", "endpoints", "none", "endpoints" );
            // milepost of various flavors
            $mileFiles = ""; //"point file name |point|zoom in| zoom out ,";
            $linesSource = ""; // "linefilename|line"
            $seondSource = ""; // display immediately after the llines
            // always display miles along the trails
            if (rrwParam::Boolean("hidemiles", $attr)) {
                // route-buttons
            } else {
                $mileFiles .= "milepost-10|mile10,";
                $mileFiles .= "milepost-05|mile05,";
                $mileFiles .= "milepost-01|mile01,";
            }
            if (rrwParam::Boolean("traildivide", $attr)) {
                $mileFiles .= "traildevide|amen,";
            }
            if (rrwParam::Boolean("traillabels", $attr)) {
                $seondSource .= "traillable|traillable,"; // first thing is the trail names
            }
            if (rrwParam::Boolean("amenities", $attr)) {
                $mileFiles .= "icons_amen|amen,";
                $showAmities = true; // display the selection header
            } else {
                $showAmities = false;
            }
            // various milepost information
            if (rrwParam::Boolean("allmileposts", $attr)) {
                // $mileFiles .= "launch|launch,milepost_other|launch,milepost_access|launch,";
            }
            /*
            << TODO business locations and line to not implmented
            if (rrwParam::Boolean("businesslocations", $attr)) {
                $mileFiles .= "businesslocations|location,";
            }
                */
            if (rrwParam::Boolean("hideamenities", $attr)) {
                $showAmities = false;
            } else {
                $mileFiles .= "icons_amen|amen,";
                $showAmities = true; // display the selection header
            }
            if (rrwParam::Boolean("hidecamp", $attr)) {
            } else {
                $mileFiles .= "icons_camp|camp,";
            }
            if (rrwParam::Boolean("hideparking", $attr)) {
            } else {
                $mileFiles .= "icons_park|park,";
            }
            $mileFiles = substr($mileFiles, 0, strlen($mileFiles) - 1); // remove trailing comma
            //  --------------------------------------------------------- which specific item
            //        print "mileFiles $mileFiles $eol";
            if ($debugMap) $msg .= "route = $route, trailId =  $trailId $eol";
            // TODO handle group data requests
            // note that if these items are enpty the file will not be created and the search will be blank
            $trailIdLower = strtolower($lineName);
            $trailIdLower = strtolower($bizNameRequest);
            $trailIdLower = strtolower($trailId);
            if (empty($lineId)) {
                $headerStyleScript .= "    var freewheeling_line_search = '';\n";
                $headerStyleScript .= "    var freewheeling_business_search = '';\n";
                $headerStyleScript .= "    var freewheeling_route_search = '$trailIdLower';\n";
            } else {
                // asked for a  linid search
                $headerStyleScript .= "    var freewheeling_line_search = '$lineName';\n";
                $headerStyleScript .= "    var freewheeling_business_search = '';\n";
                $headerStyleScript .= "    var freewheeling_route_search = '';\n";
            }
            //  --------------------------------------------------------- which lines
            $linesSource .= "zz-lines|line,"; // always display the trail lineslines
            if (rrwParam::Boolean("trail2biz", $attr)) {
                $linesSource .= "";     // zz_trail2biz.txt|line,";  file is way to big
            }
            if (!empty($bizNameRequest) || !empty($bizId)) {
                $routesRequestedList = "\"$bizNameRequest\"";
                $linesSource .= "$OneBizFileName|line,"; // just one business
            }
            if (rrwParam::Boolean("counties", $attr)) {
                $linesSource .= "zz-county|line,";
            }
            //  -------------------------------------------------------- which amenities
            if (rrwParam::Boolean("trailmileposts", $attr)) {
                $routesRequestedList = "'mileposts', $routesRequestedList";
            }
            if ($dino)
                $headerStyleScript .= "
                var FreeWheelingEasy_linesSource  = 'dinomites|dino';
                ";
            else
                $headerStyleScript .= "
                var FreeWheelingEasy_linesSource  = '$seondSource$linesSource$mileFiles';
                ";
            if (rrwParam::Boolean("highlightGaps", $attr)) {
                $headerStyleScript .= "\n var	FreewheelingEasy_GapWeight =10\n";
            } else {
                $headerStyleScript .= "\n var	FreewheelingEasy_GapWeight =3\n";
            }
            /*
            if (freeWheeling_edit_setGlobals::AllowedToEdit("movePoints", "")) {
                $headerStyleScript .= "
                function freewheelingHandleDragEnd(a) {
                        var latitude = a.latLng.lat().toFixed(7);
                        var longitude = a.latLng.lng().toFixed(7);
                        var dinoFileName = a.dinoFileName
                        var url = 'https://edit.shaw-weil/com/update-database'
                            + '?table=pillowan_wp451.wpprrj_00rrwdinos'
                            + '&keyField=filename&keyValue=' + dinoFileName
                            + '&field=latitue&newValue=' + latitude
                        + 'https://edit.shaw-weil/com/update-database'
                    + '?table=pillowan_wp451.wpprrj_00rrwdinos'
                    + '&keyField=filename&keyValue=' + this.trailid
                            + ' & field = longitude & newValue = ' + longitude;
                        alert(url);
                    }";
            } else {
                $headerStyleScript .= "";
            }
*/
            $centerLat = ($north + $south) / 2;
            $centerLong = ($east + $west) / 2;


            $headerStyleScript .= "

function displayTheMap() {
    _freewheelingmap_ResizeMapCanvas2Page ('mapCanvas', 100, 80, $north, $south, $east, $west);
    window.addEventListener('load', _freewheelingmap_Initialize('mapCanvas', true, \"$titleLine\") );
    var mapcanvasObject = document.getElementById('mapCanvas');
    mapcanvasObject,moveTo(0,0);
    titleSpace = document.getElementsByClassName('entry-title');
    titleSpace[0].innerHTML = '$titleLine';
    var title = titleSpace[0].innerHTML;
    var look = title.indexOf('Point State Park');
    if (look == 0) {
        // Add the circle for this fountain to the map.
        var myLatlng = new google.maps.LatLng( $centerLat,$centerLong); // + milepostLngShift);
        $circleScript
        $spokeScript
            console.log('circle added');
        }
   }
        console.log('about to display the map');
    displayTheMap();
    </script>";
            //     fillColor: '#FF0000',
            //      fillOpacity: 0.75,
            // ======================================================================
            $html .= "
<table width='100%'><tr>
<td>&nbsp;</td>
<td style='font-size:24pt; font-weight:bold'>
	$titleLine</td><td style='font-size:10pt; test-align:right'>
	This map brought to you by the book
	<a href='https://freewheelingeasy.com' class='freewheeling-amenities-external' >
	Freewheeling Easy in Western Pennsylvania</a> .
</td></tr>
</table>
";
            if (!empty($showInstructions)) {
                $html .= "<strong>instructions:</strong> Use this map to verify trail alignment and condition.
					<ul><li>Scroll over a trail segment to see its name. </li>
					<li><a href='#linework'>below the map </a> is a table of lines with distance</li>
					<li>Clickng a line name will open a map in a new window with just that line displayed</li>
					<li>Spelling of names is sloppy click the pencil icon to edit</li>
					</ul>
		";
            }

            if (!empty($trailId && !empty($showInstructions))) {
                $file = "$trailId-routeDetail.html";        // add detail to the output page
                $html .= "<span id='linework'>$eol</span>";
                $html .=  freewheeling_WriteUp::getFileContents("miles-by-type", $file);
                // append the data for any spur tails
                $sqlSpur = "select trId from $wpdbExtra->trails where spurof  = '$trailId'";
                try {
                    $trId = $wpdbExtra->get_resultsA($sqlSpur);
                    foreach ($trId as $tr) {
                        $trIdSpur = $tr["trId"];
                        $file = "$trIdSpur-routeDetail.html";        // add detail to the output page
                        $html .=  freewheeling_WriteUp::getFileContents("miles-by-type", $file);
                    }
                } catch (Exception $ex) {
                    // on failure of sql Query assume there are no spurs. I.e. not called from edit
                }
            } // end if show instructions
            //            $msg .= freewheel_encapsulateWithCopyright($headerStyleScript . $html);
            $msg .= $headerStyleScript . $html;
        } catch (Exception $ex) {
            $msg .=  $ex->getMessage() . "at the bottom of display map, look elsewher or error";
        } // end catch
        return "<!-- before msg --> " . $msg .
            "<!-- after html --> "; //  this goes to the screen
    } // end function displaymap
    private static function setRange($sqlRequest, &$north, &$south, &$east, &$west, &$titleLine, $incrementDegree = 0.001)
    {
        // $sqlRequest sets a point latitude, longitude around which to plot
        // setRange returns the range(north, south,east,west) of the map to be displayed
        // and the titleLine is extracted from the record
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        $msg = "";
        $recs = $wpdbExtra->get_resultsA($sqlRequest);
        if (1 != count($recs)) {
            $msg .= "$errorBeg E#2203 there are " . count($recs) . " records for $sqlRequest $errorEnd";
            $msg .= rrwFormat::backtrace("in setRange: ");
            throw new Exception($msg);
        }
        $rec = $recs[0];
        $north = $rec["latitude"] + $incrementDegree;
        $south = $rec["latitude"] - $incrementDegree;
        $east = $rec["longitude"] + $incrementDegree;
        $west = $rec["longitude"] - $incrementDegree;;
        if (array_key_exists("titleLine", $rec))
            $titleLine = htmlspecialchars($rec["titleLine"], ENT_QUOTES);
        else
            $titleLine = " ";
        return $msg;
    }
} // emd class FreeWheeling_DisplayMap
add_shortcode('freewheeling-easy-map', array('FreeWheeling_DisplayMap', 'displayMap'));
//add_shortcode('freewheelingeasymap', 'displaymapbizna,e');
// add_shortcode( 'freewheeling-easy-map-trailhead', 'displayTrailHeads' );
add_shortcode('freewheeling-easy-map-OLC-explain', 'displayOlcExplanations');
add_shortcode('freewheeling-easy-map-write-up', array('freewheeling_WriteUp', 'freewheelingWriteUpDisplay'));
add_shortcode('freewheeling-easy-map-segments', array("freewheeling_Segments", "freewheelingDisplaySegments"));
add_shortcode('freewheeling-easy-map-segments-e2p', array("freewheeling_Segments", "freewheelingSegmentE2Preport"));
add_shortcode('freewheeling-easy-map-test-api', array("freewheelAPI_2025", "testGetMapApi"));
add_shortcode('freewheeling-easy-map-buildpages', array("freewheelingEasy_buildpages", "buildpages"));
// -------------------------------------  cause it to happen
register_activation_hook(__FILE__, array('freewheelingEasy_buildpages', 'buildpages'));
require_once "plugin_update_check.php";
$MyUpdateChecker = new PluginUpdateChecker_2_0(
    'https://pluginserver.royweil.com/freewheeling-map.php',
    __FILE__,
    'freewheeling-map',
    1
);
