<?php
require_once "rrw_google-api-credentials.php";
class freewheelAPI_2025
{
    static private $typesCnt; // holds the counts for each type of API key
    static private $max4Free; // maximum number of free requests allowed
    static private $apiCredentials;
    static public $debugDynamic = false;
    const CURRENT = "currentApi";

    static public function testGetMapApi($attributes)
    {
        global $eol, $errorBeg, $errorEnd;
        global $wpdbExtra;
        try {

            // Test the Google Maps API
            $msg = "";
            if (self::$debugDynamic) {
                $sqlDynamic = "select billApiKey, billCount from $wpdbExtra->googleBilling
                        where billType = 'dynamic' and billYearMonth = '" . date("Y-m") . "' order by billCount";
                $rebill = $wpdbExtra->get_resultsA($sqlDynamic);
                $msg .= rrwUtil::print_r($rebill, true, "I#2013 current dynamic billing $eol");
                $msg .= "E#2000 testing new nearby $eol";
                $msg .= freewheeling_Google_Costs::googleCostPage(array());
            }
            $iconName = "First Avenue Garage";
            $sqlLocation = "select latitude, longitude from $wpdbExtra->icons where iconName = '$iconName';";
            $rec = $wpdbExtra->get_resultsA($sqlLocation);
            if (0 == $wpdbExtra->num_rows) {
                $msg .= "$errorBeg E#2001 failed to find location $errorEnd $eol";
                return $msg;
            }
            $latitude = $rec[0]["latitude"];
            $longitude = $rec[0]["longitude"];

            $msg .= freeWheelingGoogleUpdate::UpdateBusinessByLatLng($latitude, $longitude, 2, "restaurant", $iconName);
            $msg .= freewheeling_Google_Costs::googleCostPage(array());
            if (self::$debugDynamic) {
                $sqlDynamic = "select billApiKey, billCount from $wpdbExtra->googleBilling
                        where billType = 'dynamic' and billYearMonth = '" . date("Y-m") . "' order by billCount";
                $rebill = $wpdbExtra->get_resultsA($sqlDynamic);
                $msg .= rrwUtil::print_r($rebill, true, "I#2014 current dynamic billing $eol");
            }
        } catch (Exception $e) {
            $msg .= "$errorBeg " . $e->getMessage() . "$eol E#2002 testGetMapApi failed see above $errorEnd $eol";
        }
        return $msg;
    } // end testGetMapApi

    static public function appendApiKeyToUrl(&$url)
    {
        return self::appendApiKeyToUrlWithDate($url, date("Y-m"));
    }
    /**
     * Appends the appropriate Google Maps API key to the provided URL based on usage limits and billing records.
     *
     * @param string &$url        The URL to which the API key will be appended.
     * @param string $dateFormat  Optional for debugging. The year and month in 'YYYY-MM' format for billing records.
     * @return string             Debug or status messages generated during the process.
     * @throws Exception          If unable to find or update the API key or billing information.
     */
    static public function appendApiKeyToUrlWithDate(&$url, $dateFormat = "")
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        try {
            $debugAppendApiKey = rrwParam::isDebugMode("debugKeyAssign");
            if (empty($dateFormat))
                $dateFormat = date("Y-m");
            if (! isset(self::$apiCredentials)) {
                self::$apiCredentials = new freewheelingeasyGoogleAPIcredentials();
                // $msg .= "E#1950 created new freewheelingeasyGoogleAPIcredentials $eol";
            }
            if (! isset(self::$typesCnt)) {
                $msg .= self::setTypesCnt($dateFormat);
                // will return empty typeCnt for non edit-shaw sites
                // $msg .= rrwUtil::print_r(self::$typesCnt["textsearch"], true, "E#20238 the current initialized counts");
            }
            $thisType = self::getCostType($url);
            if ($debugAppendApiKey) {
                $msg .= "E#20231 debugAppendApiKey for type $thisType $eol";
                //  $msg .= rrwUtil::print_r(self::$typesCnt[$thisType], true, "E#1955 the current counts");

            }
            if ("mapping" == $thisType) {
                $currentApi = self::$apiCredentials->getGoogleAPIkey("maps-rrw");
                $url .= "&key=$currentApi"; // force to the mapping key.
                $msg .= self::updateGoogleBilling($currentApi, "mapping", $dateFormat);
                if (false) $msg .= "final URL is $url  $eol";
                return $msg;
            }
            if (count(self::$typesCnt) < 1) {
                $msgErr = "$errorBeg E#2027 no keys found in the system, cannot proceed $errorEnd $eol";
                throw new Exception("$msg $msgErr");
            }
            if (empty(self::$typesCnt[$thisType][self::CURRENT])) {
                // we have not seen this type before
                $msg .= self::findNewCurrentType($thisType, $dateFormat);
            }
            $currentApi = self::$typesCnt[$thisType][self::CURRENT];
            $currentCount = self::$typesCnt[$thisType][$currentApi];
            $currentLimit = self::$max4Free[$thisType];
            if ($debugAppendApiKey) $msg .= "E#2028 current API = $currentApi, current count = $currentCount, limit = $currentLimit $eol";
            if ($currentCount < $currentLimit) {
                // we have not reached the limit for this API key
                // increment the count
                self::$typesCnt[$thisType][$currentApi]++;
                if (self::$debugDynamic) {
                    $msg .= "E#2007 bump count for $thisType, apiKey $currentApi to " . self::$typesCnt[$thisType][$currentApi] . " $eol";
                    $msg .= "E#2008 bump count for dynamic, apiKey $currentApi to " . self::$typesCnt["dynamic"][$currentApi] . " $eol";
                }
                $msg .= self::updateGoogleBilling($currentApi, $thisType, $dateFormat);
                $url = "$url&key=$currentApi";
                if ($debugAppendApiKey) $msg .= " I#20232 returning url $url $eol";
                return $msg;
            }
            if ($currentCount >= self::$max4Free[$thisType]) {
                // we are at the limit, time to find a new one
                $msg .= self::findNewCurrentType($thisType, $dateFormat);
                self::$typesCnt[$thisType][$currentApi]++;
                if (self::$debugDynamic) {
                    $msg .= "E#2009 bump count for $thisType, apiKey $currentApi to " . self::$typesCnt[$thisType][$currentApi] . " $eol";
                    $msg .= "E#2010 bump count for dynamic, apiKey $currentApi to " . self::$typesCnt["dynamic"][$currentApi] . " $eol";
                }

                $msg .= self::updateGoogleBilling($currentApi, $thisType, $dateFormat);
                $url = "$url&key=$currentApi";
            }
            if ($debugAppendApiKey) $msg .= " I#20236 returning url $url $eol";
            return $msg;
        } catch (Exception $e) {
            $msg .= "$errorBeg " . $e->getMessage() . "$eol E#20239 debugAppendApiKey failed see above $errorEnd $eol";
            throw new Exception($msg);
        }
    } // end function appendApiKeyToUrlWithDate

    private static function findNewCurrentType(&$thisType, $dateFormat)
    {
        global $eol, $wpdbExtra;
        $msg = "";
        $debugFindNewCurrentType = rrwParam::isDebugMode("debugFindNewCurrentType");
        if ($debugFindNewCurrentType) $msg .= "E#1956 findNewCurrentType for type $thisType $eol";
        // find the first api key that has not reached the limit
        foreach (self::$typesCnt[$thisType] as $apiKey => $cnt) {
            if ($cnt < self::$max4Free[$thisType] && 0 != $cnt) {
                // we have found a key that has not reached the limit and is not 0
                if ($debugFindNewCurrentType) $msg .= "E#1957 found current API key $apiKey for type $thisType $eol";
                self::$typesCnt[$thisType][self::CURRENT] = $apiKey;
                if ($debugFindNewCurrentType) $msg .= "E#1953 using existing API key $apiKey for type $thisType, count = $cnt $eol";
                return $msg;
            }
        } // end foreach looking for an API key with existing counts less than the limit and not zero
        if ($debugFindNewCurrentType) $msg .= "E#1958 no API key found for type $thisType, all keys have reached the limit or are zero $eol";
        foreach (self::$typesCnt[$thisType] as $apiKey => $cnt) {
            // none found, lets look for a zero count
            if (0 == $cnt) {
                $sqlInsert = "insert into $wpdbExtra->googleBilling
                        (billApiKey, billType, billYearMonth, billCount) values ('$apiKey', '$thisType', '$dateFormat', 0)";
                // this is the first time we are using this key
                $insertCnt = $wpdbExtra->query($sqlInsert);
                if (1 != $insertCnt) {
                    $msg .= "E#1952 failed to insert new API key $apiKey for type $thisType, date $dateFormat, count = $cnt $eol";
                    throw new Exception($msg);
                }
                self::$typesCnt[$thisType][self::CURRENT] = $apiKey;
                if ($debugFindNewCurrentType) $msg .= "E#20235 using existing API key $apiKey for type $thisType, count = $cnt $eol";
                return $msg;
            } // end if found zero count
            // not yet found, keep looking
        } // end foreach looking for an API key with zero counts
        throw new Exception("E#20237 no API key found for type $thisType, all keys have reached the limit $eol");
    }
    /**
     * Updates the Google billing table with the current API key, type, and date format.
     *
     * @param string $apiKey      The Google API key to be recorded.
     * @param string $googleType  The type of Google API request (e.g., 'textsearch', 'nearby').
     * @param string $dateFormat  The year and month in 'YYYY-MM' format for billing records.
     * @return string             Debug or status messages generated during the update.
     */
    private static function updateGoogleBilling($apiKey, $googleType, $dateFormat)
    {
        global $eol, $errorBeg, $errorEnd, $wpdbExtra;
        $msg = "";
        $siteURL = site_url();
        if ("mapping" == $googleType && strpos($siteURL, "edit.shaw") === false)
            return $msg; // no need to track mapping requests
        // updates the google billing table with the current api key and type
        $debugUpdateGoogleBilling = false; // rrwParam::isDebugMode("debugUpdateGoogleBilling");
        if (self::$debugDynamic) $msg .=  "E#2011 updateGoogleBilling for apiKey $apiKey, type $googleType, dateFormat $dateFormat $eol";
        $sqlInsert = "sqlInsert not set yet";        // initialize in case of error message there is something there
        // first try to update an existing record
        $sqlUpdateCount = "update $wpdbExtra->googleBilling set billCount = billCount +1
                    where  billApiKey= '$apiKey' and billType = '$googleType' and billYearMonth = '$dateFormat' ";
        $updateCnt = $wpdbExtra->query($sqlUpdateCount);
        if ($debugUpdateGoogleBilling) $msg .= "E#2016 updateGoogleBilling updated $updateCnt rows with $sqlUpdateCount $eol";
        if (0 == $updateCnt) {
            // no record found, we need to insert a new one
            if ($debugUpdateGoogleBilling) $msg .= "E#1960 no record found for apiKey $apiKey, type $googleType, dateFormat $dateFormat $eol";
            $sqlInsert = "insert into $wpdbExtra->googleBilling
                        (billApiKey, billType, billYearMonth, billCount) values ('$apiKey', '$googleType', '$dateFormat', 1)";
            $insertCnt = $wpdbExtra->query($sqlInsert);
            if (1 != $insertCnt) {
                $msgErr = "$errorBeg E#2012 insert cnt failed to create new record in $errorEnd $sqlInsert";
                throw new Exception("$msg $msgErr");
            }
        }
        if (1 != $updateCnt) {
            $msg .= "E#2021 Cnt = updateCnt failed to update Google billing for apiKey $apiKey, type $googleType,
                            dateFormat $dateFormat $eol $sqlUpdateCount $eol$sqlInsert $eol";
            throw new Exception($msg);
        }

        return $msg;
    } // end function updateGoogleBilling

    private static function getMapApiFromBillCode($billCode)
    {
        $apiCredentials = new freewheelingeasyGoogleAPIcredentials();
        $key = $apiCredentials->getGoogleAPIkey($billCode); // get a key based on site
        return $key;
    } // end function getMapApiFromBillCode

    static private function siteUrlToApiDomain()
    {
        global $eol;
        $siteUrlToApiDomain = rrwParam::isDebugMode("debugKeyAssign");
        // returns the api domain name given a site url
        $siteUrl = site_url();
        if ($siteUrlToApiDomain) print "input url $siteUrl. $eol";
        $parsedUrl = parse_url($siteUrl);
        $host = isset($parsedUrl['host']) ? $parsedUrl['host'] : $siteUrl;
        if ($siteUrlToApiDomain) print "no scheme, host only: $host.$eol";
        $iiDot = strpos($host, "."); // first period
        $iiDotSecond = strpos($host, ".", $iiDot + 1); // second period
        if ($iiDotSecond === false)
            $apiDomain = $host;     // only one name in the host
        else
            $apiDomain = substr($host, 0, $iiDotSecond);    // two or more names in the host, use only 2
        // site is now only the first one of two section  of the host name

        if ($siteUrlToApiDomain) print "first two domains $apiDomain $eol";
        $apiDomain = strtolower($apiDomain);
        if ($siteUrlToApiDomain) print "final - '$apiDomain' $eol";
        return $apiDomain;
    } // end function siteUrlToApiDomain

    static public function getGoogleBillingName($apiKey)
    {
        // returns the google billing name given an apiKey
        $apiCredentials = new freewheelingeasyGoogleAPIcredentials();
        return $apiCredentials->getGoogleBillingName($apiKey);
    } // end function getBillingName

    private static function getCostType($url)
    {
        global $eol, $errorBeg, $errorEnd;
        // extract the type of request from the URL
        $debugGetCostType = rrwParam::isDebugMode("debugGetCostType");
        if ($debugGetCostType) print "E#956 getCostType from $url";
        if (false !== strpos($url, "rating"))
            $item = "rating";           // rating  must be first to supersede nearby,place
        elseif (false !== strpos($url, "searchNearby"))
            $item = "nearby";
        elseif (false !== strpos($url, "v1/places/"))
            $item = "nearby";
        elseif (false !== strpos($url, "textsearch"))
            $item = "textsearch";
        elseif (false !== strpos($url, "direction"))
            $item = "direction";
        elseif (false !== strpos($url, "maps/api/js")) {
            $item = "mapping";
            //print "E#2003 found maps/api/js in $url, setting item to dynamic $eol";
        } elseif (false !== strpos($url, "dynamic")) {
            $item = "dynamic";
            print "E#2004 found dynamic in $url, setting item to dynamic $eol";
        } else {
            $item = "unknown";
            $msg = "$errorBeg E#957 unknown cost type in $errorEnd $url $eol";
            throw new Exception($msg);
        }
        if (self::$debugDynamic) {
            print "E#2005  $item   --- $url $eol";
            print rrwUtil::print_r(self::$typesCnt["dynamic"], true, "E#2006 the current counts for dynamic");
        }
        return $item;
    } // end function getCostType

    /**
     * Initializes and updates the count of API usage per type and API key for a given billing year and month.
     *
     * This method performs the following tasks:
     * - Retrieves the list of API keys and billing types from the database.
     * - Initializes the usage count (`self::$typesCnt`) for each API key and billing type to zero.
     * - Sets the free usage limit (`self::$max4Free`) for each billing type, applying a buffer to the limit.
     * - Updates the usage count for each API key and billing type based on existing billing records for the specified month.
     *
     * @param string $billYearMonth The billing year and month in 'YYYYMM' format.
     */
    private static function setTypesCnt($billYearMonth): string
    {
        global $eol;
        global $wpdbExtra;
        $debugSetTypeCnt = rrwParam::isDebugMode("debugSetTypeCnt");
        $msg = "";
        if ($debugSetTypeCnt) $msg .= "E#2020 setTypesCnt  $eol";
        $ApiKeysList = self::$apiCredentials->getEditKeys();
        if ($debugSetTypeCnt) $msg .= rrwUtil::print_r($ApiKeysList, true, "E#2022 setTypesCnt: ApiKeysList");
        self::$typesCnt = array();
        self::$max4Free = array();
        $site = site_url();
        if (strpos($site, "edit.shaw") === false) {
            if ($debugSetTypeCnt) $msg .= "E#2023 site is $site, not tracking requests $eol";
            return $msg;
        }
        $sqlTypes = "select googleType, FreeLimit from $wpdbExtra->google_billing_rates order by googleType";
        $recTypes = $wpdbExtra->get_resultsA($sqlTypes);
        foreach ($recTypes as $recType) {
            $type = $recType["googleType"];
            self::$typesCnt[$type][self::CURRENT] = "";
            self::$typesCnt[$type] = array();
            self::$max4Free[$type] = $recType["FreeLimit"];
            if (self::$max4Free[$type] > 2000) self::$max4Free[$type] -= 100;
            elseif (self::$max4Free[$type] > 1000) self::$max4Free[$type] -= 50;
            elseif (self::$max4Free[$type] > 0) self::$max4Free[$type] -= 20;    // give a little bit of buffer to the limit.
            foreach ($ApiKeysList as $key) {
                self::$typesCnt[$type][$key] = 0; // initialize the count for each API key
            }
        } // end foreach recTypes initialization
        $sqlExist = "select billApiKey, BillYearMonth, BillCount, billType from $wpdbExtra->googleBilling
                Where billYearMonth = '$billYearMonth'";
        $recExists = $wpdbExtra->get_resultsA($sqlExist);
        if ($debugSetTypeCnt) $msg .= "E#1954 found " . $wpdbExtra->num_rows . " rows to update with $sqlExist $eol";

        foreach ($recExists as $recExisting) {
            $apiKey = $recExisting["billApiKey"];
            $billCount = $recExisting["BillCount"];
            $billType = $recExisting["billType"];
            self::$typesCnt[$billType][$apiKey] = $billCount;
            if ($debugSetTypeCnt) $msg .= "E#2024 updating self::typesCnt[$billType][$apiKey] = $billCount;$eol";
        }
        if (self::$debugDynamic) {
            $currentApi = "AIza" . "SyBoTy5leTIDnU37bkKqjHsTTMv-_woyHvI";
            $msg .= "E#20102 bump count just after fill for dynamic, apiKey $currentApi to " . self::$typesCnt["dynamic"][$currentApi] . " $eol";
        }
        return $msg;
    }   // end function setTypesCnt
} // end class freewheelAPI_2025
