<?php
/*		Freewheeling Easy Mapping Application
 *
 *		A collection of routines for display of trail maps and amenities
 *
 *		copyright Roy R Weil 2019 - https://royweil.com
 *
 */
class freewheeling_Segments
{
    static public
    function freewheelingDisplaySegments($attributes)
    {
        global $eol, $errorBeg, $errorEnd;
        try {
            error_reporting(E_ALL);
            $msg = "";
            $route = rrwParam::String("route", $attributes);
            if (empty($route))
                $route = "dobbs_freeport";
            $title = rrwParam::String("title", $attributes, "Trail Status - by Segments");
            $start = rrwParam::String("start", $attributes, "");
            $lastOne = rrwParam::String("last", $attributes, "");
            if (empty($lastOne))
                $lastOne = rrwParam::String("end", $attributes, "");
            $displayKey = rrwParam::Boolean("displayKey", $attributes, true);
            //( $title );
            $msg .= freewheeling_Segments::printSegReportFromJson($route, $title, $start, $lastOne, $displayKey);
            return $msg;
        } catch (Exception $e) {
            $msg .= "E#2315 " . $e->getMessage() . $eol;
            return $msg;
        }
    }
    static public
    function printSegReportFromJson($routeRequested, $title, $start, $lastOne, $displayKey)
    {
        global $eol, $errorBeg, $errorEnd;
        global $freewheelingeasy_images_URL;
        global $freewheelingeasy_stylesheet;
        global $rrw_segments, $wpdbExtra;
        $debugReport = rrwParam::Boolean("debugReport");
        $debugJsonOpen = false;
        $debugLegs = false;
        $msg = "";
        if ($debugReport) $msg .= "printSegReportFromJson( $routeRequested, $title, $start, $lastOne, $displayKey ) ";
        $report = "";
        $report .= freeWheeling_edit_setGlobals::setGlobals("printSegReportFromJson");
        $report .= $freewheelingeasy_stylesheet;
        if ($debugReport) $msg .= "into from processing printReport($routeRequested) $eol";
        $start = str_replace("+", " ", $start);
        $start = str_replace("%20", " ", $start);
        $start = str_replace('"', "", $start);
        $lastOne = str_replace("+", " ", $lastOne);
        $lastOne = str_replace("%20", " ", $lastOne);
        $filename = "$routeRequested.json";
        if ($debugLegs) $msg .= "Opening the legs file $filename $eol";
        $legsText = freewheeling_WriteUp::getFileContents("status-json", "$filename");
        if (false === $legsText) {
            $msg .= "$errorBeg E#2378 Could not open the legs file /$filename $errorEnd";
            return $msg;
        }
        $legs = json_decode($legsText, true);
        if ($debugLegs) $msg .= "Found " . count($legs) . " entries in the comment table $eol";
        if (false) $msg .= rrwUtil::print_r($legs, true, "the read legs file");

        $color = rrwUtil::colorSwap();
        if (empty($start))
            $notYetAtStart = false;
        else
            $notYetAtStart = true;
        if (!is_array($legs)) {
            $report .= "<h2>Trail status for $routeRequested</h2>\n";
            $report .= "$errorBeg E#2319 The legs file /$filename is not valid json $errorEnd";
            return $report;
        }
        if (count($legs) == 0) {
            $report .= "<h2>Trail status for $routeRequested</h2>\n";
            $report .= "$errorBeg There are no segments defined for this trail $errorEnd";
            return $report;
        }
        $trname = $legs[0]["trname"];
        unset($legs[0]);
        if (false) $msg .= rrwUtil::print_r($legs, true, "the read legs fle");
        if (empty($title)) {
            $title = "Trail status for $trname";
            if (!empty($start))
                $title .= " I#2331 starting at $start ";
            if (!empty($start) && !empty($lastOne))
                $title .= " and ";
            if (!empty($lastOne))
                $title .= " ending at $lastOne ";
        } else {
            //  use the existing title
        }
        $report .= "<h2>$title</h2>\n";
        $report .= "$eol Surface Key: <span class='colorMilesgreen'> xx miles on limestone or asphalt </span> &nbsp;
						<span class='colorMilesYellow'> xx miles on shared road </span>&nbsp;
						<span class='colorMilesBrown'> xx miles on unimproved ballast/dirt </span>&nbsp;
						<span class='colorMilesRed'> xx miles on on closed trail</span> &nbsp; Surface Key$eol";
        $segCnt = 0;
        foreach ($legs as $recSeg) {
            $segCnt++;
            //           if ( $segCnt == 1 )$msg .= rrwUtil::print_r( $recSeg, true, "the read recSeg fle" );
            $startIcon = $recSeg["startIcon"];
            if ($notYetAtStart) {
                if ($debugReport) $msg .= "skipping compare strcmp( $startIcon, $start ) $eol";
                if (strcmp($start, $startIcon) != 0)
                    continue;
            }
            $notYetAtStart = false;
            if (!empty($lastOne) && strcmp($lastOne, $startIcon) == 0) {
                break;
            }
            $seg_commentid = $recSeg["segmentid"];
            $edit_href = "<a href='https://edit.shaw-weil.com/edit-segment/" .
                "?segmentid=$seg_commentid&amp;route=$routeRequested&action=edit' target='editWindow'> ";
            $endicon = $recSeg["endicon"];
            $public = $recSeg["descpublic"];
            $publicSource = $recSeg["publicSource"];
            $internal = $recSeg["descinternal"];
            $title = $recSeg["title"];
            if (array_key_exists("startmiles", $recSeg)) {
                $startmiles = $recSeg["startmiles"];
                $endmiles = $recSeg["endmiles"];
            } else {
                $startmiles = 0;
                $endmiles = 0;
                $msg .= "$errorBeg E#2314 Milage does not exist for segment #$seg_commentid, $startIcon to $endicon $errorEnd";
            }
            if (is_null($seg_commentid))
                continue;
            if (!empty($publicSource))
                $public .= "<span style='color:gray'> - Source: $publicSource</span>";
            $topLine = freewheelFormat::Milepost($startmiles) . " mi to " . freewheelFormat::Milepost($endmiles) . " mi";
            $mileSegment = $endmiles - $startmiles;
            // build the Contents message
            $edit_href = "<a href='https://edit.shaw-weil.com/edit-segment/";
            $edit_href .= "?segmentid=$seg_commentid&amp;route=$routeRequested&action=edit' target='editWindow'> ";
            if (!empty($internal)) {
                $internal .= "$edit_href Read More...</a>";
                $internal .= freeWheel::editViewStart .
                    "<br />\n --------------- VVVVVVVVVV -- confidential information -- VVVVVVVVVVVVVVVV --------------<br />$internal " .
                    freeWheel::editViewEnd;
            }
            $contents = "$public";
            // if ( current_user_can( "edit_posts" ) ) $contents .= $internal ;
            if (strpos($contents, "colorMile") === false) {
                // miles class not specifed in the contents. calculate and preappend.
                if (strpos(substr($contents, 0, 10), "mile ") === false) {
                    if (
                        strpos($public, "proposed ") !== false ||
                        strpos($public, "closed") !== false
                    ) {
                        $MileClass = "class = 'colorMilesRed' ";
                    } elseif (
                        strpos($public, "off road") !== false ||
                        strpos($public, "off - road") !== false ||
                        strpos($public, "off-road") !== false
                    ) {
                        $MileClass = "class='colorMilesgreen'";
                    } elseif (
                        strpos($public, "on road") !== false ||
                        strpos($public, "existing road") !== false ||
                        strpos($public, "on - road") !== false ||
                        strpos($public, "on-road") !== false ||
                        strpos($public, "Park Rd") !== false ||
                        strpos($public, "wide street") !== false ||
                        strpos($public, "wide ballast") !== false ||
                        strpos($public, "on wide road") !== false
                    ) {
                        $MileClass = "class='colorMilesYellow'";
                    } elseif (
                        strpos($public, "ballast") !== false ||
                        strpos($public, "existing dirt") !== false ||
                        strpos($public, "packed dirt") !== false
                    ) {
                        $MileClass = "class='colorMilesBrown'";
                    } else {
                        $MileClass = "class = 'colorMilesRed'";
                    }
                    $miles = "<span $MileClass>\n" . round($mileSegment, 1) . " miles";
                    if ($mileSegment > 5) {
                        for ($ii = 5; $ii < $mileSegment; $ii++) $miles .= "&nbsp; "; // lengthen the green line
                    }
                    $contents = "$miles</span> on $contents";
                } else { // "mile" in first 10 characters
                    $contents = "$contents";
                } // now display the result
            } else {
                // contents contains colorMailes. do not insert milage
            } // end if ( strpos( $contents, "class=colorMiles" )===false ) $color=rrwUtil::colorSwap( $color );
            $report .= "<div style='background-color:$color;' >
                    <h3>$edit_href<img src='" . rrwUtil::penIconIMG() . "' alt='Edit' /></a>" .
                "$topLine</h3><br />$contents </div>\n\n ";
        } // end   foreach ( $legs as $recSeg )
        // at the bottom
        if (true) {
            $report .= "
<script>
docTitle = document.getElementsByClassName('entry-title');
console.log (docTitle);
console.log (docTitle).item(0).innerHTML ;
docTitle.innerHTML = '$title';
</script>
<br />
<hr>
<p><span class='colorMilesgreen'>mileage in green</span> is is designated
    Erie to Pittsburgh Trail that is on separated off road path $eol
    <span class='colorMilesYellow'>mileage in yellow </span> is designated Erie to Pittsburgh Trail
    that is on road $eol
    <span class='colorMilesBrown'>mileage in tan </span> is unfinished service (dirt or packed ballast)
    that is on road $eol
    <span class='colorMilesRed'>mileage in red </span> is for section where there is no designated
    Erie to Pittsburgh Trail or trail is closed. $eol
    The length of the color is an indication of the length of the section. </p>$eol ";
            $site = get_site_url();
            if (strpos($site, "
                            edit.shaw-weil.com ") !== false) {
                $sqlMax = "
                            select max( segmentId ) + 1 from $rrw_segments ";
                $maxSeg = $wpdbExtra->get_var($sqlMax);
                $report .= " <a href='https://edit.shaw-weil.com/edit-segment/?" .
                    "segmentId=$maxSeg&amp;action=new&amp;route=$routeRequested'
                            target = 'edit' > Create a New Entry < /a> $eol";
            }
            //          $report .= "Thank You for reading this report";
        }
        if (!empty($msg)) $msg .= $eol;
        return "$msg $report";
    }
    static private
    function outputScriptsAndStyle($title = "")
    {
        global $eol, $errorBeg, $errorEnd;
        global $freewheelingeasy_stylesheet;
        $msg = "";
        return $msg;
    }
} // end class
